import { SxProps } from "@mui/material";
import { styled, StyleFunction, unstable_styleFunctionSx } from "@mui/system";

import { Key } from "../generated/ubo/v1/ubo_pb";

interface SvgProps {
  sx?: SxProps;
}

const Svg = styled("svg")<SvgProps>(
  unstable_styleFunctionSx as StyleFunction<SvgProps>,
);

const LayoutIcon = styled("path")`
  fill: ${({ theme }) => theme.palette.background.paper};
  pointer-events: none;
`;

const LayoutButton = styled("path")`
  fill: ${({ theme }) => theme.palette.text.disabled};
  cursor: pointer;

  &:active {
    fill: ${({ theme }) => theme.palette.action.disabled};
  }
`;

interface LayoutProps {
  sx?: SxProps;
  onKeyDown: (button: Key) => void;
  onKeyUp: (button: Key) => void;
}

export function Layout({ sx, onKeyDown, onKeyUp }: LayoutProps) {
  function handleMouseDown(key: Key) {
    return ({ target: originalTarget }: React.MouseEvent) => {
      const mouseUpHandler = ({ target }: MouseEvent) => {
        if (target === originalTarget) {
          onKeyDown(key);
          onKeyUp(key);
        }
        window.removeEventListener("mouseup", mouseUpHandler);
      };
      window.addEventListener("mouseup", mouseUpHandler);
    };
  }
  return (
    <Svg
      viewBox="0 0 96.043732 76.464592"
      version="1.1"
      xmlns="http://www.w3.org/2000/svg"
      sx={sx}
    >
      <g transform="translate(-56.885418,-110.86042)" strokeWidth="0.264583">
        <LayoutButton
          id="L1"
          fillRule="evenodd"
          clipRule="evenodd"
          d="m 56.885418,123.6927 c 0,-2.41106 1.954556,-4.36562 4.365625,-4.36562 h 7.441406 c 0.338138,0 0.507233,0 0.647303,0.0307 0.504243,0.11063 0.898049,0.50443 1.008671,1.00868 0.03075,0.14007 0.03075,0.30916 0.03075,0.6473 v 5.35781 c 0,0.33814 0,0.50723 -0.03075,0.6473 -0.110622,0.50425 -0.504428,0.89805 -1.008671,1.00868 -0.14007,0.0307 -0.309165,0.0307 -0.647303,0.0307 h -7.441406 c -2.411069,0 -4.365625,-1.95456 -4.365625,-4.36563 z"
          onMouseDown={handleMouseDown(Key.KEY_L1)}
        />
        <LayoutButton
          id="L2"
          fillRule="evenodd"
          clipRule="evenodd"
          d="m 56.885418,138.77396 c 0,-2.41107 1.954556,-4.36562 4.365625,-4.36562 h 7.441406 c 0.338138,0 0.507233,0 0.647303,0.0307 0.504243,0.11062 0.898049,0.50443 1.008671,1.00867 0.03075,0.14007 0.03075,0.30917 0.03075,0.64731 v 5.35781 c 0,0.33813 0,0.5072 -0.03075,0.64743 -0.110622,0.50403 -0.504428,0.898 -1.008671,1.00859 -0.14007,0.0307 -0.309165,0.0307 -0.647303,0.0307 h -7.441406 c -2.411069,0 -4.365625,-1.95448 -4.365625,-4.36563 z"
          onMouseDown={handleMouseDown(Key.KEY_L2)}
        />
        <LayoutButton
          id="L3"
          fillRule="evenodd"
          clipRule="evenodd"
          d="m 56.885418,153.85522 c 0,-2.41115 1.954556,-4.36563 4.365625,-4.36563 h 7.441406 c 0.338138,0 0.507233,0 0.647303,0.0307 0.504243,0.1106 0.898049,0.50456 1.008671,1.0086 0.03075,0.14023 0.03075,0.30929 0.03075,0.64743 v 5.35781 c 0,0.33814 0,0.50721 -0.03075,0.64744 -0.110622,0.50403 -0.504428,0.898 -1.008671,1.00859 -0.14007,0.0307 -0.309165,0.0307 -0.647303,0.0307 h -7.441406 c -2.411069,0 -4.365625,-1.95447 -4.365625,-4.36562 z"
          onMouseDown={handleMouseDown(Key.KEY_L3)}
        />
        <g id="Home" onMouseDown={handleMouseDown(Key.KEY_HOME)}>
          <LayoutButton
            fillRule="evenodd"
            clipRule="evenodd"
            d="m 137.31875,176.12678 c 0,3.28322 0,4.92496 -0.49425,6.23438 -0.7784,2.06296 -2.40665,3.6912 -4.4696,4.46961 -1.30942,0.49424 -2.95116,0.49424 -6.23438,0.49424 h -15.52469 c -0.74083,0 -1.11125,0 -1.39435,-0.1442 -0.24898,-0.12673 -0.45138,-0.32914 -0.57812,-0.57811 -0.1442,-0.28311 -0.1442,-0.65352 -0.1442,-1.39436 v -10.05416 c 0,-0.74084 0,-1.11125 0.1442,-1.39436 0.12674,-0.24897 0.32914,-0.45138 0.57812,-0.57811 0.2831,-0.1442 0.65352,-0.1442 1.39435,-0.1442 h 23.63364 c 0.90593,0 1.35864,0 1.72006,0.13626 0.56885,0.21484 1.01811,0.6641 1.23296,1.23296 0.13626,0.36142 0.13626,0.81412 0.13626,1.72005 z"
          />
          <LayoutIcon
            d="m 125.08918,180.04526 -0.38471,-0.38497 -1.53961,-1.53934 c -0.036,-0.036 -0.0849,-0.0564 -0.136,-0.0564 -0.0511,0 -0.10001,0.0204 -0.13599,0.0564 l -1.53935,1.53934 -0.38497,0.38497 c -0.0349,0.0362 -0.0545,0.0849 -0.054,0.13521 5.3e-4,0.0505 0.0206,0.0987 0.0564,0.1344 0.0357,0.0357 0.0839,0.0561 0.1344,0.0564 0.0505,5.3e-4 0.099,-0.0188 0.13547,-0.054 l 0.0564,-0.0563 v 1.54913 c 0,0.12939 0.0516,0.25321 0.14287,0.34476 0.0915,0.0915 0.21564,0.14287 0.34502,0.14314 h 2.48761 c 0.12938,-2.7e-4 0.25347,-0.0516 0.34502,-0.14314 0.0915,-0.0916 0.14287,-0.21537 0.14314,-0.34476 v -1.54913 l 0.0563,0.0563 c 0.0362,0.0352 0.0849,0.0545 0.13521,0.054 0.0505,-2.6e-4 0.0987,-0.0206 0.1344,-0.0564 0.0357,-0.0357 0.0561,-0.0839 0.0564,-0.1344 5.3e-4,-0.0503 -0.0188,-0.099 -0.054,-0.13521 z"
            fillOpacity="0.8"
          />
        </g>
        <g id="Back" onMouseDown={handleMouseDown(Key.KEY_BACK)}>
          <LayoutButton
            fillRule="evenodd"
            clipRule="evenodd"
            d="m 73.81875,176.12678 c 0,3.28322 0,4.92496 0.494189,6.23438 0.778483,2.06296 2.406755,3.6912 4.469579,4.46961 1.309503,0.49424 2.951242,0.49424 6.234457,0.49424 h 15.855415 c 0.74084,0 1.11125,0 1.39436,-0.1442 0.24897,-0.12673 0.45138,-0.32914 0.57811,-0.57811 0.1442,-0.28311 0.1442,-0.65352 0.1442,-1.39436 v -10.05416 c 0,-0.74084 0,-1.11125 -0.1442,-1.39436 -0.12673,-0.24897 -0.32914,-0.45138 -0.57811,-0.57811 -0.28311,-0.1442 -0.65352,-0.1442 -1.39436,-0.1442 H 76.907945 c -0.905748,0 -1.358635,0 -1.719871,0.13626 -0.569066,0.21484 -1.018249,0.6641 -1.233011,1.23296 -0.136313,0.36142 -0.136313,0.81412 -0.136313,1.72005 z"
          />
          <LayoutIcon
            fillRule="evenodd"
            clipRule="evenodd"
            d="m 87.233389,180.44875 -0.802216,-0.91466 h 3.113087 c 1.460235,0 1.540669,2.08624 0.240771,2.32701 -0.256911,0.032 -0.208756,0.48128 0.06403,0.43312 1.813454,-0.28866 1.717146,-3.20939 -0.3048,-3.20939 h -3.113088 l 0.802216,-0.91467 c 0.192617,-0.22463 -0.128323,-0.51356 -0.320939,-0.28892 l -1.139296,1.28375 c -0.06429,0.0804 -0.06429,0.20876 0,0.28893 l 1.139296,1.2999 c 0.176477,0.20849 0.529695,-0.0802 0.320939,-0.30507 z"
            fillOpacity="0.8"
          />
        </g>
        <g id="Down" onMouseDown={handleMouseDown(Key.KEY_DOWN)}>
          <LayoutButton
            fillRule="evenodd"
            clipRule="evenodd"
            d="m 146.84374,165.62917 c -3.36101,0 -6.08542,-2.72442 -6.08542,-6.08542 v -16.40416 c 0,-0.74084 0,-1.11125 0.1442,-1.39436 0.12673,-0.24897 0.32914,-0.45138 0.57811,-0.57811 0.28311,-0.1442 0.65352,-0.1442 1.39436,-0.1442 h 7.9375 c 0.74083,0 1.11125,0 1.39435,0.1442 0.24897,0.12673 0.45138,0.32914 0.57811,0.57811 0.1442,0.28311 0.1442,0.65352 0.1442,1.39436 v 16.40416 c 0,3.361 -2.72441,6.08542 -6.08541,6.08542 z"
          />
          <LayoutIcon d="m 146.84797,154.2505 c 0.0717,-0.007 0.13943,-0.0357 0.1942,-0.0828 l 1.46579,-1.2565 c 0.0365,-0.0294 0.0669,-0.0656 0.0892,-0.10663 0.0222,-0.0413 0.0357,-0.0865 0.0402,-0.13308 0.004,-0.0466 -8e-4,-0.0937 -0.0148,-0.13812 -0.0143,-0.0447 -0.037,-0.086 -0.0675,-0.12144 -0.0304,-0.0357 -0.0677,-0.0648 -0.10954,-0.0855 -0.0421,-0.0209 -0.0876,-0.0331 -0.13441,-0.036 -0.0466,-0.003 -0.0934,0.004 -0.13758,0.019 -0.0442,0.0156 -0.0847,0.04 -0.11906,0.0714 l -1.23931,1.06257 -1.23904,-1.06257 c -0.0344,-0.0315 -0.0751,-0.0558 -0.11907,-0.0714 -0.0442,-0.0153 -0.091,-0.022 -0.13784,-0.019 -0.0466,0.003 -0.0923,0.0151 -0.13415,0.036 -0.0418,0.0206 -0.0791,0.0497 -0.10953,0.0855 -0.0304,0.0354 -0.0534,0.0767 -0.0675,0.12144 -0.0143,0.0444 -0.0193,0.0915 -0.0148,0.13812 0.004,0.0466 0.018,0.0918 0.0402,0.13308 0.0222,0.041 0.0524,0.0773 0.0889,0.10663 l 1.46605,1.2565 c 0.0355,0.0304 0.0767,0.0537 0.12145,0.0677 0.0445,0.0143 0.0915,0.0196 0.13811,0.0151 z" />
        </g>
        <g id="Up" onMouseDown={handleMouseDown(Key.KEY_UP)}>
          <LayoutButton
            fillRule="evenodd"
            clipRule="evenodd"
            d="m 146.84374,110.86042 c 3.361,0 6.08541,2.72452 6.08541,6.08542 V 133.35 c 0,0.74092 0,1.11136 -0.1442,1.39436 -0.12673,0.24892 -0.32914,0.4513 -0.57811,0.57811 -0.2831,0.1442 -0.65352,0.1442 -1.39435,0.1442 h -7.9375 c -0.74084,0 -1.11125,0 -1.39436,-0.1442 -0.24897,-0.12681 -0.45138,-0.32919 -0.57811,-0.57811 -0.1442,-0.283 -0.1442,-0.65344 -0.1442,-1.39436 v -16.40416 c 0,-3.36087 2.72441,-6.08542 6.08542,-6.08542 z"
          />
          <LayoutIcon d="m 146.78262,122.23898 c -0.0717,0.007 -0.1397,0.0359 -0.19421,0.0829 l -1.46605,1.25653 c -0.0365,0.0293 -0.0667,0.0656 -0.0889,0.10676 -0.0222,0.0412 -0.036,0.0864 -0.0402,0.13301 -0.004,0.0466 5.3e-4,0.0936 0.0148,0.13816 0.014,0.0446 0.037,0.0859 0.0675,0.12145 0.0304,0.0355 0.0677,0.0646 0.10953,0.0855 0.0418,0.0209 0.0876,0.0331 0.13415,0.0359 0.0468,0.003 0.0937,-0.004 0.13784,-0.0193 0.0439,-0.0156 0.0847,-0.0399 0.11907,-0.0714 l 1.23904,-1.06238 1.23904,1.06238 c 0.0347,0.0316 0.0751,0.0559 0.11933,0.0714 0.0442,0.0156 0.091,0.0221 0.13758,0.0193 0.0468,-0.003 0.0923,-0.0151 0.13441,-0.0359 0.0418,-0.0209 0.0791,-0.0499 0.10954,-0.0855 0.0304,-0.0356 0.0532,-0.0768 0.0675,-0.12145 0.014,-0.0446 0.019,-0.0916 0.0148,-0.13816 -0.005,-0.0466 -0.018,-0.0918 -0.0402,-0.13301 -0.0222,-0.0412 -0.0526,-0.0775 -0.0892,-0.10676 l -1.46579,-1.25653 c -0.0354,-0.0305 -0.0767,-0.0536 -0.12144,-0.0678 -0.0444,-0.0142 -0.0915,-0.0194 -0.13811,-0.0151 z" />
        </g>
      </g>
    </Svg>
  );
}
