# mypy-boto3-waf-regional

[![PyPI - mypy-boto3-waf-regional](https://img.shields.io/pypi/v/mypy-boto3-waf-regional.svg?color=blue)](https://pypi.org/project/mypy-boto3-waf-regional)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-waf-regional.svg?color=blue)](https://pypi.org/project/mypy-boto3-waf-regional)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.WAFRegional 1.16.17](https://boto3.amazonaws.com/v1/documentation/api/1.16.17/reference/services/waf-regional.html#WAFRegional) service
compatible with
[VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright)
and other tools.

Generated by [mypy-boto3-buider 3.2.2](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

- [mypy-boto3-waf-regional](#mypy-boto3-waf-regional)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Service Resource annotations](#service-resource-annotations)
    - [Other resources annotations](#other-resources-annotations)
    - [Collections annotations](#collections-annotations)
    - [Typed dictionations](#typed-dictionations)

## How to install

Install `boto3-stubs` for `WAFRegional` service.

```bash
python -m pip install boto3-stubs[waf-regional]
```

## Usage

### VSCode

- Install [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[waf-regional]` in your environment: `python -m pip install 'boto3-stubs[waf-regional]'`

Both type checking and auto-complete should work for `WAFRegional` service.
No explicit type annotations required, write your `boto3` code as usual.

### PyCharm

- Install `boto-stubs[waf-regional]` in your environment: `python -m pip install 'boto3-stubs[waf-regional]'`

Both type checking and auto-complete should work for `WAFRegional` service.
No explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed `boto3-stubs` submodules.

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything should work.

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[waf-regional]` in your environment: `python -m pip install 'boto3-stubs[waf-regional]'`
- Run `mypy` as usual

Type checking should work for `WAFRegional` service.
No explicit type annotations required, write your `boto3` code as usual.

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[waf-regional]` in your environment: `python -m pip install 'boto3-stubs[waf-regional]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `WAFRegional` service.
No explicit type annotations required, write your `boto3` code as usual.

## Explicit type annotations

### Client annotations

`WAFRegionalClient` provides annotations for `boto3.client("waf-regional")`.

```python
import boto3

from mypy_boto3_waf_regional import WAFRegionalClient

client: WAFRegionalClient = boto3.client("waf-regional")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: WAFRegionalClient = session.client("waf-regional")
```








### Typed dictionations

`mypy_boto3_waf_regional.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_waf_regional.type_defs import (
    ActivatedRuleTypeDef,
    ByteMatchSetSummaryTypeDef,
    ByteMatchSetTypeDef,
    ByteMatchSetUpdateTypeDef,
    ByteMatchTupleTypeDef,
    CreateByteMatchSetResponseTypeDef,
    CreateGeoMatchSetResponseTypeDef,
    CreateIPSetResponseTypeDef,
    CreateRateBasedRuleResponseTypeDef,
    CreateRegexMatchSetResponseTypeDef,
    CreateRegexPatternSetResponseTypeDef,
    CreateRuleGroupResponseTypeDef,
    CreateRuleResponseTypeDef,
    CreateSizeConstraintSetResponseTypeDef,
    CreateSqlInjectionMatchSetResponseTypeDef,
    CreateWebACLMigrationStackResponseTypeDef,
    CreateWebACLResponseTypeDef,
    CreateXssMatchSetResponseTypeDef,
    DeleteByteMatchSetResponseTypeDef,
    DeleteGeoMatchSetResponseTypeDef,
    DeleteIPSetResponseTypeDef,
    DeleteRateBasedRuleResponseTypeDef,
    DeleteRegexMatchSetResponseTypeDef,
    DeleteRegexPatternSetResponseTypeDef,
    DeleteRuleGroupResponseTypeDef,
    DeleteRuleResponseTypeDef,
    DeleteSizeConstraintSetResponseTypeDef,
    DeleteSqlInjectionMatchSetResponseTypeDef,
    DeleteWebACLResponseTypeDef,
    DeleteXssMatchSetResponseTypeDef,
    ExcludedRuleTypeDef,
    FieldToMatchTypeDef,
    GeoMatchConstraintTypeDef,
    GeoMatchSetSummaryTypeDef,
    GeoMatchSetTypeDef,
    GeoMatchSetUpdateTypeDef,
    GetByteMatchSetResponseTypeDef,
    GetChangeTokenResponseTypeDef,
    GetChangeTokenStatusResponseTypeDef,
    GetGeoMatchSetResponseTypeDef,
    GetIPSetResponseTypeDef,
    GetLoggingConfigurationResponseTypeDef,
    GetPermissionPolicyResponseTypeDef,
    GetRateBasedRuleManagedKeysResponseTypeDef,
    GetRateBasedRuleResponseTypeDef,
    GetRegexMatchSetResponseTypeDef,
    GetRegexPatternSetResponseTypeDef,
    GetRuleGroupResponseTypeDef,
    GetRuleResponseTypeDef,
    GetSampledRequestsResponseTypeDef,
    GetSizeConstraintSetResponseTypeDef,
    GetSqlInjectionMatchSetResponseTypeDef,
    GetWebACLForResourceResponseTypeDef,
    GetWebACLResponseTypeDef,
    GetXssMatchSetResponseTypeDef,
    HTTPHeaderTypeDef,
    HTTPRequestTypeDef,
    IPSetDescriptorTypeDef,
    IPSetSummaryTypeDef,
    IPSetTypeDef,
    IPSetUpdateTypeDef,
    ListActivatedRulesInRuleGroupResponseTypeDef,
    ListByteMatchSetsResponseTypeDef,
    ListGeoMatchSetsResponseTypeDef,
    ListIPSetsResponseTypeDef,
    ListLoggingConfigurationsResponseTypeDef,
    ListRateBasedRulesResponseTypeDef,
    ListRegexMatchSetsResponseTypeDef,
    ListRegexPatternSetsResponseTypeDef,
    ListResourcesForWebACLResponseTypeDef,
    ListRuleGroupsResponseTypeDef,
    ListRulesResponseTypeDef,
    ListSizeConstraintSetsResponseTypeDef,
    ListSqlInjectionMatchSetsResponseTypeDef,
    ListSubscribedRuleGroupsResponseTypeDef,
    ListTagsForResourceResponseTypeDef,
    ListWebACLsResponseTypeDef,
    ListXssMatchSetsResponseTypeDef,
    LoggingConfigurationTypeDef,
    PredicateTypeDef,
    PutLoggingConfigurationResponseTypeDef,
    RateBasedRuleTypeDef,
    RegexMatchSetSummaryTypeDef,
    RegexMatchSetTypeDef,
    RegexMatchSetUpdateTypeDef,
    RegexMatchTupleTypeDef,
    RegexPatternSetSummaryTypeDef,
    RegexPatternSetTypeDef,
    RegexPatternSetUpdateTypeDef,
    RuleGroupSummaryTypeDef,
    RuleGroupTypeDef,
    RuleGroupUpdateTypeDef,
    RuleSummaryTypeDef,
    RuleTypeDef,
    RuleUpdateTypeDef,
    SampledHTTPRequestTypeDef,
    SizeConstraintSetSummaryTypeDef,
    SizeConstraintSetTypeDef,
    SizeConstraintSetUpdateTypeDef,
    SizeConstraintTypeDef,
    SqlInjectionMatchSetSummaryTypeDef,
    SqlInjectionMatchSetTypeDef,
    SqlInjectionMatchSetUpdateTypeDef,
    SqlInjectionMatchTupleTypeDef,
    SubscribedRuleGroupSummaryTypeDef,
    TagInfoForResourceTypeDef,
    TagTypeDef,
    TimeWindowTypeDef,
    UpdateByteMatchSetResponseTypeDef,
    UpdateGeoMatchSetResponseTypeDef,
    UpdateIPSetResponseTypeDef,
    UpdateRateBasedRuleResponseTypeDef,
    UpdateRegexMatchSetResponseTypeDef,
    UpdateRegexPatternSetResponseTypeDef,
    UpdateRuleGroupResponseTypeDef,
    UpdateRuleResponseTypeDef,
    UpdateSizeConstraintSetResponseTypeDef,
    UpdateSqlInjectionMatchSetResponseTypeDef,
    UpdateWebACLResponseTypeDef,
    UpdateXssMatchSetResponseTypeDef,
    WafActionTypeDef,
    WafOverrideActionTypeDef,
    WebACLSummaryTypeDef,
    WebACLTypeDef,
    WebACLUpdateTypeDef,
    XssMatchSetSummaryTypeDef,
    XssMatchSetTypeDef,
    XssMatchSetUpdateTypeDef,
    XssMatchTupleTypeDef,
)

def get_structure() -> ActivatedRuleTypeDef:
    return {
      ...
    }
```
