# ---------- Text Templates used by the CLI ----------

WORKFLOW_TXT = """✅ Machine Learning Workflow Checklist

0) Project setup
   - Create repo, README, issues
   - Define success criteria and baseline

1) Problem framing
   - Objective (business/research)
   - Inputs/Outputs, constraints, metrics

2) Data
   - Sources, access, licenses
   - Train/Val/Test split strategy
   - Data dictionary / schema

3) Preprocessing
   - Missing values
   - Categorical encoding
   - Scaling/normalization
   - Feature engineering
   - Leakage checks

4) EDA
   - Summary stats, distributions
   - Outliers, imbalance
   - Correlations/relationships
   - Data quality notes

5) Baseline & Models
   - Simple baseline first
   - Candidate models and rationale

6) Training & Evaluation
   - Cross-validation strategy
   - Metrics (clf: acc/prec/rec/F1/AUC | reg: RMSE/MAE/R²)
   - Error analysis

7) Tuning
   - Hyperparam search plan (Grid/Random/Bayes)
   - Reproducibility (seed, versions)

8) Packaging & Artifacts
   - Save model, encoder, scaler
   - Version artifacts & metadata

9) Deployment
   - API/Batch/Stream (FastAPI/Flask/Streamlit)
   - Containerization (optional)
   - Sec/Perf/Cost considerations

10) Monitoring & Iteration
   - Data & performance drift
   - Feedback loops and retraining cadence
"""

README_TEMPLATE = """# {project_name}

Generated by **mlscaffold**.

## Structure
- `src/` — main Python source
- `data/raw`, `data/processed` — dataset staging
- `models/` — saved models & checkpoints
- `notebooks/` — exploratory notebooks
- `docs/` — project documentation
- `tests/` — unit tests
- `ML_Workflow.txt` — ML lifecycle checklist

## Quickstart
```bash
python -m venv .venv
# Linux/Mac
source .venv/bin/activate
# Windows (PowerShell)
# .venv\\Scripts\\Activate.ps1

pip install -r requirements.txt
python src/main.py

"""

MAIN_PY_TEMPLATE = '''"""
Entry script for your ML project.
"""

def __main__():
    print("🚀 Project is ready. Start building in src/ !")
    print("Tip: open ML_Workflow.txt for a step-by-step checklist.")

if __name__ == "__main__":
    __main__()
'''

REQUIREMENTS_TXT = """# Add your dependencies here (example basics)
numpy
pandas
scikit-learn
matplotlib
"""

GITIGNORE_TXT = """pycache/
*.py[cod]
.venv/
.env
dist/
build/
*.egg-info/
.ipynb_checkpoints/
.DS_Store
Thumbs.db
"""

TEST_SAMPLE = """def test_smoke():
assert True
"""