# Experiments in Meggie

This section provides a straightforward overview of Meggie's layout and the steps for starting and managing experiments with subjects.

## Layout Overview

Meggie's interface is organized into two main columns:

- Left Column: This area is your control panel for the experiment. Here, you add new subjects to your experiment and adjust settings like channel groups. It's the organizational hub for your data.

- Right Column: This column contains the analysis tools, referred to as actions, which you'll apply to your data. These tools are arranged in tabs and are used to process the data step by step.

## Starting an Experiment

Begin by creating an experiment where you'll enter basic information such as the experiment's name and the person conducting it. You'll also choose a pipeline that fits your research needs. This helps keep the interface focused and guides you through the necessary steps. A folder for the experiment will be created to store all related files.

## Adding Subjects

After setting up your experiment, you can add subjects, which are your individual recordings, using the "Add new..." option in the left column.

## Applying Actions

In the right column, you'll find the actions you can apply to your data. These actions are designed to be used on all your subjects at once, making it efficient to process multiple datasets.

## Preprocessing

Meggie includes basic preprocessing features to improve the quality of your data. You can remove unwanted noise and apply filters to clean up the signals before further analysis.

## Working with EEG and MEG Data

Meggie is equipped to handle both EEG and MEG data. For EEG, it offers tools to add sensor locations and adjust channel references when necessary.

## Managing Events

Events, which are significant points in your recordings, can be managed within Meggie. This ensures you have control over important data points for analysis.

## Progressing Through Analysis

The goal is to transform raw recordings into data that can inform your research. You'll use actions to move through analysis stages, each tailored to bring out specific features of your data.
