import numpy as np
import pytest
from pytrade.risk.models.full import _numpy_compute_single_period_lwcc_cov
from pytrade.utils.pandas import str_to_pandas


# TODO: reuse johnson stock data
def johnson_stock_data():
    return str_to_pandas("""
    time    jpmorgan  citibank  wellsfargo  royaldutchshell  exxonmobil
       0    0.013034 -0.007843   -0.003189        -0.044769    0.005215
       1    0.008486  0.016689   -0.006210         0.011956    0.013489
       2   -0.017915 -0.008639    0.010036         0.000000   -0.006143
       3    0.021559 -0.003486    0.017435        -0.028592   -0.006953
       4    0.010823  0.003717   -0.010134         0.029190    0.040975
       5    0.010171 -0.012198   -0.008377         0.013708    0.002989
       6    0.011129  0.028004    0.008072         0.030543    0.003229
       7    0.048480 -0.005148    0.018249         0.006335    0.007675
       8   -0.034491 -0.013799   -0.008047        -0.029901   -0.010811
       9   -0.004660  0.020988   -0.006084        -0.020394   -0.012668
       10  -0.001821 -0.005568   -0.010759        -0.008990   -0.018365
       11   0.014852  0.034668   -0.006000         0.036285    0.028703
       12  -0.009243 -0.005203    0.004716         0.026492    0.012955
       13  -0.045867 -0.027824   -0.014270         0.037478    0.033202
       14  -0.024443 -0.018291    0.005905        -0.025957   -0.020233
       15  -0.018374 -0.014029    0.001136         0.007328   -0.009718
       16  -0.029779 -0.028457   -0.016456         0.031085    0.016438
       17  -0.022508 -0.022883    0.034423        -0.006201    0.006758
       18   0.011962 -0.006792    0.018591        -0.019363   -0.015344
       19   0.020981  0.024051    0.012959         0.035542    0.015096
       20   0.011867  0.002533   -0.003604         0.002119    0.002878
       21   0.014016  0.017226    0.000362         0.015011    0.014112
       22  -0.014951  0.003161   -0.000181         0.031035    0.022641
       23   0.020332 -0.014855   -0.018261        -0.002828   -0.016144
       24   0.011227 -0.022161   -0.005156        -0.024716    0.010549
       25  -0.032751 -0.015888   -0.003702         0.014333    0.016470
       26  -0.026112 -0.031339    0.015608         0.002458    0.008215
       27   0.018267  0.015686   -0.021954        -0.049847   -0.011091
       28   0.021991  0.004344    0.013655         0.015265    0.021744
       29  -0.033126 -0.020423   -0.010150        -0.018636   -0.025538
       30   0.021376  0.018886    0.021066         0.022874    0.001379
       31   0.048452  0.044054    0.008764         0.016034    0.007346
       32   0.027618  0.016832    0.010498         0.000415    0.004330
       33   0.003193  0.002494    0.010389         0.022831    0.035625
       34  -0.001061  0.008595   -0.002305        -0.004058    0.006573
       35  -0.003717 -0.006055    0.003554         0.011410    0.021115
       36   0.002399 -0.059792   -0.011863        -0.025181   -0.011085
       37   0.014890  0.016319    0.026519         0.020046    0.021988
       38  -0.008908 -0.006848    0.004713         0.012966    0.019616
       39  -0.022733 -0.014028   -0.006949         0.002400   -0.016549
       40  -0.033000 -0.031348   -0.036214         0.005587   -0.006521
       41   0.030210  0.052278    0.031766         0.026786    0.010587
       42   0.019549  0.039508    0.038177         0.021642    0.023884
       43  -0.004527  0.020483    0.017455         0.025345    0.005934
       44  -0.044676 -0.040812   -0.016323        -0.003505   -0.000814
       45   0.007001  0.006045    0.015408         0.032025    0.025244
       46   0.010011  0.004853   -0.001667        -0.005022   -0.026608
       47  -0.011288  0.005750    0.010022        -0.017307   -0.002448
       48   0.023670  0.015550   -0.016206         0.000183   -0.006953
       49   0.016594  0.045710    0.006556         0.028430    0.043451
       50  -0.004014 -0.011843   -0.004175         0.003924   -0.013617
       51  -0.006986  0.009806    0.000335        -0.026115   -0.028611
       52  -0.015422 -0.023306   -0.023806         0.011310    0.025747
       53  -0.025282  0.008838   -0.009445         0.007576   -0.012450
       54   0.003947  0.009417    0.006761         0.024168    0.016470
       55   0.018815  0.037969    0.015499         0.051040    0.078416
       56  -0.005513 -0.007525   -0.011192        -0.004490    0.019848
       57  -0.026053 -0.016849   -0.008060         0.043268    0.058749
       58   0.012806 -0.005998    0.001383         0.014892    0.064937
       59   0.014611  0.002586    0.010014         0.036289    0.004840
       60  -0.037386 -0.012683   -0.011453        -0.027253   -0.039653
       61  -0.002877 -0.019595   -0.007090        -0.010017    0.026245
       62  -0.030006 -0.049745   -0.016719        -0.050751   -0.058316
       63  -0.019334  0.002103    0.017889         0.015490    0.026293
       64   0.017288  0.017491    0.002262         0.019518   -0.008933
       65  -0.016398  0.007793   -0.007292        -0.035875   -0.063605
       66   0.027584  0.012509   -0.007870         0.019690    0.057392
       67   0.017699  0.023360    0.021682        -0.012764   -0.040192
       68   0.003478 -0.007902    0.005004         0.007128    0.010021
       69  -0.032351 -0.014602   -0.008412        -0.048223   -0.062899
       70   0.046567  0.041087    0.034972         0.015217    0.005672
       71  -0.007131 -0.010783   -0.008699         0.030319    0.051701
       72  -0.007182  0.005886    0.009112        -0.006447    0.006078
       73  -0.003183  0.001734   -0.000669         0.006489    0.021500
       74   0.018287 -0.003894    0.004685         0.061994    0.043138
       75  -0.014253 -0.010643   -0.014157         0.000156   -0.045023
       76  -0.004627 -0.016904    0.008954         0.039066    0.002794
       77  -0.007263  0.007593    0.000000        -0.004943    0.018631
       78   0.030143 -0.001995    0.026122        -0.030709   -0.020855
       79  -0.007102 -0.043082   -0.017787        -0.051871    0.023045
       80  -0.012875 -0.010907   -0.006646         0.016708   -0.012628
       81   0.002899  0.003050   -0.007359         0.044305   -0.011234
       82  -0.026590 -0.000234   -0.003370         0.061555    0.056109
       83   0.006829  0.012401    0.007608        -0.042000   -0.036577
       84  -0.025951 -0.024035   -0.030369        -0.020935   -0.006872
       85   0.013624  0.018233    0.008652         0.056864    0.038748
       86   0.020908  0.016512    0.008921        -0.023017    0.041632
       87   0.004974  0.018760    0.002380         0.012305    0.007834
       88  -0.026201 -0.004491   -0.016624        -0.009635    0.002062
       89  -0.004185  0.006091   -0.006728         0.013471   -0.004591
       90   0.009006 -0.002242    0.000000        -0.042977   -0.062023
       91   0.005356 -0.008315    0.006947        -0.018827   -0.016107
       92   0.030778 -0.016089    0.003105        -0.053948   -0.055661
       93   0.037324  0.035928    0.025275         0.058188    0.016971
       94   0.023803  0.003112   -0.006876         0.012254    0.028171
       95   0.025683  0.052527    0.040696        -0.031662   -0.018848
       96  -0.006062  0.008633    0.005841         0.044558    0.030594
       97   0.021745  0.022964    0.029198         0.008440    0.031930
       98   0.003374 -0.015306   -0.023824        -0.001674   -0.017227
       99   0.003363  0.002902   -0.003051        -0.001219   -0.009701
       100  0.017015  0.009506    0.018199        -0.016176   -0.007561
       101  0.010393 -0.002661    0.004429        -0.002482   -0.016450
       102 -0.012795 -0.014368   -0.018740        -0.004976   -0.016373
        """, index_col="time")


@pytest.mark.parametrize(["returns", "expected"],
                         [pytest.param(
                             johnson_stock_data() * 100,
                             np.array([[4.33, 2.54, 1.5, 0.88, 1.09],
                                       [2.54, 4.39, 1.68, 1.85, 1.38],
                                       [1.5, 1.68, 2.24, 0.86, 0.76],
                                       [0.88, 1.85, 0.86, 7.22, 4.65],
                                       [1.09, 1.38, 0.76, 4.65, 7.66]]))])
def test__numpy_single_period_lwcc_cov(returns, expected):
    actual = _numpy_compute_single_period_lwcc_cov(returns.values)
    np.testing.assert_allclose(actual, expected, atol=1e-2, rtol=0)
