"""
AgentMind Memory - The missing memory layer for AI agents
"""
from setuptools import setup, find_packages
import os

here = os.path.abspath(os.path.dirname(__file__))

with open(os.path.join(here, "README.md"), "r", encoding="utf-8") as fh:
    long_description = fh.read()

setup(
    name="agentmind",
    version="0.2.0",
    author="muiez",
    author_email="",
    description="Plug-and-play memory for AI agents. Simple, fast, and powerful.",
    long_description=long_description,
    long_description_content_type="text/markdown",
    url="https://github.com/muiez/agentmind",
    packages=find_packages(),
    classifiers=[
        "Development Status :: 3 - Alpha",
        "Intended Audience :: Developers",
        "Topic :: Scientific/Engineering :: Artificial Intelligence",
        "License :: OSI Approved :: MIT License",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.9",
        "Programming Language :: Python :: 3.10",
        "Programming Language :: Python :: 3.11",
    ],
    python_requires=">=3.9",
    install_requires=[
        "requests>=2.28.0",
        "pydantic>=2.0.0",
        "numpy>=1.24.0",
        "tiktoken>=0.5.0",
        "python-dateutil>=2.8.0",
    ],
    extras_require={
        "dev": [
            "pytest>=7.0.0",
            "pytest-asyncio>=0.21.0",
            "black>=23.0.0",
            "flake8>=6.0.0",
            "mypy>=1.0.0",
            "pytest-cov>=4.0.0",
        ],
        "langchain": ["langchain>=0.1.0"],
        "openai": ["openai>=1.0.0"],
    },
)