"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GlobalAuroraRDSSlaveInfra = exports.GlobalAuroraRDSMaster = exports.InstanceTypeEnum = exports.MySQLtimeZone = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const ec2 = require("@aws-cdk/aws-ec2");
const iam = require("@aws-cdk/aws-iam");
const lambda = require("@aws-cdk/aws-lambda");
const logs = require("@aws-cdk/aws-logs");
const rds = require("@aws-cdk/aws-rds");
const cdk = require("@aws-cdk/core");
const cr = require("@aws-cdk/custom-resources");
var MySQLtimeZone;
(function (MySQLtimeZone) {
    /**
     * TIME ZONE UTC
     */
    MySQLtimeZone["UTC"] = "UTC";
    /**
     * TIME ZONE Asia/Taipei
     */
    MySQLtimeZone["ASIA_TAIPEI"] = "Asia/Taipei";
    /**
     * TIME ZONE Africa/Cairo
     */
    MySQLtimeZone["AFRICA_CAIRO"] = "Africa/Cairo";
    /**
     * TIME ZONE Asia/Bangkok
     */
    MySQLtimeZone["ASIA_BANGKOK"] = "Asia/Bangkok";
    /**
     * TIME ZONE Australia/Darwin
     */
    MySQLtimeZone["AUSTRALIA_DARWIN"] = "Australia/Darwin";
    /**
     * TIME ZONE Africa/Casablanca
     */
    MySQLtimeZone["AFRICA_CASABLANCA"] = "Africa/Casablanca";
    /**
     * TIME ZONE Asia/Beirut
     */
    MySQLtimeZone["ASIA_BEIRUT"] = "Asia/Beirut";
    /**
     * TIME ZONE Australia/Hobart
     */
    MySQLtimeZone["AUSTRALIA_HOBART"] = "Australia/Hobart";
    /**
     * TIME ZONE Africa/Harare
     */
    MySQLtimeZone["AFRICA_HARARE"] = "Africa/Harare";
    /**
     * TIME ZONE Asia/Calcutta
     */
    MySQLtimeZone["ASIA_CALCUTTA"] = "Asia/Calcutta";
    /**
     * TIME ZONE Australia/Perth
     */
    MySQLtimeZone["AUSTRALIA_PERTH"] = "Australia/Perth";
    /**
     * TIME ZONE Africa/Monrovia
     */
    MySQLtimeZone["AFRICA_MONROVIA"] = "Africa/Monrovia";
    /**
     * TIME ZONE Asia/Damascus
     */
    MySQLtimeZone["ASIA_DAMASCUS"] = "Asia/Damascus";
    /**
     * TIME ZONE Australia/Sydney
     */
    MySQLtimeZone["AUSTRALIA_SYDNEY"] = "Australia/Sydney";
    /**
     * TIME ZONE Africa/Nairobi
     */
    MySQLtimeZone["AFRICA_NAIROBI"] = "Africa/Nairobi";
    /**
     * TIME ZONE Asia/Dhaka
     */
    MySQLtimeZone["ASIA_DHAKA"] = "Asia/Dhaka";
    /**
     * TIME ZONE Brazil/East
     */
    MySQLtimeZone["BRAZIL_EAST"] = "Brazil/East";
    /**
     * TIME ZONE Africa/Tripoli
     */
    MySQLtimeZone["AFRICA_TRIPOLI"] = "Africa/Tripoli";
    /**
     * TIME ZONE Asia/Irkutsk
     */
    MySQLtimeZone["ASIA_IRKUTSK"] = "Asia/Irkutsk";
    /**
     * TIME ZONE Canada/Newfoundland
     */
    MySQLtimeZone["CANADA_NEWFOUNDLAND"] = "Canada/Newfoundland";
    /**
     * TIME ZONE Africa/Windhoek
     */
    MySQLtimeZone["AFRICA_WINDHOEK"] = "Africa/Windhoek";
    /**
     * TIME ZONE Asia/Jerusalem
     */
    MySQLtimeZone["ASIA_JERUSALEM"] = "Asia/Jerusalem";
    /**
     * TIME ZONE Canada/Saskatchewan
     */
    MySQLtimeZone["CANADA_SASKATCHEWAN"] = "Canada/Saskatchewan";
    /**
     * TIME ZONE America/Araguaina
     */
    MySQLtimeZone["AMERICA_ARAGUAINA"] = "America/Araguaina";
    /**
     * TIME ZONE Asia/Kabul
     */
    MySQLtimeZone["ASIA_KABUL"] = "Asia/Kabul";
    /**
     * TIME ZONE Europe/Amsterdam
     */
    MySQLtimeZone["EUROPE_AMSTERDAM"] = "Europe/Amsterdam";
    /**
     * TIME ZONE America/Asuncion
     */
    MySQLtimeZone["AMERICA_ASUNCION"] = "America/Asuncion";
    /**
     * TIME ZONE Asia/Karachi
     */
    MySQLtimeZone["ASIA_KARACHI"] = "Asia/Karachi";
    /**
     * TIME ZONE Europe/Athens
     */
    MySQLtimeZone["EUROPE_ATHENS"] = "Europe/Athens";
    /**
     * TIME ZONE America/Bogota
     */
    MySQLtimeZone["AMERICA_BOGOTA"] = "America/Bogota";
    /**
     * TIME ZONE Asia/Kathmandu
     */
    MySQLtimeZone["ASIA_KATHMANDU"] = "Asia/Kathmandu";
    /**
     * TIME ZONE Europe/Dublin
     */
    MySQLtimeZone["EUROPE_DUBLIN"] = "Europe/Dublin";
    /**
     * TIME ZONE America/Caracas
     */
    MySQLtimeZone["AMERICA_CARACAS"] = "America/Caracas";
    /**
    * TIME ZONE Asia/Krasnoyarsk
    */
    MySQLtimeZone["ASIA_KRASNOYARSK"] = "Asia/Krasnoyarsk";
    /**
     * TIME ZONE Europe/Helsinki
     */
    MySQLtimeZone["EUROPE_HELSINKI"] = "Europe/Helsinki";
    /**
     * TIME ZONE America/Chihuahua
     */
    MySQLtimeZone["AMERICA_CHIHUAHUA"] = "America/Chihuahua";
    /**
     * TIME ZONE Asia/Magadan
     */
    MySQLtimeZone["ASIA_MAGADAN"] = "Asia/Magadan";
    /**
     * TIME ZONE Europe/Istanbul
     */
    MySQLtimeZone["EUROPE_ISTANBUL"] = "Europe/Istanbul";
    /**
     * TIME ZONE America/Cuiaba
     */
    MySQLtimeZone["AMERICA_CUIABA"] = "America/Cuiaba";
    /**
     * TIME ZONE Asia/Muscat
     */
    MySQLtimeZone["ASIA_MUSCAT"] = "Asia/Muscat";
    /**
     * TIME ZONE Europe/Kaliningrad
     */
    MySQLtimeZone["EUROPE_KALININGRAD"] = "Europe/Kaliningrad";
    /**
     * TIME ZONE America/Denver
     */
    MySQLtimeZone["AMERICA_DENVER"] = "America/Denver";
    /**
     * TIME ZONE Asia/Novosibirsk
     */
    MySQLtimeZone["ASIA_NOVOSIBIRSK"] = "Asia/Novosibirsk";
    /**
     * TIME ZONE Europe/Moscow'
     */
    MySQLtimeZone["EUROPE_MOSCOW"] = "Europe/Moscow";
    /**
     * TIME ZONE America/Fortaleza
     */
    MySQLtimeZone["AMERICA_FORTALEZA"] = "America/Fortaleza";
    /**
     * TIME ZONE Asia/Riyadh
     */
    MySQLtimeZone["ASIA_RIYADH"] = "Asia/Riyadh";
    /**
     * TIME ZONE Europe/Paris
     */
    MySQLtimeZone["EUROPE_PARIS"] = "Europe/Paris";
    /**
     * TIME ZONE America/Guatemala
     */
    MySQLtimeZone["AMERICA_GUATEMALA"] = "America/Guatemala";
    /**
     * TIME ZONE Asia/Seoul
     */
    MySQLtimeZone["ASIA_SEOUL"] = "Asia/Seoul";
    /**
     * TIME ZONE Europe/Prague
     */
    MySQLtimeZone["EUROPE_PRAGUE"] = "Europe/Prague";
    /**
     * TIME ZONE America/Halifax
     */
    MySQLtimeZone["AMERICA_HALIFAX"] = "America/Halifax";
    /**
     * TIME ZONE Asia/Shanghai
     */
    MySQLtimeZone["ASIA_SHANGHAI"] = "Asia/Shanghai";
    /**
     * TIME ZONE Europe/Sarajevo
     */
    MySQLtimeZone["EUROPE_SARAJEVO"] = "Europe/Sarajevo";
    /**
     * TIME ZONE America/Manaus
     */
    MySQLtimeZone["AMERICA_MANAUS"] = "America/Manaus";
    /**
     * TIME ZONE Asia/Singapore
     */
    MySQLtimeZone["ASIA_SINGAPORE"] = "Asia/Singapore";
    /**
     * TIME ZONE Pacific/Auckland
     */
    MySQLtimeZone["PACIFIC_AUCKLAND"] = "Pacific/Auckland";
    /**
     * TIME ZONE America/Matamoros
     */
    MySQLtimeZone["AMERICA_MATAMOROS"] = "America/Matamoros";
    /**
     * TIME ZONE Pacific/Fiji
     */
    MySQLtimeZone["PACIFIC_FIJI"] = "Pacific/Fiji";
    /**
     * TIME ZONE America/Monterrey
     */
    MySQLtimeZone["AMERICA_MONTERREY"] = "America/Monterrey";
    /**
     * TIME ZONE Asia/Tehran
     */
    MySQLtimeZone["ASIA_TEHRAN"] = "Asia/Tehran";
    /**
     * TIME ZONE Pacific/Guam
     */
    MySQLtimeZone["PACIFIC_GUAM"] = "Pacific/Guam";
    /**
     * TIME ZONE America/Montevideo
     */
    MySQLtimeZone["AMERICA_MONTEVIDEO"] = "America/Montevideo";
    /**
     * TIME ZONE Asia/Tokyo
     */
    MySQLtimeZone["ASIA_TOKYO"] = "Asia/Tokyo";
    /**
     * TIME ZONE Pacific/Honolulu
     */
    MySQLtimeZone["PACIFIC_HONOLULU"] = "Pacific/Honolulu";
    /**
     * TIME ZONE America/Phoenix
     */
    MySQLtimeZone["AMERICA_PHOENIX"] = "America/Phoenix";
    /**
     * TIME ZONE Asia/Ulaanbaatar
     */
    MySQLtimeZone["ASIA_ULAANBAATAR"] = "Asia/Ulaanbaatar";
    /**
     * TIME ZONE Pacific/Samoa
     */
    MySQLtimeZone["PACIFIC_SAMOA"] = "Pacific/Samoa";
    /**
     * TIME ZONE America/Santiago
     */
    MySQLtimeZone["AMERICA_SANTIAGO"] = "America/Santiago";
    /**
     * TIME ZONE Asia/Vladivostok
     */
    MySQLtimeZone["ASIA_VLADIVOSTOK"] = "Asia/Vladivostok";
    /**
     * TIME ZONE US/Alaska
     */
    MySQLtimeZone["US_ALASKA"] = "US/Alaska";
    /**
     * TIME ZONE America/Tijuana
     */
    MySQLtimeZone["AMERICA_TIJUANA"] = "America/Tijuana";
    /**
     * TIME ZONE Asia/Yakutsk
     */
    MySQLtimeZone["ASIA_YAKUTSK"] = "Asia/Yakutsk";
    /**
     * TIME ZONE US/Central
     */
    MySQLtimeZone["US_CENTRAL"] = "US/Central";
    /**
     * TIME ZONE Asia/Amman
     */
    MySQLtimeZone["ASIA_AMMAN"] = "Asia/Amman";
    /**
     * TIME ZONE Asia/Yerevan
     */
    MySQLtimeZone["ASIA_YEREVAN"] = "Asia/Yerevan";
    /**
    * TIME ZONE US/Eastern
    */
    MySQLtimeZone["US_EASTERN"] = "US/Eastern";
    /**
     * TIME ZONE Asia/Ashgabat
     */
    MySQLtimeZone["ASIA_ASHGABAT"] = "Asia/Ashgabat";
    /**
     * TIME ZONE Atlantic/Azores
     */
    MySQLtimeZone["ATLANTIC_AZORES"] = "Atlantic/Azores";
    /**
     * TIME ZONE US/East-Indiana
     */
    MySQLtimeZone["US_EAST_INDIANA"] = "US/East-Indiana";
    /**
     * TIME ZONE Asia/Baghdad
     */
    MySQLtimeZone["ASIA_BAGHDAD"] = "Asia/Baghdad";
    /**
     * TIME ZONE Australia/Adelaide
     */
    MySQLtimeZone["AUSTRALIA_ADELAIDE"] = "Australia/Adelaide";
    /**
     * TIME ZONE US/Pacific
     */
    MySQLtimeZone["US_PACIFIC"] = "US/Pacific";
    /**
     * TIME ZONE Asia/Baku
     */
    MySQLtimeZone["ASIA_BAKU"] = "Asia/Baku";
    /**
     * TIME ZONE Australia/Brisbane
     */
    MySQLtimeZone["AUSTRALIA_BRISBANE"] = "Australia/Brisbane";
})(MySQLtimeZone || (exports.MySQLtimeZone = MySQLtimeZone = {}));
var InstanceTypeEnum;
(function (InstanceTypeEnum) {
    /**
     * db Instance Type r4.large
     */
    InstanceTypeEnum["R4_LARGE"] = "r4.large";
    /**
     * db Instance Type r4.xlarge
     */
    InstanceTypeEnum["R4_XLARGE"] = "r4.xlarge";
    /**
     * db Instance Type r4.2xlarge
     */
    InstanceTypeEnum["R4_2XLARGE"] = "r4.2xlarge";
    /**
     * db Instance Type r4.4xlarge
     */
    InstanceTypeEnum["R4_4XLARGE"] = "r4.4xlarge";
    /**
     * db Instance Type r4.8xlarge
     */
    InstanceTypeEnum["R4_8XLARGE"] = "r4.8xlarge";
    /**
     * db Instance Type r4.16xlarge
     */
    InstanceTypeEnum["R4_16XLARGE"] = "r4.16xlarge";
    /**
     * db Instance Type r5.large
     */
    InstanceTypeEnum["R5_LARGE"] = "r5.large";
    /**
     * db Instance Type r5.xlarge
     */
    InstanceTypeEnum["R5_XLARGE"] = "r5.xlarge";
    /**
     * db Instance Type r5.2xlarge
     */
    InstanceTypeEnum["R5_2XLARGE"] = "r5.2xlarge";
    /**
     * db Instance Type r5.4xlarge
     */
    InstanceTypeEnum["R5_4XLARGE"] = "r5.4xlarge";
    /**
     * db Instance Type r5.8xlarge
     */
    InstanceTypeEnum["R5_8XLARGE"] = "r5.8xlarge";
    /**
     * db Instance Type r5.12xlarge
     */
    InstanceTypeEnum["R5_12XLARGE"] = "r5.12xlarge";
    /**
     * db Instance Type r5.16xlarge
     */
    InstanceTypeEnum["R5_16XLARGE"] = "r5.16xlarge";
    /**
     * db Instance Type r5.24xlarge
     */
    InstanceTypeEnum["R5_24XLARGE"] = "r5.24xlarge";
    /**
     * db Instance Type r6g.large
     */
    InstanceTypeEnum["R6G_LARGE"] = "r6g.large";
    /**
     * db Instance Type r6g.xlarge
     */
    InstanceTypeEnum["R6G_XLARGE"] = "r6g.xlarge";
    /**
     * db Instance Type r6g.2xlarge
     */
    InstanceTypeEnum["R6G_2XLARGE"] = "r6g.2xlarge";
    /**
     * db Instance Type r6g.4xlarge
     */
    InstanceTypeEnum["R6G_4XLARGE"] = "r6g.4xlarge";
    /**
     * db Instance Type r6g.8xlarge
     */
    InstanceTypeEnum["R6G_8XLARGE"] = "r6g.8xlarge";
    /**
     * db Instance Type r6g.12xlarge
     */
    InstanceTypeEnum["R6G_12XLARGE"] = "r6g.12xlarge";
    /**
     * db Instance Type r6g.16xlarge
     */
    InstanceTypeEnum["R6G_16XLARGE"] = "r6g.16xlarge";
})(InstanceTypeEnum || (exports.InstanceTypeEnum = InstanceTypeEnum = {}));
const GlobalAuroraRDSSupportRegion = ['us-east-1', 'us-east-2', 'us-west-1', 'us-west-2', 'eu-west-1', 'eu-west-2', 'eu-west-3', 'eu-central-1',
    'ap-south-1', 'ap-southeast-1', 'ap-southeast-2', 'ap-northeast-1', 'ap-northeast-2', 'ca-central-1'];
class GlobalAuroraRDSMaster extends cdk.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const stack = cdk.Stack.of(this);
        if (GlobalAuroraRDSSupportRegion.indexOf(stack.region) == -1) {
            throw new Error(`This region ${stack.region} not Support Global RDS !!!`);
        }
        let rdsCredentials;
        if (props?.rdsPassword) {
            rdsCredentials = {
                username: props?.dbUserName ?? 'sysadmin',
                password: cdk.SecretValue.plainText(props?.rdsPassword),
            };
        }
        else {
            rdsCredentials = {
                username: props?.dbUserName ?? 'sysadmin',
            };
        }
        ;
        // Mysql need (MySQL 5.6 / version > 5.6.10a) , Postgres need (version 10.11 , 10.12 , 11.7 or later)
        this.engineVersion = props?.engineVersion ?? rds.DatabaseClusterEngine.auroraMysql({
            version: rds.AuroraMysqlEngineVersion.VER_2_07_1,
        });
        this.rdsInstanceType = props?.instanceType ?? InstanceTypeEnum.R5_LARGE;
        // Master region Vpc
        const rdsVpc = props?.vpc ?? new ec2.Vpc(this, 'RDSVpcRegionMaster', {
            cidr: '10.108.0.0/16',
            enableDnsHostnames: true,
            enableDnsSupport: true,
            natGateways: 1,
        });
        this.dbClusterpPG = props?.dbClusterpPG ?? new rds.ParameterGroup(this, 'dbClusterparametergroup', {
            engine: this.engineVersion,
            parameters: props?.parameters ?? {
                time_zone: props?.timeZone ?? MySQLtimeZone.UTC,
            },
        });
        let rdsVpcSubnetSelect = ec2.SubnetType.PRIVATE;
        if (this.azOfSubnets(rdsVpc.privateSubnets) === 0) {
            rdsVpcSubnetSelect = ec2.SubnetType.PUBLIC;
        }
        this.rdsCluster = new rds.DatabaseCluster(this, 'RDSCluster', {
            engine: this.engineVersion,
            parameterGroup: this.dbClusterpPG,
            clusterIdentifier: `${stack.stackName.toLowerCase()}-primary`,
            credentials: rdsCredentials,
            instances: 1,
            instanceProps: {
                // if want publicAccess , need to define vpcSubnets: { subnetType: ec2.SubnetType.PUBLIC } ,
                vpc: rdsVpc,
                vpcSubnets: { subnetType: rdsVpcSubnetSelect },
                instanceType: new ec2.InstanceType(this.rdsInstanceType),
            },
            removalPolicy: cdk.RemovalPolicy.DESTROY,
            defaultDatabaseName: props?.defaultDatabaseName ?? 'globaldatabase',
        });
        this.rdsPassword = `Please use this command get password back , aws secretsmanager get-secret-value --secret-id ${this.rdsCluster.secret?.secretName}` ?? props?.rdsPassword;
        ;
        this.rdsCluster.node.addDependency(rdsVpc);
        this.rdsCluster.connections.allowDefaultPortFrom(ec2.Peer.ipv4(rdsVpc.vpcCidrBlock));
        // custom resource policy
        const CustomResourcePolicy = new iam.PolicyStatement({
            resources: ['*'],
            actions: ['rds:CreateGlobalCluster', 'rds:DeleteGlobalCluster', 'rds:RemoveFromGlobalCluster', 'rds:ModifyGlobalCluster'],
        });
        // Upgrade database to Global.
        const onEvent = new lambda.Function(this, 'onEventHandler', {
            runtime: lambda.Runtime.PYTHON_3_8,
            code: lambda.Code.fromAsset(path.join(__dirname, '../custom-resource-handler')),
            handler: 'global_index.on_event',
            timeout: cdk.Duration.minutes(5),
        });
        const UpgradeglobaldbProvider = new cr.Provider(this, 'UpgradeglobaldbProvider', {
            onEventHandler: onEvent,
            logRetention: logs.RetentionDays.ONE_DAY,
        });
        this.crGlobalRDSProvider = new cdk.CustomResource(this, 'CRUpgradeglobaldbProvider', {
            resourceType: 'Custom::UpgradeGlobalClusterProvider',
            serviceToken: UpgradeglobaldbProvider.serviceToken,
            properties: {
                SourceDBClusterIdentifier: `arn:aws:rds:${stack.region}:${stack.account}:cluster:${this.rdsCluster.clusterIdentifier}`,
                GlobalClusterIdentifier: `global-${stack.stackName.toLowerCase()}`,
            },
        });
        this.crGlobalRDSProvider.node.addDependency(this.rdsCluster);
        onEvent.role?.addToPrincipalPolicy(CustomResourcePolicy);
        this.rdsIsPublic = rdsVpcSubnetSelect;
        new cdk.CfnOutput(this, 'RDSisPublic', {
            value: this.rdsIsPublic,
        });
        this.rdsClusterarn = `arn:aws:rds:${stack.region}:${stack.account}:cluster:${this.rdsCluster.clusterIdentifier}`;
        new cdk.CfnOutput(this, 'RDSClusterarn', {
            value: this.rdsClusterarn,
        });
        this.globalClusterIdentifier = `global-${stack.stackName.toLowerCase()}`;
        new cdk.CfnOutput(this, 'GlobalClusterIdentifier', {
            value: this.globalClusterIdentifier,
        });
        this.engine = cdk.Token.asString(this.crGlobalRDSProvider.getAtt('Engine'));
        new cdk.CfnOutput(this, 'Engine', {
            value: this.engine,
        });
        this.clusterEngineVersion = cdk.Token.asString(this.crGlobalRDSProvider.getAtt('EngineVersion'));
        new cdk.CfnOutput(this, 'clusterEngineVersion', {
            value: this.clusterEngineVersion,
        });
        this.globalClusterArn = cdk.Token.asString(this.crGlobalRDSProvider.getAtt('GlobalClusterArn'));
        new cdk.CfnOutput(this, 'GlobalClusterArn', {
            value: this.globalClusterArn,
        });
        new cdk.CfnOutput(this, 'GlobalClusterPrimaryEndpoint', {
            value: this.rdsCluster.clusterEndpoint.hostname,
        });
    }
    azOfSubnets(subnets) {
        return new Set(subnets.map(subnet => subnet.availabilityZone)).size;
    }
    addRegionalCluster(scope, id, options) {
        const stack = cdk.Stack.of(scope);
        // custom resource policy
        const CustomResourcePolicy = new iam.PolicyStatement({
            resources: ['*'],
            actions: [
                'rds:CreateGlobalCluster', 'rds:DeleteGlobalCluster', 'rds:RemoveFromGlobalCluster', 'rds:ModifyGlobalCluster',
                'rds:CreateDBCluster', 'rds:CreateDBInstance', 'rds:DeleteDBCluster', 'rds:DeleteDBInstance', 'rds:DescribeDBInstances',
                'rds:DescribeGlobalClusters',
            ],
        });
        // Upgrade database to Global.
        const onEvent = new lambda.Function(scope, `${id}-addRegionalonEvent`, {
            runtime: lambda.Runtime.PYTHON_3_8,
            code: lambda.Code.fromAsset(path.join(__dirname, '../custom-resource-handler')),
            handler: 'add_region_index.on_event',
            timeout: cdk.Duration.minutes(10),
        });
        const isComplete = new lambda.Function(scope, `${id}-IsComplete`, {
            code: lambda.Code.fromAsset(path.join(__dirname, '../custom-resource-handler')),
            handler: 'add_region_index.is_complete',
            runtime: lambda.Runtime.PYTHON_3_8,
            timeout: cdk.Duration.minutes(10),
            role: onEvent.role,
        });
        const addRegionalProvider = new cr.Provider(scope, `${id}-addRegionalProvider`, {
            onEventHandler: onEvent,
            isCompleteHandler: isComplete,
            logRetention: logs.RetentionDays.ONE_DAY,
        });
        const secondRDSClusterArn = `arn:aws:rds:${options.region}:${stack.account}:cluster:${stack.stackName.toLowerCase()}-${options.region}`;
        const seconddbInstanceIdentifier = `${stack.stackName.toLowerCase()}-${options.region}-1`;
        const CRSecondRDSProvider = new cdk.CustomResource(scope, `${id}-addRegionalCustomResource`, {
            resourceType: 'Custom::addRegionalClusterProvider',
            serviceToken: addRegionalProvider.serviceToken,
            properties: {
                SourceDBClusterIdentifier: this.rdsClusterarn,
                GlobalClusterIdentifier: this.globalClusterIdentifier,
                REGION: options.region,
                DBSubnetGroupName: options.dbSubnetGroupName,
                Engine: this.engine,
                EngineVersion: this.clusterEngineVersion,
                ClusterIdentifier: `${stack.stackName.toLowerCase()}-${options.region}`,
                InstanceType: this.rdsInstanceType,
                rdsIsPublic: this.rdsIsPublic,
                secondRDSClusterArn,
                seconddbInstanceIdentifier,
                securityGroup: options.securityGroupId,
                dbParameterGroup: options.dbParameterGroup,
            },
        });
        CRSecondRDSProvider.node.addDependency(this.crGlobalRDSProvider);
        onEvent.role?.addToPrincipalPolicy(CustomResourcePolicy);
        new cdk.CfnOutput(scope, 'secondRDSClusterArn', {
            value: secondRDSClusterArn,
        });
        new cdk.CfnOutput(scope, 'seconddbInstanceIdentifier', {
            value: seconddbInstanceIdentifier,
        });
    }
}
exports.GlobalAuroraRDSMaster = GlobalAuroraRDSMaster;
_a = JSII_RTTI_SYMBOL_1;
GlobalAuroraRDSMaster[_a] = { fqn: "cdk-aurora-globaldatabase.GlobalAuroraRDSMaster", version: "1.1.615" };
class GlobalAuroraRDSSlaveInfra extends cdk.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const stack = cdk.Stack.of(this);
        if (GlobalAuroraRDSSupportRegion.indexOf(stack.region) == -1) {
            throw new Error(`This region ${stack.region} not Support Global RDS !!!`);
        }
        // Slave region Vpc
        const rdsVpcSecond = props?.vpc ?? new ec2.Vpc(this, 'RDSVpcRegionSlave', {
            cidr: '10.109.0.0/16',
            enableDnsHostnames: true,
            enableDnsSupport: true,
            natGateways: 1,
        });
        const DBsubnetType = props?.subnetType ?? ec2.SubnetType.PRIVATE;
        if (DBsubnetType === ec2.SubnetType.PUBLIC) {
            const PublicSubnet = rdsVpcSecond.selectSubnets({ subnetType: ec2.SubnetType.PUBLIC });
            this.dbSubnetGroup = new rds.CfnDBSubnetGroup(this, 'Subnets', {
                dbSubnetGroupName: `${stack.stackName.toLowerCase()}-publicsubnetgroup`,
                dbSubnetGroupDescription: 'Public Subnets for database',
                subnetIds: PublicSubnet.subnetIds,
            });
            cdk.Tags.of(this.dbSubnetGroup).add('Name', 'PublicDBSubnetGroup');
            this.dbSubnetGroup.node.addDependency(rdsVpcSecond);
        }
        else {
            const PrivateSubnet = rdsVpcSecond.selectSubnets({ subnetType: ec2.SubnetType.PRIVATE });
            this.dbSubnetGroup = new rds.CfnDBSubnetGroup(this, 'Subnets', {
                dbSubnetGroupName: `${stack.stackName.toLowerCase()}-privatesubnetgroup`,
                dbSubnetGroupDescription: 'Private Subnets for database',
                subnetIds: PrivateSubnet.subnetIds,
            });
            cdk.Tags.of(this.dbSubnetGroup).add('Name', 'PrivateDBSubnetGroup');
            this.dbSubnetGroup.node.addDependency(rdsVpcSecond);
        }
        new cdk.CfnOutput(this, 'newDBSubnetGroup', {
            value: `${this.dbSubnetGroup.dbSubnetGroupName}`,
        });
        new cdk.CfnOutput(this, 'stackRegion', {
            value: `${stack.region}`,
        });
    }
}
exports.GlobalAuroraRDSSlaveInfra = GlobalAuroraRDSSlaveInfra;
_b = JSII_RTTI_SYMBOL_1;
GlobalAuroraRDSSlaveInfra[_b] = { fqn: "cdk-aurora-globaldatabase.GlobalAuroraRDSSlaveInfra", version: "1.1.615" };
//# sourceMappingURL=data:application/json;base64,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