# mypy-boto3-storagegateway<a id="mypy-boto3-storagegateway"></a>

[![PyPI - mypy-boto3-storagegateway](https://img.shields.io/pypi/v/mypy-boto3-storagegateway.svg?color=blue)](https://pypi.org/project/mypy-boto3-storagegateway)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-storagegateway.svg?color=blue)](https://pypi.org/project/mypy-boto3-storagegateway)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/mypy-boto3-storagegateway?color=blue)](https://pypistats.org/packages/mypy-boto3-storagegateway)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.StorageGateway 1.17.70](https://boto3.amazonaws.com/v1/documentation/api/1.17.70/reference/services/storagegateway.html#StorageGateway)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-buider 4.11.1](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-storagegateway docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_storagegateway/)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-storagegateway](#mypy-boto3-storagegateway)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [Versioning](#versioning)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

## How to install<a id="how-to-install"></a>

Install `boto3-stubs` for `StorageGateway` service.

```bash
python -m pip install boto3-stubs[storagegateway]
```

## Usage<a id="usage"></a>

### VSCode<a id="vscode"></a>

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[storagegateway]` in your environment:
  `python -m pip install 'boto3-stubs[storagegateway]'`

Both type checking and auto-complete should work for `StorageGateway` service.
No explicit type annotations required, write your `boto3` code as usual.

### PyCharm<a id="pycharm"></a>

- Install `boto-stubs[storagegateway]` in your environment:
  `python -m pip install 'boto3-stubs[storagegateway]'`

Both type checking and auto-complete should work for `StorageGateway` service.
No explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed
`boto3-stubs` submodules.

### Other IDEs<a id="other-ides"></a>

Not tested, but as long as your IDE support `mypy` or `pyright`, everything
should work.

### mypy<a id="mypy"></a>

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[storagegateway]` in your environment:
  `python -m pip install 'boto3-stubs[storagegateway]'`
- Run `mypy` as usual

Type checking should work for `StorageGateway` service. No explicit type
annotations required, write your `boto3` code as usual.

### pyright<a id="pyright"></a>

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[storagegateway]` in your environment:
  `python -m pip install 'boto3-stubs[storagegateway]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `StorageGateway` service. No explicit type
annotations required, write your `boto3` code as usual.

## Explicit type annotations<a id="explicit-type-annotations"></a>

### Client annotations<a id="client-annotations"></a>

`StorageGatewayClient` provides annotations for
`boto3.client("storagegateway")`.

```python
import boto3

from mypy_boto3_storagegateway import StorageGatewayClient

client: StorageGatewayClient = boto3.client("storagegateway")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: StorageGatewayClient = session.client("storagegateway")
```

### Paginators annotations<a id="paginators-annotations"></a>

`mypy_boto3_storagegateway.paginator` module contains type annotations for all
paginators.

```python
from mypy_boto3_storagegateway import StorageGatewayClient
from mypy_boto3_storagegateway.paginator import (
    DescribeTapeArchivesPaginator,
    DescribeTapeRecoveryPointsPaginator,
    DescribeTapesPaginator,
    DescribeVTLDevicesPaginator,
    ListFileSharesPaginator,
    ListFileSystemAssociationsPaginator,
    ListGatewaysPaginator,
    ListTagsForResourcePaginator,
    ListTapePoolsPaginator,
    ListTapesPaginator,
    ListVolumesPaginator,
)

client: StorageGatewayClient = boto3.client("storagegateway")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
describe_tape_archives_paginator: DescribeTapeArchivesPaginator = client.get_paginator("describe_tape_archives")
describe_tape_recovery_points_paginator: DescribeTapeRecoveryPointsPaginator = client.get_paginator("describe_tape_recovery_points")
describe_tapes_paginator: DescribeTapesPaginator = client.get_paginator("describe_tapes")
describe_vtl_devices_paginator: DescribeVTLDevicesPaginator = client.get_paginator("describe_vtl_devices")
list_file_shares_paginator: ListFileSharesPaginator = client.get_paginator("list_file_shares")
list_file_system_associations_paginator: ListFileSystemAssociationsPaginator = client.get_paginator("list_file_system_associations")
list_gateways_paginator: ListGatewaysPaginator = client.get_paginator("list_gateways")
list_tags_for_resource_paginator: ListTagsForResourcePaginator = client.get_paginator("list_tags_for_resource")
list_tape_pools_paginator: ListTapePoolsPaginator = client.get_paginator("list_tape_pools")
list_tapes_paginator: ListTapesPaginator = client.get_paginator("list_tapes")
list_volumes_paginator: ListVolumesPaginator = client.get_paginator("list_volumes")
```

### Literals<a id="literals"></a>

`mypy_boto3_storagegateway.literals` module contains literals extracted from
shapes that can be used in user code for type checking.

```python
from mypy_boto3_storagegateway.literals import (
    ActiveDirectoryStatus,
    AvailabilityMonitorTestStatus,
    CaseSensitivity,
    DescribeTapeArchivesPaginatorName,
    DescribeTapeRecoveryPointsPaginatorName,
    DescribeTapesPaginatorName,
    DescribeVTLDevicesPaginatorName,
    FileShareType,
    HostEnvironment,
    ListFileSharesPaginatorName,
    ListFileSystemAssociationsPaginatorName,
    ListGatewaysPaginatorName,
    ListTagsForResourcePaginatorName,
    ListTapePoolsPaginatorName,
    ListTapesPaginatorName,
    ListVolumesPaginatorName,
    ObjectACL,
    PoolStatus,
    RetentionLockType,
    SMBSecurityStrategy,
    TapeStorageClass,
)

def check_value(value: ActiveDirectoryStatus) -> bool:
    ...
```

### Typed dictionaries<a id="typed-dictionaries"></a>

`mypy_boto3_storagegateway.type_defs` module contains structures and shapes
assembled to typed dictionaries for additional type checking.

```python
from mypy_boto3_storagegateway.type_defs import (
    ActivateGatewayOutputTypeDef,
    AddCacheOutputTypeDef,
    AddTagsToResourceOutputTypeDef,
    AddUploadBufferOutputTypeDef,
    AddWorkingStorageOutputTypeDef,
    AssignTapePoolOutputTypeDef,
    AssociateFileSystemOutputTypeDef,
    AttachVolumeOutputTypeDef,
    AutomaticTapeCreationPolicyInfoTypeDef,
    AutomaticTapeCreationRuleTypeDef,
    BandwidthRateLimitIntervalTypeDef,
    CacheAttributesTypeDef,
    CachediSCSIVolumeTypeDef,
    CancelArchivalOutputTypeDef,
    CancelRetrievalOutputTypeDef,
    ChapInfoTypeDef,
    CreateCachediSCSIVolumeOutputTypeDef,
    CreateNFSFileShareOutputTypeDef,
    CreateSMBFileShareOutputTypeDef,
    CreateSnapshotFromVolumeRecoveryPointOutputTypeDef,
    CreateSnapshotOutputTypeDef,
    CreateStorediSCSIVolumeOutputTypeDef,
    CreateTapePoolOutputTypeDef,
    CreateTapeWithBarcodeOutputTypeDef,
    CreateTapesOutputTypeDef,
    DeleteAutomaticTapeCreationPolicyOutputTypeDef,
    DeleteBandwidthRateLimitOutputTypeDef,
    DeleteChapCredentialsOutputTypeDef,
    DeleteFileShareOutputTypeDef,
    DeleteGatewayOutputTypeDef,
    DeleteSnapshotScheduleOutputTypeDef,
    DeleteTapeArchiveOutputTypeDef,
    DeleteTapeOutputTypeDef,
    DeleteTapePoolOutputTypeDef,
    DeleteVolumeOutputTypeDef,
    DescribeAvailabilityMonitorTestOutputTypeDef,
    DescribeBandwidthRateLimitOutputTypeDef,
    DescribeBandwidthRateLimitScheduleOutputTypeDef,
    DescribeCacheOutputTypeDef,
    DescribeCachediSCSIVolumesOutputTypeDef,
    DescribeChapCredentialsOutputTypeDef,
    DescribeFileSystemAssociationsOutputTypeDef,
    DescribeGatewayInformationOutputTypeDef,
    DescribeMaintenanceStartTimeOutputTypeDef,
    DescribeNFSFileSharesOutputTypeDef,
    DescribeSMBFileSharesOutputTypeDef,
    DescribeSMBSettingsOutputTypeDef,
    DescribeSnapshotScheduleOutputTypeDef,
    DescribeStorediSCSIVolumesOutputTypeDef,
    DescribeTapeArchivesOutputTypeDef,
    DescribeTapeRecoveryPointsOutputTypeDef,
    DescribeTapesOutputTypeDef,
    DescribeUploadBufferOutputTypeDef,
    DescribeVTLDevicesOutputTypeDef,
    DescribeWorkingStorageOutputTypeDef,
    DetachVolumeOutputTypeDef,
    DeviceiSCSIAttributesTypeDef,
    DisableGatewayOutputTypeDef,
    DisassociateFileSystemOutputTypeDef,
    DiskTypeDef,
    FileShareInfoTypeDef,
    FileSystemAssociationInfoTypeDef,
    FileSystemAssociationSummaryTypeDef,
    GatewayInfoTypeDef,
    JoinDomainOutputTypeDef,
    ListAutomaticTapeCreationPoliciesOutputTypeDef,
    ListFileSharesOutputTypeDef,
    ListFileSystemAssociationsOutputTypeDef,
    ListGatewaysOutputTypeDef,
    ListLocalDisksOutputTypeDef,
    ListTagsForResourceOutputTypeDef,
    ListTapePoolsOutputTypeDef,
    ListTapesOutputTypeDef,
    ListVolumeInitiatorsOutputTypeDef,
    ListVolumeRecoveryPointsOutputTypeDef,
    ListVolumesOutputTypeDef,
    NFSFileShareDefaultsTypeDef,
    NFSFileShareInfoTypeDef,
    NetworkInterfaceTypeDef,
    NotifyWhenUploadedOutputTypeDef,
    PaginatorConfigTypeDef,
    PoolInfoTypeDef,
    RefreshCacheOutputTypeDef,
    RemoveTagsFromResourceOutputTypeDef,
    ResetCacheOutputTypeDef,
    ResponseMetadata,
    RetrieveTapeArchiveOutputTypeDef,
    RetrieveTapeRecoveryPointOutputTypeDef,
    SMBFileShareInfoTypeDef,
    SetLocalConsolePasswordOutputTypeDef,
    SetSMBGuestPasswordOutputTypeDef,
    ShutdownGatewayOutputTypeDef,
    StartAvailabilityMonitorTestOutputTypeDef,
    StartGatewayOutputTypeDef,
    StorediSCSIVolumeTypeDef,
    TagTypeDef,
    TapeArchiveTypeDef,
    TapeInfoTypeDef,
    TapeRecoveryPointInfoTypeDef,
    TapeTypeDef,
    UpdateAutomaticTapeCreationPolicyOutputTypeDef,
    UpdateBandwidthRateLimitOutputTypeDef,
    UpdateBandwidthRateLimitScheduleOutputTypeDef,
    UpdateChapCredentialsOutputTypeDef,
    UpdateFileSystemAssociationOutputTypeDef,
    UpdateGatewayInformationOutputTypeDef,
    UpdateGatewaySoftwareNowOutputTypeDef,
    UpdateMaintenanceStartTimeOutputTypeDef,
    UpdateNFSFileShareOutputTypeDef,
    UpdateSMBFileShareOutputTypeDef,
    UpdateSMBFileShareVisibilityOutputTypeDef,
    UpdateSMBSecurityStrategyOutputTypeDef,
    UpdateSnapshotScheduleOutputTypeDef,
    UpdateVTLDeviceTypeOutputTypeDef,
    VTLDeviceTypeDef,
    VolumeInfoTypeDef,
    VolumeRecoveryPointInfoTypeDef,
    VolumeiSCSIAttributesTypeDef,
)

def get_structure() -> ActivateGatewayOutputTypeDef:
    return {
      ...
    }
```

## Versioning<a id="versioning"></a>

`mypy-boto3-storagegateway` version is the same as related `boto3` version and
follows [PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

## Documentation<a id="documentation"></a>

All type annotations can be found in
[mypy-boto3-storagegateway docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_storagegateway/)

## Support and contributing<a id="support-and-contributing"></a>

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/vemel/mypy_boto3_builder/issues/)
repository.
