"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GolbalAuroraRDSSlaveInfra = exports.GolbalAuroraRDSMaster = exports.InstanceTypeEnum = exports.MySQLtimeZone = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const ec2 = require("@aws-cdk/aws-ec2");
const iam = require("@aws-cdk/aws-iam");
const lambda = require("@aws-cdk/aws-lambda");
const logs = require("@aws-cdk/aws-logs");
const rds = require("@aws-cdk/aws-rds");
const cdk = require("@aws-cdk/core");
const cr = require("@aws-cdk/custom-resources");
/**
 * @experimental
 */
var MySQLtimeZone;
(function (MySQLtimeZone) {
    MySQLtimeZone["UTC"] = "UTC";
    MySQLtimeZone["ASIA_TAIPEI"] = "Asia/Taipei";
    MySQLtimeZone["AFRICA_CAIRO"] = "Africa/Cairo";
    MySQLtimeZone["ASIA_BANGKOK"] = "Asia/Bangkok";
    MySQLtimeZone["AUSTRALIA_DARWIN"] = "Australia/Darwin";
    MySQLtimeZone["AFRICA_CASABLANCA"] = "Africa/Casablanca";
    MySQLtimeZone["ASIA_BEIRUT"] = "Asia/Beirut";
    MySQLtimeZone["AUSTRALIA_HOBART"] = "Australia/Hobart";
    MySQLtimeZone["AFRICA_HARARE"] = "Africa/Harare";
    MySQLtimeZone["ASIA_CALCUTTA"] = "Asia/Calcutta";
    MySQLtimeZone["AUSTRALIA_PERTH"] = "Australia/Perth";
    MySQLtimeZone["AFRICA_MONROVIA"] = "Africa/Monrovia";
    MySQLtimeZone["ASIA_DAMASCUS"] = "Asia/Damascus";
    MySQLtimeZone["AUSTRALIA_SYDNEY"] = "Australia/Sydney";
    MySQLtimeZone["AFRICA_NAIROBI"] = "Africa/Nairobi";
    MySQLtimeZone["ASIA_DHAKA"] = "Asia/Dhaka";
    MySQLtimeZone["BRAZIL_EAST"] = "Brazil/East";
    MySQLtimeZone["AFRICA_TRIPOLI"] = "Africa/Tripoli";
    MySQLtimeZone["ASIA_IRKUTSK"] = "Asia/Irkutsk";
    MySQLtimeZone["CANADA_NEWFOUNDLAND"] = "Canada/Newfoundland";
    MySQLtimeZone["AFRICA_WINDHOEK"] = "Africa/Windhoek";
    MySQLtimeZone["ASIA_JERUSALEM"] = "Asia/Jerusalem";
    MySQLtimeZone["CANADA_SASKATCHEWAN"] = "Canada/Saskatchewan";
    MySQLtimeZone["AMERICA_ARAGUAINA"] = "America/Araguaina";
    MySQLtimeZone["ASIA_KABUL"] = "Asia/Kabul";
    MySQLtimeZone["EUROPE_AMSTERDAM"] = "Europe/Amsterdam";
    MySQLtimeZone["AMERICA_ASUNCION"] = "America/Asuncion";
    MySQLtimeZone["ASIA_KARACHI"] = "Asia/Karachi";
    MySQLtimeZone["EUROPE_ATHENS"] = "Europe/Athens";
    MySQLtimeZone["AMERICA_BOGOTA"] = "America/Bogota";
    MySQLtimeZone["ASIA_KATHMANDU"] = "Asia/Kathmandu";
    MySQLtimeZone["EUROPE_DUBLIN"] = "Europe/Dublin";
    MySQLtimeZone["AMERICA_CARACAS"] = "America/Caracas";
    MySQLtimeZone["ASIA_KRASNOYARSK"] = "Asia/Krasnoyarsk";
    MySQLtimeZone["EUROPE_HELSINKI"] = "Europe/Helsinki";
    MySQLtimeZone["AMERICA_CHIHUAHUA"] = "America/Chihuahua";
    MySQLtimeZone["ASIA_MAGADAN"] = "Asia/Magadan";
    MySQLtimeZone["EUROPE_ISTANBUL"] = "Europe/Istanbul";
    MySQLtimeZone["AMERICA_CUIABA"] = "America/Cuiaba";
    MySQLtimeZone["ASIA_MUSCAT"] = "Asia/Muscat";
    MySQLtimeZone["EUROPE_KALININGRAD"] = "Europe/Kaliningrad";
    MySQLtimeZone["AMERICA_DENVER"] = "America/Denver";
    MySQLtimeZone["ASIA_NOVOSIBIRSK"] = "Asia/Novosibirsk";
    MySQLtimeZone["EUROPE_MOSCOW"] = "Europe/Moscow";
    MySQLtimeZone["AMERICA_FORTALEZA"] = "America/Fortaleza";
    MySQLtimeZone["ASIA_RIYADH"] = "Asia/Riyadh";
    MySQLtimeZone["EUROPE_PARIS"] = "Europe/Paris";
    MySQLtimeZone["AMERICA_GUATEMALA"] = "America/Guatemala";
    MySQLtimeZone["ASIA_SEOUL"] = "Asia/Seoul";
    MySQLtimeZone["EUROPE_PRAGUE"] = "Europe/Prague";
    MySQLtimeZone["AMERICA_HALIFAX"] = "America/Halifax";
    MySQLtimeZone["ASIA_SHANGHAI"] = "Asia/Shanghai";
    MySQLtimeZone["EUROPE_SARAJEVO"] = "Europe/Sarajevo";
    MySQLtimeZone["AMERICA_MANAUS"] = "America/Manaus";
    MySQLtimeZone["ASIA_SINGAPORE"] = "Asia/Singapore";
    MySQLtimeZone["PACIFIC_AUCKLAND"] = "Pacific/Auckland";
    MySQLtimeZone["AMERICA_MATAMOROS"] = "America/Matamoros";
    MySQLtimeZone["PACIFIC_FIJI"] = "Pacific/Fiji";
    MySQLtimeZone["AMERICA_MONTERREY"] = "America/Monterrey";
    MySQLtimeZone["ASIA_TEHRAN"] = "Asia/Tehran";
    MySQLtimeZone["PACIFIC_GUAM"] = "Pacific/Guam";
    MySQLtimeZone["AMERICA_MONTEVIDEO"] = "America/Montevideo";
    MySQLtimeZone["ASIA_TOKYO"] = "Asia/Tokyo";
    MySQLtimeZone["PACIFIC_HONOLULU"] = "Pacific/Honolulu";
    MySQLtimeZone["AMERICA_PHOENIX"] = "America/Phoenix";
    MySQLtimeZone["ASIA_ULAANBAATAR"] = "Asia/Ulaanbaatar";
    MySQLtimeZone["PACIFIC_SAMOA"] = "Pacific/Samoa";
    MySQLtimeZone["AMERICA_SANTIAGO"] = "America/Santiago";
    MySQLtimeZone["ASIA_VLADIVOSTOK"] = "Asia/Vladivostok";
    MySQLtimeZone["US_ALASKA"] = "US/Alaska";
    MySQLtimeZone["AMERICA_TIJUANA"] = "America/Tijuana";
    MySQLtimeZone["ASIA_YAKUTSK"] = "Asia/Yakutsk";
    MySQLtimeZone["US_CENTRAL"] = "US/Central";
    MySQLtimeZone["ASIA_AMMAN"] = "Asia/Amman";
    MySQLtimeZone["ASIA_YEREVAN"] = "Asia/Yerevan";
    MySQLtimeZone["US_EASTERN"] = "US/Eastern";
    MySQLtimeZone["ASIA_ASHGABAT"] = "Asia/Ashgabat";
    MySQLtimeZone["ATLANTIC_AZORES"] = "Atlantic/Azores";
    MySQLtimeZone["US_EAST_INDIANA"] = "US/East-Indiana";
    MySQLtimeZone["ASIA_BAGHDAD"] = "Asia/Baghdad";
    MySQLtimeZone["AUSTRALIA_ADELAIDE"] = "Australia/Adelaide";
    MySQLtimeZone["US_PACIFIC"] = "US/Pacific";
    MySQLtimeZone["ASIA_BAKU"] = "Asia/Baku";
    MySQLtimeZone["AUSTRALIA_BRISBANE"] = "Australia/Brisbane";
})(MySQLtimeZone = exports.MySQLtimeZone || (exports.MySQLtimeZone = {}));
/**
 * @experimental
 */
var InstanceTypeEnum;
(function (InstanceTypeEnum) {
    InstanceTypeEnum["R4_LARGE"] = "r4.large";
    InstanceTypeEnum["R4_XLARGE"] = "r4.xlarge";
    InstanceTypeEnum["R4_2XLARGE"] = "r4.2xlarge";
    InstanceTypeEnum["R4_4XLARGE"] = "r4.4xlarge";
    InstanceTypeEnum["R4_8XLARGE"] = "r4.8xlarge";
    InstanceTypeEnum["R4_16XLARGE"] = "r4.16xlarge";
    InstanceTypeEnum["R5_LARGE"] = "r5.large";
    InstanceTypeEnum["R5_XLARGE"] = "r5.xlarge";
    InstanceTypeEnum["R5_2XLARGE"] = "r5.2xlarge";
    InstanceTypeEnum["R5_4XLARGE"] = "r5.4xlarge";
    InstanceTypeEnum["R5_8XLARGE"] = "r5.8xlarge";
    InstanceTypeEnum["R5_12XLARGE"] = "r5.12xlarge";
    InstanceTypeEnum["R5_16XLARGE"] = "r5.16xlarge";
    InstanceTypeEnum["R5_24XLARGE"] = "r5.24xlarge";
})(InstanceTypeEnum = exports.InstanceTypeEnum || (exports.InstanceTypeEnum = {}));
const GlobalAuroraRDSSupportRegion = ['us-east-1', 'us-east-2', 'us-west-1', 'us-west-2', 'eu-west-1', 'eu-west-2', 'eu-west-3', 'eu-central-1',
    'ap-south-1', 'ap-southeast-1', 'ap-southeast-2', 'ap-northeast-1', 'ap-northeast-2', 'ca-central-1'];
/**
 * @experimental
 */
class GolbalAuroraRDSMaster extends cdk.Construct {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        var _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p;
        super(scope, id);
        const stack = cdk.Stack.of(this);
        if (GlobalAuroraRDSSupportRegion.indexOf(stack.region) == -1) {
            throw new Error(`This region ${stack.region} not Support Global RDS !!!`);
        }
        let rdsCredentials;
        if (props === null || props === void 0 ? void 0 : props.rdsPassword) {
            rdsCredentials = {
                username: (_c = props === null || props === void 0 ? void 0 : props.dbUserName) !== null && _c !== void 0 ? _c : 'sysadmin',
                password: cdk.SecretValue.plainText(props === null || props === void 0 ? void 0 : props.rdsPassword),
            };
        }
        else {
            rdsCredentials = {
                username: (_d = props === null || props === void 0 ? void 0 : props.dbUserName) !== null && _d !== void 0 ? _d : 'sysadmin',
            };
        }
        ;
        // Mysql need (MySQL 5.6 / version > 5.6.10a) , Postgres need (version 10.11 , 10.12 , 11.7 or later)
        this.engineVersion = (_e = props === null || props === void 0 ? void 0 : props.engineVersion) !== null && _e !== void 0 ? _e : rds.DatabaseClusterEngine.auroraMysql({
            version: rds.AuroraMysqlEngineVersion.VER_2_07_1,
        });
        this.rdsInstanceType = (_f = props === null || props === void 0 ? void 0 : props.instanceType) !== null && _f !== void 0 ? _f : InstanceTypeEnum.R5_LARGE;
        // Master region Vpc
        const rdsVpc = (_g = props === null || props === void 0 ? void 0 : props.vpc) !== null && _g !== void 0 ? _g : new ec2.Vpc(this, 'RDSVpcRegionMaster', {
            cidr: '10.108.0.0/16',
            enableDnsHostnames: true,
            enableDnsSupport: true,
            natGateways: 1,
        });
        this.dbClusterpPG = (_h = props === null || props === void 0 ? void 0 : props.dbClusterpPG) !== null && _h !== void 0 ? _h : new rds.ParameterGroup(this, 'dbClusterparametergroup', {
            engine: this.engineVersion,
            parameters: (_j = props === null || props === void 0 ? void 0 : props.parameters) !== null && _j !== void 0 ? _j : {
                time_zone: (_k = props === null || props === void 0 ? void 0 : props.timeZone) !== null && _k !== void 0 ? _k : MySQLtimeZone.UTC,
            },
        });
        let rdsVpcSubnetSelect = ec2.SubnetType.PRIVATE;
        if (this.azOfSubnets(rdsVpc.privateSubnets) === 0) {
            rdsVpcSubnetSelect = ec2.SubnetType.PUBLIC;
        }
        this.rdsCluster = new rds.DatabaseCluster(this, 'RDSCluster', {
            engine: this.engineVersion,
            parameterGroup: this.dbClusterpPG,
            clusterIdentifier: `${stack.stackName.toLowerCase()}-primary`,
            credentials: rdsCredentials,
            instances: 1,
            instanceProps: {
                // if want publicAccess , need to define vpcSubnets: { subnetType: ec2.SubnetType.PUBLIC } ,
                vpc: rdsVpc,
                vpcSubnets: { subnetType: rdsVpcSubnetSelect },
                instanceType: new ec2.InstanceType(this.rdsInstanceType),
            },
            removalPolicy: cdk.RemovalPolicy.DESTROY,
            defaultDatabaseName: (_l = props === null || props === void 0 ? void 0 : props.defaultDatabaseName) !== null && _l !== void 0 ? _l : 'globaldatabase',
        });
        this.rdsPassword = (_o = `Please use this command get password back , aws secretsmanager get-secret-value --secret-id ${(_m = this.rdsCluster.secret) === null || _m === void 0 ? void 0 : _m.secretName}`) !== null && _o !== void 0 ? _o : props === null || props === void 0 ? void 0 : props.rdsPassword;
        ;
        this.rdsCluster.node.addDependency(rdsVpc);
        this.rdsCluster.connections.allowDefaultPortFrom(ec2.Peer.ipv4(rdsVpc.vpcCidrBlock));
        // custom resource policy
        const CustomResourcePolicy = new iam.PolicyStatement({
            resources: ['*'],
            actions: ['rds:CreateGlobalCluster', 'rds:DeleteGlobalCluster', 'rds:RemoveFromGlobalCluster', 'rds:ModifyGlobalCluster'],
        });
        // Upgrade database to Global.
        const onEvent = new lambda.Function(this, 'onEventHandler', {
            runtime: lambda.Runtime.PYTHON_3_8,
            code: lambda.Code.fromAsset(path.join(__dirname, '../custom-resource-handler')),
            handler: 'global_index.on_event',
            timeout: cdk.Duration.minutes(5),
        });
        const UpgradeglobaldbProvider = new cr.Provider(this, 'UpgradeglobaldbProvider', {
            onEventHandler: onEvent,
            logRetention: logs.RetentionDays.ONE_DAY,
        });
        this.crGlobalRDSProvider = new cdk.CustomResource(this, 'CRUpgradeglobaldbProvider', {
            resourceType: 'Custom::UpgradeGlobalClusterProvider',
            serviceToken: UpgradeglobaldbProvider.serviceToken,
            properties: {
                SourceDBClusterIdentifier: `arn:aws:rds:${stack.region}:${stack.account}:cluster:${this.rdsCluster.clusterIdentifier}`,
                GlobalClusterIdentifier: `global-${stack.stackName.toLowerCase()}`,
            },
        });
        this.crGlobalRDSProvider.node.addDependency(this.rdsCluster);
        (_p = onEvent.role) === null || _p === void 0 ? void 0 : _p.addToPrincipalPolicy(CustomResourcePolicy);
        this.rdsIsPublic = rdsVpcSubnetSelect;
        new cdk.CfnOutput(this, 'RDSisPublic', {
            value: this.rdsIsPublic,
        });
        this.rdsClusterarn = `arn:aws:rds:${stack.region}:${stack.account}:cluster:${this.rdsCluster.clusterIdentifier}`;
        new cdk.CfnOutput(this, 'RDSClusterarn', {
            value: this.rdsClusterarn,
        });
        this.globalClusterIdentifier = `global-${stack.stackName.toLowerCase()}`;
        new cdk.CfnOutput(this, 'GlobalClusterIdentifier', {
            value: this.globalClusterIdentifier,
        });
        this.engine = cdk.Token.asString(this.crGlobalRDSProvider.getAtt('Engine'));
        new cdk.CfnOutput(this, 'Engine', {
            value: this.engine,
        });
        this.clusterEngineVersion = cdk.Token.asString(this.crGlobalRDSProvider.getAtt('EngineVersion'));
        new cdk.CfnOutput(this, 'clusterEngineVersion', {
            value: this.clusterEngineVersion,
        });
        this.globalClusterArn = cdk.Token.asString(this.crGlobalRDSProvider.getAtt('GlobalClusterArn'));
        new cdk.CfnOutput(this, 'GlobalClusterArn', {
            value: this.globalClusterArn,
        });
        new cdk.CfnOutput(this, 'GlobalClusterPrimaryEndpoint', {
            value: this.rdsCluster.clusterEndpoint.hostname,
        });
    }
    azOfSubnets(subnets) {
        return new Set(subnets.map(subnet => subnet.availabilityZone)).size;
    }
    /**
     * @experimental
     */
    addRegionalCluster(scope, id, options) {
        var _c;
        const stack = cdk.Stack.of(scope);
        // custom resource policy
        const CustomResourcePolicy = new iam.PolicyStatement({
            resources: ['*'],
            actions: [
                'rds:CreateGlobalCluster', 'rds:DeleteGlobalCluster', 'rds:RemoveFromGlobalCluster', 'rds:ModifyGlobalCluster',
                'rds:CreateDBCluster', 'rds:CreateDBInstance', 'rds:DeleteDBCluster', 'rds:DeleteDBInstance', 'rds:DescribeDBInstances',
                'rds:DescribeGlobalClusters',
            ],
        });
        // Upgrade database to Global.
        const onEvent = new lambda.Function(scope, `${id}-addRegionalonEvent`, {
            runtime: lambda.Runtime.PYTHON_3_8,
            code: lambda.Code.fromAsset(path.join(__dirname, '../custom-resource-handler')),
            handler: 'add_region_index.on_event',
            timeout: cdk.Duration.minutes(10),
        });
        const isComplete = new lambda.Function(scope, `${id}-IsComplete`, {
            code: lambda.Code.fromAsset(path.join(__dirname, '../custom-resource-handler')),
            handler: 'add_region_index.is_complete',
            runtime: lambda.Runtime.PYTHON_3_8,
            timeout: cdk.Duration.minutes(10),
            role: onEvent.role,
        });
        const addRegionalProvider = new cr.Provider(scope, `${id}-addRegionalProvider`, {
            onEventHandler: onEvent,
            isCompleteHandler: isComplete,
            logRetention: logs.RetentionDays.ONE_DAY,
        });
        const CRSecondRDSProvider = new cdk.CustomResource(scope, `${id}-addRegionalCustomResource`, {
            resourceType: 'Custom::addRegionalClusterProvider',
            serviceToken: addRegionalProvider.serviceToken,
            properties: {
                SourceDBClusterIdentifier: this.rdsClusterarn,
                GlobalClusterIdentifier: this.globalClusterIdentifier,
                REGION: options.region,
                DBSubnetGroupName: options.dbSubnetGroupName,
                Engine: this.engine,
                EngineVersion: this.clusterEngineVersion,
                ClusterIdentifier: `${stack.stackName.toLowerCase()}-${options.region}`,
                InstanceType: this.rdsInstanceType,
                rdsIsPublic: this.rdsIsPublic,
                secondRDSClusterArn: `arn:aws:rds:${options.region}:${stack.account}:cluster:${stack.stackName.toLowerCase()}-${options.region}`,
                seconddbInstanceIdentifier: `${stack.stackName.toLowerCase()}-${options.region}-1`,
            },
        });
        CRSecondRDSProvider.node.addDependency(this.crGlobalRDSProvider);
        (_c = onEvent.role) === null || _c === void 0 ? void 0 : _c.addToPrincipalPolicy(CustomResourcePolicy);
        new cdk.CfnOutput(scope, 'secondRDSClusterArn', {
            value: cdk.Token.asString(CRSecondRDSProvider.getAtt('secondRDSClusterArn')),
        });
        new cdk.CfnOutput(scope, 'seconddbInstanceIdentifier', {
            value: cdk.Token.asString(CRSecondRDSProvider.getAtt('seconddbInstanceIdentifier')),
        });
    }
}
exports.GolbalAuroraRDSMaster = GolbalAuroraRDSMaster;
_a = JSII_RTTI_SYMBOL_1;
GolbalAuroraRDSMaster[_a] = { fqn: "cdk-aurora-globaldatabase.GolbalAuroraRDSMaster", version: "1.0.20" };
/**
 * @experimental
 */
class GolbalAuroraRDSSlaveInfra extends cdk.Construct {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        var _c, _d;
        super(scope, id);
        const stack = cdk.Stack.of(this);
        if (GlobalAuroraRDSSupportRegion.indexOf(stack.region) == -1) {
            throw new Error(`This region ${stack.region} not Support Global RDS !!!`);
        }
        // Slave region Vpc
        const rdsVpcSecond = (_c = props === null || props === void 0 ? void 0 : props.vpc) !== null && _c !== void 0 ? _c : new ec2.Vpc(this, 'RDSVpcRegionSlave', {
            cidr: '10.109.0.0/16',
            enableDnsHostnames: true,
            enableDnsSupport: true,
            natGateways: 1,
        });
        const DBsubnetType = (_d = props === null || props === void 0 ? void 0 : props.subnetType) !== null && _d !== void 0 ? _d : ec2.SubnetType.PRIVATE;
        if (DBsubnetType === ec2.SubnetType.PRIVATE) {
            const PrivateSubnet = rdsVpcSecond.selectSubnets({ subnetType: ec2.SubnetType.PRIVATE });
            this.dbSubnetGroup = new rds.CfnDBSubnetGroup(this, 'Subnets', {
                dbSubnetGroupName: `${stack.stackName.toLowerCase()}-privatesubnetgroup`,
                dbSubnetGroupDescription: 'Private Subnets for database',
                subnetIds: PrivateSubnet.subnetIds,
            });
            cdk.Tags.of(this.dbSubnetGroup).add('Name', 'PrivateDBSubnetGroup');
            this.dbSubnetGroup.node.addDependency(rdsVpcSecond);
        }
        else {
            const PublicSubnet = rdsVpcSecond.selectSubnets({ subnetType: ec2.SubnetType.PUBLIC });
            this.dbSubnetGroup = new rds.CfnDBSubnetGroup(this, 'Subnets', {
                dbSubnetGroupName: `${stack.stackName.toLowerCase()}-publicsubnetgroup`,
                dbSubnetGroupDescription: 'Public Subnets for database',
                subnetIds: PublicSubnet.subnetIds,
            });
            cdk.Tags.of(this.dbSubnetGroup).add('Name', 'PublicDBSubnetGroup');
            this.dbSubnetGroup.node.addDependency(rdsVpcSecond);
        }
        new cdk.CfnOutput(this, 'newDBSubnetGroup', {
            value: `${this.dbSubnetGroup.dbSubnetGroupName}`,
        });
        new cdk.CfnOutput(this, 'stackRegion', {
            value: `${stack.region}`,
        });
    }
}
exports.GolbalAuroraRDSSlaveInfra = GolbalAuroraRDSSlaveInfra;
_b = JSII_RTTI_SYMBOL_1;
GolbalAuroraRDSSlaveInfra[_b] = { fqn: "cdk-aurora-globaldatabase.GolbalAuroraRDSSlaveInfra", version: "1.0.20" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi9zcmMvaW5kZXgudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFBQSw2QkFBNkI7QUFDN0Isd0NBQXdDO0FBQ3hDLHdDQUF3QztBQUN4Qyw4Q0FBOEM7QUFDOUMsMENBQTBDO0FBQzFDLHdDQUF3QztBQUN4QyxxQ0FBcUM7QUFDckMsZ0RBQWdEOzs7O0FBR2hELElBQVksYUF5S1g7QUF6S0QsV0FBWSxhQUFhO0lBRXZCLDRCQUFXLENBQUE7SUFFWCw0Q0FBMkIsQ0FBQTtJQUUzQiw4Q0FBNkIsQ0FBQTtJQUU3Qiw4Q0FBNkIsQ0FBQTtJQUU3QixzREFBcUMsQ0FBQTtJQUVyQyx3REFBdUMsQ0FBQTtJQUV2Qyw0Q0FBMkIsQ0FBQTtJQUUzQixzREFBcUMsQ0FBQTtJQUVyQyxnREFBK0IsQ0FBQTtJQUUvQixnREFBK0IsQ0FBQTtJQUUvQixvREFBbUMsQ0FBQTtJQUVuQyxvREFBbUMsQ0FBQTtJQUVuQyxnREFBK0IsQ0FBQTtJQUUvQixzREFBcUMsQ0FBQTtJQUVyQyxrREFBaUMsQ0FBQTtJQUVqQywwQ0FBeUIsQ0FBQTtJQUV6Qiw0Q0FBMkIsQ0FBQTtJQUUzQixrREFBaUMsQ0FBQTtJQUVqQyw4Q0FBNkIsQ0FBQTtJQUU3Qiw0REFBMkMsQ0FBQTtJQUUzQyxvREFBbUMsQ0FBQTtJQUVuQyxrREFBaUMsQ0FBQTtJQUVqQyw0REFBMkMsQ0FBQTtJQUUzQyx3REFBdUMsQ0FBQTtJQUV2QywwQ0FBeUIsQ0FBQTtJQUV6QixzREFBcUMsQ0FBQTtJQUVyQyxzREFBcUMsQ0FBQTtJQUVyQyw4Q0FBNkIsQ0FBQTtJQUU3QixnREFBK0IsQ0FBQTtJQUUvQixrREFBaUMsQ0FBQTtJQUVqQyxrREFBaUMsQ0FBQTtJQUVqQyxnREFBK0IsQ0FBQTtJQUUvQixvREFBbUMsQ0FBQTtJQUVuQyxzREFBcUMsQ0FBQTtJQUVyQyxvREFBbUMsQ0FBQTtJQUVuQyx3REFBdUMsQ0FBQTtJQUV2Qyw4Q0FBNkIsQ0FBQTtJQUU3QixvREFBbUMsQ0FBQTtJQUVuQyxrREFBaUMsQ0FBQTtJQUVqQyw0Q0FBMkIsQ0FBQTtJQUUzQiwwREFBeUMsQ0FBQTtJQUV6QyxrREFBaUMsQ0FBQTtJQUVqQyxzREFBcUMsQ0FBQTtJQUVyQyxnREFBK0IsQ0FBQTtJQUUvQix3REFBdUMsQ0FBQTtJQUV2Qyw0Q0FBMkIsQ0FBQTtJQUUzQiw4Q0FBNkIsQ0FBQTtJQUU3Qix3REFBdUMsQ0FBQTtJQUV2QywwQ0FBeUIsQ0FBQTtJQUV6QixnREFBK0IsQ0FBQTtJQUUvQixvREFBbUMsQ0FBQTtJQUVuQyxnREFBK0IsQ0FBQTtJQUUvQixvREFBbUMsQ0FBQTtJQUVuQyxrREFBaUMsQ0FBQTtJQUVqQyxrREFBaUMsQ0FBQTtJQUVqQyxzREFBcUMsQ0FBQTtJQUVyQyx3REFBdUMsQ0FBQTtJQUV2Qyw4Q0FBNkIsQ0FBQTtJQUU3Qix3REFBdUMsQ0FBQTtJQUV2Qyw0Q0FBMkIsQ0FBQTtJQUUzQiw4Q0FBNkIsQ0FBQTtJQUU3QiwwREFBeUMsQ0FBQTtJQUV6QywwQ0FBeUIsQ0FBQTtJQUV6QixzREFBcUMsQ0FBQTtJQUVyQyxvREFBbUMsQ0FBQTtJQUVuQyxzREFBcUMsQ0FBQTtJQUVyQyxnREFBK0IsQ0FBQTtJQUUvQixzREFBcUMsQ0FBQTtJQUVyQyxzREFBcUMsQ0FBQTtJQUVyQyx3Q0FBdUIsQ0FBQTtJQUV2QixvREFBbUMsQ0FBQTtJQUVuQyw4Q0FBNkIsQ0FBQTtJQUU3QiwwQ0FBeUIsQ0FBQTtJQUV6QiwwQ0FBeUIsQ0FBQTtJQUV6Qiw4Q0FBNkIsQ0FBQTtJQUU3QiwwQ0FBeUIsQ0FBQTtJQUV6QixnREFBK0IsQ0FBQTtJQUUvQixvREFBbUMsQ0FBQTtJQUVuQyxvREFBbUMsQ0FBQTtJQUVuQyw4Q0FBNkIsQ0FBQTtJQUU3QiwwREFBeUMsQ0FBQTtJQUV6QywwQ0FBeUIsQ0FBQTtJQUV6Qix3Q0FBdUIsQ0FBQTtJQUV2QiwwREFBeUMsQ0FBQTtBQUMzQyxDQUFDLEVBektXLGFBQWEsR0FBYixxQkFBYSxLQUFiLHFCQUFhLFFBeUt4Qjs7OztBQUVELElBQVksZ0JBNkJYO0FBN0JELFdBQVksZ0JBQWdCO0lBRTFCLHlDQUFxQixDQUFBO0lBRXJCLDJDQUF1QixDQUFBO0lBRXZCLDZDQUF5QixDQUFBO0lBRXpCLDZDQUF5QixDQUFBO0lBRXpCLDZDQUF5QixDQUFBO0lBRXpCLCtDQUEyQixDQUFBO0lBRTNCLHlDQUFxQixDQUFBO0lBRXJCLDJDQUF1QixDQUFBO0lBRXZCLDZDQUF5QixDQUFBO0lBRXpCLDZDQUF5QixDQUFBO0lBRXpCLDZDQUF5QixDQUFBO0lBRXpCLCtDQUEyQixDQUFBO0lBRTNCLCtDQUEyQixDQUFBO0lBRTNCLCtDQUEyQixDQUFBO0FBQzdCLENBQUMsRUE3QlcsZ0JBQWdCLEdBQWhCLHdCQUFnQixLQUFoQix3QkFBZ0IsUUE2QjNCO0FBRUQsTUFBTSw0QkFBNEIsR0FBRyxDQUFDLFdBQVcsRUFBRSxXQUFXLEVBQUUsV0FBVyxFQUFFLFdBQVcsRUFBRSxXQUFXLEVBQUUsV0FBVyxFQUFFLFdBQVcsRUFBRSxjQUFjO0lBQzdJLFlBQVksRUFBRSxnQkFBZ0IsRUFBRSxnQkFBZ0IsRUFBRSxnQkFBZ0IsRUFBRSxnQkFBZ0IsRUFBRSxjQUFjLENBQUMsQ0FBQzs7OztBQTBDeEcsTUFBYSxxQkFBc0IsU0FBUSxHQUFHLENBQUMsU0FBUzs7OztJQXNDdEQsWUFBWSxLQUFvQixFQUFFLEVBQVUsRUFBRSxLQUFrQzs7UUFDOUUsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztRQUNqQixNQUFNLEtBQUssR0FBRyxHQUFHLENBQUMsS0FBSyxDQUFDLEVBQUUsQ0FBQyxJQUFJLENBQUMsQ0FBQztRQUVqQyxJQUFJLDRCQUE0QixDQUFDLE9BQU8sQ0FBQyxLQUFLLENBQUMsTUFBTSxDQUFDLElBQUksQ0FBQyxDQUFDLEVBQUc7WUFDN0QsTUFBTSxJQUFJLEtBQUssQ0FBQyxlQUFlLEtBQUssQ0FBQyxNQUFNLDZCQUE2QixDQUFDLENBQUM7U0FDM0U7UUFDRCxJQUFJLGNBQStCLENBQUM7UUFDcEMsSUFBSSxLQUFLLGFBQUwsS0FBSyx1QkFBTCxLQUFLLENBQUUsV0FBVyxFQUFFO1lBQ3RCLGNBQWMsR0FBRztnQkFDZixRQUFRLFFBQUUsS0FBSyxhQUFMLEtBQUssdUJBQUwsS0FBSyxDQUFFLFVBQVUsbUNBQUksVUFBVTtnQkFDekMsUUFBUSxFQUFFLEdBQUcsQ0FBQyxXQUFXLENBQUMsU0FBUyxDQUFDLEtBQUssYUFBTCxLQUFLLHVCQUFMLEtBQUssQ0FBRSxXQUFXLENBQUM7YUFDeEQsQ0FBQztTQUNIO2FBQU07WUFDTCxjQUFjLEdBQUc7Z0JBQ2YsUUFBUSxRQUFFLEtBQUssYUFBTCxLQUFLLHVCQUFMLEtBQUssQ0FBRSxVQUFVLG1DQUFJLFVBQVU7YUFDMUMsQ0FBQztTQUNIO1FBQUEsQ0FBQztRQUVGLHFHQUFxRztRQUNyRyxJQUFJLENBQUMsYUFBYSxTQUFHLEtBQUssYUFBTCxLQUFLLHVCQUFMLEtBQUssQ0FBRSxhQUFhLG1DQUFJLEdBQUcsQ0FBQyxxQkFBcUIsQ0FBQyxXQUFXLENBQUM7WUFDakYsT0FBTyxFQUFFLEdBQUcsQ0FBQyx3QkFBd0IsQ0FBQyxVQUFVO1NBQ2pELENBQUMsQ0FBQztRQUVILElBQUksQ0FBQyxlQUFlLFNBQUcsS0FBSyxhQUFMLEtBQUssdUJBQUwsS0FBSyxDQUFFLFlBQVksbUNBQUksZ0JBQWdCLENBQUMsUUFBUSxDQUFDO1FBQ3hFLG9CQUFvQjtRQUNwQixNQUFNLE1BQU0sU0FBRyxLQUFLLGFBQUwsS0FBSyx1QkFBTCxLQUFLLENBQUUsR0FBRyxtQ0FBSSxJQUFJLEdBQUcsQ0FBQyxHQUFHLENBQUMsSUFBSSxFQUFFLG9CQUFvQixFQUFFO1lBQ25FLElBQUksRUFBRSxlQUFlO1lBQ3JCLGtCQUFrQixFQUFFLElBQUk7WUFDeEIsZ0JBQWdCLEVBQUUsSUFBSTtZQUN0QixXQUFXLEVBQUUsQ0FBQztTQUNmLENBQUMsQ0FBQztRQUVILElBQUksQ0FBQyxZQUFZLFNBQUcsS0FBSyxhQUFMLEtBQUssdUJBQUwsS0FBSyxDQUFFLFlBQVksbUNBQUksSUFBSSxHQUFHLENBQUMsY0FBYyxDQUFDLElBQUksRUFBRSx5QkFBeUIsRUFBRTtZQUNqRyxNQUFNLEVBQUUsSUFBSSxDQUFDLGFBQWE7WUFDMUIsVUFBVSxRQUFFLEtBQUssYUFBTCxLQUFLLHVCQUFMLEtBQUssQ0FBRSxVQUFVLG1DQUFJO2dCQUMvQixTQUFTLFFBQUUsS0FBSyxhQUFMLEtBQUssdUJBQUwsS0FBSyxDQUFFLFFBQVEsbUNBQUksYUFBYSxDQUFDLEdBQUc7YUFDaEQ7U0FDRixDQUFDLENBQUM7UUFFSCxJQUFJLGtCQUFrQixHQUFHLEdBQUcsQ0FBQyxVQUFVLENBQUMsT0FBTyxDQUFDO1FBQ2hELElBQUksSUFBSSxDQUFDLFdBQVcsQ0FBQyxNQUFNLENBQUMsY0FBYyxDQUFDLEtBQUssQ0FBQyxFQUFFO1lBQ2pELGtCQUFrQixHQUFHLEdBQUcsQ0FBQyxVQUFVLENBQUMsTUFBTSxDQUFDO1NBQzVDO1FBQ0QsSUFBSSxDQUFDLFVBQVUsR0FBRyxJQUFJLEdBQUcsQ0FBQyxlQUFlLENBQUMsSUFBSSxFQUFFLFlBQVksRUFBRTtZQUM1RCxNQUFNLEVBQUUsSUFBSSxDQUFDLGFBQWE7WUFDMUIsY0FBYyxFQUFFLElBQUksQ0FBQyxZQUFZO1lBQ2pDLGlCQUFpQixFQUFFLEdBQUcsS0FBSyxDQUFDLFNBQVMsQ0FBQyxXQUFXLEVBQUUsVUFBVTtZQUM3RCxXQUFXLEVBQUUsY0FBZTtZQUM1QixTQUFTLEVBQUUsQ0FBQztZQUNaLGFBQWEsRUFBRTtnQkFDYiw0RkFBNEY7Z0JBQzVGLEdBQUcsRUFBRSxNQUFNO2dCQUNYLFVBQVUsRUFBRSxFQUFFLFVBQVUsRUFBRSxrQkFBa0IsRUFBRTtnQkFDOUMsWUFBWSxFQUFFLElBQUksR0FBRyxDQUFDLFlBQVksQ0FBQyxJQUFJLENBQUMsZUFBZSxDQUFDO2FBQ3pEO1lBQ0QsYUFBYSxFQUFFLEdBQUcsQ0FBQyxhQUFhLENBQUMsT0FBTztZQUN4QyxtQkFBbUIsUUFBRSxLQUFLLGFBQUwsS0FBSyx1QkFBTCxLQUFLLENBQUUsbUJBQW1CLG1DQUFJLGdCQUFnQjtTQUNwRSxDQUFDLENBQUM7UUFFSCxJQUFJLENBQUMsV0FBVyxTQUFHLCtGQUErRixNQUFBLElBQUksQ0FBQyxVQUFVLENBQUMsTUFBTSwwQ0FBRSxVQUFVLEVBQUUsbUNBQUksS0FBSyxhQUFMLEtBQUssdUJBQUwsS0FBSyxDQUFFLFdBQVcsQ0FBQztRQUFBLENBQUM7UUFFOUssSUFBSSxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUMsYUFBYSxDQUFDLE1BQU0sQ0FBQyxDQUFDO1FBQzNDLElBQUksQ0FBQyxVQUFVLENBQUMsV0FBVyxDQUFDLG9CQUFvQixDQUFDLEdBQUcsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxZQUFZLENBQUMsQ0FBQyxDQUFDO1FBRXJGLHlCQUF5QjtRQUN6QixNQUFNLG9CQUFvQixHQUFHLElBQUksR0FBRyxDQUFDLGVBQWUsQ0FBQztZQUNuRCxTQUFTLEVBQUUsQ0FBQyxHQUFHLENBQUM7WUFDaEIsT0FBTyxFQUFFLENBQUMseUJBQXlCLEVBQUUseUJBQXlCLEVBQUUsNkJBQTZCLEVBQUUseUJBQXlCLENBQUM7U0FDMUgsQ0FBQyxDQUFDO1FBQ0gsOEJBQThCO1FBQzlCLE1BQU0sT0FBTyxHQUFHLElBQUksTUFBTSxDQUFDLFFBQVEsQ0FBQyxJQUFJLEVBQUUsZ0JBQWdCLEVBQUU7WUFDMUQsT0FBTyxFQUFFLE1BQU0sQ0FBQyxPQUFPLENBQUMsVUFBVTtZQUNsQyxJQUFJLEVBQUUsTUFBTSxDQUFDLElBQUksQ0FBQyxTQUFTLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxTQUFTLEVBQUUsNEJBQTRCLENBQUMsQ0FBQztZQUMvRSxPQUFPLEVBQUUsdUJBQXVCO1lBQ2hDLE9BQU8sRUFBRSxHQUFHLENBQUMsUUFBUSxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUM7U0FDakMsQ0FBQyxDQUFDO1FBRUgsTUFBTSx1QkFBdUIsR0FBRyxJQUFJLEVBQUUsQ0FBQyxRQUFRLENBQUMsSUFBSSxFQUFFLHlCQUF5QixFQUFFO1lBQy9FLGNBQWMsRUFBRSxPQUFPO1lBQ3ZCLFlBQVksRUFBRSxJQUFJLENBQUMsYUFBYSxDQUFDLE9BQU87U0FDekMsQ0FBQyxDQUFDO1FBRUgsSUFBSSxDQUFDLG1CQUFtQixHQUFHLElBQUksR0FBRyxDQUFDLGNBQWMsQ0FBQyxJQUFJLEVBQUUsMkJBQTJCLEVBQUU7WUFDbkYsWUFBWSxFQUFFLHNDQUFzQztZQUNwRCxZQUFZLEVBQUUsdUJBQXVCLENBQUMsWUFBWTtZQUNsRCxVQUFVLEVBQUU7Z0JBQ1YseUJBQXlCLEVBQUUsZUFBZSxLQUFLLENBQUMsTUFBTSxJQUFJLEtBQUssQ0FBQyxPQUFPLFlBQVksSUFBSSxDQUFDLFVBQVUsQ0FBQyxpQkFBaUIsRUFBRTtnQkFDdEgsdUJBQXVCLEVBQUUsVUFBVSxLQUFLLENBQUMsU0FBUyxDQUFDLFdBQVcsRUFBRSxFQUFFO2FBQ25FO1NBQ0YsQ0FBQyxDQUFDO1FBRUgsSUFBSSxDQUFDLG1CQUFtQixDQUFDLElBQUksQ0FBQyxhQUFhLENBQUMsSUFBSSxDQUFDLFVBQVUsQ0FBQyxDQUFDO1FBQzdELE1BQUEsT0FBTyxDQUFDLElBQUksMENBQUUsb0JBQW9CLENBQUMsb0JBQW9CLEVBQUU7UUFDekQsSUFBSSxDQUFDLFdBQVcsR0FBRyxrQkFBa0IsQ0FBQztRQUN0QyxJQUFJLEdBQUcsQ0FBQyxTQUFTLENBQUMsSUFBSSxFQUFFLGFBQWEsRUFBRTtZQUNyQyxLQUFLLEVBQUUsSUFBSSxDQUFDLFdBQVc7U0FDeEIsQ0FBQyxDQUFDO1FBRUgsSUFBSSxDQUFDLGFBQWEsR0FBRyxlQUFlLEtBQUssQ0FBQyxNQUFNLElBQUksS0FBSyxDQUFDLE9BQU8sWUFBWSxJQUFJLENBQUMsVUFBVSxDQUFDLGlCQUFpQixFQUFFLENBQUM7UUFDakgsSUFBSSxHQUFHLENBQUMsU0FBUyxDQUFDLElBQUksRUFBRSxlQUFlLEVBQUU7WUFDdkMsS0FBSyxFQUFFLElBQUksQ0FBQyxhQUFhO1NBQzFCLENBQUMsQ0FBQztRQUVILElBQUksQ0FBQyx1QkFBdUIsR0FBRyxVQUFVLEtBQUssQ0FBQyxTQUFTLENBQUMsV0FBVyxFQUFFLEVBQUUsQ0FBQztRQUN6RSxJQUFJLEdBQUcsQ0FBQyxTQUFTLENBQUMsSUFBSSxFQUFFLHlCQUF5QixFQUFFO1lBQ2pELEtBQUssRUFBRSxJQUFJLENBQUMsdUJBQXVCO1NBQ3BDLENBQUMsQ0FBQztRQUVILElBQUksQ0FBQyxNQUFNLEdBQUcsR0FBRyxDQUFDLEtBQUssQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLG1CQUFtQixDQUFDLE1BQU0sQ0FBQyxRQUFRLENBQUMsQ0FBQyxDQUFDO1FBQzVFLElBQUksR0FBRyxDQUFDLFNBQVMsQ0FBQyxJQUFJLEVBQUUsUUFBUSxFQUFFO1lBQ2hDLEtBQUssRUFBRSxJQUFJLENBQUMsTUFBTTtTQUNuQixDQUFDLENBQUM7UUFFSCxJQUFJLENBQUMsb0JBQW9CLEdBQUcsR0FBRyxDQUFDLEtBQUssQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLG1CQUFtQixDQUFDLE1BQU0sQ0FBQyxlQUFlLENBQUMsQ0FBQyxDQUFDO1FBQ2pHLElBQUksR0FBRyxDQUFDLFNBQVMsQ0FBQyxJQUFJLEVBQUUsc0JBQXNCLEVBQUU7WUFDOUMsS0FBSyxFQUFFLElBQUksQ0FBQyxvQkFBb0I7U0FDakMsQ0FBQyxDQUFDO1FBRUgsSUFBSSxDQUFDLGdCQUFnQixHQUFHLEdBQUcsQ0FBQyxLQUFLLENBQUMsUUFBUSxDQUFDLElBQUksQ0FBQyxtQkFBbUIsQ0FBQyxNQUFNLENBQUMsa0JBQWtCLENBQUMsQ0FBQyxDQUFDO1FBQ2hHLElBQUksR0FBRyxDQUFDLFNBQVMsQ0FBQyxJQUFJLEVBQUUsa0JBQWtCLEVBQUU7WUFDMUMsS0FBSyxFQUFFLElBQUksQ0FBQyxnQkFBZ0I7U0FDN0IsQ0FBQyxDQUFDO1FBRUgsSUFBSSxHQUFHLENBQUMsU0FBUyxDQUFDLElBQUksRUFBRSw4QkFBOEIsRUFBRTtZQUN0RCxLQUFLLEVBQUUsSUFBSSxDQUFDLFVBQVUsQ0FBQyxlQUFlLENBQUMsUUFBUTtTQUNoRCxDQUFDLENBQUM7SUFDTCxDQUFDO0lBQ08sV0FBVyxDQUFDLE9BQXNCO1FBQ3hDLE9BQU8sSUFBSSxHQUFHLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxNQUFNLENBQUMsRUFBRSxDQUFDLE1BQU0sQ0FBQyxnQkFBZ0IsQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDO0lBQ3RFLENBQUM7Ozs7SUFFTSxrQkFBa0IsQ0FBQyxLQUFvQixFQUFFLEVBQVUsRUFBRSxPQUF3Qjs7UUFDbEYsTUFBTSxLQUFLLEdBQUcsR0FBRyxDQUFDLEtBQUssQ0FBQyxFQUFFLENBQUMsS0FBSyxDQUFDLENBQUM7UUFDbEMseUJBQXlCO1FBQ3pCLE1BQU0sb0JBQW9CLEdBQUcsSUFBSSxHQUFHLENBQUMsZUFBZSxDQUFDO1lBQ25ELFNBQVMsRUFBRSxDQUFDLEdBQUcsQ0FBQztZQUNoQixPQUFPLEVBQUU7Z0JBQ1AseUJBQXlCLEVBQUUseUJBQXlCLEVBQUUsNkJBQTZCLEVBQUUseUJBQXlCO2dCQUM5RyxxQkFBcUIsRUFBRSxzQkFBc0IsRUFBRSxxQkFBcUIsRUFBRSxzQkFBc0IsRUFBRSx5QkFBeUI7Z0JBQ3ZILDRCQUE0QjthQUM3QjtTQUNGLENBQUMsQ0FBQztRQUNILDhCQUE4QjtRQUM5QixNQUFNLE9BQU8sR0FBRyxJQUFJLE1BQU0sQ0FBQyxRQUFRLENBQUMsS0FBSyxFQUFFLEdBQUcsRUFBRSxxQkFBcUIsRUFBRTtZQUNyRSxPQUFPLEVBQUUsTUFBTSxDQUFDLE9BQU8sQ0FBQyxVQUFVO1lBQ2xDLElBQUksRUFBRSxNQUFNLENBQUMsSUFBSSxDQUFDLFNBQVMsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLFNBQVMsRUFBRSw0QkFBNEIsQ0FBQyxDQUFDO1lBQy9FLE9BQU8sRUFBRSwyQkFBMkI7WUFDcEMsT0FBTyxFQUFFLEdBQUcsQ0FBQyxRQUFRLENBQUMsT0FBTyxDQUFDLEVBQUUsQ0FBQztTQUNsQyxDQUFDLENBQUM7UUFFSCxNQUFNLFVBQVUsR0FBRyxJQUFJLE1BQU0sQ0FBQyxRQUFRLENBQUMsS0FBSyxFQUFFLEdBQUcsRUFBRSxhQUFhLEVBQUU7WUFDaEUsSUFBSSxFQUFFLE1BQU0sQ0FBQyxJQUFJLENBQUMsU0FBUyxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsU0FBUyxFQUFFLDRCQUE0QixDQUFDLENBQUM7WUFDL0UsT0FBTyxFQUFFLDhCQUE4QjtZQUN2QyxPQUFPLEVBQUUsTUFBTSxDQUFDLE9BQU8sQ0FBQyxVQUFVO1lBQ2xDLE9BQU8sRUFBRSxHQUFHLENBQUMsUUFBUSxDQUFDLE9BQU8sQ0FBQyxFQUFFLENBQUM7WUFDakMsSUFBSSxFQUFFLE9BQU8sQ0FBQyxJQUFJO1NBQ25CLENBQUMsQ0FBQztRQUVILE1BQU0sbUJBQW1CLEdBQUcsSUFBSSxFQUFFLENBQUMsUUFBUSxDQUFDLEtBQUssRUFBRSxHQUFHLEVBQUUsc0JBQXNCLEVBQUU7WUFDOUUsY0FBYyxFQUFFLE9BQU87WUFDdkIsaUJBQWlCLEVBQUUsVUFBVTtZQUM3QixZQUFZLEVBQUUsSUFBSSxDQUFDLGFBQWEsQ0FBQyxPQUFPO1NBQ3pDLENBQUMsQ0FBQztRQUVILE1BQU0sbUJBQW1CLEdBQUcsSUFBSSxHQUFHLENBQUMsY0FBYyxDQUFDLEtBQUssRUFBRSxHQUFHLEVBQUUsNEJBQTRCLEVBQUU7WUFDM0YsWUFBWSxFQUFFLG9DQUFvQztZQUNsRCxZQUFZLEVBQUUsbUJBQW1CLENBQUMsWUFBWTtZQUM5QyxVQUFVLEVBQUU7Z0JBQ1YseUJBQXlCLEVBQUUsSUFBSSxDQUFDLGFBQWE7Z0JBQzdDLHVCQUF1QixFQUFFLElBQUksQ0FBQyx1QkFBdUI7Z0JBQ3JELE1BQU0sRUFBRSxPQUFPLENBQUMsTUFBTTtnQkFDdEIsaUJBQWlCLEVBQUUsT0FBTyxDQUFDLGlCQUFpQjtnQkFDNUMsTUFBTSxFQUFFLElBQUksQ0FBQyxNQUFNO2dCQUNuQixhQUFhLEVBQUUsSUFBSSxDQUFDLG9CQUFvQjtnQkFDeEMsaUJBQWlCLEVBQUUsR0FBRyxLQUFLLENBQUMsU0FBUyxDQUFDLFdBQVcsRUFBRSxJQUFJLE9BQU8sQ0FBQyxNQUFNLEVBQUU7Z0JBQ3ZFLFlBQVksRUFBRSxJQUFJLENBQUMsZUFBZTtnQkFDbEMsV0FBVyxFQUFFLElBQUksQ0FBQyxXQUFXO2dCQUM3QixtQkFBbUIsRUFBRSxlQUFlLE9BQU8sQ0FBQyxNQUFNLElBQUksS0FBSyxDQUFDLE9BQU8sWUFBWSxLQUFLLENBQUMsU0FBUyxDQUFDLFdBQVcsRUFBRSxJQUFJLE9BQU8sQ0FBQyxNQUFNLEVBQUU7Z0JBQ2hJLDBCQUEwQixFQUFFLEdBQUcsS0FBSyxDQUFDLFNBQVMsQ0FBQyxXQUFXLEVBQUUsSUFBSSxPQUFPLENBQUMsTUFBTSxJQUFJO2FBQ25GO1NBQ0YsQ0FBQyxDQUFDO1FBQ0gsbUJBQW1CLENBQUMsSUFBSSxDQUFDLGFBQWEsQ0FBQyxJQUFJLENBQUMsbUJBQW1CLENBQUMsQ0FBQztRQUNqRSxNQUFBLE9BQU8sQ0FBQyxJQUFJLDBDQUFFLG9CQUFvQixDQUFDLG9CQUFvQixFQUFFO1FBRXpELElBQUksR0FBRyxDQUFDLFNBQVMsQ0FBQyxLQUFLLEVBQUUscUJBQXFCLEVBQUU7WUFDOUMsS0FBSyxFQUFFLEdBQUcsQ0FBQyxLQUFLLENBQUMsUUFBUSxDQUFDLG1CQUFtQixDQUFDLE1BQU0sQ0FBQyxxQkFBcUIsQ0FBQyxDQUFDO1NBQzdFLENBQUMsQ0FBQztRQUVILElBQUksR0FBRyxDQUFDLFNBQVMsQ0FBQyxLQUFLLEVBQUUsNEJBQTRCLEVBQUU7WUFDckQsS0FBSyxFQUFFLEdBQUcsQ0FBQyxLQUFLLENBQUMsUUFBUSxDQUFDLG1CQUFtQixDQUFDLE1BQU0sQ0FBQyw0QkFBNEIsQ0FBQyxDQUFDO1NBQ3BGLENBQUMsQ0FBQztJQUNMLENBQUM7O0FBdE9ILHNEQXVPQzs7Ozs7O0FBbUJELE1BQWEseUJBQTBCLFNBQVEsR0FBRyxDQUFDLFNBQVM7Ozs7SUFHMUQsWUFBWSxLQUFvQixFQUFFLEVBQVUsRUFBRSxLQUFzQzs7UUFDbEYsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztRQUNqQixNQUFNLEtBQUssR0FBRyxHQUFHLENBQUMsS0FBSyxDQUFDLEVBQUUsQ0FBQyxJQUFJLENBQUMsQ0FBQztRQUNqQyxJQUFJLDRCQUE0QixDQUFDLE9BQU8sQ0FBQyxLQUFLLENBQUMsTUFBTSxDQUFDLElBQUksQ0FBQyxDQUFDLEVBQUc7WUFDN0QsTUFBTSxJQUFJLEtBQUssQ0FBQyxlQUFlLEtBQUssQ0FBQyxNQUFNLDZCQUE2QixDQUFDLENBQUM7U0FDM0U7UUFDRCxtQkFBbUI7UUFDbkIsTUFBTSxZQUFZLFNBQUcsS0FBSyxhQUFMLEtBQUssdUJBQUwsS0FBSyxDQUFFLEdBQUcsbUNBQUksSUFBSSxHQUFHLENBQUMsR0FBRyxDQUFDLElBQUksRUFBRSxtQkFBbUIsRUFBRTtZQUN4RSxJQUFJLEVBQUUsZUFBZTtZQUNyQixrQkFBa0IsRUFBRSxJQUFJO1lBQ3hCLGdCQUFnQixFQUFFLElBQUk7WUFDdEIsV0FBVyxFQUFFLENBQUM7U0FDZixDQUFDLENBQUM7UUFFSCxNQUFNLFlBQVksU0FBRyxLQUFLLGFBQUwsS0FBSyx1QkFBTCxLQUFLLENBQUUsVUFBVSxtQ0FBSSxHQUFHLENBQUMsVUFBVSxDQUFDLE9BQU8sQ0FBQztRQUNqRSxJQUFJLFlBQVksS0FBSyxHQUFHLENBQUMsVUFBVSxDQUFDLE9BQU8sRUFBRTtZQUMzQyxNQUFNLGFBQWEsR0FBRyxZQUFZLENBQUMsYUFBYSxDQUFDLEVBQUUsVUFBVSxFQUFFLEdBQUcsQ0FBQyxVQUFVLENBQUMsT0FBTyxFQUFFLENBQUMsQ0FBQztZQUN6RixJQUFJLENBQUMsYUFBYSxHQUFHLElBQUksR0FBRyxDQUFDLGdCQUFnQixDQUFDLElBQUksRUFBRSxTQUFTLEVBQUU7Z0JBQzdELGlCQUFpQixFQUFFLEdBQUcsS0FBSyxDQUFDLFNBQVMsQ0FBQyxXQUFXLEVBQUUscUJBQXFCO2dCQUN4RSx3QkFBd0IsRUFBRSw4QkFBOEI7Z0JBQ3hELFNBQVMsRUFBRSxhQUFhLENBQUMsU0FBUzthQUNuQyxDQUFDLENBQUM7WUFFSCxHQUFHLENBQUMsSUFBSSxDQUFDLEVBQUUsQ0FBQyxJQUFJLENBQUMsYUFBYSxDQUFDLENBQUMsR0FBRyxDQUFDLE1BQU0sRUFBRSxzQkFBc0IsQ0FBQyxDQUFDO1lBQ3BFLElBQUksQ0FBQyxhQUFhLENBQUMsSUFBSSxDQUFDLGFBQWEsQ0FBQyxZQUFZLENBQUMsQ0FBQztTQUNyRDthQUFNO1lBQ0wsTUFBTSxZQUFZLEdBQUcsWUFBWSxDQUFDLGFBQWEsQ0FBQyxFQUFFLFVBQVUsRUFBRSxHQUFHLENBQUMsVUFBVSxDQUFDLE1BQU0sRUFBRSxDQUFDLENBQUM7WUFDdkYsSUFBSSxDQUFDLGFBQWEsR0FBRyxJQUFJLEdBQUcsQ0FBQyxnQkFBZ0IsQ0FBQyxJQUFJLEVBQUUsU0FBUyxFQUFFO2dCQUM3RCxpQkFBaUIsRUFBRSxHQUFHLEtBQUssQ0FBQyxTQUFTLENBQUMsV0FBVyxFQUFFLG9CQUFvQjtnQkFDdkUsd0JBQXdCLEVBQUUsNkJBQTZCO2dCQUN2RCxTQUFTLEVBQUUsWUFBWSxDQUFDLFNBQVM7YUFDbEMsQ0FBQyxDQUFDO1lBRUgsR0FBRyxDQUFDLElBQUksQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLGFBQWEsQ0FBQyxDQUFDLEdBQUcsQ0FBQyxNQUFNLEVBQUUscUJBQXFCLENBQUMsQ0FBQztZQUNuRSxJQUFJLENBQUMsYUFBYSxDQUFDLElBQUksQ0FBQyxhQUFhLENBQUMsWUFBWSxDQUFDLENBQUM7U0FDckQ7UUFDRCxJQUFJLEdBQUcsQ0FBQyxTQUFTLENBQUMsSUFBSSxFQUFFLGtCQUFrQixFQUFFO1lBQzFDLEtBQUssRUFBRSxHQUFHLElBQUksQ0FBQyxhQUFhLENBQUMsaUJBQWlCLEVBQUU7U0FDakQsQ0FBQyxDQUFDO1FBRUgsSUFBSSxHQUFHLENBQUMsU0FBUyxDQUFDLElBQUksRUFBRSxhQUFhLEVBQUU7WUFDckMsS0FBSyxFQUFFLEdBQUcsS0FBSyxDQUFDLE1BQU0sRUFBRTtTQUN6QixDQUFDLENBQUM7SUFDTCxDQUFDOztBQTlDSCw4REErQ0MiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBwYXRoIGZyb20gJ3BhdGgnO1xuaW1wb3J0ICogYXMgZWMyIGZyb20gJ0Bhd3MtY2RrL2F3cy1lYzInO1xuaW1wb3J0ICogYXMgaWFtIGZyb20gJ0Bhd3MtY2RrL2F3cy1pYW0nO1xuaW1wb3J0ICogYXMgbGFtYmRhIGZyb20gJ0Bhd3MtY2RrL2F3cy1sYW1iZGEnO1xuaW1wb3J0ICogYXMgbG9ncyBmcm9tICdAYXdzLWNkay9hd3MtbG9ncyc7XG5pbXBvcnQgKiBhcyByZHMgZnJvbSAnQGF3cy1jZGsvYXdzLXJkcyc7XG5pbXBvcnQgKiBhcyBjZGsgZnJvbSAnQGF3cy1jZGsvY29yZSc7XG5pbXBvcnQgKiBhcyBjciBmcm9tICdAYXdzLWNkay9jdXN0b20tcmVzb3VyY2VzJztcblxuXG5leHBvcnQgZW51bSBNeVNRTHRpbWVab25lIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBVVEMgPSAnVVRDJyxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIEFTSUFfVEFJUEVJID0gJ0FzaWEvVGFpcGVpJyxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBBRlJJQ0FfQ0FJUk8gPSAnQWZyaWNhL0NhaXJvJyxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBBU0lBX0JBTkdLT0sgPSAnQXNpYS9CYW5na29rJyxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgQVVTVFJBTElBX0RBUldJTiA9ICdBdXN0cmFsaWEvRGFyd2luJyxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIEFGUklDQV9DQVNBQkxBTkNBID0gJ0FmcmljYS9DYXNhYmxhbmNhJyxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIEFTSUFfQkVJUlVUID0gJ0FzaWEvQmVpcnV0JyxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgQVVTVFJBTElBX0hPQkFSVCA9ICdBdXN0cmFsaWEvSG9iYXJ0JyxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgQUZSSUNBX0hBUkFSRSA9ICdBZnJpY2EvSGFyYXJlJyxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgQVNJQV9DQUxDVVRUQSA9ICdBc2lhL0NhbGN1dHRhJyxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBBVVNUUkFMSUFfUEVSVEggPSAnQXVzdHJhbGlhL1BlcnRoJyxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBBRlJJQ0FfTU9OUk9WSUEgPSAnQWZyaWNhL01vbnJvdmlhJyxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgQVNJQV9EQU1BU0NVUyA9ICdBc2lhL0RhbWFzY3VzJyxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgQVVTVFJBTElBX1NZRE5FWSA9ICdBdXN0cmFsaWEvU3lkbmV5JyxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIEFGUklDQV9OQUlST0JJID0gJ0FmcmljYS9OYWlyb2JpJyxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgQVNJQV9ESEFLQSA9ICdBc2lhL0RoYWthJyxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIEJSQVpJTF9FQVNUID0gJ0JyYXppbC9FYXN0JyxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIEFGUklDQV9UUklQT0xJID0gJ0FmcmljYS9Ucmlwb2xpJyxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBBU0lBX0lSS1VUU0sgPSAnQXNpYS9Jcmt1dHNrJyxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgQ0FOQURBX05FV0ZPVU5ETEFORCA9ICdDYW5hZGEvTmV3Zm91bmRsYW5kJyxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBBRlJJQ0FfV0lOREhPRUsgPSAnQWZyaWNhL1dpbmRob2VrJyxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIEFTSUFfSkVSVVNBTEVNID0gJ0FzaWEvSmVydXNhbGVtJyxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgQ0FOQURBX1NBU0tBVENIRVdBTiA9ICdDYW5hZGEvU2Fza2F0Y2hld2FuJyxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIEFNRVJJQ0FfQVJBR1VBSU5BID0gJ0FtZXJpY2EvQXJhZ3VhaW5hJyxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgQVNJQV9LQUJVTCA9ICdBc2lhL0thYnVsJyxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgRVVST1BFX0FNU1RFUkRBTSA9ICdFdXJvcGUvQW1zdGVyZGFtJyxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgQU1FUklDQV9BU1VOQ0lPTiA9ICdBbWVyaWNhL0FzdW5jaW9uJyxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBBU0lBX0tBUkFDSEkgPSAnQXNpYS9LYXJhY2hpJyxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgRVVST1BFX0FUSEVOUyA9ICdFdXJvcGUvQXRoZW5zJyxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIEFNRVJJQ0FfQk9HT1RBID0gJ0FtZXJpY2EvQm9nb3RhJyxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIEFTSUFfS0FUSE1BTkRVID0gJ0FzaWEvS2F0aG1hbmR1JyxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgRVVST1BFX0RVQkxJTiA9ICdFdXJvcGUvRHVibGluJyxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBBTUVSSUNBX0NBUkFDQVMgPSAnQW1lcmljYS9DYXJhY2FzJyxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIEFTSUFfS1JBU05PWUFSU0sgPSAnQXNpYS9LcmFzbm95YXJzaycsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgRVVST1BFX0hFTFNJTktJID0gJ0V1cm9wZS9IZWxzaW5raScsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBBTUVSSUNBX0NISUhVQUhVQSA9ICdBbWVyaWNhL0NoaWh1YWh1YScsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgQVNJQV9NQUdBREFOID0gJ0FzaWEvTWFnYWRhbicsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgRVVST1BFX0lTVEFOQlVMID0gJ0V1cm9wZS9Jc3RhbmJ1bCcsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBBTUVSSUNBX0NVSUFCQSA9ICdBbWVyaWNhL0N1aWFiYScsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBBU0lBX01VU0NBVCA9ICdBc2lhL011c2NhdCcsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgRVVST1BFX0tBTElOSU5HUkFEID0gJ0V1cm9wZS9LYWxpbmluZ3JhZCcsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBBTUVSSUNBX0RFTlZFUiA9ICdBbWVyaWNhL0RlbnZlcicsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIEFTSUFfTk9WT1NJQklSU0sgPSAnQXNpYS9Ob3Zvc2liaXJzaycsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBFVVJPUEVfTU9TQ09XID0gJ0V1cm9wZS9Nb3Njb3cnLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgQU1FUklDQV9GT1JUQUxFWkEgPSAnQW1lcmljYS9Gb3J0YWxlemEnLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgQVNJQV9SSVlBREggPSAnQXNpYS9SaXlhZGgnLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIEVVUk9QRV9QQVJJUyA9ICdFdXJvcGUvUGFyaXMnLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgQU1FUklDQV9HVUFURU1BTEEgPSAnQW1lcmljYS9HdWF0ZW1hbGEnLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBBU0lBX1NFT1VMID0gJ0FzaWEvU2VvdWwnLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBFVVJPUEVfUFJBR1VFID0gJ0V1cm9wZS9QcmFndWUnLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIEFNRVJJQ0FfSEFMSUZBWCA9ICdBbWVyaWNhL0hhbGlmYXgnLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBBU0lBX1NIQU5HSEFJID0gJ0FzaWEvU2hhbmdoYWknLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIEVVUk9QRV9TQVJBSkVWTyA9ICdFdXJvcGUvU2FyYWpldm8nLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgQU1FUklDQV9NQU5BVVMgPSAnQW1lcmljYS9NYW5hdXMnLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgQVNJQV9TSU5HQVBPUkUgPSAnQXNpYS9TaW5nYXBvcmUnLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBQQUNJRklDX0FVQ0tMQU5EID0gJ1BhY2lmaWMvQXVja2xhbmQnLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgQU1FUklDQV9NQVRBTU9ST1MgPSAnQW1lcmljYS9NYXRhbW9yb3MnLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIFBBQ0lGSUNfRklKSSA9ICdQYWNpZmljL0ZpamknLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgQU1FUklDQV9NT05URVJSRVkgPSAnQW1lcmljYS9Nb250ZXJyZXknLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgQVNJQV9URUhSQU4gPSAnQXNpYS9UZWhyYW4nLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIFBBQ0lGSUNfR1VBTSA9ICdQYWNpZmljL0d1YW0nLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIEFNRVJJQ0FfTU9OVEVWSURFTyA9ICdBbWVyaWNhL01vbnRldmlkZW8nLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBBU0lBX1RPS1lPID0gJ0FzaWEvVG9reW8nLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBQQUNJRklDX0hPTk9MVUxVID0gJ1BhY2lmaWMvSG9ub2x1bHUnLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIEFNRVJJQ0FfUEhPRU5JWCA9ICdBbWVyaWNhL1Bob2VuaXgnLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBBU0lBX1VMQUFOQkFBVEFSID0gJ0FzaWEvVWxhYW5iYWF0YXInLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBQQUNJRklDX1NBTU9BID0gJ1BhY2lmaWMvU2Ftb2EnLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBBTUVSSUNBX1NBTlRJQUdPID0gJ0FtZXJpY2EvU2FudGlhZ28nLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBBU0lBX1ZMQURJVk9TVE9LID0gJ0FzaWEvVmxhZGl2b3N0b2snLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIFVTX0FMQVNLQSA9ICdVUy9BbGFza2EnLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIEFNRVJJQ0FfVElKVUFOQSA9ICdBbWVyaWNhL1RpanVhbmEnLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIEFTSUFfWUFLVVRTSyA9ICdBc2lhL1lha3V0c2snLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBVU19DRU5UUkFMID0gJ1VTL0NlbnRyYWwnLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBBU0lBX0FNTUFOID0gJ0FzaWEvQW1tYW4nLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIEFTSUFfWUVSRVZBTiA9ICdBc2lhL1llcmV2YW4nLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgVVNfRUFTVEVSTiA9ICdVUy9FYXN0ZXJuJyxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgQVNJQV9BU0hHQUJBVCA9ICdBc2lhL0FzaGdhYmF0JyxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBBVExBTlRJQ19BWk9SRVMgPSAnQXRsYW50aWMvQXpvcmVzJyxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBVU19FQVNUX0lORElBTkEgPSAnVVMvRWFzdC1JbmRpYW5hJyxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBBU0lBX0JBR0hEQUQgPSAnQXNpYS9CYWdoZGFkJyxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBBVVNUUkFMSUFfQURFTEFJREUgPSAnQXVzdHJhbGlhL0FkZWxhaWRlJyxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgVVNfUEFDSUZJQyA9ICdVUy9QYWNpZmljJyxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBBU0lBX0JBS1UgPSAnQXNpYS9CYWt1JyxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBBVVNUUkFMSUFfQlJJU0JBTkUgPSAnQXVzdHJhbGlhL0JyaXNiYW5lJyxcbn1cblxuZXhwb3J0IGVudW0gSW5zdGFuY2VUeXBlRW51bXtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBSNF9MQVJHRSA9ICdyNC5sYXJnZScsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIFI0X1hMQVJHRSA9ICdyNC54bGFyZ2UnLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgUjRfMlhMQVJHRSA9ICdyNC4yeGxhcmdlJyxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIFI0XzRYTEFSR0UgPSAncjQuNHhsYXJnZScsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBSNF84WExBUkdFID0gJ3I0Ljh4bGFyZ2UnLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIFI0XzE2WExBUkdFID0gJ3I0LjE2eGxhcmdlJyxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBSNV9MQVJHRSA9ICdyNS5sYXJnZScsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIFI1X1hMQVJHRSA9ICdyNS54bGFyZ2UnLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgUjVfMlhMQVJHRSA9ICdyNS4yeGxhcmdlJyxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIFI1XzRYTEFSR0UgPSAncjUuNHhsYXJnZScsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBSNV84WExBUkdFID0gJ3I1Ljh4bGFyZ2UnLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIFI1XzEyWExBUkdFID0gJ3I1LjEyeGxhcmdlJyxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBSNV8xNlhMQVJHRSA9ICdyNS4xNnhsYXJnZScsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgUjVfMjRYTEFSR0UgPSAncjUuMjR4bGFyZ2UnLFxufVxuXG5jb25zdCBHbG9iYWxBdXJvcmFSRFNTdXBwb3J0UmVnaW9uID0gWyd1cy1lYXN0LTEnLCAndXMtZWFzdC0yJywgJ3VzLXdlc3QtMScsICd1cy13ZXN0LTInLCAnZXUtd2VzdC0xJywgJ2V1LXdlc3QtMicsICdldS13ZXN0LTMnLCAnZXUtY2VudHJhbC0xJyxcbiAgJ2FwLXNvdXRoLTEnLCAnYXAtc291dGhlYXN0LTEnLCAnYXAtc291dGhlYXN0LTInLCAnYXAtbm9ydGhlYXN0LTEnLCAnYXAtbm9ydGhlYXN0LTInLCAnY2EtY2VudHJhbC0xJ107XG5cbmV4cG9ydCBpbnRlcmZhY2UgR29sYmFsQXVyb3JhUkRTTWFzdGVyUHJvcHMge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSB2cGM/OiBlYzIuSVZwYztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgZGJVc2VyTmFtZT86IHN0cmluZztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGRlZmF1bHREYXRhYmFzZU5hbWU/OiBzdHJpbmc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBkYkNsdXN0ZXJwUEc/OiByZHMuSVBhcmFtZXRlckdyb3VwO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGluc3RhbmNlVHlwZT86IEluc3RhbmNlVHlwZUVudW07XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSB0aW1lWm9uZT86IE15U1FMdGltZVpvbmU7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHBhcmFtZXRlcnM/OiB7W2tleTogc3RyaW5nXTogc3RyaW5nfSB8IHVuZGVmaW5lZDtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBlbmdpbmVWZXJzaW9uPzogcmRzLklDbHVzdGVyRW5naW5lO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGRlbGV0aW9uUHJvdGVjdGlvbj86IGJvb2xlYW47XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBzdG9yYWdlRW5jcnlwdGVkPzogYm9vbGVhbjtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgcmRzUGFzc3dvcmQ/OiBzdHJpbmc7XG59XG5cbmV4cG9ydCBpbnRlcmZhY2UgUmVnaW9uYWxPcHRpb25zIHtcbiAgcmVhZG9ubHkgcmVnaW9uOiBzdHJpbmc7XG4gIHJlYWRvbmx5IGRiU3VibmV0R3JvdXBOYW1lPzogc3RyaW5nO1xufVxuXG5leHBvcnQgY2xhc3MgR29sYmFsQXVyb3JhUkRTTWFzdGVyIGV4dGVuZHMgY2RrLkNvbnN0cnVjdCB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSByZHNDbHVzdGVyOiByZHMuRGF0YWJhc2VDbHVzdGVyO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHJkc1Bhc3N3b3JkOiBzdHJpbmcgfCB1bmRlZmluZWQ7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGRiQ2x1c3RlcnBQRzogcmRzLklQYXJhbWV0ZXJHcm91cDtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgcmRzSXNQdWJsaWM6IGVjMi5TdWJuZXRUeXBlO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSByZHNDbHVzdGVyYXJuOiBzdHJpbmc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgZ2xvYmFsQ2x1c3RlcklkZW50aWZpZXI6IHN0cmluZztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgZW5naW5lOiBzdHJpbmc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBlbmdpbmVWZXJzaW9uOiByZHMuSUNsdXN0ZXJFbmdpbmU7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBnbG9iYWxDbHVzdGVyQXJuOiBzdHJpbmc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgcmRzSW5zdGFuY2VUeXBlOiBJbnN0YW5jZVR5cGVFbnVtO1xuXG4gIC8qKlxuICAgKiBDdXN0b21SZXNvdXJjZSBmb3IgU2Vjb25kIFJlZ2lvbmFsIC5cbiAgICovXG4gIHByaXZhdGUgY3JHbG9iYWxSRFNQcm92aWRlcjogY2RrLkN1c3RvbVJlc291cmNlO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgY2x1c3RlckVuZ2luZVZlcnNpb246IHN0cmluZztcbiAgY29uc3RydWN0b3Ioc2NvcGU6IGNkay5Db25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzPzogR29sYmFsQXVyb3JhUkRTTWFzdGVyUHJvcHMgKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkKTtcbiAgICBjb25zdCBzdGFjayA9IGNkay5TdGFjay5vZih0aGlzKTtcblxuICAgIGlmIChHbG9iYWxBdXJvcmFSRFNTdXBwb3J0UmVnaW9uLmluZGV4T2Yoc3RhY2sucmVnaW9uKSA9PSAtMSApIHtcbiAgICAgIHRocm93IG5ldyBFcnJvcihgVGhpcyByZWdpb24gJHtzdGFjay5yZWdpb259IG5vdCBTdXBwb3J0IEdsb2JhbCBSRFMgISEhYCk7XG4gICAgfVxuICAgIGxldCByZHNDcmVkZW50aWFsczogcmRzLkNyZWRlbnRpYWxzO1xuICAgIGlmIChwcm9wcz8ucmRzUGFzc3dvcmQpIHtcbiAgICAgIHJkc0NyZWRlbnRpYWxzID0ge1xuICAgICAgICB1c2VybmFtZTogcHJvcHM/LmRiVXNlck5hbWUgPz8gJ3N5c2FkbWluJyxcbiAgICAgICAgcGFzc3dvcmQ6IGNkay5TZWNyZXRWYWx1ZS5wbGFpblRleHQocHJvcHM/LnJkc1Bhc3N3b3JkKSxcbiAgICAgIH07XG4gICAgfSBlbHNlIHtcbiAgICAgIHJkc0NyZWRlbnRpYWxzID0ge1xuICAgICAgICB1c2VybmFtZTogcHJvcHM/LmRiVXNlck5hbWUgPz8gJ3N5c2FkbWluJyxcbiAgICAgIH07XG4gICAgfTtcblxuICAgIC8vIE15c3FsIG5lZWQgKE15U1FMIDUuNiAvIHZlcnNpb24gPiA1LjYuMTBhKSAsIFBvc3RncmVzIG5lZWQgKHZlcnNpb24gMTAuMTEgLCAxMC4xMiAsIDExLjcgb3IgbGF0ZXIpXG4gICAgdGhpcy5lbmdpbmVWZXJzaW9uID0gcHJvcHM/LmVuZ2luZVZlcnNpb24gPz8gcmRzLkRhdGFiYXNlQ2x1c3RlckVuZ2luZS5hdXJvcmFNeXNxbCh7XG4gICAgICB2ZXJzaW9uOiByZHMuQXVyb3JhTXlzcWxFbmdpbmVWZXJzaW9uLlZFUl8yXzA3XzEsXG4gICAgfSk7XG5cbiAgICB0aGlzLnJkc0luc3RhbmNlVHlwZSA9IHByb3BzPy5pbnN0YW5jZVR5cGUgPz8gSW5zdGFuY2VUeXBlRW51bS5SNV9MQVJHRTtcbiAgICAvLyBNYXN0ZXIgcmVnaW9uIFZwY1xuICAgIGNvbnN0IHJkc1ZwYyA9IHByb3BzPy52cGMgPz8gbmV3IGVjMi5WcGModGhpcywgJ1JEU1ZwY1JlZ2lvbk1hc3RlcicsIHtcbiAgICAgIGNpZHI6ICcxMC4xMDguMC4wLzE2JyxcbiAgICAgIGVuYWJsZURuc0hvc3RuYW1lczogdHJ1ZSxcbiAgICAgIGVuYWJsZURuc1N1cHBvcnQ6IHRydWUsXG4gICAgICBuYXRHYXRld2F5czogMSxcbiAgICB9KTtcblxuICAgIHRoaXMuZGJDbHVzdGVycFBHID0gcHJvcHM/LmRiQ2x1c3RlcnBQRyA/PyBuZXcgcmRzLlBhcmFtZXRlckdyb3VwKHRoaXMsICdkYkNsdXN0ZXJwYXJhbWV0ZXJncm91cCcsIHtcbiAgICAgIGVuZ2luZTogdGhpcy5lbmdpbmVWZXJzaW9uLFxuICAgICAgcGFyYW1ldGVyczogcHJvcHM/LnBhcmFtZXRlcnMgPz8ge1xuICAgICAgICB0aW1lX3pvbmU6IHByb3BzPy50aW1lWm9uZSA/PyBNeVNRTHRpbWVab25lLlVUQyxcbiAgICAgIH0sXG4gICAgfSk7XG5cbiAgICBsZXQgcmRzVnBjU3VibmV0U2VsZWN0ID0gZWMyLlN1Ym5ldFR5cGUuUFJJVkFURTtcbiAgICBpZiAodGhpcy5hek9mU3VibmV0cyhyZHNWcGMucHJpdmF0ZVN1Ym5ldHMpID09PSAwKSB7XG4gICAgICByZHNWcGNTdWJuZXRTZWxlY3QgPSBlYzIuU3VibmV0VHlwZS5QVUJMSUM7XG4gICAgfVxuICAgIHRoaXMucmRzQ2x1c3RlciA9IG5ldyByZHMuRGF0YWJhc2VDbHVzdGVyKHRoaXMsICdSRFNDbHVzdGVyJywge1xuICAgICAgZW5naW5lOiB0aGlzLmVuZ2luZVZlcnNpb24sXG4gICAgICBwYXJhbWV0ZXJHcm91cDogdGhpcy5kYkNsdXN0ZXJwUEcsXG4gICAgICBjbHVzdGVySWRlbnRpZmllcjogYCR7c3RhY2suc3RhY2tOYW1lLnRvTG93ZXJDYXNlKCl9LXByaW1hcnlgLFxuICAgICAgY3JlZGVudGlhbHM6IHJkc0NyZWRlbnRpYWxzISxcbiAgICAgIGluc3RhbmNlczogMSxcbiAgICAgIGluc3RhbmNlUHJvcHM6IHtcbiAgICAgICAgLy8gaWYgd2FudCBwdWJsaWNBY2Nlc3MgLCBuZWVkIHRvIGRlZmluZSB2cGNTdWJuZXRzOiB7IHN1Ym5ldFR5cGU6IGVjMi5TdWJuZXRUeXBlLlBVQkxJQyB9ICxcbiAgICAgICAgdnBjOiByZHNWcGMsXG4gICAgICAgIHZwY1N1Ym5ldHM6IHsgc3VibmV0VHlwZTogcmRzVnBjU3VibmV0U2VsZWN0IH0sXG4gICAgICAgIGluc3RhbmNlVHlwZTogbmV3IGVjMi5JbnN0YW5jZVR5cGUodGhpcy5yZHNJbnN0YW5jZVR5cGUpLFxuICAgICAgfSxcbiAgICAgIHJlbW92YWxQb2xpY3k6IGNkay5SZW1vdmFsUG9saWN5LkRFU1RST1ksXG4gICAgICBkZWZhdWx0RGF0YWJhc2VOYW1lOiBwcm9wcz8uZGVmYXVsdERhdGFiYXNlTmFtZSA/PyAnZ2xvYmFsZGF0YWJhc2UnLFxuICAgIH0pO1xuXG4gICAgdGhpcy5yZHNQYXNzd29yZCA9IGBQbGVhc2UgdXNlIHRoaXMgY29tbWFuZCBnZXQgcGFzc3dvcmQgYmFjayAsIGF3cyBzZWNyZXRzbWFuYWdlciBnZXQtc2VjcmV0LXZhbHVlIC0tc2VjcmV0LWlkICR7dGhpcy5yZHNDbHVzdGVyLnNlY3JldD8uc2VjcmV0TmFtZX1gID8/IHByb3BzPy5yZHNQYXNzd29yZDs7XG5cbiAgICB0aGlzLnJkc0NsdXN0ZXIubm9kZS5hZGREZXBlbmRlbmN5KHJkc1ZwYyk7XG4gICAgdGhpcy5yZHNDbHVzdGVyLmNvbm5lY3Rpb25zLmFsbG93RGVmYXVsdFBvcnRGcm9tKGVjMi5QZWVyLmlwdjQocmRzVnBjLnZwY0NpZHJCbG9jaykpO1xuXG4gICAgLy8gY3VzdG9tIHJlc291cmNlIHBvbGljeVxuICAgIGNvbnN0IEN1c3RvbVJlc291cmNlUG9saWN5ID0gbmV3IGlhbS5Qb2xpY3lTdGF0ZW1lbnQoe1xuICAgICAgcmVzb3VyY2VzOiBbJyonXSxcbiAgICAgIGFjdGlvbnM6IFsncmRzOkNyZWF0ZUdsb2JhbENsdXN0ZXInLCAncmRzOkRlbGV0ZUdsb2JhbENsdXN0ZXInLCAncmRzOlJlbW92ZUZyb21HbG9iYWxDbHVzdGVyJywgJ3JkczpNb2RpZnlHbG9iYWxDbHVzdGVyJ10sXG4gICAgfSk7XG4gICAgLy8gVXBncmFkZSBkYXRhYmFzZSB0byBHbG9iYWwuXG4gICAgY29uc3Qgb25FdmVudCA9IG5ldyBsYW1iZGEuRnVuY3Rpb24odGhpcywgJ29uRXZlbnRIYW5kbGVyJywge1xuICAgICAgcnVudGltZTogbGFtYmRhLlJ1bnRpbWUuUFlUSE9OXzNfOCxcbiAgICAgIGNvZGU6IGxhbWJkYS5Db2RlLmZyb21Bc3NldChwYXRoLmpvaW4oX19kaXJuYW1lLCAnLi4vY3VzdG9tLXJlc291cmNlLWhhbmRsZXInKSksXG4gICAgICBoYW5kbGVyOiAnZ2xvYmFsX2luZGV4Lm9uX2V2ZW50JyxcbiAgICAgIHRpbWVvdXQ6IGNkay5EdXJhdGlvbi5taW51dGVzKDUpLFxuICAgIH0pO1xuXG4gICAgY29uc3QgVXBncmFkZWdsb2JhbGRiUHJvdmlkZXIgPSBuZXcgY3IuUHJvdmlkZXIodGhpcywgJ1VwZ3JhZGVnbG9iYWxkYlByb3ZpZGVyJywge1xuICAgICAgb25FdmVudEhhbmRsZXI6IG9uRXZlbnQsXG4gICAgICBsb2dSZXRlbnRpb246IGxvZ3MuUmV0ZW50aW9uRGF5cy5PTkVfREFZLFxuICAgIH0pO1xuXG4gICAgdGhpcy5jckdsb2JhbFJEU1Byb3ZpZGVyID0gbmV3IGNkay5DdXN0b21SZXNvdXJjZSh0aGlzLCAnQ1JVcGdyYWRlZ2xvYmFsZGJQcm92aWRlcicsIHtcbiAgICAgIHJlc291cmNlVHlwZTogJ0N1c3RvbTo6VXBncmFkZUdsb2JhbENsdXN0ZXJQcm92aWRlcicsXG4gICAgICBzZXJ2aWNlVG9rZW46IFVwZ3JhZGVnbG9iYWxkYlByb3ZpZGVyLnNlcnZpY2VUb2tlbixcbiAgICAgIHByb3BlcnRpZXM6IHtcbiAgICAgICAgU291cmNlREJDbHVzdGVySWRlbnRpZmllcjogYGFybjphd3M6cmRzOiR7c3RhY2sucmVnaW9ufToke3N0YWNrLmFjY291bnR9OmNsdXN0ZXI6JHt0aGlzLnJkc0NsdXN0ZXIuY2x1c3RlcklkZW50aWZpZXJ9YCxcbiAgICAgICAgR2xvYmFsQ2x1c3RlcklkZW50aWZpZXI6IGBnbG9iYWwtJHtzdGFjay5zdGFja05hbWUudG9Mb3dlckNhc2UoKX1gLFxuICAgICAgfSxcbiAgICB9KTtcblxuICAgIHRoaXMuY3JHbG9iYWxSRFNQcm92aWRlci5ub2RlLmFkZERlcGVuZGVuY3kodGhpcy5yZHNDbHVzdGVyKTtcbiAgICBvbkV2ZW50LnJvbGU/LmFkZFRvUHJpbmNpcGFsUG9saWN5KEN1c3RvbVJlc291cmNlUG9saWN5KTtcbiAgICB0aGlzLnJkc0lzUHVibGljID0gcmRzVnBjU3VibmV0U2VsZWN0O1xuICAgIG5ldyBjZGsuQ2ZuT3V0cHV0KHRoaXMsICdSRFNpc1B1YmxpYycsIHtcbiAgICAgIHZhbHVlOiB0aGlzLnJkc0lzUHVibGljLFxuICAgIH0pO1xuXG4gICAgdGhpcy5yZHNDbHVzdGVyYXJuID0gYGFybjphd3M6cmRzOiR7c3RhY2sucmVnaW9ufToke3N0YWNrLmFjY291bnR9OmNsdXN0ZXI6JHt0aGlzLnJkc0NsdXN0ZXIuY2x1c3RlcklkZW50aWZpZXJ9YDtcbiAgICBuZXcgY2RrLkNmbk91dHB1dCh0aGlzLCAnUkRTQ2x1c3RlcmFybicsIHtcbiAgICAgIHZhbHVlOiB0aGlzLnJkc0NsdXN0ZXJhcm4sXG4gICAgfSk7XG5cbiAgICB0aGlzLmdsb2JhbENsdXN0ZXJJZGVudGlmaWVyID0gYGdsb2JhbC0ke3N0YWNrLnN0YWNrTmFtZS50b0xvd2VyQ2FzZSgpfWA7XG4gICAgbmV3IGNkay5DZm5PdXRwdXQodGhpcywgJ0dsb2JhbENsdXN0ZXJJZGVudGlmaWVyJywge1xuICAgICAgdmFsdWU6IHRoaXMuZ2xvYmFsQ2x1c3RlcklkZW50aWZpZXIsXG4gICAgfSk7XG5cbiAgICB0aGlzLmVuZ2luZSA9IGNkay5Ub2tlbi5hc1N0cmluZyh0aGlzLmNyR2xvYmFsUkRTUHJvdmlkZXIuZ2V0QXR0KCdFbmdpbmUnKSk7XG4gICAgbmV3IGNkay5DZm5PdXRwdXQodGhpcywgJ0VuZ2luZScsIHtcbiAgICAgIHZhbHVlOiB0aGlzLmVuZ2luZSxcbiAgICB9KTtcblxuICAgIHRoaXMuY2x1c3RlckVuZ2luZVZlcnNpb24gPSBjZGsuVG9rZW4uYXNTdHJpbmcodGhpcy5jckdsb2JhbFJEU1Byb3ZpZGVyLmdldEF0dCgnRW5naW5lVmVyc2lvbicpKTtcbiAgICBuZXcgY2RrLkNmbk91dHB1dCh0aGlzLCAnY2x1c3RlckVuZ2luZVZlcnNpb24nLCB7XG4gICAgICB2YWx1ZTogdGhpcy5jbHVzdGVyRW5naW5lVmVyc2lvbixcbiAgICB9KTtcblxuICAgIHRoaXMuZ2xvYmFsQ2x1c3RlckFybiA9IGNkay5Ub2tlbi5hc1N0cmluZyh0aGlzLmNyR2xvYmFsUkRTUHJvdmlkZXIuZ2V0QXR0KCdHbG9iYWxDbHVzdGVyQXJuJykpO1xuICAgIG5ldyBjZGsuQ2ZuT3V0cHV0KHRoaXMsICdHbG9iYWxDbHVzdGVyQXJuJywge1xuICAgICAgdmFsdWU6IHRoaXMuZ2xvYmFsQ2x1c3RlckFybixcbiAgICB9KTtcblxuICAgIG5ldyBjZGsuQ2ZuT3V0cHV0KHRoaXMsICdHbG9iYWxDbHVzdGVyUHJpbWFyeUVuZHBvaW50Jywge1xuICAgICAgdmFsdWU6IHRoaXMucmRzQ2x1c3Rlci5jbHVzdGVyRW5kcG9pbnQuaG9zdG5hbWUsXG4gICAgfSk7XG4gIH1cbiAgcHJpdmF0ZSBhek9mU3VibmV0cyhzdWJuZXRzOiBlYzIuSVN1Ym5ldFtdKTogbnVtYmVyIHtcbiAgICByZXR1cm4gbmV3IFNldChzdWJuZXRzLm1hcChzdWJuZXQgPT4gc3VibmV0LmF2YWlsYWJpbGl0eVpvbmUpKS5zaXplO1xuICB9XG5cbiAgcHVibGljIGFkZFJlZ2lvbmFsQ2x1c3RlcihzY29wZTogY2RrLkNvbnN0cnVjdCwgaWQ6IHN0cmluZywgb3B0aW9uczogUmVnaW9uYWxPcHRpb25zKSB7XG4gICAgY29uc3Qgc3RhY2sgPSBjZGsuU3RhY2sub2Yoc2NvcGUpO1xuICAgIC8vIGN1c3RvbSByZXNvdXJjZSBwb2xpY3lcbiAgICBjb25zdCBDdXN0b21SZXNvdXJjZVBvbGljeSA9IG5ldyBpYW0uUG9saWN5U3RhdGVtZW50KHtcbiAgICAgIHJlc291cmNlczogWycqJ10sXG4gICAgICBhY3Rpb25zOiBbXG4gICAgICAgICdyZHM6Q3JlYXRlR2xvYmFsQ2x1c3RlcicsICdyZHM6RGVsZXRlR2xvYmFsQ2x1c3RlcicsICdyZHM6UmVtb3ZlRnJvbUdsb2JhbENsdXN0ZXInLCAncmRzOk1vZGlmeUdsb2JhbENsdXN0ZXInLFxuICAgICAgICAncmRzOkNyZWF0ZURCQ2x1c3RlcicsICdyZHM6Q3JlYXRlREJJbnN0YW5jZScsICdyZHM6RGVsZXRlREJDbHVzdGVyJywgJ3JkczpEZWxldGVEQkluc3RhbmNlJywgJ3JkczpEZXNjcmliZURCSW5zdGFuY2VzJyxcbiAgICAgICAgJ3JkczpEZXNjcmliZUdsb2JhbENsdXN0ZXJzJyxcbiAgICAgIF0sXG4gICAgfSk7XG4gICAgLy8gVXBncmFkZSBkYXRhYmFzZSB0byBHbG9iYWwuXG4gICAgY29uc3Qgb25FdmVudCA9IG5ldyBsYW1iZGEuRnVuY3Rpb24oc2NvcGUsIGAke2lkfS1hZGRSZWdpb25hbG9uRXZlbnRgLCB7XG4gICAgICBydW50aW1lOiBsYW1iZGEuUnVudGltZS5QWVRIT05fM184LFxuICAgICAgY29kZTogbGFtYmRhLkNvZGUuZnJvbUFzc2V0KHBhdGguam9pbihfX2Rpcm5hbWUsICcuLi9jdXN0b20tcmVzb3VyY2UtaGFuZGxlcicpKSxcbiAgICAgIGhhbmRsZXI6ICdhZGRfcmVnaW9uX2luZGV4Lm9uX2V2ZW50JyxcbiAgICAgIHRpbWVvdXQ6IGNkay5EdXJhdGlvbi5taW51dGVzKDEwKSxcbiAgICB9KTtcblxuICAgIGNvbnN0IGlzQ29tcGxldGUgPSBuZXcgbGFtYmRhLkZ1bmN0aW9uKHNjb3BlLCBgJHtpZH0tSXNDb21wbGV0ZWAsIHtcbiAgICAgIGNvZGU6IGxhbWJkYS5Db2RlLmZyb21Bc3NldChwYXRoLmpvaW4oX19kaXJuYW1lLCAnLi4vY3VzdG9tLXJlc291cmNlLWhhbmRsZXInKSksXG4gICAgICBoYW5kbGVyOiAnYWRkX3JlZ2lvbl9pbmRleC5pc19jb21wbGV0ZScsXG4gICAgICBydW50aW1lOiBsYW1iZGEuUnVudGltZS5QWVRIT05fM184LFxuICAgICAgdGltZW91dDogY2RrLkR1cmF0aW9uLm1pbnV0ZXMoMTApLFxuICAgICAgcm9sZTogb25FdmVudC5yb2xlLFxuICAgIH0pO1xuXG4gICAgY29uc3QgYWRkUmVnaW9uYWxQcm92aWRlciA9IG5ldyBjci5Qcm92aWRlcihzY29wZSwgYCR7aWR9LWFkZFJlZ2lvbmFsUHJvdmlkZXJgLCB7XG4gICAgICBvbkV2ZW50SGFuZGxlcjogb25FdmVudCxcbiAgICAgIGlzQ29tcGxldGVIYW5kbGVyOiBpc0NvbXBsZXRlLFxuICAgICAgbG9nUmV0ZW50aW9uOiBsb2dzLlJldGVudGlvbkRheXMuT05FX0RBWSxcbiAgICB9KTtcblxuICAgIGNvbnN0IENSU2Vjb25kUkRTUHJvdmlkZXIgPSBuZXcgY2RrLkN1c3RvbVJlc291cmNlKHNjb3BlLCBgJHtpZH0tYWRkUmVnaW9uYWxDdXN0b21SZXNvdXJjZWAsIHtcbiAgICAgIHJlc291cmNlVHlwZTogJ0N1c3RvbTo6YWRkUmVnaW9uYWxDbHVzdGVyUHJvdmlkZXInLFxuICAgICAgc2VydmljZVRva2VuOiBhZGRSZWdpb25hbFByb3ZpZGVyLnNlcnZpY2VUb2tlbixcbiAgICAgIHByb3BlcnRpZXM6IHtcbiAgICAgICAgU291cmNlREJDbHVzdGVySWRlbnRpZmllcjogdGhpcy5yZHNDbHVzdGVyYXJuLFxuICAgICAgICBHbG9iYWxDbHVzdGVySWRlbnRpZmllcjogdGhpcy5nbG9iYWxDbHVzdGVySWRlbnRpZmllcixcbiAgICAgICAgUkVHSU9OOiBvcHRpb25zLnJlZ2lvbixcbiAgICAgICAgREJTdWJuZXRHcm91cE5hbWU6IG9wdGlvbnMuZGJTdWJuZXRHcm91cE5hbWUsXG4gICAgICAgIEVuZ2luZTogdGhpcy5lbmdpbmUsXG4gICAgICAgIEVuZ2luZVZlcnNpb246IHRoaXMuY2x1c3RlckVuZ2luZVZlcnNpb24sXG4gICAgICAgIENsdXN0ZXJJZGVudGlmaWVyOiBgJHtzdGFjay5zdGFja05hbWUudG9Mb3dlckNhc2UoKX0tJHtvcHRpb25zLnJlZ2lvbn1gLFxuICAgICAgICBJbnN0YW5jZVR5cGU6IHRoaXMucmRzSW5zdGFuY2VUeXBlLFxuICAgICAgICByZHNJc1B1YmxpYzogdGhpcy5yZHNJc1B1YmxpYyxcbiAgICAgICAgc2Vjb25kUkRTQ2x1c3RlckFybjogYGFybjphd3M6cmRzOiR7b3B0aW9ucy5yZWdpb259OiR7c3RhY2suYWNjb3VudH06Y2x1c3Rlcjoke3N0YWNrLnN0YWNrTmFtZS50b0xvd2VyQ2FzZSgpfS0ke29wdGlvbnMucmVnaW9ufWAsXG4gICAgICAgIHNlY29uZGRiSW5zdGFuY2VJZGVudGlmaWVyOiBgJHtzdGFjay5zdGFja05hbWUudG9Mb3dlckNhc2UoKX0tJHtvcHRpb25zLnJlZ2lvbn0tMWAsXG4gICAgICB9LFxuICAgIH0pO1xuICAgIENSU2Vjb25kUkRTUHJvdmlkZXIubm9kZS5hZGREZXBlbmRlbmN5KHRoaXMuY3JHbG9iYWxSRFNQcm92aWRlcik7XG4gICAgb25FdmVudC5yb2xlPy5hZGRUb1ByaW5jaXBhbFBvbGljeShDdXN0b21SZXNvdXJjZVBvbGljeSk7XG5cbiAgICBuZXcgY2RrLkNmbk91dHB1dChzY29wZSwgJ3NlY29uZFJEU0NsdXN0ZXJBcm4nLCB7XG4gICAgICB2YWx1ZTogY2RrLlRva2VuLmFzU3RyaW5nKENSU2Vjb25kUkRTUHJvdmlkZXIuZ2V0QXR0KCdzZWNvbmRSRFNDbHVzdGVyQXJuJykpLFxuICAgIH0pO1xuXG4gICAgbmV3IGNkay5DZm5PdXRwdXQoc2NvcGUsICdzZWNvbmRkYkluc3RhbmNlSWRlbnRpZmllcicsIHtcbiAgICAgIHZhbHVlOiBjZGsuVG9rZW4uYXNTdHJpbmcoQ1JTZWNvbmRSRFNQcm92aWRlci5nZXRBdHQoJ3NlY29uZGRiSW5zdGFuY2VJZGVudGlmaWVyJykpLFxuICAgIH0pO1xuICB9XG59XG5cbmV4cG9ydCBpbnRlcmZhY2UgR29sYmFsQXVyb3JhUkRTU2xhdmVJbmZyYVByb3BzIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgdnBjPzogZWMyLklWcGM7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHN1Ym5ldFR5cGU/OiBlYzIuU3VibmV0VHlwZTtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHN0YWNrPzogY2RrLlN0YWNrO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGRlbGV0aW9uUHJvdGVjdGlvbj86IGJvb2xlYW47XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBzdG9yYWdlRW5jcnlwdGVkPzogYm9vbGVhbjtcbn1cblxuZXhwb3J0IGNsYXNzIEdvbGJhbEF1cm9yYVJEU1NsYXZlSW5mcmEgZXh0ZW5kcyBjZGsuQ29uc3RydWN0IHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBkYlN1Ym5ldEdyb3VwOnJkcy5DZm5EQlN1Ym5ldEdyb3VwO1xuICBjb25zdHJ1Y3RvcihzY29wZTogY2RrLkNvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM/OiBHb2xiYWxBdXJvcmFSRFNTbGF2ZUluZnJhUHJvcHMgKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkKTtcbiAgICBjb25zdCBzdGFjayA9IGNkay5TdGFjay5vZih0aGlzKTtcbiAgICBpZiAoR2xvYmFsQXVyb3JhUkRTU3VwcG9ydFJlZ2lvbi5pbmRleE9mKHN0YWNrLnJlZ2lvbikgPT0gLTEgKSB7XG4gICAgICB0aHJvdyBuZXcgRXJyb3IoYFRoaXMgcmVnaW9uICR7c3RhY2sucmVnaW9ufSBub3QgU3VwcG9ydCBHbG9iYWwgUkRTICEhIWApO1xuICAgIH1cbiAgICAvLyBTbGF2ZSByZWdpb24gVnBjXG4gICAgY29uc3QgcmRzVnBjU2Vjb25kID0gcHJvcHM/LnZwYyA/PyBuZXcgZWMyLlZwYyh0aGlzLCAnUkRTVnBjUmVnaW9uU2xhdmUnLCB7XG4gICAgICBjaWRyOiAnMTAuMTA5LjAuMC8xNicsXG4gICAgICBlbmFibGVEbnNIb3N0bmFtZXM6IHRydWUsXG4gICAgICBlbmFibGVEbnNTdXBwb3J0OiB0cnVlLFxuICAgICAgbmF0R2F0ZXdheXM6IDEsXG4gICAgfSk7XG5cbiAgICBjb25zdCBEQnN1Ym5ldFR5cGUgPSBwcm9wcz8uc3VibmV0VHlwZSA/PyBlYzIuU3VibmV0VHlwZS5QUklWQVRFO1xuICAgIGlmIChEQnN1Ym5ldFR5cGUgPT09IGVjMi5TdWJuZXRUeXBlLlBSSVZBVEUpIHtcbiAgICAgIGNvbnN0IFByaXZhdGVTdWJuZXQgPSByZHNWcGNTZWNvbmQuc2VsZWN0U3VibmV0cyh7IHN1Ym5ldFR5cGU6IGVjMi5TdWJuZXRUeXBlLlBSSVZBVEUgfSk7XG4gICAgICB0aGlzLmRiU3VibmV0R3JvdXAgPSBuZXcgcmRzLkNmbkRCU3VibmV0R3JvdXAodGhpcywgJ1N1Ym5ldHMnLCB7XG4gICAgICAgIGRiU3VibmV0R3JvdXBOYW1lOiBgJHtzdGFjay5zdGFja05hbWUudG9Mb3dlckNhc2UoKX0tcHJpdmF0ZXN1Ym5ldGdyb3VwYCxcbiAgICAgICAgZGJTdWJuZXRHcm91cERlc2NyaXB0aW9uOiAnUHJpdmF0ZSBTdWJuZXRzIGZvciBkYXRhYmFzZScsXG4gICAgICAgIHN1Ym5ldElkczogUHJpdmF0ZVN1Ym5ldC5zdWJuZXRJZHMsXG4gICAgICB9KTtcblxuICAgICAgY2RrLlRhZ3Mub2YodGhpcy5kYlN1Ym5ldEdyb3VwKS5hZGQoJ05hbWUnLCAnUHJpdmF0ZURCU3VibmV0R3JvdXAnKTtcbiAgICAgIHRoaXMuZGJTdWJuZXRHcm91cC5ub2RlLmFkZERlcGVuZGVuY3kocmRzVnBjU2Vjb25kKTtcbiAgICB9IGVsc2Uge1xuICAgICAgY29uc3QgUHVibGljU3VibmV0ID0gcmRzVnBjU2Vjb25kLnNlbGVjdFN1Ym5ldHMoeyBzdWJuZXRUeXBlOiBlYzIuU3VibmV0VHlwZS5QVUJMSUMgfSk7XG4gICAgICB0aGlzLmRiU3VibmV0R3JvdXAgPSBuZXcgcmRzLkNmbkRCU3VibmV0R3JvdXAodGhpcywgJ1N1Ym5ldHMnLCB7XG4gICAgICAgIGRiU3VibmV0R3JvdXBOYW1lOiBgJHtzdGFjay5zdGFja05hbWUudG9Mb3dlckNhc2UoKX0tcHVibGljc3VibmV0Z3JvdXBgLFxuICAgICAgICBkYlN1Ym5ldEdyb3VwRGVzY3JpcHRpb246ICdQdWJsaWMgU3VibmV0cyBmb3IgZGF0YWJhc2UnLFxuICAgICAgICBzdWJuZXRJZHM6IFB1YmxpY1N1Ym5ldC5zdWJuZXRJZHMsXG4gICAgICB9KTtcblxuICAgICAgY2RrLlRhZ3Mub2YodGhpcy5kYlN1Ym5ldEdyb3VwKS5hZGQoJ05hbWUnLCAnUHVibGljREJTdWJuZXRHcm91cCcpO1xuICAgICAgdGhpcy5kYlN1Ym5ldEdyb3VwLm5vZGUuYWRkRGVwZW5kZW5jeShyZHNWcGNTZWNvbmQpO1xuICAgIH1cbiAgICBuZXcgY2RrLkNmbk91dHB1dCh0aGlzLCAnbmV3REJTdWJuZXRHcm91cCcsIHtcbiAgICAgIHZhbHVlOiBgJHt0aGlzLmRiU3VibmV0R3JvdXAuZGJTdWJuZXRHcm91cE5hbWV9YCxcbiAgICB9KTtcblxuICAgIG5ldyBjZGsuQ2ZuT3V0cHV0KHRoaXMsICdzdGFja1JlZ2lvbicsIHtcbiAgICAgIHZhbHVlOiBgJHtzdGFjay5yZWdpb259YCxcbiAgICB9KTtcbiAgfVxufVxuIl19