"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const ec2 = require("@aws-cdk/aws-ec2");
const _rds = require("@aws-cdk/aws-rds");
const core_1 = require("@aws-cdk/core");
const index_1 = require("./index");
const mockApp = new core_1.App();
const envSingapro = { account: process.env.CDK_DEFAULT_ACCOUNT, region: 'ap-southeast-1' };
const envTokyo = { account: process.env.CDK_DEFAULT_ACCOUNT, region: 'ap-northeast-1' };
const stackM = new core_1.Stack(mockApp, 'testing-stackM', { env: envTokyo });
const vpcPublic = new ec2.Vpc(stackM, 'defaultVpc', {
    natGateways: 0,
    maxAzs: 3,
    subnetConfiguration: [{
            cidrMask: 26,
            name: 'masterVPC2',
            subnetType: ec2.SubnetType.PUBLIC,
        }],
});
const globaldbM = new index_1.GolbalAuroraRDSMaster(stackM, 'golbalAuroraRDSMaster', {
    instanceType: index_1.InstanceTypeEnum.R5_LARGE,
    vpc: vpcPublic,
    //rdsPassword: '1qaz2wsx',
    engineVersion: _rds.DatabaseClusterEngine.auroraPostgres({ version: _rds.AuroraPostgresEngineVersion.VER_11_7 }),
    dbClusterpPG: new _rds.ParameterGroup(stackM, 'dbClusterparametergroup', {
        engine: _rds.DatabaseClusterEngine.auroraPostgres({
            version: _rds.AuroraPostgresEngineVersion.VER_11_7,
        }),
        parameters: {
            'rds.force_ssl': '1',
            'rds.log_retention_period': '10080',
            'auto_explain.log_min_duration': '5000',
            'auto_explain.log_verbose': '1',
            'timezone': 'UTC+8',
            'shared_preload_libraries': 'auto_explain,pg_stat_statements,pg_hint_plan,pgaudit',
            'log_connections': '1',
            'log_statement': 'ddl',
            'log_disconnections': '1',
            'log_lock_waits': '1',
            'log_min_duration_statement': '5000',
            'log_rotation_age': '1440',
            'log_rotation_size': '102400',
            'random_page_cost': '1',
            'track_activity_query_size': '16384',
            'idle_in_transaction_session_timeout': '7200000',
        },
    }),
});
globaldbM.rdsCluster.connections.allowDefaultPortFrom(ec2.Peer.ipv4(`${process.env.MYIP}/32`));
const stackS = new core_1.Stack(mockApp, 'testing-stackS', { env: envSingapro });
const vpcPublic2 = new ec2.Vpc(stackS, 'defaultVpc2', {
    natGateways: 0,
    maxAzs: 3,
    subnetConfiguration: [{
            cidrMask: 26,
            name: 'secondVPC2',
            subnetType: ec2.SubnetType.PUBLIC,
        }],
});
const globaldbS = new index_1.GolbalAuroraRDSSlaveInfra(stackS, 'slaveregion', {
    vpc: vpcPublic2,
    subnetType: ec2.SubnetType.PUBLIC,
});
stackM.addDependency(stackS);
new core_1.CfnOutput(stackM, 'password', { value: `${globaldbM.rdsPassword}` });
// add second region cluster
globaldbM.addRegionalCluster(stackM, 'addregionalrds', {
    region: 'ap-southeast-1',
    dbSubnetGroupName: globaldbS.dbSubnetGroup.dbSubnetGroupName,
});
//# sourceMappingURL=data:application/json;base64,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