# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.raw_devices import RawDevices
from .raw_client import AsyncRawDevicesClient, RawDevicesClient


class DevicesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawDevicesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawDevicesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawDevicesClient
        """
        return self._raw_client

    def get_raw(
        self,
        user_id: str,
        *,
        provider: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> RawDevices:
        """
        Get Devices for user_id

        Parameters
        ----------
        user_id : str

        provider : typing.Optional[str]
            Provider oura/strava etc

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        RawDevices
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.devices.get_raw(user_id='user_id', )
        """
        _response = self._raw_client.get_raw(user_id, provider=provider, request_options=request_options)
        return _response.data


class AsyncDevicesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawDevicesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawDevicesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawDevicesClient
        """
        return self._raw_client

    async def get_raw(
        self,
        user_id: str,
        *,
        provider: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> RawDevices:
        """
        Get Devices for user_id

        Parameters
        ----------
        user_id : str

        provider : typing.Optional[str]
            Provider oura/strava etc

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        RawDevices
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.devices.get_raw(user_id='user_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_raw(user_id, provider=provider, request_options=request_options)
        return _response.data
