# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.http_response import AsyncHttpResponse, HttpResponse
from ..core.pydantic_utilities import parse_obj_as
from ..core.request_options import RequestOptions
from ..errors.unprocessable_entity_error import UnprocessableEntityError
from ..types.http_validation_error import HttpValidationError
from ..types.providers import Providers
from ..types.user_historical_pulls_response import UserHistoricalPullsResponse
from ..types.user_resources_response import UserResourcesResponse


class RawIntrospectClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def get_user_resources(
        self,
        *,
        user_id: typing.Optional[str] = None,
        provider: typing.Optional[Providers] = None,
        user_limit: typing.Optional[int] = None,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[UserResourcesResponse]:
        """
        Parameters
        ----------
        user_id : typing.Optional[str]
            Filter by user ID.

        provider : typing.Optional[Providers]

        user_limit : typing.Optional[int]

        cursor : typing.Optional[str]

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[UserResourcesResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "v2/introspect/resources",
            method="GET",
            params={
                "user_id": user_id,
                "provider": provider,
                "user_limit": user_limit,
                "cursor": cursor,
                "next_cursor": next_cursor,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    UserResourcesResponse,
                    parse_obj_as(
                        type_=UserResourcesResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_user_historical_pulls(
        self,
        *,
        user_id: typing.Optional[str] = None,
        provider: typing.Optional[Providers] = None,
        user_limit: typing.Optional[int] = None,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[UserHistoricalPullsResponse]:
        """
        Parameters
        ----------
        user_id : typing.Optional[str]
            Filter by user ID.

        provider : typing.Optional[Providers]

        user_limit : typing.Optional[int]

        cursor : typing.Optional[str]

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[UserHistoricalPullsResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "v2/introspect/historical_pull",
            method="GET",
            params={
                "user_id": user_id,
                "provider": provider,
                "user_limit": user_limit,
                "cursor": cursor,
                "next_cursor": next_cursor,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    UserHistoricalPullsResponse,
                    parse_obj_as(
                        type_=UserHistoricalPullsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawIntrospectClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def get_user_resources(
        self,
        *,
        user_id: typing.Optional[str] = None,
        provider: typing.Optional[Providers] = None,
        user_limit: typing.Optional[int] = None,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[UserResourcesResponse]:
        """
        Parameters
        ----------
        user_id : typing.Optional[str]
            Filter by user ID.

        provider : typing.Optional[Providers]

        user_limit : typing.Optional[int]

        cursor : typing.Optional[str]

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[UserResourcesResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v2/introspect/resources",
            method="GET",
            params={
                "user_id": user_id,
                "provider": provider,
                "user_limit": user_limit,
                "cursor": cursor,
                "next_cursor": next_cursor,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    UserResourcesResponse,
                    parse_obj_as(
                        type_=UserResourcesResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_user_historical_pulls(
        self,
        *,
        user_id: typing.Optional[str] = None,
        provider: typing.Optional[Providers] = None,
        user_limit: typing.Optional[int] = None,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[UserHistoricalPullsResponse]:
        """
        Parameters
        ----------
        user_id : typing.Optional[str]
            Filter by user ID.

        provider : typing.Optional[Providers]

        user_limit : typing.Optional[int]

        cursor : typing.Optional[str]

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[UserHistoricalPullsResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v2/introspect/historical_pull",
            method="GET",
            params={
                "user_id": user_id,
                "provider": provider,
                "user_limit": user_limit,
                "cursor": cursor,
                "next_cursor": next_cursor,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    UserHistoricalPullsResponse,
                    parse_obj_as(
                        type_=UserHistoricalPullsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
