# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.client_facing_sleep_stream import ClientFacingSleepStream
from ..types.client_sleep_response import ClientSleepResponse
from ..types.raw_sleep import RawSleep
from .raw_client import AsyncRawSleepClient, RawSleepClient


class SleepClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawSleepClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawSleepClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawSleepClient
        """
        return self._raw_client

    def get(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ClientSleepResponse:
        """
        Get sleep summary for user_id

        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ClientSleepResponse
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.sleep.get(user_id='user_id', start_date='start_date', )
        """
        _response = self._raw_client.get(
            user_id, start_date=start_date, provider=provider, end_date=end_date, request_options=request_options
        )
        return _response.data

    def get_raw(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> RawSleep:
        """
        Get raw sleep summary for user_id

        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        RawSleep
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.sleep.get_raw(user_id='user_id', start_date='start_date', )
        """
        _response = self._raw_client.get_raw(
            user_id, start_date=start_date, provider=provider, end_date=end_date, request_options=request_options
        )
        return _response.data

    def get_stream_by_sleep_id(
        self, sleep_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ClientFacingSleepStream:
        """
        Get Sleep stream for a user_id

        Parameters
        ----------
        sleep_id : str
            The Vital Sleep ID

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ClientFacingSleepStream
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.sleep.get_stream_by_sleep_id(sleep_id='sleep_id', )
        """
        _response = self._raw_client.get_stream_by_sleep_id(sleep_id, request_options=request_options)
        return _response.data


class AsyncSleepClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawSleepClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawSleepClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawSleepClient
        """
        return self._raw_client

    async def get(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ClientSleepResponse:
        """
        Get sleep summary for user_id

        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ClientSleepResponse
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.sleep.get(user_id='user_id', start_date='start_date', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get(
            user_id, start_date=start_date, provider=provider, end_date=end_date, request_options=request_options
        )
        return _response.data

    async def get_raw(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> RawSleep:
        """
        Get raw sleep summary for user_id

        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        RawSleep
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.sleep.get_raw(user_id='user_id', start_date='start_date', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_raw(
            user_id, start_date=start_date, provider=provider, end_date=end_date, request_options=request_options
        )
        return _response.data

    async def get_stream_by_sleep_id(
        self, sleep_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ClientFacingSleepStream:
        """
        Get Sleep stream for a user_id

        Parameters
        ----------
        sleep_id : str
            The Vital Sleep ID

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ClientFacingSleepStream
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.sleep.get_stream_by_sleep_id(sleep_id='sleep_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_stream_by_sleep_id(sleep_id, request_options=request_options)
        return _response.data
