# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.http_response import AsyncHttpResponse, HttpResponse
from ..core.jsonable_encoder import jsonable_encoder
from ..core.pydantic_utilities import parse_obj_as
from ..core.request_options import RequestOptions
from ..errors.bad_request_error import BadRequestError
from ..errors.unprocessable_entity_error import UnprocessableEntityError
from ..types.address import Address
from ..types.client_facing_device import ClientFacingDevice
from ..types.client_facing_insurance import ClientFacingInsurance
from ..types.client_facing_provider_with_status import ClientFacingProviderWithStatus
from ..types.client_facing_user import ClientFacingUser
from ..types.client_facing_user_key import ClientFacingUserKey
from ..types.create_user_portal_url_response import CreateUserPortalUrlResponse
from ..types.ethnicity import Ethnicity
from ..types.gender_identity import GenderIdentity
from ..types.guarantor_details import GuarantorDetails
from ..types.http_validation_error import HttpValidationError
from ..types.metrics_result import MetricsResult
from ..types.paginated_users_response import PaginatedUsersResponse
from ..types.providers import Providers
from ..types.race import Race
from ..types.responsible_relationship import ResponsibleRelationship
from ..types.sexual_orientation import SexualOrientation
from ..types.user_info import UserInfo
from ..types.user_refresh_success_response import UserRefreshSuccessResponse
from ..types.user_sign_in_token_response import UserSignInTokenResponse
from ..types.user_success_response import UserSuccessResponse
from ..types.vital_core_schemas_db_schemas_lab_test_insurance_person_details import (
    VitalCoreSchemasDbSchemasLabTestInsurancePersonDetails,
)
from .types.create_user_portal_url_body_context import CreateUserPortalUrlBodyContext

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawUserClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def get_all(
        self,
        *,
        offset: typing.Optional[int] = None,
        limit: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[PaginatedUsersResponse]:
        """
        GET All users for team.

        Parameters
        ----------
        offset : typing.Optional[int]

        limit : typing.Optional[int]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[PaginatedUsersResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "v2/user",
            method="GET",
            params={
                "offset": offset,
                "limit": limit,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PaginatedUsersResponse,
                    parse_obj_as(
                        type_=PaginatedUsersResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def create(
        self,
        *,
        client_user_id: str,
        fallback_time_zone: typing.Optional[str] = OMIT,
        fallback_birth_date: typing.Optional[str] = OMIT,
        ingestion_start: typing.Optional[str] = OMIT,
        ingestion_end: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[ClientFacingUserKey]:
        """
        POST Create a Vital user given a client_user_id and returns the user_id.

        Parameters
        ----------
        client_user_id : str
            A unique ID representing the end user. Typically this will be a user ID from your application. Personally identifiable information, such as an email address or phone number, should not be used in the client_user_id.

        fallback_time_zone : typing.Optional[str]

                Fallback time zone of the user, in the form of a valid IANA tzdatabase identifier (e.g., `Europe/London` or `America/Los_Angeles`).
                Used when pulling data from sources that are completely time zone agnostic (e.g., all time is relative to UTC clock, without any time zone attributions on data points).


        fallback_birth_date : typing.Optional[str]
            Fallback date of birth of the user, in YYYY-mm-dd format. Used for calculating max heartrate for providers that don not provide users' age.

        ingestion_start : typing.Optional[str]
            Starting bound for user [data ingestion bounds](https://docs.tryvital.io/wearables/providers/data-ingestion-bounds).

        ingestion_end : typing.Optional[str]
            Ending bound for user [data ingestion bounds](https://docs.tryvital.io/wearables/providers/data-ingestion-bounds).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ClientFacingUserKey]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "v2/user",
            method="POST",
            json={
                "client_user_id": client_user_id,
                "fallback_time_zone": fallback_time_zone,
                "fallback_birth_date": fallback_birth_date,
                "ingestion_start": ingestion_start,
                "ingestion_end": ingestion_end,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ClientFacingUserKey,
                    parse_obj_as(
                        type_=ClientFacingUserKey,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_team_metrics(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[MetricsResult]:
        """
        GET metrics for team.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[MetricsResult]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "v2/user/metrics",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    MetricsResult,
                    parse_obj_as(
                        type_=MetricsResult,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_connected_providers(
        self, user_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[typing.Dict[str, typing.List[ClientFacingProviderWithStatus]]]:
        """
        GET Users connected providers

        Parameters
        ----------
        user_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[typing.Dict[str, typing.List[ClientFacingProviderWithStatus]]]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/user/providers/{jsonable_encoder(user_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.Dict[str, typing.List[ClientFacingProviderWithStatus]],
                    parse_obj_as(
                        type_=typing.Dict[str, typing.List[ClientFacingProviderWithStatus]],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_latest_user_info(
        self, user_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[UserInfo]:
        """
        Parameters
        ----------
        user_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[UserInfo]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/user/{jsonable_encoder(user_id)}/info/latest",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    UserInfo,
                    parse_obj_as(
                        type_=UserInfo,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def create_insurance(
        self,
        user_id: str,
        *,
        payor_code: str,
        member_id: str,
        relationship: ResponsibleRelationship,
        insured: VitalCoreSchemasDbSchemasLabTestInsurancePersonDetails,
        group_id: typing.Optional[str] = OMIT,
        guarantor: typing.Optional[GuarantorDetails] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[ClientFacingInsurance]:
        """
        Parameters
        ----------
        user_id : str

        payor_code : str

        member_id : str

        relationship : ResponsibleRelationship

        insured : VitalCoreSchemasDbSchemasLabTestInsurancePersonDetails

        group_id : typing.Optional[str]

        guarantor : typing.Optional[GuarantorDetails]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ClientFacingInsurance]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/user/{jsonable_encoder(user_id)}/insurance",
            method="POST",
            json={
                "payor_code": payor_code,
                "member_id": member_id,
                "group_id": group_id,
                "relationship": relationship,
                "insured": insured,
                "guarantor": guarantor,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ClientFacingInsurance,
                    parse_obj_as(
                        type_=ClientFacingInsurance,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_latest_insurance(
        self, user_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[ClientFacingInsurance]:
        """
        Parameters
        ----------
        user_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ClientFacingInsurance]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/user/{jsonable_encoder(user_id)}/insurance/latest",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ClientFacingInsurance,
                    parse_obj_as(
                        type_=ClientFacingInsurance,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def upsert_user_info(
        self,
        user_id: str,
        *,
        first_name: str,
        last_name: str,
        email: str,
        phone_number: str,
        gender: str,
        dob: str,
        address: Address,
        medical_proxy: typing.Optional[GuarantorDetails] = OMIT,
        race: typing.Optional[Race] = OMIT,
        ethnicity: typing.Optional[Ethnicity] = OMIT,
        sexual_orientation: typing.Optional[SexualOrientation] = OMIT,
        gender_identity: typing.Optional[GenderIdentity] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[UserInfo]:
        """
        Parameters
        ----------
        user_id : str

        first_name : str

        last_name : str

        email : str

        phone_number : str

        gender : str

        dob : str

        address : Address

        medical_proxy : typing.Optional[GuarantorDetails]

        race : typing.Optional[Race]

        ethnicity : typing.Optional[Ethnicity]

        sexual_orientation : typing.Optional[SexualOrientation]

        gender_identity : typing.Optional[GenderIdentity]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[UserInfo]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/user/{jsonable_encoder(user_id)}/info",
            method="PATCH",
            json={
                "first_name": first_name,
                "last_name": last_name,
                "email": email,
                "phone_number": phone_number,
                "gender": gender,
                "dob": dob,
                "address": address,
                "medical_proxy": medical_proxy,
                "race": race,
                "ethnicity": ethnicity,
                "sexual_orientation": sexual_orientation,
                "gender_identity": gender_identity,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    UserInfo,
                    parse_obj_as(
                        type_=UserInfo,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_by_client_user_id(
        self, client_user_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[ClientFacingUser]:
        """
        GET user_id from client_user_id.

        Parameters
        ----------
        client_user_id : str
            A unique ID representing the end user. Typically this will be a user ID number from your application. Personally identifiable information, such as an email address or phone number, should not be used in the client_user_id.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ClientFacingUser]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/user/resolve/{jsonable_encoder(client_user_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ClientFacingUser,
                    parse_obj_as(
                        type_=ClientFacingUser,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def deregister_provider(
        self, user_id: str, provider: Providers, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[UserSuccessResponse]:
        """
        Parameters
        ----------
        user_id : str

        provider : Providers
            Provider slug. e.g., `oura`, `fitbit`, `garmin`.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[UserSuccessResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/user/{jsonable_encoder(user_id)}/{jsonable_encoder(provider)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    UserSuccessResponse,
                    parse_obj_as(
                        type_=UserSuccessResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get(
        self, user_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[ClientFacingUser]:
        """
        Parameters
        ----------
        user_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ClientFacingUser]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/user/{jsonable_encoder(user_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ClientFacingUser,
                    parse_obj_as(
                        type_=ClientFacingUser,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def delete(
        self, user_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[UserSuccessResponse]:
        """
        Parameters
        ----------
        user_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[UserSuccessResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/user/{jsonable_encoder(user_id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    UserSuccessResponse,
                    parse_obj_as(
                        type_=UserSuccessResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def patch(
        self,
        user_id: str,
        *,
        fallback_time_zone: typing.Optional[str] = OMIT,
        fallback_birth_date: typing.Optional[str] = OMIT,
        ingestion_start: typing.Optional[str] = OMIT,
        ingestion_end: typing.Optional[str] = OMIT,
        client_user_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[None]:
        """
        Parameters
        ----------
        user_id : str

        fallback_time_zone : typing.Optional[str]

                Fallback time zone of the user, in the form of a valid IANA tzdatabase identifier (e.g., `Europe/London` or `America/Los_Angeles`).
                Used when pulling data from sources that are completely time zone agnostic (e.g., all time is relative to UTC clock, without any time zone attributions on data points).


        fallback_birth_date : typing.Optional[str]
            Fallback date of birth of the user, in YYYY-mm-dd format. Used for calculating max heartrate for providers that don not provide users' age.

        ingestion_start : typing.Optional[str]
            Starting bound for user [data ingestion bounds](https://docs.tryvital.io/wearables/providers/data-ingestion-bounds).

        ingestion_end : typing.Optional[str]
            Ending bound for user [data ingestion bounds](https://docs.tryvital.io/wearables/providers/data-ingestion-bounds).

        client_user_id : typing.Optional[str]
            A unique ID representing the end user. Typically this will be a user ID from your application. Personally identifiable information, such as an email address or phone number, should not be used in the client_user_id.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[None]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/user/{jsonable_encoder(user_id)}",
            method="PATCH",
            json={
                "fallback_time_zone": fallback_time_zone,
                "fallback_birth_date": fallback_birth_date,
                "ingestion_start": ingestion_start,
                "ingestion_end": ingestion_end,
                "client_user_id": client_user_id,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return HttpResponse(response=_response, data=None)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def undo_delete(
        self,
        *,
        user_id: typing.Optional[str] = None,
        client_user_id: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[UserSuccessResponse]:
        """
        Parameters
        ----------
        user_id : typing.Optional[str]
            User ID to undo deletion. Mutually exclusive with `client_user_id`.

        client_user_id : typing.Optional[str]
            Client User ID to undo deletion. Mutually exclusive with `user_id`.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[UserSuccessResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "v2/user/undo_delete",
            method="POST",
            params={
                "user_id": user_id,
                "client_user_id": client_user_id,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    UserSuccessResponse,
                    parse_obj_as(
                        type_=UserSuccessResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def refresh(
        self,
        user_id: str,
        *,
        timeout: typing.Optional[float] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[UserRefreshSuccessResponse]:
        """
        Trigger a manual refresh for a specific user

        Parameters
        ----------
        user_id : str

        timeout : typing.Optional[float]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[UserRefreshSuccessResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/user/refresh/{jsonable_encoder(user_id)}",
            method="POST",
            params={
                "timeout": timeout,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    UserRefreshSuccessResponse,
                    parse_obj_as(
                        type_=UserRefreshSuccessResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_devices(
        self, user_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[typing.List[ClientFacingDevice]]:
        """
        Parameters
        ----------
        user_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[typing.List[ClientFacingDevice]]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/user/{jsonable_encoder(user_id)}/device",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[ClientFacingDevice],
                    parse_obj_as(
                        type_=typing.List[ClientFacingDevice],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_device(
        self, user_id: str, device_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[ClientFacingDevice]:
        """
        Parameters
        ----------
        user_id : str

        device_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ClientFacingDevice]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/user/{jsonable_encoder(user_id)}/device/{jsonable_encoder(device_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ClientFacingDevice,
                    parse_obj_as(
                        type_=ClientFacingDevice,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_user_sign_in_token(
        self, user_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[UserSignInTokenResponse]:
        """
        Parameters
        ----------
        user_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[UserSignInTokenResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/user/{jsonable_encoder(user_id)}/sign_in_token",
            method="POST",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    UserSignInTokenResponse,
                    parse_obj_as(
                        type_=UserSignInTokenResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def create_portal_url(
        self,
        user_id: str,
        *,
        context: CreateUserPortalUrlBodyContext,
        order_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[CreateUserPortalUrlResponse]:
        """
        Parameters
        ----------
        user_id : str

        context : CreateUserPortalUrlBodyContext
            `launch`: Generates a short-lived (minutes) portal URL that is intended for launching a user from your
            authenticated web context directly into the Junction User Portal. This URL is not suitable for asynchronous
            communications due to its verbosity as well as short-lived nature.

            `communications`: Generates a long-lived (weeks) but shortened portal URL that is suitable for Emails, SMS
            messages and other communication channels. Users may be asked to verify their identity with Email and SMS
            authentication, e.g., when they open a short link on a new device. ℹ️ This enum is non-exhaustive.

        order_id : typing.Optional[str]
            If specified, the generated URL will deeplink to the specified Order.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[CreateUserPortalUrlResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/user/{jsonable_encoder(user_id)}/create_portal_url",
            method="POST",
            json={
                "context": context,
                "order_id": order_id,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CreateUserPortalUrlResponse,
                    parse_obj_as(
                        type_=CreateUserPortalUrlResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawUserClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def get_all(
        self,
        *,
        offset: typing.Optional[int] = None,
        limit: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[PaginatedUsersResponse]:
        """
        GET All users for team.

        Parameters
        ----------
        offset : typing.Optional[int]

        limit : typing.Optional[int]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[PaginatedUsersResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v2/user",
            method="GET",
            params={
                "offset": offset,
                "limit": limit,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PaginatedUsersResponse,
                    parse_obj_as(
                        type_=PaginatedUsersResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def create(
        self,
        *,
        client_user_id: str,
        fallback_time_zone: typing.Optional[str] = OMIT,
        fallback_birth_date: typing.Optional[str] = OMIT,
        ingestion_start: typing.Optional[str] = OMIT,
        ingestion_end: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[ClientFacingUserKey]:
        """
        POST Create a Vital user given a client_user_id and returns the user_id.

        Parameters
        ----------
        client_user_id : str
            A unique ID representing the end user. Typically this will be a user ID from your application. Personally identifiable information, such as an email address or phone number, should not be used in the client_user_id.

        fallback_time_zone : typing.Optional[str]

                Fallback time zone of the user, in the form of a valid IANA tzdatabase identifier (e.g., `Europe/London` or `America/Los_Angeles`).
                Used when pulling data from sources that are completely time zone agnostic (e.g., all time is relative to UTC clock, without any time zone attributions on data points).


        fallback_birth_date : typing.Optional[str]
            Fallback date of birth of the user, in YYYY-mm-dd format. Used for calculating max heartrate for providers that don not provide users' age.

        ingestion_start : typing.Optional[str]
            Starting bound for user [data ingestion bounds](https://docs.tryvital.io/wearables/providers/data-ingestion-bounds).

        ingestion_end : typing.Optional[str]
            Ending bound for user [data ingestion bounds](https://docs.tryvital.io/wearables/providers/data-ingestion-bounds).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ClientFacingUserKey]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v2/user",
            method="POST",
            json={
                "client_user_id": client_user_id,
                "fallback_time_zone": fallback_time_zone,
                "fallback_birth_date": fallback_birth_date,
                "ingestion_start": ingestion_start,
                "ingestion_end": ingestion_end,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ClientFacingUserKey,
                    parse_obj_as(
                        type_=ClientFacingUserKey,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_team_metrics(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[MetricsResult]:
        """
        GET metrics for team.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[MetricsResult]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v2/user/metrics",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    MetricsResult,
                    parse_obj_as(
                        type_=MetricsResult,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_connected_providers(
        self, user_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[typing.Dict[str, typing.List[ClientFacingProviderWithStatus]]]:
        """
        GET Users connected providers

        Parameters
        ----------
        user_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[typing.Dict[str, typing.List[ClientFacingProviderWithStatus]]]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/user/providers/{jsonable_encoder(user_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.Dict[str, typing.List[ClientFacingProviderWithStatus]],
                    parse_obj_as(
                        type_=typing.Dict[str, typing.List[ClientFacingProviderWithStatus]],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_latest_user_info(
        self, user_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[UserInfo]:
        """
        Parameters
        ----------
        user_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[UserInfo]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/user/{jsonable_encoder(user_id)}/info/latest",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    UserInfo,
                    parse_obj_as(
                        type_=UserInfo,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def create_insurance(
        self,
        user_id: str,
        *,
        payor_code: str,
        member_id: str,
        relationship: ResponsibleRelationship,
        insured: VitalCoreSchemasDbSchemasLabTestInsurancePersonDetails,
        group_id: typing.Optional[str] = OMIT,
        guarantor: typing.Optional[GuarantorDetails] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[ClientFacingInsurance]:
        """
        Parameters
        ----------
        user_id : str

        payor_code : str

        member_id : str

        relationship : ResponsibleRelationship

        insured : VitalCoreSchemasDbSchemasLabTestInsurancePersonDetails

        group_id : typing.Optional[str]

        guarantor : typing.Optional[GuarantorDetails]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ClientFacingInsurance]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/user/{jsonable_encoder(user_id)}/insurance",
            method="POST",
            json={
                "payor_code": payor_code,
                "member_id": member_id,
                "group_id": group_id,
                "relationship": relationship,
                "insured": insured,
                "guarantor": guarantor,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ClientFacingInsurance,
                    parse_obj_as(
                        type_=ClientFacingInsurance,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_latest_insurance(
        self, user_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[ClientFacingInsurance]:
        """
        Parameters
        ----------
        user_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ClientFacingInsurance]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/user/{jsonable_encoder(user_id)}/insurance/latest",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ClientFacingInsurance,
                    parse_obj_as(
                        type_=ClientFacingInsurance,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def upsert_user_info(
        self,
        user_id: str,
        *,
        first_name: str,
        last_name: str,
        email: str,
        phone_number: str,
        gender: str,
        dob: str,
        address: Address,
        medical_proxy: typing.Optional[GuarantorDetails] = OMIT,
        race: typing.Optional[Race] = OMIT,
        ethnicity: typing.Optional[Ethnicity] = OMIT,
        sexual_orientation: typing.Optional[SexualOrientation] = OMIT,
        gender_identity: typing.Optional[GenderIdentity] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[UserInfo]:
        """
        Parameters
        ----------
        user_id : str

        first_name : str

        last_name : str

        email : str

        phone_number : str

        gender : str

        dob : str

        address : Address

        medical_proxy : typing.Optional[GuarantorDetails]

        race : typing.Optional[Race]

        ethnicity : typing.Optional[Ethnicity]

        sexual_orientation : typing.Optional[SexualOrientation]

        gender_identity : typing.Optional[GenderIdentity]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[UserInfo]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/user/{jsonable_encoder(user_id)}/info",
            method="PATCH",
            json={
                "first_name": first_name,
                "last_name": last_name,
                "email": email,
                "phone_number": phone_number,
                "gender": gender,
                "dob": dob,
                "address": address,
                "medical_proxy": medical_proxy,
                "race": race,
                "ethnicity": ethnicity,
                "sexual_orientation": sexual_orientation,
                "gender_identity": gender_identity,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    UserInfo,
                    parse_obj_as(
                        type_=UserInfo,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_by_client_user_id(
        self, client_user_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[ClientFacingUser]:
        """
        GET user_id from client_user_id.

        Parameters
        ----------
        client_user_id : str
            A unique ID representing the end user. Typically this will be a user ID number from your application. Personally identifiable information, such as an email address or phone number, should not be used in the client_user_id.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ClientFacingUser]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/user/resolve/{jsonable_encoder(client_user_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ClientFacingUser,
                    parse_obj_as(
                        type_=ClientFacingUser,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def deregister_provider(
        self, user_id: str, provider: Providers, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[UserSuccessResponse]:
        """
        Parameters
        ----------
        user_id : str

        provider : Providers
            Provider slug. e.g., `oura`, `fitbit`, `garmin`.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[UserSuccessResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/user/{jsonable_encoder(user_id)}/{jsonable_encoder(provider)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    UserSuccessResponse,
                    parse_obj_as(
                        type_=UserSuccessResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get(
        self, user_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[ClientFacingUser]:
        """
        Parameters
        ----------
        user_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ClientFacingUser]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/user/{jsonable_encoder(user_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ClientFacingUser,
                    parse_obj_as(
                        type_=ClientFacingUser,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def delete(
        self, user_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[UserSuccessResponse]:
        """
        Parameters
        ----------
        user_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[UserSuccessResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/user/{jsonable_encoder(user_id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    UserSuccessResponse,
                    parse_obj_as(
                        type_=UserSuccessResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def patch(
        self,
        user_id: str,
        *,
        fallback_time_zone: typing.Optional[str] = OMIT,
        fallback_birth_date: typing.Optional[str] = OMIT,
        ingestion_start: typing.Optional[str] = OMIT,
        ingestion_end: typing.Optional[str] = OMIT,
        client_user_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[None]:
        """
        Parameters
        ----------
        user_id : str

        fallback_time_zone : typing.Optional[str]

                Fallback time zone of the user, in the form of a valid IANA tzdatabase identifier (e.g., `Europe/London` or `America/Los_Angeles`).
                Used when pulling data from sources that are completely time zone agnostic (e.g., all time is relative to UTC clock, without any time zone attributions on data points).


        fallback_birth_date : typing.Optional[str]
            Fallback date of birth of the user, in YYYY-mm-dd format. Used for calculating max heartrate for providers that don not provide users' age.

        ingestion_start : typing.Optional[str]
            Starting bound for user [data ingestion bounds](https://docs.tryvital.io/wearables/providers/data-ingestion-bounds).

        ingestion_end : typing.Optional[str]
            Ending bound for user [data ingestion bounds](https://docs.tryvital.io/wearables/providers/data-ingestion-bounds).

        client_user_id : typing.Optional[str]
            A unique ID representing the end user. Typically this will be a user ID from your application. Personally identifiable information, such as an email address or phone number, should not be used in the client_user_id.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[None]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/user/{jsonable_encoder(user_id)}",
            method="PATCH",
            json={
                "fallback_time_zone": fallback_time_zone,
                "fallback_birth_date": fallback_birth_date,
                "ingestion_start": ingestion_start,
                "ingestion_end": ingestion_end,
                "client_user_id": client_user_id,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return AsyncHttpResponse(response=_response, data=None)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def undo_delete(
        self,
        *,
        user_id: typing.Optional[str] = None,
        client_user_id: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[UserSuccessResponse]:
        """
        Parameters
        ----------
        user_id : typing.Optional[str]
            User ID to undo deletion. Mutually exclusive with `client_user_id`.

        client_user_id : typing.Optional[str]
            Client User ID to undo deletion. Mutually exclusive with `user_id`.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[UserSuccessResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v2/user/undo_delete",
            method="POST",
            params={
                "user_id": user_id,
                "client_user_id": client_user_id,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    UserSuccessResponse,
                    parse_obj_as(
                        type_=UserSuccessResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def refresh(
        self,
        user_id: str,
        *,
        timeout: typing.Optional[float] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[UserRefreshSuccessResponse]:
        """
        Trigger a manual refresh for a specific user

        Parameters
        ----------
        user_id : str

        timeout : typing.Optional[float]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[UserRefreshSuccessResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/user/refresh/{jsonable_encoder(user_id)}",
            method="POST",
            params={
                "timeout": timeout,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    UserRefreshSuccessResponse,
                    parse_obj_as(
                        type_=UserRefreshSuccessResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_devices(
        self, user_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[typing.List[ClientFacingDevice]]:
        """
        Parameters
        ----------
        user_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[typing.List[ClientFacingDevice]]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/user/{jsonable_encoder(user_id)}/device",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[ClientFacingDevice],
                    parse_obj_as(
                        type_=typing.List[ClientFacingDevice],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_device(
        self, user_id: str, device_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[ClientFacingDevice]:
        """
        Parameters
        ----------
        user_id : str

        device_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ClientFacingDevice]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/user/{jsonable_encoder(user_id)}/device/{jsonable_encoder(device_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ClientFacingDevice,
                    parse_obj_as(
                        type_=ClientFacingDevice,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_user_sign_in_token(
        self, user_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[UserSignInTokenResponse]:
        """
        Parameters
        ----------
        user_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[UserSignInTokenResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/user/{jsonable_encoder(user_id)}/sign_in_token",
            method="POST",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    UserSignInTokenResponse,
                    parse_obj_as(
                        type_=UserSignInTokenResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def create_portal_url(
        self,
        user_id: str,
        *,
        context: CreateUserPortalUrlBodyContext,
        order_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[CreateUserPortalUrlResponse]:
        """
        Parameters
        ----------
        user_id : str

        context : CreateUserPortalUrlBodyContext
            `launch`: Generates a short-lived (minutes) portal URL that is intended for launching a user from your
            authenticated web context directly into the Junction User Portal. This URL is not suitable for asynchronous
            communications due to its verbosity as well as short-lived nature.

            `communications`: Generates a long-lived (weeks) but shortened portal URL that is suitable for Emails, SMS
            messages and other communication channels. Users may be asked to verify their identity with Email and SMS
            authentication, e.g., when they open a short link on a new device. ℹ️ This enum is non-exhaustive.

        order_id : typing.Optional[str]
            If specified, the generated URL will deeplink to the specified Order.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[CreateUserPortalUrlResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/user/{jsonable_encoder(user_id)}/create_portal_url",
            method="POST",
            json={
                "context": context,
                "order_id": order_id,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CreateUserPortalUrlResponse,
                    parse_obj_as(
                        type_=CreateUserPortalUrlResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
