# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.client_facing_blood_oxygen_timeseries import ClientFacingBloodOxygenTimeseries
from ..types.client_facing_blood_pressure_timeseries import ClientFacingBloodPressureTimeseries
from ..types.client_facing_body_fat_timeseries import ClientFacingBodyFatTimeseries
from ..types.client_facing_body_weight_timeseries import ClientFacingBodyWeightTimeseries
from ..types.client_facing_caffeine_timeseries import ClientFacingCaffeineTimeseries
from ..types.client_facing_calories_active_timeseries import ClientFacingCaloriesActiveTimeseries
from ..types.client_facing_calories_basal_timeseries import ClientFacingCaloriesBasalTimeseries
from ..types.client_facing_cholesterol_timeseries import ClientFacingCholesterolTimeseries
from ..types.client_facing_distance_timeseries import ClientFacingDistanceTimeseries
from ..types.client_facing_electrocardiogram_voltage_timeseries import ClientFacingElectrocardiogramVoltageTimeseries
from ..types.client_facing_floors_climbed_timeseries import ClientFacingFloorsClimbedTimeseries
from ..types.client_facing_glucose_timeseries import ClientFacingGlucoseTimeseries
from ..types.client_facing_heart_rate_timeseries import ClientFacingHeartRateTimeseries
from ..types.client_facing_hrv_timeseries import ClientFacingHrvTimeseries
from ..types.client_facing_hypnogram_timeseries import ClientFacingHypnogramTimeseries
from ..types.client_facing_ige_timeseries import ClientFacingIgeTimeseries
from ..types.client_facing_igg_timeseries import ClientFacingIggTimeseries
from ..types.client_facing_mindfulness_minutes_timeseries import ClientFacingMindfulnessMinutesTimeseries
from ..types.client_facing_respiratory_rate_timeseries import ClientFacingRespiratoryRateTimeseries
from ..types.client_facing_steps_timeseries import ClientFacingStepsTimeseries
from ..types.client_facing_stress_level_timeseries import ClientFacingStressLevelTimeseries
from ..types.client_facing_vo_2_max_timeseries import ClientFacingVo2MaxTimeseries
from ..types.client_facing_water_timeseries import ClientFacingWaterTimeseries
from ..types.grouped_a_fib_burden_response import GroupedAFibBurdenResponse
from ..types.grouped_basal_body_temperature_response import GroupedBasalBodyTemperatureResponse
from ..types.grouped_blood_oxygen_response import GroupedBloodOxygenResponse
from ..types.grouped_blood_pressure_response import GroupedBloodPressureResponse
from ..types.grouped_body_fat_response import GroupedBodyFatResponse
from ..types.grouped_body_mass_index_response import GroupedBodyMassIndexResponse
from ..types.grouped_body_temperature_delta_response import GroupedBodyTemperatureDeltaResponse
from ..types.grouped_body_temperature_response import GroupedBodyTemperatureResponse
from ..types.grouped_body_weight_response import GroupedBodyWeightResponse
from ..types.grouped_caffeine_response import GroupedCaffeineResponse
from ..types.grouped_calories_active_response import GroupedCaloriesActiveResponse
from ..types.grouped_calories_basal_response import GroupedCaloriesBasalResponse
from ..types.grouped_carbohydrates_response import GroupedCarbohydratesResponse
from ..types.grouped_cholesterol_response import GroupedCholesterolResponse
from ..types.grouped_daylight_exposure_response import GroupedDaylightExposureResponse
from ..types.grouped_distance_response import GroupedDistanceResponse
from ..types.grouped_electrocardiogram_voltage_response import GroupedElectrocardiogramVoltageResponse
from ..types.grouped_fall_response import GroupedFallResponse
from ..types.grouped_floors_climbed_response import GroupedFloorsClimbedResponse
from ..types.grouped_forced_expiratory_volume_1_response import GroupedForcedExpiratoryVolume1Response
from ..types.grouped_forced_vital_capacity_response import GroupedForcedVitalCapacityResponse
from ..types.grouped_glucose_response import GroupedGlucoseResponse
from ..types.grouped_handwashing_response import GroupedHandwashingResponse
from ..types.grouped_heart_rate_alert_response import GroupedHeartRateAlertResponse
from ..types.grouped_heart_rate_recovery_one_minute_response import GroupedHeartRateRecoveryOneMinuteResponse
from ..types.grouped_heart_rate_response import GroupedHeartRateResponse
from ..types.grouped_hrv_response import GroupedHrvResponse
from ..types.grouped_hypnogram_response import GroupedHypnogramResponse
from ..types.grouped_ige_response import GroupedIgeResponse
from ..types.grouped_igg_response import GroupedIggResponse
from ..types.grouped_inhaler_usage_response import GroupedInhalerUsageResponse
from ..types.grouped_insulin_injection_response import GroupedInsulinInjectionResponse
from ..types.grouped_lean_body_mass_response import GroupedLeanBodyMassResponse
from ..types.grouped_mindfulness_minutes_response import GroupedMindfulnessMinutesResponse
from ..types.grouped_note_response import GroupedNoteResponse
from ..types.grouped_peak_expiratory_flow_rate_response import GroupedPeakExpiratoryFlowRateResponse
from ..types.grouped_respiratory_rate_response import GroupedRespiratoryRateResponse
from ..types.grouped_sleep_apnea_alert_response import GroupedSleepApneaAlertResponse
from ..types.grouped_sleep_breathing_disturbance_response import GroupedSleepBreathingDisturbanceResponse
from ..types.grouped_stand_duration_response import GroupedStandDurationResponse
from ..types.grouped_stand_hour_response import GroupedStandHourResponse
from ..types.grouped_steps_response import GroupedStepsResponse
from ..types.grouped_stress_level_response import GroupedStressLevelResponse
from ..types.grouped_uv_exposure_response import GroupedUvExposureResponse
from ..types.grouped_vo_2_max_response import GroupedVo2MaxResponse
from ..types.grouped_waist_circumference_response import GroupedWaistCircumferenceResponse
from ..types.grouped_water_response import GroupedWaterResponse
from ..types.grouped_wheelchair_push_response import GroupedWheelchairPushResponse
from ..types.grouped_workout_distance_response import GroupedWorkoutDistanceResponse
from ..types.grouped_workout_duration_response import GroupedWorkoutDurationResponse
from ..types.grouped_workout_swimming_stroke_response import GroupedWorkoutSwimmingStrokeResponse
from .raw_client import AsyncRawVitalsClient, RawVitalsClient


class VitalsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawVitalsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawVitalsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawVitalsClient
        """
        return self._raw_client

    def workout_swimming_stroke_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupedWorkoutSwimmingStrokeResponse:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupedWorkoutSwimmingStrokeResponse
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.vitals.workout_swimming_stroke_grouped(user_id='user_id', start_date='start_date', )
        """
        _response = self._raw_client.workout_swimming_stroke_grouped(
            user_id,
            start_date=start_date,
            cursor=cursor,
            next_cursor=next_cursor,
            provider=provider,
            end_date=end_date,
            request_options=request_options,
        )
        return _response.data

    def workout_distance_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupedWorkoutDistanceResponse:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupedWorkoutDistanceResponse
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.vitals.workout_distance_grouped(user_id='user_id', start_date='start_date', )
        """
        _response = self._raw_client.workout_distance_grouped(
            user_id,
            start_date=start_date,
            cursor=cursor,
            next_cursor=next_cursor,
            provider=provider,
            end_date=end_date,
            request_options=request_options,
        )
        return _response.data

    def heart_rate_recovery_one_minute_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupedHeartRateRecoveryOneMinuteResponse:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupedHeartRateRecoveryOneMinuteResponse
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.vitals.heart_rate_recovery_one_minute_grouped(user_id='user_id', start_date='start_date', )
        """
        _response = self._raw_client.heart_rate_recovery_one_minute_grouped(
            user_id,
            start_date=start_date,
            cursor=cursor,
            next_cursor=next_cursor,
            provider=provider,
            end_date=end_date,
            request_options=request_options,
        )
        return _response.data

    def waist_circumference_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupedWaistCircumferenceResponse:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupedWaistCircumferenceResponse
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.vitals.waist_circumference_grouped(user_id='user_id', start_date='start_date', )
        """
        _response = self._raw_client.waist_circumference_grouped(
            user_id,
            start_date=start_date,
            cursor=cursor,
            next_cursor=next_cursor,
            provider=provider,
            end_date=end_date,
            request_options=request_options,
        )
        return _response.data

    def lean_body_mass_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupedLeanBodyMassResponse:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupedLeanBodyMassResponse
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.vitals.lean_body_mass_grouped(user_id='user_id', start_date='start_date', )
        """
        _response = self._raw_client.lean_body_mass_grouped(
            user_id,
            start_date=start_date,
            cursor=cursor,
            next_cursor=next_cursor,
            provider=provider,
            end_date=end_date,
            request_options=request_options,
        )
        return _response.data

    def body_mass_index_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupedBodyMassIndexResponse:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupedBodyMassIndexResponse
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.vitals.body_mass_index_grouped(user_id='user_id', start_date='start_date', )
        """
        _response = self._raw_client.body_mass_index_grouped(
            user_id,
            start_date=start_date,
            cursor=cursor,
            next_cursor=next_cursor,
            provider=provider,
            end_date=end_date,
            request_options=request_options,
        )
        return _response.data

    def basal_body_temperature_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupedBasalBodyTemperatureResponse:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupedBasalBodyTemperatureResponse
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.vitals.basal_body_temperature_grouped(user_id='user_id', start_date='start_date', )
        """
        _response = self._raw_client.basal_body_temperature_grouped(
            user_id,
            start_date=start_date,
            cursor=cursor,
            next_cursor=next_cursor,
            provider=provider,
            end_date=end_date,
            request_options=request_options,
        )
        return _response.data

    def handwashing_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupedHandwashingResponse:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupedHandwashingResponse
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.vitals.handwashing_grouped(user_id='user_id', start_date='start_date', )
        """
        _response = self._raw_client.handwashing_grouped(
            user_id,
            start_date=start_date,
            cursor=cursor,
            next_cursor=next_cursor,
            provider=provider,
            end_date=end_date,
            request_options=request_options,
        )
        return _response.data

    def daylight_exposure_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupedDaylightExposureResponse:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupedDaylightExposureResponse
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.vitals.daylight_exposure_grouped(user_id='user_id', start_date='start_date', )
        """
        _response = self._raw_client.daylight_exposure_grouped(
            user_id,
            start_date=start_date,
            cursor=cursor,
            next_cursor=next_cursor,
            provider=provider,
            end_date=end_date,
            request_options=request_options,
        )
        return _response.data

    def uv_exposure_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupedUvExposureResponse:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupedUvExposureResponse
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.vitals.uv_exposure_grouped(user_id='user_id', start_date='start_date', )
        """
        _response = self._raw_client.uv_exposure_grouped(
            user_id,
            start_date=start_date,
            cursor=cursor,
            next_cursor=next_cursor,
            provider=provider,
            end_date=end_date,
            request_options=request_options,
        )
        return _response.data

    def fall_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupedFallResponse:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupedFallResponse
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.vitals.fall_grouped(user_id='user_id', start_date='start_date', )
        """
        _response = self._raw_client.fall_grouped(
            user_id,
            start_date=start_date,
            cursor=cursor,
            next_cursor=next_cursor,
            provider=provider,
            end_date=end_date,
            request_options=request_options,
        )
        return _response.data

    def inhaler_usage_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupedInhalerUsageResponse:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupedInhalerUsageResponse
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.vitals.inhaler_usage_grouped(user_id='user_id', start_date='start_date', )
        """
        _response = self._raw_client.inhaler_usage_grouped(
            user_id,
            start_date=start_date,
            cursor=cursor,
            next_cursor=next_cursor,
            provider=provider,
            end_date=end_date,
            request_options=request_options,
        )
        return _response.data

    def peak_expiratory_flow_rate_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupedPeakExpiratoryFlowRateResponse:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupedPeakExpiratoryFlowRateResponse
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.vitals.peak_expiratory_flow_rate_grouped(user_id='user_id', start_date='start_date', )
        """
        _response = self._raw_client.peak_expiratory_flow_rate_grouped(
            user_id,
            start_date=start_date,
            cursor=cursor,
            next_cursor=next_cursor,
            provider=provider,
            end_date=end_date,
            request_options=request_options,
        )
        return _response.data

    def forced_vital_capacity_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupedForcedVitalCapacityResponse:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupedForcedVitalCapacityResponse
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.vitals.forced_vital_capacity_grouped(user_id='user_id', start_date='start_date', )
        """
        _response = self._raw_client.forced_vital_capacity_grouped(
            user_id,
            start_date=start_date,
            cursor=cursor,
            next_cursor=next_cursor,
            provider=provider,
            end_date=end_date,
            request_options=request_options,
        )
        return _response.data

    def forced_expiratory_volume_1_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupedForcedExpiratoryVolume1Response:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupedForcedExpiratoryVolume1Response
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.vitals.forced_expiratory_volume_1_grouped(user_id='user_id', start_date='start_date', )
        """
        _response = self._raw_client.forced_expiratory_volume_1_grouped(
            user_id,
            start_date=start_date,
            cursor=cursor,
            next_cursor=next_cursor,
            provider=provider,
            end_date=end_date,
            request_options=request_options,
        )
        return _response.data

    def wheelchair_push_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupedWheelchairPushResponse:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupedWheelchairPushResponse
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.vitals.wheelchair_push_grouped(user_id='user_id', start_date='start_date', )
        """
        _response = self._raw_client.wheelchair_push_grouped(
            user_id,
            start_date=start_date,
            cursor=cursor,
            next_cursor=next_cursor,
            provider=provider,
            end_date=end_date,
            request_options=request_options,
        )
        return _response.data

    def sleep_breathing_disturbance_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupedSleepBreathingDisturbanceResponse:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupedSleepBreathingDisturbanceResponse
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.vitals.sleep_breathing_disturbance_grouped(user_id='user_id', start_date='start_date', )
        """
        _response = self._raw_client.sleep_breathing_disturbance_grouped(
            user_id,
            start_date=start_date,
            cursor=cursor,
            next_cursor=next_cursor,
            provider=provider,
            end_date=end_date,
            request_options=request_options,
        )
        return _response.data

    def sleep_apnea_alert_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupedSleepApneaAlertResponse:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupedSleepApneaAlertResponse
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.vitals.sleep_apnea_alert_grouped(user_id='user_id', start_date='start_date', )
        """
        _response = self._raw_client.sleep_apnea_alert_grouped(
            user_id,
            start_date=start_date,
            cursor=cursor,
            next_cursor=next_cursor,
            provider=provider,
            end_date=end_date,
            request_options=request_options,
        )
        return _response.data

    def stand_duration_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupedStandDurationResponse:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupedStandDurationResponse
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.vitals.stand_duration_grouped(user_id='user_id', start_date='start_date', )
        """
        _response = self._raw_client.stand_duration_grouped(
            user_id,
            start_date=start_date,
            cursor=cursor,
            next_cursor=next_cursor,
            provider=provider,
            end_date=end_date,
            request_options=request_options,
        )
        return _response.data

    def stand_hour_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupedStandHourResponse:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupedStandHourResponse
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.vitals.stand_hour_grouped(user_id='user_id', start_date='start_date', )
        """
        _response = self._raw_client.stand_hour_grouped(
            user_id,
            start_date=start_date,
            cursor=cursor,
            next_cursor=next_cursor,
            provider=provider,
            end_date=end_date,
            request_options=request_options,
        )
        return _response.data

    def heart_rate_alert_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupedHeartRateAlertResponse:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupedHeartRateAlertResponse
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.vitals.heart_rate_alert_grouped(user_id='user_id', start_date='start_date', )
        """
        _response = self._raw_client.heart_rate_alert_grouped(
            user_id,
            start_date=start_date,
            cursor=cursor,
            next_cursor=next_cursor,
            provider=provider,
            end_date=end_date,
            request_options=request_options,
        )
        return _response.data

    def afib_burden_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupedAFibBurdenResponse:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupedAFibBurdenResponse
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.vitals.afib_burden_grouped(user_id='user_id', start_date='start_date', )
        """
        _response = self._raw_client.afib_burden_grouped(
            user_id,
            start_date=start_date,
            cursor=cursor,
            next_cursor=next_cursor,
            provider=provider,
            end_date=end_date,
            request_options=request_options,
        )
        return _response.data

    def workout_duration_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupedWorkoutDurationResponse:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupedWorkoutDurationResponse
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.vitals.workout_duration_grouped(user_id='user_id', start_date='start_date', )
        """
        _response = self._raw_client.workout_duration_grouped(
            user_id,
            start_date=start_date,
            cursor=cursor,
            next_cursor=next_cursor,
            provider=provider,
            end_date=end_date,
            request_options=request_options,
        )
        return _response.data

    def vo_2_max_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupedVo2MaxResponse:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupedVo2MaxResponse
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.vitals.vo_2_max_grouped(user_id='user_id', start_date='start_date', )
        """
        _response = self._raw_client.vo_2_max_grouped(
            user_id,
            start_date=start_date,
            cursor=cursor,
            next_cursor=next_cursor,
            provider=provider,
            end_date=end_date,
            request_options=request_options,
        )
        return _response.data

    def stress_level_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupedStressLevelResponse:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupedStressLevelResponse
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.vitals.stress_level_grouped(user_id='user_id', start_date='start_date', )
        """
        _response = self._raw_client.stress_level_grouped(
            user_id,
            start_date=start_date,
            cursor=cursor,
            next_cursor=next_cursor,
            provider=provider,
            end_date=end_date,
            request_options=request_options,
        )
        return _response.data

    def mindfulness_minutes_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupedMindfulnessMinutesResponse:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupedMindfulnessMinutesResponse
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.vitals.mindfulness_minutes_grouped(user_id='user_id', start_date='start_date', )
        """
        _response = self._raw_client.mindfulness_minutes_grouped(
            user_id,
            start_date=start_date,
            cursor=cursor,
            next_cursor=next_cursor,
            provider=provider,
            end_date=end_date,
            request_options=request_options,
        )
        return _response.data

    def caffeine_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupedCaffeineResponse:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupedCaffeineResponse
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.vitals.caffeine_grouped(user_id='user_id', start_date='start_date', )
        """
        _response = self._raw_client.caffeine_grouped(
            user_id,
            start_date=start_date,
            cursor=cursor,
            next_cursor=next_cursor,
            provider=provider,
            end_date=end_date,
            request_options=request_options,
        )
        return _response.data

    def water_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupedWaterResponse:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupedWaterResponse
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.vitals.water_grouped(user_id='user_id', start_date='start_date', )
        """
        _response = self._raw_client.water_grouped(
            user_id,
            start_date=start_date,
            cursor=cursor,
            next_cursor=next_cursor,
            provider=provider,
            end_date=end_date,
            request_options=request_options,
        )
        return _response.data

    def steps_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupedStepsResponse:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupedStepsResponse
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.vitals.steps_grouped(user_id='user_id', start_date='start_date', )
        """
        _response = self._raw_client.steps_grouped(
            user_id,
            start_date=start_date,
            cursor=cursor,
            next_cursor=next_cursor,
            provider=provider,
            end_date=end_date,
            request_options=request_options,
        )
        return _response.data

    def floors_climbed_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupedFloorsClimbedResponse:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupedFloorsClimbedResponse
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.vitals.floors_climbed_grouped(user_id='user_id', start_date='start_date', )
        """
        _response = self._raw_client.floors_climbed_grouped(
            user_id,
            start_date=start_date,
            cursor=cursor,
            next_cursor=next_cursor,
            provider=provider,
            end_date=end_date,
            request_options=request_options,
        )
        return _response.data

    def distance_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupedDistanceResponse:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupedDistanceResponse
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.vitals.distance_grouped(user_id='user_id', start_date='start_date', )
        """
        _response = self._raw_client.distance_grouped(
            user_id,
            start_date=start_date,
            cursor=cursor,
            next_cursor=next_cursor,
            provider=provider,
            end_date=end_date,
            request_options=request_options,
        )
        return _response.data

    def calories_basal_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupedCaloriesBasalResponse:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupedCaloriesBasalResponse
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.vitals.calories_basal_grouped(user_id='user_id', start_date='start_date', )
        """
        _response = self._raw_client.calories_basal_grouped(
            user_id,
            start_date=start_date,
            cursor=cursor,
            next_cursor=next_cursor,
            provider=provider,
            end_date=end_date,
            request_options=request_options,
        )
        return _response.data

    def calories_active_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupedCaloriesActiveResponse:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupedCaloriesActiveResponse
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.vitals.calories_active_grouped(user_id='user_id', start_date='start_date', )
        """
        _response = self._raw_client.calories_active_grouped(
            user_id,
            start_date=start_date,
            cursor=cursor,
            next_cursor=next_cursor,
            provider=provider,
            end_date=end_date,
            request_options=request_options,
        )
        return _response.data

    def respiratory_rate_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupedRespiratoryRateResponse:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupedRespiratoryRateResponse
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.vitals.respiratory_rate_grouped(user_id='user_id', start_date='start_date', )
        """
        _response = self._raw_client.respiratory_rate_grouped(
            user_id,
            start_date=start_date,
            cursor=cursor,
            next_cursor=next_cursor,
            provider=provider,
            end_date=end_date,
            request_options=request_options,
        )
        return _response.data

    def note_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupedNoteResponse:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupedNoteResponse
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.vitals.note_grouped(user_id='user_id', start_date='start_date', )
        """
        _response = self._raw_client.note_grouped(
            user_id,
            start_date=start_date,
            cursor=cursor,
            next_cursor=next_cursor,
            provider=provider,
            end_date=end_date,
            request_options=request_options,
        )
        return _response.data

    def insulin_injection_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupedInsulinInjectionResponse:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupedInsulinInjectionResponse
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.vitals.insulin_injection_grouped(user_id='user_id', start_date='start_date', )
        """
        _response = self._raw_client.insulin_injection_grouped(
            user_id,
            start_date=start_date,
            cursor=cursor,
            next_cursor=next_cursor,
            provider=provider,
            end_date=end_date,
            request_options=request_options,
        )
        return _response.data

    def ige_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupedIgeResponse:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupedIgeResponse
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.vitals.ige_grouped(user_id='user_id', start_date='start_date', )
        """
        _response = self._raw_client.ige_grouped(
            user_id,
            start_date=start_date,
            cursor=cursor,
            next_cursor=next_cursor,
            provider=provider,
            end_date=end_date,
            request_options=request_options,
        )
        return _response.data

    def igg_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupedIggResponse:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupedIggResponse
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.vitals.igg_grouped(user_id='user_id', start_date='start_date', )
        """
        _response = self._raw_client.igg_grouped(
            user_id,
            start_date=start_date,
            cursor=cursor,
            next_cursor=next_cursor,
            provider=provider,
            end_date=end_date,
            request_options=request_options,
        )
        return _response.data

    def hypnogram_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupedHypnogramResponse:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupedHypnogramResponse
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.vitals.hypnogram_grouped(user_id='user_id', start_date='start_date', )
        """
        _response = self._raw_client.hypnogram_grouped(
            user_id,
            start_date=start_date,
            cursor=cursor,
            next_cursor=next_cursor,
            provider=provider,
            end_date=end_date,
            request_options=request_options,
        )
        return _response.data

    def hrv_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupedHrvResponse:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupedHrvResponse
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.vitals.hrv_grouped(user_id='user_id', start_date='start_date', )
        """
        _response = self._raw_client.hrv_grouped(
            user_id,
            start_date=start_date,
            cursor=cursor,
            next_cursor=next_cursor,
            provider=provider,
            end_date=end_date,
            request_options=request_options,
        )
        return _response.data

    def heartrate_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupedHeartRateResponse:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupedHeartRateResponse
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.vitals.heartrate_grouped(user_id='user_id', start_date='start_date', )
        """
        _response = self._raw_client.heartrate_grouped(
            user_id,
            start_date=start_date,
            cursor=cursor,
            next_cursor=next_cursor,
            provider=provider,
            end_date=end_date,
            request_options=request_options,
        )
        return _response.data

    def glucose_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupedGlucoseResponse:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupedGlucoseResponse
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.vitals.glucose_grouped(user_id='user_id', start_date='start_date', )
        """
        _response = self._raw_client.glucose_grouped(
            user_id,
            start_date=start_date,
            cursor=cursor,
            next_cursor=next_cursor,
            provider=provider,
            end_date=end_date,
            request_options=request_options,
        )
        return _response.data

    def cholesterol_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupedCholesterolResponse:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupedCholesterolResponse
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.vitals.cholesterol_grouped(user_id='user_id', start_date='start_date', )
        """
        _response = self._raw_client.cholesterol_grouped(
            user_id,
            start_date=start_date,
            cursor=cursor,
            next_cursor=next_cursor,
            provider=provider,
            end_date=end_date,
            request_options=request_options,
        )
        return _response.data

    def carbohydrates_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupedCarbohydratesResponse:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupedCarbohydratesResponse
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.vitals.carbohydrates_grouped(user_id='user_id', start_date='start_date', )
        """
        _response = self._raw_client.carbohydrates_grouped(
            user_id,
            start_date=start_date,
            cursor=cursor,
            next_cursor=next_cursor,
            provider=provider,
            end_date=end_date,
            request_options=request_options,
        )
        return _response.data

    def body_temperature_delta_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupedBodyTemperatureDeltaResponse:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupedBodyTemperatureDeltaResponse
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.vitals.body_temperature_delta_grouped(user_id='user_id', start_date='start_date', )
        """
        _response = self._raw_client.body_temperature_delta_grouped(
            user_id,
            start_date=start_date,
            cursor=cursor,
            next_cursor=next_cursor,
            provider=provider,
            end_date=end_date,
            request_options=request_options,
        )
        return _response.data

    def body_temperature_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupedBodyTemperatureResponse:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupedBodyTemperatureResponse
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.vitals.body_temperature_grouped(user_id='user_id', start_date='start_date', )
        """
        _response = self._raw_client.body_temperature_grouped(
            user_id,
            start_date=start_date,
            cursor=cursor,
            next_cursor=next_cursor,
            provider=provider,
            end_date=end_date,
            request_options=request_options,
        )
        return _response.data

    def body_weight_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupedBodyWeightResponse:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupedBodyWeightResponse
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.vitals.body_weight_grouped(user_id='user_id', start_date='start_date', )
        """
        _response = self._raw_client.body_weight_grouped(
            user_id,
            start_date=start_date,
            cursor=cursor,
            next_cursor=next_cursor,
            provider=provider,
            end_date=end_date,
            request_options=request_options,
        )
        return _response.data

    def body_fat_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupedBodyFatResponse:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupedBodyFatResponse
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.vitals.body_fat_grouped(user_id='user_id', start_date='start_date', )
        """
        _response = self._raw_client.body_fat_grouped(
            user_id,
            start_date=start_date,
            cursor=cursor,
            next_cursor=next_cursor,
            provider=provider,
            end_date=end_date,
            request_options=request_options,
        )
        return _response.data

    def blood_oxygen_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupedBloodOxygenResponse:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupedBloodOxygenResponse
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.vitals.blood_oxygen_grouped(user_id='user_id', start_date='start_date', )
        """
        _response = self._raw_client.blood_oxygen_grouped(
            user_id,
            start_date=start_date,
            cursor=cursor,
            next_cursor=next_cursor,
            provider=provider,
            end_date=end_date,
            request_options=request_options,
        )
        return _response.data

    def electrocardiogram_voltage_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupedElectrocardiogramVoltageResponse:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupedElectrocardiogramVoltageResponse
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.vitals.electrocardiogram_voltage_grouped(user_id='user_id', start_date='start_date', )
        """
        _response = self._raw_client.electrocardiogram_voltage_grouped(
            user_id,
            start_date=start_date,
            cursor=cursor,
            next_cursor=next_cursor,
            provider=provider,
            end_date=end_date,
            request_options=request_options,
        )
        return _response.data

    def blood_pressure_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupedBloodPressureResponse:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupedBloodPressureResponse
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.vitals.blood_pressure_grouped(user_id='user_id', start_date='start_date', )
        """
        _response = self._raw_client.blood_pressure_grouped(
            user_id,
            start_date=start_date,
            cursor=cursor,
            next_cursor=next_cursor,
            provider=provider,
            end_date=end_date,
            request_options=request_options,
        )
        return _response.data

    def vo_2_max(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[ClientFacingVo2MaxTimeseries]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[ClientFacingVo2MaxTimeseries]
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.vitals.vo_2_max(user_id='user_id', start_date='start_date', )
        """
        _response = self._raw_client.vo_2_max(
            user_id, start_date=start_date, provider=provider, end_date=end_date, request_options=request_options
        )
        return _response.data

    def stress_level(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[ClientFacingStressLevelTimeseries]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[ClientFacingStressLevelTimeseries]
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.vitals.stress_level(user_id='user_id', start_date='start_date', )
        """
        _response = self._raw_client.stress_level(
            user_id, start_date=start_date, provider=provider, end_date=end_date, request_options=request_options
        )
        return _response.data

    def mindfulness_minutes(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[ClientFacingMindfulnessMinutesTimeseries]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[ClientFacingMindfulnessMinutesTimeseries]
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.vitals.mindfulness_minutes(user_id='user_id', start_date='start_date', )
        """
        _response = self._raw_client.mindfulness_minutes(
            user_id, start_date=start_date, provider=provider, end_date=end_date, request_options=request_options
        )
        return _response.data

    def caffeine(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[ClientFacingCaffeineTimeseries]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[ClientFacingCaffeineTimeseries]
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.vitals.caffeine(user_id='user_id', start_date='start_date', )
        """
        _response = self._raw_client.caffeine(
            user_id, start_date=start_date, provider=provider, end_date=end_date, request_options=request_options
        )
        return _response.data

    def water(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[ClientFacingWaterTimeseries]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[ClientFacingWaterTimeseries]
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.vitals.water(user_id='user_id', start_date='start_date', )
        """
        _response = self._raw_client.water(
            user_id, start_date=start_date, provider=provider, end_date=end_date, request_options=request_options
        )
        return _response.data

    def steps(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[ClientFacingStepsTimeseries]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[ClientFacingStepsTimeseries]
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.vitals.steps(user_id='user_id', start_date='start_date', )
        """
        _response = self._raw_client.steps(
            user_id, start_date=start_date, provider=provider, end_date=end_date, request_options=request_options
        )
        return _response.data

    def floors_climbed(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[ClientFacingFloorsClimbedTimeseries]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[ClientFacingFloorsClimbedTimeseries]
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.vitals.floors_climbed(user_id='user_id', start_date='start_date', )
        """
        _response = self._raw_client.floors_climbed(
            user_id, start_date=start_date, provider=provider, end_date=end_date, request_options=request_options
        )
        return _response.data

    def distance(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[ClientFacingDistanceTimeseries]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[ClientFacingDistanceTimeseries]
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.vitals.distance(user_id='user_id', start_date='start_date', )
        """
        _response = self._raw_client.distance(
            user_id, start_date=start_date, provider=provider, end_date=end_date, request_options=request_options
        )
        return _response.data

    def calories_basal(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[ClientFacingCaloriesBasalTimeseries]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[ClientFacingCaloriesBasalTimeseries]
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.vitals.calories_basal(user_id='user_id', start_date='start_date', )
        """
        _response = self._raw_client.calories_basal(
            user_id, start_date=start_date, provider=provider, end_date=end_date, request_options=request_options
        )
        return _response.data

    def calories_active(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[ClientFacingCaloriesActiveTimeseries]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[ClientFacingCaloriesActiveTimeseries]
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.vitals.calories_active(user_id='user_id', start_date='start_date', )
        """
        _response = self._raw_client.calories_active(
            user_id, start_date=start_date, provider=provider, end_date=end_date, request_options=request_options
        )
        return _response.data

    def respiratory_rate(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[ClientFacingRespiratoryRateTimeseries]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[ClientFacingRespiratoryRateTimeseries]
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.vitals.respiratory_rate(user_id='user_id', start_date='start_date', )
        """
        _response = self._raw_client.respiratory_rate(
            user_id, start_date=start_date, provider=provider, end_date=end_date, request_options=request_options
        )
        return _response.data

    def ige(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[ClientFacingIgeTimeseries]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[ClientFacingIgeTimeseries]
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.vitals.ige(user_id='user_id', start_date='start_date', )
        """
        _response = self._raw_client.ige(
            user_id, start_date=start_date, provider=provider, end_date=end_date, request_options=request_options
        )
        return _response.data

    def igg(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[ClientFacingIggTimeseries]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[ClientFacingIggTimeseries]
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.vitals.igg(user_id='user_id', start_date='start_date', )
        """
        _response = self._raw_client.igg(
            user_id, start_date=start_date, provider=provider, end_date=end_date, request_options=request_options
        )
        return _response.data

    def hypnogram(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[ClientFacingHypnogramTimeseries]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[ClientFacingHypnogramTimeseries]
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.vitals.hypnogram(user_id='user_id', start_date='start_date', )
        """
        _response = self._raw_client.hypnogram(
            user_id, start_date=start_date, provider=provider, end_date=end_date, request_options=request_options
        )
        return _response.data

    def hrv(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[ClientFacingHrvTimeseries]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[ClientFacingHrvTimeseries]
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.vitals.hrv(user_id='user_id', start_date='start_date', )
        """
        _response = self._raw_client.hrv(
            user_id, start_date=start_date, provider=provider, end_date=end_date, request_options=request_options
        )
        return _response.data

    def heartrate(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[ClientFacingHeartRateTimeseries]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[ClientFacingHeartRateTimeseries]
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.vitals.heartrate(user_id='user_id', start_date='start_date', )
        """
        _response = self._raw_client.heartrate(
            user_id, start_date=start_date, provider=provider, end_date=end_date, request_options=request_options
        )
        return _response.data

    def glucose(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[ClientFacingGlucoseTimeseries]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[ClientFacingGlucoseTimeseries]
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.vitals.glucose(user_id='user_id', start_date='start_date', )
        """
        _response = self._raw_client.glucose(
            user_id, start_date=start_date, provider=provider, end_date=end_date, request_options=request_options
        )
        return _response.data

    def cholesterol_triglycerides(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[ClientFacingCholesterolTimeseries]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[ClientFacingCholesterolTimeseries]
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.vitals.cholesterol_triglycerides(user_id='user_id', start_date='start_date', )
        """
        _response = self._raw_client.cholesterol_triglycerides(
            user_id, start_date=start_date, provider=provider, end_date=end_date, request_options=request_options
        )
        return _response.data

    def cholesterol_total(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[ClientFacingCholesterolTimeseries]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[ClientFacingCholesterolTimeseries]
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.vitals.cholesterol_total(user_id='user_id', start_date='start_date', )
        """
        _response = self._raw_client.cholesterol_total(
            user_id, start_date=start_date, provider=provider, end_date=end_date, request_options=request_options
        )
        return _response.data

    def cholesterol_ldl(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[ClientFacingCholesterolTimeseries]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[ClientFacingCholesterolTimeseries]
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.vitals.cholesterol_ldl(user_id='user_id', start_date='start_date', )
        """
        _response = self._raw_client.cholesterol_ldl(
            user_id, start_date=start_date, provider=provider, end_date=end_date, request_options=request_options
        )
        return _response.data

    def cholesterol_hdl(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[ClientFacingCholesterolTimeseries]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[ClientFacingCholesterolTimeseries]
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.vitals.cholesterol_hdl(user_id='user_id', start_date='start_date', )
        """
        _response = self._raw_client.cholesterol_hdl(
            user_id, start_date=start_date, provider=provider, end_date=end_date, request_options=request_options
        )
        return _response.data

    def cholesterol(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[ClientFacingCholesterolTimeseries]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[ClientFacingCholesterolTimeseries]
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.vitals.cholesterol(user_id='user_id', start_date='start_date', )
        """
        _response = self._raw_client.cholesterol(
            user_id, start_date=start_date, provider=provider, end_date=end_date, request_options=request_options
        )
        return _response.data

    def body_weight(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[ClientFacingBodyWeightTimeseries]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[ClientFacingBodyWeightTimeseries]
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.vitals.body_weight(user_id='user_id', start_date='start_date', )
        """
        _response = self._raw_client.body_weight(
            user_id, start_date=start_date, provider=provider, end_date=end_date, request_options=request_options
        )
        return _response.data

    def body_fat(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[ClientFacingBodyFatTimeseries]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[ClientFacingBodyFatTimeseries]
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.vitals.body_fat(user_id='user_id', start_date='start_date', )
        """
        _response = self._raw_client.body_fat(
            user_id, start_date=start_date, provider=provider, end_date=end_date, request_options=request_options
        )
        return _response.data

    def blood_oxygen(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[ClientFacingBloodOxygenTimeseries]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[ClientFacingBloodOxygenTimeseries]
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.vitals.blood_oxygen(user_id='user_id', start_date='start_date', )
        """
        _response = self._raw_client.blood_oxygen(
            user_id, start_date=start_date, provider=provider, end_date=end_date, request_options=request_options
        )
        return _response.data

    def electrocardiogram_voltage(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[ClientFacingElectrocardiogramVoltageTimeseries]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[ClientFacingElectrocardiogramVoltageTimeseries]
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.vitals.electrocardiogram_voltage(user_id='user_id', start_date='start_date', )
        """
        _response = self._raw_client.electrocardiogram_voltage(
            user_id, start_date=start_date, provider=provider, end_date=end_date, request_options=request_options
        )
        return _response.data

    def blood_pressure(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[ClientFacingBloodPressureTimeseries]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[ClientFacingBloodPressureTimeseries]
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.vitals.blood_pressure(user_id='user_id', start_date='start_date', )
        """
        _response = self._raw_client.blood_pressure(
            user_id, start_date=start_date, provider=provider, end_date=end_date, request_options=request_options
        )
        return _response.data


class AsyncVitalsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawVitalsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawVitalsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawVitalsClient
        """
        return self._raw_client

    async def workout_swimming_stroke_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupedWorkoutSwimmingStrokeResponse:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupedWorkoutSwimmingStrokeResponse
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.vitals.workout_swimming_stroke_grouped(user_id='user_id', start_date='start_date', )
        asyncio.run(main())
        """
        _response = await self._raw_client.workout_swimming_stroke_grouped(
            user_id,
            start_date=start_date,
            cursor=cursor,
            next_cursor=next_cursor,
            provider=provider,
            end_date=end_date,
            request_options=request_options,
        )
        return _response.data

    async def workout_distance_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupedWorkoutDistanceResponse:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupedWorkoutDistanceResponse
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.vitals.workout_distance_grouped(user_id='user_id', start_date='start_date', )
        asyncio.run(main())
        """
        _response = await self._raw_client.workout_distance_grouped(
            user_id,
            start_date=start_date,
            cursor=cursor,
            next_cursor=next_cursor,
            provider=provider,
            end_date=end_date,
            request_options=request_options,
        )
        return _response.data

    async def heart_rate_recovery_one_minute_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupedHeartRateRecoveryOneMinuteResponse:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupedHeartRateRecoveryOneMinuteResponse
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.vitals.heart_rate_recovery_one_minute_grouped(user_id='user_id', start_date='start_date', )
        asyncio.run(main())
        """
        _response = await self._raw_client.heart_rate_recovery_one_minute_grouped(
            user_id,
            start_date=start_date,
            cursor=cursor,
            next_cursor=next_cursor,
            provider=provider,
            end_date=end_date,
            request_options=request_options,
        )
        return _response.data

    async def waist_circumference_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupedWaistCircumferenceResponse:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupedWaistCircumferenceResponse
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.vitals.waist_circumference_grouped(user_id='user_id', start_date='start_date', )
        asyncio.run(main())
        """
        _response = await self._raw_client.waist_circumference_grouped(
            user_id,
            start_date=start_date,
            cursor=cursor,
            next_cursor=next_cursor,
            provider=provider,
            end_date=end_date,
            request_options=request_options,
        )
        return _response.data

    async def lean_body_mass_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupedLeanBodyMassResponse:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupedLeanBodyMassResponse
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.vitals.lean_body_mass_grouped(user_id='user_id', start_date='start_date', )
        asyncio.run(main())
        """
        _response = await self._raw_client.lean_body_mass_grouped(
            user_id,
            start_date=start_date,
            cursor=cursor,
            next_cursor=next_cursor,
            provider=provider,
            end_date=end_date,
            request_options=request_options,
        )
        return _response.data

    async def body_mass_index_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupedBodyMassIndexResponse:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupedBodyMassIndexResponse
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.vitals.body_mass_index_grouped(user_id='user_id', start_date='start_date', )
        asyncio.run(main())
        """
        _response = await self._raw_client.body_mass_index_grouped(
            user_id,
            start_date=start_date,
            cursor=cursor,
            next_cursor=next_cursor,
            provider=provider,
            end_date=end_date,
            request_options=request_options,
        )
        return _response.data

    async def basal_body_temperature_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupedBasalBodyTemperatureResponse:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupedBasalBodyTemperatureResponse
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.vitals.basal_body_temperature_grouped(user_id='user_id', start_date='start_date', )
        asyncio.run(main())
        """
        _response = await self._raw_client.basal_body_temperature_grouped(
            user_id,
            start_date=start_date,
            cursor=cursor,
            next_cursor=next_cursor,
            provider=provider,
            end_date=end_date,
            request_options=request_options,
        )
        return _response.data

    async def handwashing_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupedHandwashingResponse:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupedHandwashingResponse
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.vitals.handwashing_grouped(user_id='user_id', start_date='start_date', )
        asyncio.run(main())
        """
        _response = await self._raw_client.handwashing_grouped(
            user_id,
            start_date=start_date,
            cursor=cursor,
            next_cursor=next_cursor,
            provider=provider,
            end_date=end_date,
            request_options=request_options,
        )
        return _response.data

    async def daylight_exposure_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupedDaylightExposureResponse:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupedDaylightExposureResponse
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.vitals.daylight_exposure_grouped(user_id='user_id', start_date='start_date', )
        asyncio.run(main())
        """
        _response = await self._raw_client.daylight_exposure_grouped(
            user_id,
            start_date=start_date,
            cursor=cursor,
            next_cursor=next_cursor,
            provider=provider,
            end_date=end_date,
            request_options=request_options,
        )
        return _response.data

    async def uv_exposure_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupedUvExposureResponse:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupedUvExposureResponse
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.vitals.uv_exposure_grouped(user_id='user_id', start_date='start_date', )
        asyncio.run(main())
        """
        _response = await self._raw_client.uv_exposure_grouped(
            user_id,
            start_date=start_date,
            cursor=cursor,
            next_cursor=next_cursor,
            provider=provider,
            end_date=end_date,
            request_options=request_options,
        )
        return _response.data

    async def fall_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupedFallResponse:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupedFallResponse
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.vitals.fall_grouped(user_id='user_id', start_date='start_date', )
        asyncio.run(main())
        """
        _response = await self._raw_client.fall_grouped(
            user_id,
            start_date=start_date,
            cursor=cursor,
            next_cursor=next_cursor,
            provider=provider,
            end_date=end_date,
            request_options=request_options,
        )
        return _response.data

    async def inhaler_usage_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupedInhalerUsageResponse:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupedInhalerUsageResponse
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.vitals.inhaler_usage_grouped(user_id='user_id', start_date='start_date', )
        asyncio.run(main())
        """
        _response = await self._raw_client.inhaler_usage_grouped(
            user_id,
            start_date=start_date,
            cursor=cursor,
            next_cursor=next_cursor,
            provider=provider,
            end_date=end_date,
            request_options=request_options,
        )
        return _response.data

    async def peak_expiratory_flow_rate_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupedPeakExpiratoryFlowRateResponse:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupedPeakExpiratoryFlowRateResponse
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.vitals.peak_expiratory_flow_rate_grouped(user_id='user_id', start_date='start_date', )
        asyncio.run(main())
        """
        _response = await self._raw_client.peak_expiratory_flow_rate_grouped(
            user_id,
            start_date=start_date,
            cursor=cursor,
            next_cursor=next_cursor,
            provider=provider,
            end_date=end_date,
            request_options=request_options,
        )
        return _response.data

    async def forced_vital_capacity_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupedForcedVitalCapacityResponse:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupedForcedVitalCapacityResponse
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.vitals.forced_vital_capacity_grouped(user_id='user_id', start_date='start_date', )
        asyncio.run(main())
        """
        _response = await self._raw_client.forced_vital_capacity_grouped(
            user_id,
            start_date=start_date,
            cursor=cursor,
            next_cursor=next_cursor,
            provider=provider,
            end_date=end_date,
            request_options=request_options,
        )
        return _response.data

    async def forced_expiratory_volume_1_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupedForcedExpiratoryVolume1Response:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupedForcedExpiratoryVolume1Response
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.vitals.forced_expiratory_volume_1_grouped(user_id='user_id', start_date='start_date', )
        asyncio.run(main())
        """
        _response = await self._raw_client.forced_expiratory_volume_1_grouped(
            user_id,
            start_date=start_date,
            cursor=cursor,
            next_cursor=next_cursor,
            provider=provider,
            end_date=end_date,
            request_options=request_options,
        )
        return _response.data

    async def wheelchair_push_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupedWheelchairPushResponse:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupedWheelchairPushResponse
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.vitals.wheelchair_push_grouped(user_id='user_id', start_date='start_date', )
        asyncio.run(main())
        """
        _response = await self._raw_client.wheelchair_push_grouped(
            user_id,
            start_date=start_date,
            cursor=cursor,
            next_cursor=next_cursor,
            provider=provider,
            end_date=end_date,
            request_options=request_options,
        )
        return _response.data

    async def sleep_breathing_disturbance_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupedSleepBreathingDisturbanceResponse:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupedSleepBreathingDisturbanceResponse
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.vitals.sleep_breathing_disturbance_grouped(user_id='user_id', start_date='start_date', )
        asyncio.run(main())
        """
        _response = await self._raw_client.sleep_breathing_disturbance_grouped(
            user_id,
            start_date=start_date,
            cursor=cursor,
            next_cursor=next_cursor,
            provider=provider,
            end_date=end_date,
            request_options=request_options,
        )
        return _response.data

    async def sleep_apnea_alert_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupedSleepApneaAlertResponse:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupedSleepApneaAlertResponse
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.vitals.sleep_apnea_alert_grouped(user_id='user_id', start_date='start_date', )
        asyncio.run(main())
        """
        _response = await self._raw_client.sleep_apnea_alert_grouped(
            user_id,
            start_date=start_date,
            cursor=cursor,
            next_cursor=next_cursor,
            provider=provider,
            end_date=end_date,
            request_options=request_options,
        )
        return _response.data

    async def stand_duration_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupedStandDurationResponse:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupedStandDurationResponse
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.vitals.stand_duration_grouped(user_id='user_id', start_date='start_date', )
        asyncio.run(main())
        """
        _response = await self._raw_client.stand_duration_grouped(
            user_id,
            start_date=start_date,
            cursor=cursor,
            next_cursor=next_cursor,
            provider=provider,
            end_date=end_date,
            request_options=request_options,
        )
        return _response.data

    async def stand_hour_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupedStandHourResponse:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupedStandHourResponse
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.vitals.stand_hour_grouped(user_id='user_id', start_date='start_date', )
        asyncio.run(main())
        """
        _response = await self._raw_client.stand_hour_grouped(
            user_id,
            start_date=start_date,
            cursor=cursor,
            next_cursor=next_cursor,
            provider=provider,
            end_date=end_date,
            request_options=request_options,
        )
        return _response.data

    async def heart_rate_alert_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupedHeartRateAlertResponse:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupedHeartRateAlertResponse
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.vitals.heart_rate_alert_grouped(user_id='user_id', start_date='start_date', )
        asyncio.run(main())
        """
        _response = await self._raw_client.heart_rate_alert_grouped(
            user_id,
            start_date=start_date,
            cursor=cursor,
            next_cursor=next_cursor,
            provider=provider,
            end_date=end_date,
            request_options=request_options,
        )
        return _response.data

    async def afib_burden_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupedAFibBurdenResponse:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupedAFibBurdenResponse
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.vitals.afib_burden_grouped(user_id='user_id', start_date='start_date', )
        asyncio.run(main())
        """
        _response = await self._raw_client.afib_burden_grouped(
            user_id,
            start_date=start_date,
            cursor=cursor,
            next_cursor=next_cursor,
            provider=provider,
            end_date=end_date,
            request_options=request_options,
        )
        return _response.data

    async def workout_duration_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupedWorkoutDurationResponse:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupedWorkoutDurationResponse
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.vitals.workout_duration_grouped(user_id='user_id', start_date='start_date', )
        asyncio.run(main())
        """
        _response = await self._raw_client.workout_duration_grouped(
            user_id,
            start_date=start_date,
            cursor=cursor,
            next_cursor=next_cursor,
            provider=provider,
            end_date=end_date,
            request_options=request_options,
        )
        return _response.data

    async def vo_2_max_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupedVo2MaxResponse:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupedVo2MaxResponse
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.vitals.vo_2_max_grouped(user_id='user_id', start_date='start_date', )
        asyncio.run(main())
        """
        _response = await self._raw_client.vo_2_max_grouped(
            user_id,
            start_date=start_date,
            cursor=cursor,
            next_cursor=next_cursor,
            provider=provider,
            end_date=end_date,
            request_options=request_options,
        )
        return _response.data

    async def stress_level_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupedStressLevelResponse:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupedStressLevelResponse
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.vitals.stress_level_grouped(user_id='user_id', start_date='start_date', )
        asyncio.run(main())
        """
        _response = await self._raw_client.stress_level_grouped(
            user_id,
            start_date=start_date,
            cursor=cursor,
            next_cursor=next_cursor,
            provider=provider,
            end_date=end_date,
            request_options=request_options,
        )
        return _response.data

    async def mindfulness_minutes_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupedMindfulnessMinutesResponse:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupedMindfulnessMinutesResponse
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.vitals.mindfulness_minutes_grouped(user_id='user_id', start_date='start_date', )
        asyncio.run(main())
        """
        _response = await self._raw_client.mindfulness_minutes_grouped(
            user_id,
            start_date=start_date,
            cursor=cursor,
            next_cursor=next_cursor,
            provider=provider,
            end_date=end_date,
            request_options=request_options,
        )
        return _response.data

    async def caffeine_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupedCaffeineResponse:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupedCaffeineResponse
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.vitals.caffeine_grouped(user_id='user_id', start_date='start_date', )
        asyncio.run(main())
        """
        _response = await self._raw_client.caffeine_grouped(
            user_id,
            start_date=start_date,
            cursor=cursor,
            next_cursor=next_cursor,
            provider=provider,
            end_date=end_date,
            request_options=request_options,
        )
        return _response.data

    async def water_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupedWaterResponse:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupedWaterResponse
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.vitals.water_grouped(user_id='user_id', start_date='start_date', )
        asyncio.run(main())
        """
        _response = await self._raw_client.water_grouped(
            user_id,
            start_date=start_date,
            cursor=cursor,
            next_cursor=next_cursor,
            provider=provider,
            end_date=end_date,
            request_options=request_options,
        )
        return _response.data

    async def steps_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupedStepsResponse:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupedStepsResponse
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.vitals.steps_grouped(user_id='user_id', start_date='start_date', )
        asyncio.run(main())
        """
        _response = await self._raw_client.steps_grouped(
            user_id,
            start_date=start_date,
            cursor=cursor,
            next_cursor=next_cursor,
            provider=provider,
            end_date=end_date,
            request_options=request_options,
        )
        return _response.data

    async def floors_climbed_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupedFloorsClimbedResponse:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupedFloorsClimbedResponse
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.vitals.floors_climbed_grouped(user_id='user_id', start_date='start_date', )
        asyncio.run(main())
        """
        _response = await self._raw_client.floors_climbed_grouped(
            user_id,
            start_date=start_date,
            cursor=cursor,
            next_cursor=next_cursor,
            provider=provider,
            end_date=end_date,
            request_options=request_options,
        )
        return _response.data

    async def distance_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupedDistanceResponse:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupedDistanceResponse
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.vitals.distance_grouped(user_id='user_id', start_date='start_date', )
        asyncio.run(main())
        """
        _response = await self._raw_client.distance_grouped(
            user_id,
            start_date=start_date,
            cursor=cursor,
            next_cursor=next_cursor,
            provider=provider,
            end_date=end_date,
            request_options=request_options,
        )
        return _response.data

    async def calories_basal_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupedCaloriesBasalResponse:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupedCaloriesBasalResponse
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.vitals.calories_basal_grouped(user_id='user_id', start_date='start_date', )
        asyncio.run(main())
        """
        _response = await self._raw_client.calories_basal_grouped(
            user_id,
            start_date=start_date,
            cursor=cursor,
            next_cursor=next_cursor,
            provider=provider,
            end_date=end_date,
            request_options=request_options,
        )
        return _response.data

    async def calories_active_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupedCaloriesActiveResponse:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupedCaloriesActiveResponse
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.vitals.calories_active_grouped(user_id='user_id', start_date='start_date', )
        asyncio.run(main())
        """
        _response = await self._raw_client.calories_active_grouped(
            user_id,
            start_date=start_date,
            cursor=cursor,
            next_cursor=next_cursor,
            provider=provider,
            end_date=end_date,
            request_options=request_options,
        )
        return _response.data

    async def respiratory_rate_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupedRespiratoryRateResponse:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupedRespiratoryRateResponse
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.vitals.respiratory_rate_grouped(user_id='user_id', start_date='start_date', )
        asyncio.run(main())
        """
        _response = await self._raw_client.respiratory_rate_grouped(
            user_id,
            start_date=start_date,
            cursor=cursor,
            next_cursor=next_cursor,
            provider=provider,
            end_date=end_date,
            request_options=request_options,
        )
        return _response.data

    async def note_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupedNoteResponse:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupedNoteResponse
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.vitals.note_grouped(user_id='user_id', start_date='start_date', )
        asyncio.run(main())
        """
        _response = await self._raw_client.note_grouped(
            user_id,
            start_date=start_date,
            cursor=cursor,
            next_cursor=next_cursor,
            provider=provider,
            end_date=end_date,
            request_options=request_options,
        )
        return _response.data

    async def insulin_injection_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupedInsulinInjectionResponse:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupedInsulinInjectionResponse
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.vitals.insulin_injection_grouped(user_id='user_id', start_date='start_date', )
        asyncio.run(main())
        """
        _response = await self._raw_client.insulin_injection_grouped(
            user_id,
            start_date=start_date,
            cursor=cursor,
            next_cursor=next_cursor,
            provider=provider,
            end_date=end_date,
            request_options=request_options,
        )
        return _response.data

    async def ige_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupedIgeResponse:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupedIgeResponse
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.vitals.ige_grouped(user_id='user_id', start_date='start_date', )
        asyncio.run(main())
        """
        _response = await self._raw_client.ige_grouped(
            user_id,
            start_date=start_date,
            cursor=cursor,
            next_cursor=next_cursor,
            provider=provider,
            end_date=end_date,
            request_options=request_options,
        )
        return _response.data

    async def igg_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupedIggResponse:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupedIggResponse
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.vitals.igg_grouped(user_id='user_id', start_date='start_date', )
        asyncio.run(main())
        """
        _response = await self._raw_client.igg_grouped(
            user_id,
            start_date=start_date,
            cursor=cursor,
            next_cursor=next_cursor,
            provider=provider,
            end_date=end_date,
            request_options=request_options,
        )
        return _response.data

    async def hypnogram_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupedHypnogramResponse:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupedHypnogramResponse
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.vitals.hypnogram_grouped(user_id='user_id', start_date='start_date', )
        asyncio.run(main())
        """
        _response = await self._raw_client.hypnogram_grouped(
            user_id,
            start_date=start_date,
            cursor=cursor,
            next_cursor=next_cursor,
            provider=provider,
            end_date=end_date,
            request_options=request_options,
        )
        return _response.data

    async def hrv_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupedHrvResponse:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupedHrvResponse
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.vitals.hrv_grouped(user_id='user_id', start_date='start_date', )
        asyncio.run(main())
        """
        _response = await self._raw_client.hrv_grouped(
            user_id,
            start_date=start_date,
            cursor=cursor,
            next_cursor=next_cursor,
            provider=provider,
            end_date=end_date,
            request_options=request_options,
        )
        return _response.data

    async def heartrate_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupedHeartRateResponse:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupedHeartRateResponse
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.vitals.heartrate_grouped(user_id='user_id', start_date='start_date', )
        asyncio.run(main())
        """
        _response = await self._raw_client.heartrate_grouped(
            user_id,
            start_date=start_date,
            cursor=cursor,
            next_cursor=next_cursor,
            provider=provider,
            end_date=end_date,
            request_options=request_options,
        )
        return _response.data

    async def glucose_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupedGlucoseResponse:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupedGlucoseResponse
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.vitals.glucose_grouped(user_id='user_id', start_date='start_date', )
        asyncio.run(main())
        """
        _response = await self._raw_client.glucose_grouped(
            user_id,
            start_date=start_date,
            cursor=cursor,
            next_cursor=next_cursor,
            provider=provider,
            end_date=end_date,
            request_options=request_options,
        )
        return _response.data

    async def cholesterol_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupedCholesterolResponse:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupedCholesterolResponse
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.vitals.cholesterol_grouped(user_id='user_id', start_date='start_date', )
        asyncio.run(main())
        """
        _response = await self._raw_client.cholesterol_grouped(
            user_id,
            start_date=start_date,
            cursor=cursor,
            next_cursor=next_cursor,
            provider=provider,
            end_date=end_date,
            request_options=request_options,
        )
        return _response.data

    async def carbohydrates_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupedCarbohydratesResponse:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupedCarbohydratesResponse
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.vitals.carbohydrates_grouped(user_id='user_id', start_date='start_date', )
        asyncio.run(main())
        """
        _response = await self._raw_client.carbohydrates_grouped(
            user_id,
            start_date=start_date,
            cursor=cursor,
            next_cursor=next_cursor,
            provider=provider,
            end_date=end_date,
            request_options=request_options,
        )
        return _response.data

    async def body_temperature_delta_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupedBodyTemperatureDeltaResponse:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupedBodyTemperatureDeltaResponse
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.vitals.body_temperature_delta_grouped(user_id='user_id', start_date='start_date', )
        asyncio.run(main())
        """
        _response = await self._raw_client.body_temperature_delta_grouped(
            user_id,
            start_date=start_date,
            cursor=cursor,
            next_cursor=next_cursor,
            provider=provider,
            end_date=end_date,
            request_options=request_options,
        )
        return _response.data

    async def body_temperature_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupedBodyTemperatureResponse:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupedBodyTemperatureResponse
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.vitals.body_temperature_grouped(user_id='user_id', start_date='start_date', )
        asyncio.run(main())
        """
        _response = await self._raw_client.body_temperature_grouped(
            user_id,
            start_date=start_date,
            cursor=cursor,
            next_cursor=next_cursor,
            provider=provider,
            end_date=end_date,
            request_options=request_options,
        )
        return _response.data

    async def body_weight_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupedBodyWeightResponse:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupedBodyWeightResponse
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.vitals.body_weight_grouped(user_id='user_id', start_date='start_date', )
        asyncio.run(main())
        """
        _response = await self._raw_client.body_weight_grouped(
            user_id,
            start_date=start_date,
            cursor=cursor,
            next_cursor=next_cursor,
            provider=provider,
            end_date=end_date,
            request_options=request_options,
        )
        return _response.data

    async def body_fat_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupedBodyFatResponse:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupedBodyFatResponse
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.vitals.body_fat_grouped(user_id='user_id', start_date='start_date', )
        asyncio.run(main())
        """
        _response = await self._raw_client.body_fat_grouped(
            user_id,
            start_date=start_date,
            cursor=cursor,
            next_cursor=next_cursor,
            provider=provider,
            end_date=end_date,
            request_options=request_options,
        )
        return _response.data

    async def blood_oxygen_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupedBloodOxygenResponse:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupedBloodOxygenResponse
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.vitals.blood_oxygen_grouped(user_id='user_id', start_date='start_date', )
        asyncio.run(main())
        """
        _response = await self._raw_client.blood_oxygen_grouped(
            user_id,
            start_date=start_date,
            cursor=cursor,
            next_cursor=next_cursor,
            provider=provider,
            end_date=end_date,
            request_options=request_options,
        )
        return _response.data

    async def electrocardiogram_voltage_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupedElectrocardiogramVoltageResponse:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupedElectrocardiogramVoltageResponse
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.vitals.electrocardiogram_voltage_grouped(user_id='user_id', start_date='start_date', )
        asyncio.run(main())
        """
        _response = await self._raw_client.electrocardiogram_voltage_grouped(
            user_id,
            start_date=start_date,
            cursor=cursor,
            next_cursor=next_cursor,
            provider=provider,
            end_date=end_date,
            request_options=request_options,
        )
        return _response.data

    async def blood_pressure_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupedBloodPressureResponse:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupedBloodPressureResponse
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.vitals.blood_pressure_grouped(user_id='user_id', start_date='start_date', )
        asyncio.run(main())
        """
        _response = await self._raw_client.blood_pressure_grouped(
            user_id,
            start_date=start_date,
            cursor=cursor,
            next_cursor=next_cursor,
            provider=provider,
            end_date=end_date,
            request_options=request_options,
        )
        return _response.data

    async def vo_2_max(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[ClientFacingVo2MaxTimeseries]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[ClientFacingVo2MaxTimeseries]
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.vitals.vo_2_max(user_id='user_id', start_date='start_date', )
        asyncio.run(main())
        """
        _response = await self._raw_client.vo_2_max(
            user_id, start_date=start_date, provider=provider, end_date=end_date, request_options=request_options
        )
        return _response.data

    async def stress_level(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[ClientFacingStressLevelTimeseries]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[ClientFacingStressLevelTimeseries]
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.vitals.stress_level(user_id='user_id', start_date='start_date', )
        asyncio.run(main())
        """
        _response = await self._raw_client.stress_level(
            user_id, start_date=start_date, provider=provider, end_date=end_date, request_options=request_options
        )
        return _response.data

    async def mindfulness_minutes(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[ClientFacingMindfulnessMinutesTimeseries]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[ClientFacingMindfulnessMinutesTimeseries]
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.vitals.mindfulness_minutes(user_id='user_id', start_date='start_date', )
        asyncio.run(main())
        """
        _response = await self._raw_client.mindfulness_minutes(
            user_id, start_date=start_date, provider=provider, end_date=end_date, request_options=request_options
        )
        return _response.data

    async def caffeine(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[ClientFacingCaffeineTimeseries]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[ClientFacingCaffeineTimeseries]
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.vitals.caffeine(user_id='user_id', start_date='start_date', )
        asyncio.run(main())
        """
        _response = await self._raw_client.caffeine(
            user_id, start_date=start_date, provider=provider, end_date=end_date, request_options=request_options
        )
        return _response.data

    async def water(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[ClientFacingWaterTimeseries]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[ClientFacingWaterTimeseries]
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.vitals.water(user_id='user_id', start_date='start_date', )
        asyncio.run(main())
        """
        _response = await self._raw_client.water(
            user_id, start_date=start_date, provider=provider, end_date=end_date, request_options=request_options
        )
        return _response.data

    async def steps(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[ClientFacingStepsTimeseries]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[ClientFacingStepsTimeseries]
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.vitals.steps(user_id='user_id', start_date='start_date', )
        asyncio.run(main())
        """
        _response = await self._raw_client.steps(
            user_id, start_date=start_date, provider=provider, end_date=end_date, request_options=request_options
        )
        return _response.data

    async def floors_climbed(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[ClientFacingFloorsClimbedTimeseries]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[ClientFacingFloorsClimbedTimeseries]
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.vitals.floors_climbed(user_id='user_id', start_date='start_date', )
        asyncio.run(main())
        """
        _response = await self._raw_client.floors_climbed(
            user_id, start_date=start_date, provider=provider, end_date=end_date, request_options=request_options
        )
        return _response.data

    async def distance(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[ClientFacingDistanceTimeseries]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[ClientFacingDistanceTimeseries]
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.vitals.distance(user_id='user_id', start_date='start_date', )
        asyncio.run(main())
        """
        _response = await self._raw_client.distance(
            user_id, start_date=start_date, provider=provider, end_date=end_date, request_options=request_options
        )
        return _response.data

    async def calories_basal(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[ClientFacingCaloriesBasalTimeseries]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[ClientFacingCaloriesBasalTimeseries]
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.vitals.calories_basal(user_id='user_id', start_date='start_date', )
        asyncio.run(main())
        """
        _response = await self._raw_client.calories_basal(
            user_id, start_date=start_date, provider=provider, end_date=end_date, request_options=request_options
        )
        return _response.data

    async def calories_active(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[ClientFacingCaloriesActiveTimeseries]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[ClientFacingCaloriesActiveTimeseries]
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.vitals.calories_active(user_id='user_id', start_date='start_date', )
        asyncio.run(main())
        """
        _response = await self._raw_client.calories_active(
            user_id, start_date=start_date, provider=provider, end_date=end_date, request_options=request_options
        )
        return _response.data

    async def respiratory_rate(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[ClientFacingRespiratoryRateTimeseries]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[ClientFacingRespiratoryRateTimeseries]
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.vitals.respiratory_rate(user_id='user_id', start_date='start_date', )
        asyncio.run(main())
        """
        _response = await self._raw_client.respiratory_rate(
            user_id, start_date=start_date, provider=provider, end_date=end_date, request_options=request_options
        )
        return _response.data

    async def ige(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[ClientFacingIgeTimeseries]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[ClientFacingIgeTimeseries]
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.vitals.ige(user_id='user_id', start_date='start_date', )
        asyncio.run(main())
        """
        _response = await self._raw_client.ige(
            user_id, start_date=start_date, provider=provider, end_date=end_date, request_options=request_options
        )
        return _response.data

    async def igg(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[ClientFacingIggTimeseries]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[ClientFacingIggTimeseries]
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.vitals.igg(user_id='user_id', start_date='start_date', )
        asyncio.run(main())
        """
        _response = await self._raw_client.igg(
            user_id, start_date=start_date, provider=provider, end_date=end_date, request_options=request_options
        )
        return _response.data

    async def hypnogram(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[ClientFacingHypnogramTimeseries]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[ClientFacingHypnogramTimeseries]
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.vitals.hypnogram(user_id='user_id', start_date='start_date', )
        asyncio.run(main())
        """
        _response = await self._raw_client.hypnogram(
            user_id, start_date=start_date, provider=provider, end_date=end_date, request_options=request_options
        )
        return _response.data

    async def hrv(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[ClientFacingHrvTimeseries]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[ClientFacingHrvTimeseries]
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.vitals.hrv(user_id='user_id', start_date='start_date', )
        asyncio.run(main())
        """
        _response = await self._raw_client.hrv(
            user_id, start_date=start_date, provider=provider, end_date=end_date, request_options=request_options
        )
        return _response.data

    async def heartrate(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[ClientFacingHeartRateTimeseries]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[ClientFacingHeartRateTimeseries]
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.vitals.heartrate(user_id='user_id', start_date='start_date', )
        asyncio.run(main())
        """
        _response = await self._raw_client.heartrate(
            user_id, start_date=start_date, provider=provider, end_date=end_date, request_options=request_options
        )
        return _response.data

    async def glucose(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[ClientFacingGlucoseTimeseries]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[ClientFacingGlucoseTimeseries]
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.vitals.glucose(user_id='user_id', start_date='start_date', )
        asyncio.run(main())
        """
        _response = await self._raw_client.glucose(
            user_id, start_date=start_date, provider=provider, end_date=end_date, request_options=request_options
        )
        return _response.data

    async def cholesterol_triglycerides(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[ClientFacingCholesterolTimeseries]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[ClientFacingCholesterolTimeseries]
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.vitals.cholesterol_triglycerides(user_id='user_id', start_date='start_date', )
        asyncio.run(main())
        """
        _response = await self._raw_client.cholesterol_triglycerides(
            user_id, start_date=start_date, provider=provider, end_date=end_date, request_options=request_options
        )
        return _response.data

    async def cholesterol_total(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[ClientFacingCholesterolTimeseries]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[ClientFacingCholesterolTimeseries]
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.vitals.cholesterol_total(user_id='user_id', start_date='start_date', )
        asyncio.run(main())
        """
        _response = await self._raw_client.cholesterol_total(
            user_id, start_date=start_date, provider=provider, end_date=end_date, request_options=request_options
        )
        return _response.data

    async def cholesterol_ldl(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[ClientFacingCholesterolTimeseries]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[ClientFacingCholesterolTimeseries]
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.vitals.cholesterol_ldl(user_id='user_id', start_date='start_date', )
        asyncio.run(main())
        """
        _response = await self._raw_client.cholesterol_ldl(
            user_id, start_date=start_date, provider=provider, end_date=end_date, request_options=request_options
        )
        return _response.data

    async def cholesterol_hdl(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[ClientFacingCholesterolTimeseries]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[ClientFacingCholesterolTimeseries]
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.vitals.cholesterol_hdl(user_id='user_id', start_date='start_date', )
        asyncio.run(main())
        """
        _response = await self._raw_client.cholesterol_hdl(
            user_id, start_date=start_date, provider=provider, end_date=end_date, request_options=request_options
        )
        return _response.data

    async def cholesterol(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[ClientFacingCholesterolTimeseries]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[ClientFacingCholesterolTimeseries]
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.vitals.cholesterol(user_id='user_id', start_date='start_date', )
        asyncio.run(main())
        """
        _response = await self._raw_client.cholesterol(
            user_id, start_date=start_date, provider=provider, end_date=end_date, request_options=request_options
        )
        return _response.data

    async def body_weight(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[ClientFacingBodyWeightTimeseries]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[ClientFacingBodyWeightTimeseries]
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.vitals.body_weight(user_id='user_id', start_date='start_date', )
        asyncio.run(main())
        """
        _response = await self._raw_client.body_weight(
            user_id, start_date=start_date, provider=provider, end_date=end_date, request_options=request_options
        )
        return _response.data

    async def body_fat(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[ClientFacingBodyFatTimeseries]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[ClientFacingBodyFatTimeseries]
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.vitals.body_fat(user_id='user_id', start_date='start_date', )
        asyncio.run(main())
        """
        _response = await self._raw_client.body_fat(
            user_id, start_date=start_date, provider=provider, end_date=end_date, request_options=request_options
        )
        return _response.data

    async def blood_oxygen(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[ClientFacingBloodOxygenTimeseries]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[ClientFacingBloodOxygenTimeseries]
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.vitals.blood_oxygen(user_id='user_id', start_date='start_date', )
        asyncio.run(main())
        """
        _response = await self._raw_client.blood_oxygen(
            user_id, start_date=start_date, provider=provider, end_date=end_date, request_options=request_options
        )
        return _response.data

    async def electrocardiogram_voltage(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[ClientFacingElectrocardiogramVoltageTimeseries]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[ClientFacingElectrocardiogramVoltageTimeseries]
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.vitals.electrocardiogram_voltage(user_id='user_id', start_date='start_date', )
        asyncio.run(main())
        """
        _response = await self._raw_client.electrocardiogram_voltage(
            user_id, start_date=start_date, provider=provider, end_date=end_date, request_options=request_options
        )
        return _response.data

    async def blood_pressure(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[ClientFacingBloodPressureTimeseries]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[ClientFacingBloodPressureTimeseries]
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.vitals.blood_pressure(user_id='user_id', start_date='start_date', )
        asyncio.run(main())
        """
        _response = await self._raw_client.blood_pressure(
            user_id, start_date=start_date, provider=provider, end_date=end_date, request_options=request_options
        )
        return _response.data
