# coding=utf-8
from otlmow_model.OtlmowModel.BaseClasses.KeuzelijstField import KeuzelijstField
from otlmow_model.OtlmowModel.BaseClasses.KeuzelijstWaarde import KeuzelijstWaarde


# Generated with OTLEnumerationCreator. To modify: extend, do not edit
class KlBeheerGrazigeVegetatie(KeuzelijstField):
    """De verschillende soorten van beheer voor grazige vegetatie."""
    naam = 'KlBeheerGrazigeVegetatie'
    label = 'Beheer grazige vegetatie'
    objectUri = 'https://wegenenverkeer.data.vlaanderen.be/ns/levenscyclus#KlBeheerGrazigeVegetatie'
    definition = 'De verschillende soorten van beheer voor grazige vegetatie.'
    status = 'ingebruik'
    codelist = 'https://wegenenverkeer.data.vlaanderen.be/id/conceptscheme/KlBeheerGrazigeVegetatie'
    options = {
        'afboorden': KeuzelijstWaarde(invulwaarde='afboorden',
                                      label='afboorden',
                                      status='ingebruik',
                                      definitie='Het afsteken van de overgroeiende vegetatie langs de rand van de verharding. (wordt afranden genoemd in SB250) ',
                                      objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlBeheerGrazigeVegetatie/afboorden'),
        'aflagen': KeuzelijstWaarde(invulwaarde='aflagen',
                                    label='aflagen',
                                    status='ingebruik',
                                    definitie='Het verwijderen van de bovenste grondlaag met begroeiing om afwatering te garanderen',
                                    objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlBeheerGrazigeVegetatie/aflagen'),
        'begrazing': KeuzelijstWaarde(invulwaarde='begrazing',
                                      label='begrazing',
                                      status='ingebruik',
                                      definitie='De vegetatie wordt begraasd door dieren.',
                                      objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlBeheerGrazigeVegetatie/begrazing'),
        'beluchten': KeuzelijstWaarde(invulwaarde='beluchten',
                                      label='beluchten',
                                      status='ingebruik',
                                      definitie='Beluchten van grazige vegetatie.',
                                      objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlBeheerGrazigeVegetatie/beluchten'),
        'bestrijden-ongewenste-vegetatie': KeuzelijstWaarde(invulwaarde='bestrijden-ongewenste-vegetatie',
                                                            label='bestrijden ongewenste vegetatie',
                                                            status='ingebruik',
                                                            definitie='Bestrijden van ongewenste vegetatie die zich bevingt in het perceel van grazige vegetatie..',
                                                            objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlBeheerGrazigeVegetatie/bestrijden-ongewenste-vegetatie'),
        'konijnenbeheer': KeuzelijstWaarde(invulwaarde='konijnenbeheer',
                                           label='konijnenbeheer',
                                           status='ingebruik',
                                           definitie='Het reduceren van konijnenpopulaties om de stabilietit van taluds te blijven garanderen',
                                           objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlBeheerGrazigeVegetatie/konijnenbeheer'),
        'maairegime-1': KeuzelijstWaarde(invulwaarde='maairegime-1',
                                         label='Maairegime 1',
                                         status='ingebruik',
                                         definitie='2 maaibeurten waarbij de volledige berm gemaaid wordt. Eerste maaibeurt gebeurt in periode van 1mei tot 15 juni, 2e maaibeurt gebeurt na 15 september. Het maaisel wordt afgevoerd.',
                                         objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlBeheerGrazigeVegetatie/maairegime-1'),
        'maairegime-2': KeuzelijstWaarde(invulwaarde='maairegime-2',
                                         label='Maairegime 2',
                                         status='ingebruik',
                                         definitie='2 maaibeurten waarbij een maaibreedte van 2 maaibalken gemaaid wordt. Eerste maaibeurt gebeurt in periode van 1mei tot 15 juni, 2e maaibeurt gebeurt na 15 september. Het maaisel wordt afgevoerd.',
                                         objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlBeheerGrazigeVegetatie/maairegime-2'),
        'maairegime-3': KeuzelijstWaarde(invulwaarde='maairegime-3',
                                         label='Maairegime 3',
                                         status='ingebruik',
                                         definitie='2 maaibeurten waarbij de volledige berm gemaaid wordt. Eerste maaibeurt gebeurt in periode na 15 juni, 2e maaibeurt gebeurt na 15 september. Het maaisel wordt afgevoerd.',
                                         objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlBeheerGrazigeVegetatie/maairegime-3'),
        'maairegime-4': KeuzelijstWaarde(invulwaarde='maairegime-4',
                                         label='Maairegime 4',
                                         status='ingebruik',
                                         definitie='2 maaibeurten waarbij een maaibreedte van 2 maaibalken gemaaid wordt. Eerste maaibeurt gebeurt in periode na15 juni, 2e maaibeurt gebeurt na 15 september. Het maaisel wordt afgevoerd.',
                                         objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlBeheerGrazigeVegetatie/maairegime-4'),
        'maairegime-5': KeuzelijstWaarde(invulwaarde='maairegime-5',
                                         label='Maairegime 5',
                                         status='ingebruik',
                                         definitie='1 maaibeurt waarbij de volledige berm gemaaid wordt. Deze maaibeurt vindt plaats tussen augustus en oktober. Het maaisel wordt afgevoerd.',
                                         objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlBeheerGrazigeVegetatie/maairegime-5'),
        'maaisel-verwijderen-directe-opzuig': KeuzelijstWaarde(invulwaarde='maaisel-verwijderen-directe-opzuig',
                                                               label='maaisel verwijderen directe opzuig',
                                                               status='ingebruik',
                                                               definitie='het verwijderen van het maaisel met een maaizuigcombinatie',
                                                               objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlBeheerGrazigeVegetatie/maaisel-verwijderen-directe-opzuig'),
        'maaisel-verwijderen-hooien-oprapen': KeuzelijstWaarde(invulwaarde='maaisel-verwijderen-hooien-oprapen',
                                                               label='maaisel verwijderen hooien-oprapen',
                                                               status='ingebruik',
                                                               definitie='het maaisel wordt gehooid en binnen de 10 dagen opgeraapt en verwijderd',
                                                               objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlBeheerGrazigeVegetatie/maaisel-verwijderen-hooien-oprapen'),
        'niets-doen': KeuzelijstWaarde(invulwaarde='niets-doen',
                                       label='niets doen',
                                       status='ingebruik',
                                       definitie='Er wordt geen beheer uitgevoerd',
                                       objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlBeheerGrazigeVegetatie/niets-doen'),
        'plaggen': KeuzelijstWaarde(invulwaarde='plaggen',
                                    label='plaggen',
                                    status='ingebruik',
                                    definitie='Plaggen is het verwijderen van de bovenste grondlaag met begroeiing om grond te verschralen',
                                    objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlBeheerGrazigeVegetatie/plaggen'),
        'profielherstelling-zonder-herinzaaien': KeuzelijstWaarde(invulwaarde='profielherstelling-zonder-herinzaaien',
                                                                  label='profielherstelling zonder herinzaaien',
                                                                  status='ingebruik',
                                                                  definitie='Profielherstelling zonder herinzaaiing van grazige vegetatie.',
                                                                  objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlBeheerGrazigeVegetatie/profielherstelling-zonder-herinzaaien'),
        'reiten': KeuzelijstWaarde(invulwaarde='reiten',
                                   label='reiten',
                                   status='ingebruik',
                                   definitie='Het inkorten van het riet tot ongeveer 10 cm boven het wateroppervlak met maaikorf. Maaisel wordt verwijderd.',
                                   objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlBeheerGrazigeVegetatie/reiten'),
        'rietbeheer': KeuzelijstWaarde(invulwaarde='rietbeheer',
                                       label='Rietbeheer',
                                       status='ingebruik',
                                       definitie='De volledige berm wordt 1 keer per 2 jaar gemaaid in de periode van augustus tot oktober. Jaarlijks gebeurt er een veiligheidsmaaibeurt van 1 maaibalk breed.',
                                       objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlBeheerGrazigeVegetatie/rietbeheer'),
        'ruigtebeheer': KeuzelijstWaarde(invulwaarde='ruigtebeheer',
                                         label='Ruigtebeheer',
                                         status='ingebruik',
                                         definitie='De volledige berm wordt 1 keer per 3 jaar gemaaid in de periode van augustus tot oktober. Jaarlijks gebeurt er een veiligheidsmaaibeurt van 1 maaibalk breed.',
                                         objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlBeheerGrazigeVegetatie/ruigtebeheer'),
        'uitharken': KeuzelijstWaarde(invulwaarde='uitharken',
                                      label='uitharken',
                                      status='ingebruik',
                                      definitie='Uitharken van grazige vegetatie.',
                                      objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlBeheerGrazigeVegetatie/uitharken')
    }

    @classmethod
    def create_dummy_data(cls):
        return cls.create_dummy_data_keuzelijst(cls.options)

