from django.contrib.auth import mixins


class SuperuserRequiredMixin(mixins.AccessMixin):
    def dispatch(self, request, *args, **kwargs):
        if not request.user.is_superuser:
            return self.handle_no_permission()
        return super().dispatch(request, *args, **kwargs)
