"""
This module is flow360 for simulation based models
"""

from flow360.accounts_utils import Accounts
from flow360.cli.api_set_func import configure_caller as configure
from flow360.component.case import Case
from flow360.component.geometry import Geometry
from flow360.component.project import Project
from flow360.component.simulation import migration, services
from flow360.component.simulation import units as u
from flow360.component.simulation.entity_operation import Transformation
from flow360.component.simulation.folder import Folder
from flow360.component.simulation.meshing_param.edge_params import (
    AngleBasedRefinement,
    AspectRatioBasedRefinement,
    HeightBasedRefinement,
    ProjectAnisoSpacing,
    SurfaceEdgeRefinement,
)
from flow360.component.simulation.meshing_param.face_params import (
    BoundaryLayer,
    GeometryRefinement,
    PassiveSpacing,
    SurfaceRefinement,
)
from flow360.component.simulation.meshing_param.meshing_specs import (
    BetaVolumeMeshingDefaults,
    MeshingDefaults,
    SnappyCastellatedMeshControls,
    SnappyQualityMetrics,
    SnappySmoothControls,
    SnappySnapControls,
    SnappySurfaceMeshingDefaults,
)
from flow360.component.simulation.meshing_param.params import (
    BetaVolumeMeshingParams,
    MeshingParams,
    ModularMeshingWorkflow,
    SnappySurfaceMeshingParams,
)
from flow360.component.simulation.meshing_param.surface_mesh_refinements import (
    SnappyBodyRefinement,
    SnappyRegionRefinement,
    SnappySurfaceEdgeRefinement,
)
from flow360.component.simulation.meshing_param.volume_params import (
    AutomatedFarfield,
    AxisymmetricRefinement,
    RotationCylinder,
    UniformRefinement,
    UserDefinedFarfield,
)
from flow360.component.simulation.models.material import (
    Air,
    SolidMaterial,
    Sutherland,
    Water,
)
from flow360.component.simulation.models.solver_numerics import (
    DetachedEddySimulation,
    HeatEquationSolver,
    KOmegaSST,
    KOmegaSSTModelConstants,
    LinearSolver,
    NavierStokesSolver,
    NoneSolver,
    SpalartAllmaras,
    SpalartAllmarasModelConstants,
    TransitionModelSolver,
    TurbulenceModelControls,
)
from flow360.component.simulation.models.surface_models import (
    Freestream,
    HeatFlux,
    Inflow,
    Mach,
    MassFlowRate,
    Outflow,
    Periodic,
    PorousJump,
    Pressure,
    Rotational,
    SlaterPorousBleed,
    SlipWall,
    SymmetryPlane,
    Temperature,
    TotalPressure,
    Translational,
    Wall,
    WallRotation,
)
from flow360.component.simulation.models.turbulence_quantities import (
    TurbulenceQuantities,
)
from flow360.component.simulation.models.volume_models import (
    ActuatorDisk,
    AngleExpression,
    AngularVelocity,
    BETDisk,
    BETDiskChord,
    BETDiskSectionalPolar,
    BETDiskTwist,
    C81File,
    DFDCFile,
    Fluid,
    ForcePerArea,
    FromUserDefinedDynamics,
    HeatEquationInitialCondition,
    NavierStokesInitialCondition,
    NavierStokesModifiedRestartSolution,
    PorousMedium,
    Rotation,
    Solid,
    XFOILFile,
    XROTORFile,
)
from flow360.component.simulation.operating_condition.operating_condition import (
    AerospaceCondition,
    GenericReferenceCondition,
    LiquidOperatingCondition,
    ThermalState,
)
from flow360.component.simulation.outputs.output_entities import (
    Isosurface,
    Point,
    PointArray,
    PointArray2D,
    Slice,
)
from flow360.component.simulation.outputs.outputs import (
    AeroAcousticOutput,
    ImportedSurfaceIntegralOutput,
    ImportedSurfaceOutput,
    IsosurfaceOutput,
    Observer,
    ProbeOutput,
    SliceOutput,
    StreamlineOutput,
    SurfaceIntegralOutput,
    SurfaceOutput,
    SurfaceProbeOutput,
    SurfaceSliceOutput,
    TimeAverageImportedSurfaceOutput,
    TimeAverageIsosurfaceOutput,
    TimeAverageProbeOutput,
    TimeAverageSliceOutput,
    TimeAverageSurfaceOutput,
    TimeAverageSurfaceProbeOutput,
    TimeAverageVolumeOutput,
    UserDefinedField,
    VolumeOutput,
)
from flow360.component.simulation.primitives import (
    Box,
    CustomVolume,
    Cylinder,
    MeshZone,
    ReferenceGeometry,
    SnappyBody,
)
from flow360.component.simulation.simulation_params import SimulationParams
from flow360.component.simulation.time_stepping.time_stepping import (
    AdaptiveCFL,
    RampCFL,
    Steady,
    Unsteady,
)
from flow360.component.simulation.unit_system import (
    CGS_unit_system,
    SI_unit_system,
    imperial_unit_system,
)
from flow360.component.simulation.user_code.core.types import (
    UserVariable,
    get_user_variable,
    remove_user_variable,
    show_user_variables,
)
from flow360.component.simulation.user_code.functions import math
from flow360.component.simulation.user_code.variables import solution
from flow360.component.simulation.user_defined_dynamics.user_defined_dynamics import (
    UserDefinedDynamic,
)
from flow360.component.surface_mesh_v2 import SurfaceMeshV2 as SurfaceMesh
from flow360.component.volume_mesh import VolumeMeshV2 as VolumeMesh
from flow360.environment import Env
from flow360.plugins import report
from flow360.version import __solver_version__, __version__

__all__ = [
    "GeometryRefinement",
    "Env",
    "Case",
    "CustomVolume",
    "AngleBasedRefinement",
    "AspectRatioBasedRefinement",
    "ProjectAnisoSpacing",
    "BoundaryLayer",
    "PassiveSpacing",
    "__solver_version__",
    "__version__",
    "Accounts",
    "Project",
    "u",
    "SimulationParams",
    "SI_unit_system",
    "imperial_unit_system",
    "CGS_unit_system",
    "services",
    "MeshingParams",
    "MeshingDefaults",
    "SurfaceRefinement",
    "AutomatedFarfield",
    "AxisymmetricRefinement",
    "RotationCylinder",
    "UniformRefinement",
    "SurfaceEdgeRefinement",
    "HeightBasedRefinement",
    "ReferenceGeometry",
    "Cylinder",
    "AerospaceCondition",
    "ThermalState",
    "LiquidOperatingCondition",
    "Steady",
    "Unsteady",
    "RampCFL",
    "AdaptiveCFL",
    "Wall",
    "Freestream",
    "SlipWall",
    "Outflow",
    "Inflow",
    "Periodic",
    "PorousJump",
    "SymmetryPlane",
    "Fluid",
    "Solid",
    "ActuatorDisk",
    "AngularVelocity",
    "BETDisk",
    "BETDiskChord",
    "BETDiskSectionalPolar",
    "BETDiskTwist",
    "Rotation",
    "PorousMedium",
    "SurfaceOutput",
    "TimeAverageSurfaceOutput",
    "VolumeOutput",
    "TimeAverageVolumeOutput",
    "SliceOutput",
    "TimeAverageSliceOutput",
    "IsosurfaceOutput",
    "TimeAverageIsosurfaceOutput",
    "SurfaceIntegralOutput",
    "ProbeOutput",
    "SurfaceProbeOutput",
    "AeroAcousticOutput",
    "ImportedSurfaceOutput",
    "TimeAverageImportedSurfaceOutput",
    "ImportedSurfaceIntegralOutput",
    "Observer",
    "HeatEquationSolver",
    "NavierStokesSolver",
    "NoneSolver",
    "SpalartAllmaras",
    "KOmegaSST",
    "SpalartAllmarasModelConstants",
    "DetachedEddySimulation",
    "KOmegaSSTModelConstants",
    "LinearSolver",
    "Folder",
    "ForcePerArea",
    "Air",
    "Sutherland",
    "SolidMaterial",
    "Slice",
    "Isosurface",
    "TurbulenceQuantities",
    "UserDefinedDynamic",
    "Translational",
    "NavierStokesInitialCondition",
    "NavierStokesModifiedRestartSolution",
    "FromUserDefinedDynamics",
    "HeatEquationInitialCondition",
    "Temperature",
    "HeatFlux",
    "Point",
    "PointArray",
    "AngleExpression",
    "Box",
    "GenericReferenceCondition",
    "TransitionModelSolver",
    "TurbulenceModelControls",
    "Pressure",
    "TotalPressure",
    "Rotational",
    "Mach",
    "MassFlowRate",
    "UserDefinedField",
    "VolumeMesh",
    "SurfaceMesh",
    "UserDefinedFarfield",
    "Geometry",
    "XROTORFile",
    "DFDCFile",
    "C81File",
    "XFOILFile",
    "TimeAverageProbeOutput",
    "TimeAverageSurfaceProbeOutput",
    "SurfaceSliceOutput",
    "SlaterPorousBleed",
    "migration",
    "Water",
    "PointArray2D",
    "StreamlineOutput",
    "Transformation",
    "WallRotation",
    "UserVariable",
    "math",
    "solution",
    "report",
    "ModularMeshingWorkflow",
    "SnappySurfaceMeshingDefaults",
    "SnappySnapControls",
    "SnappyCastellatedMeshControls",
    "SnappyQualityMetrics",
    "SnappySmoothControls",
    "SnappyBodyRefinement",
    "SnappyRegionRefinement",
    "SnappySurfaceEdgeRefinement",
    "SnappyBody",
    "MeshZone",
    "SnappySurfaceMeshingParams",
    "BetaVolumeMeshingParams",
    "BetaVolumeMeshingDefaults",
    "get_user_variable",
    "show_user_variables",
    "remove_user_variable",
]
