"""
Flow360 V1 (legacy) modules.
"""

import os

from numpy import pi

from flow360 import global_exception_handler
from flow360.cli import flow360
from flow360.cloud.s3_utils import ProgressCallbackInterface
from flow360.component.case import Case
from flow360.component.case import CaseList as MyCases
from flow360.component.folder import Folder
from flow360.component.surface_mesh import SurfaceMesh
from flow360.component.surface_mesh import SurfaceMeshList as MySurfaceMeshes
from flow360.component.v1 import meshing, solvers, units
from flow360.component.v1.boundaries import (
    FreestreamBoundary,
    HeatFluxWall,
    IsothermalWall,
    MassInflow,
    MassOutflow,
    NoSlipWall,
    PressureOutflow,
    RiemannInvariant,
    RotationallyPeriodic,
    SlidingInterfaceBoundary,
    SlipWall,
    SolidAdiabaticWall,
    SolidIsothermalWall,
    SubsonicInflow,
    SubsonicOutflowMach,
    SubsonicOutflowPressure,
    SupersonicInflow,
    SymmetryPlane,
    TranslationallyPeriodic,
    VelocityInflow,
    WallFunction,
)
from flow360.component.v1.flow360_output import (
    IsoSurfaceOutput,
    IsoSurfaces,
    MonitorOutput,
    Monitors,
    ProbeMonitor,
    Slice,
    SliceOutput,
    Slices,
    SurfaceIntegralMonitor,
    SurfaceOutput,
    Surfaces,
)
from flow360.component.v1.flow360_params import (
    ActuatorDisk,
    AeroacousticOutput,
    AirDensityTemperature,
    AirPressureTemperature,
    BETDisk,
    BETDiskChord,
    BETDiskSectionalPolar,
    BETDiskTwist,
    Boundaries,
    Flow360MeshParams,
    Flow360Params,
    ForcePerArea,
    FreestreamFromMach,
    FreestreamFromMachReynolds,
    FreestreamFromVelocity,
    Geometry,
    HeatEquationSolver,
    MeshBoundary,
    PorousMediumBox,
    SlidingInterface,
    TransitionModelSolver,
    UnvalidatedFlow360Params,
    UserDefinedDynamic,
    VolumeOutput,
    VolumeZones,
    ZeroFreestream,
    ZeroFreestreamFromVelocity,
    air,
)
from flow360.component.v1.initial_condition import (
    ExpressionInitialCondition,
    ModifiedRestartSolution,
)
from flow360.component.v1.meshing.params import (
    Aniso,
    BoxRefinement,
    CylinderRefinement,
    Edges,
    Face,
    Faces,
    Farfield,
    ProjectAniso,
    RotorDisk,
    SurfaceMeshingParams,
    UseAdjacent,
    Volume,
    VolumeMeshingParams,
)
from flow360.component.v1.solvers import (
    IncompressibleNavierStokesSolver,
    KOmegaSST,
    KOmegaSSTModelConstants,
    LinearSolver,
    NavierStokesSolver,
    NoneSolver,
    PressureCorrectionSolver,
    SpalartAllmaras,
    SpalartAllmarasModelConstants,
)
from flow360.component.v1.time_stepping import (
    AdaptiveCFL,
    RampCFL,
    SteadyTimeStepping,
    TimeStepping,
    UnsteadyTimeStepping,
)
from flow360.component.v1.turbulence_quantities import TurbulenceQuantities
from flow360.component.v1.unit_system import (
    CGS_unit_system,
    SI_unit_system,
    UnitSystem,
    flow360_unit_system,
    imperial_unit_system,
)
from flow360.component.v1.volume_zones import (
    FluidDynamicsVolumeZone,
    HeatTransferVolumeZone,
    InitialConditionHeatTransfer,
    PorousMediumVolumeZone,
    ReferenceFrame,
    ReferenceFrameDynamic,
    ReferenceFrameExpression,
    ReferenceFrameOmegaDegrees,
    ReferenceFrameOmegaRadians,
)
from flow360.component.volume_mesh import VolumeMesh
from flow360.component.volume_mesh import VolumeMeshList as MyVolumeMeshes
from flow360.flags import Flags
from flow360.user_config import UserConfig

__all__ = [
    "ActuatorDisk",
    "AdaptiveCFL",
    "AeroacousticOutput",
    "AirDensityTemperature",
    "AirPressureTemperature",
    "Aniso",
    "BETDisk",
    "BETDiskChord",
    "BETDiskSectionalPolar",
    "BETDiskTwist",
    "Boundaries",
    "BoxRefinement",
    "CGS_unit_system",
    "Case",
    "CylinderRefinement",
    "Edges",
    "ExpressionInitialCondition",
    "Face",
    "Faces",
    "Farfield",
    "Flags",
    "Flow360MeshParams",
    "Flow360Params",
    "FluidDynamicsVolumeZone",
    "Folder",
    "ForcePerArea",
    "FreestreamBoundary",
    "FreestreamFromMach",
    "FreestreamFromMachReynolds",
    "FreestreamFromVelocity",
    "Geometry",
    "HeatEquationSolver",
    "HeatFluxWall",
    "HeatTransferVolumeZone",
    "IncompressibleNavierStokesSolver",
    "InitialConditionHeatTransfer",
    "IsoSurfaceOutput",
    "IsoSurfaces",
    "IsothermalWall",
    "KOmegaSST",
    "KOmegaSSTModelConstants",
    "LinearSolver",
    "MassInflow",
    "MassOutflow",
    "MeshBoundary",
    "ModifiedRestartSolution",
    "MonitorOutput",
    "Monitors",
    "MyCases",
    "MySurfaceMeshes",
    "MyVolumeMeshes",
    "NavierStokesSolver",
    "NoSlipWall",
    "NoneSolver",
    "PorousMediumBox",
    "PorousMediumVolumeZone",
    "PressureCorrectionSolver",
    "PressureOutflow",
    "ProbeMonitor",
    "ProgressCallbackInterface",
    "ProjectAniso",
    "RampCFL",
    "ReferenceFrame",
    "ReferenceFrameDynamic",
    "ReferenceFrameExpression",
    "ReferenceFrameOmegaDegrees",
    "ReferenceFrameOmegaRadians",
    "RiemannInvariant",
    "RotationallyPeriodic",
    "RotorDisk",
    "SI_unit_system",
    "Slice",
    "SliceOutput",
    "Slices",
    "SlidingInterface",
    "SlidingInterfaceBoundary",
    "SlipWall",
    "SolidAdiabaticWall",
    "SolidIsothermalWall",
    "SpalartAllmaras",
    "SpalartAllmarasModelConstants",
    "SteadyTimeStepping",
    "SubsonicInflow",
    "SubsonicOutflowMach",
    "SubsonicOutflowPressure",
    "SupersonicInflow",
    "SurfaceIntegralMonitor",
    "SurfaceMesh",
    "SurfaceMeshingParams",
    "SurfaceOutput",
    "Surfaces",
    "SymmetryPlane",
    "TimeStepping",
    "TransitionModelSolver",
    "TranslationallyPeriodic",
    "TurbulenceQuantities",
    "UnitSystem",
    "UnsteadyTimeStepping",
    "UnvalidatedFlow360Params",
    "UseAdjacent",
    "UserConfig",
    "UserDefinedDynamic",
    "VelocityInflow",
    "Volume",
    "VolumeMesh",
    "VolumeMeshingParams",
    "VolumeOutput",
    "VolumeZones",
    "WallFunction",
    "ZeroFreestream",
    "ZeroFreestreamFromVelocity",
    "air",
    "flow360",
    "flow360_unit_system",
    "global_exception_handler",
    "imperial_unit_system",
    "meshing",
    "os",
    "pi",
    "solvers",
    "units",
]
