"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ScaleOnCpuUtilization = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const extension_interfaces_1 = require("./extension-interfaces");
// The default autoscaling settings
const cpuScalingPropsDefault = {
    initialTaskCount: 2,
    minTaskCount: 2,
    maxTaskCount: 8,
    targetCpuUtilization: 50,
    scaleOutCooldown: aws_cdk_lib_1.Duration.seconds(60),
    scaleInCooldown: aws_cdk_lib_1.Duration.seconds(60),
};
/**
 * This extension helps you scale your service according to CPU utilization.
 *
 * @deprecated To enable target tracking based on CPU utilization, use the `targetCpuUtilization` property of `autoScaleTaskCount` in the `Service` construct.
 * For more information, please refer https://github.com/aws/aws-cdk/blob/master/packages/%40aws-cdk-containers/ecs-service-extensions/README.md#task-auto-scaling .
 */
class ScaleOnCpuUtilization extends extension_interfaces_1.ServiceExtension {
    constructor(props) {
        super('scale-on-cpu-utilization');
        let combinedProps = {
            ...cpuScalingPropsDefault,
            ...props,
        };
        this.initialTaskCount = combinedProps.initialTaskCount;
        this.minTaskCount = combinedProps.minTaskCount;
        this.maxTaskCount = combinedProps.maxTaskCount;
        this.targetCpuUtilization = combinedProps.targetCpuUtilization;
        this.scaleOutCooldown = combinedProps.scaleOutCooldown;
        this.scaleInCooldown = combinedProps.scaleInCooldown;
    }
    // This service modifies properties of the service prior
    // to construct creation.
    modifyServiceProps(props) {
        return {
            ...props,
            // Launch an initial number of tasks
            // In the future we should change this to use a custom resource
            // to read the current task count set by autoscaling, so that the task
            // count doesn't rollback to the initial level on each deploy.
            desiredCount: this.initialTaskCount,
        };
    }
    // This hook utilizes the resulting service construct
    // once it is created.
    useService(service) {
        if (this.parentService.scalableTaskCount) {
            throw Error('Cannot specify \'autoScaleTaskCount\' in the Service construct and also provide a  \'ScaleOnCpuUtilization\' extension. \'ScaleOnCpuUtilization\' is deprecated. Please only provide \'autoScaleTaskCount\'.');
        }
        const scalingTarget = service.autoScaleTaskCount({
            minCapacity: this.minTaskCount,
            maxCapacity: this.maxTaskCount,
        });
        scalingTarget.scaleOnCpuUtilization(`${this.parentService.id}-target-cpu-utilization-${this.targetCpuUtilization}`, {
            targetUtilizationPercent: this.targetCpuUtilization,
            scaleInCooldown: this.scaleInCooldown,
            scaleOutCooldown: this.scaleOutCooldown,
        });
        this.parentService.enableAutoScalingPolicy();
    }
}
exports.ScaleOnCpuUtilization = ScaleOnCpuUtilization;
_a = JSII_RTTI_SYMBOL_1;
ScaleOnCpuUtilization[_a] = { fqn: "@aws-cdk-containers/ecs-service-extensions.ScaleOnCpuUtilization", version: "2.0.0-alpha.160" };
//# sourceMappingURL=data:application/json;base64,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