# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.http_response import AsyncHttpResponse, HttpResponse
from ..core.jsonable_encoder import jsonable_encoder
from ..core.pydantic_utilities import parse_obj_as
from ..core.request_options import RequestOptions
from ..errors.unprocessable_entity_error import UnprocessableEntityError
from ..types.http_validation_error import HttpValidationError
from ..types.response import Response
from ..types.response_active_sessions_result import ResponseActiveSessionsResult
from ..types.response_jupyter_execute_response import ResponseJupyterExecuteResponse
from ..types.response_jupyter_info_response import ResponseJupyterInfoResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawJupyterClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def execute_jupyter_code(
        self,
        *,
        code: str,
        timeout: typing.Optional[int] = OMIT,
        kernel_name: typing.Optional[str] = OMIT,
        session_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[ResponseJupyterExecuteResponse]:
        """
        Execute Python code using Jupyter kernel with session persistence

        This endpoint allows you to execute Python code and get results back.
        You can optionally specify a kernel_name (defaults to 'python3').
        Use session_id to maintain variable state across multiple requests.
        Sessions automatically expire after 30 minutes of inactivity.

        Parameters
        ----------
        code : str
            Python code to execute

        timeout : typing.Optional[int]
            Execution timeout in seconds

        kernel_name : typing.Optional[str]
            Kernel name to use (e.g., 'python3', 'python3.11'). Defaults to 'python3'

        session_id : typing.Optional[str]
            Session ID to maintain kernel state across requests

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ResponseJupyterExecuteResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/jupyter/execute",
            method="POST",
            json={
                "code": code,
                "timeout": timeout,
                "kernel_name": kernel_name,
                "session_id": session_id,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ResponseJupyterExecuteResponse,
                    parse_obj_as(
                        type_=ResponseJupyterExecuteResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def info(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[ResponseJupyterInfoResponse]:
        """
        Get information about available Jupyter kernels

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ResponseJupyterInfoResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/jupyter/info",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ResponseJupyterInfoResponse,
                    parse_obj_as(
                        type_=ResponseJupyterInfoResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def list_sessions(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[ResponseActiveSessionsResult]:
        """
        List all active Jupyter sessions

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ResponseActiveSessionsResult]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/jupyter/sessions",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ResponseActiveSessionsResult,
                    parse_obj_as(
                        type_=ResponseActiveSessionsResult,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def cleanup_all_sessions(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[Response]:
        """
        Cleanup all active sessions

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[Response]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/jupyter/sessions",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Response,
                    parse_obj_as(
                        type_=Response,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def cleanup_session(
        self, session_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[Response]:
        """
        Manually cleanup a specific session

        Parameters
        ----------
        session_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[Response]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v1/jupyter/sessions/{jsonable_encoder(session_id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Response,
                    parse_obj_as(
                        type_=Response,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawJupyterClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def execute_jupyter_code(
        self,
        *,
        code: str,
        timeout: typing.Optional[int] = OMIT,
        kernel_name: typing.Optional[str] = OMIT,
        session_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[ResponseJupyterExecuteResponse]:
        """
        Execute Python code using Jupyter kernel with session persistence

        This endpoint allows you to execute Python code and get results back.
        You can optionally specify a kernel_name (defaults to 'python3').
        Use session_id to maintain variable state across multiple requests.
        Sessions automatically expire after 30 minutes of inactivity.

        Parameters
        ----------
        code : str
            Python code to execute

        timeout : typing.Optional[int]
            Execution timeout in seconds

        kernel_name : typing.Optional[str]
            Kernel name to use (e.g., 'python3', 'python3.11'). Defaults to 'python3'

        session_id : typing.Optional[str]
            Session ID to maintain kernel state across requests

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ResponseJupyterExecuteResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/jupyter/execute",
            method="POST",
            json={
                "code": code,
                "timeout": timeout,
                "kernel_name": kernel_name,
                "session_id": session_id,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ResponseJupyterExecuteResponse,
                    parse_obj_as(
                        type_=ResponseJupyterExecuteResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def info(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[ResponseJupyterInfoResponse]:
        """
        Get information about available Jupyter kernels

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ResponseJupyterInfoResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/jupyter/info",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ResponseJupyterInfoResponse,
                    parse_obj_as(
                        type_=ResponseJupyterInfoResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def list_sessions(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[ResponseActiveSessionsResult]:
        """
        List all active Jupyter sessions

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ResponseActiveSessionsResult]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/jupyter/sessions",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ResponseActiveSessionsResult,
                    parse_obj_as(
                        type_=ResponseActiveSessionsResult,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def cleanup_all_sessions(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[Response]:
        """
        Cleanup all active sessions

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[Response]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/jupyter/sessions",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Response,
                    parse_obj_as(
                        type_=Response,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def cleanup_session(
        self, session_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[Response]:
        """
        Manually cleanup a specific session

        Parameters
        ----------
        session_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[Response]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v1/jupyter/sessions/{jsonable_encoder(session_id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Response,
                    parse_obj_as(
                        type_=Response,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
