# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.http_response import AsyncHttpResponse, HttpResponse
from ..core.jsonable_encoder import jsonable_encoder
from ..core.pydantic_utilities import parse_obj_as
from ..core.request_options import RequestOptions
from ..errors.unprocessable_entity_error import UnprocessableEntityError
from ..types.http_validation_error import HttpValidationError
from ..types.response_call_tool_result import ResponseCallToolResult
from ..types.response_list_str import ResponseListStr
from ..types.response_list_tools_result import ResponseListToolsResult

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawMcpClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def list_mcp_tools(
        self, server_name: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[ResponseListToolsResult]:
        """
        List all available tools from the specified MCP server

        Args:
            server_name: The name of the MCP server as defined in mcp-servers.json

        Returns:
            Response containing the list of available tools with their descriptions and parameters

        Parameters
        ----------
        server_name : str
            Name of the MCP server

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ResponseListToolsResult]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v1/mcp/{jsonable_encoder(server_name)}/tools",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ResponseListToolsResult,
                    parse_obj_as(
                        type_=ResponseListToolsResult,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def execute_mcp_tool(
        self,
        server_name: str,
        tool_name: str,
        *,
        request: typing.Dict[str, typing.Optional[typing.Any]],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[ResponseCallToolResult]:
        """
        Execute a specific tool on the specified MCP server

        Args:
            server_name: The name of the MCP server as defined in mcp-servers.json
            tool_name: The name of the tool to execute
            arguments: Tool arguments dictionary

        Returns:
            Response containing the tool execution results

        Parameters
        ----------
        server_name : str
            Name of the MCP server

        tool_name : str
            Name of the tool to execute

        request : typing.Dict[str, typing.Optional[typing.Any]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ResponseCallToolResult]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v1/mcp/{jsonable_encoder(server_name)}/tools/{jsonable_encoder(tool_name)}",
            method="POST",
            json=request,
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ResponseCallToolResult,
                    parse_obj_as(
                        type_=ResponseCallToolResult,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def list_mcp_servers(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[ResponseListStr]:
        """
        List all configured MCP servers

        Returns:
            Response containing the list of configured and filtered MCP servers

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ResponseListStr]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/mcp/servers",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ResponseListStr,
                    parse_obj_as(
                        type_=ResponseListStr,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawMcpClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def list_mcp_tools(
        self, server_name: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[ResponseListToolsResult]:
        """
        List all available tools from the specified MCP server

        Args:
            server_name: The name of the MCP server as defined in mcp-servers.json

        Returns:
            Response containing the list of available tools with their descriptions and parameters

        Parameters
        ----------
        server_name : str
            Name of the MCP server

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ResponseListToolsResult]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v1/mcp/{jsonable_encoder(server_name)}/tools",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ResponseListToolsResult,
                    parse_obj_as(
                        type_=ResponseListToolsResult,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def execute_mcp_tool(
        self,
        server_name: str,
        tool_name: str,
        *,
        request: typing.Dict[str, typing.Optional[typing.Any]],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[ResponseCallToolResult]:
        """
        Execute a specific tool on the specified MCP server

        Args:
            server_name: The name of the MCP server as defined in mcp-servers.json
            tool_name: The name of the tool to execute
            arguments: Tool arguments dictionary

        Returns:
            Response containing the tool execution results

        Parameters
        ----------
        server_name : str
            Name of the MCP server

        tool_name : str
            Name of the tool to execute

        request : typing.Dict[str, typing.Optional[typing.Any]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ResponseCallToolResult]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v1/mcp/{jsonable_encoder(server_name)}/tools/{jsonable_encoder(tool_name)}",
            method="POST",
            json=request,
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ResponseCallToolResult,
                    parse_obj_as(
                        type_=ResponseCallToolResult,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def list_mcp_servers(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[ResponseListStr]:
        """
        List all configured MCP servers

        Returns:
            Response containing the list of configured and filtered MCP servers

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ResponseListStr]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/mcp/servers",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ResponseListStr,
                    parse_obj_as(
                        type_=ResponseListStr,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
