# This file was auto-generated by Fern from our API Definition.

import typing
from typing import Optional



import volcenginesdkvefaas
import volcenginesdkcore

from .base import BaseProvider
from ..types.sandbox_response import SandboxResponse


class VolcengineProvider(BaseProvider):
    """
    Volcengine cloud provider implementation for sandbox management.
    
    This provider uses the Volcengine VEFAAS (Volcengine Function as a Service)
    API to manage sandbox instances.
    """
    
    def __init__(
        self,
        access_key: str,
        secret_key: str,
        region: str = "cn-beijing",
        client_side_validation: bool = True
    ):
        """
        Initialize the Volcengine provider.
        
        Parameters
        ----------
        access_key : str
            Volcengine access key ID
        secret_key : str
            Volcengine secret access key
        region : str, optional
            Volcengine region, defaults to "cn-beijing"
        client_side_validation : bool, optional
            Enable client-side validation, defaults to True
        """
        
        self.access_key = access_key
        self.secret_key = secret_key
        self.region = region
        self.client_side_validation = client_side_validation
        
        # Initialize Volcengine configuration
        configuration = volcenginesdkcore.Configuration()
        configuration.ak = access_key
        configuration.sk = secret_key
        configuration.region = region
        configuration.client_side_validation = client_side_validation
        volcenginesdkcore.Configuration.set_default(configuration)

        # Initialize VEFAAS client
        self._client = volcenginesdkvefaas.VEFAASApi(volcenginesdkcore.ApiClient(configuration))
    
    def create_sandbox(
        self,
        function_id: str,
        timeout: int = 30,
        **kwargs
    ) -> SandboxResponse:
        """
        Create a new sandbox instance using Volcengine VEFAAS.
        
        Parameters
        ----------
        function_id : str
            The function ID for the sandbox
        timeout: int
            The timeout for the sandbox creation in minutes
        **kwargs
            Additional parameters for sandbox creation
            
        Returns
        -------
        str
            The ID of the created sandbox
        Exception
            The exception raised if the sandbox creation fails
        -------
        """
        try:
            request = volcenginesdkvefaas.CreateSandboxRequest(
                function_id=function_id,
                timeout=timeout,
                **kwargs
            )
            response = self._client.create_sandbox(request)
            return response.sandbox_id
            
        except Exception as e:
            return e
    
    def delete_sandbox(self, function_id: str, sandbox_id: str, **kwargs) -> SandboxResponse:
        """
        Delete an existing sandbox instance.
        
        Parameters
        ----------
        function_id : str
            The function ID of the sandbox
        sandbox_id : str
            The ID of the sandbox to delete
        **kwargs
            Additional parameters for sandbox deletion
            
        Returns
        -------
        SandboxResponse
            The response containing deletion status
        """
        try:
            request = volcenginesdkvefaas.KillSandboxRequest(
                function_id=function_id,
                sandbox_id=sandbox_id,
                **kwargs
            )
            response = self._client.kill_sandbox(request)

            return response
        
        except Exception as e:
            return e
    
    def get_sandbox(self, function_id: str, sandbox_id: str, **kwargs) -> SandboxResponse:
        """
        Get details of an existing sandbox instance.
        
        Parameters
        ----------
        function_id : str
            The function ID of the sandbox
        sandbox_id : str
            The ID of the sandbox to retrieve
        **kwargs
            Additional parameters for sandbox retrieval
            
        Returns
        -------
        SandboxResponse
            The response containing sandbox details
        """
        try:
            request = volcenginesdkvefaas.DescribeSandboxRequest(
                function_id=function_id,
                sandbox_id=sandbox_id,
                **kwargs
            )
            response = self._client.describe_sandbox(request)
            
            return response
            
        except Exception as e:
            return e
    
    def list_sandboxes(self, function_id: str, **kwargs) -> SandboxResponse:
        """
        List all sandbox instances for a function.
        
        Parameters
        ----------
        function_id : str
            The function ID to list sandboxes for
        **kwargs
            Additional parameters for listing sandboxes
            
        Returns
        -------
        SandboxResponse
            The response containing list of sandboxes
        """
        try:
            request = volcenginesdkvefaas.ListSandboxesRequest(
                function_id=function_id,
                **kwargs
            )
            response = self._client.list_sandboxes(request)
            
            return response.sandboxes
            
        except Exception as e:
            return e
