# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .browser_viewport import BrowserViewport


class BrowserInfoResult(UniversalBaseModel):
    """
    Browser Info result
    """

    user_agent: str = pydantic.Field()
    """
    User agent
    """

    cdp_url: str = pydantic.Field()
    """
    Browser CDP URL
    """

    vnc_url: str = pydantic.Field()
    """
    VNC URL
    """

    viewport: BrowserViewport = pydantic.Field()
    """
    Viewport size
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
