# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class JupyterOutput(UniversalBaseModel):
    """
    Jupyter execution output model
    """

    output_type: str = pydantic.Field()
    """
    Type of output: stream, execute_result, display_data, or error
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Stream name (stdout/stderr) for stream outputs
    """

    text: typing.Optional[str] = pydantic.Field(default=None)
    """
    Text content for stream outputs
    """

    data: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = pydantic.Field(default=None)
    """
    Output data for execute_result/display_data
    """

    metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = pydantic.Field(default=None)
    """
    Output metadata
    """

    execution_count: typing.Optional[int] = pydantic.Field(default=None)
    """
    Execution count for execute_result
    """

    ename: typing.Optional[str] = pydantic.Field(default=None)
    """
    Error name for error outputs
    """

    evalue: typing.Optional[str] = pydantic.Field(default=None)
    """
    Error value for error outputs
    """

    traceback: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    Error traceback for error outputs
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
