
WIKI = """
# Telecom Customer Service Knowledge Base

## Service Plans Overview

### Mobile Services
- **Unlimited Plan**: $85/month - Unlimited data, 5G access, 50GB hotspot
- **Family Plan (4 lines)**: $160/month - Shared 40GB data, family controls
- **Business Plan (10 lines)**: $450/month - Unlimited data, priority network
- **Basic Plan**: $35/month - 5GB data, unlimited talk/text
- **Senior Plan**: $45/month - 10GB data, senior discount, large button phone option

### Internet Services
- **Fiber 2GB**: $120/month - 2000 Mbps up/down, premium router
- **Fiber 1GB**: $80/month - 1000 Mbps up/down, router included
- **Fiber 500MB**: $60/month - 500 Mbps up/down, router included
- **Cable 500MB**: $55/month - 500 Mbps down/50 up, router included
- **Cable 100MB**: $35/month - 100 Mbps down/10 up, 1TB data limit

### TV Services
- **Premium Package**: $95/month - 300+ channels, premium networks, 500hr DVR
- **Basic Package**: $45/month - 125 channels, local channels, 100hr DVR
- **Sports Package**: $75/month - 200 channels, all sports networks, 300hr DVR

### Additional Services
- **Business Phone System**: $150/month - 10 lines, unlimited calling, advanced features
- **Home Security**: $40/month - 24/7 monitoring, sensors, mobile app

## Device Information

### Mobile Devices
- Support for iPhone (all models), Samsung Galaxy, Google Pixel
- BYOD (Bring Your Own Device) supported
- Device insurance and replacement programs available
- Trade-in programs for upgrades

### Networking Equipment
- WiFi 6 routers for fiber services
- Standard routers for cable services
- Mesh systems available for large homes
- Enterprise-grade equipment for business customers

### TV Equipment
- Smart TV apps available
- HD and 4K cable boxes
- DVR functionality included with most packages
- Streaming device compatibility

## Troubleshooting Quick Reference

### Mobile Issues
- **No Service**: Check coverage area, restart device, check for outages
- **Slow Data**: Verify data allowance, check network congestion, restart device
- **Call Issues**: Check signal strength, verify number, restart device

### Internet Issues
- **Slow Speeds**: Power cycle router, check for interference, run speed test
- **No Connection**: Check cables, verify power, check for outages
- **WiFi Problems**: Move closer to router, check password, restart router

### TV Issues
- **No Signal**: Check input source, verify connections, restart cable box
- **Poor Quality**: Check cable connections, verify signal strength
- **Remote Issues**: Replace batteries, check line of sight, request replacement

## Billing Information

### Payment Methods
- Auto-pay (credit card or bank account)
- Online payments
- Phone payments
- Mail-in payments
- In-store payments

### Billing Cycles
- Monthly billing on account creation date
- Paperless billing available with $5 discount
- Late fees apply after 30 days
- Service suspension after 60 days non-payment

### Credits and Adjustments
- Service outage credits automatically applied
- Prorated charges for service changes
- Early termination fees for contract services
- Senior and military discounts available

## Network Coverage

### Service Areas
- Major metropolitan areas with 5G coverage
- Fiber internet in select neighborhoods
- Cable internet widely available
- Rural coverage through partner networks

### Network Status
- Real-time outage information available
- Planned maintenance notifications
- Service quality monitoring
- Customer impact assessments

## Support Escalation

### Tier 1 Support (You)
- Basic troubleshooting
- Account information
- Service changes
- Billing inquiries

### Tier 2 Support (Human Agents)
- Complex technical issues
- Billing disputes
- Service installation coordination
- Advanced troubleshooting

### Supervisor Escalation
- Customer complaints
- Service credits/adjustments
- Policy exceptions
- Retention offers

## Customer Privacy

### Data Protection
- Customer information is confidential
- Verify identity before providing account details
- Follow data retention policies
- Report security incidents immediately

### Account Access
- Primary account holder verification required
- Authorized user list maintained
- Password/PIN verification for phone support
- Multi-factor authentication available
"""
