#!/usr/bin/env python3
"""
****************************************************************************************************
*******************************************************************#********************************
*********************************************************##******#@*****%#******#*******************
**************************************************#****#%#*******#%@#************#%%#***************
*****************************************************#@#****#***###%@%**************%@%*************
****************************************************#@%**##@%%@%%##@@@#**#***********#@@%***********
***************************************************##@@###%#%%%%%#%@@@****************#@@%#*********
***************************************************#%#%%%%%%%%%%@@@@@@%#**************#@@@%#********
****************************************************#%%#%%%@@@@@@@@@@%%####************@@@@%#*******
****************************************************#@%%%@#**#@%%@@@@@#****************@@@@@%*******
*****************************************************#*%%@***#@@@@@@@@@##%#***********#@@@@@%%******
*****************************************************%%@@%@%%@@%@@@@@@@@%%###*********%@@@@@@%#*****
******************************************************%%%%%%#%%@%@@@@@@@@@%##********#@@@@@@@@@*****
*********#@@@@@%%%%%%%%%%%%%@#************************#%###%%@%@@@@@@@@@%@%@%#******#%@@@@@%@@%#****
*********%@@@@@@@@@@@@@@@@@@@%*************************%%%%%@@@@@@@@@@@%%%@@@%#*****%@@@@@@@@@%#****
*********%@@@@@@@@@@@@@@@@@@@%*******************************%@@@@@@@@%%#%%@@%#****%@@@@@@@@@@@%****
*********#@@@@@@@@@@@@@@@@@@@%*****************************#@@@@@@@@@%@%%%@@@%****%@#***@@@***@%****
*********#@@@@@@@@@@@@@@@@@@@%*****************************#@@@@@@%@@@%%%%@@@###*#@%****#%****#@****
*********#@@@@@@@@@@@@@@@@@@@%****************************#%@@@@@@@@@@%%%%@@@@%##@%*****%#****#@****
*********#@@@@@@@@@@@@@@@@@@@@***************************#%@@@@@@@@@@%%%%%@@@@#%#*******%*****#%****
*********#@@@@@@@@@@@@@@@@@@@@**************************%%@@@@%@@@@@@%%%%@@@@%%****************%****
*********#@@@@@@@@@@@@@@@@@@@@*********************##%%@%@@@%*#@@@@%#%%%@@@@@%#***************#%%***
*#**#*****##%%%@@@@@@@@@@@@@@@*************###%%%%@%@@@@@@@##%#%%%%%%%%@@@@@@%##*********###***#%***
##@@@@%%%#####@@@@@%#####%%%%#*###%%*****#@%@%%%%%%%%###%%#%%%%%%%%%%@@@@@@@@#*********%@%##%%##****
#%@@@@@@@%##@@@@@@@@@%%%#%@###%@@@@%%@@@@@@@@@@%@@@@%%%%%%%@%@@@@@@@@@@@@@@@@@@%%#%%%%%@#####@@%##**
%%@@%%@@@@%%@@@@@@@@@@@@@@%%%%%@@@@@@@@@@@@@@@@@@@@@@@@%%%%@@@@@@@@@@@@@@@@@@@@@%%%@%@%%%%%%%%@%####
@@@@@%%%%@%%%%%%%@@@@%@%%%%@%%@%%%%%#%%%%%@@%%@%%%%%%#%%%%%%%%@%%#%%%%%%@@%%@%@@@@@@@%@@@@@@@@@%%%%#
@@@@@@@@@@@@@@@@@@@@@%%%%%#%%%%#%%#%%@%%%#%#####%%###%%%%#%%%##%##@%#%#%%#%%%%@%@%#@@%@@@@%@@%%%%%%%
@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%%%%%%%###%#######%%%###%%####%%####%%######%%#######%%%####%%#
@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%@%%%%@%%%%%%%%%%%%%%%%%%%
                        ___  ____ ____ _    ___  ____ ____ ____ ____ _  _ _ ____
                        |__] |___ |___ |      /  |___ |    |  | |  | |_/  | |___
                        |__] |___ |___ |___  /__ |___ |___ |__| |__| | \_ | |___
    https://0xbthn.com
    https://github.com/0xbthn
    Maker: Batuhan Aydın

    I want to be a cookie.
"""

from setuptools import setup, find_packages
import os

# Read the README file
def read_readme():
    readme_path = os.path.join(os.path.dirname(__file__), 'beelzecookie', 'README.md')
    if os.path.exists(readme_path):
        with open(readme_path, 'r', encoding='utf-8') as f:
            return f.read()
    return "BeelzeCookie - Cookie Bomb Vulnerability Scanner I want to be a cookie."

# Read requirements
def read_requirements():
    requirements_path = os.path.join(os.path.dirname(__file__), 'requirements.txt')
    if os.path.exists(requirements_path):
        with open(requirements_path, 'r') as f:
            return [line.strip() for line in f if line.strip() and not line.startswith('#')]
    return []

setup(
    name="beelzecookie",
    version="1.0.3",
    author="0xbthn",
    description="Cookie Bomb Vulnerability Scanner I want to be a cookie.",
    long_description=read_readme(),
    long_description_content_type="text/markdown",
    packages=find_packages(),
    install_requires=read_requirements(),
    python_requires=">=3.7",
    entry_points={
        'console_scripts': [
            'beelzecookie=beelzecookie.cli:main',
        ],
    },
    classifiers=[
        "Development Status :: 4 - Beta",
        "Intended Audience :: Information Technology",
        "License :: OSI Approved :: MIT License",
        "Operating System :: OS Independent",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.7",
        "Programming Language :: Python :: 3.8",
        "Programming Language :: Python :: 3.9",
        "Programming Language :: Python :: 3.10",
        "Programming Language :: Python :: 3.11",
        "Topic :: Security",
        "Topic :: Internet :: WWW/HTTP",
        "Topic :: Software Development :: Testing",
    ],
    keywords="security vulnerability scanner cookie bomb dos web application testing",
    project_urls={
        "Bug Reports": "https://github.com/0xbthn/beelzecookie/issues",
        "Source": "https://github.com/0xbthn/beelzecookie",
        "Documentation": "https://github.com/0xbthn/beelzecookie#readme",
    },
) 