# MIT License
# Copyright (c) 2025 Scott Woods
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.

"""Asynchronous distributed computing (OSI layer 7, application)

Repo: git@github.com:mr-ansar/kipjak.git
Branch: main
Commit: ceef3f1cb2b855a0f26acb42cdd9e2c5ee39cb6f
Version: 
"""

from .general_purpose import *
from .head_lock import *
from .ip_networking import *
from .command_line import *
from .command_startup import *
from .virtual_memory import *
from .convert_memory import *
from .convert_signature import *
from .convert_type import *
from .message_memory import *
from .make_message import *
from .virtual_codec import *
from .json_codec import *
from .object_logs import *
from .virtual_runtime import *
from .object_runtime import *
from .virtual_point import *
from .point_runtime import *
from .routine_point import *
from .point_machine import *
from .file_object import *
from .folder_object import *
from .object_startup import *
from .object_spool import *
from .process_object import *
from .edit_role import *
from .bind_type import *
from .object_directory import *
from .process_directory import *
from .listen_connect import *
from .get_response import *
from .retry_intervals import *
from .disk_storage import *
from .http import *
