# mypy-boto3-clouddirectory

[![PyPI - mypy-boto3-clouddirectory](https://img.shields.io/pypi/v/mypy-boto3-clouddirectory.svg?color=blue)](https://pypi.org/project/mypy-boto3-clouddirectory)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-clouddirectory.svg?color=blue)](https://pypi.org/project/mypy-boto3-clouddirectory)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.CloudDirectory 1.14.58](https://boto3.amazonaws.com/v1/documentation/api/1.14.58/reference/services/clouddirectory.html#CloudDirectory) service
compatible with
[VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright)
and other tools.

Generated by [mypy-boto3-buider 3.0.4](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

- [mypy-boto3-clouddirectory](#mypy-boto3-clouddirectory)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Service Resource annotations](#service-resource-annotations)
    - [Other resources annotations](#other-resources-annotations)
    - [Collections annotations](#collections-annotations)
    - [Typed dictionations](#typed-dictionations)

## How to install

Install `boto3-stubs` for `CloudDirectory` service.

```bash
python -m pip install boto3-stubs[clouddirectory]
```

## Usage

### VSCode

- Install [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[clouddirectory]` in your environment: `python -m pip install 'boto3-stubs[clouddirectory]'`

Both type checking and auto-complete should work for `CloudDirectory` service.
No explicit type annotations required, write your `boto3` code as usual.

### PyCharm

- Install `boto-stubs[clouddirectory]` in your environment: `python -m pip install 'boto3-stubs[clouddirectory]'`

Both type checking and auto-complete should work for `CloudDirectory` service.
No explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed `boto3-stubs` submodules.

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything should work.

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[clouddirectory]` in your environment: `python -m pip install 'boto3-stubs[clouddirectory]'`
- Run `mypy` as usual

Type checking should work for `CloudDirectory` service.
No explicit type annotations required, write your `boto3` code as usual.

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[clouddirectory]` in your environment: `python -m pip install 'boto3-stubs[clouddirectory]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `CloudDirectory` service.
No explicit type annotations required, write your `boto3` code as usual.

## Explicit type annotations

### Client annotations

`CloudDirectoryClient` provides annotations for `boto3.client("clouddirectory")`.

```python
import boto3

from mypy_boto3_clouddirectory import CloudDirectoryClient

client: CloudDirectoryClient = boto3.client("clouddirectory")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: CloudDirectoryClient = session.client("clouddirectory")
```

### Paginators annotations

`mypy_boto3_clouddirectory.paginator` module contains type annotations for all paginators.

```python
from mypy_boto3_clouddirectory import CloudDirectoryClient
from mypy_boto3_clouddirectory.paginator import (
    ListAppliedSchemaArnsPaginator,
    ListAttachedIndicesPaginator,
    ListDevelopmentSchemaArnsPaginator,
    ListDirectoriesPaginator,
    ListFacetAttributesPaginator,
    ListFacetNamesPaginator,
    ListIncomingTypedLinksPaginator,
    ListIndexPaginator,
    ListManagedSchemaArnsPaginator,
    ListObjectAttributesPaginator,
    ListObjectParentPathsPaginator,
    ListObjectPoliciesPaginator,
    ListOutgoingTypedLinksPaginator,
    ListPolicyAttachmentsPaginator,
    ListPublishedSchemaArnsPaginator,
    ListTagsForResourcePaginator,
    ListTypedLinkFacetAttributesPaginator,
    ListTypedLinkFacetNamesPaginator,
    LookupPolicyPaginator,
)

client: CloudDirectoryClient = boto3.client("clouddirectory")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
list_applied_schema_arns_paginator: ListAppliedSchemaArnsPaginator = client.get_paginator("list_applied_schema_arns")
list_attached_indices_paginator: ListAttachedIndicesPaginator = client.get_paginator("list_attached_indices")
list_development_schema_arns_paginator: ListDevelopmentSchemaArnsPaginator = client.get_paginator("list_development_schema_arns")
list_directories_paginator: ListDirectoriesPaginator = client.get_paginator("list_directories")
list_facet_attributes_paginator: ListFacetAttributesPaginator = client.get_paginator("list_facet_attributes")
list_facet_names_paginator: ListFacetNamesPaginator = client.get_paginator("list_facet_names")
list_incoming_typed_links_paginator: ListIncomingTypedLinksPaginator = client.get_paginator("list_incoming_typed_links")
list_index_paginator: ListIndexPaginator = client.get_paginator("list_index")
list_managed_schema_arns_paginator: ListManagedSchemaArnsPaginator = client.get_paginator("list_managed_schema_arns")
list_object_attributes_paginator: ListObjectAttributesPaginator = client.get_paginator("list_object_attributes")
list_object_parent_paths_paginator: ListObjectParentPathsPaginator = client.get_paginator("list_object_parent_paths")
list_object_policies_paginator: ListObjectPoliciesPaginator = client.get_paginator("list_object_policies")
list_outgoing_typed_links_paginator: ListOutgoingTypedLinksPaginator = client.get_paginator("list_outgoing_typed_links")
list_policy_attachments_paginator: ListPolicyAttachmentsPaginator = client.get_paginator("list_policy_attachments")
list_published_schema_arns_paginator: ListPublishedSchemaArnsPaginator = client.get_paginator("list_published_schema_arns")
list_tags_for_resource_paginator: ListTagsForResourcePaginator = client.get_paginator("list_tags_for_resource")
list_typed_link_facet_attributes_paginator: ListTypedLinkFacetAttributesPaginator = client.get_paginator("list_typed_link_facet_attributes")
list_typed_link_facet_names_paginator: ListTypedLinkFacetNamesPaginator = client.get_paginator("list_typed_link_facet_names")
lookup_policy_paginator: LookupPolicyPaginator = client.get_paginator("lookup_policy")
```







### Typed dictionations

`mypy_boto3_clouddirectory.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_clouddirectory.type_defs import (
    ApplySchemaResponseTypeDef,
    AttachObjectResponseTypeDef,
    AttachToIndexResponseTypeDef,
    AttachTypedLinkResponseTypeDef,
    AttributeKeyAndValueTypeDef,
    AttributeKeyTypeDef,
    AttributeNameAndValueTypeDef,
    BatchAddFacetToObjectTypeDef,
    BatchAttachObjectResponseTypeDef,
    BatchAttachObjectTypeDef,
    BatchAttachPolicyTypeDef,
    BatchAttachToIndexResponseTypeDef,
    BatchAttachToIndexTypeDef,
    BatchAttachTypedLinkResponseTypeDef,
    BatchAttachTypedLinkTypeDef,
    BatchCreateIndexResponseTypeDef,
    BatchCreateIndexTypeDef,
    BatchCreateObjectResponseTypeDef,
    BatchCreateObjectTypeDef,
    BatchDeleteObjectTypeDef,
    BatchDetachFromIndexResponseTypeDef,
    BatchDetachFromIndexTypeDef,
    BatchDetachObjectResponseTypeDef,
    BatchDetachObjectTypeDef,
    BatchDetachPolicyTypeDef,
    BatchDetachTypedLinkTypeDef,
    BatchGetLinkAttributesResponseTypeDef,
    BatchGetLinkAttributesTypeDef,
    BatchGetObjectAttributesResponseTypeDef,
    BatchGetObjectAttributesTypeDef,
    BatchGetObjectInformationResponseTypeDef,
    BatchGetObjectInformationTypeDef,
    BatchListAttachedIndicesResponseTypeDef,
    BatchListAttachedIndicesTypeDef,
    BatchListIncomingTypedLinksResponseTypeDef,
    BatchListIncomingTypedLinksTypeDef,
    BatchListIndexResponseTypeDef,
    BatchListIndexTypeDef,
    BatchListObjectAttributesResponseTypeDef,
    BatchListObjectAttributesTypeDef,
    BatchListObjectChildrenResponseTypeDef,
    BatchListObjectChildrenTypeDef,
    BatchListObjectParentPathsResponseTypeDef,
    BatchListObjectParentPathsTypeDef,
    BatchListObjectParentsResponseTypeDef,
    BatchListObjectParentsTypeDef,
    BatchListObjectPoliciesResponseTypeDef,
    BatchListObjectPoliciesTypeDef,
    BatchListOutgoingTypedLinksResponseTypeDef,
    BatchListOutgoingTypedLinksTypeDef,
    BatchListPolicyAttachmentsResponseTypeDef,
    BatchListPolicyAttachmentsTypeDef,
    BatchLookupPolicyResponseTypeDef,
    BatchLookupPolicyTypeDef,
    BatchReadExceptionTypeDef,
    BatchReadOperationResponseTypeDef,
    BatchReadOperationTypeDef,
    BatchReadResponseTypeDef,
    BatchReadSuccessfulResponseTypeDef,
    BatchRemoveFacetFromObjectTypeDef,
    BatchUpdateLinkAttributesTypeDef,
    BatchUpdateObjectAttributesResponseTypeDef,
    BatchUpdateObjectAttributesTypeDef,
    BatchWriteOperationResponseTypeDef,
    BatchWriteOperationTypeDef,
    BatchWriteResponseTypeDef,
    CreateDirectoryResponseTypeDef,
    CreateIndexResponseTypeDef,
    CreateObjectResponseTypeDef,
    CreateSchemaResponseTypeDef,
    DeleteDirectoryResponseTypeDef,
    DeleteSchemaResponseTypeDef,
    DetachFromIndexResponseTypeDef,
    DetachObjectResponseTypeDef,
    DirectoryTypeDef,
    DisableDirectoryResponseTypeDef,
    EnableDirectoryResponseTypeDef,
    FacetAttributeDefinitionTypeDef,
    FacetAttributeReferenceTypeDef,
    FacetAttributeTypeDef,
    FacetAttributeUpdateTypeDef,
    FacetTypeDef,
    GetAppliedSchemaVersionResponseTypeDef,
    GetDirectoryResponseTypeDef,
    GetFacetResponseTypeDef,
    GetLinkAttributesResponseTypeDef,
    GetObjectAttributesResponseTypeDef,
    GetObjectInformationResponseTypeDef,
    GetSchemaAsJsonResponseTypeDef,
    GetTypedLinkFacetInformationResponseTypeDef,
    IndexAttachmentTypeDef,
    LinkAttributeActionTypeDef,
    LinkAttributeUpdateTypeDef,
    ListAppliedSchemaArnsResponseTypeDef,
    ListAttachedIndicesResponseTypeDef,
    ListDevelopmentSchemaArnsResponseTypeDef,
    ListDirectoriesResponseTypeDef,
    ListFacetAttributesResponseTypeDef,
    ListFacetNamesResponseTypeDef,
    ListIncomingTypedLinksResponseTypeDef,
    ListIndexResponseTypeDef,
    ListManagedSchemaArnsResponseTypeDef,
    ListObjectAttributesResponseTypeDef,
    ListObjectChildrenResponseTypeDef,
    ListObjectParentPathsResponseTypeDef,
    ListObjectParentsResponseTypeDef,
    ListObjectPoliciesResponseTypeDef,
    ListOutgoingTypedLinksResponseTypeDef,
    ListPolicyAttachmentsResponseTypeDef,
    ListPublishedSchemaArnsResponseTypeDef,
    ListTagsForResourceResponseTypeDef,
    ListTypedLinkFacetAttributesResponseTypeDef,
    ListTypedLinkFacetNamesResponseTypeDef,
    LookupPolicyResponseTypeDef,
    ObjectAttributeActionTypeDef,
    ObjectAttributeRangeTypeDef,
    ObjectAttributeUpdateTypeDef,
    ObjectIdentifierAndLinkNameTupleTypeDef,
    ObjectReferenceTypeDef,
    PaginatorConfigTypeDef,
    PathToObjectIdentifiersTypeDef,
    PolicyAttachmentTypeDef,
    PolicyToPathTypeDef,
    PublishSchemaResponseTypeDef,
    PutSchemaFromJsonResponseTypeDef,
    RuleTypeDef,
    SchemaFacetTypeDef,
    TagTypeDef,
    TypedAttributeValueRangeTypeDef,
    TypedAttributeValueTypeDef,
    TypedLinkAttributeDefinitionTypeDef,
    TypedLinkAttributeRangeTypeDef,
    TypedLinkFacetAttributeUpdateTypeDef,
    TypedLinkFacetTypeDef,
    TypedLinkSchemaAndFacetNameTypeDef,
    TypedLinkSpecifierTypeDef,
    UpdateObjectAttributesResponseTypeDef,
    UpdateSchemaResponseTypeDef,
    UpgradeAppliedSchemaResponseTypeDef,
    UpgradePublishedSchemaResponseTypeDef,
)

def get_structure() -> AttributeKeyAndValueTypeDef:
    return {
      ...
    }
```
