# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetSdkResult',
    'AwaitableGetSdkResult',
    'get_sdk',
    'get_sdk_output',
]

@pulumi.output_type
class GetSdkResult:
    """
    A collection of values returned by getSdk.
    """
    def __init__(__self__, body=None, content_disposition=None, content_type=None, id=None, parameters=None, rest_api_id=None, sdk_type=None, stage_name=None):
        if body and not isinstance(body, str):
            raise TypeError("Expected argument 'body' to be a str")
        pulumi.set(__self__, "body", body)
        if content_disposition and not isinstance(content_disposition, str):
            raise TypeError("Expected argument 'content_disposition' to be a str")
        pulumi.set(__self__, "content_disposition", content_disposition)
        if content_type and not isinstance(content_type, str):
            raise TypeError("Expected argument 'content_type' to be a str")
        pulumi.set(__self__, "content_type", content_type)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if parameters and not isinstance(parameters, dict):
            raise TypeError("Expected argument 'parameters' to be a dict")
        pulumi.set(__self__, "parameters", parameters)
        if rest_api_id and not isinstance(rest_api_id, str):
            raise TypeError("Expected argument 'rest_api_id' to be a str")
        pulumi.set(__self__, "rest_api_id", rest_api_id)
        if sdk_type and not isinstance(sdk_type, str):
            raise TypeError("Expected argument 'sdk_type' to be a str")
        pulumi.set(__self__, "sdk_type", sdk_type)
        if stage_name and not isinstance(stage_name, str):
            raise TypeError("Expected argument 'stage_name' to be a str")
        pulumi.set(__self__, "stage_name", stage_name)

    @property
    @pulumi.getter
    def body(self) -> str:
        """
        SDK as a string.
        """
        return pulumi.get(self, "body")

    @property
    @pulumi.getter(name="contentDisposition")
    def content_disposition(self) -> str:
        """
        Content-disposition header value in the HTTP response.
        """
        return pulumi.get(self, "content_disposition")

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> str:
        """
        Content-type header value in the HTTP response.
        """
        return pulumi.get(self, "content_type")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, str]]:
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter(name="restApiId")
    def rest_api_id(self) -> str:
        return pulumi.get(self, "rest_api_id")

    @property
    @pulumi.getter(name="sdkType")
    def sdk_type(self) -> str:
        return pulumi.get(self, "sdk_type")

    @property
    @pulumi.getter(name="stageName")
    def stage_name(self) -> str:
        return pulumi.get(self, "stage_name")


class AwaitableGetSdkResult(GetSdkResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSdkResult(
            body=self.body,
            content_disposition=self.content_disposition,
            content_type=self.content_type,
            id=self.id,
            parameters=self.parameters,
            rest_api_id=self.rest_api_id,
            sdk_type=self.sdk_type,
            stage_name=self.stage_name)


def get_sdk(parameters: Optional[Mapping[str, str]] = None,
            rest_api_id: Optional[str] = None,
            sdk_type: Optional[str] = None,
            stage_name: Optional[str] = None,
            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSdkResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.apigateway.get_sdk(rest_api_id=aws_api_gateway_stage["example"]["rest_api_id"],
        stage_name=aws_api_gateway_stage["example"]["stage_name"],
        sdk_type="android",
        parameters={
            "groupId": "example",
            "artifactId": "example",
            "artifactVersion": "example",
            "invokerPackage": "example",
        })
    ```


    :param Mapping[str, str] parameters: Key-value map of query string parameters `sdk_type` properties of the SDK. For SDK Type of `objectivec` or `swift`, a parameter named `classPrefix` is required. For SDK Type of `android`, parameters named `groupId`, `artifactId`, `artifactVersion`, and `invokerPackage` are required. For SDK Type of `java`, parameters named `serviceName` and `javaPackageName` are required.
    :param str rest_api_id: Identifier of the associated REST API.
    :param str sdk_type: Language for the generated SDK. Currently `java`, `javascript`, `android`, `objectivec` (for iOS), `swift` (for iOS), and `ruby` are supported.
    :param str stage_name: Name of the Stage that will be exported.
    """
    __args__ = dict()
    __args__['parameters'] = parameters
    __args__['restApiId'] = rest_api_id
    __args__['sdkType'] = sdk_type
    __args__['stageName'] = stage_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:apigateway/getSdk:getSdk', __args__, opts=opts, typ=GetSdkResult).value

    return AwaitableGetSdkResult(
        body=pulumi.get(__ret__, 'body'),
        content_disposition=pulumi.get(__ret__, 'content_disposition'),
        content_type=pulumi.get(__ret__, 'content_type'),
        id=pulumi.get(__ret__, 'id'),
        parameters=pulumi.get(__ret__, 'parameters'),
        rest_api_id=pulumi.get(__ret__, 'rest_api_id'),
        sdk_type=pulumi.get(__ret__, 'sdk_type'),
        stage_name=pulumi.get(__ret__, 'stage_name'))


@_utilities.lift_output_func(get_sdk)
def get_sdk_output(parameters: Optional[pulumi.Input[Optional[Mapping[str, str]]]] = None,
                   rest_api_id: Optional[pulumi.Input[str]] = None,
                   sdk_type: Optional[pulumi.Input[str]] = None,
                   stage_name: Optional[pulumi.Input[str]] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetSdkResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.apigateway.get_sdk(rest_api_id=aws_api_gateway_stage["example"]["rest_api_id"],
        stage_name=aws_api_gateway_stage["example"]["stage_name"],
        sdk_type="android",
        parameters={
            "groupId": "example",
            "artifactId": "example",
            "artifactVersion": "example",
            "invokerPackage": "example",
        })
    ```


    :param Mapping[str, str] parameters: Key-value map of query string parameters `sdk_type` properties of the SDK. For SDK Type of `objectivec` or `swift`, a parameter named `classPrefix` is required. For SDK Type of `android`, parameters named `groupId`, `artifactId`, `artifactVersion`, and `invokerPackage` are required. For SDK Type of `java`, parameters named `serviceName` and `javaPackageName` are required.
    :param str rest_api_id: Identifier of the associated REST API.
    :param str sdk_type: Language for the generated SDK. Currently `java`, `javascript`, `android`, `objectivec` (for iOS), `swift` (for iOS), and `ruby` are supported.
    :param str stage_name: Name of the Stage that will be exported.
    """
    ...
