# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'DirectoryConfigServiceAccountCredentials',
    'FleetComputeCapacity',
    'FleetDomainJoinInfo',
    'FleetVpcConfig',
    'ImageBuilderAccessEndpoint',
    'ImageBuilderDomainJoinInfo',
    'ImageBuilderVpcConfig',
    'StackAccessEndpoint',
    'StackApplicationSettings',
    'StackStorageConnector',
    'StackStreamingExperienceSettings',
    'StackUserSetting',
]

@pulumi.output_type
class DirectoryConfigServiceAccountCredentials(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accountName":
            suggest = "account_name"
        elif key == "accountPassword":
            suggest = "account_password"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DirectoryConfigServiceAccountCredentials. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DirectoryConfigServiceAccountCredentials.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DirectoryConfigServiceAccountCredentials.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 account_name: str,
                 account_password: str):
        """
        :param str account_name: User name of the account. This account must have the following privileges: create computer objects, join computers to the domain, and change/reset the password on descendant computer objects for the organizational units specified.
        :param str account_password: Password for the account.
        """
        pulumi.set(__self__, "account_name", account_name)
        pulumi.set(__self__, "account_password", account_password)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> str:
        """
        User name of the account. This account must have the following privileges: create computer objects, join computers to the domain, and change/reset the password on descendant computer objects for the organizational units specified.
        """
        return pulumi.get(self, "account_name")

    @property
    @pulumi.getter(name="accountPassword")
    def account_password(self) -> str:
        """
        Password for the account.
        """
        return pulumi.get(self, "account_password")


@pulumi.output_type
class FleetComputeCapacity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "desiredInstances":
            suggest = "desired_instances"
        elif key == "inUse":
            suggest = "in_use"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FleetComputeCapacity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FleetComputeCapacity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FleetComputeCapacity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 desired_instances: int,
                 available: Optional[int] = None,
                 in_use: Optional[int] = None,
                 running: Optional[int] = None):
        """
        :param int desired_instances: Desired number of streaming instances.
        :param int available: Number of currently available instances that can be used to stream sessions.
        :param int in_use: Number of instances in use for streaming.
        :param int running: Total number of simultaneous streaming instances that are running.
        """
        pulumi.set(__self__, "desired_instances", desired_instances)
        if available is not None:
            pulumi.set(__self__, "available", available)
        if in_use is not None:
            pulumi.set(__self__, "in_use", in_use)
        if running is not None:
            pulumi.set(__self__, "running", running)

    @property
    @pulumi.getter(name="desiredInstances")
    def desired_instances(self) -> int:
        """
        Desired number of streaming instances.
        """
        return pulumi.get(self, "desired_instances")

    @property
    @pulumi.getter
    def available(self) -> Optional[int]:
        """
        Number of currently available instances that can be used to stream sessions.
        """
        return pulumi.get(self, "available")

    @property
    @pulumi.getter(name="inUse")
    def in_use(self) -> Optional[int]:
        """
        Number of instances in use for streaming.
        """
        return pulumi.get(self, "in_use")

    @property
    @pulumi.getter
    def running(self) -> Optional[int]:
        """
        Total number of simultaneous streaming instances that are running.
        """
        return pulumi.get(self, "running")


@pulumi.output_type
class FleetDomainJoinInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "directoryName":
            suggest = "directory_name"
        elif key == "organizationalUnitDistinguishedName":
            suggest = "organizational_unit_distinguished_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FleetDomainJoinInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FleetDomainJoinInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FleetDomainJoinInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 directory_name: Optional[str] = None,
                 organizational_unit_distinguished_name: Optional[str] = None):
        """
        :param str directory_name: Fully qualified name of the directory (for example, corp.example.com).
        :param str organizational_unit_distinguished_name: Distinguished name of the organizational unit for computer accounts.
        """
        if directory_name is not None:
            pulumi.set(__self__, "directory_name", directory_name)
        if organizational_unit_distinguished_name is not None:
            pulumi.set(__self__, "organizational_unit_distinguished_name", organizational_unit_distinguished_name)

    @property
    @pulumi.getter(name="directoryName")
    def directory_name(self) -> Optional[str]:
        """
        Fully qualified name of the directory (for example, corp.example.com).
        """
        return pulumi.get(self, "directory_name")

    @property
    @pulumi.getter(name="organizationalUnitDistinguishedName")
    def organizational_unit_distinguished_name(self) -> Optional[str]:
        """
        Distinguished name of the organizational unit for computer accounts.
        """
        return pulumi.get(self, "organizational_unit_distinguished_name")


@pulumi.output_type
class FleetVpcConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "securityGroupIds":
            suggest = "security_group_ids"
        elif key == "subnetIds":
            suggest = "subnet_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FleetVpcConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FleetVpcConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FleetVpcConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 security_group_ids: Optional[Sequence[str]] = None,
                 subnet_ids: Optional[Sequence[str]] = None):
        """
        :param Sequence[str] security_group_ids: Identifiers of the security groups for the fleet or image builder.
        :param Sequence[str] subnet_ids: Identifiers of the subnets to which a network interface is attached from the fleet instance or image builder instance.
        """
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if subnet_ids is not None:
            pulumi.set(__self__, "subnet_ids", subnet_ids)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[Sequence[str]]:
        """
        Identifiers of the security groups for the fleet or image builder.
        """
        return pulumi.get(self, "security_group_ids")

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Optional[Sequence[str]]:
        """
        Identifiers of the subnets to which a network interface is attached from the fleet instance or image builder instance.
        """
        return pulumi.get(self, "subnet_ids")


@pulumi.output_type
class ImageBuilderAccessEndpoint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endpointType":
            suggest = "endpoint_type"
        elif key == "vpceId":
            suggest = "vpce_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ImageBuilderAccessEndpoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ImageBuilderAccessEndpoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ImageBuilderAccessEndpoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint_type: str,
                 vpce_id: Optional[str] = None):
        """
        :param str endpoint_type: Type of interface endpoint.
        :param str vpce_id: Identifier (ID) of the VPC in which the interface endpoint is used.
        """
        pulumi.set(__self__, "endpoint_type", endpoint_type)
        if vpce_id is not None:
            pulumi.set(__self__, "vpce_id", vpce_id)

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> str:
        """
        Type of interface endpoint.
        """
        return pulumi.get(self, "endpoint_type")

    @property
    @pulumi.getter(name="vpceId")
    def vpce_id(self) -> Optional[str]:
        """
        Identifier (ID) of the VPC in which the interface endpoint is used.
        """
        return pulumi.get(self, "vpce_id")


@pulumi.output_type
class ImageBuilderDomainJoinInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "directoryName":
            suggest = "directory_name"
        elif key == "organizationalUnitDistinguishedName":
            suggest = "organizational_unit_distinguished_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ImageBuilderDomainJoinInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ImageBuilderDomainJoinInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ImageBuilderDomainJoinInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 directory_name: Optional[str] = None,
                 organizational_unit_distinguished_name: Optional[str] = None):
        """
        :param str directory_name: Fully qualified name of the directory (for example, corp.example.com).
        :param str organizational_unit_distinguished_name: Distinguished name of the organizational unit for computer accounts.
        """
        if directory_name is not None:
            pulumi.set(__self__, "directory_name", directory_name)
        if organizational_unit_distinguished_name is not None:
            pulumi.set(__self__, "organizational_unit_distinguished_name", organizational_unit_distinguished_name)

    @property
    @pulumi.getter(name="directoryName")
    def directory_name(self) -> Optional[str]:
        """
        Fully qualified name of the directory (for example, corp.example.com).
        """
        return pulumi.get(self, "directory_name")

    @property
    @pulumi.getter(name="organizationalUnitDistinguishedName")
    def organizational_unit_distinguished_name(self) -> Optional[str]:
        """
        Distinguished name of the organizational unit for computer accounts.
        """
        return pulumi.get(self, "organizational_unit_distinguished_name")


@pulumi.output_type
class ImageBuilderVpcConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "securityGroupIds":
            suggest = "security_group_ids"
        elif key == "subnetIds":
            suggest = "subnet_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ImageBuilderVpcConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ImageBuilderVpcConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ImageBuilderVpcConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 security_group_ids: Optional[Sequence[str]] = None,
                 subnet_ids: Optional[Sequence[str]] = None):
        """
        :param Sequence[str] security_group_ids: Identifiers of the security groups for the image builder or image builder.
        :param Sequence[str] subnet_ids: Identifiers of the subnets to which a network interface is attached from the image builder instance or image builder instance.
        """
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if subnet_ids is not None:
            pulumi.set(__self__, "subnet_ids", subnet_ids)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[Sequence[str]]:
        """
        Identifiers of the security groups for the image builder or image builder.
        """
        return pulumi.get(self, "security_group_ids")

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Optional[Sequence[str]]:
        """
        Identifiers of the subnets to which a network interface is attached from the image builder instance or image builder instance.
        """
        return pulumi.get(self, "subnet_ids")


@pulumi.output_type
class StackAccessEndpoint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endpointType":
            suggest = "endpoint_type"
        elif key == "vpceId":
            suggest = "vpce_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StackAccessEndpoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StackAccessEndpoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StackAccessEndpoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint_type: str,
                 vpce_id: Optional[str] = None):
        """
        :param str endpoint_type: Type of the interface endpoint.
               See the [`AccessEndpoint` AWS API documentation](https://docs.aws.amazon.com/appstream2/latest/APIReference/API_AccessEndpoint.html) for valid values.
        :param str vpce_id: ID of the VPC in which the interface endpoint is used.
        """
        pulumi.set(__self__, "endpoint_type", endpoint_type)
        if vpce_id is not None:
            pulumi.set(__self__, "vpce_id", vpce_id)

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> str:
        """
        Type of the interface endpoint.
        See the [`AccessEndpoint` AWS API documentation](https://docs.aws.amazon.com/appstream2/latest/APIReference/API_AccessEndpoint.html) for valid values.
        """
        return pulumi.get(self, "endpoint_type")

    @property
    @pulumi.getter(name="vpceId")
    def vpce_id(self) -> Optional[str]:
        """
        ID of the VPC in which the interface endpoint is used.
        """
        return pulumi.get(self, "vpce_id")


@pulumi.output_type
class StackApplicationSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "settingsGroup":
            suggest = "settings_group"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StackApplicationSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StackApplicationSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StackApplicationSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: bool,
                 settings_group: Optional[str] = None):
        """
        :param bool enabled: Whether application settings should be persisted.
        :param str settings_group: Name of the settings group.
               Required when `enabled` is `true`.
               Can be up to 100 characters.
        """
        pulumi.set(__self__, "enabled", enabled)
        if settings_group is not None:
            pulumi.set(__self__, "settings_group", settings_group)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Whether application settings should be persisted.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="settingsGroup")
    def settings_group(self) -> Optional[str]:
        """
        Name of the settings group.
        Required when `enabled` is `true`.
        Can be up to 100 characters.
        """
        return pulumi.get(self, "settings_group")


@pulumi.output_type
class StackStorageConnector(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectorType":
            suggest = "connector_type"
        elif key == "resourceIdentifier":
            suggest = "resource_identifier"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StackStorageConnector. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StackStorageConnector.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StackStorageConnector.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connector_type: str,
                 domains: Optional[Sequence[str]] = None,
                 resource_identifier: Optional[str] = None):
        """
        :param str connector_type: Type of storage connector.
               Valid values are `HOMEFOLDERS`, `GOOGLE_DRIVE`, or `ONE_DRIVE`.
        :param Sequence[str] domains: Names of the domains for the account.
        :param str resource_identifier: ARN of the storage connector.
        """
        pulumi.set(__self__, "connector_type", connector_type)
        if domains is not None:
            pulumi.set(__self__, "domains", domains)
        if resource_identifier is not None:
            pulumi.set(__self__, "resource_identifier", resource_identifier)

    @property
    @pulumi.getter(name="connectorType")
    def connector_type(self) -> str:
        """
        Type of storage connector.
        Valid values are `HOMEFOLDERS`, `GOOGLE_DRIVE`, or `ONE_DRIVE`.
        """
        return pulumi.get(self, "connector_type")

    @property
    @pulumi.getter
    def domains(self) -> Optional[Sequence[str]]:
        """
        Names of the domains for the account.
        """
        return pulumi.get(self, "domains")

    @property
    @pulumi.getter(name="resourceIdentifier")
    def resource_identifier(self) -> Optional[str]:
        """
        ARN of the storage connector.
        """
        return pulumi.get(self, "resource_identifier")


@pulumi.output_type
class StackStreamingExperienceSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "preferredProtocol":
            suggest = "preferred_protocol"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StackStreamingExperienceSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StackStreamingExperienceSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StackStreamingExperienceSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 preferred_protocol: Optional[str] = None):
        """
        :param str preferred_protocol: The preferred protocol that you want to use while streaming your application.
               Valid values are `TCP` and `UDP`.
        """
        if preferred_protocol is not None:
            pulumi.set(__self__, "preferred_protocol", preferred_protocol)

    @property
    @pulumi.getter(name="preferredProtocol")
    def preferred_protocol(self) -> Optional[str]:
        """
        The preferred protocol that you want to use while streaming your application.
        Valid values are `TCP` and `UDP`.
        """
        return pulumi.get(self, "preferred_protocol")


@pulumi.output_type
class StackUserSetting(dict):
    def __init__(__self__, *,
                 action: str,
                 permission: str):
        """
        :param str action: Action that is enabled or disabled.
               Valid values are `CLIPBOARD_COPY_FROM_LOCAL_DEVICE`,  `CLIPBOARD_COPY_TO_LOCAL_DEVICE`, `FILE_UPLOAD`, `FILE_DOWNLOAD`, `PRINTING_TO_LOCAL_DEVICE`, `DOMAIN_PASSWORD_SIGNIN`, or `DOMAIN_SMART_CARD_SIGNIN`.
        :param str permission: Whether the action is enabled or disabled.
               Valid values are `ENABLED` or `DISABLED`.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "permission", permission)

    @property
    @pulumi.getter
    def action(self) -> str:
        """
        Action that is enabled or disabled.
        Valid values are `CLIPBOARD_COPY_FROM_LOCAL_DEVICE`,  `CLIPBOARD_COPY_TO_LOCAL_DEVICE`, `FILE_UPLOAD`, `FILE_DOWNLOAD`, `PRINTING_TO_LOCAL_DEVICE`, `DOMAIN_PASSWORD_SIGNIN`, or `DOMAIN_SMART_CARD_SIGNIN`.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def permission(self) -> str:
        """
        Whether the action is enabled or disabled.
        Valid values are `ENABLED` or `DISABLED`.
        """
        return pulumi.get(self, "permission")


