# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'AssessmentAssessmentReportsDestination',
    'AssessmentRole',
    'AssessmentRolesAll',
    'AssessmentScope',
    'AssessmentScopeAwsAccount',
    'AssessmentScopeAwsService',
    'ControlControlMappingSource',
    'ControlControlMappingSourceSourceKeyword',
    'FrameworkControlSet',
    'FrameworkControlSetControl',
    'GetControlControlMappingSourceResult',
    'GetControlControlMappingSourceSourceKeywordResult',
    'GetFrameworkControlSetResult',
    'GetFrameworkControlSetControlResult',
]

@pulumi.output_type
class AssessmentAssessmentReportsDestination(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "destinationType":
            suggest = "destination_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AssessmentAssessmentReportsDestination. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AssessmentAssessmentReportsDestination.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AssessmentAssessmentReportsDestination.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 destination: str,
                 destination_type: str):
        """
        :param str destination: Destination of the assessment report. This value be in the form `s3://{bucket_name}`.
        :param str destination_type: Destination type. Currently, `S3` is the only valid value.
        """
        pulumi.set(__self__, "destination", destination)
        pulumi.set(__self__, "destination_type", destination_type)

    @property
    @pulumi.getter
    def destination(self) -> str:
        """
        Destination of the assessment report. This value be in the form `s3://{bucket_name}`.
        """
        return pulumi.get(self, "destination")

    @property
    @pulumi.getter(name="destinationType")
    def destination_type(self) -> str:
        """
        Destination type. Currently, `S3` is the only valid value.
        """
        return pulumi.get(self, "destination_type")


@pulumi.output_type
class AssessmentRole(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "roleArn":
            suggest = "role_arn"
        elif key == "roleType":
            suggest = "role_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AssessmentRole. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AssessmentRole.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AssessmentRole.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 role_arn: str,
                 role_type: str):
        """
        :param str role_arn: Amazon Resource Name (ARN) of the IAM role.
        :param str role_type: Type of customer persona. For assessment creation, type must always be `PROCESS_OWNER`.
        """
        pulumi.set(__self__, "role_arn", role_arn)
        pulumi.set(__self__, "role_type", role_type)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> str:
        """
        Amazon Resource Name (ARN) of the IAM role.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="roleType")
    def role_type(self) -> str:
        """
        Type of customer persona. For assessment creation, type must always be `PROCESS_OWNER`.
        """
        return pulumi.get(self, "role_type")


@pulumi.output_type
class AssessmentRolesAll(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "roleArn":
            suggest = "role_arn"
        elif key == "roleType":
            suggest = "role_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AssessmentRolesAll. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AssessmentRolesAll.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AssessmentRolesAll.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 role_arn: str,
                 role_type: str):
        """
        :param str role_arn: Amazon Resource Name (ARN) of the IAM role.
        :param str role_type: Type of customer persona. For assessment creation, type must always be `PROCESS_OWNER`.
        """
        pulumi.set(__self__, "role_arn", role_arn)
        pulumi.set(__self__, "role_type", role_type)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> str:
        """
        Amazon Resource Name (ARN) of the IAM role.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="roleType")
    def role_type(self) -> str:
        """
        Type of customer persona. For assessment creation, type must always be `PROCESS_OWNER`.
        """
        return pulumi.get(self, "role_type")


@pulumi.output_type
class AssessmentScope(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "awsAccounts":
            suggest = "aws_accounts"
        elif key == "awsServices":
            suggest = "aws_services"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AssessmentScope. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AssessmentScope.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AssessmentScope.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 aws_accounts: Optional[Sequence['outputs.AssessmentScopeAwsAccount']] = None,
                 aws_services: Optional[Sequence['outputs.AssessmentScopeAwsService']] = None):
        """
        :param Sequence['AssessmentScopeAwsAccountArgs'] aws_accounts: Amazon Web Services accounts that are in scope for the assessment. See `aws_accounts` below.
        :param Sequence['AssessmentScopeAwsServiceArgs'] aws_services: Amazon Web Services services that are included in the scope of the assessment. See `aws_services` below.
        """
        if aws_accounts is not None:
            pulumi.set(__self__, "aws_accounts", aws_accounts)
        if aws_services is not None:
            pulumi.set(__self__, "aws_services", aws_services)

    @property
    @pulumi.getter(name="awsAccounts")
    def aws_accounts(self) -> Optional[Sequence['outputs.AssessmentScopeAwsAccount']]:
        """
        Amazon Web Services accounts that are in scope for the assessment. See `aws_accounts` below.
        """
        return pulumi.get(self, "aws_accounts")

    @property
    @pulumi.getter(name="awsServices")
    def aws_services(self) -> Optional[Sequence['outputs.AssessmentScopeAwsService']]:
        """
        Amazon Web Services services that are included in the scope of the assessment. See `aws_services` below.
        """
        return pulumi.get(self, "aws_services")


@pulumi.output_type
class AssessmentScopeAwsAccount(dict):
    def __init__(__self__, *,
                 id: str):
        """
        :param str id: Identifier for the Amazon Web Services account.
        """
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Identifier for the Amazon Web Services account.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class AssessmentScopeAwsService(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serviceName":
            suggest = "service_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AssessmentScopeAwsService. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AssessmentScopeAwsService.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AssessmentScopeAwsService.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 service_name: str):
        """
        :param str service_name: Name of the Amazon Web Service.
        """
        pulumi.set(__self__, "service_name", service_name)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> str:
        """
        Name of the Amazon Web Service.
        """
        return pulumi.get(self, "service_name")


@pulumi.output_type
class ControlControlMappingSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceName":
            suggest = "source_name"
        elif key == "sourceSetUpOption":
            suggest = "source_set_up_option"
        elif key == "sourceType":
            suggest = "source_type"
        elif key == "sourceDescription":
            suggest = "source_description"
        elif key == "sourceFrequency":
            suggest = "source_frequency"
        elif key == "sourceId":
            suggest = "source_id"
        elif key == "sourceKeyword":
            suggest = "source_keyword"
        elif key == "troubleshootingText":
            suggest = "troubleshooting_text"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ControlControlMappingSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ControlControlMappingSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ControlControlMappingSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_name: str,
                 source_set_up_option: str,
                 source_type: str,
                 source_description: Optional[str] = None,
                 source_frequency: Optional[str] = None,
                 source_id: Optional[str] = None,
                 source_keyword: Optional['outputs.ControlControlMappingSourceSourceKeyword'] = None,
                 troubleshooting_text: Optional[str] = None):
        """
        :param str source_name: Name of the source.
        :param str source_set_up_option: The setup option for the data source. This option reflects if the evidence collection is automated or manual. Valid values are `System_Controls_Mapping` (automated) and `Procedural_Controls_Mapping` (manual).
        :param str source_type: Type of data source for evidence collection. If `source_set_up_option` is manual, the only valid value is `MANUAL`. If `source_set_up_option` is automated, valid values are `AWS_Cloudtrail`, `AWS_Config`, `AWS_Security_Hub`, or `AWS_API_Call`.
               
               The following arguments are optional:
        :param str source_description: Description of the source.
        :param str source_frequency: Frequency of evidence collection. Valid values are `DAILY`, `WEEKLY`, or `MONTHLY`.
        :param 'ControlControlMappingSourceSourceKeywordArgs' source_keyword: The keyword to search for in CloudTrail logs, Config rules, Security Hub checks, and Amazon Web Services API names. See `source_keyword` below.
        :param str troubleshooting_text: Instructions for troubleshooting the control.
        """
        pulumi.set(__self__, "source_name", source_name)
        pulumi.set(__self__, "source_set_up_option", source_set_up_option)
        pulumi.set(__self__, "source_type", source_type)
        if source_description is not None:
            pulumi.set(__self__, "source_description", source_description)
        if source_frequency is not None:
            pulumi.set(__self__, "source_frequency", source_frequency)
        if source_id is not None:
            pulumi.set(__self__, "source_id", source_id)
        if source_keyword is not None:
            pulumi.set(__self__, "source_keyword", source_keyword)
        if troubleshooting_text is not None:
            pulumi.set(__self__, "troubleshooting_text", troubleshooting_text)

    @property
    @pulumi.getter(name="sourceName")
    def source_name(self) -> str:
        """
        Name of the source.
        """
        return pulumi.get(self, "source_name")

    @property
    @pulumi.getter(name="sourceSetUpOption")
    def source_set_up_option(self) -> str:
        """
        The setup option for the data source. This option reflects if the evidence collection is automated or manual. Valid values are `System_Controls_Mapping` (automated) and `Procedural_Controls_Mapping` (manual).
        """
        return pulumi.get(self, "source_set_up_option")

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> str:
        """
        Type of data source for evidence collection. If `source_set_up_option` is manual, the only valid value is `MANUAL`. If `source_set_up_option` is automated, valid values are `AWS_Cloudtrail`, `AWS_Config`, `AWS_Security_Hub`, or `AWS_API_Call`.

        The following arguments are optional:
        """
        return pulumi.get(self, "source_type")

    @property
    @pulumi.getter(name="sourceDescription")
    def source_description(self) -> Optional[str]:
        """
        Description of the source.
        """
        return pulumi.get(self, "source_description")

    @property
    @pulumi.getter(name="sourceFrequency")
    def source_frequency(self) -> Optional[str]:
        """
        Frequency of evidence collection. Valid values are `DAILY`, `WEEKLY`, or `MONTHLY`.
        """
        return pulumi.get(self, "source_frequency")

    @property
    @pulumi.getter(name="sourceId")
    def source_id(self) -> Optional[str]:
        return pulumi.get(self, "source_id")

    @property
    @pulumi.getter(name="sourceKeyword")
    def source_keyword(self) -> Optional['outputs.ControlControlMappingSourceSourceKeyword']:
        """
        The keyword to search for in CloudTrail logs, Config rules, Security Hub checks, and Amazon Web Services API names. See `source_keyword` below.
        """
        return pulumi.get(self, "source_keyword")

    @property
    @pulumi.getter(name="troubleshootingText")
    def troubleshooting_text(self) -> Optional[str]:
        """
        Instructions for troubleshooting the control.
        """
        return pulumi.get(self, "troubleshooting_text")


@pulumi.output_type
class ControlControlMappingSourceSourceKeyword(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keywordInputType":
            suggest = "keyword_input_type"
        elif key == "keywordValue":
            suggest = "keyword_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ControlControlMappingSourceSourceKeyword. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ControlControlMappingSourceSourceKeyword.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ControlControlMappingSourceSourceKeyword.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 keyword_input_type: str,
                 keyword_value: str):
        """
        :param str keyword_input_type: Input method for the keyword. Valid values are `SELECT_FROM_LIST`.
        :param str keyword_value: The value of the keyword that's used when mapping a control data source. For example, this can be a CloudTrail event name, a rule name for Config, a Security Hub control, or the name of an Amazon Web Services API call. See the [Audit Manager supported control data sources documentation](https://docs.aws.amazon.com/audit-manager/latest/userguide/control-data-sources.html) for more information.
        """
        pulumi.set(__self__, "keyword_input_type", keyword_input_type)
        pulumi.set(__self__, "keyword_value", keyword_value)

    @property
    @pulumi.getter(name="keywordInputType")
    def keyword_input_type(self) -> str:
        """
        Input method for the keyword. Valid values are `SELECT_FROM_LIST`.
        """
        return pulumi.get(self, "keyword_input_type")

    @property
    @pulumi.getter(name="keywordValue")
    def keyword_value(self) -> str:
        """
        The value of the keyword that's used when mapping a control data source. For example, this can be a CloudTrail event name, a rule name for Config, a Security Hub control, or the name of an Amazon Web Services API call. See the [Audit Manager supported control data sources documentation](https://docs.aws.amazon.com/audit-manager/latest/userguide/control-data-sources.html) for more information.
        """
        return pulumi.get(self, "keyword_value")


@pulumi.output_type
class FrameworkControlSet(dict):
    def __init__(__self__, *,
                 name: str,
                 controls: Optional[Sequence['outputs.FrameworkControlSetControl']] = None,
                 id: Optional[str] = None):
        """
        :param str name: Name of the control set.
        :param Sequence['FrameworkControlSetControlArgs'] controls: List of controls within the control set. See `controls` below.
        :param str id: Unique identifier of the control.
        """
        pulumi.set(__self__, "name", name)
        if controls is not None:
            pulumi.set(__self__, "controls", controls)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the control set.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def controls(self) -> Optional[Sequence['outputs.FrameworkControlSetControl']]:
        """
        List of controls within the control set. See `controls` below.
        """
        return pulumi.get(self, "controls")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Unique identifier of the control.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class FrameworkControlSetControl(dict):
    def __init__(__self__, *,
                 id: str):
        """
        :param str id: Unique identifier of the control.
        """
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Unique identifier of the control.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class GetControlControlMappingSourceResult(dict):
    def __init__(__self__, *,
                 source_description: str,
                 source_frequency: str,
                 source_id: str,
                 source_name: str,
                 source_set_up_option: str,
                 source_type: str,
                 troubleshooting_text: str,
                 source_keyword: Optional['outputs.GetControlControlMappingSourceSourceKeywordResult'] = None):
        pulumi.set(__self__, "source_description", source_description)
        pulumi.set(__self__, "source_frequency", source_frequency)
        pulumi.set(__self__, "source_id", source_id)
        pulumi.set(__self__, "source_name", source_name)
        pulumi.set(__self__, "source_set_up_option", source_set_up_option)
        pulumi.set(__self__, "source_type", source_type)
        pulumi.set(__self__, "troubleshooting_text", troubleshooting_text)
        if source_keyword is not None:
            pulumi.set(__self__, "source_keyword", source_keyword)

    @property
    @pulumi.getter(name="sourceDescription")
    def source_description(self) -> str:
        return pulumi.get(self, "source_description")

    @property
    @pulumi.getter(name="sourceFrequency")
    def source_frequency(self) -> str:
        return pulumi.get(self, "source_frequency")

    @property
    @pulumi.getter(name="sourceId")
    def source_id(self) -> str:
        return pulumi.get(self, "source_id")

    @property
    @pulumi.getter(name="sourceName")
    def source_name(self) -> str:
        return pulumi.get(self, "source_name")

    @property
    @pulumi.getter(name="sourceSetUpOption")
    def source_set_up_option(self) -> str:
        return pulumi.get(self, "source_set_up_option")

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> str:
        return pulumi.get(self, "source_type")

    @property
    @pulumi.getter(name="troubleshootingText")
    def troubleshooting_text(self) -> str:
        return pulumi.get(self, "troubleshooting_text")

    @property
    @pulumi.getter(name="sourceKeyword")
    def source_keyword(self) -> Optional['outputs.GetControlControlMappingSourceSourceKeywordResult']:
        return pulumi.get(self, "source_keyword")


@pulumi.output_type
class GetControlControlMappingSourceSourceKeywordResult(dict):
    def __init__(__self__, *,
                 keyword_input_type: str,
                 keyword_value: str):
        pulumi.set(__self__, "keyword_input_type", keyword_input_type)
        pulumi.set(__self__, "keyword_value", keyword_value)

    @property
    @pulumi.getter(name="keywordInputType")
    def keyword_input_type(self) -> str:
        return pulumi.get(self, "keyword_input_type")

    @property
    @pulumi.getter(name="keywordValue")
    def keyword_value(self) -> str:
        return pulumi.get(self, "keyword_value")


@pulumi.output_type
class GetFrameworkControlSetResult(dict):
    def __init__(__self__, *,
                 id: str,
                 name: str,
                 controls: Optional[Sequence['outputs.GetFrameworkControlSetControlResult']] = None):
        """
        :param str name: Name of the framework.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        if controls is not None:
            pulumi.set(__self__, "controls", controls)

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the framework.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def controls(self) -> Optional[Sequence['outputs.GetFrameworkControlSetControlResult']]:
        return pulumi.get(self, "controls")


@pulumi.output_type
class GetFrameworkControlSetControlResult(dict):
    def __init__(__self__, *,
                 id: str):
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")


