# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['JobQueueArgs', 'JobQueue']

@pulumi.input_type
class JobQueueArgs:
    def __init__(__self__, *,
                 compute_environments: pulumi.Input[Sequence[pulumi.Input[str]]],
                 priority: pulumi.Input[int],
                 state: pulumi.Input[str],
                 name: Optional[pulumi.Input[str]] = None,
                 scheduling_policy_arn: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a JobQueue resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] compute_environments: Specifies the set of compute environments
               mapped to a job queue and their order.  The position of the compute environments
               in the list will dictate the order.
        :param pulumi.Input[int] priority: The priority of the job queue. Job queues with a higher priority
               are evaluated first when associated with the same compute environment.
        :param pulumi.Input[str] state: The state of the job queue. Must be one of: `ENABLED` or `DISABLED`
        :param pulumi.Input[str] name: Specifies the name of the job queue.
        :param pulumi.Input[str] scheduling_policy_arn: The ARN of the fair share scheduling policy. If this parameter is specified, the job queue uses a fair share scheduling policy. If this parameter isn't specified, the job queue uses a first in, first out (FIFO) scheduling policy. After a job queue is created, you can replace but can't remove the fair share scheduling policy.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        pulumi.set(__self__, "compute_environments", compute_environments)
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "state", state)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if scheduling_policy_arn is not None:
            pulumi.set(__self__, "scheduling_policy_arn", scheduling_policy_arn)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="computeEnvironments")
    def compute_environments(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Specifies the set of compute environments
        mapped to a job queue and their order.  The position of the compute environments
        in the list will dictate the order.
        """
        return pulumi.get(self, "compute_environments")

    @compute_environments.setter
    def compute_environments(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "compute_environments", value)

    @property
    @pulumi.getter
    def priority(self) -> pulumi.Input[int]:
        """
        The priority of the job queue. Job queues with a higher priority
        are evaluated first when associated with the same compute environment.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: pulumi.Input[int]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter
    def state(self) -> pulumi.Input[str]:
        """
        The state of the job queue. Must be one of: `ENABLED` or `DISABLED`
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: pulumi.Input[str]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the job queue.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="schedulingPolicyArn")
    def scheduling_policy_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the fair share scheduling policy. If this parameter is specified, the job queue uses a fair share scheduling policy. If this parameter isn't specified, the job queue uses a first in, first out (FIFO) scheduling policy. After a job queue is created, you can replace but can't remove the fair share scheduling policy.
        """
        return pulumi.get(self, "scheduling_policy_arn")

    @scheduling_policy_arn.setter
    def scheduling_policy_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scheduling_policy_arn", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _JobQueueState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[str]] = None,
                 compute_environments: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 scheduling_policy_arn: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering JobQueue resources.
        :param pulumi.Input[str] arn: The Amazon Resource Name of the job queue.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] compute_environments: Specifies the set of compute environments
               mapped to a job queue and their order.  The position of the compute environments
               in the list will dictate the order.
        :param pulumi.Input[str] name: Specifies the name of the job queue.
        :param pulumi.Input[int] priority: The priority of the job queue. Job queues with a higher priority
               are evaluated first when associated with the same compute environment.
        :param pulumi.Input[str] scheduling_policy_arn: The ARN of the fair share scheduling policy. If this parameter is specified, the job queue uses a fair share scheduling policy. If this parameter isn't specified, the job queue uses a first in, first out (FIFO) scheduling policy. After a job queue is created, you can replace but can't remove the fair share scheduling policy.
        :param pulumi.Input[str] state: The state of the job queue. Must be one of: `ENABLED` or `DISABLED`
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if compute_environments is not None:
            pulumi.set(__self__, "compute_environments", compute_environments)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if scheduling_policy_arn is not None:
            pulumi.set(__self__, "scheduling_policy_arn", scheduling_policy_arn)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name of the job queue.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="computeEnvironments")
    def compute_environments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the set of compute environments
        mapped to a job queue and their order.  The position of the compute environments
        in the list will dictate the order.
        """
        return pulumi.get(self, "compute_environments")

    @compute_environments.setter
    def compute_environments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "compute_environments", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the job queue.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[int]]:
        """
        The priority of the job queue. Job queues with a higher priority
        are evaluated first when associated with the same compute environment.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter(name="schedulingPolicyArn")
    def scheduling_policy_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the fair share scheduling policy. If this parameter is specified, the job queue uses a fair share scheduling policy. If this parameter isn't specified, the job queue uses a first in, first out (FIFO) scheduling policy. After a job queue is created, you can replace but can't remove the fair share scheduling policy.
        """
        return pulumi.get(self, "scheduling_policy_arn")

    @scheduling_policy_arn.setter
    def scheduling_policy_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scheduling_policy_arn", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The state of the job queue. Must be one of: `ENABLED` or `DISABLED`
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags_all", value)


class JobQueue(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compute_environments: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 scheduling_policy_arn: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Provides a Batch Job Queue resource.

        ## Example Usage
        ### Basic Job Queue

        ```python
        import pulumi
        import pulumi_aws as aws

        test_queue = aws.batch.JobQueue("testQueue",
            state="ENABLED",
            priority=1,
            compute_environments=[
                aws_batch_compute_environment["test_environment_1"]["arn"],
                aws_batch_compute_environment["test_environment_2"]["arn"],
            ])
        ```
        ### Job Queue with a fair share scheduling policy

        ```python
        import pulumi
        import pulumi_aws as aws

        example_scheduling_policy = aws.batch.SchedulingPolicy("exampleSchedulingPolicy", fair_share_policy=aws.batch.SchedulingPolicyFairSharePolicyArgs(
            compute_reservation=1,
            share_decay_seconds=3600,
            share_distributions=[aws.batch.SchedulingPolicyFairSharePolicyShareDistributionArgs(
                share_identifier="A1*",
                weight_factor=0.1,
            )],
        ))
        example_job_queue = aws.batch.JobQueue("exampleJobQueue",
            scheduling_policy_arn=example_scheduling_policy.arn,
            state="ENABLED",
            priority=1,
            compute_environments=[
                aws_batch_compute_environment["test_environment_1"]["arn"],
                aws_batch_compute_environment["test_environment_2"]["arn"],
            ])
        ```

        ## Import

        Using `pulumi import`, import Batch Job Queue using the `arn`. For example:

        ```sh
         $ pulumi import aws:batch/jobQueue:JobQueue test_queue arn:aws:batch:us-east-1:123456789012:job-queue/sample
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] compute_environments: Specifies the set of compute environments
               mapped to a job queue and their order.  The position of the compute environments
               in the list will dictate the order.
        :param pulumi.Input[str] name: Specifies the name of the job queue.
        :param pulumi.Input[int] priority: The priority of the job queue. Job queues with a higher priority
               are evaluated first when associated with the same compute environment.
        :param pulumi.Input[str] scheduling_policy_arn: The ARN of the fair share scheduling policy. If this parameter is specified, the job queue uses a fair share scheduling policy. If this parameter isn't specified, the job queue uses a first in, first out (FIFO) scheduling policy. After a job queue is created, you can replace but can't remove the fair share scheduling policy.
        :param pulumi.Input[str] state: The state of the job queue. Must be one of: `ENABLED` or `DISABLED`
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: JobQueueArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Batch Job Queue resource.

        ## Example Usage
        ### Basic Job Queue

        ```python
        import pulumi
        import pulumi_aws as aws

        test_queue = aws.batch.JobQueue("testQueue",
            state="ENABLED",
            priority=1,
            compute_environments=[
                aws_batch_compute_environment["test_environment_1"]["arn"],
                aws_batch_compute_environment["test_environment_2"]["arn"],
            ])
        ```
        ### Job Queue with a fair share scheduling policy

        ```python
        import pulumi
        import pulumi_aws as aws

        example_scheduling_policy = aws.batch.SchedulingPolicy("exampleSchedulingPolicy", fair_share_policy=aws.batch.SchedulingPolicyFairSharePolicyArgs(
            compute_reservation=1,
            share_decay_seconds=3600,
            share_distributions=[aws.batch.SchedulingPolicyFairSharePolicyShareDistributionArgs(
                share_identifier="A1*",
                weight_factor=0.1,
            )],
        ))
        example_job_queue = aws.batch.JobQueue("exampleJobQueue",
            scheduling_policy_arn=example_scheduling_policy.arn,
            state="ENABLED",
            priority=1,
            compute_environments=[
                aws_batch_compute_environment["test_environment_1"]["arn"],
                aws_batch_compute_environment["test_environment_2"]["arn"],
            ])
        ```

        ## Import

        Using `pulumi import`, import Batch Job Queue using the `arn`. For example:

        ```sh
         $ pulumi import aws:batch/jobQueue:JobQueue test_queue arn:aws:batch:us-east-1:123456789012:job-queue/sample
        ```

        :param str resource_name: The name of the resource.
        :param JobQueueArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(JobQueueArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compute_environments: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 scheduling_policy_arn: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = JobQueueArgs.__new__(JobQueueArgs)

            if compute_environments is None and not opts.urn:
                raise TypeError("Missing required property 'compute_environments'")
            __props__.__dict__["compute_environments"] = compute_environments
            __props__.__dict__["name"] = name
            if priority is None and not opts.urn:
                raise TypeError("Missing required property 'priority'")
            __props__.__dict__["priority"] = priority
            __props__.__dict__["scheduling_policy_arn"] = scheduling_policy_arn
            if state is None and not opts.urn:
                raise TypeError("Missing required property 'state'")
            __props__.__dict__["state"] = state
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["tags_all"] = None
        super(JobQueue, __self__).__init__(
            'aws:batch/jobQueue:JobQueue',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[str]] = None,
            compute_environments: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            priority: Optional[pulumi.Input[int]] = None,
            scheduling_policy_arn: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None) -> 'JobQueue':
        """
        Get an existing JobQueue resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] arn: The Amazon Resource Name of the job queue.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] compute_environments: Specifies the set of compute environments
               mapped to a job queue and their order.  The position of the compute environments
               in the list will dictate the order.
        :param pulumi.Input[str] name: Specifies the name of the job queue.
        :param pulumi.Input[int] priority: The priority of the job queue. Job queues with a higher priority
               are evaluated first when associated with the same compute environment.
        :param pulumi.Input[str] scheduling_policy_arn: The ARN of the fair share scheduling policy. If this parameter is specified, the job queue uses a fair share scheduling policy. If this parameter isn't specified, the job queue uses a first in, first out (FIFO) scheduling policy. After a job queue is created, you can replace but can't remove the fair share scheduling policy.
        :param pulumi.Input[str] state: The state of the job queue. Must be one of: `ENABLED` or `DISABLED`
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _JobQueueState.__new__(_JobQueueState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["compute_environments"] = compute_environments
        __props__.__dict__["name"] = name
        __props__.__dict__["priority"] = priority
        __props__.__dict__["scheduling_policy_arn"] = scheduling_policy_arn
        __props__.__dict__["state"] = state
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        return JobQueue(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        The Amazon Resource Name of the job queue.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="computeEnvironments")
    def compute_environments(self) -> pulumi.Output[Sequence[str]]:
        """
        Specifies the set of compute environments
        mapped to a job queue and their order.  The position of the compute environments
        in the list will dictate the order.
        """
        return pulumi.get(self, "compute_environments")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the name of the job queue.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def priority(self) -> pulumi.Output[int]:
        """
        The priority of the job queue. Job queues with a higher priority
        are evaluated first when associated with the same compute environment.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter(name="schedulingPolicyArn")
    def scheduling_policy_arn(self) -> pulumi.Output[Optional[str]]:
        """
        The ARN of the fair share scheduling policy. If this parameter is specified, the job queue uses a fair share scheduling policy. If this parameter isn't specified, the job queue uses a first in, first out (FIFO) scheduling policy. After a job queue is created, you can replace but can't remove the fair share scheduling policy.
        """
        return pulumi.get(self, "scheduling_policy_arn")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The state of the job queue. Must be one of: `ENABLED` or `DISABLED`
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

