# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FieldLevelEncryptionConfigArgs', 'FieldLevelEncryptionConfig']

@pulumi.input_type
class FieldLevelEncryptionConfigArgs:
    def __init__(__self__, *,
                 content_type_profile_config: pulumi.Input['FieldLevelEncryptionConfigContentTypeProfileConfigArgs'],
                 query_arg_profile_config: pulumi.Input['FieldLevelEncryptionConfigQueryArgProfileConfigArgs'],
                 comment: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a FieldLevelEncryptionConfig resource.
        :param pulumi.Input['FieldLevelEncryptionConfigContentTypeProfileConfigArgs'] content_type_profile_config: Content Type Profile Config specifies when to forward content if a content type isn't recognized and profiles to use as by default in a request if a query argument doesn't specify a profile to use.
        :param pulumi.Input['FieldLevelEncryptionConfigQueryArgProfileConfigArgs'] query_arg_profile_config: Query Arg Profile Config that specifies when to forward content if a profile isn't found and the profile that can be provided as a query argument in a request.
        :param pulumi.Input[str] comment: An optional comment about the Field Level Encryption Config.
        """
        pulumi.set(__self__, "content_type_profile_config", content_type_profile_config)
        pulumi.set(__self__, "query_arg_profile_config", query_arg_profile_config)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)

    @property
    @pulumi.getter(name="contentTypeProfileConfig")
    def content_type_profile_config(self) -> pulumi.Input['FieldLevelEncryptionConfigContentTypeProfileConfigArgs']:
        """
        Content Type Profile Config specifies when to forward content if a content type isn't recognized and profiles to use as by default in a request if a query argument doesn't specify a profile to use.
        """
        return pulumi.get(self, "content_type_profile_config")

    @content_type_profile_config.setter
    def content_type_profile_config(self, value: pulumi.Input['FieldLevelEncryptionConfigContentTypeProfileConfigArgs']):
        pulumi.set(self, "content_type_profile_config", value)

    @property
    @pulumi.getter(name="queryArgProfileConfig")
    def query_arg_profile_config(self) -> pulumi.Input['FieldLevelEncryptionConfigQueryArgProfileConfigArgs']:
        """
        Query Arg Profile Config that specifies when to forward content if a profile isn't found and the profile that can be provided as a query argument in a request.
        """
        return pulumi.get(self, "query_arg_profile_config")

    @query_arg_profile_config.setter
    def query_arg_profile_config(self, value: pulumi.Input['FieldLevelEncryptionConfigQueryArgProfileConfigArgs']):
        pulumi.set(self, "query_arg_profile_config", value)

    @property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[str]]:
        """
        An optional comment about the Field Level Encryption Config.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "comment", value)


@pulumi.input_type
class _FieldLevelEncryptionConfigState:
    def __init__(__self__, *,
                 caller_reference: Optional[pulumi.Input[str]] = None,
                 comment: Optional[pulumi.Input[str]] = None,
                 content_type_profile_config: Optional[pulumi.Input['FieldLevelEncryptionConfigContentTypeProfileConfigArgs']] = None,
                 etag: Optional[pulumi.Input[str]] = None,
                 query_arg_profile_config: Optional[pulumi.Input['FieldLevelEncryptionConfigQueryArgProfileConfigArgs']] = None):
        """
        Input properties used for looking up and filtering FieldLevelEncryptionConfig resources.
        :param pulumi.Input[str] caller_reference: Internal value used by CloudFront to allow future updates to the Field Level Encryption Config.
        :param pulumi.Input[str] comment: An optional comment about the Field Level Encryption Config.
        :param pulumi.Input['FieldLevelEncryptionConfigContentTypeProfileConfigArgs'] content_type_profile_config: Content Type Profile Config specifies when to forward content if a content type isn't recognized and profiles to use as by default in a request if a query argument doesn't specify a profile to use.
        :param pulumi.Input[str] etag: The current version of the Field Level Encryption Config. For example: `E2QWRUHAPOMQZL`.
        :param pulumi.Input['FieldLevelEncryptionConfigQueryArgProfileConfigArgs'] query_arg_profile_config: Query Arg Profile Config that specifies when to forward content if a profile isn't found and the profile that can be provided as a query argument in a request.
        """
        if caller_reference is not None:
            pulumi.set(__self__, "caller_reference", caller_reference)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if content_type_profile_config is not None:
            pulumi.set(__self__, "content_type_profile_config", content_type_profile_config)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if query_arg_profile_config is not None:
            pulumi.set(__self__, "query_arg_profile_config", query_arg_profile_config)

    @property
    @pulumi.getter(name="callerReference")
    def caller_reference(self) -> Optional[pulumi.Input[str]]:
        """
        Internal value used by CloudFront to allow future updates to the Field Level Encryption Config.
        """
        return pulumi.get(self, "caller_reference")

    @caller_reference.setter
    def caller_reference(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "caller_reference", value)

    @property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[str]]:
        """
        An optional comment about the Field Level Encryption Config.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "comment", value)

    @property
    @pulumi.getter(name="contentTypeProfileConfig")
    def content_type_profile_config(self) -> Optional[pulumi.Input['FieldLevelEncryptionConfigContentTypeProfileConfigArgs']]:
        """
        Content Type Profile Config specifies when to forward content if a content type isn't recognized and profiles to use as by default in a request if a query argument doesn't specify a profile to use.
        """
        return pulumi.get(self, "content_type_profile_config")

    @content_type_profile_config.setter
    def content_type_profile_config(self, value: Optional[pulumi.Input['FieldLevelEncryptionConfigContentTypeProfileConfigArgs']]):
        pulumi.set(self, "content_type_profile_config", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[str]]:
        """
        The current version of the Field Level Encryption Config. For example: `E2QWRUHAPOMQZL`.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter(name="queryArgProfileConfig")
    def query_arg_profile_config(self) -> Optional[pulumi.Input['FieldLevelEncryptionConfigQueryArgProfileConfigArgs']]:
        """
        Query Arg Profile Config that specifies when to forward content if a profile isn't found and the profile that can be provided as a query argument in a request.
        """
        return pulumi.get(self, "query_arg_profile_config")

    @query_arg_profile_config.setter
    def query_arg_profile_config(self, value: Optional[pulumi.Input['FieldLevelEncryptionConfigQueryArgProfileConfigArgs']]):
        pulumi.set(self, "query_arg_profile_config", value)


class FieldLevelEncryptionConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 comment: Optional[pulumi.Input[str]] = None,
                 content_type_profile_config: Optional[pulumi.Input[pulumi.InputType['FieldLevelEncryptionConfigContentTypeProfileConfigArgs']]] = None,
                 query_arg_profile_config: Optional[pulumi.Input[pulumi.InputType['FieldLevelEncryptionConfigQueryArgProfileConfigArgs']]] = None,
                 __props__=None):
        """
        Provides a CloudFront Field-level Encryption Config resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.cloudfront.FieldLevelEncryptionConfig("test",
            comment="test comment",
            content_type_profile_config=aws.cloudfront.FieldLevelEncryptionConfigContentTypeProfileConfigArgs(
                forward_when_content_type_is_unknown=True,
                content_type_profiles=aws.cloudfront.FieldLevelEncryptionConfigContentTypeProfileConfigContentTypeProfilesArgs(
                    items=[aws.cloudfront.FieldLevelEncryptionConfigContentTypeProfileConfigContentTypeProfilesItemArgs(
                        content_type="application/x-www-form-urlencoded",
                        format="URLEncoded",
                    )],
                ),
            ),
            query_arg_profile_config=aws.cloudfront.FieldLevelEncryptionConfigQueryArgProfileConfigArgs(
                forward_when_query_arg_profile_is_unknown=True,
                query_arg_profiles=aws.cloudfront.FieldLevelEncryptionConfigQueryArgProfileConfigQueryArgProfilesArgs(
                    items=[aws.cloudfront.FieldLevelEncryptionConfigQueryArgProfileConfigQueryArgProfilesItemArgs(
                        profile_id=aws_cloudfront_field_level_encryption_profile["test"]["id"],
                        query_arg="Arg1",
                    )],
                ),
            ))
        ```

        ## Import

        Using `pulumi import`, import Cloudfront Field Level Encryption Config using the `id`. For example:

        ```sh
         $ pulumi import aws:cloudfront/fieldLevelEncryptionConfig:FieldLevelEncryptionConfig config E74FTE3AEXAMPLE
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] comment: An optional comment about the Field Level Encryption Config.
        :param pulumi.Input[pulumi.InputType['FieldLevelEncryptionConfigContentTypeProfileConfigArgs']] content_type_profile_config: Content Type Profile Config specifies when to forward content if a content type isn't recognized and profiles to use as by default in a request if a query argument doesn't specify a profile to use.
        :param pulumi.Input[pulumi.InputType['FieldLevelEncryptionConfigQueryArgProfileConfigArgs']] query_arg_profile_config: Query Arg Profile Config that specifies when to forward content if a profile isn't found and the profile that can be provided as a query argument in a request.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FieldLevelEncryptionConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a CloudFront Field-level Encryption Config resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.cloudfront.FieldLevelEncryptionConfig("test",
            comment="test comment",
            content_type_profile_config=aws.cloudfront.FieldLevelEncryptionConfigContentTypeProfileConfigArgs(
                forward_when_content_type_is_unknown=True,
                content_type_profiles=aws.cloudfront.FieldLevelEncryptionConfigContentTypeProfileConfigContentTypeProfilesArgs(
                    items=[aws.cloudfront.FieldLevelEncryptionConfigContentTypeProfileConfigContentTypeProfilesItemArgs(
                        content_type="application/x-www-form-urlencoded",
                        format="URLEncoded",
                    )],
                ),
            ),
            query_arg_profile_config=aws.cloudfront.FieldLevelEncryptionConfigQueryArgProfileConfigArgs(
                forward_when_query_arg_profile_is_unknown=True,
                query_arg_profiles=aws.cloudfront.FieldLevelEncryptionConfigQueryArgProfileConfigQueryArgProfilesArgs(
                    items=[aws.cloudfront.FieldLevelEncryptionConfigQueryArgProfileConfigQueryArgProfilesItemArgs(
                        profile_id=aws_cloudfront_field_level_encryption_profile["test"]["id"],
                        query_arg="Arg1",
                    )],
                ),
            ))
        ```

        ## Import

        Using `pulumi import`, import Cloudfront Field Level Encryption Config using the `id`. For example:

        ```sh
         $ pulumi import aws:cloudfront/fieldLevelEncryptionConfig:FieldLevelEncryptionConfig config E74FTE3AEXAMPLE
        ```

        :param str resource_name: The name of the resource.
        :param FieldLevelEncryptionConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FieldLevelEncryptionConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 comment: Optional[pulumi.Input[str]] = None,
                 content_type_profile_config: Optional[pulumi.Input[pulumi.InputType['FieldLevelEncryptionConfigContentTypeProfileConfigArgs']]] = None,
                 query_arg_profile_config: Optional[pulumi.Input[pulumi.InputType['FieldLevelEncryptionConfigQueryArgProfileConfigArgs']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FieldLevelEncryptionConfigArgs.__new__(FieldLevelEncryptionConfigArgs)

            __props__.__dict__["comment"] = comment
            if content_type_profile_config is None and not opts.urn:
                raise TypeError("Missing required property 'content_type_profile_config'")
            __props__.__dict__["content_type_profile_config"] = content_type_profile_config
            if query_arg_profile_config is None and not opts.urn:
                raise TypeError("Missing required property 'query_arg_profile_config'")
            __props__.__dict__["query_arg_profile_config"] = query_arg_profile_config
            __props__.__dict__["caller_reference"] = None
            __props__.__dict__["etag"] = None
        super(FieldLevelEncryptionConfig, __self__).__init__(
            'aws:cloudfront/fieldLevelEncryptionConfig:FieldLevelEncryptionConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            caller_reference: Optional[pulumi.Input[str]] = None,
            comment: Optional[pulumi.Input[str]] = None,
            content_type_profile_config: Optional[pulumi.Input[pulumi.InputType['FieldLevelEncryptionConfigContentTypeProfileConfigArgs']]] = None,
            etag: Optional[pulumi.Input[str]] = None,
            query_arg_profile_config: Optional[pulumi.Input[pulumi.InputType['FieldLevelEncryptionConfigQueryArgProfileConfigArgs']]] = None) -> 'FieldLevelEncryptionConfig':
        """
        Get an existing FieldLevelEncryptionConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] caller_reference: Internal value used by CloudFront to allow future updates to the Field Level Encryption Config.
        :param pulumi.Input[str] comment: An optional comment about the Field Level Encryption Config.
        :param pulumi.Input[pulumi.InputType['FieldLevelEncryptionConfigContentTypeProfileConfigArgs']] content_type_profile_config: Content Type Profile Config specifies when to forward content if a content type isn't recognized and profiles to use as by default in a request if a query argument doesn't specify a profile to use.
        :param pulumi.Input[str] etag: The current version of the Field Level Encryption Config. For example: `E2QWRUHAPOMQZL`.
        :param pulumi.Input[pulumi.InputType['FieldLevelEncryptionConfigQueryArgProfileConfigArgs']] query_arg_profile_config: Query Arg Profile Config that specifies when to forward content if a profile isn't found and the profile that can be provided as a query argument in a request.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FieldLevelEncryptionConfigState.__new__(_FieldLevelEncryptionConfigState)

        __props__.__dict__["caller_reference"] = caller_reference
        __props__.__dict__["comment"] = comment
        __props__.__dict__["content_type_profile_config"] = content_type_profile_config
        __props__.__dict__["etag"] = etag
        __props__.__dict__["query_arg_profile_config"] = query_arg_profile_config
        return FieldLevelEncryptionConfig(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="callerReference")
    def caller_reference(self) -> pulumi.Output[str]:
        """
        Internal value used by CloudFront to allow future updates to the Field Level Encryption Config.
        """
        return pulumi.get(self, "caller_reference")

    @property
    @pulumi.getter
    def comment(self) -> pulumi.Output[Optional[str]]:
        """
        An optional comment about the Field Level Encryption Config.
        """
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter(name="contentTypeProfileConfig")
    def content_type_profile_config(self) -> pulumi.Output['outputs.FieldLevelEncryptionConfigContentTypeProfileConfig']:
        """
        Content Type Profile Config specifies when to forward content if a content type isn't recognized and profiles to use as by default in a request if a query argument doesn't specify a profile to use.
        """
        return pulumi.get(self, "content_type_profile_config")

    @property
    @pulumi.getter
    def etag(self) -> pulumi.Output[str]:
        """
        The current version of the Field Level Encryption Config. For example: `E2QWRUHAPOMQZL`.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="queryArgProfileConfig")
    def query_arg_profile_config(self) -> pulumi.Output['outputs.FieldLevelEncryptionConfigQueryArgProfileConfig']:
        """
        Query Arg Profile Config that specifies when to forward content if a profile isn't found and the profile that can be provided as a query argument in a request.
        """
        return pulumi.get(self, "query_arg_profile_config")

