# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['EventArchiveArgs', 'EventArchive']

@pulumi.input_type
class EventArchiveArgs:
    def __init__(__self__, *,
                 event_source_arn: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 event_pattern: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 retention_days: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a EventArchive resource.
        :param pulumi.Input[str] event_source_arn: Event bus source ARN from where these events should be archived.
        :param pulumi.Input[str] description: The description of the new event archive.
        :param pulumi.Input[str] event_pattern: Instructs the new event archive to only capture events matched by this pattern. By default, it attempts to archive every event received in the `event_source_arn`.
        :param pulumi.Input[str] name: The name of the new event archive. The archive name cannot exceed 48 characters.
        :param pulumi.Input[int] retention_days: The maximum number of days to retain events in the new event archive. By default, it archives indefinitely.
        """
        pulumi.set(__self__, "event_source_arn", event_source_arn)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if event_pattern is not None:
            pulumi.set(__self__, "event_pattern", event_pattern)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if retention_days is not None:
            pulumi.set(__self__, "retention_days", retention_days)

    @property
    @pulumi.getter(name="eventSourceArn")
    def event_source_arn(self) -> pulumi.Input[str]:
        """
        Event bus source ARN from where these events should be archived.
        """
        return pulumi.get(self, "event_source_arn")

    @event_source_arn.setter
    def event_source_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "event_source_arn", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the new event archive.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="eventPattern")
    def event_pattern(self) -> Optional[pulumi.Input[str]]:
        """
        Instructs the new event archive to only capture events matched by this pattern. By default, it attempts to archive every event received in the `event_source_arn`.
        """
        return pulumi.get(self, "event_pattern")

    @event_pattern.setter
    def event_pattern(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "event_pattern", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the new event archive. The archive name cannot exceed 48 characters.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="retentionDays")
    def retention_days(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of days to retain events in the new event archive. By default, it archives indefinitely.
        """
        return pulumi.get(self, "retention_days")

    @retention_days.setter
    def retention_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "retention_days", value)


@pulumi.input_type
class _EventArchiveState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 event_pattern: Optional[pulumi.Input[str]] = None,
                 event_source_arn: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 retention_days: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering EventArchive resources.
        :param pulumi.Input[str] arn: The Amazon Resource Name (ARN) of the event archive.
        :param pulumi.Input[str] description: The description of the new event archive.
        :param pulumi.Input[str] event_pattern: Instructs the new event archive to only capture events matched by this pattern. By default, it attempts to archive every event received in the `event_source_arn`.
        :param pulumi.Input[str] event_source_arn: Event bus source ARN from where these events should be archived.
        :param pulumi.Input[str] name: The name of the new event archive. The archive name cannot exceed 48 characters.
        :param pulumi.Input[int] retention_days: The maximum number of days to retain events in the new event archive. By default, it archives indefinitely.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if event_pattern is not None:
            pulumi.set(__self__, "event_pattern", event_pattern)
        if event_source_arn is not None:
            pulumi.set(__self__, "event_source_arn", event_source_arn)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if retention_days is not None:
            pulumi.set(__self__, "retention_days", retention_days)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name (ARN) of the event archive.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the new event archive.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="eventPattern")
    def event_pattern(self) -> Optional[pulumi.Input[str]]:
        """
        Instructs the new event archive to only capture events matched by this pattern. By default, it attempts to archive every event received in the `event_source_arn`.
        """
        return pulumi.get(self, "event_pattern")

    @event_pattern.setter
    def event_pattern(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "event_pattern", value)

    @property
    @pulumi.getter(name="eventSourceArn")
    def event_source_arn(self) -> Optional[pulumi.Input[str]]:
        """
        Event bus source ARN from where these events should be archived.
        """
        return pulumi.get(self, "event_source_arn")

    @event_source_arn.setter
    def event_source_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "event_source_arn", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the new event archive. The archive name cannot exceed 48 characters.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="retentionDays")
    def retention_days(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of days to retain events in the new event archive. By default, it archives indefinitely.
        """
        return pulumi.get(self, "retention_days")

    @retention_days.setter
    def retention_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "retention_days", value)


class EventArchive(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 event_pattern: Optional[pulumi.Input[str]] = None,
                 event_source_arn: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 retention_days: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        Provides an EventBridge event archive resource.

        > **Note:** EventBridge was formerly known as CloudWatch Events. The functionality is identical.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        order_event_bus = aws.cloudwatch.EventBus("orderEventBus")
        order_event_archive = aws.cloudwatch.EventArchive("orderEventArchive", event_source_arn=order_event_bus.arn)
        ```
        ## Example all optional arguments

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        order_event_bus = aws.cloudwatch.EventBus("orderEventBus")
        order_event_archive = aws.cloudwatch.EventArchive("orderEventArchive",
            description="Archived events from order service",
            event_source_arn=order_event_bus.arn,
            retention_days=7,
            event_pattern=json.dumps({
                "source": ["company.team.order"],
            }))
        ```

        ## Import

        Using `pulumi import`, import an EventBridge archive using the `name`. For example:

        ```sh
         $ pulumi import aws:cloudwatch/eventArchive:EventArchive imported_event_archive order-archive
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description of the new event archive.
        :param pulumi.Input[str] event_pattern: Instructs the new event archive to only capture events matched by this pattern. By default, it attempts to archive every event received in the `event_source_arn`.
        :param pulumi.Input[str] event_source_arn: Event bus source ARN from where these events should be archived.
        :param pulumi.Input[str] name: The name of the new event archive. The archive name cannot exceed 48 characters.
        :param pulumi.Input[int] retention_days: The maximum number of days to retain events in the new event archive. By default, it archives indefinitely.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EventArchiveArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an EventBridge event archive resource.

        > **Note:** EventBridge was formerly known as CloudWatch Events. The functionality is identical.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        order_event_bus = aws.cloudwatch.EventBus("orderEventBus")
        order_event_archive = aws.cloudwatch.EventArchive("orderEventArchive", event_source_arn=order_event_bus.arn)
        ```
        ## Example all optional arguments

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        order_event_bus = aws.cloudwatch.EventBus("orderEventBus")
        order_event_archive = aws.cloudwatch.EventArchive("orderEventArchive",
            description="Archived events from order service",
            event_source_arn=order_event_bus.arn,
            retention_days=7,
            event_pattern=json.dumps({
                "source": ["company.team.order"],
            }))
        ```

        ## Import

        Using `pulumi import`, import an EventBridge archive using the `name`. For example:

        ```sh
         $ pulumi import aws:cloudwatch/eventArchive:EventArchive imported_event_archive order-archive
        ```

        :param str resource_name: The name of the resource.
        :param EventArchiveArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EventArchiveArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 event_pattern: Optional[pulumi.Input[str]] = None,
                 event_source_arn: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 retention_days: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EventArchiveArgs.__new__(EventArchiveArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["event_pattern"] = event_pattern
            if event_source_arn is None and not opts.urn:
                raise TypeError("Missing required property 'event_source_arn'")
            __props__.__dict__["event_source_arn"] = event_source_arn
            __props__.__dict__["name"] = name
            __props__.__dict__["retention_days"] = retention_days
            __props__.__dict__["arn"] = None
        super(EventArchive, __self__).__init__(
            'aws:cloudwatch/eventArchive:EventArchive',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            event_pattern: Optional[pulumi.Input[str]] = None,
            event_source_arn: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            retention_days: Optional[pulumi.Input[int]] = None) -> 'EventArchive':
        """
        Get an existing EventArchive resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] arn: The Amazon Resource Name (ARN) of the event archive.
        :param pulumi.Input[str] description: The description of the new event archive.
        :param pulumi.Input[str] event_pattern: Instructs the new event archive to only capture events matched by this pattern. By default, it attempts to archive every event received in the `event_source_arn`.
        :param pulumi.Input[str] event_source_arn: Event bus source ARN from where these events should be archived.
        :param pulumi.Input[str] name: The name of the new event archive. The archive name cannot exceed 48 characters.
        :param pulumi.Input[int] retention_days: The maximum number of days to retain events in the new event archive. By default, it archives indefinitely.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EventArchiveState.__new__(_EventArchiveState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["description"] = description
        __props__.__dict__["event_pattern"] = event_pattern
        __props__.__dict__["event_source_arn"] = event_source_arn
        __props__.__dict__["name"] = name
        __props__.__dict__["retention_days"] = retention_days
        return EventArchive(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        The Amazon Resource Name (ARN) of the event archive.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the new event archive.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="eventPattern")
    def event_pattern(self) -> pulumi.Output[Optional[str]]:
        """
        Instructs the new event archive to only capture events matched by this pattern. By default, it attempts to archive every event received in the `event_source_arn`.
        """
        return pulumi.get(self, "event_pattern")

    @property
    @pulumi.getter(name="eventSourceArn")
    def event_source_arn(self) -> pulumi.Output[str]:
        """
        Event bus source ARN from where these events should be archived.
        """
        return pulumi.get(self, "event_source_arn")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the new event archive. The archive name cannot exceed 48 characters.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="retentionDays")
    def retention_days(self) -> pulumi.Output[Optional[int]]:
        """
        The maximum number of days to retain events in the new event archive. By default, it archives indefinitely.
        """
        return pulumi.get(self, "retention_days")

