# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InternetMonitorArgs', 'InternetMonitor']

@pulumi.input_type
class InternetMonitorArgs:
    def __init__(__self__, *,
                 monitor_name: pulumi.Input[str],
                 health_events_config: Optional[pulumi.Input['InternetMonitorHealthEventsConfigArgs']] = None,
                 internet_measurements_log_delivery: Optional[pulumi.Input['InternetMonitorInternetMeasurementsLogDeliveryArgs']] = None,
                 max_city_networks_to_monitor: Optional[pulumi.Input[int]] = None,
                 resources: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 traffic_percentage_to_monitor: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a InternetMonitor resource.
        :param pulumi.Input[str] monitor_name: The name of the monitor.
               
               The following arguments are optional:
        :param pulumi.Input['InternetMonitorHealthEventsConfigArgs'] health_events_config: Health event thresholds. A health event threshold percentage, for performance and availability, determines when Internet Monitor creates a health event when there's an internet issue that affects your application end users. See Health Events Config below.
        :param pulumi.Input['InternetMonitorInternetMeasurementsLogDeliveryArgs'] internet_measurements_log_delivery: Publish internet measurements for Internet Monitor to an Amazon S3 bucket in addition to CloudWatch Logs.
        :param pulumi.Input[int] max_city_networks_to_monitor: The maximum number of city-networks to monitor for your resources. A city-network is the location (city) where clients access your application resources from and the network or ASN, such as an internet service provider (ISP), that clients access the resources through. This limit helps control billing costs.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] resources: The resources to include in a monitor, which you provide as a set of Amazon Resource Names (ARNs).
        :param pulumi.Input[str] status: The status for a monitor. The accepted values for Status with the UpdateMonitor API call are the following: `ACTIVE` and `INACTIVE`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[int] traffic_percentage_to_monitor: The percentage of the internet-facing traffic for your application that you want to monitor with this monitor.
        """
        pulumi.set(__self__, "monitor_name", monitor_name)
        if health_events_config is not None:
            pulumi.set(__self__, "health_events_config", health_events_config)
        if internet_measurements_log_delivery is not None:
            pulumi.set(__self__, "internet_measurements_log_delivery", internet_measurements_log_delivery)
        if max_city_networks_to_monitor is not None:
            pulumi.set(__self__, "max_city_networks_to_monitor", max_city_networks_to_monitor)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if traffic_percentage_to_monitor is not None:
            pulumi.set(__self__, "traffic_percentage_to_monitor", traffic_percentage_to_monitor)

    @property
    @pulumi.getter(name="monitorName")
    def monitor_name(self) -> pulumi.Input[str]:
        """
        The name of the monitor.

        The following arguments are optional:
        """
        return pulumi.get(self, "monitor_name")

    @monitor_name.setter
    def monitor_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "monitor_name", value)

    @property
    @pulumi.getter(name="healthEventsConfig")
    def health_events_config(self) -> Optional[pulumi.Input['InternetMonitorHealthEventsConfigArgs']]:
        """
        Health event thresholds. A health event threshold percentage, for performance and availability, determines when Internet Monitor creates a health event when there's an internet issue that affects your application end users. See Health Events Config below.
        """
        return pulumi.get(self, "health_events_config")

    @health_events_config.setter
    def health_events_config(self, value: Optional[pulumi.Input['InternetMonitorHealthEventsConfigArgs']]):
        pulumi.set(self, "health_events_config", value)

    @property
    @pulumi.getter(name="internetMeasurementsLogDelivery")
    def internet_measurements_log_delivery(self) -> Optional[pulumi.Input['InternetMonitorInternetMeasurementsLogDeliveryArgs']]:
        """
        Publish internet measurements for Internet Monitor to an Amazon S3 bucket in addition to CloudWatch Logs.
        """
        return pulumi.get(self, "internet_measurements_log_delivery")

    @internet_measurements_log_delivery.setter
    def internet_measurements_log_delivery(self, value: Optional[pulumi.Input['InternetMonitorInternetMeasurementsLogDeliveryArgs']]):
        pulumi.set(self, "internet_measurements_log_delivery", value)

    @property
    @pulumi.getter(name="maxCityNetworksToMonitor")
    def max_city_networks_to_monitor(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of city-networks to monitor for your resources. A city-network is the location (city) where clients access your application resources from and the network or ASN, such as an internet service provider (ISP), that clients access the resources through. This limit helps control billing costs.
        """
        return pulumi.get(self, "max_city_networks_to_monitor")

    @max_city_networks_to_monitor.setter
    def max_city_networks_to_monitor(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_city_networks_to_monitor", value)

    @property
    @pulumi.getter
    def resources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The resources to include in a monitor, which you provide as a set of Amazon Resource Names (ARNs).
        """
        return pulumi.get(self, "resources")

    @resources.setter
    def resources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "resources", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status for a monitor. The accepted values for Status with the UpdateMonitor API call are the following: `ACTIVE` and `INACTIVE`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="trafficPercentageToMonitor")
    def traffic_percentage_to_monitor(self) -> Optional[pulumi.Input[int]]:
        """
        The percentage of the internet-facing traffic for your application that you want to monitor with this monitor.
        """
        return pulumi.get(self, "traffic_percentage_to_monitor")

    @traffic_percentage_to_monitor.setter
    def traffic_percentage_to_monitor(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "traffic_percentage_to_monitor", value)


@pulumi.input_type
class _InternetMonitorState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[str]] = None,
                 health_events_config: Optional[pulumi.Input['InternetMonitorHealthEventsConfigArgs']] = None,
                 internet_measurements_log_delivery: Optional[pulumi.Input['InternetMonitorInternetMeasurementsLogDeliveryArgs']] = None,
                 max_city_networks_to_monitor: Optional[pulumi.Input[int]] = None,
                 monitor_name: Optional[pulumi.Input[str]] = None,
                 resources: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 traffic_percentage_to_monitor: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering InternetMonitor resources.
        :param pulumi.Input[str] arn: ARN of the Monitor.
        :param pulumi.Input['InternetMonitorHealthEventsConfigArgs'] health_events_config: Health event thresholds. A health event threshold percentage, for performance and availability, determines when Internet Monitor creates a health event when there's an internet issue that affects your application end users. See Health Events Config below.
        :param pulumi.Input['InternetMonitorInternetMeasurementsLogDeliveryArgs'] internet_measurements_log_delivery: Publish internet measurements for Internet Monitor to an Amazon S3 bucket in addition to CloudWatch Logs.
        :param pulumi.Input[int] max_city_networks_to_monitor: The maximum number of city-networks to monitor for your resources. A city-network is the location (city) where clients access your application resources from and the network or ASN, such as an internet service provider (ISP), that clients access the resources through. This limit helps control billing costs.
        :param pulumi.Input[str] monitor_name: The name of the monitor.
               
               The following arguments are optional:
        :param pulumi.Input[Sequence[pulumi.Input[str]]] resources: The resources to include in a monitor, which you provide as a set of Amazon Resource Names (ARNs).
        :param pulumi.Input[str] status: The status for a monitor. The accepted values for Status with the UpdateMonitor API call are the following: `ACTIVE` and `INACTIVE`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[int] traffic_percentage_to_monitor: The percentage of the internet-facing traffic for your application that you want to monitor with this monitor.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if health_events_config is not None:
            pulumi.set(__self__, "health_events_config", health_events_config)
        if internet_measurements_log_delivery is not None:
            pulumi.set(__self__, "internet_measurements_log_delivery", internet_measurements_log_delivery)
        if max_city_networks_to_monitor is not None:
            pulumi.set(__self__, "max_city_networks_to_monitor", max_city_networks_to_monitor)
        if monitor_name is not None:
            pulumi.set(__self__, "monitor_name", monitor_name)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if traffic_percentage_to_monitor is not None:
            pulumi.set(__self__, "traffic_percentage_to_monitor", traffic_percentage_to_monitor)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN of the Monitor.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="healthEventsConfig")
    def health_events_config(self) -> Optional[pulumi.Input['InternetMonitorHealthEventsConfigArgs']]:
        """
        Health event thresholds. A health event threshold percentage, for performance and availability, determines when Internet Monitor creates a health event when there's an internet issue that affects your application end users. See Health Events Config below.
        """
        return pulumi.get(self, "health_events_config")

    @health_events_config.setter
    def health_events_config(self, value: Optional[pulumi.Input['InternetMonitorHealthEventsConfigArgs']]):
        pulumi.set(self, "health_events_config", value)

    @property
    @pulumi.getter(name="internetMeasurementsLogDelivery")
    def internet_measurements_log_delivery(self) -> Optional[pulumi.Input['InternetMonitorInternetMeasurementsLogDeliveryArgs']]:
        """
        Publish internet measurements for Internet Monitor to an Amazon S3 bucket in addition to CloudWatch Logs.
        """
        return pulumi.get(self, "internet_measurements_log_delivery")

    @internet_measurements_log_delivery.setter
    def internet_measurements_log_delivery(self, value: Optional[pulumi.Input['InternetMonitorInternetMeasurementsLogDeliveryArgs']]):
        pulumi.set(self, "internet_measurements_log_delivery", value)

    @property
    @pulumi.getter(name="maxCityNetworksToMonitor")
    def max_city_networks_to_monitor(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of city-networks to monitor for your resources. A city-network is the location (city) where clients access your application resources from and the network or ASN, such as an internet service provider (ISP), that clients access the resources through. This limit helps control billing costs.
        """
        return pulumi.get(self, "max_city_networks_to_monitor")

    @max_city_networks_to_monitor.setter
    def max_city_networks_to_monitor(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_city_networks_to_monitor", value)

    @property
    @pulumi.getter(name="monitorName")
    def monitor_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the monitor.

        The following arguments are optional:
        """
        return pulumi.get(self, "monitor_name")

    @monitor_name.setter
    def monitor_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "monitor_name", value)

    @property
    @pulumi.getter
    def resources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The resources to include in a monitor, which you provide as a set of Amazon Resource Names (ARNs).
        """
        return pulumi.get(self, "resources")

    @resources.setter
    def resources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "resources", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status for a monitor. The accepted values for Status with the UpdateMonitor API call are the following: `ACTIVE` and `INACTIVE`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter(name="trafficPercentageToMonitor")
    def traffic_percentage_to_monitor(self) -> Optional[pulumi.Input[int]]:
        """
        The percentage of the internet-facing traffic for your application that you want to monitor with this monitor.
        """
        return pulumi.get(self, "traffic_percentage_to_monitor")

    @traffic_percentage_to_monitor.setter
    def traffic_percentage_to_monitor(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "traffic_percentage_to_monitor", value)


class InternetMonitor(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 health_events_config: Optional[pulumi.Input[pulumi.InputType['InternetMonitorHealthEventsConfigArgs']]] = None,
                 internet_measurements_log_delivery: Optional[pulumi.Input[pulumi.InputType['InternetMonitorInternetMeasurementsLogDeliveryArgs']]] = None,
                 max_city_networks_to_monitor: Optional[pulumi.Input[int]] = None,
                 monitor_name: Optional[pulumi.Input[str]] = None,
                 resources: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 traffic_percentage_to_monitor: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        Provides a Internet Monitor Monitor resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.cloudwatch.InternetMonitor("example", monitor_name="exmple")
        ```

        ## Import

        Using `pulumi import`, import Internet Monitor Monitors using the `monitor_name`. For example:

        ```sh
         $ pulumi import aws:cloudwatch/internetMonitor:InternetMonitor some some-monitor
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['InternetMonitorHealthEventsConfigArgs']] health_events_config: Health event thresholds. A health event threshold percentage, for performance and availability, determines when Internet Monitor creates a health event when there's an internet issue that affects your application end users. See Health Events Config below.
        :param pulumi.Input[pulumi.InputType['InternetMonitorInternetMeasurementsLogDeliveryArgs']] internet_measurements_log_delivery: Publish internet measurements for Internet Monitor to an Amazon S3 bucket in addition to CloudWatch Logs.
        :param pulumi.Input[int] max_city_networks_to_monitor: The maximum number of city-networks to monitor for your resources. A city-network is the location (city) where clients access your application resources from and the network or ASN, such as an internet service provider (ISP), that clients access the resources through. This limit helps control billing costs.
        :param pulumi.Input[str] monitor_name: The name of the monitor.
               
               The following arguments are optional:
        :param pulumi.Input[Sequence[pulumi.Input[str]]] resources: The resources to include in a monitor, which you provide as a set of Amazon Resource Names (ARNs).
        :param pulumi.Input[str] status: The status for a monitor. The accepted values for Status with the UpdateMonitor API call are the following: `ACTIVE` and `INACTIVE`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[int] traffic_percentage_to_monitor: The percentage of the internet-facing traffic for your application that you want to monitor with this monitor.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InternetMonitorArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Internet Monitor Monitor resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.cloudwatch.InternetMonitor("example", monitor_name="exmple")
        ```

        ## Import

        Using `pulumi import`, import Internet Monitor Monitors using the `monitor_name`. For example:

        ```sh
         $ pulumi import aws:cloudwatch/internetMonitor:InternetMonitor some some-monitor
        ```

        :param str resource_name: The name of the resource.
        :param InternetMonitorArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InternetMonitorArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 health_events_config: Optional[pulumi.Input[pulumi.InputType['InternetMonitorHealthEventsConfigArgs']]] = None,
                 internet_measurements_log_delivery: Optional[pulumi.Input[pulumi.InputType['InternetMonitorInternetMeasurementsLogDeliveryArgs']]] = None,
                 max_city_networks_to_monitor: Optional[pulumi.Input[int]] = None,
                 monitor_name: Optional[pulumi.Input[str]] = None,
                 resources: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 traffic_percentage_to_monitor: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InternetMonitorArgs.__new__(InternetMonitorArgs)

            __props__.__dict__["health_events_config"] = health_events_config
            __props__.__dict__["internet_measurements_log_delivery"] = internet_measurements_log_delivery
            __props__.__dict__["max_city_networks_to_monitor"] = max_city_networks_to_monitor
            if monitor_name is None and not opts.urn:
                raise TypeError("Missing required property 'monitor_name'")
            __props__.__dict__["monitor_name"] = monitor_name
            __props__.__dict__["resources"] = resources
            __props__.__dict__["status"] = status
            __props__.__dict__["tags"] = tags
            __props__.__dict__["traffic_percentage_to_monitor"] = traffic_percentage_to_monitor
            __props__.__dict__["arn"] = None
            __props__.__dict__["tags_all"] = None
        super(InternetMonitor, __self__).__init__(
            'aws:cloudwatch/internetMonitor:InternetMonitor',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[str]] = None,
            health_events_config: Optional[pulumi.Input[pulumi.InputType['InternetMonitorHealthEventsConfigArgs']]] = None,
            internet_measurements_log_delivery: Optional[pulumi.Input[pulumi.InputType['InternetMonitorInternetMeasurementsLogDeliveryArgs']]] = None,
            max_city_networks_to_monitor: Optional[pulumi.Input[int]] = None,
            monitor_name: Optional[pulumi.Input[str]] = None,
            resources: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            status: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            traffic_percentage_to_monitor: Optional[pulumi.Input[int]] = None) -> 'InternetMonitor':
        """
        Get an existing InternetMonitor resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] arn: ARN of the Monitor.
        :param pulumi.Input[pulumi.InputType['InternetMonitorHealthEventsConfigArgs']] health_events_config: Health event thresholds. A health event threshold percentage, for performance and availability, determines when Internet Monitor creates a health event when there's an internet issue that affects your application end users. See Health Events Config below.
        :param pulumi.Input[pulumi.InputType['InternetMonitorInternetMeasurementsLogDeliveryArgs']] internet_measurements_log_delivery: Publish internet measurements for Internet Monitor to an Amazon S3 bucket in addition to CloudWatch Logs.
        :param pulumi.Input[int] max_city_networks_to_monitor: The maximum number of city-networks to monitor for your resources. A city-network is the location (city) where clients access your application resources from and the network or ASN, such as an internet service provider (ISP), that clients access the resources through. This limit helps control billing costs.
        :param pulumi.Input[str] monitor_name: The name of the monitor.
               
               The following arguments are optional:
        :param pulumi.Input[Sequence[pulumi.Input[str]]] resources: The resources to include in a monitor, which you provide as a set of Amazon Resource Names (ARNs).
        :param pulumi.Input[str] status: The status for a monitor. The accepted values for Status with the UpdateMonitor API call are the following: `ACTIVE` and `INACTIVE`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[int] traffic_percentage_to_monitor: The percentage of the internet-facing traffic for your application that you want to monitor with this monitor.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InternetMonitorState.__new__(_InternetMonitorState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["health_events_config"] = health_events_config
        __props__.__dict__["internet_measurements_log_delivery"] = internet_measurements_log_delivery
        __props__.__dict__["max_city_networks_to_monitor"] = max_city_networks_to_monitor
        __props__.__dict__["monitor_name"] = monitor_name
        __props__.__dict__["resources"] = resources
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["traffic_percentage_to_monitor"] = traffic_percentage_to_monitor
        return InternetMonitor(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        ARN of the Monitor.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="healthEventsConfig")
    def health_events_config(self) -> pulumi.Output[Optional['outputs.InternetMonitorHealthEventsConfig']]:
        """
        Health event thresholds. A health event threshold percentage, for performance and availability, determines when Internet Monitor creates a health event when there's an internet issue that affects your application end users. See Health Events Config below.
        """
        return pulumi.get(self, "health_events_config")

    @property
    @pulumi.getter(name="internetMeasurementsLogDelivery")
    def internet_measurements_log_delivery(self) -> pulumi.Output[Optional['outputs.InternetMonitorInternetMeasurementsLogDelivery']]:
        """
        Publish internet measurements for Internet Monitor to an Amazon S3 bucket in addition to CloudWatch Logs.
        """
        return pulumi.get(self, "internet_measurements_log_delivery")

    @property
    @pulumi.getter(name="maxCityNetworksToMonitor")
    def max_city_networks_to_monitor(self) -> pulumi.Output[Optional[int]]:
        """
        The maximum number of city-networks to monitor for your resources. A city-network is the location (city) where clients access your application resources from and the network or ASN, such as an internet service provider (ISP), that clients access the resources through. This limit helps control billing costs.
        """
        return pulumi.get(self, "max_city_networks_to_monitor")

    @property
    @pulumi.getter(name="monitorName")
    def monitor_name(self) -> pulumi.Output[str]:
        """
        The name of the monitor.

        The following arguments are optional:
        """
        return pulumi.get(self, "monitor_name")

    @property
    @pulumi.getter
    def resources(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The resources to include in a monitor, which you provide as a set of Amazon Resource Names (ARNs).
        """
        return pulumi.get(self, "resources")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[Optional[str]]:
        """
        The status for a monitor. The accepted values for Status with the UpdateMonitor API call are the following: `ACTIVE` and `INACTIVE`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter(name="trafficPercentageToMonitor")
    def traffic_percentage_to_monitor(self) -> pulumi.Output[Optional[int]]:
        """
        The percentage of the internet-facing traffic for your application that you want to monitor with this monitor.
        """
        return pulumi.get(self, "traffic_percentage_to_monitor")

