# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'HostVpcConfiguration',
]

@pulumi.output_type
class HostVpcConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "securityGroupIds":
            suggest = "security_group_ids"
        elif key == "subnetIds":
            suggest = "subnet_ids"
        elif key == "vpcId":
            suggest = "vpc_id"
        elif key == "tlsCertificate":
            suggest = "tls_certificate"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HostVpcConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HostVpcConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HostVpcConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 security_group_ids: Sequence[str],
                 subnet_ids: Sequence[str],
                 vpc_id: str,
                 tls_certificate: Optional[str] = None):
        """
        :param Sequence[str] security_group_ids: ID of the security group or security groups associated with the Amazon VPC connected to the infrastructure where your provider type is installed.
        :param Sequence[str] subnet_ids: The ID of the subnet or subnets associated with the Amazon VPC connected to the infrastructure where your provider type is installed.
        :param str vpc_id: The ID of the Amazon VPC connected to the infrastructure where your provider type is installed.
        :param str tls_certificate: The value of the Transport Layer Security (TLS) certificate associated with the infrastructure where your provider type is installed.
        """
        pulumi.set(__self__, "security_group_ids", security_group_ids)
        pulumi.set(__self__, "subnet_ids", subnet_ids)
        pulumi.set(__self__, "vpc_id", vpc_id)
        if tls_certificate is not None:
            pulumi.set(__self__, "tls_certificate", tls_certificate)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Sequence[str]:
        """
        ID of the security group or security groups associated with the Amazon VPC connected to the infrastructure where your provider type is installed.
        """
        return pulumi.get(self, "security_group_ids")

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Sequence[str]:
        """
        The ID of the subnet or subnets associated with the Amazon VPC connected to the infrastructure where your provider type is installed.
        """
        return pulumi.get(self, "subnet_ids")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> str:
        """
        The ID of the Amazon VPC connected to the infrastructure where your provider type is installed.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="tlsCertificate")
    def tls_certificate(self) -> Optional[str]:
        """
        The value of the Transport Layer Security (TLS) certificate associated with the infrastructure where your provider type is installed.
        """
        return pulumi.get(self, "tls_certificate")


