# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'IdentityPoolCognitoIdentityProvider',
    'IdentityPoolRoleAttachmentRoleMapping',
    'IdentityPoolRoleAttachmentRoleMappingMappingRule',
    'ManagedUserPoolClientAnalyticsConfiguration',
    'ManagedUserPoolClientTokenValidityUnits',
    'ResourceServerScope',
    'RiskConfigurationAccountTakeoverRiskConfiguration',
    'RiskConfigurationAccountTakeoverRiskConfigurationActions',
    'RiskConfigurationAccountTakeoverRiskConfigurationActionsHighAction',
    'RiskConfigurationAccountTakeoverRiskConfigurationActionsLowAction',
    'RiskConfigurationAccountTakeoverRiskConfigurationActionsMediumAction',
    'RiskConfigurationAccountTakeoverRiskConfigurationNotifyConfiguration',
    'RiskConfigurationAccountTakeoverRiskConfigurationNotifyConfigurationBlockEmail',
    'RiskConfigurationAccountTakeoverRiskConfigurationNotifyConfigurationMfaEmail',
    'RiskConfigurationAccountTakeoverRiskConfigurationNotifyConfigurationNoActionEmail',
    'RiskConfigurationCompromisedCredentialsRiskConfiguration',
    'RiskConfigurationCompromisedCredentialsRiskConfigurationActions',
    'RiskConfigurationRiskExceptionConfiguration',
    'UserPoolAccountRecoverySetting',
    'UserPoolAccountRecoverySettingRecoveryMechanism',
    'UserPoolAdminCreateUserConfig',
    'UserPoolAdminCreateUserConfigInviteMessageTemplate',
    'UserPoolClientAnalyticsConfiguration',
    'UserPoolClientTokenValidityUnits',
    'UserPoolDeviceConfiguration',
    'UserPoolEmailConfiguration',
    'UserPoolLambdaConfig',
    'UserPoolLambdaConfigCustomEmailSender',
    'UserPoolLambdaConfigCustomSmsSender',
    'UserPoolPasswordPolicy',
    'UserPoolSchema',
    'UserPoolSchemaNumberAttributeConstraints',
    'UserPoolSchemaStringAttributeConstraints',
    'UserPoolSmsConfiguration',
    'UserPoolSoftwareTokenMfaConfiguration',
    'UserPoolUserAttributeUpdateSettings',
    'UserPoolUserPoolAddOns',
    'UserPoolUsernameConfiguration',
    'UserPoolVerificationMessageTemplate',
    'GetUserPoolClientAnalyticsConfigurationResult',
    'GetUserPoolClientTokenValidityUnitResult',
]

@pulumi.output_type
class IdentityPoolCognitoIdentityProvider(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "providerName":
            suggest = "provider_name"
        elif key == "serverSideTokenCheck":
            suggest = "server_side_token_check"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IdentityPoolCognitoIdentityProvider. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IdentityPoolCognitoIdentityProvider.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IdentityPoolCognitoIdentityProvider.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: Optional[str] = None,
                 provider_name: Optional[str] = None,
                 server_side_token_check: Optional[bool] = None):
        """
        :param str client_id: The client ID for the Amazon Cognito Identity User Pool.
        :param str provider_name: The provider name for an Amazon Cognito Identity User Pool.
        :param bool server_side_token_check: Whether server-side token validation is enabled for the identity provider’s token or not.
        """
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if provider_name is not None:
            pulumi.set(__self__, "provider_name", provider_name)
        if server_side_token_check is not None:
            pulumi.set(__self__, "server_side_token_check", server_side_token_check)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[str]:
        """
        The client ID for the Amazon Cognito Identity User Pool.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="providerName")
    def provider_name(self) -> Optional[str]:
        """
        The provider name for an Amazon Cognito Identity User Pool.
        """
        return pulumi.get(self, "provider_name")

    @property
    @pulumi.getter(name="serverSideTokenCheck")
    def server_side_token_check(self) -> Optional[bool]:
        """
        Whether server-side token validation is enabled for the identity provider’s token or not.
        """
        return pulumi.get(self, "server_side_token_check")


@pulumi.output_type
class IdentityPoolRoleAttachmentRoleMapping(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "identityProvider":
            suggest = "identity_provider"
        elif key == "ambiguousRoleResolution":
            suggest = "ambiguous_role_resolution"
        elif key == "mappingRules":
            suggest = "mapping_rules"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IdentityPoolRoleAttachmentRoleMapping. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IdentityPoolRoleAttachmentRoleMapping.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IdentityPoolRoleAttachmentRoleMapping.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 identity_provider: str,
                 type: str,
                 ambiguous_role_resolution: Optional[str] = None,
                 mapping_rules: Optional[Sequence['outputs.IdentityPoolRoleAttachmentRoleMappingMappingRule']] = None):
        """
        :param str identity_provider: A string identifying the identity provider, for example, "graph.facebook.com" or "cognito-idp.us-east-1.amazonaws.com/us-east-1_abcdefghi:app_client_id". Depends on `cognito_identity_providers` set on `cognito.IdentityPool` resource or a `cognito.IdentityProvider` resource.
        :param str type: The role mapping type.
        :param str ambiguous_role_resolution: Specifies the action to be taken if either no rules match the claim value for the Rules type, or there is no cognito:preferred_role claim and there are multiple cognito:roles matches for the Token type. `Required` if you specify Token or Rules as the Type.
        :param Sequence['IdentityPoolRoleAttachmentRoleMappingMappingRuleArgs'] mapping_rules: The Rules Configuration to be used for mapping users to roles. You can specify up to 25 rules per identity provider. Rules are evaluated in order. The first one to match specifies the role.
        """
        pulumi.set(__self__, "identity_provider", identity_provider)
        pulumi.set(__self__, "type", type)
        if ambiguous_role_resolution is not None:
            pulumi.set(__self__, "ambiguous_role_resolution", ambiguous_role_resolution)
        if mapping_rules is not None:
            pulumi.set(__self__, "mapping_rules", mapping_rules)

    @property
    @pulumi.getter(name="identityProvider")
    def identity_provider(self) -> str:
        """
        A string identifying the identity provider, for example, "graph.facebook.com" or "cognito-idp.us-east-1.amazonaws.com/us-east-1_abcdefghi:app_client_id". Depends on `cognito_identity_providers` set on `cognito.IdentityPool` resource or a `cognito.IdentityProvider` resource.
        """
        return pulumi.get(self, "identity_provider")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The role mapping type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="ambiguousRoleResolution")
    def ambiguous_role_resolution(self) -> Optional[str]:
        """
        Specifies the action to be taken if either no rules match the claim value for the Rules type, or there is no cognito:preferred_role claim and there are multiple cognito:roles matches for the Token type. `Required` if you specify Token or Rules as the Type.
        """
        return pulumi.get(self, "ambiguous_role_resolution")

    @property
    @pulumi.getter(name="mappingRules")
    def mapping_rules(self) -> Optional[Sequence['outputs.IdentityPoolRoleAttachmentRoleMappingMappingRule']]:
        """
        The Rules Configuration to be used for mapping users to roles. You can specify up to 25 rules per identity provider. Rules are evaluated in order. The first one to match specifies the role.
        """
        return pulumi.get(self, "mapping_rules")


@pulumi.output_type
class IdentityPoolRoleAttachmentRoleMappingMappingRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "matchType":
            suggest = "match_type"
        elif key == "roleArn":
            suggest = "role_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IdentityPoolRoleAttachmentRoleMappingMappingRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IdentityPoolRoleAttachmentRoleMappingMappingRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IdentityPoolRoleAttachmentRoleMappingMappingRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 claim: str,
                 match_type: str,
                 role_arn: str,
                 value: str):
        """
        :param str claim: The claim name that must be present in the token, for example, "isAdmin" or "paid".
        :param str match_type: The match condition that specifies how closely the claim value in the IdP token must match Value.
        :param str role_arn: The role ARN.
        :param str value: A brief string that the claim must match, for example, "paid" or "yes".
        """
        pulumi.set(__self__, "claim", claim)
        pulumi.set(__self__, "match_type", match_type)
        pulumi.set(__self__, "role_arn", role_arn)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def claim(self) -> str:
        """
        The claim name that must be present in the token, for example, "isAdmin" or "paid".
        """
        return pulumi.get(self, "claim")

    @property
    @pulumi.getter(name="matchType")
    def match_type(self) -> str:
        """
        The match condition that specifies how closely the claim value in the IdP token must match Value.
        """
        return pulumi.get(self, "match_type")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> str:
        """
        The role ARN.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        A brief string that the claim must match, for example, "paid" or "yes".
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ManagedUserPoolClientAnalyticsConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "applicationArn":
            suggest = "application_arn"
        elif key == "applicationId":
            suggest = "application_id"
        elif key == "externalId":
            suggest = "external_id"
        elif key == "roleArn":
            suggest = "role_arn"
        elif key == "userDataShared":
            suggest = "user_data_shared"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedUserPoolClientAnalyticsConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedUserPoolClientAnalyticsConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedUserPoolClientAnalyticsConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 application_arn: Optional[str] = None,
                 application_id: Optional[str] = None,
                 external_id: Optional[str] = None,
                 role_arn: Optional[str] = None,
                 user_data_shared: Optional[bool] = None):
        """
        :param str application_arn: Application ARN for an Amazon Pinpoint application. It conflicts with `external_id` and `role_arn`.
        :param str application_id: Unique identifier for an Amazon Pinpoint application.
        :param str external_id: ID for the Analytics Configuration and conflicts with `application_arn`.
        :param str role_arn: ARN of an IAM role that authorizes Amazon Cognito to publish events to Amazon Pinpoint analytics. It conflicts with `application_arn`.
        :param bool user_data_shared: If `user_data_shared` is set to `true`, Amazon Cognito will include user data in the events it publishes to Amazon Pinpoint analytics.
        """
        if application_arn is not None:
            pulumi.set(__self__, "application_arn", application_arn)
        if application_id is not None:
            pulumi.set(__self__, "application_id", application_id)
        if external_id is not None:
            pulumi.set(__self__, "external_id", external_id)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if user_data_shared is not None:
            pulumi.set(__self__, "user_data_shared", user_data_shared)

    @property
    @pulumi.getter(name="applicationArn")
    def application_arn(self) -> Optional[str]:
        """
        Application ARN for an Amazon Pinpoint application. It conflicts with `external_id` and `role_arn`.
        """
        return pulumi.get(self, "application_arn")

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> Optional[str]:
        """
        Unique identifier for an Amazon Pinpoint application.
        """
        return pulumi.get(self, "application_id")

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> Optional[str]:
        """
        ID for the Analytics Configuration and conflicts with `application_arn`.
        """
        return pulumi.get(self, "external_id")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[str]:
        """
        ARN of an IAM role that authorizes Amazon Cognito to publish events to Amazon Pinpoint analytics. It conflicts with `application_arn`.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="userDataShared")
    def user_data_shared(self) -> Optional[bool]:
        """
        If `user_data_shared` is set to `true`, Amazon Cognito will include user data in the events it publishes to Amazon Pinpoint analytics.
        """
        return pulumi.get(self, "user_data_shared")


@pulumi.output_type
class ManagedUserPoolClientTokenValidityUnits(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessToken":
            suggest = "access_token"
        elif key == "idToken":
            suggest = "id_token"
        elif key == "refreshToken":
            suggest = "refresh_token"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedUserPoolClientTokenValidityUnits. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedUserPoolClientTokenValidityUnits.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedUserPoolClientTokenValidityUnits.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_token: Optional[str] = None,
                 id_token: Optional[str] = None,
                 refresh_token: Optional[str] = None):
        """
        :param str access_token: Time unit for the value in `access_token_validity` and defaults to `hours`.
        :param str id_token: Time unit for the value in `id_token_validity`, and it defaults to `hours`.
        :param str refresh_token: Time unit for the value in `refresh_token_validity` and defaults to `days`.
        """
        if access_token is not None:
            pulumi.set(__self__, "access_token", access_token)
        if id_token is not None:
            pulumi.set(__self__, "id_token", id_token)
        if refresh_token is not None:
            pulumi.set(__self__, "refresh_token", refresh_token)

    @property
    @pulumi.getter(name="accessToken")
    def access_token(self) -> Optional[str]:
        """
        Time unit for the value in `access_token_validity` and defaults to `hours`.
        """
        return pulumi.get(self, "access_token")

    @property
    @pulumi.getter(name="idToken")
    def id_token(self) -> Optional[str]:
        """
        Time unit for the value in `id_token_validity`, and it defaults to `hours`.
        """
        return pulumi.get(self, "id_token")

    @property
    @pulumi.getter(name="refreshToken")
    def refresh_token(self) -> Optional[str]:
        """
        Time unit for the value in `refresh_token_validity` and defaults to `days`.
        """
        return pulumi.get(self, "refresh_token")


@pulumi.output_type
class ResourceServerScope(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "scopeDescription":
            suggest = "scope_description"
        elif key == "scopeName":
            suggest = "scope_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceServerScope. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceServerScope.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceServerScope.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 scope_description: str,
                 scope_name: str):
        """
        :param str scope_description: The scope description.
        :param str scope_name: The scope name.
        """
        pulumi.set(__self__, "scope_description", scope_description)
        pulumi.set(__self__, "scope_name", scope_name)

    @property
    @pulumi.getter(name="scopeDescription")
    def scope_description(self) -> str:
        """
        The scope description.
        """
        return pulumi.get(self, "scope_description")

    @property
    @pulumi.getter(name="scopeName")
    def scope_name(self) -> str:
        """
        The scope name.
        """
        return pulumi.get(self, "scope_name")


@pulumi.output_type
class RiskConfigurationAccountTakeoverRiskConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "notifyConfiguration":
            suggest = "notify_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RiskConfigurationAccountTakeoverRiskConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RiskConfigurationAccountTakeoverRiskConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RiskConfigurationAccountTakeoverRiskConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 actions: 'outputs.RiskConfigurationAccountTakeoverRiskConfigurationActions',
                 notify_configuration: 'outputs.RiskConfigurationAccountTakeoverRiskConfigurationNotifyConfiguration'):
        """
        :param 'RiskConfigurationAccountTakeoverRiskConfigurationActionsArgs' actions: Account takeover risk configuration actions. See details below.
        :param 'RiskConfigurationAccountTakeoverRiskConfigurationNotifyConfigurationArgs' notify_configuration: The notify configuration used to construct email notifications. See details below.
        """
        pulumi.set(__self__, "actions", actions)
        pulumi.set(__self__, "notify_configuration", notify_configuration)

    @property
    @pulumi.getter
    def actions(self) -> 'outputs.RiskConfigurationAccountTakeoverRiskConfigurationActions':
        """
        Account takeover risk configuration actions. See details below.
        """
        return pulumi.get(self, "actions")

    @property
    @pulumi.getter(name="notifyConfiguration")
    def notify_configuration(self) -> 'outputs.RiskConfigurationAccountTakeoverRiskConfigurationNotifyConfiguration':
        """
        The notify configuration used to construct email notifications. See details below.
        """
        return pulumi.get(self, "notify_configuration")


@pulumi.output_type
class RiskConfigurationAccountTakeoverRiskConfigurationActions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "highAction":
            suggest = "high_action"
        elif key == "lowAction":
            suggest = "low_action"
        elif key == "mediumAction":
            suggest = "medium_action"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RiskConfigurationAccountTakeoverRiskConfigurationActions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RiskConfigurationAccountTakeoverRiskConfigurationActions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RiskConfigurationAccountTakeoverRiskConfigurationActions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 high_action: Optional['outputs.RiskConfigurationAccountTakeoverRiskConfigurationActionsHighAction'] = None,
                 low_action: Optional['outputs.RiskConfigurationAccountTakeoverRiskConfigurationActionsLowAction'] = None,
                 medium_action: Optional['outputs.RiskConfigurationAccountTakeoverRiskConfigurationActionsMediumAction'] = None):
        """
        :param 'RiskConfigurationAccountTakeoverRiskConfigurationActionsHighActionArgs' high_action: Action to take for a high risk. See action block below.
        :param 'RiskConfigurationAccountTakeoverRiskConfigurationActionsLowActionArgs' low_action: Action to take for a low risk. See action block below.
        :param 'RiskConfigurationAccountTakeoverRiskConfigurationActionsMediumActionArgs' medium_action: Action to take for a medium risk. See action block below.
        """
        if high_action is not None:
            pulumi.set(__self__, "high_action", high_action)
        if low_action is not None:
            pulumi.set(__self__, "low_action", low_action)
        if medium_action is not None:
            pulumi.set(__self__, "medium_action", medium_action)

    @property
    @pulumi.getter(name="highAction")
    def high_action(self) -> Optional['outputs.RiskConfigurationAccountTakeoverRiskConfigurationActionsHighAction']:
        """
        Action to take for a high risk. See action block below.
        """
        return pulumi.get(self, "high_action")

    @property
    @pulumi.getter(name="lowAction")
    def low_action(self) -> Optional['outputs.RiskConfigurationAccountTakeoverRiskConfigurationActionsLowAction']:
        """
        Action to take for a low risk. See action block below.
        """
        return pulumi.get(self, "low_action")

    @property
    @pulumi.getter(name="mediumAction")
    def medium_action(self) -> Optional['outputs.RiskConfigurationAccountTakeoverRiskConfigurationActionsMediumAction']:
        """
        Action to take for a medium risk. See action block below.
        """
        return pulumi.get(self, "medium_action")


@pulumi.output_type
class RiskConfigurationAccountTakeoverRiskConfigurationActionsHighAction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "eventAction":
            suggest = "event_action"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RiskConfigurationAccountTakeoverRiskConfigurationActionsHighAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RiskConfigurationAccountTakeoverRiskConfigurationActionsHighAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RiskConfigurationAccountTakeoverRiskConfigurationActionsHighAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 event_action: str,
                 notify: bool):
        """
        :param str event_action: The action to take in response to the account takeover action. Valid values are `BLOCK`, `MFA_IF_CONFIGURED`, `MFA_REQUIRED` and `NO_ACTION`.
        """
        pulumi.set(__self__, "event_action", event_action)
        pulumi.set(__self__, "notify", notify)

    @property
    @pulumi.getter(name="eventAction")
    def event_action(self) -> str:
        """
        The action to take in response to the account takeover action. Valid values are `BLOCK`, `MFA_IF_CONFIGURED`, `MFA_REQUIRED` and `NO_ACTION`.
        """
        return pulumi.get(self, "event_action")

    @property
    @pulumi.getter
    def notify(self) -> bool:
        return pulumi.get(self, "notify")


@pulumi.output_type
class RiskConfigurationAccountTakeoverRiskConfigurationActionsLowAction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "eventAction":
            suggest = "event_action"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RiskConfigurationAccountTakeoverRiskConfigurationActionsLowAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RiskConfigurationAccountTakeoverRiskConfigurationActionsLowAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RiskConfigurationAccountTakeoverRiskConfigurationActionsLowAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 event_action: str,
                 notify: bool):
        """
        :param str event_action: The action to take in response to the account takeover action. Valid values are `BLOCK`, `MFA_IF_CONFIGURED`, `MFA_REQUIRED` and `NO_ACTION`.
        """
        pulumi.set(__self__, "event_action", event_action)
        pulumi.set(__self__, "notify", notify)

    @property
    @pulumi.getter(name="eventAction")
    def event_action(self) -> str:
        """
        The action to take in response to the account takeover action. Valid values are `BLOCK`, `MFA_IF_CONFIGURED`, `MFA_REQUIRED` and `NO_ACTION`.
        """
        return pulumi.get(self, "event_action")

    @property
    @pulumi.getter
    def notify(self) -> bool:
        return pulumi.get(self, "notify")


@pulumi.output_type
class RiskConfigurationAccountTakeoverRiskConfigurationActionsMediumAction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "eventAction":
            suggest = "event_action"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RiskConfigurationAccountTakeoverRiskConfigurationActionsMediumAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RiskConfigurationAccountTakeoverRiskConfigurationActionsMediumAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RiskConfigurationAccountTakeoverRiskConfigurationActionsMediumAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 event_action: str,
                 notify: bool):
        """
        :param str event_action: The action to take in response to the account takeover action. Valid values are `BLOCK`, `MFA_IF_CONFIGURED`, `MFA_REQUIRED` and `NO_ACTION`.
        """
        pulumi.set(__self__, "event_action", event_action)
        pulumi.set(__self__, "notify", notify)

    @property
    @pulumi.getter(name="eventAction")
    def event_action(self) -> str:
        """
        The action to take in response to the account takeover action. Valid values are `BLOCK`, `MFA_IF_CONFIGURED`, `MFA_REQUIRED` and `NO_ACTION`.
        """
        return pulumi.get(self, "event_action")

    @property
    @pulumi.getter
    def notify(self) -> bool:
        return pulumi.get(self, "notify")


@pulumi.output_type
class RiskConfigurationAccountTakeoverRiskConfigurationNotifyConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceArn":
            suggest = "source_arn"
        elif key == "blockEmail":
            suggest = "block_email"
        elif key == "from":
            suggest = "from_"
        elif key == "mfaEmail":
            suggest = "mfa_email"
        elif key == "noActionEmail":
            suggest = "no_action_email"
        elif key == "replyTo":
            suggest = "reply_to"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RiskConfigurationAccountTakeoverRiskConfigurationNotifyConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RiskConfigurationAccountTakeoverRiskConfigurationNotifyConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RiskConfigurationAccountTakeoverRiskConfigurationNotifyConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_arn: str,
                 block_email: Optional['outputs.RiskConfigurationAccountTakeoverRiskConfigurationNotifyConfigurationBlockEmail'] = None,
                 from_: Optional[str] = None,
                 mfa_email: Optional['outputs.RiskConfigurationAccountTakeoverRiskConfigurationNotifyConfigurationMfaEmail'] = None,
                 no_action_email: Optional['outputs.RiskConfigurationAccountTakeoverRiskConfigurationNotifyConfigurationNoActionEmail'] = None,
                 reply_to: Optional[str] = None):
        """
        :param str source_arn: The Amazon Resource Name (ARN) of the identity that is associated with the sending authorization policy. This identity permits Amazon Cognito to send for the email address specified in the From parameter.
        :param 'RiskConfigurationAccountTakeoverRiskConfigurationNotifyConfigurationBlockEmailArgs' block_email: Email template used when a detected risk event is blocked. See notify email type below.
        :param str from_: The email address that is sending the email. The address must be either individually verified with Amazon Simple Email Service, or from a domain that has been verified with Amazon SES.
        :param 'RiskConfigurationAccountTakeoverRiskConfigurationNotifyConfigurationMfaEmailArgs' mfa_email: The multi-factor authentication (MFA) email template used when MFA is challenged as part of a detected risk. See notify email type below.
        :param 'RiskConfigurationAccountTakeoverRiskConfigurationNotifyConfigurationNoActionEmailArgs' no_action_email: The email template used when a detected risk event is allowed. See notify email type below.
        :param str reply_to: The destination to which the receiver of an email should reply to.
        """
        pulumi.set(__self__, "source_arn", source_arn)
        if block_email is not None:
            pulumi.set(__self__, "block_email", block_email)
        if from_ is not None:
            pulumi.set(__self__, "from_", from_)
        if mfa_email is not None:
            pulumi.set(__self__, "mfa_email", mfa_email)
        if no_action_email is not None:
            pulumi.set(__self__, "no_action_email", no_action_email)
        if reply_to is not None:
            pulumi.set(__self__, "reply_to", reply_to)

    @property
    @pulumi.getter(name="sourceArn")
    def source_arn(self) -> str:
        """
        The Amazon Resource Name (ARN) of the identity that is associated with the sending authorization policy. This identity permits Amazon Cognito to send for the email address specified in the From parameter.
        """
        return pulumi.get(self, "source_arn")

    @property
    @pulumi.getter(name="blockEmail")
    def block_email(self) -> Optional['outputs.RiskConfigurationAccountTakeoverRiskConfigurationNotifyConfigurationBlockEmail']:
        """
        Email template used when a detected risk event is blocked. See notify email type below.
        """
        return pulumi.get(self, "block_email")

    @property
    @pulumi.getter(name="from")
    def from_(self) -> Optional[str]:
        """
        The email address that is sending the email. The address must be either individually verified with Amazon Simple Email Service, or from a domain that has been verified with Amazon SES.
        """
        return pulumi.get(self, "from_")

    @property
    @pulumi.getter(name="mfaEmail")
    def mfa_email(self) -> Optional['outputs.RiskConfigurationAccountTakeoverRiskConfigurationNotifyConfigurationMfaEmail']:
        """
        The multi-factor authentication (MFA) email template used when MFA is challenged as part of a detected risk. See notify email type below.
        """
        return pulumi.get(self, "mfa_email")

    @property
    @pulumi.getter(name="noActionEmail")
    def no_action_email(self) -> Optional['outputs.RiskConfigurationAccountTakeoverRiskConfigurationNotifyConfigurationNoActionEmail']:
        """
        The email template used when a detected risk event is allowed. See notify email type below.
        """
        return pulumi.get(self, "no_action_email")

    @property
    @pulumi.getter(name="replyTo")
    def reply_to(self) -> Optional[str]:
        """
        The destination to which the receiver of an email should reply to.
        """
        return pulumi.get(self, "reply_to")


@pulumi.output_type
class RiskConfigurationAccountTakeoverRiskConfigurationNotifyConfigurationBlockEmail(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "htmlBody":
            suggest = "html_body"
        elif key == "textBody":
            suggest = "text_body"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RiskConfigurationAccountTakeoverRiskConfigurationNotifyConfigurationBlockEmail. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RiskConfigurationAccountTakeoverRiskConfigurationNotifyConfigurationBlockEmail.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RiskConfigurationAccountTakeoverRiskConfigurationNotifyConfigurationBlockEmail.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 html_body: str,
                 subject: str,
                 text_body: str):
        """
        :param str html_body: The email HTML body.
        :param str subject: The email subject.
        :param str text_body: The email text body.
        """
        pulumi.set(__self__, "html_body", html_body)
        pulumi.set(__self__, "subject", subject)
        pulumi.set(__self__, "text_body", text_body)

    @property
    @pulumi.getter(name="htmlBody")
    def html_body(self) -> str:
        """
        The email HTML body.
        """
        return pulumi.get(self, "html_body")

    @property
    @pulumi.getter
    def subject(self) -> str:
        """
        The email subject.
        """
        return pulumi.get(self, "subject")

    @property
    @pulumi.getter(name="textBody")
    def text_body(self) -> str:
        """
        The email text body.
        """
        return pulumi.get(self, "text_body")


@pulumi.output_type
class RiskConfigurationAccountTakeoverRiskConfigurationNotifyConfigurationMfaEmail(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "htmlBody":
            suggest = "html_body"
        elif key == "textBody":
            suggest = "text_body"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RiskConfigurationAccountTakeoverRiskConfigurationNotifyConfigurationMfaEmail. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RiskConfigurationAccountTakeoverRiskConfigurationNotifyConfigurationMfaEmail.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RiskConfigurationAccountTakeoverRiskConfigurationNotifyConfigurationMfaEmail.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 html_body: str,
                 subject: str,
                 text_body: str):
        """
        :param str html_body: The email HTML body.
        :param str subject: The email subject.
        :param str text_body: The email text body.
        """
        pulumi.set(__self__, "html_body", html_body)
        pulumi.set(__self__, "subject", subject)
        pulumi.set(__self__, "text_body", text_body)

    @property
    @pulumi.getter(name="htmlBody")
    def html_body(self) -> str:
        """
        The email HTML body.
        """
        return pulumi.get(self, "html_body")

    @property
    @pulumi.getter
    def subject(self) -> str:
        """
        The email subject.
        """
        return pulumi.get(self, "subject")

    @property
    @pulumi.getter(name="textBody")
    def text_body(self) -> str:
        """
        The email text body.
        """
        return pulumi.get(self, "text_body")


@pulumi.output_type
class RiskConfigurationAccountTakeoverRiskConfigurationNotifyConfigurationNoActionEmail(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "htmlBody":
            suggest = "html_body"
        elif key == "textBody":
            suggest = "text_body"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RiskConfigurationAccountTakeoverRiskConfigurationNotifyConfigurationNoActionEmail. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RiskConfigurationAccountTakeoverRiskConfigurationNotifyConfigurationNoActionEmail.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RiskConfigurationAccountTakeoverRiskConfigurationNotifyConfigurationNoActionEmail.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 html_body: str,
                 subject: str,
                 text_body: str):
        """
        :param str html_body: The email HTML body.
        :param str subject: The email subject.
        :param str text_body: The email text body.
        """
        pulumi.set(__self__, "html_body", html_body)
        pulumi.set(__self__, "subject", subject)
        pulumi.set(__self__, "text_body", text_body)

    @property
    @pulumi.getter(name="htmlBody")
    def html_body(self) -> str:
        """
        The email HTML body.
        """
        return pulumi.get(self, "html_body")

    @property
    @pulumi.getter
    def subject(self) -> str:
        """
        The email subject.
        """
        return pulumi.get(self, "subject")

    @property
    @pulumi.getter(name="textBody")
    def text_body(self) -> str:
        """
        The email text body.
        """
        return pulumi.get(self, "text_body")


@pulumi.output_type
class RiskConfigurationCompromisedCredentialsRiskConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "eventFilters":
            suggest = "event_filters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RiskConfigurationCompromisedCredentialsRiskConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RiskConfigurationCompromisedCredentialsRiskConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RiskConfigurationCompromisedCredentialsRiskConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 actions: 'outputs.RiskConfigurationCompromisedCredentialsRiskConfigurationActions',
                 event_filters: Optional[Sequence[str]] = None):
        """
        :param 'RiskConfigurationCompromisedCredentialsRiskConfigurationActionsArgs' actions: The compromised credentials risk configuration actions. See details below.
        :param Sequence[str] event_filters: Perform the action for these events. The default is to perform all events if no event filter is specified. Valid values are `SIGN_IN`, `PASSWORD_CHANGE`, and `SIGN_UP`.
        """
        pulumi.set(__self__, "actions", actions)
        if event_filters is not None:
            pulumi.set(__self__, "event_filters", event_filters)

    @property
    @pulumi.getter
    def actions(self) -> 'outputs.RiskConfigurationCompromisedCredentialsRiskConfigurationActions':
        """
        The compromised credentials risk configuration actions. See details below.
        """
        return pulumi.get(self, "actions")

    @property
    @pulumi.getter(name="eventFilters")
    def event_filters(self) -> Optional[Sequence[str]]:
        """
        Perform the action for these events. The default is to perform all events if no event filter is specified. Valid values are `SIGN_IN`, `PASSWORD_CHANGE`, and `SIGN_UP`.
        """
        return pulumi.get(self, "event_filters")


@pulumi.output_type
class RiskConfigurationCompromisedCredentialsRiskConfigurationActions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "eventAction":
            suggest = "event_action"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RiskConfigurationCompromisedCredentialsRiskConfigurationActions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RiskConfigurationCompromisedCredentialsRiskConfigurationActions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RiskConfigurationCompromisedCredentialsRiskConfigurationActions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 event_action: str):
        """
        :param str event_action: The event action. Valid values are `BLOCK` or `NO_ACTION`.
        """
        pulumi.set(__self__, "event_action", event_action)

    @property
    @pulumi.getter(name="eventAction")
    def event_action(self) -> str:
        """
        The event action. Valid values are `BLOCK` or `NO_ACTION`.
        """
        return pulumi.get(self, "event_action")


@pulumi.output_type
class RiskConfigurationRiskExceptionConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "blockedIpRangeLists":
            suggest = "blocked_ip_range_lists"
        elif key == "skippedIpRangeLists":
            suggest = "skipped_ip_range_lists"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RiskConfigurationRiskExceptionConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RiskConfigurationRiskExceptionConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RiskConfigurationRiskExceptionConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 blocked_ip_range_lists: Optional[Sequence[str]] = None,
                 skipped_ip_range_lists: Optional[Sequence[str]] = None):
        """
        :param Sequence[str] blocked_ip_range_lists: Overrides the risk decision to always block the pre-authentication requests.
               The IP range is in CIDR notation, a compact representation of an IP address and its routing prefix.
               Can contain a maximum of 200 items.
        :param Sequence[str] skipped_ip_range_lists: Risk detection isn't performed on the IP addresses in this range list.
               The IP range is in CIDR notation.
               Can contain a maximum of 200 items.
        """
        if blocked_ip_range_lists is not None:
            pulumi.set(__self__, "blocked_ip_range_lists", blocked_ip_range_lists)
        if skipped_ip_range_lists is not None:
            pulumi.set(__self__, "skipped_ip_range_lists", skipped_ip_range_lists)

    @property
    @pulumi.getter(name="blockedIpRangeLists")
    def blocked_ip_range_lists(self) -> Optional[Sequence[str]]:
        """
        Overrides the risk decision to always block the pre-authentication requests.
        The IP range is in CIDR notation, a compact representation of an IP address and its routing prefix.
        Can contain a maximum of 200 items.
        """
        return pulumi.get(self, "blocked_ip_range_lists")

    @property
    @pulumi.getter(name="skippedIpRangeLists")
    def skipped_ip_range_lists(self) -> Optional[Sequence[str]]:
        """
        Risk detection isn't performed on the IP addresses in this range list.
        The IP range is in CIDR notation.
        Can contain a maximum of 200 items.
        """
        return pulumi.get(self, "skipped_ip_range_lists")


@pulumi.output_type
class UserPoolAccountRecoverySetting(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "recoveryMechanisms":
            suggest = "recovery_mechanisms"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserPoolAccountRecoverySetting. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserPoolAccountRecoverySetting.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserPoolAccountRecoverySetting.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 recovery_mechanisms: Optional[Sequence['outputs.UserPoolAccountRecoverySettingRecoveryMechanism']] = None):
        """
        :param Sequence['UserPoolAccountRecoverySettingRecoveryMechanismArgs'] recovery_mechanisms: List of Account Recovery Options of the following structure:
        """
        if recovery_mechanisms is not None:
            pulumi.set(__self__, "recovery_mechanisms", recovery_mechanisms)

    @property
    @pulumi.getter(name="recoveryMechanisms")
    def recovery_mechanisms(self) -> Optional[Sequence['outputs.UserPoolAccountRecoverySettingRecoveryMechanism']]:
        """
        List of Account Recovery Options of the following structure:
        """
        return pulumi.get(self, "recovery_mechanisms")


@pulumi.output_type
class UserPoolAccountRecoverySettingRecoveryMechanism(dict):
    def __init__(__self__, *,
                 name: str,
                 priority: int):
        """
        :param str name: Name of the user pool.
               
               The following arguments are optional:
        :param int priority: Positive integer specifying priority of a method with 1 being the highest priority.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "priority", priority)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the user pool.

        The following arguments are optional:
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def priority(self) -> int:
        """
        Positive integer specifying priority of a method with 1 being the highest priority.
        """
        return pulumi.get(self, "priority")


@pulumi.output_type
class UserPoolAdminCreateUserConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowAdminCreateUserOnly":
            suggest = "allow_admin_create_user_only"
        elif key == "inviteMessageTemplate":
            suggest = "invite_message_template"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserPoolAdminCreateUserConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserPoolAdminCreateUserConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserPoolAdminCreateUserConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_admin_create_user_only: Optional[bool] = None,
                 invite_message_template: Optional['outputs.UserPoolAdminCreateUserConfigInviteMessageTemplate'] = None):
        """
        :param bool allow_admin_create_user_only: Set to True if only the administrator is allowed to create user profiles. Set to False if users can sign themselves up via an app.
        :param 'UserPoolAdminCreateUserConfigInviteMessageTemplateArgs' invite_message_template: Invite message template structure. Detailed below.
        """
        if allow_admin_create_user_only is not None:
            pulumi.set(__self__, "allow_admin_create_user_only", allow_admin_create_user_only)
        if invite_message_template is not None:
            pulumi.set(__self__, "invite_message_template", invite_message_template)

    @property
    @pulumi.getter(name="allowAdminCreateUserOnly")
    def allow_admin_create_user_only(self) -> Optional[bool]:
        """
        Set to True if only the administrator is allowed to create user profiles. Set to False if users can sign themselves up via an app.
        """
        return pulumi.get(self, "allow_admin_create_user_only")

    @property
    @pulumi.getter(name="inviteMessageTemplate")
    def invite_message_template(self) -> Optional['outputs.UserPoolAdminCreateUserConfigInviteMessageTemplate']:
        """
        Invite message template structure. Detailed below.
        """
        return pulumi.get(self, "invite_message_template")


@pulumi.output_type
class UserPoolAdminCreateUserConfigInviteMessageTemplate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "emailMessage":
            suggest = "email_message"
        elif key == "emailSubject":
            suggest = "email_subject"
        elif key == "smsMessage":
            suggest = "sms_message"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserPoolAdminCreateUserConfigInviteMessageTemplate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserPoolAdminCreateUserConfigInviteMessageTemplate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserPoolAdminCreateUserConfigInviteMessageTemplate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 email_message: Optional[str] = None,
                 email_subject: Optional[str] = None,
                 sms_message: Optional[str] = None):
        """
        :param str email_message: Message template for email messages. Must contain `{username}` and `{####}` placeholders, for username and temporary password, respectively.
        :param str email_subject: Subject line for email messages.
        :param str sms_message: Message template for SMS messages. Must contain `{username}` and `{####}` placeholders, for username and temporary password, respectively.
        """
        if email_message is not None:
            pulumi.set(__self__, "email_message", email_message)
        if email_subject is not None:
            pulumi.set(__self__, "email_subject", email_subject)
        if sms_message is not None:
            pulumi.set(__self__, "sms_message", sms_message)

    @property
    @pulumi.getter(name="emailMessage")
    def email_message(self) -> Optional[str]:
        """
        Message template for email messages. Must contain `{username}` and `{####}` placeholders, for username and temporary password, respectively.
        """
        return pulumi.get(self, "email_message")

    @property
    @pulumi.getter(name="emailSubject")
    def email_subject(self) -> Optional[str]:
        """
        Subject line for email messages.
        """
        return pulumi.get(self, "email_subject")

    @property
    @pulumi.getter(name="smsMessage")
    def sms_message(self) -> Optional[str]:
        """
        Message template for SMS messages. Must contain `{username}` and `{####}` placeholders, for username and temporary password, respectively.
        """
        return pulumi.get(self, "sms_message")


@pulumi.output_type
class UserPoolClientAnalyticsConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "applicationArn":
            suggest = "application_arn"
        elif key == "applicationId":
            suggest = "application_id"
        elif key == "externalId":
            suggest = "external_id"
        elif key == "roleArn":
            suggest = "role_arn"
        elif key == "userDataShared":
            suggest = "user_data_shared"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserPoolClientAnalyticsConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserPoolClientAnalyticsConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserPoolClientAnalyticsConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 application_arn: Optional[str] = None,
                 application_id: Optional[str] = None,
                 external_id: Optional[str] = None,
                 role_arn: Optional[str] = None,
                 user_data_shared: Optional[bool] = None):
        """
        :param str application_arn: Application ARN for an Amazon Pinpoint application. Conflicts with `external_id` and `role_arn`.
        :param str application_id: Application ID for an Amazon Pinpoint application.
        :param str external_id: ID for the Analytics Configuration. Conflicts with `application_arn`.
        :param str role_arn: ARN of an IAM role that authorizes Amazon Cognito to publish events to Amazon Pinpoint analytics. Conflicts with `application_arn`.
        :param bool user_data_shared: If set to `true`, Amazon Cognito will include user data in the events it publishes to Amazon Pinpoint analytics.
        """
        if application_arn is not None:
            pulumi.set(__self__, "application_arn", application_arn)
        if application_id is not None:
            pulumi.set(__self__, "application_id", application_id)
        if external_id is not None:
            pulumi.set(__self__, "external_id", external_id)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if user_data_shared is not None:
            pulumi.set(__self__, "user_data_shared", user_data_shared)

    @property
    @pulumi.getter(name="applicationArn")
    def application_arn(self) -> Optional[str]:
        """
        Application ARN for an Amazon Pinpoint application. Conflicts with `external_id` and `role_arn`.
        """
        return pulumi.get(self, "application_arn")

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> Optional[str]:
        """
        Application ID for an Amazon Pinpoint application.
        """
        return pulumi.get(self, "application_id")

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> Optional[str]:
        """
        ID for the Analytics Configuration. Conflicts with `application_arn`.
        """
        return pulumi.get(self, "external_id")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[str]:
        """
        ARN of an IAM role that authorizes Amazon Cognito to publish events to Amazon Pinpoint analytics. Conflicts with `application_arn`.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="userDataShared")
    def user_data_shared(self) -> Optional[bool]:
        """
        If set to `true`, Amazon Cognito will include user data in the events it publishes to Amazon Pinpoint analytics.
        """
        return pulumi.get(self, "user_data_shared")


@pulumi.output_type
class UserPoolClientTokenValidityUnits(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessToken":
            suggest = "access_token"
        elif key == "idToken":
            suggest = "id_token"
        elif key == "refreshToken":
            suggest = "refresh_token"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserPoolClientTokenValidityUnits. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserPoolClientTokenValidityUnits.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserPoolClientTokenValidityUnits.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_token: Optional[str] = None,
                 id_token: Optional[str] = None,
                 refresh_token: Optional[str] = None):
        """
        :param str access_token: Time unit in for the value in `access_token_validity`, defaults to `hours`.
        :param str id_token: Time unit in for the value in `id_token_validity`, defaults to `hours`.
        :param str refresh_token: Time unit in for the value in `refresh_token_validity`, defaults to `days`.
        """
        if access_token is not None:
            pulumi.set(__self__, "access_token", access_token)
        if id_token is not None:
            pulumi.set(__self__, "id_token", id_token)
        if refresh_token is not None:
            pulumi.set(__self__, "refresh_token", refresh_token)

    @property
    @pulumi.getter(name="accessToken")
    def access_token(self) -> Optional[str]:
        """
        Time unit in for the value in `access_token_validity`, defaults to `hours`.
        """
        return pulumi.get(self, "access_token")

    @property
    @pulumi.getter(name="idToken")
    def id_token(self) -> Optional[str]:
        """
        Time unit in for the value in `id_token_validity`, defaults to `hours`.
        """
        return pulumi.get(self, "id_token")

    @property
    @pulumi.getter(name="refreshToken")
    def refresh_token(self) -> Optional[str]:
        """
        Time unit in for the value in `refresh_token_validity`, defaults to `days`.
        """
        return pulumi.get(self, "refresh_token")


@pulumi.output_type
class UserPoolDeviceConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "challengeRequiredOnNewDevice":
            suggest = "challenge_required_on_new_device"
        elif key == "deviceOnlyRememberedOnUserPrompt":
            suggest = "device_only_remembered_on_user_prompt"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserPoolDeviceConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserPoolDeviceConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserPoolDeviceConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 challenge_required_on_new_device: Optional[bool] = None,
                 device_only_remembered_on_user_prompt: Optional[bool] = None):
        """
        :param bool challenge_required_on_new_device: Whether a challenge is required on a new device. Only applicable to a new device.
        :param bool device_only_remembered_on_user_prompt: Whether a device is only remembered on user prompt. `false` equates to "Always" remember, `true` is "User Opt In," and not using a `device_configuration` block is "No."
        """
        if challenge_required_on_new_device is not None:
            pulumi.set(__self__, "challenge_required_on_new_device", challenge_required_on_new_device)
        if device_only_remembered_on_user_prompt is not None:
            pulumi.set(__self__, "device_only_remembered_on_user_prompt", device_only_remembered_on_user_prompt)

    @property
    @pulumi.getter(name="challengeRequiredOnNewDevice")
    def challenge_required_on_new_device(self) -> Optional[bool]:
        """
        Whether a challenge is required on a new device. Only applicable to a new device.
        """
        return pulumi.get(self, "challenge_required_on_new_device")

    @property
    @pulumi.getter(name="deviceOnlyRememberedOnUserPrompt")
    def device_only_remembered_on_user_prompt(self) -> Optional[bool]:
        """
        Whether a device is only remembered on user prompt. `false` equates to "Always" remember, `true` is "User Opt In," and not using a `device_configuration` block is "No."
        """
        return pulumi.get(self, "device_only_remembered_on_user_prompt")


@pulumi.output_type
class UserPoolEmailConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "configurationSet":
            suggest = "configuration_set"
        elif key == "emailSendingAccount":
            suggest = "email_sending_account"
        elif key == "fromEmailAddress":
            suggest = "from_email_address"
        elif key == "replyToEmailAddress":
            suggest = "reply_to_email_address"
        elif key == "sourceArn":
            suggest = "source_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserPoolEmailConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserPoolEmailConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserPoolEmailConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 configuration_set: Optional[str] = None,
                 email_sending_account: Optional[str] = None,
                 from_email_address: Optional[str] = None,
                 reply_to_email_address: Optional[str] = None,
                 source_arn: Optional[str] = None):
        """
        :param str configuration_set: Email configuration set name from SES.
        :param str email_sending_account: Email delivery method to use. `COGNITO_DEFAULT` for the default email functionality built into Cognito or `DEVELOPER` to use your Amazon SES configuration. Required to be `DEVELOPER` if `from_email_address` is set.
        :param str from_email_address: Sender’s email address or sender’s display name with their email address (e.g., `john@example.com`, `John Smith <john@example.com>` or `\\"John Smith Ph.D.\\" <john@example.com>`). Escaped double quotes are required around display names that contain certain characters as specified in [RFC 5322](https://tools.ietf.org/html/rfc5322).
        :param str reply_to_email_address: REPLY-TO email address.
        :param str source_arn: ARN of the SES verified email identity to use. Required if `email_sending_account` is set to `DEVELOPER`.
        """
        if configuration_set is not None:
            pulumi.set(__self__, "configuration_set", configuration_set)
        if email_sending_account is not None:
            pulumi.set(__self__, "email_sending_account", email_sending_account)
        if from_email_address is not None:
            pulumi.set(__self__, "from_email_address", from_email_address)
        if reply_to_email_address is not None:
            pulumi.set(__self__, "reply_to_email_address", reply_to_email_address)
        if source_arn is not None:
            pulumi.set(__self__, "source_arn", source_arn)

    @property
    @pulumi.getter(name="configurationSet")
    def configuration_set(self) -> Optional[str]:
        """
        Email configuration set name from SES.
        """
        return pulumi.get(self, "configuration_set")

    @property
    @pulumi.getter(name="emailSendingAccount")
    def email_sending_account(self) -> Optional[str]:
        """
        Email delivery method to use. `COGNITO_DEFAULT` for the default email functionality built into Cognito or `DEVELOPER` to use your Amazon SES configuration. Required to be `DEVELOPER` if `from_email_address` is set.
        """
        return pulumi.get(self, "email_sending_account")

    @property
    @pulumi.getter(name="fromEmailAddress")
    def from_email_address(self) -> Optional[str]:
        """
        Sender’s email address or sender’s display name with their email address (e.g., `john@example.com`, `John Smith <john@example.com>` or `\\"John Smith Ph.D.\\" <john@example.com>`). Escaped double quotes are required around display names that contain certain characters as specified in [RFC 5322](https://tools.ietf.org/html/rfc5322).
        """
        return pulumi.get(self, "from_email_address")

    @property
    @pulumi.getter(name="replyToEmailAddress")
    def reply_to_email_address(self) -> Optional[str]:
        """
        REPLY-TO email address.
        """
        return pulumi.get(self, "reply_to_email_address")

    @property
    @pulumi.getter(name="sourceArn")
    def source_arn(self) -> Optional[str]:
        """
        ARN of the SES verified email identity to use. Required if `email_sending_account` is set to `DEVELOPER`.
        """
        return pulumi.get(self, "source_arn")


@pulumi.output_type
class UserPoolLambdaConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createAuthChallenge":
            suggest = "create_auth_challenge"
        elif key == "customEmailSender":
            suggest = "custom_email_sender"
        elif key == "customMessage":
            suggest = "custom_message"
        elif key == "customSmsSender":
            suggest = "custom_sms_sender"
        elif key == "defineAuthChallenge":
            suggest = "define_auth_challenge"
        elif key == "kmsKeyId":
            suggest = "kms_key_id"
        elif key == "postAuthentication":
            suggest = "post_authentication"
        elif key == "postConfirmation":
            suggest = "post_confirmation"
        elif key == "preAuthentication":
            suggest = "pre_authentication"
        elif key == "preSignUp":
            suggest = "pre_sign_up"
        elif key == "preTokenGeneration":
            suggest = "pre_token_generation"
        elif key == "userMigration":
            suggest = "user_migration"
        elif key == "verifyAuthChallengeResponse":
            suggest = "verify_auth_challenge_response"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserPoolLambdaConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserPoolLambdaConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserPoolLambdaConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 create_auth_challenge: Optional[str] = None,
                 custom_email_sender: Optional['outputs.UserPoolLambdaConfigCustomEmailSender'] = None,
                 custom_message: Optional[str] = None,
                 custom_sms_sender: Optional['outputs.UserPoolLambdaConfigCustomSmsSender'] = None,
                 define_auth_challenge: Optional[str] = None,
                 kms_key_id: Optional[str] = None,
                 post_authentication: Optional[str] = None,
                 post_confirmation: Optional[str] = None,
                 pre_authentication: Optional[str] = None,
                 pre_sign_up: Optional[str] = None,
                 pre_token_generation: Optional[str] = None,
                 user_migration: Optional[str] = None,
                 verify_auth_challenge_response: Optional[str] = None):
        """
        :param str create_auth_challenge: ARN of the lambda creating an authentication challenge.
        :param 'UserPoolLambdaConfigCustomEmailSenderArgs' custom_email_sender: A custom email sender AWS Lambda trigger. See custom_email_sender Below.
        :param str custom_message: Custom Message AWS Lambda trigger.
        :param 'UserPoolLambdaConfigCustomSmsSenderArgs' custom_sms_sender: A custom SMS sender AWS Lambda trigger. See custom_sms_sender Below.
        :param str define_auth_challenge: Defines the authentication challenge.
        :param str kms_key_id: The Amazon Resource Name of Key Management Service Customer master keys. Amazon Cognito uses the key to encrypt codes and temporary passwords sent to CustomEmailSender and CustomSMSSender.
        :param str post_authentication: Post-authentication AWS Lambda trigger.
        :param str post_confirmation: Post-confirmation AWS Lambda trigger.
        :param str pre_authentication: Pre-authentication AWS Lambda trigger.
        :param str pre_sign_up: Pre-registration AWS Lambda trigger.
        :param str pre_token_generation: Allow to customize identity token claims before token generation.
        :param str user_migration: User migration Lambda config type.
        :param str verify_auth_challenge_response: Verifies the authentication challenge response.
        """
        if create_auth_challenge is not None:
            pulumi.set(__self__, "create_auth_challenge", create_auth_challenge)
        if custom_email_sender is not None:
            pulumi.set(__self__, "custom_email_sender", custom_email_sender)
        if custom_message is not None:
            pulumi.set(__self__, "custom_message", custom_message)
        if custom_sms_sender is not None:
            pulumi.set(__self__, "custom_sms_sender", custom_sms_sender)
        if define_auth_challenge is not None:
            pulumi.set(__self__, "define_auth_challenge", define_auth_challenge)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if post_authentication is not None:
            pulumi.set(__self__, "post_authentication", post_authentication)
        if post_confirmation is not None:
            pulumi.set(__self__, "post_confirmation", post_confirmation)
        if pre_authentication is not None:
            pulumi.set(__self__, "pre_authentication", pre_authentication)
        if pre_sign_up is not None:
            pulumi.set(__self__, "pre_sign_up", pre_sign_up)
        if pre_token_generation is not None:
            pulumi.set(__self__, "pre_token_generation", pre_token_generation)
        if user_migration is not None:
            pulumi.set(__self__, "user_migration", user_migration)
        if verify_auth_challenge_response is not None:
            pulumi.set(__self__, "verify_auth_challenge_response", verify_auth_challenge_response)

    @property
    @pulumi.getter(name="createAuthChallenge")
    def create_auth_challenge(self) -> Optional[str]:
        """
        ARN of the lambda creating an authentication challenge.
        """
        return pulumi.get(self, "create_auth_challenge")

    @property
    @pulumi.getter(name="customEmailSender")
    def custom_email_sender(self) -> Optional['outputs.UserPoolLambdaConfigCustomEmailSender']:
        """
        A custom email sender AWS Lambda trigger. See custom_email_sender Below.
        """
        return pulumi.get(self, "custom_email_sender")

    @property
    @pulumi.getter(name="customMessage")
    def custom_message(self) -> Optional[str]:
        """
        Custom Message AWS Lambda trigger.
        """
        return pulumi.get(self, "custom_message")

    @property
    @pulumi.getter(name="customSmsSender")
    def custom_sms_sender(self) -> Optional['outputs.UserPoolLambdaConfigCustomSmsSender']:
        """
        A custom SMS sender AWS Lambda trigger. See custom_sms_sender Below.
        """
        return pulumi.get(self, "custom_sms_sender")

    @property
    @pulumi.getter(name="defineAuthChallenge")
    def define_auth_challenge(self) -> Optional[str]:
        """
        Defines the authentication challenge.
        """
        return pulumi.get(self, "define_auth_challenge")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[str]:
        """
        The Amazon Resource Name of Key Management Service Customer master keys. Amazon Cognito uses the key to encrypt codes and temporary passwords sent to CustomEmailSender and CustomSMSSender.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="postAuthentication")
    def post_authentication(self) -> Optional[str]:
        """
        Post-authentication AWS Lambda trigger.
        """
        return pulumi.get(self, "post_authentication")

    @property
    @pulumi.getter(name="postConfirmation")
    def post_confirmation(self) -> Optional[str]:
        """
        Post-confirmation AWS Lambda trigger.
        """
        return pulumi.get(self, "post_confirmation")

    @property
    @pulumi.getter(name="preAuthentication")
    def pre_authentication(self) -> Optional[str]:
        """
        Pre-authentication AWS Lambda trigger.
        """
        return pulumi.get(self, "pre_authentication")

    @property
    @pulumi.getter(name="preSignUp")
    def pre_sign_up(self) -> Optional[str]:
        """
        Pre-registration AWS Lambda trigger.
        """
        return pulumi.get(self, "pre_sign_up")

    @property
    @pulumi.getter(name="preTokenGeneration")
    def pre_token_generation(self) -> Optional[str]:
        """
        Allow to customize identity token claims before token generation.
        """
        return pulumi.get(self, "pre_token_generation")

    @property
    @pulumi.getter(name="userMigration")
    def user_migration(self) -> Optional[str]:
        """
        User migration Lambda config type.
        """
        return pulumi.get(self, "user_migration")

    @property
    @pulumi.getter(name="verifyAuthChallengeResponse")
    def verify_auth_challenge_response(self) -> Optional[str]:
        """
        Verifies the authentication challenge response.
        """
        return pulumi.get(self, "verify_auth_challenge_response")


@pulumi.output_type
class UserPoolLambdaConfigCustomEmailSender(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lambdaArn":
            suggest = "lambda_arn"
        elif key == "lambdaVersion":
            suggest = "lambda_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserPoolLambdaConfigCustomEmailSender. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserPoolLambdaConfigCustomEmailSender.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserPoolLambdaConfigCustomEmailSender.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 lambda_arn: str,
                 lambda_version: str):
        """
        :param str lambda_arn: The Lambda Amazon Resource Name of the Lambda function that Amazon Cognito triggers to send email notifications to users.
        :param str lambda_version: The Lambda version represents the signature of the "request" attribute in the "event" information Amazon Cognito passes to your custom email Lambda function. The only supported value is `V1_0`.
        """
        pulumi.set(__self__, "lambda_arn", lambda_arn)
        pulumi.set(__self__, "lambda_version", lambda_version)

    @property
    @pulumi.getter(name="lambdaArn")
    def lambda_arn(self) -> str:
        """
        The Lambda Amazon Resource Name of the Lambda function that Amazon Cognito triggers to send email notifications to users.
        """
        return pulumi.get(self, "lambda_arn")

    @property
    @pulumi.getter(name="lambdaVersion")
    def lambda_version(self) -> str:
        """
        The Lambda version represents the signature of the "request" attribute in the "event" information Amazon Cognito passes to your custom email Lambda function. The only supported value is `V1_0`.
        """
        return pulumi.get(self, "lambda_version")


@pulumi.output_type
class UserPoolLambdaConfigCustomSmsSender(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lambdaArn":
            suggest = "lambda_arn"
        elif key == "lambdaVersion":
            suggest = "lambda_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserPoolLambdaConfigCustomSmsSender. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserPoolLambdaConfigCustomSmsSender.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserPoolLambdaConfigCustomSmsSender.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 lambda_arn: str,
                 lambda_version: str):
        """
        :param str lambda_arn: The Lambda Amazon Resource Name of the Lambda function that Amazon Cognito triggers to send SMS notifications to users.
        :param str lambda_version: The Lambda version represents the signature of the "request" attribute in the "event" information Amazon Cognito passes to your custom SMS Lambda function. The only supported value is `V1_0`.
        """
        pulumi.set(__self__, "lambda_arn", lambda_arn)
        pulumi.set(__self__, "lambda_version", lambda_version)

    @property
    @pulumi.getter(name="lambdaArn")
    def lambda_arn(self) -> str:
        """
        The Lambda Amazon Resource Name of the Lambda function that Amazon Cognito triggers to send SMS notifications to users.
        """
        return pulumi.get(self, "lambda_arn")

    @property
    @pulumi.getter(name="lambdaVersion")
    def lambda_version(self) -> str:
        """
        The Lambda version represents the signature of the "request" attribute in the "event" information Amazon Cognito passes to your custom SMS Lambda function. The only supported value is `V1_0`.
        """
        return pulumi.get(self, "lambda_version")


@pulumi.output_type
class UserPoolPasswordPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "minimumLength":
            suggest = "minimum_length"
        elif key == "requireLowercase":
            suggest = "require_lowercase"
        elif key == "requireNumbers":
            suggest = "require_numbers"
        elif key == "requireSymbols":
            suggest = "require_symbols"
        elif key == "requireUppercase":
            suggest = "require_uppercase"
        elif key == "temporaryPasswordValidityDays":
            suggest = "temporary_password_validity_days"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserPoolPasswordPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserPoolPasswordPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserPoolPasswordPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 minimum_length: Optional[int] = None,
                 require_lowercase: Optional[bool] = None,
                 require_numbers: Optional[bool] = None,
                 require_symbols: Optional[bool] = None,
                 require_uppercase: Optional[bool] = None,
                 temporary_password_validity_days: Optional[int] = None):
        """
        :param int minimum_length: Minimum length of the password policy that you have set.
        :param bool require_lowercase: Whether you have required users to use at least one lowercase letter in their password.
        :param bool require_numbers: Whether you have required users to use at least one number in their password.
        :param bool require_symbols: Whether you have required users to use at least one symbol in their password.
        :param bool require_uppercase: Whether you have required users to use at least one uppercase letter in their password.
        :param int temporary_password_validity_days: In the password policy you have set, refers to the number of days a temporary password is valid. If the user does not sign-in during this time, their password will need to be reset by an administrator.
        """
        if minimum_length is not None:
            pulumi.set(__self__, "minimum_length", minimum_length)
        if require_lowercase is not None:
            pulumi.set(__self__, "require_lowercase", require_lowercase)
        if require_numbers is not None:
            pulumi.set(__self__, "require_numbers", require_numbers)
        if require_symbols is not None:
            pulumi.set(__self__, "require_symbols", require_symbols)
        if require_uppercase is not None:
            pulumi.set(__self__, "require_uppercase", require_uppercase)
        if temporary_password_validity_days is not None:
            pulumi.set(__self__, "temporary_password_validity_days", temporary_password_validity_days)

    @property
    @pulumi.getter(name="minimumLength")
    def minimum_length(self) -> Optional[int]:
        """
        Minimum length of the password policy that you have set.
        """
        return pulumi.get(self, "minimum_length")

    @property
    @pulumi.getter(name="requireLowercase")
    def require_lowercase(self) -> Optional[bool]:
        """
        Whether you have required users to use at least one lowercase letter in their password.
        """
        return pulumi.get(self, "require_lowercase")

    @property
    @pulumi.getter(name="requireNumbers")
    def require_numbers(self) -> Optional[bool]:
        """
        Whether you have required users to use at least one number in their password.
        """
        return pulumi.get(self, "require_numbers")

    @property
    @pulumi.getter(name="requireSymbols")
    def require_symbols(self) -> Optional[bool]:
        """
        Whether you have required users to use at least one symbol in their password.
        """
        return pulumi.get(self, "require_symbols")

    @property
    @pulumi.getter(name="requireUppercase")
    def require_uppercase(self) -> Optional[bool]:
        """
        Whether you have required users to use at least one uppercase letter in their password.
        """
        return pulumi.get(self, "require_uppercase")

    @property
    @pulumi.getter(name="temporaryPasswordValidityDays")
    def temporary_password_validity_days(self) -> Optional[int]:
        """
        In the password policy you have set, refers to the number of days a temporary password is valid. If the user does not sign-in during this time, their password will need to be reset by an administrator.
        """
        return pulumi.get(self, "temporary_password_validity_days")


@pulumi.output_type
class UserPoolSchema(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "attributeDataType":
            suggest = "attribute_data_type"
        elif key == "developerOnlyAttribute":
            suggest = "developer_only_attribute"
        elif key == "numberAttributeConstraints":
            suggest = "number_attribute_constraints"
        elif key == "stringAttributeConstraints":
            suggest = "string_attribute_constraints"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserPoolSchema. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserPoolSchema.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserPoolSchema.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 attribute_data_type: str,
                 name: str,
                 developer_only_attribute: Optional[bool] = None,
                 mutable: Optional[bool] = None,
                 number_attribute_constraints: Optional['outputs.UserPoolSchemaNumberAttributeConstraints'] = None,
                 required: Optional[bool] = None,
                 string_attribute_constraints: Optional['outputs.UserPoolSchemaStringAttributeConstraints'] = None):
        """
        :param str attribute_data_type: Attribute data type. Must be one of `Boolean`, `Number`, `String`, `DateTime`.
        :param str name: Name of the attribute.
        :param bool developer_only_attribute: Whether the attribute type is developer only.
        :param bool mutable: Whether the attribute can be changed once it has been created.
        :param 'UserPoolSchemaNumberAttributeConstraintsArgs' number_attribute_constraints: Configuration block for the constraints for an attribute of the number type. Detailed below.
        :param bool required: Whether a user pool attribute is required. If the attribute is required and the user does not provide a value, registration or sign-in will fail.
        :param 'UserPoolSchemaStringAttributeConstraintsArgs' string_attribute_constraints: Constraints for an attribute of the string type. Detailed below.
        """
        pulumi.set(__self__, "attribute_data_type", attribute_data_type)
        pulumi.set(__self__, "name", name)
        if developer_only_attribute is not None:
            pulumi.set(__self__, "developer_only_attribute", developer_only_attribute)
        if mutable is not None:
            pulumi.set(__self__, "mutable", mutable)
        if number_attribute_constraints is not None:
            pulumi.set(__self__, "number_attribute_constraints", number_attribute_constraints)
        if required is not None:
            pulumi.set(__self__, "required", required)
        if string_attribute_constraints is not None:
            pulumi.set(__self__, "string_attribute_constraints", string_attribute_constraints)

    @property
    @pulumi.getter(name="attributeDataType")
    def attribute_data_type(self) -> str:
        """
        Attribute data type. Must be one of `Boolean`, `Number`, `String`, `DateTime`.
        """
        return pulumi.get(self, "attribute_data_type")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the attribute.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="developerOnlyAttribute")
    def developer_only_attribute(self) -> Optional[bool]:
        """
        Whether the attribute type is developer only.
        """
        return pulumi.get(self, "developer_only_attribute")

    @property
    @pulumi.getter
    def mutable(self) -> Optional[bool]:
        """
        Whether the attribute can be changed once it has been created.
        """
        return pulumi.get(self, "mutable")

    @property
    @pulumi.getter(name="numberAttributeConstraints")
    def number_attribute_constraints(self) -> Optional['outputs.UserPoolSchemaNumberAttributeConstraints']:
        """
        Configuration block for the constraints for an attribute of the number type. Detailed below.
        """
        return pulumi.get(self, "number_attribute_constraints")

    @property
    @pulumi.getter
    def required(self) -> Optional[bool]:
        """
        Whether a user pool attribute is required. If the attribute is required and the user does not provide a value, registration or sign-in will fail.
        """
        return pulumi.get(self, "required")

    @property
    @pulumi.getter(name="stringAttributeConstraints")
    def string_attribute_constraints(self) -> Optional['outputs.UserPoolSchemaStringAttributeConstraints']:
        """
        Constraints for an attribute of the string type. Detailed below.
        """
        return pulumi.get(self, "string_attribute_constraints")


@pulumi.output_type
class UserPoolSchemaNumberAttributeConstraints(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxValue":
            suggest = "max_value"
        elif key == "minValue":
            suggest = "min_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserPoolSchemaNumberAttributeConstraints. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserPoolSchemaNumberAttributeConstraints.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserPoolSchemaNumberAttributeConstraints.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_value: Optional[str] = None,
                 min_value: Optional[str] = None):
        """
        :param str max_value: Maximum value of an attribute that is of the number data type.
        :param str min_value: Minimum value of an attribute that is of the number data type.
        """
        if max_value is not None:
            pulumi.set(__self__, "max_value", max_value)
        if min_value is not None:
            pulumi.set(__self__, "min_value", min_value)

    @property
    @pulumi.getter(name="maxValue")
    def max_value(self) -> Optional[str]:
        """
        Maximum value of an attribute that is of the number data type.
        """
        return pulumi.get(self, "max_value")

    @property
    @pulumi.getter(name="minValue")
    def min_value(self) -> Optional[str]:
        """
        Minimum value of an attribute that is of the number data type.
        """
        return pulumi.get(self, "min_value")


@pulumi.output_type
class UserPoolSchemaStringAttributeConstraints(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxLength":
            suggest = "max_length"
        elif key == "minLength":
            suggest = "min_length"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserPoolSchemaStringAttributeConstraints. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserPoolSchemaStringAttributeConstraints.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserPoolSchemaStringAttributeConstraints.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_length: Optional[str] = None,
                 min_length: Optional[str] = None):
        """
        :param str max_length: Maximum length of an attribute value of the string type.
        :param str min_length: Minimum length of an attribute value of the string type.
        """
        if max_length is not None:
            pulumi.set(__self__, "max_length", max_length)
        if min_length is not None:
            pulumi.set(__self__, "min_length", min_length)

    @property
    @pulumi.getter(name="maxLength")
    def max_length(self) -> Optional[str]:
        """
        Maximum length of an attribute value of the string type.
        """
        return pulumi.get(self, "max_length")

    @property
    @pulumi.getter(name="minLength")
    def min_length(self) -> Optional[str]:
        """
        Minimum length of an attribute value of the string type.
        """
        return pulumi.get(self, "min_length")


@pulumi.output_type
class UserPoolSmsConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "externalId":
            suggest = "external_id"
        elif key == "snsCallerArn":
            suggest = "sns_caller_arn"
        elif key == "snsRegion":
            suggest = "sns_region"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserPoolSmsConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserPoolSmsConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserPoolSmsConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 external_id: str,
                 sns_caller_arn: str,
                 sns_region: Optional[str] = None):
        """
        :param str external_id: External ID used in IAM role trust relationships. For more information about using external IDs, see [How to Use an External ID When Granting Access to Your AWS Resources to a Third Party](http://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_create_for-user_externalid.html).
        :param str sns_caller_arn: ARN of the Amazon SNS caller. This is usually the IAM role that you've given Cognito permission to assume.
        :param str sns_region: The AWS Region to use with Amazon SNS integration. You can choose the same Region as your user pool, or a supported Legacy Amazon SNS alternate Region. Amazon Cognito resources in the Asia Pacific (Seoul) AWS Region must use your Amazon SNS configuration in the Asia Pacific (Tokyo) Region. For more information, see [SMS message settings for Amazon Cognito user pools](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html).
        """
        pulumi.set(__self__, "external_id", external_id)
        pulumi.set(__self__, "sns_caller_arn", sns_caller_arn)
        if sns_region is not None:
            pulumi.set(__self__, "sns_region", sns_region)

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> str:
        """
        External ID used in IAM role trust relationships. For more information about using external IDs, see [How to Use an External ID When Granting Access to Your AWS Resources to a Third Party](http://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_create_for-user_externalid.html).
        """
        return pulumi.get(self, "external_id")

    @property
    @pulumi.getter(name="snsCallerArn")
    def sns_caller_arn(self) -> str:
        """
        ARN of the Amazon SNS caller. This is usually the IAM role that you've given Cognito permission to assume.
        """
        return pulumi.get(self, "sns_caller_arn")

    @property
    @pulumi.getter(name="snsRegion")
    def sns_region(self) -> Optional[str]:
        """
        The AWS Region to use with Amazon SNS integration. You can choose the same Region as your user pool, or a supported Legacy Amazon SNS alternate Region. Amazon Cognito resources in the Asia Pacific (Seoul) AWS Region must use your Amazon SNS configuration in the Asia Pacific (Tokyo) Region. For more information, see [SMS message settings for Amazon Cognito user pools](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html).
        """
        return pulumi.get(self, "sns_region")


@pulumi.output_type
class UserPoolSoftwareTokenMfaConfiguration(dict):
    def __init__(__self__, *,
                 enabled: bool):
        """
        :param bool enabled: Boolean whether to enable software token Multi-Factor (MFA) tokens, such as Time-based One-Time Password (TOTP). To disable software token MFA When `sms_configuration` is not present, the `mfa_configuration` argument must be set to `OFF` and the `software_token_mfa_configuration` configuration block must be fully removed.
        """
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Boolean whether to enable software token Multi-Factor (MFA) tokens, such as Time-based One-Time Password (TOTP). To disable software token MFA When `sms_configuration` is not present, the `mfa_configuration` argument must be set to `OFF` and the `software_token_mfa_configuration` configuration block must be fully removed.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class UserPoolUserAttributeUpdateSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "attributesRequireVerificationBeforeUpdates":
            suggest = "attributes_require_verification_before_updates"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserPoolUserAttributeUpdateSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserPoolUserAttributeUpdateSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserPoolUserAttributeUpdateSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 attributes_require_verification_before_updates: Sequence[str]):
        """
        :param Sequence[str] attributes_require_verification_before_updates: A list of attributes requiring verification before update. If set, the provided value(s) must also be set in `auto_verified_attributes`. Valid values: `email`, `phone_number`.
        """
        pulumi.set(__self__, "attributes_require_verification_before_updates", attributes_require_verification_before_updates)

    @property
    @pulumi.getter(name="attributesRequireVerificationBeforeUpdates")
    def attributes_require_verification_before_updates(self) -> Sequence[str]:
        """
        A list of attributes requiring verification before update. If set, the provided value(s) must also be set in `auto_verified_attributes`. Valid values: `email`, `phone_number`.
        """
        return pulumi.get(self, "attributes_require_verification_before_updates")


@pulumi.output_type
class UserPoolUserPoolAddOns(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "advancedSecurityMode":
            suggest = "advanced_security_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserPoolUserPoolAddOns. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserPoolUserPoolAddOns.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserPoolUserPoolAddOns.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 advanced_security_mode: str):
        """
        :param str advanced_security_mode: Mode for advanced security, must be one of `OFF`, `AUDIT` or `ENFORCED`.
        """
        pulumi.set(__self__, "advanced_security_mode", advanced_security_mode)

    @property
    @pulumi.getter(name="advancedSecurityMode")
    def advanced_security_mode(self) -> str:
        """
        Mode for advanced security, must be one of `OFF`, `AUDIT` or `ENFORCED`.
        """
        return pulumi.get(self, "advanced_security_mode")


@pulumi.output_type
class UserPoolUsernameConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "caseSensitive":
            suggest = "case_sensitive"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserPoolUsernameConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserPoolUsernameConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserPoolUsernameConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 case_sensitive: bool):
        """
        :param bool case_sensitive: Whether username case sensitivity will be applied for all users in the user pool through Cognito APIs.
        """
        pulumi.set(__self__, "case_sensitive", case_sensitive)

    @property
    @pulumi.getter(name="caseSensitive")
    def case_sensitive(self) -> bool:
        """
        Whether username case sensitivity will be applied for all users in the user pool through Cognito APIs.
        """
        return pulumi.get(self, "case_sensitive")


@pulumi.output_type
class UserPoolVerificationMessageTemplate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultEmailOption":
            suggest = "default_email_option"
        elif key == "emailMessage":
            suggest = "email_message"
        elif key == "emailMessageByLink":
            suggest = "email_message_by_link"
        elif key == "emailSubject":
            suggest = "email_subject"
        elif key == "emailSubjectByLink":
            suggest = "email_subject_by_link"
        elif key == "smsMessage":
            suggest = "sms_message"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserPoolVerificationMessageTemplate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserPoolVerificationMessageTemplate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserPoolVerificationMessageTemplate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_email_option: Optional[str] = None,
                 email_message: Optional[str] = None,
                 email_message_by_link: Optional[str] = None,
                 email_subject: Optional[str] = None,
                 email_subject_by_link: Optional[str] = None,
                 sms_message: Optional[str] = None):
        """
        :param str default_email_option: Default email option. Must be either `CONFIRM_WITH_CODE` or `CONFIRM_WITH_LINK`. Defaults to `CONFIRM_WITH_CODE`.
        :param str email_message: Email message template. Must contain the `{####}` placeholder. Conflicts with `email_verification_message` argument.
        :param str email_message_by_link: Email message template for sending a confirmation link to the user, it must contain the `{##Click Here##}` placeholder.
        :param str email_subject: Subject line for the email message template. Conflicts with `email_verification_subject` argument.
        :param str email_subject_by_link: Subject line for the email message template for sending a confirmation link to the user.
        :param str sms_message: SMS message template. Must contain the `{####}` placeholder. Conflicts with `sms_verification_message` argument.
        """
        if default_email_option is not None:
            pulumi.set(__self__, "default_email_option", default_email_option)
        if email_message is not None:
            pulumi.set(__self__, "email_message", email_message)
        if email_message_by_link is not None:
            pulumi.set(__self__, "email_message_by_link", email_message_by_link)
        if email_subject is not None:
            pulumi.set(__self__, "email_subject", email_subject)
        if email_subject_by_link is not None:
            pulumi.set(__self__, "email_subject_by_link", email_subject_by_link)
        if sms_message is not None:
            pulumi.set(__self__, "sms_message", sms_message)

    @property
    @pulumi.getter(name="defaultEmailOption")
    def default_email_option(self) -> Optional[str]:
        """
        Default email option. Must be either `CONFIRM_WITH_CODE` or `CONFIRM_WITH_LINK`. Defaults to `CONFIRM_WITH_CODE`.
        """
        return pulumi.get(self, "default_email_option")

    @property
    @pulumi.getter(name="emailMessage")
    def email_message(self) -> Optional[str]:
        """
        Email message template. Must contain the `{####}` placeholder. Conflicts with `email_verification_message` argument.
        """
        return pulumi.get(self, "email_message")

    @property
    @pulumi.getter(name="emailMessageByLink")
    def email_message_by_link(self) -> Optional[str]:
        """
        Email message template for sending a confirmation link to the user, it must contain the `{##Click Here##}` placeholder.
        """
        return pulumi.get(self, "email_message_by_link")

    @property
    @pulumi.getter(name="emailSubject")
    def email_subject(self) -> Optional[str]:
        """
        Subject line for the email message template. Conflicts with `email_verification_subject` argument.
        """
        return pulumi.get(self, "email_subject")

    @property
    @pulumi.getter(name="emailSubjectByLink")
    def email_subject_by_link(self) -> Optional[str]:
        """
        Subject line for the email message template for sending a confirmation link to the user.
        """
        return pulumi.get(self, "email_subject_by_link")

    @property
    @pulumi.getter(name="smsMessage")
    def sms_message(self) -> Optional[str]:
        """
        SMS message template. Must contain the `{####}` placeholder. Conflicts with `sms_verification_message` argument.
        """
        return pulumi.get(self, "sms_message")


@pulumi.output_type
class GetUserPoolClientAnalyticsConfigurationResult(dict):
    def __init__(__self__, *,
                 application_arn: str,
                 application_id: str,
                 external_id: str,
                 role_arn: str,
                 user_data_shared: bool):
        """
        :param str application_arn: (Optional) Application ARN for an Amazon Pinpoint application. Conflicts with `external_id` and `role_arn`.
        :param str application_id: (Optional) Application ID for an Amazon Pinpoint application.
        :param str external_id: (Optional) ID for the Analytics Configuration. Conflicts with `application_arn`.
        :param str role_arn: (Optional) ARN of an IAM role that authorizes Amazon Cognito to publish events to Amazon Pinpoint analytics. Conflicts with `application_arn`.
        :param bool user_data_shared: (Optional) If set to `true`, Amazon Cognito will include user data in the events it publishes to Amazon Pinpoint analytics.
        """
        pulumi.set(__self__, "application_arn", application_arn)
        pulumi.set(__self__, "application_id", application_id)
        pulumi.set(__self__, "external_id", external_id)
        pulumi.set(__self__, "role_arn", role_arn)
        pulumi.set(__self__, "user_data_shared", user_data_shared)

    @property
    @pulumi.getter(name="applicationArn")
    def application_arn(self) -> str:
        """
        (Optional) Application ARN for an Amazon Pinpoint application. Conflicts with `external_id` and `role_arn`.
        """
        return pulumi.get(self, "application_arn")

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> str:
        """
        (Optional) Application ID for an Amazon Pinpoint application.
        """
        return pulumi.get(self, "application_id")

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> str:
        """
        (Optional) ID for the Analytics Configuration. Conflicts with `application_arn`.
        """
        return pulumi.get(self, "external_id")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> str:
        """
        (Optional) ARN of an IAM role that authorizes Amazon Cognito to publish events to Amazon Pinpoint analytics. Conflicts with `application_arn`.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="userDataShared")
    def user_data_shared(self) -> bool:
        """
        (Optional) If set to `true`, Amazon Cognito will include user data in the events it publishes to Amazon Pinpoint analytics.
        """
        return pulumi.get(self, "user_data_shared")


@pulumi.output_type
class GetUserPoolClientTokenValidityUnitResult(dict):
    def __init__(__self__, *,
                 access_token: str,
                 id_token: str,
                 refresh_token: str):
        """
        :param str access_token: (Optional) Time unit in for the value in `access_token_validity`, defaults to `hours`.
        :param str id_token: (Optional) Time unit in for the value in `id_token_validity`, defaults to `hours`.
        :param str refresh_token: (Optional) Time unit in for the value in `refresh_token_validity`, defaults to `days`.
        """
        pulumi.set(__self__, "access_token", access_token)
        pulumi.set(__self__, "id_token", id_token)
        pulumi.set(__self__, "refresh_token", refresh_token)

    @property
    @pulumi.getter(name="accessToken")
    def access_token(self) -> str:
        """
        (Optional) Time unit in for the value in `access_token_validity`, defaults to `hours`.
        """
        return pulumi.get(self, "access_token")

    @property
    @pulumi.getter(name="idToken")
    def id_token(self) -> str:
        """
        (Optional) Time unit in for the value in `id_token_validity`, defaults to `hours`.
        """
        return pulumi.get(self, "id_token")

    @property
    @pulumi.getter(name="refreshToken")
    def refresh_token(self) -> str:
        """
        (Optional) Time unit in for the value in `refresh_token_validity`, defaults to `days`.
        """
        return pulumi.get(self, "refresh_token")


