# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['UserInGroupArgs', 'UserInGroup']

@pulumi.input_type
class UserInGroupArgs:
    def __init__(__self__, *,
                 group_name: pulumi.Input[str],
                 user_pool_id: pulumi.Input[str],
                 username: pulumi.Input[str]):
        """
        The set of arguments for constructing a UserInGroup resource.
        :param pulumi.Input[str] group_name: The name of the group to which the user is to be added.
        :param pulumi.Input[str] user_pool_id: The user pool ID of the user and group.
        :param pulumi.Input[str] username: The username of the user to be added to the group.
        """
        pulumi.set(__self__, "group_name", group_name)
        pulumi.set(__self__, "user_pool_id", user_pool_id)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="groupName")
    def group_name(self) -> pulumi.Input[str]:
        """
        The name of the group to which the user is to be added.
        """
        return pulumi.get(self, "group_name")

    @group_name.setter
    def group_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "group_name", value)

    @property
    @pulumi.getter(name="userPoolId")
    def user_pool_id(self) -> pulumi.Input[str]:
        """
        The user pool ID of the user and group.
        """
        return pulumi.get(self, "user_pool_id")

    @user_pool_id.setter
    def user_pool_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "user_pool_id", value)

    @property
    @pulumi.getter
    def username(self) -> pulumi.Input[str]:
        """
        The username of the user to be added to the group.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[str]):
        pulumi.set(self, "username", value)


@pulumi.input_type
class _UserInGroupState:
    def __init__(__self__, *,
                 group_name: Optional[pulumi.Input[str]] = None,
                 user_pool_id: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering UserInGroup resources.
        :param pulumi.Input[str] group_name: The name of the group to which the user is to be added.
        :param pulumi.Input[str] user_pool_id: The user pool ID of the user and group.
        :param pulumi.Input[str] username: The username of the user to be added to the group.
        """
        if group_name is not None:
            pulumi.set(__self__, "group_name", group_name)
        if user_pool_id is not None:
            pulumi.set(__self__, "user_pool_id", user_pool_id)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="groupName")
    def group_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the group to which the user is to be added.
        """
        return pulumi.get(self, "group_name")

    @group_name.setter
    def group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group_name", value)

    @property
    @pulumi.getter(name="userPoolId")
    def user_pool_id(self) -> Optional[pulumi.Input[str]]:
        """
        The user pool ID of the user and group.
        """
        return pulumi.get(self, "user_pool_id")

    @user_pool_id.setter
    def user_pool_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_pool_id", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        The username of the user to be added to the group.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)


class UserInGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 group_name: Optional[pulumi.Input[str]] = None,
                 user_pool_id: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Adds the specified user to the specified group.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example_user_pool = aws.cognito.UserPool("exampleUserPool", password_policy=aws.cognito.UserPoolPasswordPolicyArgs(
            temporary_password_validity_days=7,
            minimum_length=6,
            require_uppercase=False,
            require_symbols=False,
            require_numbers=False,
        ))
        example_user = aws.cognito.User("exampleUser",
            user_pool_id=example_user_pool.id,
            username="example")
        example_user_group = aws.cognito.UserGroup("exampleUserGroup", user_pool_id=example_user_pool.id)
        example_user_in_group = aws.cognito.UserInGroup("exampleUserInGroup",
            user_pool_id=example_user_pool.id,
            group_name=example_user_group.name,
            username=example_user.username)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] group_name: The name of the group to which the user is to be added.
        :param pulumi.Input[str] user_pool_id: The user pool ID of the user and group.
        :param pulumi.Input[str] username: The username of the user to be added to the group.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: UserInGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Adds the specified user to the specified group.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example_user_pool = aws.cognito.UserPool("exampleUserPool", password_policy=aws.cognito.UserPoolPasswordPolicyArgs(
            temporary_password_validity_days=7,
            minimum_length=6,
            require_uppercase=False,
            require_symbols=False,
            require_numbers=False,
        ))
        example_user = aws.cognito.User("exampleUser",
            user_pool_id=example_user_pool.id,
            username="example")
        example_user_group = aws.cognito.UserGroup("exampleUserGroup", user_pool_id=example_user_pool.id)
        example_user_in_group = aws.cognito.UserInGroup("exampleUserInGroup",
            user_pool_id=example_user_pool.id,
            group_name=example_user_group.name,
            username=example_user.username)
        ```

        :param str resource_name: The name of the resource.
        :param UserInGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UserInGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 group_name: Optional[pulumi.Input[str]] = None,
                 user_pool_id: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UserInGroupArgs.__new__(UserInGroupArgs)

            if group_name is None and not opts.urn:
                raise TypeError("Missing required property 'group_name'")
            __props__.__dict__["group_name"] = group_name
            if user_pool_id is None and not opts.urn:
                raise TypeError("Missing required property 'user_pool_id'")
            __props__.__dict__["user_pool_id"] = user_pool_id
            if username is None and not opts.urn:
                raise TypeError("Missing required property 'username'")
            __props__.__dict__["username"] = username
        super(UserInGroup, __self__).__init__(
            'aws:cognito/userInGroup:UserInGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            group_name: Optional[pulumi.Input[str]] = None,
            user_pool_id: Optional[pulumi.Input[str]] = None,
            username: Optional[pulumi.Input[str]] = None) -> 'UserInGroup':
        """
        Get an existing UserInGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] group_name: The name of the group to which the user is to be added.
        :param pulumi.Input[str] user_pool_id: The user pool ID of the user and group.
        :param pulumi.Input[str] username: The username of the user to be added to the group.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UserInGroupState.__new__(_UserInGroupState)

        __props__.__dict__["group_name"] = group_name
        __props__.__dict__["user_pool_id"] = user_pool_id
        __props__.__dict__["username"] = username
        return UserInGroup(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="groupName")
    def group_name(self) -> pulumi.Output[str]:
        """
        The name of the group to which the user is to be added.
        """
        return pulumi.get(self, "group_name")

    @property
    @pulumi.getter(name="userPoolId")
    def user_pool_id(self) -> pulumi.Output[str]:
        """
        The user pool ID of the user and group.
        """
        return pulumi.get(self, "user_pool_id")

    @property
    @pulumi.getter
    def username(self) -> pulumi.Output[str]:
        """
        The username of the user to be added to the group.
        """
        return pulumi.get(self, "username")

