# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'DocumentClassifierInputDataConfigArgs',
    'DocumentClassifierInputDataConfigAugmentedManifestArgs',
    'DocumentClassifierOutputDataConfigArgs',
    'DocumentClassifierVpcConfigArgs',
    'EntityRecognizerInputDataConfigArgs',
    'EntityRecognizerInputDataConfigAnnotationsArgs',
    'EntityRecognizerInputDataConfigAugmentedManifestArgs',
    'EntityRecognizerInputDataConfigDocumentsArgs',
    'EntityRecognizerInputDataConfigEntityListArgs',
    'EntityRecognizerInputDataConfigEntityTypeArgs',
    'EntityRecognizerVpcConfigArgs',
]

@pulumi.input_type
class DocumentClassifierInputDataConfigArgs:
    def __init__(__self__, *,
                 augmented_manifests: Optional[pulumi.Input[Sequence[pulumi.Input['DocumentClassifierInputDataConfigAugmentedManifestArgs']]]] = None,
                 data_format: Optional[pulumi.Input[str]] = None,
                 label_delimiter: Optional[pulumi.Input[str]] = None,
                 s3_uri: Optional[pulumi.Input[str]] = None,
                 test_s3_uri: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['DocumentClassifierInputDataConfigAugmentedManifestArgs']]] augmented_manifests: List of training datasets produced by Amazon SageMaker Ground Truth.
               Used if `data_format` is `AUGMENTED_MANIFEST`.
               See the `augmented_manifests` Configuration Block section below.
        :param pulumi.Input[str] data_format: The format for the training data.
               One of `COMPREHEND_CSV` or `AUGMENTED_MANIFEST`.
        :param pulumi.Input[str] label_delimiter: Delimiter between labels when training a multi-label classifier.
               Valid values are `|`, `~`, `!`, `@`, `#`, `$`, `%`, `^`, `*`, `-`, `_`, `+`, `=`, `\\`, `:`, `;`, `>`, `?`, `/`, `<space>`, and `<tab>`.
               Default is `|`.
        :param pulumi.Input[str] s3_uri: Location of training documents.
               Used if `data_format` is `COMPREHEND_CSV`.
        """
        if augmented_manifests is not None:
            pulumi.set(__self__, "augmented_manifests", augmented_manifests)
        if data_format is not None:
            pulumi.set(__self__, "data_format", data_format)
        if label_delimiter is not None:
            pulumi.set(__self__, "label_delimiter", label_delimiter)
        if s3_uri is not None:
            pulumi.set(__self__, "s3_uri", s3_uri)
        if test_s3_uri is not None:
            pulumi.set(__self__, "test_s3_uri", test_s3_uri)

    @property
    @pulumi.getter(name="augmentedManifests")
    def augmented_manifests(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DocumentClassifierInputDataConfigAugmentedManifestArgs']]]]:
        """
        List of training datasets produced by Amazon SageMaker Ground Truth.
        Used if `data_format` is `AUGMENTED_MANIFEST`.
        See the `augmented_manifests` Configuration Block section below.
        """
        return pulumi.get(self, "augmented_manifests")

    @augmented_manifests.setter
    def augmented_manifests(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DocumentClassifierInputDataConfigAugmentedManifestArgs']]]]):
        pulumi.set(self, "augmented_manifests", value)

    @property
    @pulumi.getter(name="dataFormat")
    def data_format(self) -> Optional[pulumi.Input[str]]:
        """
        The format for the training data.
        One of `COMPREHEND_CSV` or `AUGMENTED_MANIFEST`.
        """
        return pulumi.get(self, "data_format")

    @data_format.setter
    def data_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_format", value)

    @property
    @pulumi.getter(name="labelDelimiter")
    def label_delimiter(self) -> Optional[pulumi.Input[str]]:
        """
        Delimiter between labels when training a multi-label classifier.
        Valid values are `|`, `~`, `!`, `@`, `#`, `$`, `%`, `^`, `*`, `-`, `_`, `+`, `=`, `\\`, `:`, `;`, `>`, `?`, `/`, `<space>`, and `<tab>`.
        Default is `|`.
        """
        return pulumi.get(self, "label_delimiter")

    @label_delimiter.setter
    def label_delimiter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "label_delimiter", value)

    @property
    @pulumi.getter(name="s3Uri")
    def s3_uri(self) -> Optional[pulumi.Input[str]]:
        """
        Location of training documents.
        Used if `data_format` is `COMPREHEND_CSV`.
        """
        return pulumi.get(self, "s3_uri")

    @s3_uri.setter
    def s3_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "s3_uri", value)

    @property
    @pulumi.getter(name="testS3Uri")
    def test_s3_uri(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "test_s3_uri")

    @test_s3_uri.setter
    def test_s3_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "test_s3_uri", value)


@pulumi.input_type
class DocumentClassifierInputDataConfigAugmentedManifestArgs:
    def __init__(__self__, *,
                 attribute_names: pulumi.Input[Sequence[pulumi.Input[str]]],
                 s3_uri: pulumi.Input[str],
                 annotation_data_s3_uri: Optional[pulumi.Input[str]] = None,
                 document_type: Optional[pulumi.Input[str]] = None,
                 source_documents_s3_uri: Optional[pulumi.Input[str]] = None,
                 split: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] attribute_names: The JSON attribute that contains the annotations for the training documents.
        :param pulumi.Input[str] s3_uri: Location of augmented manifest file.
        :param pulumi.Input[str] annotation_data_s3_uri: Location of annotation files.
        :param pulumi.Input[str] document_type: Type of augmented manifest.
               One of `PLAIN_TEXT_DOCUMENT` or `SEMI_STRUCTURED_DOCUMENT`.
        :param pulumi.Input[str] source_documents_s3_uri: Location of source PDF files.
        :param pulumi.Input[str] split: Purpose of data in augmented manifest.
               One of `TRAIN` or `TEST`.
        """
        pulumi.set(__self__, "attribute_names", attribute_names)
        pulumi.set(__self__, "s3_uri", s3_uri)
        if annotation_data_s3_uri is not None:
            pulumi.set(__self__, "annotation_data_s3_uri", annotation_data_s3_uri)
        if document_type is not None:
            pulumi.set(__self__, "document_type", document_type)
        if source_documents_s3_uri is not None:
            pulumi.set(__self__, "source_documents_s3_uri", source_documents_s3_uri)
        if split is not None:
            pulumi.set(__self__, "split", split)

    @property
    @pulumi.getter(name="attributeNames")
    def attribute_names(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The JSON attribute that contains the annotations for the training documents.
        """
        return pulumi.get(self, "attribute_names")

    @attribute_names.setter
    def attribute_names(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "attribute_names", value)

    @property
    @pulumi.getter(name="s3Uri")
    def s3_uri(self) -> pulumi.Input[str]:
        """
        Location of augmented manifest file.
        """
        return pulumi.get(self, "s3_uri")

    @s3_uri.setter
    def s3_uri(self, value: pulumi.Input[str]):
        pulumi.set(self, "s3_uri", value)

    @property
    @pulumi.getter(name="annotationDataS3Uri")
    def annotation_data_s3_uri(self) -> Optional[pulumi.Input[str]]:
        """
        Location of annotation files.
        """
        return pulumi.get(self, "annotation_data_s3_uri")

    @annotation_data_s3_uri.setter
    def annotation_data_s3_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "annotation_data_s3_uri", value)

    @property
    @pulumi.getter(name="documentType")
    def document_type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of augmented manifest.
        One of `PLAIN_TEXT_DOCUMENT` or `SEMI_STRUCTURED_DOCUMENT`.
        """
        return pulumi.get(self, "document_type")

    @document_type.setter
    def document_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "document_type", value)

    @property
    @pulumi.getter(name="sourceDocumentsS3Uri")
    def source_documents_s3_uri(self) -> Optional[pulumi.Input[str]]:
        """
        Location of source PDF files.
        """
        return pulumi.get(self, "source_documents_s3_uri")

    @source_documents_s3_uri.setter
    def source_documents_s3_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_documents_s3_uri", value)

    @property
    @pulumi.getter
    def split(self) -> Optional[pulumi.Input[str]]:
        """
        Purpose of data in augmented manifest.
        One of `TRAIN` or `TEST`.
        """
        return pulumi.get(self, "split")

    @split.setter
    def split(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "split", value)


@pulumi.input_type
class DocumentClassifierOutputDataConfigArgs:
    def __init__(__self__, *,
                 s3_uri: pulumi.Input[str],
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 output_s3_uri: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] s3_uri: Destination path for the output documents.
               The full path to the output file will be returned in `output_s3_uri`.
        :param pulumi.Input[str] kms_key_id: KMS Key used to encrypt the output documents.
               Can be a KMS Key ID, a KMS Key ARN, a KMS Alias name, or a KMS Alias ARN.
        :param pulumi.Input[str] output_s3_uri: Full path for the output documents.
        """
        pulumi.set(__self__, "s3_uri", s3_uri)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if output_s3_uri is not None:
            pulumi.set(__self__, "output_s3_uri", output_s3_uri)

    @property
    @pulumi.getter(name="s3Uri")
    def s3_uri(self) -> pulumi.Input[str]:
        """
        Destination path for the output documents.
        The full path to the output file will be returned in `output_s3_uri`.
        """
        return pulumi.get(self, "s3_uri")

    @s3_uri.setter
    def s3_uri(self, value: pulumi.Input[str]):
        pulumi.set(self, "s3_uri", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        KMS Key used to encrypt the output documents.
        Can be a KMS Key ID, a KMS Key ARN, a KMS Alias name, or a KMS Alias ARN.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="outputS3Uri")
    def output_s3_uri(self) -> Optional[pulumi.Input[str]]:
        """
        Full path for the output documents.
        """
        return pulumi.get(self, "output_s3_uri")

    @output_s3_uri.setter
    def output_s3_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "output_s3_uri", value)


@pulumi.input_type
class DocumentClassifierVpcConfigArgs:
    def __init__(__self__, *,
                 security_group_ids: pulumi.Input[Sequence[pulumi.Input[str]]],
                 subnets: pulumi.Input[Sequence[pulumi.Input[str]]]):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: List of security group IDs.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnets: List of VPC subnets.
        """
        pulumi.set(__self__, "security_group_ids", security_group_ids)
        pulumi.set(__self__, "subnets", subnets)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        List of security group IDs.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "security_group_ids", value)

    @property
    @pulumi.getter
    def subnets(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        List of VPC subnets.
        """
        return pulumi.get(self, "subnets")

    @subnets.setter
    def subnets(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "subnets", value)


@pulumi.input_type
class EntityRecognizerInputDataConfigArgs:
    def __init__(__self__, *,
                 entity_types: pulumi.Input[Sequence[pulumi.Input['EntityRecognizerInputDataConfigEntityTypeArgs']]],
                 annotations: Optional[pulumi.Input['EntityRecognizerInputDataConfigAnnotationsArgs']] = None,
                 augmented_manifests: Optional[pulumi.Input[Sequence[pulumi.Input['EntityRecognizerInputDataConfigAugmentedManifestArgs']]]] = None,
                 data_format: Optional[pulumi.Input[str]] = None,
                 documents: Optional[pulumi.Input['EntityRecognizerInputDataConfigDocumentsArgs']] = None,
                 entity_list: Optional[pulumi.Input['EntityRecognizerInputDataConfigEntityListArgs']] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['EntityRecognizerInputDataConfigEntityTypeArgs']]] entity_types: Set of entity types to be recognized.
               Has a maximum of 25 items.
               See the `entity_types` Configuration Block section below.
        :param pulumi.Input['EntityRecognizerInputDataConfigAnnotationsArgs'] annotations: Specifies location of the document annotation data.
               See the `annotations` Configuration Block section below.
               One of `annotations` or `entity_list` is required.
        :param pulumi.Input[Sequence[pulumi.Input['EntityRecognizerInputDataConfigAugmentedManifestArgs']]] augmented_manifests: List of training datasets produced by Amazon SageMaker Ground Truth.
               Used if `data_format` is `AUGMENTED_MANIFEST`.
               See the `augmented_manifests` Configuration Block section below.
        :param pulumi.Input[str] data_format: The format for the training data.
               One of `COMPREHEND_CSV` or `AUGMENTED_MANIFEST`.
        :param pulumi.Input['EntityRecognizerInputDataConfigDocumentsArgs'] documents: Specifies a collection of training documents.
               Used if `data_format` is `COMPREHEND_CSV`.
               See the `documents` Configuration Block section below.
        :param pulumi.Input['EntityRecognizerInputDataConfigEntityListArgs'] entity_list: Specifies location of the entity list data.
               See the `entity_list` Configuration Block section below.
               One of `entity_list` or `annotations` is required.
        """
        pulumi.set(__self__, "entity_types", entity_types)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if augmented_manifests is not None:
            pulumi.set(__self__, "augmented_manifests", augmented_manifests)
        if data_format is not None:
            pulumi.set(__self__, "data_format", data_format)
        if documents is not None:
            pulumi.set(__self__, "documents", documents)
        if entity_list is not None:
            pulumi.set(__self__, "entity_list", entity_list)

    @property
    @pulumi.getter(name="entityTypes")
    def entity_types(self) -> pulumi.Input[Sequence[pulumi.Input['EntityRecognizerInputDataConfigEntityTypeArgs']]]:
        """
        Set of entity types to be recognized.
        Has a maximum of 25 items.
        See the `entity_types` Configuration Block section below.
        """
        return pulumi.get(self, "entity_types")

    @entity_types.setter
    def entity_types(self, value: pulumi.Input[Sequence[pulumi.Input['EntityRecognizerInputDataConfigEntityTypeArgs']]]):
        pulumi.set(self, "entity_types", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input['EntityRecognizerInputDataConfigAnnotationsArgs']]:
        """
        Specifies location of the document annotation data.
        See the `annotations` Configuration Block section below.
        One of `annotations` or `entity_list` is required.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input['EntityRecognizerInputDataConfigAnnotationsArgs']]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="augmentedManifests")
    def augmented_manifests(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EntityRecognizerInputDataConfigAugmentedManifestArgs']]]]:
        """
        List of training datasets produced by Amazon SageMaker Ground Truth.
        Used if `data_format` is `AUGMENTED_MANIFEST`.
        See the `augmented_manifests` Configuration Block section below.
        """
        return pulumi.get(self, "augmented_manifests")

    @augmented_manifests.setter
    def augmented_manifests(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EntityRecognizerInputDataConfigAugmentedManifestArgs']]]]):
        pulumi.set(self, "augmented_manifests", value)

    @property
    @pulumi.getter(name="dataFormat")
    def data_format(self) -> Optional[pulumi.Input[str]]:
        """
        The format for the training data.
        One of `COMPREHEND_CSV` or `AUGMENTED_MANIFEST`.
        """
        return pulumi.get(self, "data_format")

    @data_format.setter
    def data_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_format", value)

    @property
    @pulumi.getter
    def documents(self) -> Optional[pulumi.Input['EntityRecognizerInputDataConfigDocumentsArgs']]:
        """
        Specifies a collection of training documents.
        Used if `data_format` is `COMPREHEND_CSV`.
        See the `documents` Configuration Block section below.
        """
        return pulumi.get(self, "documents")

    @documents.setter
    def documents(self, value: Optional[pulumi.Input['EntityRecognizerInputDataConfigDocumentsArgs']]):
        pulumi.set(self, "documents", value)

    @property
    @pulumi.getter(name="entityList")
    def entity_list(self) -> Optional[pulumi.Input['EntityRecognizerInputDataConfigEntityListArgs']]:
        """
        Specifies location of the entity list data.
        See the `entity_list` Configuration Block section below.
        One of `entity_list` or `annotations` is required.
        """
        return pulumi.get(self, "entity_list")

    @entity_list.setter
    def entity_list(self, value: Optional[pulumi.Input['EntityRecognizerInputDataConfigEntityListArgs']]):
        pulumi.set(self, "entity_list", value)


@pulumi.input_type
class EntityRecognizerInputDataConfigAnnotationsArgs:
    def __init__(__self__, *,
                 s3_uri: pulumi.Input[str],
                 test_s3_uri: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] s3_uri: Location of training annotations.
        """
        pulumi.set(__self__, "s3_uri", s3_uri)
        if test_s3_uri is not None:
            pulumi.set(__self__, "test_s3_uri", test_s3_uri)

    @property
    @pulumi.getter(name="s3Uri")
    def s3_uri(self) -> pulumi.Input[str]:
        """
        Location of training annotations.
        """
        return pulumi.get(self, "s3_uri")

    @s3_uri.setter
    def s3_uri(self, value: pulumi.Input[str]):
        pulumi.set(self, "s3_uri", value)

    @property
    @pulumi.getter(name="testS3Uri")
    def test_s3_uri(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "test_s3_uri")

    @test_s3_uri.setter
    def test_s3_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "test_s3_uri", value)


@pulumi.input_type
class EntityRecognizerInputDataConfigAugmentedManifestArgs:
    def __init__(__self__, *,
                 attribute_names: pulumi.Input[Sequence[pulumi.Input[str]]],
                 s3_uri: pulumi.Input[str],
                 annotation_data_s3_uri: Optional[pulumi.Input[str]] = None,
                 document_type: Optional[pulumi.Input[str]] = None,
                 source_documents_s3_uri: Optional[pulumi.Input[str]] = None,
                 split: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] attribute_names: The JSON attribute that contains the annotations for the training documents.
        :param pulumi.Input[str] s3_uri: Location of augmented manifest file.
        :param pulumi.Input[str] annotation_data_s3_uri: Location of annotation files.
        :param pulumi.Input[str] document_type: Type of augmented manifest.
               One of `PLAIN_TEXT_DOCUMENT` or `SEMI_STRUCTURED_DOCUMENT`.
        :param pulumi.Input[str] source_documents_s3_uri: Location of source PDF files.
        :param pulumi.Input[str] split: Purpose of data in augmented manifest.
               One of `TRAIN` or `TEST`.
        """
        pulumi.set(__self__, "attribute_names", attribute_names)
        pulumi.set(__self__, "s3_uri", s3_uri)
        if annotation_data_s3_uri is not None:
            pulumi.set(__self__, "annotation_data_s3_uri", annotation_data_s3_uri)
        if document_type is not None:
            pulumi.set(__self__, "document_type", document_type)
        if source_documents_s3_uri is not None:
            pulumi.set(__self__, "source_documents_s3_uri", source_documents_s3_uri)
        if split is not None:
            pulumi.set(__self__, "split", split)

    @property
    @pulumi.getter(name="attributeNames")
    def attribute_names(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The JSON attribute that contains the annotations for the training documents.
        """
        return pulumi.get(self, "attribute_names")

    @attribute_names.setter
    def attribute_names(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "attribute_names", value)

    @property
    @pulumi.getter(name="s3Uri")
    def s3_uri(self) -> pulumi.Input[str]:
        """
        Location of augmented manifest file.
        """
        return pulumi.get(self, "s3_uri")

    @s3_uri.setter
    def s3_uri(self, value: pulumi.Input[str]):
        pulumi.set(self, "s3_uri", value)

    @property
    @pulumi.getter(name="annotationDataS3Uri")
    def annotation_data_s3_uri(self) -> Optional[pulumi.Input[str]]:
        """
        Location of annotation files.
        """
        return pulumi.get(self, "annotation_data_s3_uri")

    @annotation_data_s3_uri.setter
    def annotation_data_s3_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "annotation_data_s3_uri", value)

    @property
    @pulumi.getter(name="documentType")
    def document_type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of augmented manifest.
        One of `PLAIN_TEXT_DOCUMENT` or `SEMI_STRUCTURED_DOCUMENT`.
        """
        return pulumi.get(self, "document_type")

    @document_type.setter
    def document_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "document_type", value)

    @property
    @pulumi.getter(name="sourceDocumentsS3Uri")
    def source_documents_s3_uri(self) -> Optional[pulumi.Input[str]]:
        """
        Location of source PDF files.
        """
        return pulumi.get(self, "source_documents_s3_uri")

    @source_documents_s3_uri.setter
    def source_documents_s3_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_documents_s3_uri", value)

    @property
    @pulumi.getter
    def split(self) -> Optional[pulumi.Input[str]]:
        """
        Purpose of data in augmented manifest.
        One of `TRAIN` or `TEST`.
        """
        return pulumi.get(self, "split")

    @split.setter
    def split(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "split", value)


@pulumi.input_type
class EntityRecognizerInputDataConfigDocumentsArgs:
    def __init__(__self__, *,
                 s3_uri: pulumi.Input[str],
                 input_format: Optional[pulumi.Input[str]] = None,
                 test_s3_uri: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] s3_uri: Location of training documents.
        :param pulumi.Input[str] input_format: Specifies how the input files should be processed.
               One of `ONE_DOC_PER_LINE` or `ONE_DOC_PER_FILE`.
        """
        pulumi.set(__self__, "s3_uri", s3_uri)
        if input_format is not None:
            pulumi.set(__self__, "input_format", input_format)
        if test_s3_uri is not None:
            pulumi.set(__self__, "test_s3_uri", test_s3_uri)

    @property
    @pulumi.getter(name="s3Uri")
    def s3_uri(self) -> pulumi.Input[str]:
        """
        Location of training documents.
        """
        return pulumi.get(self, "s3_uri")

    @s3_uri.setter
    def s3_uri(self, value: pulumi.Input[str]):
        pulumi.set(self, "s3_uri", value)

    @property
    @pulumi.getter(name="inputFormat")
    def input_format(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies how the input files should be processed.
        One of `ONE_DOC_PER_LINE` or `ONE_DOC_PER_FILE`.
        """
        return pulumi.get(self, "input_format")

    @input_format.setter
    def input_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "input_format", value)

    @property
    @pulumi.getter(name="testS3Uri")
    def test_s3_uri(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "test_s3_uri")

    @test_s3_uri.setter
    def test_s3_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "test_s3_uri", value)


@pulumi.input_type
class EntityRecognizerInputDataConfigEntityListArgs:
    def __init__(__self__, *,
                 s3_uri: pulumi.Input[str]):
        """
        :param pulumi.Input[str] s3_uri: Location of entity list.
        """
        pulumi.set(__self__, "s3_uri", s3_uri)

    @property
    @pulumi.getter(name="s3Uri")
    def s3_uri(self) -> pulumi.Input[str]:
        """
        Location of entity list.
        """
        return pulumi.get(self, "s3_uri")

    @s3_uri.setter
    def s3_uri(self, value: pulumi.Input[str]):
        pulumi.set(self, "s3_uri", value)


@pulumi.input_type
class EntityRecognizerInputDataConfigEntityTypeArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str]):
        """
        :param pulumi.Input[str] type: An entity type to be matched by the Entity Recognizer.
               Cannot contain a newline (`\\n`), carriage return (`\\r`), or tab (`\\t`).
        """
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        An entity type to be matched by the Entity Recognizer.
        Cannot contain a newline (`\\n`), carriage return (`\\r`), or tab (`\\t`).
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class EntityRecognizerVpcConfigArgs:
    def __init__(__self__, *,
                 security_group_ids: pulumi.Input[Sequence[pulumi.Input[str]]],
                 subnets: pulumi.Input[Sequence[pulumi.Input[str]]]):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: List of security group IDs.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnets: List of VPC subnets.
        """
        pulumi.set(__self__, "security_group_ids", security_group_ids)
        pulumi.set(__self__, "subnets", subnets)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        List of security group IDs.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "security_group_ids", value)

    @property
    @pulumi.getter
    def subnets(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        List of VPC subnets.
        """
        return pulumi.get(self, "subnets")

    @subnets.setter
    def subnets(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "subnets", value)


