# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'LifecyclePolicyPolicyDetails',
    'LifecyclePolicyPolicyDetailsAction',
    'LifecyclePolicyPolicyDetailsActionCrossRegionCopy',
    'LifecyclePolicyPolicyDetailsActionCrossRegionCopyEncryptionConfiguration',
    'LifecyclePolicyPolicyDetailsActionCrossRegionCopyRetainRule',
    'LifecyclePolicyPolicyDetailsEventSource',
    'LifecyclePolicyPolicyDetailsEventSourceParameters',
    'LifecyclePolicyPolicyDetailsParameters',
    'LifecyclePolicyPolicyDetailsSchedule',
    'LifecyclePolicyPolicyDetailsScheduleCreateRule',
    'LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRule',
    'LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleDeprecateRule',
    'LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleRetainRule',
    'LifecyclePolicyPolicyDetailsScheduleDeprecateRule',
    'LifecyclePolicyPolicyDetailsScheduleFastRestoreRule',
    'LifecyclePolicyPolicyDetailsScheduleRetainRule',
    'LifecyclePolicyPolicyDetailsScheduleShareRule',
]

@pulumi.output_type
class LifecyclePolicyPolicyDetails(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "eventSource":
            suggest = "event_source"
        elif key == "policyType":
            suggest = "policy_type"
        elif key == "resourceLocations":
            suggest = "resource_locations"
        elif key == "resourceTypes":
            suggest = "resource_types"
        elif key == "targetTags":
            suggest = "target_tags"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LifecyclePolicyPolicyDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LifecyclePolicyPolicyDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LifecyclePolicyPolicyDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: Optional['outputs.LifecyclePolicyPolicyDetailsAction'] = None,
                 event_source: Optional['outputs.LifecyclePolicyPolicyDetailsEventSource'] = None,
                 parameters: Optional['outputs.LifecyclePolicyPolicyDetailsParameters'] = None,
                 policy_type: Optional[str] = None,
                 resource_locations: Optional[str] = None,
                 resource_types: Optional[Sequence[str]] = None,
                 schedules: Optional[Sequence['outputs.LifecyclePolicyPolicyDetailsSchedule']] = None,
                 target_tags: Optional[Mapping[str, str]] = None):
        """
        :param 'LifecyclePolicyPolicyDetailsActionArgs' action: The actions to be performed when the event-based policy is triggered. You can specify only one action per policy. This parameter is required for event-based policies only. If you are creating a snapshot or AMI policy, omit this parameter. See the `action` configuration block.
        :param 'LifecyclePolicyPolicyDetailsEventSourceArgs' event_source: The event that triggers the event-based policy. This parameter is required for event-based policies only. If you are creating a snapshot or AMI policy, omit this parameter. See the `event_source` configuration block.
        :param 'LifecyclePolicyPolicyDetailsParametersArgs' parameters: A set of optional parameters for snapshot and AMI lifecycle policies. See the `parameters` configuration block.
        :param str policy_type: The valid target resource types and actions a policy can manage. Specify `EBS_SNAPSHOT_MANAGEMENT` to create a lifecycle policy that manages the lifecycle of Amazon EBS snapshots. Specify `IMAGE_MANAGEMENT` to create a lifecycle policy that manages the lifecycle of EBS-backed AMIs. Specify `EVENT_BASED_POLICY` to create an event-based policy that performs specific actions when a defined event occurs in your AWS account. Default value is `EBS_SNAPSHOT_MANAGEMENT`.
        :param str resource_locations: The location of the resources to backup. If the source resources are located in an AWS Region, specify `CLOUD`. If the source resources are located on an Outpost in your account, specify `OUTPOST`. If you specify `OUTPOST`, Amazon Data Lifecycle Manager backs up all resources of the specified type with matching target tags across all of the Outposts in your account. Valid values are `CLOUD` and `OUTPOST`.
        :param Sequence[str] resource_types: A list of resource types that should be targeted by the lifecycle policy. Valid values are `VOLUME` and `INSTANCE`.
        :param Sequence['LifecyclePolicyPolicyDetailsScheduleArgs'] schedules: See the `schedule` configuration block.
        :param Mapping[str, str] target_tags: A map of tag keys and their values. Any resources that match the `resource_types` and are tagged with _any_ of these tags will be targeted.
               
               > Note: You cannot have overlapping lifecycle policies that share the same `target_tags`. This provider is unable to detect this at plan time but it will fail during apply.
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if event_source is not None:
            pulumi.set(__self__, "event_source", event_source)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if policy_type is not None:
            pulumi.set(__self__, "policy_type", policy_type)
        if resource_locations is not None:
            pulumi.set(__self__, "resource_locations", resource_locations)
        if resource_types is not None:
            pulumi.set(__self__, "resource_types", resource_types)
        if schedules is not None:
            pulumi.set(__self__, "schedules", schedules)
        if target_tags is not None:
            pulumi.set(__self__, "target_tags", target_tags)

    @property
    @pulumi.getter
    def action(self) -> Optional['outputs.LifecyclePolicyPolicyDetailsAction']:
        """
        The actions to be performed when the event-based policy is triggered. You can specify only one action per policy. This parameter is required for event-based policies only. If you are creating a snapshot or AMI policy, omit this parameter. See the `action` configuration block.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter(name="eventSource")
    def event_source(self) -> Optional['outputs.LifecyclePolicyPolicyDetailsEventSource']:
        """
        The event that triggers the event-based policy. This parameter is required for event-based policies only. If you are creating a snapshot or AMI policy, omit this parameter. See the `event_source` configuration block.
        """
        return pulumi.get(self, "event_source")

    @property
    @pulumi.getter
    def parameters(self) -> Optional['outputs.LifecyclePolicyPolicyDetailsParameters']:
        """
        A set of optional parameters for snapshot and AMI lifecycle policies. See the `parameters` configuration block.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter(name="policyType")
    def policy_type(self) -> Optional[str]:
        """
        The valid target resource types and actions a policy can manage. Specify `EBS_SNAPSHOT_MANAGEMENT` to create a lifecycle policy that manages the lifecycle of Amazon EBS snapshots. Specify `IMAGE_MANAGEMENT` to create a lifecycle policy that manages the lifecycle of EBS-backed AMIs. Specify `EVENT_BASED_POLICY` to create an event-based policy that performs specific actions when a defined event occurs in your AWS account. Default value is `EBS_SNAPSHOT_MANAGEMENT`.
        """
        return pulumi.get(self, "policy_type")

    @property
    @pulumi.getter(name="resourceLocations")
    def resource_locations(self) -> Optional[str]:
        """
        The location of the resources to backup. If the source resources are located in an AWS Region, specify `CLOUD`. If the source resources are located on an Outpost in your account, specify `OUTPOST`. If you specify `OUTPOST`, Amazon Data Lifecycle Manager backs up all resources of the specified type with matching target tags across all of the Outposts in your account. Valid values are `CLOUD` and `OUTPOST`.
        """
        return pulumi.get(self, "resource_locations")

    @property
    @pulumi.getter(name="resourceTypes")
    def resource_types(self) -> Optional[Sequence[str]]:
        """
        A list of resource types that should be targeted by the lifecycle policy. Valid values are `VOLUME` and `INSTANCE`.
        """
        return pulumi.get(self, "resource_types")

    @property
    @pulumi.getter
    def schedules(self) -> Optional[Sequence['outputs.LifecyclePolicyPolicyDetailsSchedule']]:
        """
        See the `schedule` configuration block.
        """
        return pulumi.get(self, "schedules")

    @property
    @pulumi.getter(name="targetTags")
    def target_tags(self) -> Optional[Mapping[str, str]]:
        """
        A map of tag keys and their values. Any resources that match the `resource_types` and are tagged with _any_ of these tags will be targeted.

        > Note: You cannot have overlapping lifecycle policies that share the same `target_tags`. This provider is unable to detect this at plan time but it will fail during apply.
        """
        return pulumi.get(self, "target_tags")


@pulumi.output_type
class LifecyclePolicyPolicyDetailsAction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "crossRegionCopies":
            suggest = "cross_region_copies"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LifecyclePolicyPolicyDetailsAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LifecyclePolicyPolicyDetailsAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LifecyclePolicyPolicyDetailsAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cross_region_copies: Sequence['outputs.LifecyclePolicyPolicyDetailsActionCrossRegionCopy'],
                 name: str):
        """
        :param Sequence['LifecyclePolicyPolicyDetailsActionCrossRegionCopyArgs'] cross_region_copies: The rule for copying shared snapshots across Regions. See the `cross_region_copy` configuration block.
        :param str name: A descriptive name for the action.
        """
        pulumi.set(__self__, "cross_region_copies", cross_region_copies)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="crossRegionCopies")
    def cross_region_copies(self) -> Sequence['outputs.LifecyclePolicyPolicyDetailsActionCrossRegionCopy']:
        """
        The rule for copying shared snapshots across Regions. See the `cross_region_copy` configuration block.
        """
        return pulumi.get(self, "cross_region_copies")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A descriptive name for the action.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class LifecyclePolicyPolicyDetailsActionCrossRegionCopy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "encryptionConfiguration":
            suggest = "encryption_configuration"
        elif key == "retainRule":
            suggest = "retain_rule"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LifecyclePolicyPolicyDetailsActionCrossRegionCopy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LifecyclePolicyPolicyDetailsActionCrossRegionCopy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LifecyclePolicyPolicyDetailsActionCrossRegionCopy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 encryption_configuration: 'outputs.LifecyclePolicyPolicyDetailsActionCrossRegionCopyEncryptionConfiguration',
                 target: str,
                 retain_rule: Optional['outputs.LifecyclePolicyPolicyDetailsActionCrossRegionCopyRetainRule'] = None):
        """
        :param 'LifecyclePolicyPolicyDetailsActionCrossRegionCopyEncryptionConfigurationArgs' encryption_configuration: The encryption settings for the copied snapshot. See the `encryption_configuration` block. Max of 1 per action.
        :param str target: The target Region or the Amazon Resource Name (ARN) of the target Outpost for the snapshot copies.
        :param 'LifecyclePolicyPolicyDetailsActionCrossRegionCopyRetainRuleArgs' retain_rule: Specifies the retention rule for cross-Region snapshot copies. See the `retain_rule` block. Max of 1 per action.
        """
        pulumi.set(__self__, "encryption_configuration", encryption_configuration)
        pulumi.set(__self__, "target", target)
        if retain_rule is not None:
            pulumi.set(__self__, "retain_rule", retain_rule)

    @property
    @pulumi.getter(name="encryptionConfiguration")
    def encryption_configuration(self) -> 'outputs.LifecyclePolicyPolicyDetailsActionCrossRegionCopyEncryptionConfiguration':
        """
        The encryption settings for the copied snapshot. See the `encryption_configuration` block. Max of 1 per action.
        """
        return pulumi.get(self, "encryption_configuration")

    @property
    @pulumi.getter
    def target(self) -> str:
        """
        The target Region or the Amazon Resource Name (ARN) of the target Outpost for the snapshot copies.
        """
        return pulumi.get(self, "target")

    @property
    @pulumi.getter(name="retainRule")
    def retain_rule(self) -> Optional['outputs.LifecyclePolicyPolicyDetailsActionCrossRegionCopyRetainRule']:
        """
        Specifies the retention rule for cross-Region snapshot copies. See the `retain_rule` block. Max of 1 per action.
        """
        return pulumi.get(self, "retain_rule")


@pulumi.output_type
class LifecyclePolicyPolicyDetailsActionCrossRegionCopyEncryptionConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cmkArn":
            suggest = "cmk_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LifecyclePolicyPolicyDetailsActionCrossRegionCopyEncryptionConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LifecyclePolicyPolicyDetailsActionCrossRegionCopyEncryptionConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LifecyclePolicyPolicyDetailsActionCrossRegionCopyEncryptionConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cmk_arn: Optional[str] = None,
                 encrypted: Optional[bool] = None):
        """
        :param str cmk_arn: The Amazon Resource Name (ARN) of the AWS KMS key to use for EBS encryption. If this parameter is not specified, the default KMS key for the account is used.
        :param bool encrypted: To encrypt a copy of an unencrypted snapshot when encryption by default is not enabled, enable encryption using this parameter. Copies of encrypted snapshots are encrypted, even if this parameter is false or when encryption by default is not enabled.
        """
        if cmk_arn is not None:
            pulumi.set(__self__, "cmk_arn", cmk_arn)
        if encrypted is not None:
            pulumi.set(__self__, "encrypted", encrypted)

    @property
    @pulumi.getter(name="cmkArn")
    def cmk_arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of the AWS KMS key to use for EBS encryption. If this parameter is not specified, the default KMS key for the account is used.
        """
        return pulumi.get(self, "cmk_arn")

    @property
    @pulumi.getter
    def encrypted(self) -> Optional[bool]:
        """
        To encrypt a copy of an unencrypted snapshot when encryption by default is not enabled, enable encryption using this parameter. Copies of encrypted snapshots are encrypted, even if this parameter is false or when encryption by default is not enabled.
        """
        return pulumi.get(self, "encrypted")


@pulumi.output_type
class LifecyclePolicyPolicyDetailsActionCrossRegionCopyRetainRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "intervalUnit":
            suggest = "interval_unit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LifecyclePolicyPolicyDetailsActionCrossRegionCopyRetainRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LifecyclePolicyPolicyDetailsActionCrossRegionCopyRetainRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LifecyclePolicyPolicyDetailsActionCrossRegionCopyRetainRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 interval: int,
                 interval_unit: str):
        """
        :param int interval: How often this lifecycle policy should be evaluated. `1`, `2`,`3`,`4`,`6`,`8`,`12` or `24` are valid values. Conflicts with `cron_expression`. If set, `interval_unit` and `times` must also be set.
        :param str interval_unit: The unit for how often the lifecycle policy should be evaluated. `HOURS` is currently the only allowed value and also the default value. Conflicts with `cron_expression`. Must be set if `interval` is set.
        """
        pulumi.set(__self__, "interval", interval)
        pulumi.set(__self__, "interval_unit", interval_unit)

    @property
    @pulumi.getter
    def interval(self) -> int:
        """
        How often this lifecycle policy should be evaluated. `1`, `2`,`3`,`4`,`6`,`8`,`12` or `24` are valid values. Conflicts with `cron_expression`. If set, `interval_unit` and `times` must also be set.
        """
        return pulumi.get(self, "interval")

    @property
    @pulumi.getter(name="intervalUnit")
    def interval_unit(self) -> str:
        """
        The unit for how often the lifecycle policy should be evaluated. `HOURS` is currently the only allowed value and also the default value. Conflicts with `cron_expression`. Must be set if `interval` is set.
        """
        return pulumi.get(self, "interval_unit")


@pulumi.output_type
class LifecyclePolicyPolicyDetailsEventSource(dict):
    def __init__(__self__, *,
                 parameters: 'outputs.LifecyclePolicyPolicyDetailsEventSourceParameters',
                 type: str):
        """
        :param 'LifecyclePolicyPolicyDetailsEventSourceParametersArgs' parameters: A set of optional parameters for snapshot and AMI lifecycle policies. See the `parameters` configuration block.
        :param str type: The source of the event. Currently only managed CloudWatch Events rules are supported. Valid values are `MANAGED_CWE`.
        """
        pulumi.set(__self__, "parameters", parameters)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def parameters(self) -> 'outputs.LifecyclePolicyPolicyDetailsEventSourceParameters':
        """
        A set of optional parameters for snapshot and AMI lifecycle policies. See the `parameters` configuration block.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The source of the event. Currently only managed CloudWatch Events rules are supported. Valid values are `MANAGED_CWE`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class LifecyclePolicyPolicyDetailsEventSourceParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "descriptionRegex":
            suggest = "description_regex"
        elif key == "eventType":
            suggest = "event_type"
        elif key == "snapshotOwners":
            suggest = "snapshot_owners"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LifecyclePolicyPolicyDetailsEventSourceParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LifecyclePolicyPolicyDetailsEventSourceParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LifecyclePolicyPolicyDetailsEventSourceParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 description_regex: str,
                 event_type: str,
                 snapshot_owners: Sequence[str]):
        """
        :param str description_regex: The snapshot description that can trigger the policy. The description pattern is specified using a regular expression. The policy runs only if a snapshot with a description that matches the specified pattern is shared with your account.
        :param str event_type: The type of event. Currently, only `shareSnapshot` events are supported.
        :param Sequence[str] snapshot_owners: The IDs of the AWS accounts that can trigger policy by sharing snapshots with your account. The policy only runs if one of the specified AWS accounts shares a snapshot with your account.
        """
        pulumi.set(__self__, "description_regex", description_regex)
        pulumi.set(__self__, "event_type", event_type)
        pulumi.set(__self__, "snapshot_owners", snapshot_owners)

    @property
    @pulumi.getter(name="descriptionRegex")
    def description_regex(self) -> str:
        """
        The snapshot description that can trigger the policy. The description pattern is specified using a regular expression. The policy runs only if a snapshot with a description that matches the specified pattern is shared with your account.
        """
        return pulumi.get(self, "description_regex")

    @property
    @pulumi.getter(name="eventType")
    def event_type(self) -> str:
        """
        The type of event. Currently, only `shareSnapshot` events are supported.
        """
        return pulumi.get(self, "event_type")

    @property
    @pulumi.getter(name="snapshotOwners")
    def snapshot_owners(self) -> Sequence[str]:
        """
        The IDs of the AWS accounts that can trigger policy by sharing snapshots with your account. The policy only runs if one of the specified AWS accounts shares a snapshot with your account.
        """
        return pulumi.get(self, "snapshot_owners")


@pulumi.output_type
class LifecyclePolicyPolicyDetailsParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "excludeBootVolume":
            suggest = "exclude_boot_volume"
        elif key == "noReboot":
            suggest = "no_reboot"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LifecyclePolicyPolicyDetailsParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LifecyclePolicyPolicyDetailsParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LifecyclePolicyPolicyDetailsParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 exclude_boot_volume: Optional[bool] = None,
                 no_reboot: Optional[bool] = None):
        """
        :param bool exclude_boot_volume: Indicates whether to exclude the root volume from snapshots created using CreateSnapshots. The default is `false`.
        :param bool no_reboot: Applies to AMI lifecycle policies only. Indicates whether targeted instances are rebooted when the lifecycle policy runs. `true` indicates that targeted instances are not rebooted when the policy runs. `false` indicates that target instances are rebooted when the policy runs. The default is `true` (instances are not rebooted).
        """
        if exclude_boot_volume is not None:
            pulumi.set(__self__, "exclude_boot_volume", exclude_boot_volume)
        if no_reboot is not None:
            pulumi.set(__self__, "no_reboot", no_reboot)

    @property
    @pulumi.getter(name="excludeBootVolume")
    def exclude_boot_volume(self) -> Optional[bool]:
        """
        Indicates whether to exclude the root volume from snapshots created using CreateSnapshots. The default is `false`.
        """
        return pulumi.get(self, "exclude_boot_volume")

    @property
    @pulumi.getter(name="noReboot")
    def no_reboot(self) -> Optional[bool]:
        """
        Applies to AMI lifecycle policies only. Indicates whether targeted instances are rebooted when the lifecycle policy runs. `true` indicates that targeted instances are not rebooted when the policy runs. `false` indicates that target instances are rebooted when the policy runs. The default is `true` (instances are not rebooted).
        """
        return pulumi.get(self, "no_reboot")


@pulumi.output_type
class LifecyclePolicyPolicyDetailsSchedule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createRule":
            suggest = "create_rule"
        elif key == "retainRule":
            suggest = "retain_rule"
        elif key == "copyTags":
            suggest = "copy_tags"
        elif key == "crossRegionCopyRules":
            suggest = "cross_region_copy_rules"
        elif key == "deprecateRule":
            suggest = "deprecate_rule"
        elif key == "fastRestoreRule":
            suggest = "fast_restore_rule"
        elif key == "shareRule":
            suggest = "share_rule"
        elif key == "tagsToAdd":
            suggest = "tags_to_add"
        elif key == "variableTags":
            suggest = "variable_tags"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LifecyclePolicyPolicyDetailsSchedule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LifecyclePolicyPolicyDetailsSchedule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LifecyclePolicyPolicyDetailsSchedule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 create_rule: 'outputs.LifecyclePolicyPolicyDetailsScheduleCreateRule',
                 name: str,
                 retain_rule: 'outputs.LifecyclePolicyPolicyDetailsScheduleRetainRule',
                 copy_tags: Optional[bool] = None,
                 cross_region_copy_rules: Optional[Sequence['outputs.LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRule']] = None,
                 deprecate_rule: Optional['outputs.LifecyclePolicyPolicyDetailsScheduleDeprecateRule'] = None,
                 fast_restore_rule: Optional['outputs.LifecyclePolicyPolicyDetailsScheduleFastRestoreRule'] = None,
                 share_rule: Optional['outputs.LifecyclePolicyPolicyDetailsScheduleShareRule'] = None,
                 tags_to_add: Optional[Mapping[str, str]] = None,
                 variable_tags: Optional[Mapping[str, str]] = None):
        """
        :param 'LifecyclePolicyPolicyDetailsScheduleCreateRuleArgs' create_rule: See the `create_rule` block. Max of 1 per schedule.
        :param str name: A descriptive name for the action.
        :param 'LifecyclePolicyPolicyDetailsScheduleRetainRuleArgs' retain_rule: Specifies the retention rule for cross-Region snapshot copies. See the `retain_rule` block. Max of 1 per action.
        :param bool copy_tags: Copy all user-defined tags on a source volume to snapshots of the volume created by this policy.
        :param Sequence['LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleArgs'] cross_region_copy_rules: See the `cross_region_copy_rule` block. Max of 3 per schedule.
        :param 'LifecyclePolicyPolicyDetailsScheduleDeprecateRuleArgs' deprecate_rule: See the `deprecate_rule` block. Max of 1 per schedule.
        :param 'LifecyclePolicyPolicyDetailsScheduleFastRestoreRuleArgs' fast_restore_rule: See the `fast_restore_rule` block. Max of 1 per schedule.
        :param 'LifecyclePolicyPolicyDetailsScheduleShareRuleArgs' share_rule: See the `share_rule` block. Max of 1 per schedule.
        :param Mapping[str, str] tags_to_add: A map of tag keys and their values. DLM lifecycle policies will already tag the snapshot with the tags on the volume. This configuration adds extra tags on top of these.
        :param Mapping[str, str] variable_tags: A map of tag keys and variable values, where the values are determined when the policy is executed. Only `$(instance-id)` or `$(timestamp)` are valid values. Can only be used when `resource_types` is `INSTANCE`.
        """
        pulumi.set(__self__, "create_rule", create_rule)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "retain_rule", retain_rule)
        if copy_tags is not None:
            pulumi.set(__self__, "copy_tags", copy_tags)
        if cross_region_copy_rules is not None:
            pulumi.set(__self__, "cross_region_copy_rules", cross_region_copy_rules)
        if deprecate_rule is not None:
            pulumi.set(__self__, "deprecate_rule", deprecate_rule)
        if fast_restore_rule is not None:
            pulumi.set(__self__, "fast_restore_rule", fast_restore_rule)
        if share_rule is not None:
            pulumi.set(__self__, "share_rule", share_rule)
        if tags_to_add is not None:
            pulumi.set(__self__, "tags_to_add", tags_to_add)
        if variable_tags is not None:
            pulumi.set(__self__, "variable_tags", variable_tags)

    @property
    @pulumi.getter(name="createRule")
    def create_rule(self) -> 'outputs.LifecyclePolicyPolicyDetailsScheduleCreateRule':
        """
        See the `create_rule` block. Max of 1 per schedule.
        """
        return pulumi.get(self, "create_rule")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A descriptive name for the action.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="retainRule")
    def retain_rule(self) -> 'outputs.LifecyclePolicyPolicyDetailsScheduleRetainRule':
        """
        Specifies the retention rule for cross-Region snapshot copies. See the `retain_rule` block. Max of 1 per action.
        """
        return pulumi.get(self, "retain_rule")

    @property
    @pulumi.getter(name="copyTags")
    def copy_tags(self) -> Optional[bool]:
        """
        Copy all user-defined tags on a source volume to snapshots of the volume created by this policy.
        """
        return pulumi.get(self, "copy_tags")

    @property
    @pulumi.getter(name="crossRegionCopyRules")
    def cross_region_copy_rules(self) -> Optional[Sequence['outputs.LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRule']]:
        """
        See the `cross_region_copy_rule` block. Max of 3 per schedule.
        """
        return pulumi.get(self, "cross_region_copy_rules")

    @property
    @pulumi.getter(name="deprecateRule")
    def deprecate_rule(self) -> Optional['outputs.LifecyclePolicyPolicyDetailsScheduleDeprecateRule']:
        """
        See the `deprecate_rule` block. Max of 1 per schedule.
        """
        return pulumi.get(self, "deprecate_rule")

    @property
    @pulumi.getter(name="fastRestoreRule")
    def fast_restore_rule(self) -> Optional['outputs.LifecyclePolicyPolicyDetailsScheduleFastRestoreRule']:
        """
        See the `fast_restore_rule` block. Max of 1 per schedule.
        """
        return pulumi.get(self, "fast_restore_rule")

    @property
    @pulumi.getter(name="shareRule")
    def share_rule(self) -> Optional['outputs.LifecyclePolicyPolicyDetailsScheduleShareRule']:
        """
        See the `share_rule` block. Max of 1 per schedule.
        """
        return pulumi.get(self, "share_rule")

    @property
    @pulumi.getter(name="tagsToAdd")
    def tags_to_add(self) -> Optional[Mapping[str, str]]:
        """
        A map of tag keys and their values. DLM lifecycle policies will already tag the snapshot with the tags on the volume. This configuration adds extra tags on top of these.
        """
        return pulumi.get(self, "tags_to_add")

    @property
    @pulumi.getter(name="variableTags")
    def variable_tags(self) -> Optional[Mapping[str, str]]:
        """
        A map of tag keys and variable values, where the values are determined when the policy is executed. Only `$(instance-id)` or `$(timestamp)` are valid values. Can only be used when `resource_types` is `INSTANCE`.
        """
        return pulumi.get(self, "variable_tags")


@pulumi.output_type
class LifecyclePolicyPolicyDetailsScheduleCreateRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cronExpression":
            suggest = "cron_expression"
        elif key == "intervalUnit":
            suggest = "interval_unit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LifecyclePolicyPolicyDetailsScheduleCreateRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LifecyclePolicyPolicyDetailsScheduleCreateRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LifecyclePolicyPolicyDetailsScheduleCreateRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cron_expression: Optional[str] = None,
                 interval: Optional[int] = None,
                 interval_unit: Optional[str] = None,
                 location: Optional[str] = None,
                 times: Optional[str] = None):
        """
        :param str cron_expression: The schedule, as a Cron expression. The schedule interval must be between 1 hour and 1 year. Conflicts with `interval`, `interval_unit`, and `times`.
        :param int interval: How often this lifecycle policy should be evaluated. `1`, `2`,`3`,`4`,`6`,`8`,`12` or `24` are valid values. Conflicts with `cron_expression`. If set, `interval_unit` and `times` must also be set.
        :param str interval_unit: The unit for how often the lifecycle policy should be evaluated. `HOURS` is currently the only allowed value and also the default value. Conflicts with `cron_expression`. Must be set if `interval` is set.
        :param str location: Specifies the destination for snapshots created by the policy. To create snapshots in the same Region as the source resource, specify `CLOUD`. To create snapshots on the same Outpost as the source resource, specify `OUTPOST_LOCAL`. If you omit this parameter, `CLOUD` is used by default. If the policy targets resources in an AWS Region, then you must create snapshots in the same Region as the source resource. If the policy targets resources on an Outpost, then you can create snapshots on the same Outpost as the source resource, or in the Region of that Outpost. Valid values are `CLOUD` and `OUTPOST_LOCAL`.
        :param str times: A list of times in 24 hour clock format that sets when the lifecycle policy should be evaluated. Max of 1. Conflicts with `cron_expression`. Must be set if `interval` is set.
        """
        if cron_expression is not None:
            pulumi.set(__self__, "cron_expression", cron_expression)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if interval_unit is not None:
            pulumi.set(__self__, "interval_unit", interval_unit)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if times is not None:
            pulumi.set(__self__, "times", times)

    @property
    @pulumi.getter(name="cronExpression")
    def cron_expression(self) -> Optional[str]:
        """
        The schedule, as a Cron expression. The schedule interval must be between 1 hour and 1 year. Conflicts with `interval`, `interval_unit`, and `times`.
        """
        return pulumi.get(self, "cron_expression")

    @property
    @pulumi.getter
    def interval(self) -> Optional[int]:
        """
        How often this lifecycle policy should be evaluated. `1`, `2`,`3`,`4`,`6`,`8`,`12` or `24` are valid values. Conflicts with `cron_expression`. If set, `interval_unit` and `times` must also be set.
        """
        return pulumi.get(self, "interval")

    @property
    @pulumi.getter(name="intervalUnit")
    def interval_unit(self) -> Optional[str]:
        """
        The unit for how often the lifecycle policy should be evaluated. `HOURS` is currently the only allowed value and also the default value. Conflicts with `cron_expression`. Must be set if `interval` is set.
        """
        return pulumi.get(self, "interval_unit")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        Specifies the destination for snapshots created by the policy. To create snapshots in the same Region as the source resource, specify `CLOUD`. To create snapshots on the same Outpost as the source resource, specify `OUTPOST_LOCAL`. If you omit this parameter, `CLOUD` is used by default. If the policy targets resources in an AWS Region, then you must create snapshots in the same Region as the source resource. If the policy targets resources on an Outpost, then you can create snapshots on the same Outpost as the source resource, or in the Region of that Outpost. Valid values are `CLOUD` and `OUTPOST_LOCAL`.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def times(self) -> Optional[str]:
        """
        A list of times in 24 hour clock format that sets when the lifecycle policy should be evaluated. Max of 1. Conflicts with `cron_expression`. Must be set if `interval` is set.
        """
        return pulumi.get(self, "times")


@pulumi.output_type
class LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cmkArn":
            suggest = "cmk_arn"
        elif key == "copyTags":
            suggest = "copy_tags"
        elif key == "deprecateRule":
            suggest = "deprecate_rule"
        elif key == "retainRule":
            suggest = "retain_rule"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 encrypted: bool,
                 target: str,
                 cmk_arn: Optional[str] = None,
                 copy_tags: Optional[bool] = None,
                 deprecate_rule: Optional['outputs.LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleDeprecateRule'] = None,
                 retain_rule: Optional['outputs.LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleRetainRule'] = None):
        """
        :param bool encrypted: To encrypt a copy of an unencrypted snapshot when encryption by default is not enabled, enable encryption using this parameter. Copies of encrypted snapshots are encrypted, even if this parameter is false or when encryption by default is not enabled.
        :param str target: The target Region or the Amazon Resource Name (ARN) of the target Outpost for the snapshot copies.
        :param str cmk_arn: The Amazon Resource Name (ARN) of the AWS KMS key to use for EBS encryption. If this parameter is not specified, the default KMS key for the account is used.
        :param bool copy_tags: Copy all user-defined tags on a source volume to snapshots of the volume created by this policy.
        :param 'LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleDeprecateRuleArgs' deprecate_rule: See the `deprecate_rule` block. Max of 1 per schedule.
        :param 'LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleRetainRuleArgs' retain_rule: Specifies the retention rule for cross-Region snapshot copies. See the `retain_rule` block. Max of 1 per action.
        """
        pulumi.set(__self__, "encrypted", encrypted)
        pulumi.set(__self__, "target", target)
        if cmk_arn is not None:
            pulumi.set(__self__, "cmk_arn", cmk_arn)
        if copy_tags is not None:
            pulumi.set(__self__, "copy_tags", copy_tags)
        if deprecate_rule is not None:
            pulumi.set(__self__, "deprecate_rule", deprecate_rule)
        if retain_rule is not None:
            pulumi.set(__self__, "retain_rule", retain_rule)

    @property
    @pulumi.getter
    def encrypted(self) -> bool:
        """
        To encrypt a copy of an unencrypted snapshot when encryption by default is not enabled, enable encryption using this parameter. Copies of encrypted snapshots are encrypted, even if this parameter is false or when encryption by default is not enabled.
        """
        return pulumi.get(self, "encrypted")

    @property
    @pulumi.getter
    def target(self) -> str:
        """
        The target Region or the Amazon Resource Name (ARN) of the target Outpost for the snapshot copies.
        """
        return pulumi.get(self, "target")

    @property
    @pulumi.getter(name="cmkArn")
    def cmk_arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of the AWS KMS key to use for EBS encryption. If this parameter is not specified, the default KMS key for the account is used.
        """
        return pulumi.get(self, "cmk_arn")

    @property
    @pulumi.getter(name="copyTags")
    def copy_tags(self) -> Optional[bool]:
        """
        Copy all user-defined tags on a source volume to snapshots of the volume created by this policy.
        """
        return pulumi.get(self, "copy_tags")

    @property
    @pulumi.getter(name="deprecateRule")
    def deprecate_rule(self) -> Optional['outputs.LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleDeprecateRule']:
        """
        See the `deprecate_rule` block. Max of 1 per schedule.
        """
        return pulumi.get(self, "deprecate_rule")

    @property
    @pulumi.getter(name="retainRule")
    def retain_rule(self) -> Optional['outputs.LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleRetainRule']:
        """
        Specifies the retention rule for cross-Region snapshot copies. See the `retain_rule` block. Max of 1 per action.
        """
        return pulumi.get(self, "retain_rule")


@pulumi.output_type
class LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleDeprecateRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "intervalUnit":
            suggest = "interval_unit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleDeprecateRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleDeprecateRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleDeprecateRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 interval: int,
                 interval_unit: str):
        """
        :param int interval: How often this lifecycle policy should be evaluated. `1`, `2`,`3`,`4`,`6`,`8`,`12` or `24` are valid values. Conflicts with `cron_expression`. If set, `interval_unit` and `times` must also be set.
        :param str interval_unit: The unit for how often the lifecycle policy should be evaluated. `HOURS` is currently the only allowed value and also the default value. Conflicts with `cron_expression`. Must be set if `interval` is set.
        """
        pulumi.set(__self__, "interval", interval)
        pulumi.set(__self__, "interval_unit", interval_unit)

    @property
    @pulumi.getter
    def interval(self) -> int:
        """
        How often this lifecycle policy should be evaluated. `1`, `2`,`3`,`4`,`6`,`8`,`12` or `24` are valid values. Conflicts with `cron_expression`. If set, `interval_unit` and `times` must also be set.
        """
        return pulumi.get(self, "interval")

    @property
    @pulumi.getter(name="intervalUnit")
    def interval_unit(self) -> str:
        """
        The unit for how often the lifecycle policy should be evaluated. `HOURS` is currently the only allowed value and also the default value. Conflicts with `cron_expression`. Must be set if `interval` is set.
        """
        return pulumi.get(self, "interval_unit")


@pulumi.output_type
class LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleRetainRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "intervalUnit":
            suggest = "interval_unit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleRetainRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleRetainRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleRetainRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 interval: int,
                 interval_unit: str):
        """
        :param int interval: How often this lifecycle policy should be evaluated. `1`, `2`,`3`,`4`,`6`,`8`,`12` or `24` are valid values. Conflicts with `cron_expression`. If set, `interval_unit` and `times` must also be set.
        :param str interval_unit: The unit for how often the lifecycle policy should be evaluated. `HOURS` is currently the only allowed value and also the default value. Conflicts with `cron_expression`. Must be set if `interval` is set.
        """
        pulumi.set(__self__, "interval", interval)
        pulumi.set(__self__, "interval_unit", interval_unit)

    @property
    @pulumi.getter
    def interval(self) -> int:
        """
        How often this lifecycle policy should be evaluated. `1`, `2`,`3`,`4`,`6`,`8`,`12` or `24` are valid values. Conflicts with `cron_expression`. If set, `interval_unit` and `times` must also be set.
        """
        return pulumi.get(self, "interval")

    @property
    @pulumi.getter(name="intervalUnit")
    def interval_unit(self) -> str:
        """
        The unit for how often the lifecycle policy should be evaluated. `HOURS` is currently the only allowed value and also the default value. Conflicts with `cron_expression`. Must be set if `interval` is set.
        """
        return pulumi.get(self, "interval_unit")


@pulumi.output_type
class LifecyclePolicyPolicyDetailsScheduleDeprecateRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "intervalUnit":
            suggest = "interval_unit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LifecyclePolicyPolicyDetailsScheduleDeprecateRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LifecyclePolicyPolicyDetailsScheduleDeprecateRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LifecyclePolicyPolicyDetailsScheduleDeprecateRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 count: Optional[int] = None,
                 interval: Optional[int] = None,
                 interval_unit: Optional[str] = None):
        """
        :param int count: Specifies the number of oldest AMIs to deprecate. Must be an integer between `1` and `1000`. Conflicts with `interval` and `interval_unit`.
        :param int interval: How often this lifecycle policy should be evaluated. `1`, `2`,`3`,`4`,`6`,`8`,`12` or `24` are valid values. Conflicts with `cron_expression`. If set, `interval_unit` and `times` must also be set.
        :param str interval_unit: The unit for how often the lifecycle policy should be evaluated. `HOURS` is currently the only allowed value and also the default value. Conflicts with `cron_expression`. Must be set if `interval` is set.
        """
        if count is not None:
            pulumi.set(__self__, "count", count)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if interval_unit is not None:
            pulumi.set(__self__, "interval_unit", interval_unit)

    @property
    @pulumi.getter
    def count(self) -> Optional[int]:
        """
        Specifies the number of oldest AMIs to deprecate. Must be an integer between `1` and `1000`. Conflicts with `interval` and `interval_unit`.
        """
        return pulumi.get(self, "count")

    @property
    @pulumi.getter
    def interval(self) -> Optional[int]:
        """
        How often this lifecycle policy should be evaluated. `1`, `2`,`3`,`4`,`6`,`8`,`12` or `24` are valid values. Conflicts with `cron_expression`. If set, `interval_unit` and `times` must also be set.
        """
        return pulumi.get(self, "interval")

    @property
    @pulumi.getter(name="intervalUnit")
    def interval_unit(self) -> Optional[str]:
        """
        The unit for how often the lifecycle policy should be evaluated. `HOURS` is currently the only allowed value and also the default value. Conflicts with `cron_expression`. Must be set if `interval` is set.
        """
        return pulumi.get(self, "interval_unit")


@pulumi.output_type
class LifecyclePolicyPolicyDetailsScheduleFastRestoreRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "availabilityZones":
            suggest = "availability_zones"
        elif key == "intervalUnit":
            suggest = "interval_unit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LifecyclePolicyPolicyDetailsScheduleFastRestoreRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LifecyclePolicyPolicyDetailsScheduleFastRestoreRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LifecyclePolicyPolicyDetailsScheduleFastRestoreRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 availability_zones: Sequence[str],
                 count: Optional[int] = None,
                 interval: Optional[int] = None,
                 interval_unit: Optional[str] = None):
        """
        :param Sequence[str] availability_zones: The Availability Zones in which to enable fast snapshot restore.
        :param int count: Specifies the number of oldest AMIs to deprecate. Must be an integer between `1` and `1000`. Conflicts with `interval` and `interval_unit`.
        :param int interval: How often this lifecycle policy should be evaluated. `1`, `2`,`3`,`4`,`6`,`8`,`12` or `24` are valid values. Conflicts with `cron_expression`. If set, `interval_unit` and `times` must also be set.
        :param str interval_unit: The unit for how often the lifecycle policy should be evaluated. `HOURS` is currently the only allowed value and also the default value. Conflicts with `cron_expression`. Must be set if `interval` is set.
        """
        pulumi.set(__self__, "availability_zones", availability_zones)
        if count is not None:
            pulumi.set(__self__, "count", count)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if interval_unit is not None:
            pulumi.set(__self__, "interval_unit", interval_unit)

    @property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> Sequence[str]:
        """
        The Availability Zones in which to enable fast snapshot restore.
        """
        return pulumi.get(self, "availability_zones")

    @property
    @pulumi.getter
    def count(self) -> Optional[int]:
        """
        Specifies the number of oldest AMIs to deprecate. Must be an integer between `1` and `1000`. Conflicts with `interval` and `interval_unit`.
        """
        return pulumi.get(self, "count")

    @property
    @pulumi.getter
    def interval(self) -> Optional[int]:
        """
        How often this lifecycle policy should be evaluated. `1`, `2`,`3`,`4`,`6`,`8`,`12` or `24` are valid values. Conflicts with `cron_expression`. If set, `interval_unit` and `times` must also be set.
        """
        return pulumi.get(self, "interval")

    @property
    @pulumi.getter(name="intervalUnit")
    def interval_unit(self) -> Optional[str]:
        """
        The unit for how often the lifecycle policy should be evaluated. `HOURS` is currently the only allowed value and also the default value. Conflicts with `cron_expression`. Must be set if `interval` is set.
        """
        return pulumi.get(self, "interval_unit")


@pulumi.output_type
class LifecyclePolicyPolicyDetailsScheduleRetainRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "intervalUnit":
            suggest = "interval_unit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LifecyclePolicyPolicyDetailsScheduleRetainRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LifecyclePolicyPolicyDetailsScheduleRetainRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LifecyclePolicyPolicyDetailsScheduleRetainRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 count: Optional[int] = None,
                 interval: Optional[int] = None,
                 interval_unit: Optional[str] = None):
        """
        :param int count: Specifies the number of oldest AMIs to deprecate. Must be an integer between `1` and `1000`. Conflicts with `interval` and `interval_unit`.
        :param int interval: How often this lifecycle policy should be evaluated. `1`, `2`,`3`,`4`,`6`,`8`,`12` or `24` are valid values. Conflicts with `cron_expression`. If set, `interval_unit` and `times` must also be set.
        :param str interval_unit: The unit for how often the lifecycle policy should be evaluated. `HOURS` is currently the only allowed value and also the default value. Conflicts with `cron_expression`. Must be set if `interval` is set.
        """
        if count is not None:
            pulumi.set(__self__, "count", count)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if interval_unit is not None:
            pulumi.set(__self__, "interval_unit", interval_unit)

    @property
    @pulumi.getter
    def count(self) -> Optional[int]:
        """
        Specifies the number of oldest AMIs to deprecate. Must be an integer between `1` and `1000`. Conflicts with `interval` and `interval_unit`.
        """
        return pulumi.get(self, "count")

    @property
    @pulumi.getter
    def interval(self) -> Optional[int]:
        """
        How often this lifecycle policy should be evaluated. `1`, `2`,`3`,`4`,`6`,`8`,`12` or `24` are valid values. Conflicts with `cron_expression`. If set, `interval_unit` and `times` must also be set.
        """
        return pulumi.get(self, "interval")

    @property
    @pulumi.getter(name="intervalUnit")
    def interval_unit(self) -> Optional[str]:
        """
        The unit for how often the lifecycle policy should be evaluated. `HOURS` is currently the only allowed value and also the default value. Conflicts with `cron_expression`. Must be set if `interval` is set.
        """
        return pulumi.get(self, "interval_unit")


@pulumi.output_type
class LifecyclePolicyPolicyDetailsScheduleShareRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetAccounts":
            suggest = "target_accounts"
        elif key == "unshareInterval":
            suggest = "unshare_interval"
        elif key == "unshareIntervalUnit":
            suggest = "unshare_interval_unit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LifecyclePolicyPolicyDetailsScheduleShareRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LifecyclePolicyPolicyDetailsScheduleShareRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LifecyclePolicyPolicyDetailsScheduleShareRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target_accounts: Sequence[str],
                 unshare_interval: Optional[int] = None,
                 unshare_interval_unit: Optional[str] = None):
        """
        :param Sequence[str] target_accounts: The IDs of the AWS accounts with which to share the snapshots.
        """
        pulumi.set(__self__, "target_accounts", target_accounts)
        if unshare_interval is not None:
            pulumi.set(__self__, "unshare_interval", unshare_interval)
        if unshare_interval_unit is not None:
            pulumi.set(__self__, "unshare_interval_unit", unshare_interval_unit)

    @property
    @pulumi.getter(name="targetAccounts")
    def target_accounts(self) -> Sequence[str]:
        """
        The IDs of the AWS accounts with which to share the snapshots.
        """
        return pulumi.get(self, "target_accounts")

    @property
    @pulumi.getter(name="unshareInterval")
    def unshare_interval(self) -> Optional[int]:
        return pulumi.get(self, "unshare_interval")

    @property
    @pulumi.getter(name="unshareIntervalUnit")
    def unshare_interval_unit(self) -> Optional[str]:
        return pulumi.get(self, "unshare_interval_unit")


