# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'EndpointElasticsearchSettings',
    'EndpointKafkaSettings',
    'EndpointKinesisSettings',
    'EndpointMongodbSettings',
    'EndpointRedisSettings',
    'EndpointRedshiftSettings',
    'EndpointS3Settings',
    'GetEndpointElasticsearchSettingResult',
    'GetEndpointKafkaSettingResult',
    'GetEndpointKinesisSettingResult',
    'GetEndpointMongodbSettingResult',
    'GetEndpointRedisSettingResult',
    'GetEndpointRedshiftSettingResult',
    'GetEndpointS3SettingResult',
]

@pulumi.output_type
class EndpointElasticsearchSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endpointUri":
            suggest = "endpoint_uri"
        elif key == "serviceAccessRoleArn":
            suggest = "service_access_role_arn"
        elif key == "errorRetryDuration":
            suggest = "error_retry_duration"
        elif key == "fullLoadErrorPercentage":
            suggest = "full_load_error_percentage"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EndpointElasticsearchSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EndpointElasticsearchSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EndpointElasticsearchSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint_uri: str,
                 service_access_role_arn: str,
                 error_retry_duration: Optional[int] = None,
                 full_load_error_percentage: Optional[int] = None):
        """
        :param str endpoint_uri: Endpoint for the OpenSearch cluster.
        :param str service_access_role_arn: ARN of the IAM Role with permissions to write to the OpenSearch cluster.
        :param int error_retry_duration: Maximum number of seconds for which DMS retries failed API requests to the OpenSearch cluster. Default is `300`.
        :param int full_load_error_percentage: Maximum percentage of records that can fail to be written before a full load operation stops. Default is `10`.
        """
        pulumi.set(__self__, "endpoint_uri", endpoint_uri)
        pulumi.set(__self__, "service_access_role_arn", service_access_role_arn)
        if error_retry_duration is not None:
            pulumi.set(__self__, "error_retry_duration", error_retry_duration)
        if full_load_error_percentage is not None:
            pulumi.set(__self__, "full_load_error_percentage", full_load_error_percentage)

    @property
    @pulumi.getter(name="endpointUri")
    def endpoint_uri(self) -> str:
        """
        Endpoint for the OpenSearch cluster.
        """
        return pulumi.get(self, "endpoint_uri")

    @property
    @pulumi.getter(name="serviceAccessRoleArn")
    def service_access_role_arn(self) -> str:
        """
        ARN of the IAM Role with permissions to write to the OpenSearch cluster.
        """
        return pulumi.get(self, "service_access_role_arn")

    @property
    @pulumi.getter(name="errorRetryDuration")
    def error_retry_duration(self) -> Optional[int]:
        """
        Maximum number of seconds for which DMS retries failed API requests to the OpenSearch cluster. Default is `300`.
        """
        return pulumi.get(self, "error_retry_duration")

    @property
    @pulumi.getter(name="fullLoadErrorPercentage")
    def full_load_error_percentage(self) -> Optional[int]:
        """
        Maximum percentage of records that can fail to be written before a full load operation stops. Default is `10`.
        """
        return pulumi.get(self, "full_load_error_percentage")


@pulumi.output_type
class EndpointKafkaSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "includeControlDetails":
            suggest = "include_control_details"
        elif key == "includeNullAndEmpty":
            suggest = "include_null_and_empty"
        elif key == "includePartitionValue":
            suggest = "include_partition_value"
        elif key == "includeTableAlterOperations":
            suggest = "include_table_alter_operations"
        elif key == "includeTransactionDetails":
            suggest = "include_transaction_details"
        elif key == "messageFormat":
            suggest = "message_format"
        elif key == "messageMaxBytes":
            suggest = "message_max_bytes"
        elif key == "noHexPrefix":
            suggest = "no_hex_prefix"
        elif key == "partitionIncludeSchemaTable":
            suggest = "partition_include_schema_table"
        elif key == "saslPassword":
            suggest = "sasl_password"
        elif key == "saslUsername":
            suggest = "sasl_username"
        elif key == "securityProtocol":
            suggest = "security_protocol"
        elif key == "sslCaCertificateArn":
            suggest = "ssl_ca_certificate_arn"
        elif key == "sslClientCertificateArn":
            suggest = "ssl_client_certificate_arn"
        elif key == "sslClientKeyArn":
            suggest = "ssl_client_key_arn"
        elif key == "sslClientKeyPassword":
            suggest = "ssl_client_key_password"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EndpointKafkaSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EndpointKafkaSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EndpointKafkaSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 broker: str,
                 include_control_details: Optional[bool] = None,
                 include_null_and_empty: Optional[bool] = None,
                 include_partition_value: Optional[bool] = None,
                 include_table_alter_operations: Optional[bool] = None,
                 include_transaction_details: Optional[bool] = None,
                 message_format: Optional[str] = None,
                 message_max_bytes: Optional[int] = None,
                 no_hex_prefix: Optional[bool] = None,
                 partition_include_schema_table: Optional[bool] = None,
                 sasl_password: Optional[str] = None,
                 sasl_username: Optional[str] = None,
                 security_protocol: Optional[str] = None,
                 ssl_ca_certificate_arn: Optional[str] = None,
                 ssl_client_certificate_arn: Optional[str] = None,
                 ssl_client_key_arn: Optional[str] = None,
                 ssl_client_key_password: Optional[str] = None,
                 topic: Optional[str] = None):
        """
        :param str broker: Kafka broker location. Specify in the form broker-hostname-or-ip:port.
        :param bool include_control_details: Shows detailed control information for table definition, column definition, and table and column changes in the Kafka message output. Default is `false`.
        :param bool include_null_and_empty: Include NULL and empty columns for records migrated to the endpoint. Default is `false`.
        :param bool include_partition_value: Shows the partition value within the Kafka message output unless the partition type is `schema-table-type`. Default is `false`.
        :param bool include_table_alter_operations: Includes any data definition language (DDL) operations that change the table in the control data, such as `rename-table`, `drop-table`, `add-column`, `drop-column`, and `rename-column`. Default is `false`.
        :param bool include_transaction_details: Provides detailed transaction information from the source database. This information includes a commit timestamp, a log position, and values for `transaction_id`, previous `transaction_id`, and `transaction_record_id` (the record offset within a transaction). Default is `false`.
        :param str message_format: Output format for the records created on the endpoint. Message format is `JSON` (default) or `JSON_UNFORMATTED` (a single line with no tab).
        :param int message_max_bytes: Maximum size in bytes for records created on the endpoint Default is `1,000,000`.
        :param bool no_hex_prefix: Set this optional parameter to true to avoid adding a '0x' prefix to raw data in hexadecimal format. For example, by default, AWS DMS adds a '0x' prefix to the LOB column type in hexadecimal format moving from an Oracle source to a Kafka target. Use the `no_hex_prefix` endpoint setting to enable migration of RAW data type columns without adding the `'0x'` prefix.
        :param bool partition_include_schema_table: Prefixes schema and table names to partition values, when the partition type is `primary-key-type`. Doing this increases data distribution among Kafka partitions. For example, suppose that a SysBench schema has thousands of tables and each table has only limited range for a primary key. In this case, the same primary key is sent from thousands of tables to the same partition, which causes throttling. Default is `false`.
        :param str sasl_password: Secure password you created when you first set up your MSK cluster to validate a client identity and make an encrypted connection between server and client using SASL-SSL authentication.
        :param str sasl_username: Secure user name you created when you first set up your MSK cluster to validate a client identity and make an encrypted connection between server and client using SASL-SSL authentication.
        :param str security_protocol: Set secure connection to a Kafka target endpoint using Transport Layer Security (TLS). Options include `ssl-encryption`, `ssl-authentication`, and `sasl-ssl`. `sasl-ssl` requires `sasl_username` and `sasl_password`.
        :param str ssl_ca_certificate_arn: ARN for the private certificate authority (CA) cert that AWS DMS uses to securely connect to your Kafka target endpoint.
        :param str ssl_client_certificate_arn: ARN of the client certificate used to securely connect to a Kafka target endpoint.
        :param str ssl_client_key_arn: ARN for the client private key used to securely connect to a Kafka target endpoint.
        :param str ssl_client_key_password: Password for the client private key used to securely connect to a Kafka target endpoint.
        :param str topic: Kafka topic for migration. Default is `kafka-default-topic`.
        """
        pulumi.set(__self__, "broker", broker)
        if include_control_details is not None:
            pulumi.set(__self__, "include_control_details", include_control_details)
        if include_null_and_empty is not None:
            pulumi.set(__self__, "include_null_and_empty", include_null_and_empty)
        if include_partition_value is not None:
            pulumi.set(__self__, "include_partition_value", include_partition_value)
        if include_table_alter_operations is not None:
            pulumi.set(__self__, "include_table_alter_operations", include_table_alter_operations)
        if include_transaction_details is not None:
            pulumi.set(__self__, "include_transaction_details", include_transaction_details)
        if message_format is not None:
            pulumi.set(__self__, "message_format", message_format)
        if message_max_bytes is not None:
            pulumi.set(__self__, "message_max_bytes", message_max_bytes)
        if no_hex_prefix is not None:
            pulumi.set(__self__, "no_hex_prefix", no_hex_prefix)
        if partition_include_schema_table is not None:
            pulumi.set(__self__, "partition_include_schema_table", partition_include_schema_table)
        if sasl_password is not None:
            pulumi.set(__self__, "sasl_password", sasl_password)
        if sasl_username is not None:
            pulumi.set(__self__, "sasl_username", sasl_username)
        if security_protocol is not None:
            pulumi.set(__self__, "security_protocol", security_protocol)
        if ssl_ca_certificate_arn is not None:
            pulumi.set(__self__, "ssl_ca_certificate_arn", ssl_ca_certificate_arn)
        if ssl_client_certificate_arn is not None:
            pulumi.set(__self__, "ssl_client_certificate_arn", ssl_client_certificate_arn)
        if ssl_client_key_arn is not None:
            pulumi.set(__self__, "ssl_client_key_arn", ssl_client_key_arn)
        if ssl_client_key_password is not None:
            pulumi.set(__self__, "ssl_client_key_password", ssl_client_key_password)
        if topic is not None:
            pulumi.set(__self__, "topic", topic)

    @property
    @pulumi.getter
    def broker(self) -> str:
        """
        Kafka broker location. Specify in the form broker-hostname-or-ip:port.
        """
        return pulumi.get(self, "broker")

    @property
    @pulumi.getter(name="includeControlDetails")
    def include_control_details(self) -> Optional[bool]:
        """
        Shows detailed control information for table definition, column definition, and table and column changes in the Kafka message output. Default is `false`.
        """
        return pulumi.get(self, "include_control_details")

    @property
    @pulumi.getter(name="includeNullAndEmpty")
    def include_null_and_empty(self) -> Optional[bool]:
        """
        Include NULL and empty columns for records migrated to the endpoint. Default is `false`.
        """
        return pulumi.get(self, "include_null_and_empty")

    @property
    @pulumi.getter(name="includePartitionValue")
    def include_partition_value(self) -> Optional[bool]:
        """
        Shows the partition value within the Kafka message output unless the partition type is `schema-table-type`. Default is `false`.
        """
        return pulumi.get(self, "include_partition_value")

    @property
    @pulumi.getter(name="includeTableAlterOperations")
    def include_table_alter_operations(self) -> Optional[bool]:
        """
        Includes any data definition language (DDL) operations that change the table in the control data, such as `rename-table`, `drop-table`, `add-column`, `drop-column`, and `rename-column`. Default is `false`.
        """
        return pulumi.get(self, "include_table_alter_operations")

    @property
    @pulumi.getter(name="includeTransactionDetails")
    def include_transaction_details(self) -> Optional[bool]:
        """
        Provides detailed transaction information from the source database. This information includes a commit timestamp, a log position, and values for `transaction_id`, previous `transaction_id`, and `transaction_record_id` (the record offset within a transaction). Default is `false`.
        """
        return pulumi.get(self, "include_transaction_details")

    @property
    @pulumi.getter(name="messageFormat")
    def message_format(self) -> Optional[str]:
        """
        Output format for the records created on the endpoint. Message format is `JSON` (default) or `JSON_UNFORMATTED` (a single line with no tab).
        """
        return pulumi.get(self, "message_format")

    @property
    @pulumi.getter(name="messageMaxBytes")
    def message_max_bytes(self) -> Optional[int]:
        """
        Maximum size in bytes for records created on the endpoint Default is `1,000,000`.
        """
        return pulumi.get(self, "message_max_bytes")

    @property
    @pulumi.getter(name="noHexPrefix")
    def no_hex_prefix(self) -> Optional[bool]:
        """
        Set this optional parameter to true to avoid adding a '0x' prefix to raw data in hexadecimal format. For example, by default, AWS DMS adds a '0x' prefix to the LOB column type in hexadecimal format moving from an Oracle source to a Kafka target. Use the `no_hex_prefix` endpoint setting to enable migration of RAW data type columns without adding the `'0x'` prefix.
        """
        return pulumi.get(self, "no_hex_prefix")

    @property
    @pulumi.getter(name="partitionIncludeSchemaTable")
    def partition_include_schema_table(self) -> Optional[bool]:
        """
        Prefixes schema and table names to partition values, when the partition type is `primary-key-type`. Doing this increases data distribution among Kafka partitions. For example, suppose that a SysBench schema has thousands of tables and each table has only limited range for a primary key. In this case, the same primary key is sent from thousands of tables to the same partition, which causes throttling. Default is `false`.
        """
        return pulumi.get(self, "partition_include_schema_table")

    @property
    @pulumi.getter(name="saslPassword")
    def sasl_password(self) -> Optional[str]:
        """
        Secure password you created when you first set up your MSK cluster to validate a client identity and make an encrypted connection between server and client using SASL-SSL authentication.
        """
        return pulumi.get(self, "sasl_password")

    @property
    @pulumi.getter(name="saslUsername")
    def sasl_username(self) -> Optional[str]:
        """
        Secure user name you created when you first set up your MSK cluster to validate a client identity and make an encrypted connection between server and client using SASL-SSL authentication.
        """
        return pulumi.get(self, "sasl_username")

    @property
    @pulumi.getter(name="securityProtocol")
    def security_protocol(self) -> Optional[str]:
        """
        Set secure connection to a Kafka target endpoint using Transport Layer Security (TLS). Options include `ssl-encryption`, `ssl-authentication`, and `sasl-ssl`. `sasl-ssl` requires `sasl_username` and `sasl_password`.
        """
        return pulumi.get(self, "security_protocol")

    @property
    @pulumi.getter(name="sslCaCertificateArn")
    def ssl_ca_certificate_arn(self) -> Optional[str]:
        """
        ARN for the private certificate authority (CA) cert that AWS DMS uses to securely connect to your Kafka target endpoint.
        """
        return pulumi.get(self, "ssl_ca_certificate_arn")

    @property
    @pulumi.getter(name="sslClientCertificateArn")
    def ssl_client_certificate_arn(self) -> Optional[str]:
        """
        ARN of the client certificate used to securely connect to a Kafka target endpoint.
        """
        return pulumi.get(self, "ssl_client_certificate_arn")

    @property
    @pulumi.getter(name="sslClientKeyArn")
    def ssl_client_key_arn(self) -> Optional[str]:
        """
        ARN for the client private key used to securely connect to a Kafka target endpoint.
        """
        return pulumi.get(self, "ssl_client_key_arn")

    @property
    @pulumi.getter(name="sslClientKeyPassword")
    def ssl_client_key_password(self) -> Optional[str]:
        """
        Password for the client private key used to securely connect to a Kafka target endpoint.
        """
        return pulumi.get(self, "ssl_client_key_password")

    @property
    @pulumi.getter
    def topic(self) -> Optional[str]:
        """
        Kafka topic for migration. Default is `kafka-default-topic`.
        """
        return pulumi.get(self, "topic")


@pulumi.output_type
class EndpointKinesisSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "includeControlDetails":
            suggest = "include_control_details"
        elif key == "includeNullAndEmpty":
            suggest = "include_null_and_empty"
        elif key == "includePartitionValue":
            suggest = "include_partition_value"
        elif key == "includeTableAlterOperations":
            suggest = "include_table_alter_operations"
        elif key == "includeTransactionDetails":
            suggest = "include_transaction_details"
        elif key == "messageFormat":
            suggest = "message_format"
        elif key == "partitionIncludeSchemaTable":
            suggest = "partition_include_schema_table"
        elif key == "serviceAccessRoleArn":
            suggest = "service_access_role_arn"
        elif key == "streamArn":
            suggest = "stream_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EndpointKinesisSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EndpointKinesisSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EndpointKinesisSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 include_control_details: Optional[bool] = None,
                 include_null_and_empty: Optional[bool] = None,
                 include_partition_value: Optional[bool] = None,
                 include_table_alter_operations: Optional[bool] = None,
                 include_transaction_details: Optional[bool] = None,
                 message_format: Optional[str] = None,
                 partition_include_schema_table: Optional[bool] = None,
                 service_access_role_arn: Optional[str] = None,
                 stream_arn: Optional[str] = None):
        """
        :param bool include_control_details: Shows detailed control information for table definition, column definition, and table and column changes in the Kinesis message output. Default is `false`.
        :param bool include_null_and_empty: Include NULL and empty columns in the target. Default is `false`.
        :param bool include_partition_value: Shows the partition value within the Kinesis message output, unless the partition type is schema-table-type. Default is `false`.
        :param bool include_table_alter_operations: Includes any data definition language (DDL) operations that change the table in the control data. Default is `false`.
        :param bool include_transaction_details: Provides detailed transaction information from the source database. Default is `false`.
        :param str message_format: Output format for the records created. Default is `json`. Valid values are `json` and `json-unformatted` (a single line with no tab).
        :param bool partition_include_schema_table: Prefixes schema and table names to partition values, when the partition type is primary-key-type. Default is `false`.
        :param str service_access_role_arn: ARN of the IAM Role with permissions to write to the Kinesis data stream.
        :param str stream_arn: ARN of the Kinesis data stream.
        """
        if include_control_details is not None:
            pulumi.set(__self__, "include_control_details", include_control_details)
        if include_null_and_empty is not None:
            pulumi.set(__self__, "include_null_and_empty", include_null_and_empty)
        if include_partition_value is not None:
            pulumi.set(__self__, "include_partition_value", include_partition_value)
        if include_table_alter_operations is not None:
            pulumi.set(__self__, "include_table_alter_operations", include_table_alter_operations)
        if include_transaction_details is not None:
            pulumi.set(__self__, "include_transaction_details", include_transaction_details)
        if message_format is not None:
            pulumi.set(__self__, "message_format", message_format)
        if partition_include_schema_table is not None:
            pulumi.set(__self__, "partition_include_schema_table", partition_include_schema_table)
        if service_access_role_arn is not None:
            pulumi.set(__self__, "service_access_role_arn", service_access_role_arn)
        if stream_arn is not None:
            pulumi.set(__self__, "stream_arn", stream_arn)

    @property
    @pulumi.getter(name="includeControlDetails")
    def include_control_details(self) -> Optional[bool]:
        """
        Shows detailed control information for table definition, column definition, and table and column changes in the Kinesis message output. Default is `false`.
        """
        return pulumi.get(self, "include_control_details")

    @property
    @pulumi.getter(name="includeNullAndEmpty")
    def include_null_and_empty(self) -> Optional[bool]:
        """
        Include NULL and empty columns in the target. Default is `false`.
        """
        return pulumi.get(self, "include_null_and_empty")

    @property
    @pulumi.getter(name="includePartitionValue")
    def include_partition_value(self) -> Optional[bool]:
        """
        Shows the partition value within the Kinesis message output, unless the partition type is schema-table-type. Default is `false`.
        """
        return pulumi.get(self, "include_partition_value")

    @property
    @pulumi.getter(name="includeTableAlterOperations")
    def include_table_alter_operations(self) -> Optional[bool]:
        """
        Includes any data definition language (DDL) operations that change the table in the control data. Default is `false`.
        """
        return pulumi.get(self, "include_table_alter_operations")

    @property
    @pulumi.getter(name="includeTransactionDetails")
    def include_transaction_details(self) -> Optional[bool]:
        """
        Provides detailed transaction information from the source database. Default is `false`.
        """
        return pulumi.get(self, "include_transaction_details")

    @property
    @pulumi.getter(name="messageFormat")
    def message_format(self) -> Optional[str]:
        """
        Output format for the records created. Default is `json`. Valid values are `json` and `json-unformatted` (a single line with no tab).
        """
        return pulumi.get(self, "message_format")

    @property
    @pulumi.getter(name="partitionIncludeSchemaTable")
    def partition_include_schema_table(self) -> Optional[bool]:
        """
        Prefixes schema and table names to partition values, when the partition type is primary-key-type. Default is `false`.
        """
        return pulumi.get(self, "partition_include_schema_table")

    @property
    @pulumi.getter(name="serviceAccessRoleArn")
    def service_access_role_arn(self) -> Optional[str]:
        """
        ARN of the IAM Role with permissions to write to the Kinesis data stream.
        """
        return pulumi.get(self, "service_access_role_arn")

    @property
    @pulumi.getter(name="streamArn")
    def stream_arn(self) -> Optional[str]:
        """
        ARN of the Kinesis data stream.
        """
        return pulumi.get(self, "stream_arn")


@pulumi.output_type
class EndpointMongodbSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authMechanism":
            suggest = "auth_mechanism"
        elif key == "authSource":
            suggest = "auth_source"
        elif key == "authType":
            suggest = "auth_type"
        elif key == "docsToInvestigate":
            suggest = "docs_to_investigate"
        elif key == "extractDocId":
            suggest = "extract_doc_id"
        elif key == "nestingLevel":
            suggest = "nesting_level"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EndpointMongodbSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EndpointMongodbSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EndpointMongodbSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auth_mechanism: Optional[str] = None,
                 auth_source: Optional[str] = None,
                 auth_type: Optional[str] = None,
                 docs_to_investigate: Optional[str] = None,
                 extract_doc_id: Optional[str] = None,
                 nesting_level: Optional[str] = None):
        """
        :param str auth_mechanism: Authentication mechanism to access the MongoDB source endpoint. Default is `default`.
        :param str auth_source: Authentication database name. Not used when `auth_type` is `no`. Default is `admin`.
        :param str auth_type: Authentication type to access the MongoDB source endpoint. Default is `password`.
        :param str docs_to_investigate: Number of documents to preview to determine the document organization. Use this setting when `nesting_level` is set to `one`. Default is `1000`.
        :param str extract_doc_id: Document ID. Use this setting when `nesting_level` is set to `none`. Default is `false`.
        :param str nesting_level: Specifies either document or table mode. Default is `none`. Valid values are `one` (table mode) and `none` (document mode).
        """
        if auth_mechanism is not None:
            pulumi.set(__self__, "auth_mechanism", auth_mechanism)
        if auth_source is not None:
            pulumi.set(__self__, "auth_source", auth_source)
        if auth_type is not None:
            pulumi.set(__self__, "auth_type", auth_type)
        if docs_to_investigate is not None:
            pulumi.set(__self__, "docs_to_investigate", docs_to_investigate)
        if extract_doc_id is not None:
            pulumi.set(__self__, "extract_doc_id", extract_doc_id)
        if nesting_level is not None:
            pulumi.set(__self__, "nesting_level", nesting_level)

    @property
    @pulumi.getter(name="authMechanism")
    def auth_mechanism(self) -> Optional[str]:
        """
        Authentication mechanism to access the MongoDB source endpoint. Default is `default`.
        """
        return pulumi.get(self, "auth_mechanism")

    @property
    @pulumi.getter(name="authSource")
    def auth_source(self) -> Optional[str]:
        """
        Authentication database name. Not used when `auth_type` is `no`. Default is `admin`.
        """
        return pulumi.get(self, "auth_source")

    @property
    @pulumi.getter(name="authType")
    def auth_type(self) -> Optional[str]:
        """
        Authentication type to access the MongoDB source endpoint. Default is `password`.
        """
        return pulumi.get(self, "auth_type")

    @property
    @pulumi.getter(name="docsToInvestigate")
    def docs_to_investigate(self) -> Optional[str]:
        """
        Number of documents to preview to determine the document organization. Use this setting when `nesting_level` is set to `one`. Default is `1000`.
        """
        return pulumi.get(self, "docs_to_investigate")

    @property
    @pulumi.getter(name="extractDocId")
    def extract_doc_id(self) -> Optional[str]:
        """
        Document ID. Use this setting when `nesting_level` is set to `none`. Default is `false`.
        """
        return pulumi.get(self, "extract_doc_id")

    @property
    @pulumi.getter(name="nestingLevel")
    def nesting_level(self) -> Optional[str]:
        """
        Specifies either document or table mode. Default is `none`. Valid values are `one` (table mode) and `none` (document mode).
        """
        return pulumi.get(self, "nesting_level")


@pulumi.output_type
class EndpointRedisSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authType":
            suggest = "auth_type"
        elif key == "serverName":
            suggest = "server_name"
        elif key == "authPassword":
            suggest = "auth_password"
        elif key == "authUserName":
            suggest = "auth_user_name"
        elif key == "sslCaCertificateArn":
            suggest = "ssl_ca_certificate_arn"
        elif key == "sslSecurityProtocol":
            suggest = "ssl_security_protocol"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EndpointRedisSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EndpointRedisSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EndpointRedisSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auth_type: str,
                 port: int,
                 server_name: str,
                 auth_password: Optional[str] = None,
                 auth_user_name: Optional[str] = None,
                 ssl_ca_certificate_arn: Optional[str] = None,
                 ssl_security_protocol: Optional[str] = None):
        """
        :param str auth_type: The type of authentication to perform when connecting to a Redis target. Options include `none`, `auth-token`, and `auth-role`. The `auth-token` option requires an `auth_password` value to be provided. The `auth-role` option requires `auth_user_name` and `auth_password` values to be provided.
        :param int port: Transmission Control Protocol (TCP) port for the endpoint.
        :param str server_name: Fully qualified domain name of the endpoint.
        :param str auth_password: The password provided with the auth-role and auth-token options of the AuthType setting for a Redis target endpoint.
        :param str auth_user_name: The username provided with the `auth-role` option of the AuthType setting for a Redis target endpoint.
        :param str ssl_ca_certificate_arn: The Amazon Resource Name (ARN) for the certificate authority (CA) that DMS uses to connect to your Redis target endpoint.
        :param str ssl_security_protocol: The plaintext option doesn't provide Transport Layer Security (TLS) encryption for traffic between endpoint and database. Options include `plaintext`, `ssl-encryption`. The default is `ssl-encryption`.
        """
        pulumi.set(__self__, "auth_type", auth_type)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "server_name", server_name)
        if auth_password is not None:
            pulumi.set(__self__, "auth_password", auth_password)
        if auth_user_name is not None:
            pulumi.set(__self__, "auth_user_name", auth_user_name)
        if ssl_ca_certificate_arn is not None:
            pulumi.set(__self__, "ssl_ca_certificate_arn", ssl_ca_certificate_arn)
        if ssl_security_protocol is not None:
            pulumi.set(__self__, "ssl_security_protocol", ssl_security_protocol)

    @property
    @pulumi.getter(name="authType")
    def auth_type(self) -> str:
        """
        The type of authentication to perform when connecting to a Redis target. Options include `none`, `auth-token`, and `auth-role`. The `auth-token` option requires an `auth_password` value to be provided. The `auth-role` option requires `auth_user_name` and `auth_password` values to be provided.
        """
        return pulumi.get(self, "auth_type")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        Transmission Control Protocol (TCP) port for the endpoint.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="serverName")
    def server_name(self) -> str:
        """
        Fully qualified domain name of the endpoint.
        """
        return pulumi.get(self, "server_name")

    @property
    @pulumi.getter(name="authPassword")
    def auth_password(self) -> Optional[str]:
        """
        The password provided with the auth-role and auth-token options of the AuthType setting for a Redis target endpoint.
        """
        return pulumi.get(self, "auth_password")

    @property
    @pulumi.getter(name="authUserName")
    def auth_user_name(self) -> Optional[str]:
        """
        The username provided with the `auth-role` option of the AuthType setting for a Redis target endpoint.
        """
        return pulumi.get(self, "auth_user_name")

    @property
    @pulumi.getter(name="sslCaCertificateArn")
    def ssl_ca_certificate_arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) for the certificate authority (CA) that DMS uses to connect to your Redis target endpoint.
        """
        return pulumi.get(self, "ssl_ca_certificate_arn")

    @property
    @pulumi.getter(name="sslSecurityProtocol")
    def ssl_security_protocol(self) -> Optional[str]:
        """
        The plaintext option doesn't provide Transport Layer Security (TLS) encryption for traffic between endpoint and database. Options include `plaintext`, `ssl-encryption`. The default is `ssl-encryption`.
        """
        return pulumi.get(self, "ssl_security_protocol")


@pulumi.output_type
class EndpointRedshiftSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketFolder":
            suggest = "bucket_folder"
        elif key == "bucketName":
            suggest = "bucket_name"
        elif key == "encryptionMode":
            suggest = "encryption_mode"
        elif key == "serverSideEncryptionKmsKeyId":
            suggest = "server_side_encryption_kms_key_id"
        elif key == "serviceAccessRoleArn":
            suggest = "service_access_role_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EndpointRedshiftSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EndpointRedshiftSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EndpointRedshiftSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_folder: Optional[str] = None,
                 bucket_name: Optional[str] = None,
                 encryption_mode: Optional[str] = None,
                 server_side_encryption_kms_key_id: Optional[str] = None,
                 service_access_role_arn: Optional[str] = None):
        """
        :param str bucket_folder: Custom S3 Bucket Object prefix for intermediate storage.
        :param str bucket_name: Custom S3 Bucket name for intermediate storage.
        :param str encryption_mode: The server-side encryption mode that you want to encrypt your intermediate .csv object files copied to S3. Defaults to `SSE_S3`. Valid values are `SSE_S3` and `SSE_KMS`.
        :param str server_side_encryption_kms_key_id: ARN or Id of KMS Key to use when `encryption_mode` is `SSE_KMS`.
        :param str service_access_role_arn: Amazon Resource Name (ARN) of the IAM Role with permissions to read from or write to the S3 Bucket for intermediate storage.
        """
        if bucket_folder is not None:
            pulumi.set(__self__, "bucket_folder", bucket_folder)
        if bucket_name is not None:
            pulumi.set(__self__, "bucket_name", bucket_name)
        if encryption_mode is not None:
            pulumi.set(__self__, "encryption_mode", encryption_mode)
        if server_side_encryption_kms_key_id is not None:
            pulumi.set(__self__, "server_side_encryption_kms_key_id", server_side_encryption_kms_key_id)
        if service_access_role_arn is not None:
            pulumi.set(__self__, "service_access_role_arn", service_access_role_arn)

    @property
    @pulumi.getter(name="bucketFolder")
    def bucket_folder(self) -> Optional[str]:
        """
        Custom S3 Bucket Object prefix for intermediate storage.
        """
        return pulumi.get(self, "bucket_folder")

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> Optional[str]:
        """
        Custom S3 Bucket name for intermediate storage.
        """
        return pulumi.get(self, "bucket_name")

    @property
    @pulumi.getter(name="encryptionMode")
    def encryption_mode(self) -> Optional[str]:
        """
        The server-side encryption mode that you want to encrypt your intermediate .csv object files copied to S3. Defaults to `SSE_S3`. Valid values are `SSE_S3` and `SSE_KMS`.
        """
        return pulumi.get(self, "encryption_mode")

    @property
    @pulumi.getter(name="serverSideEncryptionKmsKeyId")
    def server_side_encryption_kms_key_id(self) -> Optional[str]:
        """
        ARN or Id of KMS Key to use when `encryption_mode` is `SSE_KMS`.
        """
        return pulumi.get(self, "server_side_encryption_kms_key_id")

    @property
    @pulumi.getter(name="serviceAccessRoleArn")
    def service_access_role_arn(self) -> Optional[str]:
        """
        Amazon Resource Name (ARN) of the IAM Role with permissions to read from or write to the S3 Bucket for intermediate storage.
        """
        return pulumi.get(self, "service_access_role_arn")


@pulumi.output_type
class EndpointS3Settings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "addColumnName":
            suggest = "add_column_name"
        elif key == "bucketFolder":
            suggest = "bucket_folder"
        elif key == "bucketName":
            suggest = "bucket_name"
        elif key == "cannedAclForObjects":
            suggest = "canned_acl_for_objects"
        elif key == "cdcInsertsAndUpdates":
            suggest = "cdc_inserts_and_updates"
        elif key == "cdcInsertsOnly":
            suggest = "cdc_inserts_only"
        elif key == "cdcMaxBatchInterval":
            suggest = "cdc_max_batch_interval"
        elif key == "cdcMinFileSize":
            suggest = "cdc_min_file_size"
        elif key == "cdcPath":
            suggest = "cdc_path"
        elif key == "compressionType":
            suggest = "compression_type"
        elif key == "csvDelimiter":
            suggest = "csv_delimiter"
        elif key == "csvNoSupValue":
            suggest = "csv_no_sup_value"
        elif key == "csvNullValue":
            suggest = "csv_null_value"
        elif key == "csvRowDelimiter":
            suggest = "csv_row_delimiter"
        elif key == "dataFormat":
            suggest = "data_format"
        elif key == "dataPageSize":
            suggest = "data_page_size"
        elif key == "datePartitionDelimiter":
            suggest = "date_partition_delimiter"
        elif key == "datePartitionEnabled":
            suggest = "date_partition_enabled"
        elif key == "datePartitionSequence":
            suggest = "date_partition_sequence"
        elif key == "dictPageSizeLimit":
            suggest = "dict_page_size_limit"
        elif key == "enableStatistics":
            suggest = "enable_statistics"
        elif key == "encodingType":
            suggest = "encoding_type"
        elif key == "encryptionMode":
            suggest = "encryption_mode"
        elif key == "externalTableDefinition":
            suggest = "external_table_definition"
        elif key == "ignoreHeaderRows":
            suggest = "ignore_header_rows"
        elif key == "includeOpForFullLoad":
            suggest = "include_op_for_full_load"
        elif key == "maxFileSize":
            suggest = "max_file_size"
        elif key == "parquetTimestampInMillisecond":
            suggest = "parquet_timestamp_in_millisecond"
        elif key == "parquetVersion":
            suggest = "parquet_version"
        elif key == "preserveTransactions":
            suggest = "preserve_transactions"
        elif key == "rowGroupLength":
            suggest = "row_group_length"
        elif key == "serverSideEncryptionKmsKeyId":
            suggest = "server_side_encryption_kms_key_id"
        elif key == "serviceAccessRoleArn":
            suggest = "service_access_role_arn"
        elif key == "timestampColumnName":
            suggest = "timestamp_column_name"
        elif key == "useCsvNoSupValue":
            suggest = "use_csv_no_sup_value"
        elif key == "useTaskStartTimeForFullLoadTimestamp":
            suggest = "use_task_start_time_for_full_load_timestamp"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EndpointS3Settings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EndpointS3Settings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EndpointS3Settings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 add_column_name: Optional[bool] = None,
                 bucket_folder: Optional[str] = None,
                 bucket_name: Optional[str] = None,
                 canned_acl_for_objects: Optional[str] = None,
                 cdc_inserts_and_updates: Optional[bool] = None,
                 cdc_inserts_only: Optional[bool] = None,
                 cdc_max_batch_interval: Optional[int] = None,
                 cdc_min_file_size: Optional[int] = None,
                 cdc_path: Optional[str] = None,
                 compression_type: Optional[str] = None,
                 csv_delimiter: Optional[str] = None,
                 csv_no_sup_value: Optional[str] = None,
                 csv_null_value: Optional[str] = None,
                 csv_row_delimiter: Optional[str] = None,
                 data_format: Optional[str] = None,
                 data_page_size: Optional[int] = None,
                 date_partition_delimiter: Optional[str] = None,
                 date_partition_enabled: Optional[bool] = None,
                 date_partition_sequence: Optional[str] = None,
                 dict_page_size_limit: Optional[int] = None,
                 enable_statistics: Optional[bool] = None,
                 encoding_type: Optional[str] = None,
                 encryption_mode: Optional[str] = None,
                 external_table_definition: Optional[str] = None,
                 ignore_header_rows: Optional[int] = None,
                 include_op_for_full_load: Optional[bool] = None,
                 max_file_size: Optional[int] = None,
                 parquet_timestamp_in_millisecond: Optional[bool] = None,
                 parquet_version: Optional[str] = None,
                 preserve_transactions: Optional[bool] = None,
                 rfc4180: Optional[bool] = None,
                 row_group_length: Optional[int] = None,
                 server_side_encryption_kms_key_id: Optional[str] = None,
                 service_access_role_arn: Optional[str] = None,
                 timestamp_column_name: Optional[str] = None,
                 use_csv_no_sup_value: Optional[bool] = None,
                 use_task_start_time_for_full_load_timestamp: Optional[bool] = None):
        """
        :param bool add_column_name: Whether to add column name information to the .csv output file. Default is `false`.
        :param str bucket_folder: Custom S3 Bucket Object prefix for intermediate storage.
        :param str bucket_name: Custom S3 Bucket name for intermediate storage.
        :param str canned_acl_for_objects: Predefined (canned) access control list for objects created in an S3 bucket. Valid values include `none`, `private`, `public-read`, `public-read-write`, `authenticated-read`, `aws-exec-read`, `bucket-owner-read`, and `bucket-owner-full-control`. Default is `none`.
        :param bool cdc_inserts_and_updates: Whether to write insert and update operations to .csv or .parquet output files. Default is `false`.
        :param bool cdc_inserts_only: Whether to write insert operations to .csv or .parquet output files. Default is `false`.
        :param int cdc_max_batch_interval: Maximum length of the interval, defined in seconds, after which to output a file to Amazon S3. Default is `60`.
        :param int cdc_min_file_size: Minimum file size condition as defined in kilobytes to output a file to Amazon S3. Default is `32000`. **NOTE:** Previously, this setting was measured in megabytes but now represents kilobytes. Update configurations accordingly.
        :param str cdc_path: Folder path of CDC files. For an S3 source, this setting is required if a task captures change data; otherwise, it's optional. If `cdc_path` is set, AWS DMS reads CDC files from this path and replicates the data changes to the target endpoint. Supported in AWS DMS versions 3.4.2 and later.
        :param str compression_type: Set to compress target files. Default is `NONE`. Valid values are `GZIP` and `NONE`.
        :param str csv_delimiter: Delimiter used to separate columns in the source files. Default is `,`.
        :param str csv_no_sup_value: String to use for all columns not included in the supplemental log.
        :param str csv_null_value: String to as null when writing to the target.
        :param str csv_row_delimiter: Delimiter used to separate rows in the source files. Default is `\\n`.
        :param str data_format: Output format for the files that AWS DMS uses to create S3 objects. Valid values are `csv` and `parquet`. Default is `csv`.
        :param int data_page_size: Size of one data page in bytes. Default is `1048576` (1 MiB).
        :param str date_partition_delimiter: Date separating delimiter to use during folder partitioning. Valid values are `SLASH`, `UNDERSCORE`, `DASH`, and `NONE`. Default is `SLASH`.
        :param bool date_partition_enabled: Partition S3 bucket folders based on transaction commit dates. Default is `false`.
        :param str date_partition_sequence: Date format to use during folder partitioning. Use this parameter when `date_partition_enabled` is set to true. Valid values are `YYYYMMDD`, `YYYYMMDDHH`, `YYYYMM`, `MMYYYYDD`, and `DDMMYYYY`. Default is `YYYYMMDD`.
        :param int dict_page_size_limit: Maximum size in bytes of an encoded dictionary page of a column. Default is `1048576` (1 MiB).
        :param bool enable_statistics: Whether to enable statistics for Parquet pages and row groups. Default is `true`.
        :param str encoding_type: Type of encoding to use. Value values are `rle_dictionary`, `plain`, and `plain_dictionary`. Default is `rle_dictionary`.
        :param str encryption_mode: The server-side encryption mode that you want to encrypt your intermediate .csv object files copied to S3. Defaults to `SSE_S3`. Valid values are `SSE_S3` and `SSE_KMS`.
        :param str external_table_definition: JSON document that describes how AWS DMS should interpret the data.
        :param int ignore_header_rows: When this value is set to `1`, DMS ignores the first row header in a .csv file. Default is `0`.
        :param bool include_op_for_full_load: Whether to enable a full load to write INSERT operations to the .csv output files only to indicate how the rows were added to the source database. Default is `false`.
        :param int max_file_size: Maximum size (in KB) of any .csv file to be created while migrating to an S3 target during full load. Valid values are from `1` to `1048576`. Default is `1048576` (1 GB).
        :param bool parquet_timestamp_in_millisecond: Specifies the precision of any TIMESTAMP column values written to an S3 object file in .parquet format. Default is `false`.
        :param str parquet_version: Version of the .parquet file format. Default is `parquet-1-0`. Valid values are `parquet-1-0` and `parquet-2-0`.
        :param bool preserve_transactions: Whether DMS saves the transaction order for a CDC load on the S3 target specified by `cdc_path`. Default is `false`.
        :param bool rfc4180: For an S3 source, whether each leading double quotation mark has to be followed by an ending double quotation mark. Default is `true`.
        :param int row_group_length: Number of rows in a row group. Default is `10000`.
        :param str server_side_encryption_kms_key_id: ARN or Id of KMS Key to use when `encryption_mode` is `SSE_KMS`.
        :param str service_access_role_arn: ARN of the IAM Role with permissions to write to the OpenSearch cluster.
        :param str timestamp_column_name: Column to add with timestamp information to the endpoint data for an Amazon S3 target.
        :param bool use_csv_no_sup_value: Whether to use `csv_no_sup_value` for columns not included in the supplemental log.
        :param bool use_task_start_time_for_full_load_timestamp: When set to true, uses the task start time as the timestamp column value instead of the time data is written to target. For full load, when set to true, each row of the timestamp column contains the task start time. For CDC loads, each row of the timestamp column contains the transaction commit time. When set to false, the full load timestamp in the timestamp column increments with the time data arrives at the target. Default is `false`.
        """
        if add_column_name is not None:
            pulumi.set(__self__, "add_column_name", add_column_name)
        if bucket_folder is not None:
            pulumi.set(__self__, "bucket_folder", bucket_folder)
        if bucket_name is not None:
            pulumi.set(__self__, "bucket_name", bucket_name)
        if canned_acl_for_objects is not None:
            pulumi.set(__self__, "canned_acl_for_objects", canned_acl_for_objects)
        if cdc_inserts_and_updates is not None:
            pulumi.set(__self__, "cdc_inserts_and_updates", cdc_inserts_and_updates)
        if cdc_inserts_only is not None:
            pulumi.set(__self__, "cdc_inserts_only", cdc_inserts_only)
        if cdc_max_batch_interval is not None:
            pulumi.set(__self__, "cdc_max_batch_interval", cdc_max_batch_interval)
        if cdc_min_file_size is not None:
            pulumi.set(__self__, "cdc_min_file_size", cdc_min_file_size)
        if cdc_path is not None:
            pulumi.set(__self__, "cdc_path", cdc_path)
        if compression_type is not None:
            pulumi.set(__self__, "compression_type", compression_type)
        if csv_delimiter is not None:
            pulumi.set(__self__, "csv_delimiter", csv_delimiter)
        if csv_no_sup_value is not None:
            pulumi.set(__self__, "csv_no_sup_value", csv_no_sup_value)
        if csv_null_value is not None:
            pulumi.set(__self__, "csv_null_value", csv_null_value)
        if csv_row_delimiter is not None:
            pulumi.set(__self__, "csv_row_delimiter", csv_row_delimiter)
        if data_format is not None:
            pulumi.set(__self__, "data_format", data_format)
        if data_page_size is not None:
            pulumi.set(__self__, "data_page_size", data_page_size)
        if date_partition_delimiter is not None:
            pulumi.set(__self__, "date_partition_delimiter", date_partition_delimiter)
        if date_partition_enabled is not None:
            pulumi.set(__self__, "date_partition_enabled", date_partition_enabled)
        if date_partition_sequence is not None:
            pulumi.set(__self__, "date_partition_sequence", date_partition_sequence)
        if dict_page_size_limit is not None:
            pulumi.set(__self__, "dict_page_size_limit", dict_page_size_limit)
        if enable_statistics is not None:
            pulumi.set(__self__, "enable_statistics", enable_statistics)
        if encoding_type is not None:
            pulumi.set(__self__, "encoding_type", encoding_type)
        if encryption_mode is not None:
            pulumi.set(__self__, "encryption_mode", encryption_mode)
        if external_table_definition is not None:
            pulumi.set(__self__, "external_table_definition", external_table_definition)
        if ignore_header_rows is not None:
            pulumi.set(__self__, "ignore_header_rows", ignore_header_rows)
        if include_op_for_full_load is not None:
            pulumi.set(__self__, "include_op_for_full_load", include_op_for_full_load)
        if max_file_size is not None:
            pulumi.set(__self__, "max_file_size", max_file_size)
        if parquet_timestamp_in_millisecond is not None:
            pulumi.set(__self__, "parquet_timestamp_in_millisecond", parquet_timestamp_in_millisecond)
        if parquet_version is not None:
            pulumi.set(__self__, "parquet_version", parquet_version)
        if preserve_transactions is not None:
            pulumi.set(__self__, "preserve_transactions", preserve_transactions)
        if rfc4180 is not None:
            pulumi.set(__self__, "rfc4180", rfc4180)
        if row_group_length is not None:
            pulumi.set(__self__, "row_group_length", row_group_length)
        if server_side_encryption_kms_key_id is not None:
            pulumi.set(__self__, "server_side_encryption_kms_key_id", server_side_encryption_kms_key_id)
        if service_access_role_arn is not None:
            pulumi.set(__self__, "service_access_role_arn", service_access_role_arn)
        if timestamp_column_name is not None:
            pulumi.set(__self__, "timestamp_column_name", timestamp_column_name)
        if use_csv_no_sup_value is not None:
            pulumi.set(__self__, "use_csv_no_sup_value", use_csv_no_sup_value)
        if use_task_start_time_for_full_load_timestamp is not None:
            pulumi.set(__self__, "use_task_start_time_for_full_load_timestamp", use_task_start_time_for_full_load_timestamp)

    @property
    @pulumi.getter(name="addColumnName")
    def add_column_name(self) -> Optional[bool]:
        """
        Whether to add column name information to the .csv output file. Default is `false`.
        """
        return pulumi.get(self, "add_column_name")

    @property
    @pulumi.getter(name="bucketFolder")
    def bucket_folder(self) -> Optional[str]:
        """
        Custom S3 Bucket Object prefix for intermediate storage.
        """
        return pulumi.get(self, "bucket_folder")

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> Optional[str]:
        """
        Custom S3 Bucket name for intermediate storage.
        """
        return pulumi.get(self, "bucket_name")

    @property
    @pulumi.getter(name="cannedAclForObjects")
    def canned_acl_for_objects(self) -> Optional[str]:
        """
        Predefined (canned) access control list for objects created in an S3 bucket. Valid values include `none`, `private`, `public-read`, `public-read-write`, `authenticated-read`, `aws-exec-read`, `bucket-owner-read`, and `bucket-owner-full-control`. Default is `none`.
        """
        return pulumi.get(self, "canned_acl_for_objects")

    @property
    @pulumi.getter(name="cdcInsertsAndUpdates")
    def cdc_inserts_and_updates(self) -> Optional[bool]:
        """
        Whether to write insert and update operations to .csv or .parquet output files. Default is `false`.
        """
        return pulumi.get(self, "cdc_inserts_and_updates")

    @property
    @pulumi.getter(name="cdcInsertsOnly")
    def cdc_inserts_only(self) -> Optional[bool]:
        """
        Whether to write insert operations to .csv or .parquet output files. Default is `false`.
        """
        return pulumi.get(self, "cdc_inserts_only")

    @property
    @pulumi.getter(name="cdcMaxBatchInterval")
    def cdc_max_batch_interval(self) -> Optional[int]:
        """
        Maximum length of the interval, defined in seconds, after which to output a file to Amazon S3. Default is `60`.
        """
        return pulumi.get(self, "cdc_max_batch_interval")

    @property
    @pulumi.getter(name="cdcMinFileSize")
    def cdc_min_file_size(self) -> Optional[int]:
        """
        Minimum file size condition as defined in kilobytes to output a file to Amazon S3. Default is `32000`. **NOTE:** Previously, this setting was measured in megabytes but now represents kilobytes. Update configurations accordingly.
        """
        return pulumi.get(self, "cdc_min_file_size")

    @property
    @pulumi.getter(name="cdcPath")
    def cdc_path(self) -> Optional[str]:
        """
        Folder path of CDC files. For an S3 source, this setting is required if a task captures change data; otherwise, it's optional. If `cdc_path` is set, AWS DMS reads CDC files from this path and replicates the data changes to the target endpoint. Supported in AWS DMS versions 3.4.2 and later.
        """
        return pulumi.get(self, "cdc_path")

    @property
    @pulumi.getter(name="compressionType")
    def compression_type(self) -> Optional[str]:
        """
        Set to compress target files. Default is `NONE`. Valid values are `GZIP` and `NONE`.
        """
        return pulumi.get(self, "compression_type")

    @property
    @pulumi.getter(name="csvDelimiter")
    def csv_delimiter(self) -> Optional[str]:
        """
        Delimiter used to separate columns in the source files. Default is `,`.
        """
        return pulumi.get(self, "csv_delimiter")

    @property
    @pulumi.getter(name="csvNoSupValue")
    def csv_no_sup_value(self) -> Optional[str]:
        """
        String to use for all columns not included in the supplemental log.
        """
        return pulumi.get(self, "csv_no_sup_value")

    @property
    @pulumi.getter(name="csvNullValue")
    def csv_null_value(self) -> Optional[str]:
        """
        String to as null when writing to the target.
        """
        return pulumi.get(self, "csv_null_value")

    @property
    @pulumi.getter(name="csvRowDelimiter")
    def csv_row_delimiter(self) -> Optional[str]:
        """
        Delimiter used to separate rows in the source files. Default is `\\n`.
        """
        return pulumi.get(self, "csv_row_delimiter")

    @property
    @pulumi.getter(name="dataFormat")
    def data_format(self) -> Optional[str]:
        """
        Output format for the files that AWS DMS uses to create S3 objects. Valid values are `csv` and `parquet`. Default is `csv`.
        """
        return pulumi.get(self, "data_format")

    @property
    @pulumi.getter(name="dataPageSize")
    def data_page_size(self) -> Optional[int]:
        """
        Size of one data page in bytes. Default is `1048576` (1 MiB).
        """
        return pulumi.get(self, "data_page_size")

    @property
    @pulumi.getter(name="datePartitionDelimiter")
    def date_partition_delimiter(self) -> Optional[str]:
        """
        Date separating delimiter to use during folder partitioning. Valid values are `SLASH`, `UNDERSCORE`, `DASH`, and `NONE`. Default is `SLASH`.
        """
        return pulumi.get(self, "date_partition_delimiter")

    @property
    @pulumi.getter(name="datePartitionEnabled")
    def date_partition_enabled(self) -> Optional[bool]:
        """
        Partition S3 bucket folders based on transaction commit dates. Default is `false`.
        """
        return pulumi.get(self, "date_partition_enabled")

    @property
    @pulumi.getter(name="datePartitionSequence")
    def date_partition_sequence(self) -> Optional[str]:
        """
        Date format to use during folder partitioning. Use this parameter when `date_partition_enabled` is set to true. Valid values are `YYYYMMDD`, `YYYYMMDDHH`, `YYYYMM`, `MMYYYYDD`, and `DDMMYYYY`. Default is `YYYYMMDD`.
        """
        return pulumi.get(self, "date_partition_sequence")

    @property
    @pulumi.getter(name="dictPageSizeLimit")
    def dict_page_size_limit(self) -> Optional[int]:
        """
        Maximum size in bytes of an encoded dictionary page of a column. Default is `1048576` (1 MiB).
        """
        return pulumi.get(self, "dict_page_size_limit")

    @property
    @pulumi.getter(name="enableStatistics")
    def enable_statistics(self) -> Optional[bool]:
        """
        Whether to enable statistics for Parquet pages and row groups. Default is `true`.
        """
        return pulumi.get(self, "enable_statistics")

    @property
    @pulumi.getter(name="encodingType")
    def encoding_type(self) -> Optional[str]:
        """
        Type of encoding to use. Value values are `rle_dictionary`, `plain`, and `plain_dictionary`. Default is `rle_dictionary`.
        """
        return pulumi.get(self, "encoding_type")

    @property
    @pulumi.getter(name="encryptionMode")
    def encryption_mode(self) -> Optional[str]:
        """
        The server-side encryption mode that you want to encrypt your intermediate .csv object files copied to S3. Defaults to `SSE_S3`. Valid values are `SSE_S3` and `SSE_KMS`.
        """
        return pulumi.get(self, "encryption_mode")

    @property
    @pulumi.getter(name="externalTableDefinition")
    def external_table_definition(self) -> Optional[str]:
        """
        JSON document that describes how AWS DMS should interpret the data.
        """
        return pulumi.get(self, "external_table_definition")

    @property
    @pulumi.getter(name="ignoreHeaderRows")
    def ignore_header_rows(self) -> Optional[int]:
        """
        When this value is set to `1`, DMS ignores the first row header in a .csv file. Default is `0`.
        """
        return pulumi.get(self, "ignore_header_rows")

    @property
    @pulumi.getter(name="includeOpForFullLoad")
    def include_op_for_full_load(self) -> Optional[bool]:
        """
        Whether to enable a full load to write INSERT operations to the .csv output files only to indicate how the rows were added to the source database. Default is `false`.
        """
        return pulumi.get(self, "include_op_for_full_load")

    @property
    @pulumi.getter(name="maxFileSize")
    def max_file_size(self) -> Optional[int]:
        """
        Maximum size (in KB) of any .csv file to be created while migrating to an S3 target during full load. Valid values are from `1` to `1048576`. Default is `1048576` (1 GB).
        """
        return pulumi.get(self, "max_file_size")

    @property
    @pulumi.getter(name="parquetTimestampInMillisecond")
    def parquet_timestamp_in_millisecond(self) -> Optional[bool]:
        """
        Specifies the precision of any TIMESTAMP column values written to an S3 object file in .parquet format. Default is `false`.
        """
        return pulumi.get(self, "parquet_timestamp_in_millisecond")

    @property
    @pulumi.getter(name="parquetVersion")
    def parquet_version(self) -> Optional[str]:
        """
        Version of the .parquet file format. Default is `parquet-1-0`. Valid values are `parquet-1-0` and `parquet-2-0`.
        """
        return pulumi.get(self, "parquet_version")

    @property
    @pulumi.getter(name="preserveTransactions")
    def preserve_transactions(self) -> Optional[bool]:
        """
        Whether DMS saves the transaction order for a CDC load on the S3 target specified by `cdc_path`. Default is `false`.
        """
        return pulumi.get(self, "preserve_transactions")

    @property
    @pulumi.getter
    def rfc4180(self) -> Optional[bool]:
        """
        For an S3 source, whether each leading double quotation mark has to be followed by an ending double quotation mark. Default is `true`.
        """
        return pulumi.get(self, "rfc4180")

    @property
    @pulumi.getter(name="rowGroupLength")
    def row_group_length(self) -> Optional[int]:
        """
        Number of rows in a row group. Default is `10000`.
        """
        return pulumi.get(self, "row_group_length")

    @property
    @pulumi.getter(name="serverSideEncryptionKmsKeyId")
    def server_side_encryption_kms_key_id(self) -> Optional[str]:
        """
        ARN or Id of KMS Key to use when `encryption_mode` is `SSE_KMS`.
        """
        return pulumi.get(self, "server_side_encryption_kms_key_id")

    @property
    @pulumi.getter(name="serviceAccessRoleArn")
    def service_access_role_arn(self) -> Optional[str]:
        """
        ARN of the IAM Role with permissions to write to the OpenSearch cluster.
        """
        return pulumi.get(self, "service_access_role_arn")

    @property
    @pulumi.getter(name="timestampColumnName")
    def timestamp_column_name(self) -> Optional[str]:
        """
        Column to add with timestamp information to the endpoint data for an Amazon S3 target.
        """
        return pulumi.get(self, "timestamp_column_name")

    @property
    @pulumi.getter(name="useCsvNoSupValue")
    def use_csv_no_sup_value(self) -> Optional[bool]:
        """
        Whether to use `csv_no_sup_value` for columns not included in the supplemental log.
        """
        return pulumi.get(self, "use_csv_no_sup_value")

    @property
    @pulumi.getter(name="useTaskStartTimeForFullLoadTimestamp")
    def use_task_start_time_for_full_load_timestamp(self) -> Optional[bool]:
        """
        When set to true, uses the task start time as the timestamp column value instead of the time data is written to target. For full load, when set to true, each row of the timestamp column contains the task start time. For CDC loads, each row of the timestamp column contains the transaction commit time. When set to false, the full load timestamp in the timestamp column increments with the time data arrives at the target. Default is `false`.
        """
        return pulumi.get(self, "use_task_start_time_for_full_load_timestamp")


@pulumi.output_type
class GetEndpointElasticsearchSettingResult(dict):
    def __init__(__self__, *,
                 endpoint_uri: str,
                 error_retry_duration: int,
                 full_load_error_percentage: int,
                 service_access_role_arn: str):
        pulumi.set(__self__, "endpoint_uri", endpoint_uri)
        pulumi.set(__self__, "error_retry_duration", error_retry_duration)
        pulumi.set(__self__, "full_load_error_percentage", full_load_error_percentage)
        pulumi.set(__self__, "service_access_role_arn", service_access_role_arn)

    @property
    @pulumi.getter(name="endpointUri")
    def endpoint_uri(self) -> str:
        return pulumi.get(self, "endpoint_uri")

    @property
    @pulumi.getter(name="errorRetryDuration")
    def error_retry_duration(self) -> int:
        return pulumi.get(self, "error_retry_duration")

    @property
    @pulumi.getter(name="fullLoadErrorPercentage")
    def full_load_error_percentage(self) -> int:
        return pulumi.get(self, "full_load_error_percentage")

    @property
    @pulumi.getter(name="serviceAccessRoleArn")
    def service_access_role_arn(self) -> str:
        return pulumi.get(self, "service_access_role_arn")


@pulumi.output_type
class GetEndpointKafkaSettingResult(dict):
    def __init__(__self__, *,
                 broker: str,
                 include_control_details: bool,
                 include_null_and_empty: bool,
                 include_partition_value: bool,
                 include_table_alter_operations: bool,
                 include_transaction_details: bool,
                 message_format: str,
                 message_max_bytes: int,
                 no_hex_prefix: bool,
                 partition_include_schema_table: bool,
                 sasl_password: str,
                 sasl_username: str,
                 security_protocol: str,
                 ssl_ca_certificate_arn: str,
                 ssl_client_certificate_arn: str,
                 ssl_client_key_arn: str,
                 ssl_client_key_password: str,
                 topic: str):
        pulumi.set(__self__, "broker", broker)
        pulumi.set(__self__, "include_control_details", include_control_details)
        pulumi.set(__self__, "include_null_and_empty", include_null_and_empty)
        pulumi.set(__self__, "include_partition_value", include_partition_value)
        pulumi.set(__self__, "include_table_alter_operations", include_table_alter_operations)
        pulumi.set(__self__, "include_transaction_details", include_transaction_details)
        pulumi.set(__self__, "message_format", message_format)
        pulumi.set(__self__, "message_max_bytes", message_max_bytes)
        pulumi.set(__self__, "no_hex_prefix", no_hex_prefix)
        pulumi.set(__self__, "partition_include_schema_table", partition_include_schema_table)
        pulumi.set(__self__, "sasl_password", sasl_password)
        pulumi.set(__self__, "sasl_username", sasl_username)
        pulumi.set(__self__, "security_protocol", security_protocol)
        pulumi.set(__self__, "ssl_ca_certificate_arn", ssl_ca_certificate_arn)
        pulumi.set(__self__, "ssl_client_certificate_arn", ssl_client_certificate_arn)
        pulumi.set(__self__, "ssl_client_key_arn", ssl_client_key_arn)
        pulumi.set(__self__, "ssl_client_key_password", ssl_client_key_password)
        pulumi.set(__self__, "topic", topic)

    @property
    @pulumi.getter
    def broker(self) -> str:
        return pulumi.get(self, "broker")

    @property
    @pulumi.getter(name="includeControlDetails")
    def include_control_details(self) -> bool:
        return pulumi.get(self, "include_control_details")

    @property
    @pulumi.getter(name="includeNullAndEmpty")
    def include_null_and_empty(self) -> bool:
        return pulumi.get(self, "include_null_and_empty")

    @property
    @pulumi.getter(name="includePartitionValue")
    def include_partition_value(self) -> bool:
        return pulumi.get(self, "include_partition_value")

    @property
    @pulumi.getter(name="includeTableAlterOperations")
    def include_table_alter_operations(self) -> bool:
        return pulumi.get(self, "include_table_alter_operations")

    @property
    @pulumi.getter(name="includeTransactionDetails")
    def include_transaction_details(self) -> bool:
        return pulumi.get(self, "include_transaction_details")

    @property
    @pulumi.getter(name="messageFormat")
    def message_format(self) -> str:
        return pulumi.get(self, "message_format")

    @property
    @pulumi.getter(name="messageMaxBytes")
    def message_max_bytes(self) -> int:
        return pulumi.get(self, "message_max_bytes")

    @property
    @pulumi.getter(name="noHexPrefix")
    def no_hex_prefix(self) -> bool:
        return pulumi.get(self, "no_hex_prefix")

    @property
    @pulumi.getter(name="partitionIncludeSchemaTable")
    def partition_include_schema_table(self) -> bool:
        return pulumi.get(self, "partition_include_schema_table")

    @property
    @pulumi.getter(name="saslPassword")
    def sasl_password(self) -> str:
        return pulumi.get(self, "sasl_password")

    @property
    @pulumi.getter(name="saslUsername")
    def sasl_username(self) -> str:
        return pulumi.get(self, "sasl_username")

    @property
    @pulumi.getter(name="securityProtocol")
    def security_protocol(self) -> str:
        return pulumi.get(self, "security_protocol")

    @property
    @pulumi.getter(name="sslCaCertificateArn")
    def ssl_ca_certificate_arn(self) -> str:
        return pulumi.get(self, "ssl_ca_certificate_arn")

    @property
    @pulumi.getter(name="sslClientCertificateArn")
    def ssl_client_certificate_arn(self) -> str:
        return pulumi.get(self, "ssl_client_certificate_arn")

    @property
    @pulumi.getter(name="sslClientKeyArn")
    def ssl_client_key_arn(self) -> str:
        return pulumi.get(self, "ssl_client_key_arn")

    @property
    @pulumi.getter(name="sslClientKeyPassword")
    def ssl_client_key_password(self) -> str:
        return pulumi.get(self, "ssl_client_key_password")

    @property
    @pulumi.getter
    def topic(self) -> str:
        return pulumi.get(self, "topic")


@pulumi.output_type
class GetEndpointKinesisSettingResult(dict):
    def __init__(__self__, *,
                 include_control_details: bool,
                 include_null_and_empty: bool,
                 include_partition_value: bool,
                 include_table_alter_operations: bool,
                 include_transaction_details: bool,
                 message_format: str,
                 partition_include_schema_table: bool,
                 service_access_role_arn: str,
                 stream_arn: str):
        pulumi.set(__self__, "include_control_details", include_control_details)
        pulumi.set(__self__, "include_null_and_empty", include_null_and_empty)
        pulumi.set(__self__, "include_partition_value", include_partition_value)
        pulumi.set(__self__, "include_table_alter_operations", include_table_alter_operations)
        pulumi.set(__self__, "include_transaction_details", include_transaction_details)
        pulumi.set(__self__, "message_format", message_format)
        pulumi.set(__self__, "partition_include_schema_table", partition_include_schema_table)
        pulumi.set(__self__, "service_access_role_arn", service_access_role_arn)
        pulumi.set(__self__, "stream_arn", stream_arn)

    @property
    @pulumi.getter(name="includeControlDetails")
    def include_control_details(self) -> bool:
        return pulumi.get(self, "include_control_details")

    @property
    @pulumi.getter(name="includeNullAndEmpty")
    def include_null_and_empty(self) -> bool:
        return pulumi.get(self, "include_null_and_empty")

    @property
    @pulumi.getter(name="includePartitionValue")
    def include_partition_value(self) -> bool:
        return pulumi.get(self, "include_partition_value")

    @property
    @pulumi.getter(name="includeTableAlterOperations")
    def include_table_alter_operations(self) -> bool:
        return pulumi.get(self, "include_table_alter_operations")

    @property
    @pulumi.getter(name="includeTransactionDetails")
    def include_transaction_details(self) -> bool:
        return pulumi.get(self, "include_transaction_details")

    @property
    @pulumi.getter(name="messageFormat")
    def message_format(self) -> str:
        return pulumi.get(self, "message_format")

    @property
    @pulumi.getter(name="partitionIncludeSchemaTable")
    def partition_include_schema_table(self) -> bool:
        return pulumi.get(self, "partition_include_schema_table")

    @property
    @pulumi.getter(name="serviceAccessRoleArn")
    def service_access_role_arn(self) -> str:
        return pulumi.get(self, "service_access_role_arn")

    @property
    @pulumi.getter(name="streamArn")
    def stream_arn(self) -> str:
        return pulumi.get(self, "stream_arn")


@pulumi.output_type
class GetEndpointMongodbSettingResult(dict):
    def __init__(__self__, *,
                 auth_mechanism: str,
                 auth_source: str,
                 auth_type: str,
                 docs_to_investigate: str,
                 extract_doc_id: str,
                 nesting_level: str):
        pulumi.set(__self__, "auth_mechanism", auth_mechanism)
        pulumi.set(__self__, "auth_source", auth_source)
        pulumi.set(__self__, "auth_type", auth_type)
        pulumi.set(__self__, "docs_to_investigate", docs_to_investigate)
        pulumi.set(__self__, "extract_doc_id", extract_doc_id)
        pulumi.set(__self__, "nesting_level", nesting_level)

    @property
    @pulumi.getter(name="authMechanism")
    def auth_mechanism(self) -> str:
        return pulumi.get(self, "auth_mechanism")

    @property
    @pulumi.getter(name="authSource")
    def auth_source(self) -> str:
        return pulumi.get(self, "auth_source")

    @property
    @pulumi.getter(name="authType")
    def auth_type(self) -> str:
        return pulumi.get(self, "auth_type")

    @property
    @pulumi.getter(name="docsToInvestigate")
    def docs_to_investigate(self) -> str:
        return pulumi.get(self, "docs_to_investigate")

    @property
    @pulumi.getter(name="extractDocId")
    def extract_doc_id(self) -> str:
        return pulumi.get(self, "extract_doc_id")

    @property
    @pulumi.getter(name="nestingLevel")
    def nesting_level(self) -> str:
        return pulumi.get(self, "nesting_level")


@pulumi.output_type
class GetEndpointRedisSettingResult(dict):
    def __init__(__self__, *,
                 auth_password: str,
                 auth_type: str,
                 auth_user_name: str,
                 port: int,
                 server_name: str,
                 ssl_ca_certificate_arn: str,
                 ssl_security_protocol: str):
        pulumi.set(__self__, "auth_password", auth_password)
        pulumi.set(__self__, "auth_type", auth_type)
        pulumi.set(__self__, "auth_user_name", auth_user_name)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "server_name", server_name)
        pulumi.set(__self__, "ssl_ca_certificate_arn", ssl_ca_certificate_arn)
        pulumi.set(__self__, "ssl_security_protocol", ssl_security_protocol)

    @property
    @pulumi.getter(name="authPassword")
    def auth_password(self) -> str:
        return pulumi.get(self, "auth_password")

    @property
    @pulumi.getter(name="authType")
    def auth_type(self) -> str:
        return pulumi.get(self, "auth_type")

    @property
    @pulumi.getter(name="authUserName")
    def auth_user_name(self) -> str:
        return pulumi.get(self, "auth_user_name")

    @property
    @pulumi.getter
    def port(self) -> int:
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="serverName")
    def server_name(self) -> str:
        return pulumi.get(self, "server_name")

    @property
    @pulumi.getter(name="sslCaCertificateArn")
    def ssl_ca_certificate_arn(self) -> str:
        return pulumi.get(self, "ssl_ca_certificate_arn")

    @property
    @pulumi.getter(name="sslSecurityProtocol")
    def ssl_security_protocol(self) -> str:
        return pulumi.get(self, "ssl_security_protocol")


@pulumi.output_type
class GetEndpointRedshiftSettingResult(dict):
    def __init__(__self__, *,
                 bucket_folder: str,
                 bucket_name: str,
                 encryption_mode: str,
                 server_side_encryption_kms_key_id: str,
                 service_access_role_arn: str):
        pulumi.set(__self__, "bucket_folder", bucket_folder)
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "encryption_mode", encryption_mode)
        pulumi.set(__self__, "server_side_encryption_kms_key_id", server_side_encryption_kms_key_id)
        pulumi.set(__self__, "service_access_role_arn", service_access_role_arn)

    @property
    @pulumi.getter(name="bucketFolder")
    def bucket_folder(self) -> str:
        return pulumi.get(self, "bucket_folder")

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> str:
        return pulumi.get(self, "bucket_name")

    @property
    @pulumi.getter(name="encryptionMode")
    def encryption_mode(self) -> str:
        return pulumi.get(self, "encryption_mode")

    @property
    @pulumi.getter(name="serverSideEncryptionKmsKeyId")
    def server_side_encryption_kms_key_id(self) -> str:
        return pulumi.get(self, "server_side_encryption_kms_key_id")

    @property
    @pulumi.getter(name="serviceAccessRoleArn")
    def service_access_role_arn(self) -> str:
        return pulumi.get(self, "service_access_role_arn")


@pulumi.output_type
class GetEndpointS3SettingResult(dict):
    def __init__(__self__, *,
                 add_column_name: bool,
                 bucket_folder: str,
                 bucket_name: str,
                 canned_acl_for_objects: str,
                 cdc_inserts_and_updates: bool,
                 cdc_inserts_only: bool,
                 cdc_max_batch_interval: int,
                 cdc_min_file_size: int,
                 cdc_path: str,
                 compression_type: str,
                 csv_delimiter: str,
                 csv_no_sup_value: str,
                 csv_null_value: str,
                 csv_row_delimiter: str,
                 data_format: str,
                 data_page_size: int,
                 date_partition_delimiter: str,
                 date_partition_enabled: bool,
                 date_partition_sequence: str,
                 dict_page_size_limit: int,
                 enable_statistics: bool,
                 encoding_type: str,
                 encryption_mode: str,
                 external_table_definition: str,
                 ignore_header_rows: int,
                 ignore_headers_row: int,
                 include_op_for_full_load: bool,
                 max_file_size: int,
                 parquet_timestamp_in_millisecond: bool,
                 parquet_version: str,
                 preserve_transactions: bool,
                 rfc4180: bool,
                 row_group_length: int,
                 server_side_encryption_kms_key_id: str,
                 service_access_role_arn: str,
                 timestamp_column_name: str,
                 use_csv_no_sup_value: bool,
                 use_task_start_time_for_full_load_timestamp: bool):
        pulumi.set(__self__, "add_column_name", add_column_name)
        pulumi.set(__self__, "bucket_folder", bucket_folder)
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "canned_acl_for_objects", canned_acl_for_objects)
        pulumi.set(__self__, "cdc_inserts_and_updates", cdc_inserts_and_updates)
        pulumi.set(__self__, "cdc_inserts_only", cdc_inserts_only)
        pulumi.set(__self__, "cdc_max_batch_interval", cdc_max_batch_interval)
        pulumi.set(__self__, "cdc_min_file_size", cdc_min_file_size)
        pulumi.set(__self__, "cdc_path", cdc_path)
        pulumi.set(__self__, "compression_type", compression_type)
        pulumi.set(__self__, "csv_delimiter", csv_delimiter)
        pulumi.set(__self__, "csv_no_sup_value", csv_no_sup_value)
        pulumi.set(__self__, "csv_null_value", csv_null_value)
        pulumi.set(__self__, "csv_row_delimiter", csv_row_delimiter)
        pulumi.set(__self__, "data_format", data_format)
        pulumi.set(__self__, "data_page_size", data_page_size)
        pulumi.set(__self__, "date_partition_delimiter", date_partition_delimiter)
        pulumi.set(__self__, "date_partition_enabled", date_partition_enabled)
        pulumi.set(__self__, "date_partition_sequence", date_partition_sequence)
        pulumi.set(__self__, "dict_page_size_limit", dict_page_size_limit)
        pulumi.set(__self__, "enable_statistics", enable_statistics)
        pulumi.set(__self__, "encoding_type", encoding_type)
        pulumi.set(__self__, "encryption_mode", encryption_mode)
        pulumi.set(__self__, "external_table_definition", external_table_definition)
        pulumi.set(__self__, "ignore_header_rows", ignore_header_rows)
        pulumi.set(__self__, "ignore_headers_row", ignore_headers_row)
        pulumi.set(__self__, "include_op_for_full_load", include_op_for_full_load)
        pulumi.set(__self__, "max_file_size", max_file_size)
        pulumi.set(__self__, "parquet_timestamp_in_millisecond", parquet_timestamp_in_millisecond)
        pulumi.set(__self__, "parquet_version", parquet_version)
        pulumi.set(__self__, "preserve_transactions", preserve_transactions)
        pulumi.set(__self__, "rfc4180", rfc4180)
        pulumi.set(__self__, "row_group_length", row_group_length)
        pulumi.set(__self__, "server_side_encryption_kms_key_id", server_side_encryption_kms_key_id)
        pulumi.set(__self__, "service_access_role_arn", service_access_role_arn)
        pulumi.set(__self__, "timestamp_column_name", timestamp_column_name)
        pulumi.set(__self__, "use_csv_no_sup_value", use_csv_no_sup_value)
        pulumi.set(__self__, "use_task_start_time_for_full_load_timestamp", use_task_start_time_for_full_load_timestamp)

    @property
    @pulumi.getter(name="addColumnName")
    def add_column_name(self) -> bool:
        return pulumi.get(self, "add_column_name")

    @property
    @pulumi.getter(name="bucketFolder")
    def bucket_folder(self) -> str:
        return pulumi.get(self, "bucket_folder")

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> str:
        return pulumi.get(self, "bucket_name")

    @property
    @pulumi.getter(name="cannedAclForObjects")
    def canned_acl_for_objects(self) -> str:
        return pulumi.get(self, "canned_acl_for_objects")

    @property
    @pulumi.getter(name="cdcInsertsAndUpdates")
    def cdc_inserts_and_updates(self) -> bool:
        return pulumi.get(self, "cdc_inserts_and_updates")

    @property
    @pulumi.getter(name="cdcInsertsOnly")
    def cdc_inserts_only(self) -> bool:
        return pulumi.get(self, "cdc_inserts_only")

    @property
    @pulumi.getter(name="cdcMaxBatchInterval")
    def cdc_max_batch_interval(self) -> int:
        return pulumi.get(self, "cdc_max_batch_interval")

    @property
    @pulumi.getter(name="cdcMinFileSize")
    def cdc_min_file_size(self) -> int:
        return pulumi.get(self, "cdc_min_file_size")

    @property
    @pulumi.getter(name="cdcPath")
    def cdc_path(self) -> str:
        return pulumi.get(self, "cdc_path")

    @property
    @pulumi.getter(name="compressionType")
    def compression_type(self) -> str:
        return pulumi.get(self, "compression_type")

    @property
    @pulumi.getter(name="csvDelimiter")
    def csv_delimiter(self) -> str:
        return pulumi.get(self, "csv_delimiter")

    @property
    @pulumi.getter(name="csvNoSupValue")
    def csv_no_sup_value(self) -> str:
        return pulumi.get(self, "csv_no_sup_value")

    @property
    @pulumi.getter(name="csvNullValue")
    def csv_null_value(self) -> str:
        return pulumi.get(self, "csv_null_value")

    @property
    @pulumi.getter(name="csvRowDelimiter")
    def csv_row_delimiter(self) -> str:
        return pulumi.get(self, "csv_row_delimiter")

    @property
    @pulumi.getter(name="dataFormat")
    def data_format(self) -> str:
        return pulumi.get(self, "data_format")

    @property
    @pulumi.getter(name="dataPageSize")
    def data_page_size(self) -> int:
        return pulumi.get(self, "data_page_size")

    @property
    @pulumi.getter(name="datePartitionDelimiter")
    def date_partition_delimiter(self) -> str:
        return pulumi.get(self, "date_partition_delimiter")

    @property
    @pulumi.getter(name="datePartitionEnabled")
    def date_partition_enabled(self) -> bool:
        return pulumi.get(self, "date_partition_enabled")

    @property
    @pulumi.getter(name="datePartitionSequence")
    def date_partition_sequence(self) -> str:
        return pulumi.get(self, "date_partition_sequence")

    @property
    @pulumi.getter(name="dictPageSizeLimit")
    def dict_page_size_limit(self) -> int:
        return pulumi.get(self, "dict_page_size_limit")

    @property
    @pulumi.getter(name="enableStatistics")
    def enable_statistics(self) -> bool:
        return pulumi.get(self, "enable_statistics")

    @property
    @pulumi.getter(name="encodingType")
    def encoding_type(self) -> str:
        return pulumi.get(self, "encoding_type")

    @property
    @pulumi.getter(name="encryptionMode")
    def encryption_mode(self) -> str:
        return pulumi.get(self, "encryption_mode")

    @property
    @pulumi.getter(name="externalTableDefinition")
    def external_table_definition(self) -> str:
        return pulumi.get(self, "external_table_definition")

    @property
    @pulumi.getter(name="ignoreHeaderRows")
    def ignore_header_rows(self) -> int:
        return pulumi.get(self, "ignore_header_rows")

    @property
    @pulumi.getter(name="ignoreHeadersRow")
    def ignore_headers_row(self) -> int:
        return pulumi.get(self, "ignore_headers_row")

    @property
    @pulumi.getter(name="includeOpForFullLoad")
    def include_op_for_full_load(self) -> bool:
        return pulumi.get(self, "include_op_for_full_load")

    @property
    @pulumi.getter(name="maxFileSize")
    def max_file_size(self) -> int:
        return pulumi.get(self, "max_file_size")

    @property
    @pulumi.getter(name="parquetTimestampInMillisecond")
    def parquet_timestamp_in_millisecond(self) -> bool:
        return pulumi.get(self, "parquet_timestamp_in_millisecond")

    @property
    @pulumi.getter(name="parquetVersion")
    def parquet_version(self) -> str:
        return pulumi.get(self, "parquet_version")

    @property
    @pulumi.getter(name="preserveTransactions")
    def preserve_transactions(self) -> bool:
        return pulumi.get(self, "preserve_transactions")

    @property
    @pulumi.getter
    def rfc4180(self) -> bool:
        return pulumi.get(self, "rfc4180")

    @property
    @pulumi.getter(name="rowGroupLength")
    def row_group_length(self) -> int:
        return pulumi.get(self, "row_group_length")

    @property
    @pulumi.getter(name="serverSideEncryptionKmsKeyId")
    def server_side_encryption_kms_key_id(self) -> str:
        return pulumi.get(self, "server_side_encryption_kms_key_id")

    @property
    @pulumi.getter(name="serviceAccessRoleArn")
    def service_access_role_arn(self) -> str:
        return pulumi.get(self, "service_access_role_arn")

    @property
    @pulumi.getter(name="timestampColumnName")
    def timestamp_column_name(self) -> str:
        return pulumi.get(self, "timestamp_column_name")

    @property
    @pulumi.getter(name="useCsvNoSupValue")
    def use_csv_no_sup_value(self) -> bool:
        return pulumi.get(self, "use_csv_no_sup_value")

    @property
    @pulumi.getter(name="useTaskStartTimeForFullLoadTimestamp")
    def use_task_start_time_for_full_load_timestamp(self) -> bool:
        return pulumi.get(self, "use_task_start_time_for_full_load_timestamp")


