# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['S3EndpointArgs', 'S3Endpoint']

@pulumi.input_type
class S3EndpointArgs:
    def __init__(__self__, *,
                 bucket_name: pulumi.Input[str],
                 endpoint_id: pulumi.Input[str],
                 endpoint_type: pulumi.Input[str],
                 service_access_role_arn: pulumi.Input[str],
                 add_column_name: Optional[pulumi.Input[bool]] = None,
                 add_trailing_padding_character: Optional[pulumi.Input[bool]] = None,
                 bucket_folder: Optional[pulumi.Input[str]] = None,
                 canned_acl_for_objects: Optional[pulumi.Input[str]] = None,
                 cdc_inserts_and_updates: Optional[pulumi.Input[bool]] = None,
                 cdc_inserts_only: Optional[pulumi.Input[bool]] = None,
                 cdc_max_batch_interval: Optional[pulumi.Input[int]] = None,
                 cdc_min_file_size: Optional[pulumi.Input[int]] = None,
                 cdc_path: Optional[pulumi.Input[str]] = None,
                 certificate_arn: Optional[pulumi.Input[str]] = None,
                 compression_type: Optional[pulumi.Input[str]] = None,
                 csv_delimiter: Optional[pulumi.Input[str]] = None,
                 csv_no_sup_value: Optional[pulumi.Input[str]] = None,
                 csv_null_value: Optional[pulumi.Input[str]] = None,
                 csv_row_delimiter: Optional[pulumi.Input[str]] = None,
                 data_format: Optional[pulumi.Input[str]] = None,
                 data_page_size: Optional[pulumi.Input[int]] = None,
                 date_partition_delimiter: Optional[pulumi.Input[str]] = None,
                 date_partition_enabled: Optional[pulumi.Input[bool]] = None,
                 date_partition_sequence: Optional[pulumi.Input[str]] = None,
                 date_partition_timezone: Optional[pulumi.Input[str]] = None,
                 detach_target_on_lob_lookup_failure_parquet: Optional[pulumi.Input[bool]] = None,
                 dict_page_size_limit: Optional[pulumi.Input[int]] = None,
                 enable_statistics: Optional[pulumi.Input[bool]] = None,
                 encoding_type: Optional[pulumi.Input[str]] = None,
                 encryption_mode: Optional[pulumi.Input[str]] = None,
                 expected_bucket_owner: Optional[pulumi.Input[str]] = None,
                 external_table_definition: Optional[pulumi.Input[str]] = None,
                 ignore_header_rows: Optional[pulumi.Input[int]] = None,
                 include_op_for_full_load: Optional[pulumi.Input[bool]] = None,
                 kms_key_arn: Optional[pulumi.Input[str]] = None,
                 max_file_size: Optional[pulumi.Input[int]] = None,
                 parquet_timestamp_in_millisecond: Optional[pulumi.Input[bool]] = None,
                 parquet_version: Optional[pulumi.Input[str]] = None,
                 preserve_transactions: Optional[pulumi.Input[bool]] = None,
                 rfc4180: Optional[pulumi.Input[bool]] = None,
                 row_group_length: Optional[pulumi.Input[int]] = None,
                 server_side_encryption_kms_key_id: Optional[pulumi.Input[str]] = None,
                 ssl_mode: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 timestamp_column_name: Optional[pulumi.Input[str]] = None,
                 use_csv_no_sup_value: Optional[pulumi.Input[bool]] = None,
                 use_task_start_time_for_full_load_timestamp: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a S3Endpoint resource.
        :param pulumi.Input[str] bucket_name: S3 bucket name.
        :param pulumi.Input[str] endpoint_id: Database endpoint identifier. Identifiers must contain from 1 to 255 alphanumeric characters or hyphens, begin with a letter, contain only ASCII letters, digits, and hyphens, not end with a hyphen, and not contain two consecutive hyphens.
        :param pulumi.Input[str] endpoint_type: Type of endpoint. Valid values are `source`, `target`.
        :param pulumi.Input[str] service_access_role_arn: ARN of the IAM role with permissions to the S3 Bucket.
               
               The following arguments are optional:
        :param pulumi.Input[bool] add_column_name: Whether to add column name information to the .csv output file. Default is `false`.
        :param pulumi.Input[bool] add_trailing_padding_character: Whether to add padding. Default is `false`. (Ignored for source endpoints.)
        :param pulumi.Input[str] bucket_folder: S3 object prefix.
        :param pulumi.Input[str] canned_acl_for_objects: Predefined (canned) access control list for objects created in an S3 bucket. Valid values include `none`, `private`, `public-read`, `public-read-write`, `authenticated-read`, `aws-exec-read`, `bucket-owner-read`, and `bucket-owner-full-control`. Default is `none`.
        :param pulumi.Input[bool] cdc_inserts_and_updates: Whether to write insert and update operations to .csv or .parquet output files. Default is `false`.
        :param pulumi.Input[bool] cdc_inserts_only: Whether to write insert operations to .csv or .parquet output files. Default is `false`.
        :param pulumi.Input[int] cdc_max_batch_interval: Maximum length of the interval, defined in seconds, after which to output a file to Amazon S3. (AWS default is `60`.)
        :param pulumi.Input[int] cdc_min_file_size: Minimum file size condition as defined in kilobytes to output a file to Amazon S3. (AWS default is 32000 KB.)
        :param pulumi.Input[str] cdc_path: Folder path of CDC files. If `cdc_path` is set, AWS DMS reads CDC files from this path and replicates the data changes to the target endpoint. Supported in AWS DMS versions 3.4.2 and later.
        :param pulumi.Input[str] certificate_arn: ARN for the certificate.
        :param pulumi.Input[str] compression_type: Set to compress target files. Valid values are `GZIP` and `NONE`. Default is `NONE`. (Ignored for source endpoints.)
        :param pulumi.Input[str] csv_delimiter: Delimiter used to separate columns in the source files. Default is `,`.
        :param pulumi.Input[str] csv_no_sup_value: Only applies if output files for a CDC load are written in .csv format. If `use_csv_no_sup_value` is set to `true`, string to use for all columns not included in the supplemental log. If you do not specify a string value, DMS uses the null value for these columns regardless of `use_csv_no_sup_value`. (Ignored for source endpoints.)
        :param pulumi.Input[str] csv_null_value: String to as null when writing to the target. (AWS default is `NULL`.)
        :param pulumi.Input[str] csv_row_delimiter: Delimiter used to separate rows in the source files. Default is newline (_i.e._, `\\n`).
        :param pulumi.Input[str] data_format: Output format for the files that AWS DMS uses to create S3 objects. Valid values are `csv` and `parquet`.  (Ignored for source endpoints -- only `csv` is valid.)
        :param pulumi.Input[int] data_page_size: Size of one data page in bytes. (AWS default is 1 MiB, _i.e._, `1048576`.)
        :param pulumi.Input[str] date_partition_delimiter: Date separating delimiter to use during folder partitioning. Valid values are `SLASH`, `UNDERSCORE`, `DASH`, and `NONE`. (AWS default is `SLASH`.) (Ignored for source endpoints.)
        :param pulumi.Input[bool] date_partition_enabled: Partition S3 bucket folders based on transaction commit dates. Default is `false`. (Ignored for source endpoints.)
        :param pulumi.Input[str] date_partition_sequence: Date format to use during folder partitioning. Use this parameter when `date_partition_enabled` is set to true. Valid values are `YYYYMMDD`, `YYYYMMDDHH`, `YYYYMM`, `MMYYYYDD`, and `DDMMYYYY`. (AWS default is `YYYYMMDD`.) (Ignored for source endpoints.)
        :param pulumi.Input[str] date_partition_timezone: Convert the current UTC time to a timezone. The conversion occurs when a date partition folder is created and a CDC filename is generated. The timezone format is Area/Location (_e.g._, `Europe/Paris`). Use this when `date_partition_enabled` is `true`. (Ignored for source endpoints.)
        :param pulumi.Input[bool] detach_target_on_lob_lookup_failure_parquet: Undocumented argument for use as directed by AWS Support.
        :param pulumi.Input[int] dict_page_size_limit: Maximum size in bytes of an encoded dictionary page of a column. (AWS default is 1 MiB, _i.e._, `1048576`.)
        :param pulumi.Input[bool] enable_statistics: Whether to enable statistics for Parquet pages and row groups. Default is `true`.
        :param pulumi.Input[str] encoding_type: Type of encoding to use. Value values are `rle_dictionary`, `plain`, and `plain_dictionary`. (AWS default is `rle_dictionary`.)
        :param pulumi.Input[str] encryption_mode: Server-side encryption mode that you want to encrypt your .csv or .parquet object files copied to S3. Valid values are `SSE_S3` and `SSE_KMS`. (AWS default is `SSE_S3`.) (Ignored for source endpoints -- only `SSE_S3` is valid.)
        :param pulumi.Input[str] expected_bucket_owner: Bucket owner to prevent sniping. Value is an AWS account ID.
        :param pulumi.Input[str] external_table_definition: JSON document that describes how AWS DMS should interpret the data.
        :param pulumi.Input[int] ignore_header_rows: When this value is set to `1`, DMS ignores the first row header in a .csv file. (AWS default is `0`.)
        :param pulumi.Input[bool] include_op_for_full_load: Whether to enable a full load to write INSERT operations to the .csv output files only to indicate how the rows were added to the source database. Default is `false`.
        :param pulumi.Input[str] kms_key_arn: ARN for the KMS key that will be used to encrypt the connection parameters. If you do not specify a value for `kms_key_arn`, then AWS DMS will use your default encryption key. AWS KMS creates the default encryption key for your AWS account. Your AWS account has a different default encryption key for each AWS region.
        :param pulumi.Input[int] max_file_size: Maximum size (in KB) of any .csv file to be created while migrating to an S3 target during full load. Valid values are from `1` to `1048576`. (AWS default is 1 GB, _i.e._, `1048576`.)
        :param pulumi.Input[bool] parquet_timestamp_in_millisecond: Specifies the precision of any TIMESTAMP column values written to an S3 object file in .parquet format. Default is `false`. (Ignored for source endpoints.)
        :param pulumi.Input[str] parquet_version: Version of the .parquet file format. Valid values are `parquet-1-0` and `parquet-2-0`. (AWS default is `parquet-1-0`.) (Ignored for source endpoints.)
        :param pulumi.Input[bool] preserve_transactions: Whether DMS saves the transaction order for a CDC load on the S3 target specified by `cdc_path`. Default is `false`. (Ignored for source endpoints.)
        :param pulumi.Input[bool] rfc4180: For an S3 source, whether each leading double quotation mark has to be followed by an ending double quotation mark. Default is `true`.
        :param pulumi.Input[int] row_group_length: Number of rows in a row group. (AWS default is `10000`.)
        :param pulumi.Input[str] server_side_encryption_kms_key_id: When `encryption_mode` is `SSE_KMS`, ARN for the AWS KMS key. (Ignored for source endpoints -- only `SSE_S3` `encryption_mode` is valid.)
        :param pulumi.Input[str] ssl_mode: SSL mode to use for the connection. Valid values are `none`, `require`, `verify-ca`, `verify-full`. (AWS default is `none`.)
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[str] timestamp_column_name: Column to add with timestamp information to the endpoint data for an Amazon S3 target.
        :param pulumi.Input[bool] use_csv_no_sup_value: Whether to use `csv_no_sup_value` for columns not included in the supplemental log. (Ignored for source endpoints.)
        :param pulumi.Input[bool] use_task_start_time_for_full_load_timestamp: When set to `true`, uses the task start time as the timestamp column value instead of the time data is written to target. For full load, when set to `true`, each row of the timestamp column contains the task start time. For CDC loads, each row of the timestamp column contains the transaction commit time.When set to false, the full load timestamp in the timestamp column increments with the time data arrives at the target. Default is `false`.
        """
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "endpoint_id", endpoint_id)
        pulumi.set(__self__, "endpoint_type", endpoint_type)
        pulumi.set(__self__, "service_access_role_arn", service_access_role_arn)
        if add_column_name is not None:
            pulumi.set(__self__, "add_column_name", add_column_name)
        if add_trailing_padding_character is not None:
            pulumi.set(__self__, "add_trailing_padding_character", add_trailing_padding_character)
        if bucket_folder is not None:
            pulumi.set(__self__, "bucket_folder", bucket_folder)
        if canned_acl_for_objects is not None:
            pulumi.set(__self__, "canned_acl_for_objects", canned_acl_for_objects)
        if cdc_inserts_and_updates is not None:
            pulumi.set(__self__, "cdc_inserts_and_updates", cdc_inserts_and_updates)
        if cdc_inserts_only is not None:
            pulumi.set(__self__, "cdc_inserts_only", cdc_inserts_only)
        if cdc_max_batch_interval is not None:
            pulumi.set(__self__, "cdc_max_batch_interval", cdc_max_batch_interval)
        if cdc_min_file_size is not None:
            pulumi.set(__self__, "cdc_min_file_size", cdc_min_file_size)
        if cdc_path is not None:
            pulumi.set(__self__, "cdc_path", cdc_path)
        if certificate_arn is not None:
            pulumi.set(__self__, "certificate_arn", certificate_arn)
        if compression_type is not None:
            pulumi.set(__self__, "compression_type", compression_type)
        if csv_delimiter is not None:
            pulumi.set(__self__, "csv_delimiter", csv_delimiter)
        if csv_no_sup_value is not None:
            pulumi.set(__self__, "csv_no_sup_value", csv_no_sup_value)
        if csv_null_value is not None:
            pulumi.set(__self__, "csv_null_value", csv_null_value)
        if csv_row_delimiter is not None:
            pulumi.set(__self__, "csv_row_delimiter", csv_row_delimiter)
        if data_format is not None:
            pulumi.set(__self__, "data_format", data_format)
        if data_page_size is not None:
            pulumi.set(__self__, "data_page_size", data_page_size)
        if date_partition_delimiter is not None:
            pulumi.set(__self__, "date_partition_delimiter", date_partition_delimiter)
        if date_partition_enabled is not None:
            pulumi.set(__self__, "date_partition_enabled", date_partition_enabled)
        if date_partition_sequence is not None:
            pulumi.set(__self__, "date_partition_sequence", date_partition_sequence)
        if date_partition_timezone is not None:
            pulumi.set(__self__, "date_partition_timezone", date_partition_timezone)
        if detach_target_on_lob_lookup_failure_parquet is not None:
            pulumi.set(__self__, "detach_target_on_lob_lookup_failure_parquet", detach_target_on_lob_lookup_failure_parquet)
        if dict_page_size_limit is not None:
            pulumi.set(__self__, "dict_page_size_limit", dict_page_size_limit)
        if enable_statistics is not None:
            pulumi.set(__self__, "enable_statistics", enable_statistics)
        if encoding_type is not None:
            pulumi.set(__self__, "encoding_type", encoding_type)
        if encryption_mode is not None:
            pulumi.set(__self__, "encryption_mode", encryption_mode)
        if expected_bucket_owner is not None:
            pulumi.set(__self__, "expected_bucket_owner", expected_bucket_owner)
        if external_table_definition is not None:
            pulumi.set(__self__, "external_table_definition", external_table_definition)
        if ignore_header_rows is not None:
            pulumi.set(__self__, "ignore_header_rows", ignore_header_rows)
        if include_op_for_full_load is not None:
            pulumi.set(__self__, "include_op_for_full_load", include_op_for_full_load)
        if kms_key_arn is not None:
            pulumi.set(__self__, "kms_key_arn", kms_key_arn)
        if max_file_size is not None:
            pulumi.set(__self__, "max_file_size", max_file_size)
        if parquet_timestamp_in_millisecond is not None:
            pulumi.set(__self__, "parquet_timestamp_in_millisecond", parquet_timestamp_in_millisecond)
        if parquet_version is not None:
            pulumi.set(__self__, "parquet_version", parquet_version)
        if preserve_transactions is not None:
            pulumi.set(__self__, "preserve_transactions", preserve_transactions)
        if rfc4180 is not None:
            pulumi.set(__self__, "rfc4180", rfc4180)
        if row_group_length is not None:
            pulumi.set(__self__, "row_group_length", row_group_length)
        if server_side_encryption_kms_key_id is not None:
            pulumi.set(__self__, "server_side_encryption_kms_key_id", server_side_encryption_kms_key_id)
        if ssl_mode is not None:
            pulumi.set(__self__, "ssl_mode", ssl_mode)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timestamp_column_name is not None:
            pulumi.set(__self__, "timestamp_column_name", timestamp_column_name)
        if use_csv_no_sup_value is not None:
            pulumi.set(__self__, "use_csv_no_sup_value", use_csv_no_sup_value)
        if use_task_start_time_for_full_load_timestamp is not None:
            pulumi.set(__self__, "use_task_start_time_for_full_load_timestamp", use_task_start_time_for_full_load_timestamp)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> pulumi.Input[str]:
        """
        S3 bucket name.
        """
        return pulumi.get(self, "bucket_name")

    @bucket_name.setter
    def bucket_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "bucket_name", value)

    @property
    @pulumi.getter(name="endpointId")
    def endpoint_id(self) -> pulumi.Input[str]:
        """
        Database endpoint identifier. Identifiers must contain from 1 to 255 alphanumeric characters or hyphens, begin with a letter, contain only ASCII letters, digits, and hyphens, not end with a hyphen, and not contain two consecutive hyphens.
        """
        return pulumi.get(self, "endpoint_id")

    @endpoint_id.setter
    def endpoint_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "endpoint_id", value)

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> pulumi.Input[str]:
        """
        Type of endpoint. Valid values are `source`, `target`.
        """
        return pulumi.get(self, "endpoint_type")

    @endpoint_type.setter
    def endpoint_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "endpoint_type", value)

    @property
    @pulumi.getter(name="serviceAccessRoleArn")
    def service_access_role_arn(self) -> pulumi.Input[str]:
        """
        ARN of the IAM role with permissions to the S3 Bucket.

        The following arguments are optional:
        """
        return pulumi.get(self, "service_access_role_arn")

    @service_access_role_arn.setter
    def service_access_role_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "service_access_role_arn", value)

    @property
    @pulumi.getter(name="addColumnName")
    def add_column_name(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to add column name information to the .csv output file. Default is `false`.
        """
        return pulumi.get(self, "add_column_name")

    @add_column_name.setter
    def add_column_name(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "add_column_name", value)

    @property
    @pulumi.getter(name="addTrailingPaddingCharacter")
    def add_trailing_padding_character(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to add padding. Default is `false`. (Ignored for source endpoints.)
        """
        return pulumi.get(self, "add_trailing_padding_character")

    @add_trailing_padding_character.setter
    def add_trailing_padding_character(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "add_trailing_padding_character", value)

    @property
    @pulumi.getter(name="bucketFolder")
    def bucket_folder(self) -> Optional[pulumi.Input[str]]:
        """
        S3 object prefix.
        """
        return pulumi.get(self, "bucket_folder")

    @bucket_folder.setter
    def bucket_folder(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bucket_folder", value)

    @property
    @pulumi.getter(name="cannedAclForObjects")
    def canned_acl_for_objects(self) -> Optional[pulumi.Input[str]]:
        """
        Predefined (canned) access control list for objects created in an S3 bucket. Valid values include `none`, `private`, `public-read`, `public-read-write`, `authenticated-read`, `aws-exec-read`, `bucket-owner-read`, and `bucket-owner-full-control`. Default is `none`.
        """
        return pulumi.get(self, "canned_acl_for_objects")

    @canned_acl_for_objects.setter
    def canned_acl_for_objects(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "canned_acl_for_objects", value)

    @property
    @pulumi.getter(name="cdcInsertsAndUpdates")
    def cdc_inserts_and_updates(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to write insert and update operations to .csv or .parquet output files. Default is `false`.
        """
        return pulumi.get(self, "cdc_inserts_and_updates")

    @cdc_inserts_and_updates.setter
    def cdc_inserts_and_updates(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "cdc_inserts_and_updates", value)

    @property
    @pulumi.getter(name="cdcInsertsOnly")
    def cdc_inserts_only(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to write insert operations to .csv or .parquet output files. Default is `false`.
        """
        return pulumi.get(self, "cdc_inserts_only")

    @cdc_inserts_only.setter
    def cdc_inserts_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "cdc_inserts_only", value)

    @property
    @pulumi.getter(name="cdcMaxBatchInterval")
    def cdc_max_batch_interval(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum length of the interval, defined in seconds, after which to output a file to Amazon S3. (AWS default is `60`.)
        """
        return pulumi.get(self, "cdc_max_batch_interval")

    @cdc_max_batch_interval.setter
    def cdc_max_batch_interval(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cdc_max_batch_interval", value)

    @property
    @pulumi.getter(name="cdcMinFileSize")
    def cdc_min_file_size(self) -> Optional[pulumi.Input[int]]:
        """
        Minimum file size condition as defined in kilobytes to output a file to Amazon S3. (AWS default is 32000 KB.)
        """
        return pulumi.get(self, "cdc_min_file_size")

    @cdc_min_file_size.setter
    def cdc_min_file_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cdc_min_file_size", value)

    @property
    @pulumi.getter(name="cdcPath")
    def cdc_path(self) -> Optional[pulumi.Input[str]]:
        """
        Folder path of CDC files. If `cdc_path` is set, AWS DMS reads CDC files from this path and replicates the data changes to the target endpoint. Supported in AWS DMS versions 3.4.2 and later.
        """
        return pulumi.get(self, "cdc_path")

    @cdc_path.setter
    def cdc_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cdc_path", value)

    @property
    @pulumi.getter(name="certificateArn")
    def certificate_arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN for the certificate.
        """
        return pulumi.get(self, "certificate_arn")

    @certificate_arn.setter
    def certificate_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_arn", value)

    @property
    @pulumi.getter(name="compressionType")
    def compression_type(self) -> Optional[pulumi.Input[str]]:
        """
        Set to compress target files. Valid values are `GZIP` and `NONE`. Default is `NONE`. (Ignored for source endpoints.)
        """
        return pulumi.get(self, "compression_type")

    @compression_type.setter
    def compression_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compression_type", value)

    @property
    @pulumi.getter(name="csvDelimiter")
    def csv_delimiter(self) -> Optional[pulumi.Input[str]]:
        """
        Delimiter used to separate columns in the source files. Default is `,`.
        """
        return pulumi.get(self, "csv_delimiter")

    @csv_delimiter.setter
    def csv_delimiter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "csv_delimiter", value)

    @property
    @pulumi.getter(name="csvNoSupValue")
    def csv_no_sup_value(self) -> Optional[pulumi.Input[str]]:
        """
        Only applies if output files for a CDC load are written in .csv format. If `use_csv_no_sup_value` is set to `true`, string to use for all columns not included in the supplemental log. If you do not specify a string value, DMS uses the null value for these columns regardless of `use_csv_no_sup_value`. (Ignored for source endpoints.)
        """
        return pulumi.get(self, "csv_no_sup_value")

    @csv_no_sup_value.setter
    def csv_no_sup_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "csv_no_sup_value", value)

    @property
    @pulumi.getter(name="csvNullValue")
    def csv_null_value(self) -> Optional[pulumi.Input[str]]:
        """
        String to as null when writing to the target. (AWS default is `NULL`.)
        """
        return pulumi.get(self, "csv_null_value")

    @csv_null_value.setter
    def csv_null_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "csv_null_value", value)

    @property
    @pulumi.getter(name="csvRowDelimiter")
    def csv_row_delimiter(self) -> Optional[pulumi.Input[str]]:
        """
        Delimiter used to separate rows in the source files. Default is newline (_i.e._, `\\n`).
        """
        return pulumi.get(self, "csv_row_delimiter")

    @csv_row_delimiter.setter
    def csv_row_delimiter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "csv_row_delimiter", value)

    @property
    @pulumi.getter(name="dataFormat")
    def data_format(self) -> Optional[pulumi.Input[str]]:
        """
        Output format for the files that AWS DMS uses to create S3 objects. Valid values are `csv` and `parquet`.  (Ignored for source endpoints -- only `csv` is valid.)
        """
        return pulumi.get(self, "data_format")

    @data_format.setter
    def data_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_format", value)

    @property
    @pulumi.getter(name="dataPageSize")
    def data_page_size(self) -> Optional[pulumi.Input[int]]:
        """
        Size of one data page in bytes. (AWS default is 1 MiB, _i.e._, `1048576`.)
        """
        return pulumi.get(self, "data_page_size")

    @data_page_size.setter
    def data_page_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "data_page_size", value)

    @property
    @pulumi.getter(name="datePartitionDelimiter")
    def date_partition_delimiter(self) -> Optional[pulumi.Input[str]]:
        """
        Date separating delimiter to use during folder partitioning. Valid values are `SLASH`, `UNDERSCORE`, `DASH`, and `NONE`. (AWS default is `SLASH`.) (Ignored for source endpoints.)
        """
        return pulumi.get(self, "date_partition_delimiter")

    @date_partition_delimiter.setter
    def date_partition_delimiter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "date_partition_delimiter", value)

    @property
    @pulumi.getter(name="datePartitionEnabled")
    def date_partition_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Partition S3 bucket folders based on transaction commit dates. Default is `false`. (Ignored for source endpoints.)
        """
        return pulumi.get(self, "date_partition_enabled")

    @date_partition_enabled.setter
    def date_partition_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "date_partition_enabled", value)

    @property
    @pulumi.getter(name="datePartitionSequence")
    def date_partition_sequence(self) -> Optional[pulumi.Input[str]]:
        """
        Date format to use during folder partitioning. Use this parameter when `date_partition_enabled` is set to true. Valid values are `YYYYMMDD`, `YYYYMMDDHH`, `YYYYMM`, `MMYYYYDD`, and `DDMMYYYY`. (AWS default is `YYYYMMDD`.) (Ignored for source endpoints.)
        """
        return pulumi.get(self, "date_partition_sequence")

    @date_partition_sequence.setter
    def date_partition_sequence(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "date_partition_sequence", value)

    @property
    @pulumi.getter(name="datePartitionTimezone")
    def date_partition_timezone(self) -> Optional[pulumi.Input[str]]:
        """
        Convert the current UTC time to a timezone. The conversion occurs when a date partition folder is created and a CDC filename is generated. The timezone format is Area/Location (_e.g._, `Europe/Paris`). Use this when `date_partition_enabled` is `true`. (Ignored for source endpoints.)
        """
        return pulumi.get(self, "date_partition_timezone")

    @date_partition_timezone.setter
    def date_partition_timezone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "date_partition_timezone", value)

    @property
    @pulumi.getter(name="detachTargetOnLobLookupFailureParquet")
    def detach_target_on_lob_lookup_failure_parquet(self) -> Optional[pulumi.Input[bool]]:
        """
        Undocumented argument for use as directed by AWS Support.
        """
        return pulumi.get(self, "detach_target_on_lob_lookup_failure_parquet")

    @detach_target_on_lob_lookup_failure_parquet.setter
    def detach_target_on_lob_lookup_failure_parquet(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "detach_target_on_lob_lookup_failure_parquet", value)

    @property
    @pulumi.getter(name="dictPageSizeLimit")
    def dict_page_size_limit(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum size in bytes of an encoded dictionary page of a column. (AWS default is 1 MiB, _i.e._, `1048576`.)
        """
        return pulumi.get(self, "dict_page_size_limit")

    @dict_page_size_limit.setter
    def dict_page_size_limit(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "dict_page_size_limit", value)

    @property
    @pulumi.getter(name="enableStatistics")
    def enable_statistics(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable statistics for Parquet pages and row groups. Default is `true`.
        """
        return pulumi.get(self, "enable_statistics")

    @enable_statistics.setter
    def enable_statistics(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_statistics", value)

    @property
    @pulumi.getter(name="encodingType")
    def encoding_type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of encoding to use. Value values are `rle_dictionary`, `plain`, and `plain_dictionary`. (AWS default is `rle_dictionary`.)
        """
        return pulumi.get(self, "encoding_type")

    @encoding_type.setter
    def encoding_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "encoding_type", value)

    @property
    @pulumi.getter(name="encryptionMode")
    def encryption_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Server-side encryption mode that you want to encrypt your .csv or .parquet object files copied to S3. Valid values are `SSE_S3` and `SSE_KMS`. (AWS default is `SSE_S3`.) (Ignored for source endpoints -- only `SSE_S3` is valid.)
        """
        return pulumi.get(self, "encryption_mode")

    @encryption_mode.setter
    def encryption_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "encryption_mode", value)

    @property
    @pulumi.getter(name="expectedBucketOwner")
    def expected_bucket_owner(self) -> Optional[pulumi.Input[str]]:
        """
        Bucket owner to prevent sniping. Value is an AWS account ID.
        """
        return pulumi.get(self, "expected_bucket_owner")

    @expected_bucket_owner.setter
    def expected_bucket_owner(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expected_bucket_owner", value)

    @property
    @pulumi.getter(name="externalTableDefinition")
    def external_table_definition(self) -> Optional[pulumi.Input[str]]:
        """
        JSON document that describes how AWS DMS should interpret the data.
        """
        return pulumi.get(self, "external_table_definition")

    @external_table_definition.setter
    def external_table_definition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "external_table_definition", value)

    @property
    @pulumi.getter(name="ignoreHeaderRows")
    def ignore_header_rows(self) -> Optional[pulumi.Input[int]]:
        """
        When this value is set to `1`, DMS ignores the first row header in a .csv file. (AWS default is `0`.)
        """
        return pulumi.get(self, "ignore_header_rows")

    @ignore_header_rows.setter
    def ignore_header_rows(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ignore_header_rows", value)

    @property
    @pulumi.getter(name="includeOpForFullLoad")
    def include_op_for_full_load(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable a full load to write INSERT operations to the .csv output files only to indicate how the rows were added to the source database. Default is `false`.
        """
        return pulumi.get(self, "include_op_for_full_load")

    @include_op_for_full_load.setter
    def include_op_for_full_load(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "include_op_for_full_load", value)

    @property
    @pulumi.getter(name="kmsKeyArn")
    def kms_key_arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN for the KMS key that will be used to encrypt the connection parameters. If you do not specify a value for `kms_key_arn`, then AWS DMS will use your default encryption key. AWS KMS creates the default encryption key for your AWS account. Your AWS account has a different default encryption key for each AWS region.
        """
        return pulumi.get(self, "kms_key_arn")

    @kms_key_arn.setter
    def kms_key_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_arn", value)

    @property
    @pulumi.getter(name="maxFileSize")
    def max_file_size(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum size (in KB) of any .csv file to be created while migrating to an S3 target during full load. Valid values are from `1` to `1048576`. (AWS default is 1 GB, _i.e._, `1048576`.)
        """
        return pulumi.get(self, "max_file_size")

    @max_file_size.setter
    def max_file_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_file_size", value)

    @property
    @pulumi.getter(name="parquetTimestampInMillisecond")
    def parquet_timestamp_in_millisecond(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies the precision of any TIMESTAMP column values written to an S3 object file in .parquet format. Default is `false`. (Ignored for source endpoints.)
        """
        return pulumi.get(self, "parquet_timestamp_in_millisecond")

    @parquet_timestamp_in_millisecond.setter
    def parquet_timestamp_in_millisecond(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "parquet_timestamp_in_millisecond", value)

    @property
    @pulumi.getter(name="parquetVersion")
    def parquet_version(self) -> Optional[pulumi.Input[str]]:
        """
        Version of the .parquet file format. Valid values are `parquet-1-0` and `parquet-2-0`. (AWS default is `parquet-1-0`.) (Ignored for source endpoints.)
        """
        return pulumi.get(self, "parquet_version")

    @parquet_version.setter
    def parquet_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parquet_version", value)

    @property
    @pulumi.getter(name="preserveTransactions")
    def preserve_transactions(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether DMS saves the transaction order for a CDC load on the S3 target specified by `cdc_path`. Default is `false`. (Ignored for source endpoints.)
        """
        return pulumi.get(self, "preserve_transactions")

    @preserve_transactions.setter
    def preserve_transactions(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "preserve_transactions", value)

    @property
    @pulumi.getter
    def rfc4180(self) -> Optional[pulumi.Input[bool]]:
        """
        For an S3 source, whether each leading double quotation mark has to be followed by an ending double quotation mark. Default is `true`.
        """
        return pulumi.get(self, "rfc4180")

    @rfc4180.setter
    def rfc4180(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "rfc4180", value)

    @property
    @pulumi.getter(name="rowGroupLength")
    def row_group_length(self) -> Optional[pulumi.Input[int]]:
        """
        Number of rows in a row group. (AWS default is `10000`.)
        """
        return pulumi.get(self, "row_group_length")

    @row_group_length.setter
    def row_group_length(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "row_group_length", value)

    @property
    @pulumi.getter(name="serverSideEncryptionKmsKeyId")
    def server_side_encryption_kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        When `encryption_mode` is `SSE_KMS`, ARN for the AWS KMS key. (Ignored for source endpoints -- only `SSE_S3` `encryption_mode` is valid.)
        """
        return pulumi.get(self, "server_side_encryption_kms_key_id")

    @server_side_encryption_kms_key_id.setter
    def server_side_encryption_kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_side_encryption_kms_key_id", value)

    @property
    @pulumi.getter(name="sslMode")
    def ssl_mode(self) -> Optional[pulumi.Input[str]]:
        """
        SSL mode to use for the connection. Valid values are `none`, `require`, `verify-ca`, `verify-full`. (AWS default is `none`.)
        """
        return pulumi.get(self, "ssl_mode")

    @ssl_mode.setter
    def ssl_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssl_mode", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="timestampColumnName")
    def timestamp_column_name(self) -> Optional[pulumi.Input[str]]:
        """
        Column to add with timestamp information to the endpoint data for an Amazon S3 target.
        """
        return pulumi.get(self, "timestamp_column_name")

    @timestamp_column_name.setter
    def timestamp_column_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timestamp_column_name", value)

    @property
    @pulumi.getter(name="useCsvNoSupValue")
    def use_csv_no_sup_value(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to use `csv_no_sup_value` for columns not included in the supplemental log. (Ignored for source endpoints.)
        """
        return pulumi.get(self, "use_csv_no_sup_value")

    @use_csv_no_sup_value.setter
    def use_csv_no_sup_value(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_csv_no_sup_value", value)

    @property
    @pulumi.getter(name="useTaskStartTimeForFullLoadTimestamp")
    def use_task_start_time_for_full_load_timestamp(self) -> Optional[pulumi.Input[bool]]:
        """
        When set to `true`, uses the task start time as the timestamp column value instead of the time data is written to target. For full load, when set to `true`, each row of the timestamp column contains the task start time. For CDC loads, each row of the timestamp column contains the transaction commit time.When set to false, the full load timestamp in the timestamp column increments with the time data arrives at the target. Default is `false`.
        """
        return pulumi.get(self, "use_task_start_time_for_full_load_timestamp")

    @use_task_start_time_for_full_load_timestamp.setter
    def use_task_start_time_for_full_load_timestamp(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_task_start_time_for_full_load_timestamp", value)


@pulumi.input_type
class _S3EndpointState:
    def __init__(__self__, *,
                 add_column_name: Optional[pulumi.Input[bool]] = None,
                 add_trailing_padding_character: Optional[pulumi.Input[bool]] = None,
                 bucket_folder: Optional[pulumi.Input[str]] = None,
                 bucket_name: Optional[pulumi.Input[str]] = None,
                 canned_acl_for_objects: Optional[pulumi.Input[str]] = None,
                 cdc_inserts_and_updates: Optional[pulumi.Input[bool]] = None,
                 cdc_inserts_only: Optional[pulumi.Input[bool]] = None,
                 cdc_max_batch_interval: Optional[pulumi.Input[int]] = None,
                 cdc_min_file_size: Optional[pulumi.Input[int]] = None,
                 cdc_path: Optional[pulumi.Input[str]] = None,
                 certificate_arn: Optional[pulumi.Input[str]] = None,
                 compression_type: Optional[pulumi.Input[str]] = None,
                 csv_delimiter: Optional[pulumi.Input[str]] = None,
                 csv_no_sup_value: Optional[pulumi.Input[str]] = None,
                 csv_null_value: Optional[pulumi.Input[str]] = None,
                 csv_row_delimiter: Optional[pulumi.Input[str]] = None,
                 data_format: Optional[pulumi.Input[str]] = None,
                 data_page_size: Optional[pulumi.Input[int]] = None,
                 date_partition_delimiter: Optional[pulumi.Input[str]] = None,
                 date_partition_enabled: Optional[pulumi.Input[bool]] = None,
                 date_partition_sequence: Optional[pulumi.Input[str]] = None,
                 date_partition_timezone: Optional[pulumi.Input[str]] = None,
                 detach_target_on_lob_lookup_failure_parquet: Optional[pulumi.Input[bool]] = None,
                 dict_page_size_limit: Optional[pulumi.Input[int]] = None,
                 enable_statistics: Optional[pulumi.Input[bool]] = None,
                 encoding_type: Optional[pulumi.Input[str]] = None,
                 encryption_mode: Optional[pulumi.Input[str]] = None,
                 endpoint_arn: Optional[pulumi.Input[str]] = None,
                 endpoint_id: Optional[pulumi.Input[str]] = None,
                 endpoint_type: Optional[pulumi.Input[str]] = None,
                 engine_display_name: Optional[pulumi.Input[str]] = None,
                 expected_bucket_owner: Optional[pulumi.Input[str]] = None,
                 external_id: Optional[pulumi.Input[str]] = None,
                 external_table_definition: Optional[pulumi.Input[str]] = None,
                 ignore_header_rows: Optional[pulumi.Input[int]] = None,
                 include_op_for_full_load: Optional[pulumi.Input[bool]] = None,
                 kms_key_arn: Optional[pulumi.Input[str]] = None,
                 max_file_size: Optional[pulumi.Input[int]] = None,
                 parquet_timestamp_in_millisecond: Optional[pulumi.Input[bool]] = None,
                 parquet_version: Optional[pulumi.Input[str]] = None,
                 preserve_transactions: Optional[pulumi.Input[bool]] = None,
                 rfc4180: Optional[pulumi.Input[bool]] = None,
                 row_group_length: Optional[pulumi.Input[int]] = None,
                 server_side_encryption_kms_key_id: Optional[pulumi.Input[str]] = None,
                 service_access_role_arn: Optional[pulumi.Input[str]] = None,
                 ssl_mode: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 timestamp_column_name: Optional[pulumi.Input[str]] = None,
                 use_csv_no_sup_value: Optional[pulumi.Input[bool]] = None,
                 use_task_start_time_for_full_load_timestamp: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering S3Endpoint resources.
        :param pulumi.Input[bool] add_column_name: Whether to add column name information to the .csv output file. Default is `false`.
        :param pulumi.Input[bool] add_trailing_padding_character: Whether to add padding. Default is `false`. (Ignored for source endpoints.)
        :param pulumi.Input[str] bucket_folder: S3 object prefix.
        :param pulumi.Input[str] bucket_name: S3 bucket name.
        :param pulumi.Input[str] canned_acl_for_objects: Predefined (canned) access control list for objects created in an S3 bucket. Valid values include `none`, `private`, `public-read`, `public-read-write`, `authenticated-read`, `aws-exec-read`, `bucket-owner-read`, and `bucket-owner-full-control`. Default is `none`.
        :param pulumi.Input[bool] cdc_inserts_and_updates: Whether to write insert and update operations to .csv or .parquet output files. Default is `false`.
        :param pulumi.Input[bool] cdc_inserts_only: Whether to write insert operations to .csv or .parquet output files. Default is `false`.
        :param pulumi.Input[int] cdc_max_batch_interval: Maximum length of the interval, defined in seconds, after which to output a file to Amazon S3. (AWS default is `60`.)
        :param pulumi.Input[int] cdc_min_file_size: Minimum file size condition as defined in kilobytes to output a file to Amazon S3. (AWS default is 32000 KB.)
        :param pulumi.Input[str] cdc_path: Folder path of CDC files. If `cdc_path` is set, AWS DMS reads CDC files from this path and replicates the data changes to the target endpoint. Supported in AWS DMS versions 3.4.2 and later.
        :param pulumi.Input[str] certificate_arn: ARN for the certificate.
        :param pulumi.Input[str] compression_type: Set to compress target files. Valid values are `GZIP` and `NONE`. Default is `NONE`. (Ignored for source endpoints.)
        :param pulumi.Input[str] csv_delimiter: Delimiter used to separate columns in the source files. Default is `,`.
        :param pulumi.Input[str] csv_no_sup_value: Only applies if output files for a CDC load are written in .csv format. If `use_csv_no_sup_value` is set to `true`, string to use for all columns not included in the supplemental log. If you do not specify a string value, DMS uses the null value for these columns regardless of `use_csv_no_sup_value`. (Ignored for source endpoints.)
        :param pulumi.Input[str] csv_null_value: String to as null when writing to the target. (AWS default is `NULL`.)
        :param pulumi.Input[str] csv_row_delimiter: Delimiter used to separate rows in the source files. Default is newline (_i.e._, `\\n`).
        :param pulumi.Input[str] data_format: Output format for the files that AWS DMS uses to create S3 objects. Valid values are `csv` and `parquet`.  (Ignored for source endpoints -- only `csv` is valid.)
        :param pulumi.Input[int] data_page_size: Size of one data page in bytes. (AWS default is 1 MiB, _i.e._, `1048576`.)
        :param pulumi.Input[str] date_partition_delimiter: Date separating delimiter to use during folder partitioning. Valid values are `SLASH`, `UNDERSCORE`, `DASH`, and `NONE`. (AWS default is `SLASH`.) (Ignored for source endpoints.)
        :param pulumi.Input[bool] date_partition_enabled: Partition S3 bucket folders based on transaction commit dates. Default is `false`. (Ignored for source endpoints.)
        :param pulumi.Input[str] date_partition_sequence: Date format to use during folder partitioning. Use this parameter when `date_partition_enabled` is set to true. Valid values are `YYYYMMDD`, `YYYYMMDDHH`, `YYYYMM`, `MMYYYYDD`, and `DDMMYYYY`. (AWS default is `YYYYMMDD`.) (Ignored for source endpoints.)
        :param pulumi.Input[str] date_partition_timezone: Convert the current UTC time to a timezone. The conversion occurs when a date partition folder is created and a CDC filename is generated. The timezone format is Area/Location (_e.g._, `Europe/Paris`). Use this when `date_partition_enabled` is `true`. (Ignored for source endpoints.)
        :param pulumi.Input[bool] detach_target_on_lob_lookup_failure_parquet: Undocumented argument for use as directed by AWS Support.
        :param pulumi.Input[int] dict_page_size_limit: Maximum size in bytes of an encoded dictionary page of a column. (AWS default is 1 MiB, _i.e._, `1048576`.)
        :param pulumi.Input[bool] enable_statistics: Whether to enable statistics for Parquet pages and row groups. Default is `true`.
        :param pulumi.Input[str] encoding_type: Type of encoding to use. Value values are `rle_dictionary`, `plain`, and `plain_dictionary`. (AWS default is `rle_dictionary`.)
        :param pulumi.Input[str] encryption_mode: Server-side encryption mode that you want to encrypt your .csv or .parquet object files copied to S3. Valid values are `SSE_S3` and `SSE_KMS`. (AWS default is `SSE_S3`.) (Ignored for source endpoints -- only `SSE_S3` is valid.)
        :param pulumi.Input[str] endpoint_arn: ARN for the endpoint.
        :param pulumi.Input[str] endpoint_id: Database endpoint identifier. Identifiers must contain from 1 to 255 alphanumeric characters or hyphens, begin with a letter, contain only ASCII letters, digits, and hyphens, not end with a hyphen, and not contain two consecutive hyphens.
        :param pulumi.Input[str] endpoint_type: Type of endpoint. Valid values are `source`, `target`.
        :param pulumi.Input[str] engine_display_name: Expanded name for the engine name.
        :param pulumi.Input[str] expected_bucket_owner: Bucket owner to prevent sniping. Value is an AWS account ID.
        :param pulumi.Input[str] external_id: Can be used for cross-account validation. Use it in another account with `dms.S3Endpoint` to create the endpoint cross-account.
        :param pulumi.Input[str] external_table_definition: JSON document that describes how AWS DMS should interpret the data.
        :param pulumi.Input[int] ignore_header_rows: When this value is set to `1`, DMS ignores the first row header in a .csv file. (AWS default is `0`.)
        :param pulumi.Input[bool] include_op_for_full_load: Whether to enable a full load to write INSERT operations to the .csv output files only to indicate how the rows were added to the source database. Default is `false`.
        :param pulumi.Input[str] kms_key_arn: ARN for the KMS key that will be used to encrypt the connection parameters. If you do not specify a value for `kms_key_arn`, then AWS DMS will use your default encryption key. AWS KMS creates the default encryption key for your AWS account. Your AWS account has a different default encryption key for each AWS region.
        :param pulumi.Input[int] max_file_size: Maximum size (in KB) of any .csv file to be created while migrating to an S3 target during full load. Valid values are from `1` to `1048576`. (AWS default is 1 GB, _i.e._, `1048576`.)
        :param pulumi.Input[bool] parquet_timestamp_in_millisecond: Specifies the precision of any TIMESTAMP column values written to an S3 object file in .parquet format. Default is `false`. (Ignored for source endpoints.)
        :param pulumi.Input[str] parquet_version: Version of the .parquet file format. Valid values are `parquet-1-0` and `parquet-2-0`. (AWS default is `parquet-1-0`.) (Ignored for source endpoints.)
        :param pulumi.Input[bool] preserve_transactions: Whether DMS saves the transaction order for a CDC load on the S3 target specified by `cdc_path`. Default is `false`. (Ignored for source endpoints.)
        :param pulumi.Input[bool] rfc4180: For an S3 source, whether each leading double quotation mark has to be followed by an ending double quotation mark. Default is `true`.
        :param pulumi.Input[int] row_group_length: Number of rows in a row group. (AWS default is `10000`.)
        :param pulumi.Input[str] server_side_encryption_kms_key_id: When `encryption_mode` is `SSE_KMS`, ARN for the AWS KMS key. (Ignored for source endpoints -- only `SSE_S3` `encryption_mode` is valid.)
        :param pulumi.Input[str] service_access_role_arn: ARN of the IAM role with permissions to the S3 Bucket.
               
               The following arguments are optional:
        :param pulumi.Input[str] ssl_mode: SSL mode to use for the connection. Valid values are `none`, `require`, `verify-ca`, `verify-full`. (AWS default is `none`.)
        :param pulumi.Input[str] status: Status of the endpoint.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[str] timestamp_column_name: Column to add with timestamp information to the endpoint data for an Amazon S3 target.
        :param pulumi.Input[bool] use_csv_no_sup_value: Whether to use `csv_no_sup_value` for columns not included in the supplemental log. (Ignored for source endpoints.)
        :param pulumi.Input[bool] use_task_start_time_for_full_load_timestamp: When set to `true`, uses the task start time as the timestamp column value instead of the time data is written to target. For full load, when set to `true`, each row of the timestamp column contains the task start time. For CDC loads, each row of the timestamp column contains the transaction commit time.When set to false, the full load timestamp in the timestamp column increments with the time data arrives at the target. Default is `false`.
        """
        if add_column_name is not None:
            pulumi.set(__self__, "add_column_name", add_column_name)
        if add_trailing_padding_character is not None:
            pulumi.set(__self__, "add_trailing_padding_character", add_trailing_padding_character)
        if bucket_folder is not None:
            pulumi.set(__self__, "bucket_folder", bucket_folder)
        if bucket_name is not None:
            pulumi.set(__self__, "bucket_name", bucket_name)
        if canned_acl_for_objects is not None:
            pulumi.set(__self__, "canned_acl_for_objects", canned_acl_for_objects)
        if cdc_inserts_and_updates is not None:
            pulumi.set(__self__, "cdc_inserts_and_updates", cdc_inserts_and_updates)
        if cdc_inserts_only is not None:
            pulumi.set(__self__, "cdc_inserts_only", cdc_inserts_only)
        if cdc_max_batch_interval is not None:
            pulumi.set(__self__, "cdc_max_batch_interval", cdc_max_batch_interval)
        if cdc_min_file_size is not None:
            pulumi.set(__self__, "cdc_min_file_size", cdc_min_file_size)
        if cdc_path is not None:
            pulumi.set(__self__, "cdc_path", cdc_path)
        if certificate_arn is not None:
            pulumi.set(__self__, "certificate_arn", certificate_arn)
        if compression_type is not None:
            pulumi.set(__self__, "compression_type", compression_type)
        if csv_delimiter is not None:
            pulumi.set(__self__, "csv_delimiter", csv_delimiter)
        if csv_no_sup_value is not None:
            pulumi.set(__self__, "csv_no_sup_value", csv_no_sup_value)
        if csv_null_value is not None:
            pulumi.set(__self__, "csv_null_value", csv_null_value)
        if csv_row_delimiter is not None:
            pulumi.set(__self__, "csv_row_delimiter", csv_row_delimiter)
        if data_format is not None:
            pulumi.set(__self__, "data_format", data_format)
        if data_page_size is not None:
            pulumi.set(__self__, "data_page_size", data_page_size)
        if date_partition_delimiter is not None:
            pulumi.set(__self__, "date_partition_delimiter", date_partition_delimiter)
        if date_partition_enabled is not None:
            pulumi.set(__self__, "date_partition_enabled", date_partition_enabled)
        if date_partition_sequence is not None:
            pulumi.set(__self__, "date_partition_sequence", date_partition_sequence)
        if date_partition_timezone is not None:
            pulumi.set(__self__, "date_partition_timezone", date_partition_timezone)
        if detach_target_on_lob_lookup_failure_parquet is not None:
            pulumi.set(__self__, "detach_target_on_lob_lookup_failure_parquet", detach_target_on_lob_lookup_failure_parquet)
        if dict_page_size_limit is not None:
            pulumi.set(__self__, "dict_page_size_limit", dict_page_size_limit)
        if enable_statistics is not None:
            pulumi.set(__self__, "enable_statistics", enable_statistics)
        if encoding_type is not None:
            pulumi.set(__self__, "encoding_type", encoding_type)
        if encryption_mode is not None:
            pulumi.set(__self__, "encryption_mode", encryption_mode)
        if endpoint_arn is not None:
            pulumi.set(__self__, "endpoint_arn", endpoint_arn)
        if endpoint_id is not None:
            pulumi.set(__self__, "endpoint_id", endpoint_id)
        if endpoint_type is not None:
            pulumi.set(__self__, "endpoint_type", endpoint_type)
        if engine_display_name is not None:
            pulumi.set(__self__, "engine_display_name", engine_display_name)
        if expected_bucket_owner is not None:
            pulumi.set(__self__, "expected_bucket_owner", expected_bucket_owner)
        if external_id is not None:
            pulumi.set(__self__, "external_id", external_id)
        if external_table_definition is not None:
            pulumi.set(__self__, "external_table_definition", external_table_definition)
        if ignore_header_rows is not None:
            pulumi.set(__self__, "ignore_header_rows", ignore_header_rows)
        if include_op_for_full_load is not None:
            pulumi.set(__self__, "include_op_for_full_load", include_op_for_full_load)
        if kms_key_arn is not None:
            pulumi.set(__self__, "kms_key_arn", kms_key_arn)
        if max_file_size is not None:
            pulumi.set(__self__, "max_file_size", max_file_size)
        if parquet_timestamp_in_millisecond is not None:
            pulumi.set(__self__, "parquet_timestamp_in_millisecond", parquet_timestamp_in_millisecond)
        if parquet_version is not None:
            pulumi.set(__self__, "parquet_version", parquet_version)
        if preserve_transactions is not None:
            pulumi.set(__self__, "preserve_transactions", preserve_transactions)
        if rfc4180 is not None:
            pulumi.set(__self__, "rfc4180", rfc4180)
        if row_group_length is not None:
            pulumi.set(__self__, "row_group_length", row_group_length)
        if server_side_encryption_kms_key_id is not None:
            pulumi.set(__self__, "server_side_encryption_kms_key_id", server_side_encryption_kms_key_id)
        if service_access_role_arn is not None:
            pulumi.set(__self__, "service_access_role_arn", service_access_role_arn)
        if ssl_mode is not None:
            pulumi.set(__self__, "ssl_mode", ssl_mode)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if timestamp_column_name is not None:
            pulumi.set(__self__, "timestamp_column_name", timestamp_column_name)
        if use_csv_no_sup_value is not None:
            pulumi.set(__self__, "use_csv_no_sup_value", use_csv_no_sup_value)
        if use_task_start_time_for_full_load_timestamp is not None:
            pulumi.set(__self__, "use_task_start_time_for_full_load_timestamp", use_task_start_time_for_full_load_timestamp)

    @property
    @pulumi.getter(name="addColumnName")
    def add_column_name(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to add column name information to the .csv output file. Default is `false`.
        """
        return pulumi.get(self, "add_column_name")

    @add_column_name.setter
    def add_column_name(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "add_column_name", value)

    @property
    @pulumi.getter(name="addTrailingPaddingCharacter")
    def add_trailing_padding_character(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to add padding. Default is `false`. (Ignored for source endpoints.)
        """
        return pulumi.get(self, "add_trailing_padding_character")

    @add_trailing_padding_character.setter
    def add_trailing_padding_character(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "add_trailing_padding_character", value)

    @property
    @pulumi.getter(name="bucketFolder")
    def bucket_folder(self) -> Optional[pulumi.Input[str]]:
        """
        S3 object prefix.
        """
        return pulumi.get(self, "bucket_folder")

    @bucket_folder.setter
    def bucket_folder(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bucket_folder", value)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> Optional[pulumi.Input[str]]:
        """
        S3 bucket name.
        """
        return pulumi.get(self, "bucket_name")

    @bucket_name.setter
    def bucket_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bucket_name", value)

    @property
    @pulumi.getter(name="cannedAclForObjects")
    def canned_acl_for_objects(self) -> Optional[pulumi.Input[str]]:
        """
        Predefined (canned) access control list for objects created in an S3 bucket. Valid values include `none`, `private`, `public-read`, `public-read-write`, `authenticated-read`, `aws-exec-read`, `bucket-owner-read`, and `bucket-owner-full-control`. Default is `none`.
        """
        return pulumi.get(self, "canned_acl_for_objects")

    @canned_acl_for_objects.setter
    def canned_acl_for_objects(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "canned_acl_for_objects", value)

    @property
    @pulumi.getter(name="cdcInsertsAndUpdates")
    def cdc_inserts_and_updates(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to write insert and update operations to .csv or .parquet output files. Default is `false`.
        """
        return pulumi.get(self, "cdc_inserts_and_updates")

    @cdc_inserts_and_updates.setter
    def cdc_inserts_and_updates(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "cdc_inserts_and_updates", value)

    @property
    @pulumi.getter(name="cdcInsertsOnly")
    def cdc_inserts_only(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to write insert operations to .csv or .parquet output files. Default is `false`.
        """
        return pulumi.get(self, "cdc_inserts_only")

    @cdc_inserts_only.setter
    def cdc_inserts_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "cdc_inserts_only", value)

    @property
    @pulumi.getter(name="cdcMaxBatchInterval")
    def cdc_max_batch_interval(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum length of the interval, defined in seconds, after which to output a file to Amazon S3. (AWS default is `60`.)
        """
        return pulumi.get(self, "cdc_max_batch_interval")

    @cdc_max_batch_interval.setter
    def cdc_max_batch_interval(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cdc_max_batch_interval", value)

    @property
    @pulumi.getter(name="cdcMinFileSize")
    def cdc_min_file_size(self) -> Optional[pulumi.Input[int]]:
        """
        Minimum file size condition as defined in kilobytes to output a file to Amazon S3. (AWS default is 32000 KB.)
        """
        return pulumi.get(self, "cdc_min_file_size")

    @cdc_min_file_size.setter
    def cdc_min_file_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cdc_min_file_size", value)

    @property
    @pulumi.getter(name="cdcPath")
    def cdc_path(self) -> Optional[pulumi.Input[str]]:
        """
        Folder path of CDC files. If `cdc_path` is set, AWS DMS reads CDC files from this path and replicates the data changes to the target endpoint. Supported in AWS DMS versions 3.4.2 and later.
        """
        return pulumi.get(self, "cdc_path")

    @cdc_path.setter
    def cdc_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cdc_path", value)

    @property
    @pulumi.getter(name="certificateArn")
    def certificate_arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN for the certificate.
        """
        return pulumi.get(self, "certificate_arn")

    @certificate_arn.setter
    def certificate_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_arn", value)

    @property
    @pulumi.getter(name="compressionType")
    def compression_type(self) -> Optional[pulumi.Input[str]]:
        """
        Set to compress target files. Valid values are `GZIP` and `NONE`. Default is `NONE`. (Ignored for source endpoints.)
        """
        return pulumi.get(self, "compression_type")

    @compression_type.setter
    def compression_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compression_type", value)

    @property
    @pulumi.getter(name="csvDelimiter")
    def csv_delimiter(self) -> Optional[pulumi.Input[str]]:
        """
        Delimiter used to separate columns in the source files. Default is `,`.
        """
        return pulumi.get(self, "csv_delimiter")

    @csv_delimiter.setter
    def csv_delimiter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "csv_delimiter", value)

    @property
    @pulumi.getter(name="csvNoSupValue")
    def csv_no_sup_value(self) -> Optional[pulumi.Input[str]]:
        """
        Only applies if output files for a CDC load are written in .csv format. If `use_csv_no_sup_value` is set to `true`, string to use for all columns not included in the supplemental log. If you do not specify a string value, DMS uses the null value for these columns regardless of `use_csv_no_sup_value`. (Ignored for source endpoints.)
        """
        return pulumi.get(self, "csv_no_sup_value")

    @csv_no_sup_value.setter
    def csv_no_sup_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "csv_no_sup_value", value)

    @property
    @pulumi.getter(name="csvNullValue")
    def csv_null_value(self) -> Optional[pulumi.Input[str]]:
        """
        String to as null when writing to the target. (AWS default is `NULL`.)
        """
        return pulumi.get(self, "csv_null_value")

    @csv_null_value.setter
    def csv_null_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "csv_null_value", value)

    @property
    @pulumi.getter(name="csvRowDelimiter")
    def csv_row_delimiter(self) -> Optional[pulumi.Input[str]]:
        """
        Delimiter used to separate rows in the source files. Default is newline (_i.e._, `\\n`).
        """
        return pulumi.get(self, "csv_row_delimiter")

    @csv_row_delimiter.setter
    def csv_row_delimiter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "csv_row_delimiter", value)

    @property
    @pulumi.getter(name="dataFormat")
    def data_format(self) -> Optional[pulumi.Input[str]]:
        """
        Output format for the files that AWS DMS uses to create S3 objects. Valid values are `csv` and `parquet`.  (Ignored for source endpoints -- only `csv` is valid.)
        """
        return pulumi.get(self, "data_format")

    @data_format.setter
    def data_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_format", value)

    @property
    @pulumi.getter(name="dataPageSize")
    def data_page_size(self) -> Optional[pulumi.Input[int]]:
        """
        Size of one data page in bytes. (AWS default is 1 MiB, _i.e._, `1048576`.)
        """
        return pulumi.get(self, "data_page_size")

    @data_page_size.setter
    def data_page_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "data_page_size", value)

    @property
    @pulumi.getter(name="datePartitionDelimiter")
    def date_partition_delimiter(self) -> Optional[pulumi.Input[str]]:
        """
        Date separating delimiter to use during folder partitioning. Valid values are `SLASH`, `UNDERSCORE`, `DASH`, and `NONE`. (AWS default is `SLASH`.) (Ignored for source endpoints.)
        """
        return pulumi.get(self, "date_partition_delimiter")

    @date_partition_delimiter.setter
    def date_partition_delimiter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "date_partition_delimiter", value)

    @property
    @pulumi.getter(name="datePartitionEnabled")
    def date_partition_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Partition S3 bucket folders based on transaction commit dates. Default is `false`. (Ignored for source endpoints.)
        """
        return pulumi.get(self, "date_partition_enabled")

    @date_partition_enabled.setter
    def date_partition_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "date_partition_enabled", value)

    @property
    @pulumi.getter(name="datePartitionSequence")
    def date_partition_sequence(self) -> Optional[pulumi.Input[str]]:
        """
        Date format to use during folder partitioning. Use this parameter when `date_partition_enabled` is set to true. Valid values are `YYYYMMDD`, `YYYYMMDDHH`, `YYYYMM`, `MMYYYYDD`, and `DDMMYYYY`. (AWS default is `YYYYMMDD`.) (Ignored for source endpoints.)
        """
        return pulumi.get(self, "date_partition_sequence")

    @date_partition_sequence.setter
    def date_partition_sequence(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "date_partition_sequence", value)

    @property
    @pulumi.getter(name="datePartitionTimezone")
    def date_partition_timezone(self) -> Optional[pulumi.Input[str]]:
        """
        Convert the current UTC time to a timezone. The conversion occurs when a date partition folder is created and a CDC filename is generated. The timezone format is Area/Location (_e.g._, `Europe/Paris`). Use this when `date_partition_enabled` is `true`. (Ignored for source endpoints.)
        """
        return pulumi.get(self, "date_partition_timezone")

    @date_partition_timezone.setter
    def date_partition_timezone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "date_partition_timezone", value)

    @property
    @pulumi.getter(name="detachTargetOnLobLookupFailureParquet")
    def detach_target_on_lob_lookup_failure_parquet(self) -> Optional[pulumi.Input[bool]]:
        """
        Undocumented argument for use as directed by AWS Support.
        """
        return pulumi.get(self, "detach_target_on_lob_lookup_failure_parquet")

    @detach_target_on_lob_lookup_failure_parquet.setter
    def detach_target_on_lob_lookup_failure_parquet(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "detach_target_on_lob_lookup_failure_parquet", value)

    @property
    @pulumi.getter(name="dictPageSizeLimit")
    def dict_page_size_limit(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum size in bytes of an encoded dictionary page of a column. (AWS default is 1 MiB, _i.e._, `1048576`.)
        """
        return pulumi.get(self, "dict_page_size_limit")

    @dict_page_size_limit.setter
    def dict_page_size_limit(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "dict_page_size_limit", value)

    @property
    @pulumi.getter(name="enableStatistics")
    def enable_statistics(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable statistics for Parquet pages and row groups. Default is `true`.
        """
        return pulumi.get(self, "enable_statistics")

    @enable_statistics.setter
    def enable_statistics(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_statistics", value)

    @property
    @pulumi.getter(name="encodingType")
    def encoding_type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of encoding to use. Value values are `rle_dictionary`, `plain`, and `plain_dictionary`. (AWS default is `rle_dictionary`.)
        """
        return pulumi.get(self, "encoding_type")

    @encoding_type.setter
    def encoding_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "encoding_type", value)

    @property
    @pulumi.getter(name="encryptionMode")
    def encryption_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Server-side encryption mode that you want to encrypt your .csv or .parquet object files copied to S3. Valid values are `SSE_S3` and `SSE_KMS`. (AWS default is `SSE_S3`.) (Ignored for source endpoints -- only `SSE_S3` is valid.)
        """
        return pulumi.get(self, "encryption_mode")

    @encryption_mode.setter
    def encryption_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "encryption_mode", value)

    @property
    @pulumi.getter(name="endpointArn")
    def endpoint_arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN for the endpoint.
        """
        return pulumi.get(self, "endpoint_arn")

    @endpoint_arn.setter
    def endpoint_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint_arn", value)

    @property
    @pulumi.getter(name="endpointId")
    def endpoint_id(self) -> Optional[pulumi.Input[str]]:
        """
        Database endpoint identifier. Identifiers must contain from 1 to 255 alphanumeric characters or hyphens, begin with a letter, contain only ASCII letters, digits, and hyphens, not end with a hyphen, and not contain two consecutive hyphens.
        """
        return pulumi.get(self, "endpoint_id")

    @endpoint_id.setter
    def endpoint_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint_id", value)

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of endpoint. Valid values are `source`, `target`.
        """
        return pulumi.get(self, "endpoint_type")

    @endpoint_type.setter
    def endpoint_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint_type", value)

    @property
    @pulumi.getter(name="engineDisplayName")
    def engine_display_name(self) -> Optional[pulumi.Input[str]]:
        """
        Expanded name for the engine name.
        """
        return pulumi.get(self, "engine_display_name")

    @engine_display_name.setter
    def engine_display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "engine_display_name", value)

    @property
    @pulumi.getter(name="expectedBucketOwner")
    def expected_bucket_owner(self) -> Optional[pulumi.Input[str]]:
        """
        Bucket owner to prevent sniping. Value is an AWS account ID.
        """
        return pulumi.get(self, "expected_bucket_owner")

    @expected_bucket_owner.setter
    def expected_bucket_owner(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expected_bucket_owner", value)

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> Optional[pulumi.Input[str]]:
        """
        Can be used for cross-account validation. Use it in another account with `dms.S3Endpoint` to create the endpoint cross-account.
        """
        return pulumi.get(self, "external_id")

    @external_id.setter
    def external_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "external_id", value)

    @property
    @pulumi.getter(name="externalTableDefinition")
    def external_table_definition(self) -> Optional[pulumi.Input[str]]:
        """
        JSON document that describes how AWS DMS should interpret the data.
        """
        return pulumi.get(self, "external_table_definition")

    @external_table_definition.setter
    def external_table_definition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "external_table_definition", value)

    @property
    @pulumi.getter(name="ignoreHeaderRows")
    def ignore_header_rows(self) -> Optional[pulumi.Input[int]]:
        """
        When this value is set to `1`, DMS ignores the first row header in a .csv file. (AWS default is `0`.)
        """
        return pulumi.get(self, "ignore_header_rows")

    @ignore_header_rows.setter
    def ignore_header_rows(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ignore_header_rows", value)

    @property
    @pulumi.getter(name="includeOpForFullLoad")
    def include_op_for_full_load(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable a full load to write INSERT operations to the .csv output files only to indicate how the rows were added to the source database. Default is `false`.
        """
        return pulumi.get(self, "include_op_for_full_load")

    @include_op_for_full_load.setter
    def include_op_for_full_load(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "include_op_for_full_load", value)

    @property
    @pulumi.getter(name="kmsKeyArn")
    def kms_key_arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN for the KMS key that will be used to encrypt the connection parameters. If you do not specify a value for `kms_key_arn`, then AWS DMS will use your default encryption key. AWS KMS creates the default encryption key for your AWS account. Your AWS account has a different default encryption key for each AWS region.
        """
        return pulumi.get(self, "kms_key_arn")

    @kms_key_arn.setter
    def kms_key_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_arn", value)

    @property
    @pulumi.getter(name="maxFileSize")
    def max_file_size(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum size (in KB) of any .csv file to be created while migrating to an S3 target during full load. Valid values are from `1` to `1048576`. (AWS default is 1 GB, _i.e._, `1048576`.)
        """
        return pulumi.get(self, "max_file_size")

    @max_file_size.setter
    def max_file_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_file_size", value)

    @property
    @pulumi.getter(name="parquetTimestampInMillisecond")
    def parquet_timestamp_in_millisecond(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies the precision of any TIMESTAMP column values written to an S3 object file in .parquet format. Default is `false`. (Ignored for source endpoints.)
        """
        return pulumi.get(self, "parquet_timestamp_in_millisecond")

    @parquet_timestamp_in_millisecond.setter
    def parquet_timestamp_in_millisecond(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "parquet_timestamp_in_millisecond", value)

    @property
    @pulumi.getter(name="parquetVersion")
    def parquet_version(self) -> Optional[pulumi.Input[str]]:
        """
        Version of the .parquet file format. Valid values are `parquet-1-0` and `parquet-2-0`. (AWS default is `parquet-1-0`.) (Ignored for source endpoints.)
        """
        return pulumi.get(self, "parquet_version")

    @parquet_version.setter
    def parquet_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parquet_version", value)

    @property
    @pulumi.getter(name="preserveTransactions")
    def preserve_transactions(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether DMS saves the transaction order for a CDC load on the S3 target specified by `cdc_path`. Default is `false`. (Ignored for source endpoints.)
        """
        return pulumi.get(self, "preserve_transactions")

    @preserve_transactions.setter
    def preserve_transactions(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "preserve_transactions", value)

    @property
    @pulumi.getter
    def rfc4180(self) -> Optional[pulumi.Input[bool]]:
        """
        For an S3 source, whether each leading double quotation mark has to be followed by an ending double quotation mark. Default is `true`.
        """
        return pulumi.get(self, "rfc4180")

    @rfc4180.setter
    def rfc4180(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "rfc4180", value)

    @property
    @pulumi.getter(name="rowGroupLength")
    def row_group_length(self) -> Optional[pulumi.Input[int]]:
        """
        Number of rows in a row group. (AWS default is `10000`.)
        """
        return pulumi.get(self, "row_group_length")

    @row_group_length.setter
    def row_group_length(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "row_group_length", value)

    @property
    @pulumi.getter(name="serverSideEncryptionKmsKeyId")
    def server_side_encryption_kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        When `encryption_mode` is `SSE_KMS`, ARN for the AWS KMS key. (Ignored for source endpoints -- only `SSE_S3` `encryption_mode` is valid.)
        """
        return pulumi.get(self, "server_side_encryption_kms_key_id")

    @server_side_encryption_kms_key_id.setter
    def server_side_encryption_kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_side_encryption_kms_key_id", value)

    @property
    @pulumi.getter(name="serviceAccessRoleArn")
    def service_access_role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN of the IAM role with permissions to the S3 Bucket.

        The following arguments are optional:
        """
        return pulumi.get(self, "service_access_role_arn")

    @service_access_role_arn.setter
    def service_access_role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_access_role_arn", value)

    @property
    @pulumi.getter(name="sslMode")
    def ssl_mode(self) -> Optional[pulumi.Input[str]]:
        """
        SSL mode to use for the connection. Valid values are `none`, `require`, `verify-ca`, `verify-full`. (AWS default is `none`.)
        """
        return pulumi.get(self, "ssl_mode")

    @ssl_mode.setter
    def ssl_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssl_mode", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of the endpoint.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter(name="timestampColumnName")
    def timestamp_column_name(self) -> Optional[pulumi.Input[str]]:
        """
        Column to add with timestamp information to the endpoint data for an Amazon S3 target.
        """
        return pulumi.get(self, "timestamp_column_name")

    @timestamp_column_name.setter
    def timestamp_column_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timestamp_column_name", value)

    @property
    @pulumi.getter(name="useCsvNoSupValue")
    def use_csv_no_sup_value(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to use `csv_no_sup_value` for columns not included in the supplemental log. (Ignored for source endpoints.)
        """
        return pulumi.get(self, "use_csv_no_sup_value")

    @use_csv_no_sup_value.setter
    def use_csv_no_sup_value(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_csv_no_sup_value", value)

    @property
    @pulumi.getter(name="useTaskStartTimeForFullLoadTimestamp")
    def use_task_start_time_for_full_load_timestamp(self) -> Optional[pulumi.Input[bool]]:
        """
        When set to `true`, uses the task start time as the timestamp column value instead of the time data is written to target. For full load, when set to `true`, each row of the timestamp column contains the task start time. For CDC loads, each row of the timestamp column contains the transaction commit time.When set to false, the full load timestamp in the timestamp column increments with the time data arrives at the target. Default is `false`.
        """
        return pulumi.get(self, "use_task_start_time_for_full_load_timestamp")

    @use_task_start_time_for_full_load_timestamp.setter
    def use_task_start_time_for_full_load_timestamp(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_task_start_time_for_full_load_timestamp", value)


class S3Endpoint(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 add_column_name: Optional[pulumi.Input[bool]] = None,
                 add_trailing_padding_character: Optional[pulumi.Input[bool]] = None,
                 bucket_folder: Optional[pulumi.Input[str]] = None,
                 bucket_name: Optional[pulumi.Input[str]] = None,
                 canned_acl_for_objects: Optional[pulumi.Input[str]] = None,
                 cdc_inserts_and_updates: Optional[pulumi.Input[bool]] = None,
                 cdc_inserts_only: Optional[pulumi.Input[bool]] = None,
                 cdc_max_batch_interval: Optional[pulumi.Input[int]] = None,
                 cdc_min_file_size: Optional[pulumi.Input[int]] = None,
                 cdc_path: Optional[pulumi.Input[str]] = None,
                 certificate_arn: Optional[pulumi.Input[str]] = None,
                 compression_type: Optional[pulumi.Input[str]] = None,
                 csv_delimiter: Optional[pulumi.Input[str]] = None,
                 csv_no_sup_value: Optional[pulumi.Input[str]] = None,
                 csv_null_value: Optional[pulumi.Input[str]] = None,
                 csv_row_delimiter: Optional[pulumi.Input[str]] = None,
                 data_format: Optional[pulumi.Input[str]] = None,
                 data_page_size: Optional[pulumi.Input[int]] = None,
                 date_partition_delimiter: Optional[pulumi.Input[str]] = None,
                 date_partition_enabled: Optional[pulumi.Input[bool]] = None,
                 date_partition_sequence: Optional[pulumi.Input[str]] = None,
                 date_partition_timezone: Optional[pulumi.Input[str]] = None,
                 detach_target_on_lob_lookup_failure_parquet: Optional[pulumi.Input[bool]] = None,
                 dict_page_size_limit: Optional[pulumi.Input[int]] = None,
                 enable_statistics: Optional[pulumi.Input[bool]] = None,
                 encoding_type: Optional[pulumi.Input[str]] = None,
                 encryption_mode: Optional[pulumi.Input[str]] = None,
                 endpoint_id: Optional[pulumi.Input[str]] = None,
                 endpoint_type: Optional[pulumi.Input[str]] = None,
                 expected_bucket_owner: Optional[pulumi.Input[str]] = None,
                 external_table_definition: Optional[pulumi.Input[str]] = None,
                 ignore_header_rows: Optional[pulumi.Input[int]] = None,
                 include_op_for_full_load: Optional[pulumi.Input[bool]] = None,
                 kms_key_arn: Optional[pulumi.Input[str]] = None,
                 max_file_size: Optional[pulumi.Input[int]] = None,
                 parquet_timestamp_in_millisecond: Optional[pulumi.Input[bool]] = None,
                 parquet_version: Optional[pulumi.Input[str]] = None,
                 preserve_transactions: Optional[pulumi.Input[bool]] = None,
                 rfc4180: Optional[pulumi.Input[bool]] = None,
                 row_group_length: Optional[pulumi.Input[int]] = None,
                 server_side_encryption_kms_key_id: Optional[pulumi.Input[str]] = None,
                 service_access_role_arn: Optional[pulumi.Input[str]] = None,
                 ssl_mode: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 timestamp_column_name: Optional[pulumi.Input[str]] = None,
                 use_csv_no_sup_value: Optional[pulumi.Input[bool]] = None,
                 use_task_start_time_for_full_load_timestamp: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        Provides a DMS (Data Migration Service) S3 endpoint resource. DMS S3 endpoints can be created, updated, deleted, and imported.

        > **Note:** AWS is deprecating `extra_connection_attributes`, such as used with `dms.Endpoint`. This resource is an alternative to `dms.Endpoint` and does not use `extra_connection_attributes`. (AWS currently includes `extra_connection_attributes` in the raw responses to the AWS Provider requests and so they may be visible in the logs.)

        > **Note:** Some of this resource's arguments have default values that come from the AWS Provider. Other default values are provided by AWS and subject to change without notice. When relying on AWS defaults, the provider state will often have a zero value. For example, the AWS Provider does not provide a default for `cdc_max_batch_interval` but the AWS default is `60` (seconds). However, the provider state will show `0` since this is the value return by AWS when no value is present. Below, we aim to flag the defaults that come from AWS (_e.g._, "AWS default...").

        ## Example Usage
        ### Minimal Configuration

        This is the minimal configuration for an `dms.S3Endpoint`. This endpoint will rely on the AWS Provider and AWS defaults.

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.dms.S3Endpoint("example",
            endpoint_id="donnedtipi",
            endpoint_type="target",
            bucket_name="beckut_name",
            service_access_role_arn=aws_iam_role["example"]["arn"],
            opts=pulumi.ResourceOptions(depends_on=[aws_iam_role_policy["example"]]))
        ```
        ### Complete Configuration

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.dms.S3Endpoint("example",
            endpoint_id="donnedtipi",
            endpoint_type="target",
            ssl_mode="none",
            tags={
                "Name": "donnedtipi",
                "Update": "to-update",
                "Remove": "to-remove",
            },
            add_column_name=True,
            add_trailing_padding_character=False,
            bucket_folder="folder",
            bucket_name="bucket_name",
            canned_acl_for_objects="private",
            cdc_inserts_and_updates=True,
            cdc_inserts_only=False,
            cdc_max_batch_interval=100,
            cdc_min_file_size=16,
            cdc_path="cdc/path",
            compression_type="GZIP",
            csv_delimiter=";",
            csv_no_sup_value="x",
            csv_null_value="?",
            csv_row_delimiter="\\\\r\\\\n",
            data_format="parquet",
            data_page_size=1100000,
            date_partition_delimiter="UNDERSCORE",
            date_partition_enabled=True,
            date_partition_sequence="yyyymmddhh",
            date_partition_timezone="Asia/Seoul",
            dict_page_size_limit=1000000,
            enable_statistics=False,
            encoding_type="plain",
            encryption_mode="SSE_S3",
            expected_bucket_owner=data["aws_caller_identity"]["current"]["account_id"],
            external_table_definition="etd",
            ignore_header_rows=1,
            include_op_for_full_load=True,
            max_file_size=1000000,
            parquet_timestamp_in_millisecond=True,
            parquet_version="parquet-2-0",
            preserve_transactions=False,
            rfc4180=False,
            row_group_length=11000,
            server_side_encryption_kms_key_id=aws_kms_key["example"]["arn"],
            service_access_role_arn=aws_iam_role["example"]["arn"],
            timestamp_column_name="tx_commit_time",
            use_csv_no_sup_value=False,
            use_task_start_time_for_full_load_timestamp=True,
            opts=pulumi.ResourceOptions(depends_on=[aws_iam_role_policy["example"]]))
        ```

        ## Import

        Using `pulumi import`, import endpoints using the `endpoint_id`. For example:

        ```sh
         $ pulumi import aws:dms/s3Endpoint:S3Endpoint example example-dms-endpoint-tf
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] add_column_name: Whether to add column name information to the .csv output file. Default is `false`.
        :param pulumi.Input[bool] add_trailing_padding_character: Whether to add padding. Default is `false`. (Ignored for source endpoints.)
        :param pulumi.Input[str] bucket_folder: S3 object prefix.
        :param pulumi.Input[str] bucket_name: S3 bucket name.
        :param pulumi.Input[str] canned_acl_for_objects: Predefined (canned) access control list for objects created in an S3 bucket. Valid values include `none`, `private`, `public-read`, `public-read-write`, `authenticated-read`, `aws-exec-read`, `bucket-owner-read`, and `bucket-owner-full-control`. Default is `none`.
        :param pulumi.Input[bool] cdc_inserts_and_updates: Whether to write insert and update operations to .csv or .parquet output files. Default is `false`.
        :param pulumi.Input[bool] cdc_inserts_only: Whether to write insert operations to .csv or .parquet output files. Default is `false`.
        :param pulumi.Input[int] cdc_max_batch_interval: Maximum length of the interval, defined in seconds, after which to output a file to Amazon S3. (AWS default is `60`.)
        :param pulumi.Input[int] cdc_min_file_size: Minimum file size condition as defined in kilobytes to output a file to Amazon S3. (AWS default is 32000 KB.)
        :param pulumi.Input[str] cdc_path: Folder path of CDC files. If `cdc_path` is set, AWS DMS reads CDC files from this path and replicates the data changes to the target endpoint. Supported in AWS DMS versions 3.4.2 and later.
        :param pulumi.Input[str] certificate_arn: ARN for the certificate.
        :param pulumi.Input[str] compression_type: Set to compress target files. Valid values are `GZIP` and `NONE`. Default is `NONE`. (Ignored for source endpoints.)
        :param pulumi.Input[str] csv_delimiter: Delimiter used to separate columns in the source files. Default is `,`.
        :param pulumi.Input[str] csv_no_sup_value: Only applies if output files for a CDC load are written in .csv format. If `use_csv_no_sup_value` is set to `true`, string to use for all columns not included in the supplemental log. If you do not specify a string value, DMS uses the null value for these columns regardless of `use_csv_no_sup_value`. (Ignored for source endpoints.)
        :param pulumi.Input[str] csv_null_value: String to as null when writing to the target. (AWS default is `NULL`.)
        :param pulumi.Input[str] csv_row_delimiter: Delimiter used to separate rows in the source files. Default is newline (_i.e._, `\\n`).
        :param pulumi.Input[str] data_format: Output format for the files that AWS DMS uses to create S3 objects. Valid values are `csv` and `parquet`.  (Ignored for source endpoints -- only `csv` is valid.)
        :param pulumi.Input[int] data_page_size: Size of one data page in bytes. (AWS default is 1 MiB, _i.e._, `1048576`.)
        :param pulumi.Input[str] date_partition_delimiter: Date separating delimiter to use during folder partitioning. Valid values are `SLASH`, `UNDERSCORE`, `DASH`, and `NONE`. (AWS default is `SLASH`.) (Ignored for source endpoints.)
        :param pulumi.Input[bool] date_partition_enabled: Partition S3 bucket folders based on transaction commit dates. Default is `false`. (Ignored for source endpoints.)
        :param pulumi.Input[str] date_partition_sequence: Date format to use during folder partitioning. Use this parameter when `date_partition_enabled` is set to true. Valid values are `YYYYMMDD`, `YYYYMMDDHH`, `YYYYMM`, `MMYYYYDD`, and `DDMMYYYY`. (AWS default is `YYYYMMDD`.) (Ignored for source endpoints.)
        :param pulumi.Input[str] date_partition_timezone: Convert the current UTC time to a timezone. The conversion occurs when a date partition folder is created and a CDC filename is generated. The timezone format is Area/Location (_e.g._, `Europe/Paris`). Use this when `date_partition_enabled` is `true`. (Ignored for source endpoints.)
        :param pulumi.Input[bool] detach_target_on_lob_lookup_failure_parquet: Undocumented argument for use as directed by AWS Support.
        :param pulumi.Input[int] dict_page_size_limit: Maximum size in bytes of an encoded dictionary page of a column. (AWS default is 1 MiB, _i.e._, `1048576`.)
        :param pulumi.Input[bool] enable_statistics: Whether to enable statistics for Parquet pages and row groups. Default is `true`.
        :param pulumi.Input[str] encoding_type: Type of encoding to use. Value values are `rle_dictionary`, `plain`, and `plain_dictionary`. (AWS default is `rle_dictionary`.)
        :param pulumi.Input[str] encryption_mode: Server-side encryption mode that you want to encrypt your .csv or .parquet object files copied to S3. Valid values are `SSE_S3` and `SSE_KMS`. (AWS default is `SSE_S3`.) (Ignored for source endpoints -- only `SSE_S3` is valid.)
        :param pulumi.Input[str] endpoint_id: Database endpoint identifier. Identifiers must contain from 1 to 255 alphanumeric characters or hyphens, begin with a letter, contain only ASCII letters, digits, and hyphens, not end with a hyphen, and not contain two consecutive hyphens.
        :param pulumi.Input[str] endpoint_type: Type of endpoint. Valid values are `source`, `target`.
        :param pulumi.Input[str] expected_bucket_owner: Bucket owner to prevent sniping. Value is an AWS account ID.
        :param pulumi.Input[str] external_table_definition: JSON document that describes how AWS DMS should interpret the data.
        :param pulumi.Input[int] ignore_header_rows: When this value is set to `1`, DMS ignores the first row header in a .csv file. (AWS default is `0`.)
        :param pulumi.Input[bool] include_op_for_full_load: Whether to enable a full load to write INSERT operations to the .csv output files only to indicate how the rows were added to the source database. Default is `false`.
        :param pulumi.Input[str] kms_key_arn: ARN for the KMS key that will be used to encrypt the connection parameters. If you do not specify a value for `kms_key_arn`, then AWS DMS will use your default encryption key. AWS KMS creates the default encryption key for your AWS account. Your AWS account has a different default encryption key for each AWS region.
        :param pulumi.Input[int] max_file_size: Maximum size (in KB) of any .csv file to be created while migrating to an S3 target during full load. Valid values are from `1` to `1048576`. (AWS default is 1 GB, _i.e._, `1048576`.)
        :param pulumi.Input[bool] parquet_timestamp_in_millisecond: Specifies the precision of any TIMESTAMP column values written to an S3 object file in .parquet format. Default is `false`. (Ignored for source endpoints.)
        :param pulumi.Input[str] parquet_version: Version of the .parquet file format. Valid values are `parquet-1-0` and `parquet-2-0`. (AWS default is `parquet-1-0`.) (Ignored for source endpoints.)
        :param pulumi.Input[bool] preserve_transactions: Whether DMS saves the transaction order for a CDC load on the S3 target specified by `cdc_path`. Default is `false`. (Ignored for source endpoints.)
        :param pulumi.Input[bool] rfc4180: For an S3 source, whether each leading double quotation mark has to be followed by an ending double quotation mark. Default is `true`.
        :param pulumi.Input[int] row_group_length: Number of rows in a row group. (AWS default is `10000`.)
        :param pulumi.Input[str] server_side_encryption_kms_key_id: When `encryption_mode` is `SSE_KMS`, ARN for the AWS KMS key. (Ignored for source endpoints -- only `SSE_S3` `encryption_mode` is valid.)
        :param pulumi.Input[str] service_access_role_arn: ARN of the IAM role with permissions to the S3 Bucket.
               
               The following arguments are optional:
        :param pulumi.Input[str] ssl_mode: SSL mode to use for the connection. Valid values are `none`, `require`, `verify-ca`, `verify-full`. (AWS default is `none`.)
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[str] timestamp_column_name: Column to add with timestamp information to the endpoint data for an Amazon S3 target.
        :param pulumi.Input[bool] use_csv_no_sup_value: Whether to use `csv_no_sup_value` for columns not included in the supplemental log. (Ignored for source endpoints.)
        :param pulumi.Input[bool] use_task_start_time_for_full_load_timestamp: When set to `true`, uses the task start time as the timestamp column value instead of the time data is written to target. For full load, when set to `true`, each row of the timestamp column contains the task start time. For CDC loads, each row of the timestamp column contains the transaction commit time.When set to false, the full load timestamp in the timestamp column increments with the time data arrives at the target. Default is `false`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: S3EndpointArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a DMS (Data Migration Service) S3 endpoint resource. DMS S3 endpoints can be created, updated, deleted, and imported.

        > **Note:** AWS is deprecating `extra_connection_attributes`, such as used with `dms.Endpoint`. This resource is an alternative to `dms.Endpoint` and does not use `extra_connection_attributes`. (AWS currently includes `extra_connection_attributes` in the raw responses to the AWS Provider requests and so they may be visible in the logs.)

        > **Note:** Some of this resource's arguments have default values that come from the AWS Provider. Other default values are provided by AWS and subject to change without notice. When relying on AWS defaults, the provider state will often have a zero value. For example, the AWS Provider does not provide a default for `cdc_max_batch_interval` but the AWS default is `60` (seconds). However, the provider state will show `0` since this is the value return by AWS when no value is present. Below, we aim to flag the defaults that come from AWS (_e.g._, "AWS default...").

        ## Example Usage
        ### Minimal Configuration

        This is the minimal configuration for an `dms.S3Endpoint`. This endpoint will rely on the AWS Provider and AWS defaults.

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.dms.S3Endpoint("example",
            endpoint_id="donnedtipi",
            endpoint_type="target",
            bucket_name="beckut_name",
            service_access_role_arn=aws_iam_role["example"]["arn"],
            opts=pulumi.ResourceOptions(depends_on=[aws_iam_role_policy["example"]]))
        ```
        ### Complete Configuration

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.dms.S3Endpoint("example",
            endpoint_id="donnedtipi",
            endpoint_type="target",
            ssl_mode="none",
            tags={
                "Name": "donnedtipi",
                "Update": "to-update",
                "Remove": "to-remove",
            },
            add_column_name=True,
            add_trailing_padding_character=False,
            bucket_folder="folder",
            bucket_name="bucket_name",
            canned_acl_for_objects="private",
            cdc_inserts_and_updates=True,
            cdc_inserts_only=False,
            cdc_max_batch_interval=100,
            cdc_min_file_size=16,
            cdc_path="cdc/path",
            compression_type="GZIP",
            csv_delimiter=";",
            csv_no_sup_value="x",
            csv_null_value="?",
            csv_row_delimiter="\\\\r\\\\n",
            data_format="parquet",
            data_page_size=1100000,
            date_partition_delimiter="UNDERSCORE",
            date_partition_enabled=True,
            date_partition_sequence="yyyymmddhh",
            date_partition_timezone="Asia/Seoul",
            dict_page_size_limit=1000000,
            enable_statistics=False,
            encoding_type="plain",
            encryption_mode="SSE_S3",
            expected_bucket_owner=data["aws_caller_identity"]["current"]["account_id"],
            external_table_definition="etd",
            ignore_header_rows=1,
            include_op_for_full_load=True,
            max_file_size=1000000,
            parquet_timestamp_in_millisecond=True,
            parquet_version="parquet-2-0",
            preserve_transactions=False,
            rfc4180=False,
            row_group_length=11000,
            server_side_encryption_kms_key_id=aws_kms_key["example"]["arn"],
            service_access_role_arn=aws_iam_role["example"]["arn"],
            timestamp_column_name="tx_commit_time",
            use_csv_no_sup_value=False,
            use_task_start_time_for_full_load_timestamp=True,
            opts=pulumi.ResourceOptions(depends_on=[aws_iam_role_policy["example"]]))
        ```

        ## Import

        Using `pulumi import`, import endpoints using the `endpoint_id`. For example:

        ```sh
         $ pulumi import aws:dms/s3Endpoint:S3Endpoint example example-dms-endpoint-tf
        ```

        :param str resource_name: The name of the resource.
        :param S3EndpointArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(S3EndpointArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 add_column_name: Optional[pulumi.Input[bool]] = None,
                 add_trailing_padding_character: Optional[pulumi.Input[bool]] = None,
                 bucket_folder: Optional[pulumi.Input[str]] = None,
                 bucket_name: Optional[pulumi.Input[str]] = None,
                 canned_acl_for_objects: Optional[pulumi.Input[str]] = None,
                 cdc_inserts_and_updates: Optional[pulumi.Input[bool]] = None,
                 cdc_inserts_only: Optional[pulumi.Input[bool]] = None,
                 cdc_max_batch_interval: Optional[pulumi.Input[int]] = None,
                 cdc_min_file_size: Optional[pulumi.Input[int]] = None,
                 cdc_path: Optional[pulumi.Input[str]] = None,
                 certificate_arn: Optional[pulumi.Input[str]] = None,
                 compression_type: Optional[pulumi.Input[str]] = None,
                 csv_delimiter: Optional[pulumi.Input[str]] = None,
                 csv_no_sup_value: Optional[pulumi.Input[str]] = None,
                 csv_null_value: Optional[pulumi.Input[str]] = None,
                 csv_row_delimiter: Optional[pulumi.Input[str]] = None,
                 data_format: Optional[pulumi.Input[str]] = None,
                 data_page_size: Optional[pulumi.Input[int]] = None,
                 date_partition_delimiter: Optional[pulumi.Input[str]] = None,
                 date_partition_enabled: Optional[pulumi.Input[bool]] = None,
                 date_partition_sequence: Optional[pulumi.Input[str]] = None,
                 date_partition_timezone: Optional[pulumi.Input[str]] = None,
                 detach_target_on_lob_lookup_failure_parquet: Optional[pulumi.Input[bool]] = None,
                 dict_page_size_limit: Optional[pulumi.Input[int]] = None,
                 enable_statistics: Optional[pulumi.Input[bool]] = None,
                 encoding_type: Optional[pulumi.Input[str]] = None,
                 encryption_mode: Optional[pulumi.Input[str]] = None,
                 endpoint_id: Optional[pulumi.Input[str]] = None,
                 endpoint_type: Optional[pulumi.Input[str]] = None,
                 expected_bucket_owner: Optional[pulumi.Input[str]] = None,
                 external_table_definition: Optional[pulumi.Input[str]] = None,
                 ignore_header_rows: Optional[pulumi.Input[int]] = None,
                 include_op_for_full_load: Optional[pulumi.Input[bool]] = None,
                 kms_key_arn: Optional[pulumi.Input[str]] = None,
                 max_file_size: Optional[pulumi.Input[int]] = None,
                 parquet_timestamp_in_millisecond: Optional[pulumi.Input[bool]] = None,
                 parquet_version: Optional[pulumi.Input[str]] = None,
                 preserve_transactions: Optional[pulumi.Input[bool]] = None,
                 rfc4180: Optional[pulumi.Input[bool]] = None,
                 row_group_length: Optional[pulumi.Input[int]] = None,
                 server_side_encryption_kms_key_id: Optional[pulumi.Input[str]] = None,
                 service_access_role_arn: Optional[pulumi.Input[str]] = None,
                 ssl_mode: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 timestamp_column_name: Optional[pulumi.Input[str]] = None,
                 use_csv_no_sup_value: Optional[pulumi.Input[bool]] = None,
                 use_task_start_time_for_full_load_timestamp: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = S3EndpointArgs.__new__(S3EndpointArgs)

            __props__.__dict__["add_column_name"] = add_column_name
            __props__.__dict__["add_trailing_padding_character"] = add_trailing_padding_character
            __props__.__dict__["bucket_folder"] = bucket_folder
            if bucket_name is None and not opts.urn:
                raise TypeError("Missing required property 'bucket_name'")
            __props__.__dict__["bucket_name"] = bucket_name
            __props__.__dict__["canned_acl_for_objects"] = canned_acl_for_objects
            __props__.__dict__["cdc_inserts_and_updates"] = cdc_inserts_and_updates
            __props__.__dict__["cdc_inserts_only"] = cdc_inserts_only
            __props__.__dict__["cdc_max_batch_interval"] = cdc_max_batch_interval
            __props__.__dict__["cdc_min_file_size"] = cdc_min_file_size
            __props__.__dict__["cdc_path"] = cdc_path
            __props__.__dict__["certificate_arn"] = certificate_arn
            __props__.__dict__["compression_type"] = compression_type
            __props__.__dict__["csv_delimiter"] = csv_delimiter
            __props__.__dict__["csv_no_sup_value"] = csv_no_sup_value
            __props__.__dict__["csv_null_value"] = csv_null_value
            __props__.__dict__["csv_row_delimiter"] = csv_row_delimiter
            __props__.__dict__["data_format"] = data_format
            __props__.__dict__["data_page_size"] = data_page_size
            __props__.__dict__["date_partition_delimiter"] = date_partition_delimiter
            __props__.__dict__["date_partition_enabled"] = date_partition_enabled
            __props__.__dict__["date_partition_sequence"] = date_partition_sequence
            __props__.__dict__["date_partition_timezone"] = date_partition_timezone
            __props__.__dict__["detach_target_on_lob_lookup_failure_parquet"] = detach_target_on_lob_lookup_failure_parquet
            __props__.__dict__["dict_page_size_limit"] = dict_page_size_limit
            __props__.__dict__["enable_statistics"] = enable_statistics
            __props__.__dict__["encoding_type"] = encoding_type
            __props__.__dict__["encryption_mode"] = encryption_mode
            if endpoint_id is None and not opts.urn:
                raise TypeError("Missing required property 'endpoint_id'")
            __props__.__dict__["endpoint_id"] = endpoint_id
            if endpoint_type is None and not opts.urn:
                raise TypeError("Missing required property 'endpoint_type'")
            __props__.__dict__["endpoint_type"] = endpoint_type
            __props__.__dict__["expected_bucket_owner"] = expected_bucket_owner
            __props__.__dict__["external_table_definition"] = external_table_definition
            __props__.__dict__["ignore_header_rows"] = ignore_header_rows
            __props__.__dict__["include_op_for_full_load"] = include_op_for_full_load
            __props__.__dict__["kms_key_arn"] = kms_key_arn
            __props__.__dict__["max_file_size"] = max_file_size
            __props__.__dict__["parquet_timestamp_in_millisecond"] = parquet_timestamp_in_millisecond
            __props__.__dict__["parquet_version"] = parquet_version
            __props__.__dict__["preserve_transactions"] = preserve_transactions
            __props__.__dict__["rfc4180"] = rfc4180
            __props__.__dict__["row_group_length"] = row_group_length
            __props__.__dict__["server_side_encryption_kms_key_id"] = server_side_encryption_kms_key_id
            if service_access_role_arn is None and not opts.urn:
                raise TypeError("Missing required property 'service_access_role_arn'")
            __props__.__dict__["service_access_role_arn"] = service_access_role_arn
            __props__.__dict__["ssl_mode"] = ssl_mode
            __props__.__dict__["tags"] = tags
            __props__.__dict__["timestamp_column_name"] = timestamp_column_name
            __props__.__dict__["use_csv_no_sup_value"] = use_csv_no_sup_value
            __props__.__dict__["use_task_start_time_for_full_load_timestamp"] = use_task_start_time_for_full_load_timestamp
            __props__.__dict__["endpoint_arn"] = None
            __props__.__dict__["engine_display_name"] = None
            __props__.__dict__["external_id"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["tags_all"] = None
        super(S3Endpoint, __self__).__init__(
            'aws:dms/s3Endpoint:S3Endpoint',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            add_column_name: Optional[pulumi.Input[bool]] = None,
            add_trailing_padding_character: Optional[pulumi.Input[bool]] = None,
            bucket_folder: Optional[pulumi.Input[str]] = None,
            bucket_name: Optional[pulumi.Input[str]] = None,
            canned_acl_for_objects: Optional[pulumi.Input[str]] = None,
            cdc_inserts_and_updates: Optional[pulumi.Input[bool]] = None,
            cdc_inserts_only: Optional[pulumi.Input[bool]] = None,
            cdc_max_batch_interval: Optional[pulumi.Input[int]] = None,
            cdc_min_file_size: Optional[pulumi.Input[int]] = None,
            cdc_path: Optional[pulumi.Input[str]] = None,
            certificate_arn: Optional[pulumi.Input[str]] = None,
            compression_type: Optional[pulumi.Input[str]] = None,
            csv_delimiter: Optional[pulumi.Input[str]] = None,
            csv_no_sup_value: Optional[pulumi.Input[str]] = None,
            csv_null_value: Optional[pulumi.Input[str]] = None,
            csv_row_delimiter: Optional[pulumi.Input[str]] = None,
            data_format: Optional[pulumi.Input[str]] = None,
            data_page_size: Optional[pulumi.Input[int]] = None,
            date_partition_delimiter: Optional[pulumi.Input[str]] = None,
            date_partition_enabled: Optional[pulumi.Input[bool]] = None,
            date_partition_sequence: Optional[pulumi.Input[str]] = None,
            date_partition_timezone: Optional[pulumi.Input[str]] = None,
            detach_target_on_lob_lookup_failure_parquet: Optional[pulumi.Input[bool]] = None,
            dict_page_size_limit: Optional[pulumi.Input[int]] = None,
            enable_statistics: Optional[pulumi.Input[bool]] = None,
            encoding_type: Optional[pulumi.Input[str]] = None,
            encryption_mode: Optional[pulumi.Input[str]] = None,
            endpoint_arn: Optional[pulumi.Input[str]] = None,
            endpoint_id: Optional[pulumi.Input[str]] = None,
            endpoint_type: Optional[pulumi.Input[str]] = None,
            engine_display_name: Optional[pulumi.Input[str]] = None,
            expected_bucket_owner: Optional[pulumi.Input[str]] = None,
            external_id: Optional[pulumi.Input[str]] = None,
            external_table_definition: Optional[pulumi.Input[str]] = None,
            ignore_header_rows: Optional[pulumi.Input[int]] = None,
            include_op_for_full_load: Optional[pulumi.Input[bool]] = None,
            kms_key_arn: Optional[pulumi.Input[str]] = None,
            max_file_size: Optional[pulumi.Input[int]] = None,
            parquet_timestamp_in_millisecond: Optional[pulumi.Input[bool]] = None,
            parquet_version: Optional[pulumi.Input[str]] = None,
            preserve_transactions: Optional[pulumi.Input[bool]] = None,
            rfc4180: Optional[pulumi.Input[bool]] = None,
            row_group_length: Optional[pulumi.Input[int]] = None,
            server_side_encryption_kms_key_id: Optional[pulumi.Input[str]] = None,
            service_access_role_arn: Optional[pulumi.Input[str]] = None,
            ssl_mode: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            timestamp_column_name: Optional[pulumi.Input[str]] = None,
            use_csv_no_sup_value: Optional[pulumi.Input[bool]] = None,
            use_task_start_time_for_full_load_timestamp: Optional[pulumi.Input[bool]] = None) -> 'S3Endpoint':
        """
        Get an existing S3Endpoint resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] add_column_name: Whether to add column name information to the .csv output file. Default is `false`.
        :param pulumi.Input[bool] add_trailing_padding_character: Whether to add padding. Default is `false`. (Ignored for source endpoints.)
        :param pulumi.Input[str] bucket_folder: S3 object prefix.
        :param pulumi.Input[str] bucket_name: S3 bucket name.
        :param pulumi.Input[str] canned_acl_for_objects: Predefined (canned) access control list for objects created in an S3 bucket. Valid values include `none`, `private`, `public-read`, `public-read-write`, `authenticated-read`, `aws-exec-read`, `bucket-owner-read`, and `bucket-owner-full-control`. Default is `none`.
        :param pulumi.Input[bool] cdc_inserts_and_updates: Whether to write insert and update operations to .csv or .parquet output files. Default is `false`.
        :param pulumi.Input[bool] cdc_inserts_only: Whether to write insert operations to .csv or .parquet output files. Default is `false`.
        :param pulumi.Input[int] cdc_max_batch_interval: Maximum length of the interval, defined in seconds, after which to output a file to Amazon S3. (AWS default is `60`.)
        :param pulumi.Input[int] cdc_min_file_size: Minimum file size condition as defined in kilobytes to output a file to Amazon S3. (AWS default is 32000 KB.)
        :param pulumi.Input[str] cdc_path: Folder path of CDC files. If `cdc_path` is set, AWS DMS reads CDC files from this path and replicates the data changes to the target endpoint. Supported in AWS DMS versions 3.4.2 and later.
        :param pulumi.Input[str] certificate_arn: ARN for the certificate.
        :param pulumi.Input[str] compression_type: Set to compress target files. Valid values are `GZIP` and `NONE`. Default is `NONE`. (Ignored for source endpoints.)
        :param pulumi.Input[str] csv_delimiter: Delimiter used to separate columns in the source files. Default is `,`.
        :param pulumi.Input[str] csv_no_sup_value: Only applies if output files for a CDC load are written in .csv format. If `use_csv_no_sup_value` is set to `true`, string to use for all columns not included in the supplemental log. If you do not specify a string value, DMS uses the null value for these columns regardless of `use_csv_no_sup_value`. (Ignored for source endpoints.)
        :param pulumi.Input[str] csv_null_value: String to as null when writing to the target. (AWS default is `NULL`.)
        :param pulumi.Input[str] csv_row_delimiter: Delimiter used to separate rows in the source files. Default is newline (_i.e._, `\\n`).
        :param pulumi.Input[str] data_format: Output format for the files that AWS DMS uses to create S3 objects. Valid values are `csv` and `parquet`.  (Ignored for source endpoints -- only `csv` is valid.)
        :param pulumi.Input[int] data_page_size: Size of one data page in bytes. (AWS default is 1 MiB, _i.e._, `1048576`.)
        :param pulumi.Input[str] date_partition_delimiter: Date separating delimiter to use during folder partitioning. Valid values are `SLASH`, `UNDERSCORE`, `DASH`, and `NONE`. (AWS default is `SLASH`.) (Ignored for source endpoints.)
        :param pulumi.Input[bool] date_partition_enabled: Partition S3 bucket folders based on transaction commit dates. Default is `false`. (Ignored for source endpoints.)
        :param pulumi.Input[str] date_partition_sequence: Date format to use during folder partitioning. Use this parameter when `date_partition_enabled` is set to true. Valid values are `YYYYMMDD`, `YYYYMMDDHH`, `YYYYMM`, `MMYYYYDD`, and `DDMMYYYY`. (AWS default is `YYYYMMDD`.) (Ignored for source endpoints.)
        :param pulumi.Input[str] date_partition_timezone: Convert the current UTC time to a timezone. The conversion occurs when a date partition folder is created and a CDC filename is generated. The timezone format is Area/Location (_e.g._, `Europe/Paris`). Use this when `date_partition_enabled` is `true`. (Ignored for source endpoints.)
        :param pulumi.Input[bool] detach_target_on_lob_lookup_failure_parquet: Undocumented argument for use as directed by AWS Support.
        :param pulumi.Input[int] dict_page_size_limit: Maximum size in bytes of an encoded dictionary page of a column. (AWS default is 1 MiB, _i.e._, `1048576`.)
        :param pulumi.Input[bool] enable_statistics: Whether to enable statistics for Parquet pages and row groups. Default is `true`.
        :param pulumi.Input[str] encoding_type: Type of encoding to use. Value values are `rle_dictionary`, `plain`, and `plain_dictionary`. (AWS default is `rle_dictionary`.)
        :param pulumi.Input[str] encryption_mode: Server-side encryption mode that you want to encrypt your .csv or .parquet object files copied to S3. Valid values are `SSE_S3` and `SSE_KMS`. (AWS default is `SSE_S3`.) (Ignored for source endpoints -- only `SSE_S3` is valid.)
        :param pulumi.Input[str] endpoint_arn: ARN for the endpoint.
        :param pulumi.Input[str] endpoint_id: Database endpoint identifier. Identifiers must contain from 1 to 255 alphanumeric characters or hyphens, begin with a letter, contain only ASCII letters, digits, and hyphens, not end with a hyphen, and not contain two consecutive hyphens.
        :param pulumi.Input[str] endpoint_type: Type of endpoint. Valid values are `source`, `target`.
        :param pulumi.Input[str] engine_display_name: Expanded name for the engine name.
        :param pulumi.Input[str] expected_bucket_owner: Bucket owner to prevent sniping. Value is an AWS account ID.
        :param pulumi.Input[str] external_id: Can be used for cross-account validation. Use it in another account with `dms.S3Endpoint` to create the endpoint cross-account.
        :param pulumi.Input[str] external_table_definition: JSON document that describes how AWS DMS should interpret the data.
        :param pulumi.Input[int] ignore_header_rows: When this value is set to `1`, DMS ignores the first row header in a .csv file. (AWS default is `0`.)
        :param pulumi.Input[bool] include_op_for_full_load: Whether to enable a full load to write INSERT operations to the .csv output files only to indicate how the rows were added to the source database. Default is `false`.
        :param pulumi.Input[str] kms_key_arn: ARN for the KMS key that will be used to encrypt the connection parameters. If you do not specify a value for `kms_key_arn`, then AWS DMS will use your default encryption key. AWS KMS creates the default encryption key for your AWS account. Your AWS account has a different default encryption key for each AWS region.
        :param pulumi.Input[int] max_file_size: Maximum size (in KB) of any .csv file to be created while migrating to an S3 target during full load. Valid values are from `1` to `1048576`. (AWS default is 1 GB, _i.e._, `1048576`.)
        :param pulumi.Input[bool] parquet_timestamp_in_millisecond: Specifies the precision of any TIMESTAMP column values written to an S3 object file in .parquet format. Default is `false`. (Ignored for source endpoints.)
        :param pulumi.Input[str] parquet_version: Version of the .parquet file format. Valid values are `parquet-1-0` and `parquet-2-0`. (AWS default is `parquet-1-0`.) (Ignored for source endpoints.)
        :param pulumi.Input[bool] preserve_transactions: Whether DMS saves the transaction order for a CDC load on the S3 target specified by `cdc_path`. Default is `false`. (Ignored for source endpoints.)
        :param pulumi.Input[bool] rfc4180: For an S3 source, whether each leading double quotation mark has to be followed by an ending double quotation mark. Default is `true`.
        :param pulumi.Input[int] row_group_length: Number of rows in a row group. (AWS default is `10000`.)
        :param pulumi.Input[str] server_side_encryption_kms_key_id: When `encryption_mode` is `SSE_KMS`, ARN for the AWS KMS key. (Ignored for source endpoints -- only `SSE_S3` `encryption_mode` is valid.)
        :param pulumi.Input[str] service_access_role_arn: ARN of the IAM role with permissions to the S3 Bucket.
               
               The following arguments are optional:
        :param pulumi.Input[str] ssl_mode: SSL mode to use for the connection. Valid values are `none`, `require`, `verify-ca`, `verify-full`. (AWS default is `none`.)
        :param pulumi.Input[str] status: Status of the endpoint.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[str] timestamp_column_name: Column to add with timestamp information to the endpoint data for an Amazon S3 target.
        :param pulumi.Input[bool] use_csv_no_sup_value: Whether to use `csv_no_sup_value` for columns not included in the supplemental log. (Ignored for source endpoints.)
        :param pulumi.Input[bool] use_task_start_time_for_full_load_timestamp: When set to `true`, uses the task start time as the timestamp column value instead of the time data is written to target. For full load, when set to `true`, each row of the timestamp column contains the task start time. For CDC loads, each row of the timestamp column contains the transaction commit time.When set to false, the full load timestamp in the timestamp column increments with the time data arrives at the target. Default is `false`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _S3EndpointState.__new__(_S3EndpointState)

        __props__.__dict__["add_column_name"] = add_column_name
        __props__.__dict__["add_trailing_padding_character"] = add_trailing_padding_character
        __props__.__dict__["bucket_folder"] = bucket_folder
        __props__.__dict__["bucket_name"] = bucket_name
        __props__.__dict__["canned_acl_for_objects"] = canned_acl_for_objects
        __props__.__dict__["cdc_inserts_and_updates"] = cdc_inserts_and_updates
        __props__.__dict__["cdc_inserts_only"] = cdc_inserts_only
        __props__.__dict__["cdc_max_batch_interval"] = cdc_max_batch_interval
        __props__.__dict__["cdc_min_file_size"] = cdc_min_file_size
        __props__.__dict__["cdc_path"] = cdc_path
        __props__.__dict__["certificate_arn"] = certificate_arn
        __props__.__dict__["compression_type"] = compression_type
        __props__.__dict__["csv_delimiter"] = csv_delimiter
        __props__.__dict__["csv_no_sup_value"] = csv_no_sup_value
        __props__.__dict__["csv_null_value"] = csv_null_value
        __props__.__dict__["csv_row_delimiter"] = csv_row_delimiter
        __props__.__dict__["data_format"] = data_format
        __props__.__dict__["data_page_size"] = data_page_size
        __props__.__dict__["date_partition_delimiter"] = date_partition_delimiter
        __props__.__dict__["date_partition_enabled"] = date_partition_enabled
        __props__.__dict__["date_partition_sequence"] = date_partition_sequence
        __props__.__dict__["date_partition_timezone"] = date_partition_timezone
        __props__.__dict__["detach_target_on_lob_lookup_failure_parquet"] = detach_target_on_lob_lookup_failure_parquet
        __props__.__dict__["dict_page_size_limit"] = dict_page_size_limit
        __props__.__dict__["enable_statistics"] = enable_statistics
        __props__.__dict__["encoding_type"] = encoding_type
        __props__.__dict__["encryption_mode"] = encryption_mode
        __props__.__dict__["endpoint_arn"] = endpoint_arn
        __props__.__dict__["endpoint_id"] = endpoint_id
        __props__.__dict__["endpoint_type"] = endpoint_type
        __props__.__dict__["engine_display_name"] = engine_display_name
        __props__.__dict__["expected_bucket_owner"] = expected_bucket_owner
        __props__.__dict__["external_id"] = external_id
        __props__.__dict__["external_table_definition"] = external_table_definition
        __props__.__dict__["ignore_header_rows"] = ignore_header_rows
        __props__.__dict__["include_op_for_full_load"] = include_op_for_full_load
        __props__.__dict__["kms_key_arn"] = kms_key_arn
        __props__.__dict__["max_file_size"] = max_file_size
        __props__.__dict__["parquet_timestamp_in_millisecond"] = parquet_timestamp_in_millisecond
        __props__.__dict__["parquet_version"] = parquet_version
        __props__.__dict__["preserve_transactions"] = preserve_transactions
        __props__.__dict__["rfc4180"] = rfc4180
        __props__.__dict__["row_group_length"] = row_group_length
        __props__.__dict__["server_side_encryption_kms_key_id"] = server_side_encryption_kms_key_id
        __props__.__dict__["service_access_role_arn"] = service_access_role_arn
        __props__.__dict__["ssl_mode"] = ssl_mode
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["timestamp_column_name"] = timestamp_column_name
        __props__.__dict__["use_csv_no_sup_value"] = use_csv_no_sup_value
        __props__.__dict__["use_task_start_time_for_full_load_timestamp"] = use_task_start_time_for_full_load_timestamp
        return S3Endpoint(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="addColumnName")
    def add_column_name(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to add column name information to the .csv output file. Default is `false`.
        """
        return pulumi.get(self, "add_column_name")

    @property
    @pulumi.getter(name="addTrailingPaddingCharacter")
    def add_trailing_padding_character(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to add padding. Default is `false`. (Ignored for source endpoints.)
        """
        return pulumi.get(self, "add_trailing_padding_character")

    @property
    @pulumi.getter(name="bucketFolder")
    def bucket_folder(self) -> pulumi.Output[Optional[str]]:
        """
        S3 object prefix.
        """
        return pulumi.get(self, "bucket_folder")

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> pulumi.Output[str]:
        """
        S3 bucket name.
        """
        return pulumi.get(self, "bucket_name")

    @property
    @pulumi.getter(name="cannedAclForObjects")
    def canned_acl_for_objects(self) -> pulumi.Output[Optional[str]]:
        """
        Predefined (canned) access control list for objects created in an S3 bucket. Valid values include `none`, `private`, `public-read`, `public-read-write`, `authenticated-read`, `aws-exec-read`, `bucket-owner-read`, and `bucket-owner-full-control`. Default is `none`.
        """
        return pulumi.get(self, "canned_acl_for_objects")

    @property
    @pulumi.getter(name="cdcInsertsAndUpdates")
    def cdc_inserts_and_updates(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to write insert and update operations to .csv or .parquet output files. Default is `false`.
        """
        return pulumi.get(self, "cdc_inserts_and_updates")

    @property
    @pulumi.getter(name="cdcInsertsOnly")
    def cdc_inserts_only(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to write insert operations to .csv or .parquet output files. Default is `false`.
        """
        return pulumi.get(self, "cdc_inserts_only")

    @property
    @pulumi.getter(name="cdcMaxBatchInterval")
    def cdc_max_batch_interval(self) -> pulumi.Output[Optional[int]]:
        """
        Maximum length of the interval, defined in seconds, after which to output a file to Amazon S3. (AWS default is `60`.)
        """
        return pulumi.get(self, "cdc_max_batch_interval")

    @property
    @pulumi.getter(name="cdcMinFileSize")
    def cdc_min_file_size(self) -> pulumi.Output[Optional[int]]:
        """
        Minimum file size condition as defined in kilobytes to output a file to Amazon S3. (AWS default is 32000 KB.)
        """
        return pulumi.get(self, "cdc_min_file_size")

    @property
    @pulumi.getter(name="cdcPath")
    def cdc_path(self) -> pulumi.Output[Optional[str]]:
        """
        Folder path of CDC files. If `cdc_path` is set, AWS DMS reads CDC files from this path and replicates the data changes to the target endpoint. Supported in AWS DMS versions 3.4.2 and later.
        """
        return pulumi.get(self, "cdc_path")

    @property
    @pulumi.getter(name="certificateArn")
    def certificate_arn(self) -> pulumi.Output[str]:
        """
        ARN for the certificate.
        """
        return pulumi.get(self, "certificate_arn")

    @property
    @pulumi.getter(name="compressionType")
    def compression_type(self) -> pulumi.Output[Optional[str]]:
        """
        Set to compress target files. Valid values are `GZIP` and `NONE`. Default is `NONE`. (Ignored for source endpoints.)
        """
        return pulumi.get(self, "compression_type")

    @property
    @pulumi.getter(name="csvDelimiter")
    def csv_delimiter(self) -> pulumi.Output[Optional[str]]:
        """
        Delimiter used to separate columns in the source files. Default is `,`.
        """
        return pulumi.get(self, "csv_delimiter")

    @property
    @pulumi.getter(name="csvNoSupValue")
    def csv_no_sup_value(self) -> pulumi.Output[Optional[str]]:
        """
        Only applies if output files for a CDC load are written in .csv format. If `use_csv_no_sup_value` is set to `true`, string to use for all columns not included in the supplemental log. If you do not specify a string value, DMS uses the null value for these columns regardless of `use_csv_no_sup_value`. (Ignored for source endpoints.)
        """
        return pulumi.get(self, "csv_no_sup_value")

    @property
    @pulumi.getter(name="csvNullValue")
    def csv_null_value(self) -> pulumi.Output[Optional[str]]:
        """
        String to as null when writing to the target. (AWS default is `NULL`.)
        """
        return pulumi.get(self, "csv_null_value")

    @property
    @pulumi.getter(name="csvRowDelimiter")
    def csv_row_delimiter(self) -> pulumi.Output[Optional[str]]:
        """
        Delimiter used to separate rows in the source files. Default is newline (_i.e._, `\\n`).
        """
        return pulumi.get(self, "csv_row_delimiter")

    @property
    @pulumi.getter(name="dataFormat")
    def data_format(self) -> pulumi.Output[Optional[str]]:
        """
        Output format for the files that AWS DMS uses to create S3 objects. Valid values are `csv` and `parquet`.  (Ignored for source endpoints -- only `csv` is valid.)
        """
        return pulumi.get(self, "data_format")

    @property
    @pulumi.getter(name="dataPageSize")
    def data_page_size(self) -> pulumi.Output[Optional[int]]:
        """
        Size of one data page in bytes. (AWS default is 1 MiB, _i.e._, `1048576`.)
        """
        return pulumi.get(self, "data_page_size")

    @property
    @pulumi.getter(name="datePartitionDelimiter")
    def date_partition_delimiter(self) -> pulumi.Output[Optional[str]]:
        """
        Date separating delimiter to use during folder partitioning. Valid values are `SLASH`, `UNDERSCORE`, `DASH`, and `NONE`. (AWS default is `SLASH`.) (Ignored for source endpoints.)
        """
        return pulumi.get(self, "date_partition_delimiter")

    @property
    @pulumi.getter(name="datePartitionEnabled")
    def date_partition_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Partition S3 bucket folders based on transaction commit dates. Default is `false`. (Ignored for source endpoints.)
        """
        return pulumi.get(self, "date_partition_enabled")

    @property
    @pulumi.getter(name="datePartitionSequence")
    def date_partition_sequence(self) -> pulumi.Output[Optional[str]]:
        """
        Date format to use during folder partitioning. Use this parameter when `date_partition_enabled` is set to true. Valid values are `YYYYMMDD`, `YYYYMMDDHH`, `YYYYMM`, `MMYYYYDD`, and `DDMMYYYY`. (AWS default is `YYYYMMDD`.) (Ignored for source endpoints.)
        """
        return pulumi.get(self, "date_partition_sequence")

    @property
    @pulumi.getter(name="datePartitionTimezone")
    def date_partition_timezone(self) -> pulumi.Output[Optional[str]]:
        """
        Convert the current UTC time to a timezone. The conversion occurs when a date partition folder is created and a CDC filename is generated. The timezone format is Area/Location (_e.g._, `Europe/Paris`). Use this when `date_partition_enabled` is `true`. (Ignored for source endpoints.)
        """
        return pulumi.get(self, "date_partition_timezone")

    @property
    @pulumi.getter(name="detachTargetOnLobLookupFailureParquet")
    def detach_target_on_lob_lookup_failure_parquet(self) -> pulumi.Output[Optional[bool]]:
        """
        Undocumented argument for use as directed by AWS Support.
        """
        return pulumi.get(self, "detach_target_on_lob_lookup_failure_parquet")

    @property
    @pulumi.getter(name="dictPageSizeLimit")
    def dict_page_size_limit(self) -> pulumi.Output[Optional[int]]:
        """
        Maximum size in bytes of an encoded dictionary page of a column. (AWS default is 1 MiB, _i.e._, `1048576`.)
        """
        return pulumi.get(self, "dict_page_size_limit")

    @property
    @pulumi.getter(name="enableStatistics")
    def enable_statistics(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to enable statistics for Parquet pages and row groups. Default is `true`.
        """
        return pulumi.get(self, "enable_statistics")

    @property
    @pulumi.getter(name="encodingType")
    def encoding_type(self) -> pulumi.Output[Optional[str]]:
        """
        Type of encoding to use. Value values are `rle_dictionary`, `plain`, and `plain_dictionary`. (AWS default is `rle_dictionary`.)
        """
        return pulumi.get(self, "encoding_type")

    @property
    @pulumi.getter(name="encryptionMode")
    def encryption_mode(self) -> pulumi.Output[Optional[str]]:
        """
        Server-side encryption mode that you want to encrypt your .csv or .parquet object files copied to S3. Valid values are `SSE_S3` and `SSE_KMS`. (AWS default is `SSE_S3`.) (Ignored for source endpoints -- only `SSE_S3` is valid.)
        """
        return pulumi.get(self, "encryption_mode")

    @property
    @pulumi.getter(name="endpointArn")
    def endpoint_arn(self) -> pulumi.Output[str]:
        """
        ARN for the endpoint.
        """
        return pulumi.get(self, "endpoint_arn")

    @property
    @pulumi.getter(name="endpointId")
    def endpoint_id(self) -> pulumi.Output[str]:
        """
        Database endpoint identifier. Identifiers must contain from 1 to 255 alphanumeric characters or hyphens, begin with a letter, contain only ASCII letters, digits, and hyphens, not end with a hyphen, and not contain two consecutive hyphens.
        """
        return pulumi.get(self, "endpoint_id")

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> pulumi.Output[str]:
        """
        Type of endpoint. Valid values are `source`, `target`.
        """
        return pulumi.get(self, "endpoint_type")

    @property
    @pulumi.getter(name="engineDisplayName")
    def engine_display_name(self) -> pulumi.Output[str]:
        """
        Expanded name for the engine name.
        """
        return pulumi.get(self, "engine_display_name")

    @property
    @pulumi.getter(name="expectedBucketOwner")
    def expected_bucket_owner(self) -> pulumi.Output[Optional[str]]:
        """
        Bucket owner to prevent sniping. Value is an AWS account ID.
        """
        return pulumi.get(self, "expected_bucket_owner")

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> pulumi.Output[str]:
        """
        Can be used for cross-account validation. Use it in another account with `dms.S3Endpoint` to create the endpoint cross-account.
        """
        return pulumi.get(self, "external_id")

    @property
    @pulumi.getter(name="externalTableDefinition")
    def external_table_definition(self) -> pulumi.Output[Optional[str]]:
        """
        JSON document that describes how AWS DMS should interpret the data.
        """
        return pulumi.get(self, "external_table_definition")

    @property
    @pulumi.getter(name="ignoreHeaderRows")
    def ignore_header_rows(self) -> pulumi.Output[Optional[int]]:
        """
        When this value is set to `1`, DMS ignores the first row header in a .csv file. (AWS default is `0`.)
        """
        return pulumi.get(self, "ignore_header_rows")

    @property
    @pulumi.getter(name="includeOpForFullLoad")
    def include_op_for_full_load(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to enable a full load to write INSERT operations to the .csv output files only to indicate how the rows were added to the source database. Default is `false`.
        """
        return pulumi.get(self, "include_op_for_full_load")

    @property
    @pulumi.getter(name="kmsKeyArn")
    def kms_key_arn(self) -> pulumi.Output[str]:
        """
        ARN for the KMS key that will be used to encrypt the connection parameters. If you do not specify a value for `kms_key_arn`, then AWS DMS will use your default encryption key. AWS KMS creates the default encryption key for your AWS account. Your AWS account has a different default encryption key for each AWS region.
        """
        return pulumi.get(self, "kms_key_arn")

    @property
    @pulumi.getter(name="maxFileSize")
    def max_file_size(self) -> pulumi.Output[Optional[int]]:
        """
        Maximum size (in KB) of any .csv file to be created while migrating to an S3 target during full load. Valid values are from `1` to `1048576`. (AWS default is 1 GB, _i.e._, `1048576`.)
        """
        return pulumi.get(self, "max_file_size")

    @property
    @pulumi.getter(name="parquetTimestampInMillisecond")
    def parquet_timestamp_in_millisecond(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies the precision of any TIMESTAMP column values written to an S3 object file in .parquet format. Default is `false`. (Ignored for source endpoints.)
        """
        return pulumi.get(self, "parquet_timestamp_in_millisecond")

    @property
    @pulumi.getter(name="parquetVersion")
    def parquet_version(self) -> pulumi.Output[Optional[str]]:
        """
        Version of the .parquet file format. Valid values are `parquet-1-0` and `parquet-2-0`. (AWS default is `parquet-1-0`.) (Ignored for source endpoints.)
        """
        return pulumi.get(self, "parquet_version")

    @property
    @pulumi.getter(name="preserveTransactions")
    def preserve_transactions(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether DMS saves the transaction order for a CDC load on the S3 target specified by `cdc_path`. Default is `false`. (Ignored for source endpoints.)
        """
        return pulumi.get(self, "preserve_transactions")

    @property
    @pulumi.getter
    def rfc4180(self) -> pulumi.Output[Optional[bool]]:
        """
        For an S3 source, whether each leading double quotation mark has to be followed by an ending double quotation mark. Default is `true`.
        """
        return pulumi.get(self, "rfc4180")

    @property
    @pulumi.getter(name="rowGroupLength")
    def row_group_length(self) -> pulumi.Output[Optional[int]]:
        """
        Number of rows in a row group. (AWS default is `10000`.)
        """
        return pulumi.get(self, "row_group_length")

    @property
    @pulumi.getter(name="serverSideEncryptionKmsKeyId")
    def server_side_encryption_kms_key_id(self) -> pulumi.Output[Optional[str]]:
        """
        When `encryption_mode` is `SSE_KMS`, ARN for the AWS KMS key. (Ignored for source endpoints -- only `SSE_S3` `encryption_mode` is valid.)
        """
        return pulumi.get(self, "server_side_encryption_kms_key_id")

    @property
    @pulumi.getter(name="serviceAccessRoleArn")
    def service_access_role_arn(self) -> pulumi.Output[str]:
        """
        ARN of the IAM role with permissions to the S3 Bucket.

        The following arguments are optional:
        """
        return pulumi.get(self, "service_access_role_arn")

    @property
    @pulumi.getter(name="sslMode")
    def ssl_mode(self) -> pulumi.Output[str]:
        """
        SSL mode to use for the connection. Valid values are `none`, `require`, `verify-ca`, `verify-full`. (AWS default is `none`.)
        """
        return pulumi.get(self, "ssl_mode")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        Status of the endpoint.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter(name="timestampColumnName")
    def timestamp_column_name(self) -> pulumi.Output[Optional[str]]:
        """
        Column to add with timestamp information to the endpoint data for an Amazon S3 target.
        """
        return pulumi.get(self, "timestamp_column_name")

    @property
    @pulumi.getter(name="useCsvNoSupValue")
    def use_csv_no_sup_value(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to use `csv_no_sup_value` for columns not included in the supplemental log. (Ignored for source endpoints.)
        """
        return pulumi.get(self, "use_csv_no_sup_value")

    @property
    @pulumi.getter(name="useTaskStartTimeForFullLoadTimestamp")
    def use_task_start_time_for_full_load_timestamp(self) -> pulumi.Output[Optional[bool]]:
        """
        When set to `true`, uses the task start time as the timestamp column value instead of the time data is written to target. For full load, when set to `true`, each row of the timestamp column contains the task start time. For CDC loads, each row of the timestamp column contains the transaction commit time.When set to false, the full load timestamp in the timestamp column increments with the time data arrives at the target. Default is `false`.
        """
        return pulumi.get(self, "use_task_start_time_for_full_load_timestamp")

