# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['VpcEndpointServiceAllowedPrincipleArgs', 'VpcEndpointServiceAllowedPrinciple']

@pulumi.input_type
class VpcEndpointServiceAllowedPrincipleArgs:
    def __init__(__self__, *,
                 principal_arn: pulumi.Input[str],
                 vpc_endpoint_service_id: pulumi.Input[str]):
        """
        The set of arguments for constructing a VpcEndpointServiceAllowedPrinciple resource.
        :param pulumi.Input[str] principal_arn: The ARN of the principal to allow permissions.
        :param pulumi.Input[str] vpc_endpoint_service_id: The ID of the VPC endpoint service to allow permission.
        """
        pulumi.set(__self__, "principal_arn", principal_arn)
        pulumi.set(__self__, "vpc_endpoint_service_id", vpc_endpoint_service_id)

    @property
    @pulumi.getter(name="principalArn")
    def principal_arn(self) -> pulumi.Input[str]:
        """
        The ARN of the principal to allow permissions.
        """
        return pulumi.get(self, "principal_arn")

    @principal_arn.setter
    def principal_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "principal_arn", value)

    @property
    @pulumi.getter(name="vpcEndpointServiceId")
    def vpc_endpoint_service_id(self) -> pulumi.Input[str]:
        """
        The ID of the VPC endpoint service to allow permission.
        """
        return pulumi.get(self, "vpc_endpoint_service_id")

    @vpc_endpoint_service_id.setter
    def vpc_endpoint_service_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vpc_endpoint_service_id", value)


@pulumi.input_type
class _VpcEndpointServiceAllowedPrincipleState:
    def __init__(__self__, *,
                 principal_arn: Optional[pulumi.Input[str]] = None,
                 vpc_endpoint_service_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering VpcEndpointServiceAllowedPrinciple resources.
        :param pulumi.Input[str] principal_arn: The ARN of the principal to allow permissions.
        :param pulumi.Input[str] vpc_endpoint_service_id: The ID of the VPC endpoint service to allow permission.
        """
        if principal_arn is not None:
            pulumi.set(__self__, "principal_arn", principal_arn)
        if vpc_endpoint_service_id is not None:
            pulumi.set(__self__, "vpc_endpoint_service_id", vpc_endpoint_service_id)

    @property
    @pulumi.getter(name="principalArn")
    def principal_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the principal to allow permissions.
        """
        return pulumi.get(self, "principal_arn")

    @principal_arn.setter
    def principal_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "principal_arn", value)

    @property
    @pulumi.getter(name="vpcEndpointServiceId")
    def vpc_endpoint_service_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the VPC endpoint service to allow permission.
        """
        return pulumi.get(self, "vpc_endpoint_service_id")

    @vpc_endpoint_service_id.setter
    def vpc_endpoint_service_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_endpoint_service_id", value)


class VpcEndpointServiceAllowedPrinciple(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 principal_arn: Optional[pulumi.Input[str]] = None,
                 vpc_endpoint_service_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a resource to allow a principal to discover a VPC endpoint service.

        > **NOTE on VPC Endpoint Services and VPC Endpoint Service Allowed Principals:** This provider provides
        both a standalone VPC Endpoint Service Allowed Principal resource
        and a VPC Endpoint Service resource with an `allowed_principals` attribute. Do not use the same principal ARN in both
        a VPC Endpoint Service resource and a VPC Endpoint Service Allowed Principal resource. Doing so will cause a conflict
        and will overwrite the association.

        ## Example Usage

        Basic usage:

        ```python
        import pulumi
        import pulumi_aws as aws

        current = aws.get_caller_identity()
        allow_me_to_foo = aws.ec2.VpcEndpointServiceAllowedPrinciple("allowMeToFoo",
            vpc_endpoint_service_id=aws_vpc_endpoint_service["foo"]["id"],
            principal_arn=current.arn)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] principal_arn: The ARN of the principal to allow permissions.
        :param pulumi.Input[str] vpc_endpoint_service_id: The ID of the VPC endpoint service to allow permission.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VpcEndpointServiceAllowedPrincipleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to allow a principal to discover a VPC endpoint service.

        > **NOTE on VPC Endpoint Services and VPC Endpoint Service Allowed Principals:** This provider provides
        both a standalone VPC Endpoint Service Allowed Principal resource
        and a VPC Endpoint Service resource with an `allowed_principals` attribute. Do not use the same principal ARN in both
        a VPC Endpoint Service resource and a VPC Endpoint Service Allowed Principal resource. Doing so will cause a conflict
        and will overwrite the association.

        ## Example Usage

        Basic usage:

        ```python
        import pulumi
        import pulumi_aws as aws

        current = aws.get_caller_identity()
        allow_me_to_foo = aws.ec2.VpcEndpointServiceAllowedPrinciple("allowMeToFoo",
            vpc_endpoint_service_id=aws_vpc_endpoint_service["foo"]["id"],
            principal_arn=current.arn)
        ```

        :param str resource_name: The name of the resource.
        :param VpcEndpointServiceAllowedPrincipleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VpcEndpointServiceAllowedPrincipleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 principal_arn: Optional[pulumi.Input[str]] = None,
                 vpc_endpoint_service_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VpcEndpointServiceAllowedPrincipleArgs.__new__(VpcEndpointServiceAllowedPrincipleArgs)

            if principal_arn is None and not opts.urn:
                raise TypeError("Missing required property 'principal_arn'")
            __props__.__dict__["principal_arn"] = principal_arn
            if vpc_endpoint_service_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_endpoint_service_id'")
            __props__.__dict__["vpc_endpoint_service_id"] = vpc_endpoint_service_id
        super(VpcEndpointServiceAllowedPrinciple, __self__).__init__(
            'aws:ec2/vpcEndpointServiceAllowedPrinciple:VpcEndpointServiceAllowedPrinciple',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            principal_arn: Optional[pulumi.Input[str]] = None,
            vpc_endpoint_service_id: Optional[pulumi.Input[str]] = None) -> 'VpcEndpointServiceAllowedPrinciple':
        """
        Get an existing VpcEndpointServiceAllowedPrinciple resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] principal_arn: The ARN of the principal to allow permissions.
        :param pulumi.Input[str] vpc_endpoint_service_id: The ID of the VPC endpoint service to allow permission.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VpcEndpointServiceAllowedPrincipleState.__new__(_VpcEndpointServiceAllowedPrincipleState)

        __props__.__dict__["principal_arn"] = principal_arn
        __props__.__dict__["vpc_endpoint_service_id"] = vpc_endpoint_service_id
        return VpcEndpointServiceAllowedPrinciple(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="principalArn")
    def principal_arn(self) -> pulumi.Output[str]:
        """
        The ARN of the principal to allow permissions.
        """
        return pulumi.get(self, "principal_arn")

    @property
    @pulumi.getter(name="vpcEndpointServiceId")
    def vpc_endpoint_service_id(self) -> pulumi.Output[str]:
        """
        The ID of the VPC endpoint service to allow permission.
        """
        return pulumi.get(self, "vpc_endpoint_service_id")

