# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['LoadBalancerArgs', 'LoadBalancer']

@pulumi.input_type
class LoadBalancerArgs:
    def __init__(__self__, *,
                 listeners: pulumi.Input[Sequence[pulumi.Input['LoadBalancerListenerArgs']]],
                 access_logs: Optional[pulumi.Input['LoadBalancerAccessLogsArgs']] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 connection_draining: Optional[pulumi.Input[bool]] = None,
                 connection_draining_timeout: Optional[pulumi.Input[int]] = None,
                 cross_zone_load_balancing: Optional[pulumi.Input[bool]] = None,
                 desync_mitigation_mode: Optional[pulumi.Input[str]] = None,
                 health_check: Optional[pulumi.Input['LoadBalancerHealthCheckArgs']] = None,
                 idle_timeout: Optional[pulumi.Input[int]] = None,
                 instances: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 internal: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 name_prefix: Optional[pulumi.Input[str]] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 source_security_group: Optional[pulumi.Input[str]] = None,
                 subnets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a LoadBalancer resource.
        :param pulumi.Input[Sequence[pulumi.Input['LoadBalancerListenerArgs']]] listeners: A list of listener blocks. Listeners documented below.
        :param pulumi.Input['LoadBalancerAccessLogsArgs'] access_logs: An Access Logs block. Access Logs documented below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] availability_zones: The AZ's to serve traffic in.
        :param pulumi.Input[bool] connection_draining: Boolean to enable connection draining. Default: `false`
        :param pulumi.Input[int] connection_draining_timeout: The time in seconds to allow for connections to drain. Default: `300`
        :param pulumi.Input[bool] cross_zone_load_balancing: Enable cross-zone load balancing. Default: `true`
        :param pulumi.Input[str] desync_mitigation_mode: Determines how the load balancer handles requests that might pose a security risk to an application due to HTTP desync. Valid values are `monitor`, `defensive` (default), `strictest`.
        :param pulumi.Input['LoadBalancerHealthCheckArgs'] health_check: A health_check block. Health Check documented below.
        :param pulumi.Input[int] idle_timeout: The time in seconds that the connection is allowed to be idle. Default: `60`
        :param pulumi.Input[Sequence[pulumi.Input[str]]] instances: A list of instance ids to place in the ELB pool.
        :param pulumi.Input[bool] internal: If true, ELB will be an internal ELB.
        :param pulumi.Input[str] name: The name of the ELB. By default generated by this provider.
        :param pulumi.Input[str] name_prefix: Creates a unique name beginning with the specified
               prefix. Conflicts with `name`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_groups: A list of security group IDs to assign to the ELB.
               Only valid if creating an ELB within a VPC
        :param pulumi.Input[str] source_security_group: The name of the security group that you can use as
               part of your inbound rules for your load balancer's back-end application
               instances. Use this for Classic or Default VPC only.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnets: A list of subnet IDs to attach to the ELB. When an update to subnets will remove all current subnets, this will force a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
               
               Exactly one of `availability_zones` or `subnets` must be specified: this
               determines if the ELB exists in a VPC or in EC2-classic.
        """
        pulumi.set(__self__, "listeners", listeners)
        if access_logs is not None:
            pulumi.set(__self__, "access_logs", access_logs)
        if availability_zones is not None:
            pulumi.set(__self__, "availability_zones", availability_zones)
        if connection_draining is not None:
            pulumi.set(__self__, "connection_draining", connection_draining)
        if connection_draining_timeout is not None:
            pulumi.set(__self__, "connection_draining_timeout", connection_draining_timeout)
        if cross_zone_load_balancing is not None:
            pulumi.set(__self__, "cross_zone_load_balancing", cross_zone_load_balancing)
        if desync_mitigation_mode is not None:
            pulumi.set(__self__, "desync_mitigation_mode", desync_mitigation_mode)
        if health_check is not None:
            pulumi.set(__self__, "health_check", health_check)
        if idle_timeout is not None:
            pulumi.set(__self__, "idle_timeout", idle_timeout)
        if instances is not None:
            pulumi.set(__self__, "instances", instances)
        if internal is not None:
            pulumi.set(__self__, "internal", internal)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if name_prefix is not None:
            pulumi.set(__self__, "name_prefix", name_prefix)
        if security_groups is not None:
            pulumi.set(__self__, "security_groups", security_groups)
        if source_security_group is not None:
            pulumi.set(__self__, "source_security_group", source_security_group)
        if subnets is not None:
            pulumi.set(__self__, "subnets", subnets)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def listeners(self) -> pulumi.Input[Sequence[pulumi.Input['LoadBalancerListenerArgs']]]:
        """
        A list of listener blocks. Listeners documented below.
        """
        return pulumi.get(self, "listeners")

    @listeners.setter
    def listeners(self, value: pulumi.Input[Sequence[pulumi.Input['LoadBalancerListenerArgs']]]):
        pulumi.set(self, "listeners", value)

    @property
    @pulumi.getter(name="accessLogs")
    def access_logs(self) -> Optional[pulumi.Input['LoadBalancerAccessLogsArgs']]:
        """
        An Access Logs block. Access Logs documented below.
        """
        return pulumi.get(self, "access_logs")

    @access_logs.setter
    def access_logs(self, value: Optional[pulumi.Input['LoadBalancerAccessLogsArgs']]):
        pulumi.set(self, "access_logs", value)

    @property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The AZ's to serve traffic in.
        """
        return pulumi.get(self, "availability_zones")

    @availability_zones.setter
    def availability_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "availability_zones", value)

    @property
    @pulumi.getter(name="connectionDraining")
    def connection_draining(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean to enable connection draining. Default: `false`
        """
        return pulumi.get(self, "connection_draining")

    @connection_draining.setter
    def connection_draining(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "connection_draining", value)

    @property
    @pulumi.getter(name="connectionDrainingTimeout")
    def connection_draining_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        The time in seconds to allow for connections to drain. Default: `300`
        """
        return pulumi.get(self, "connection_draining_timeout")

    @connection_draining_timeout.setter
    def connection_draining_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "connection_draining_timeout", value)

    @property
    @pulumi.getter(name="crossZoneLoadBalancing")
    def cross_zone_load_balancing(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable cross-zone load balancing. Default: `true`
        """
        return pulumi.get(self, "cross_zone_load_balancing")

    @cross_zone_load_balancing.setter
    def cross_zone_load_balancing(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "cross_zone_load_balancing", value)

    @property
    @pulumi.getter(name="desyncMitigationMode")
    def desync_mitigation_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Determines how the load balancer handles requests that might pose a security risk to an application due to HTTP desync. Valid values are `monitor`, `defensive` (default), `strictest`.
        """
        return pulumi.get(self, "desync_mitigation_mode")

    @desync_mitigation_mode.setter
    def desync_mitigation_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "desync_mitigation_mode", value)

    @property
    @pulumi.getter(name="healthCheck")
    def health_check(self) -> Optional[pulumi.Input['LoadBalancerHealthCheckArgs']]:
        """
        A health_check block. Health Check documented below.
        """
        return pulumi.get(self, "health_check")

    @health_check.setter
    def health_check(self, value: Optional[pulumi.Input['LoadBalancerHealthCheckArgs']]):
        pulumi.set(self, "health_check", value)

    @property
    @pulumi.getter(name="idleTimeout")
    def idle_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        The time in seconds that the connection is allowed to be idle. Default: `60`
        """
        return pulumi.get(self, "idle_timeout")

    @idle_timeout.setter
    def idle_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "idle_timeout", value)

    @property
    @pulumi.getter
    def instances(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of instance ids to place in the ELB pool.
        """
        return pulumi.get(self, "instances")

    @instances.setter
    def instances(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "instances", value)

    @property
    @pulumi.getter
    def internal(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, ELB will be an internal ELB.
        """
        return pulumi.get(self, "internal")

    @internal.setter
    def internal(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "internal", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the ELB. By default generated by this provider.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Creates a unique name beginning with the specified
        prefix. Conflicts with `name`.
        """
        return pulumi.get(self, "name_prefix")

    @name_prefix.setter
    def name_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name_prefix", value)

    @property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of security group IDs to assign to the ELB.
        Only valid if creating an ELB within a VPC
        """
        return pulumi.get(self, "security_groups")

    @security_groups.setter
    def security_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "security_groups", value)

    @property
    @pulumi.getter(name="sourceSecurityGroup")
    def source_security_group(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the security group that you can use as
        part of your inbound rules for your load balancer's back-end application
        instances. Use this for Classic or Default VPC only.
        """
        return pulumi.get(self, "source_security_group")

    @source_security_group.setter
    def source_security_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_security_group", value)

    @property
    @pulumi.getter
    def subnets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of subnet IDs to attach to the ELB. When an update to subnets will remove all current subnets, this will force a new resource.
        """
        return pulumi.get(self, "subnets")

    @subnets.setter
    def subnets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "subnets", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.

        Exactly one of `availability_zones` or `subnets` must be specified: this
        determines if the ELB exists in a VPC or in EC2-classic.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _LoadBalancerState:
    def __init__(__self__, *,
                 access_logs: Optional[pulumi.Input['LoadBalancerAccessLogsArgs']] = None,
                 arn: Optional[pulumi.Input[str]] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 connection_draining: Optional[pulumi.Input[bool]] = None,
                 connection_draining_timeout: Optional[pulumi.Input[int]] = None,
                 cross_zone_load_balancing: Optional[pulumi.Input[bool]] = None,
                 desync_mitigation_mode: Optional[pulumi.Input[str]] = None,
                 dns_name: Optional[pulumi.Input[str]] = None,
                 health_check: Optional[pulumi.Input['LoadBalancerHealthCheckArgs']] = None,
                 idle_timeout: Optional[pulumi.Input[int]] = None,
                 instances: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 internal: Optional[pulumi.Input[bool]] = None,
                 listeners: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerListenerArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 name_prefix: Optional[pulumi.Input[str]] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 source_security_group: Optional[pulumi.Input[str]] = None,
                 source_security_group_id: Optional[pulumi.Input[str]] = None,
                 subnets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering LoadBalancer resources.
        :param pulumi.Input['LoadBalancerAccessLogsArgs'] access_logs: An Access Logs block. Access Logs documented below.
        :param pulumi.Input[str] arn: The ARN of the ELB
        :param pulumi.Input[Sequence[pulumi.Input[str]]] availability_zones: The AZ's to serve traffic in.
        :param pulumi.Input[bool] connection_draining: Boolean to enable connection draining. Default: `false`
        :param pulumi.Input[int] connection_draining_timeout: The time in seconds to allow for connections to drain. Default: `300`
        :param pulumi.Input[bool] cross_zone_load_balancing: Enable cross-zone load balancing. Default: `true`
        :param pulumi.Input[str] desync_mitigation_mode: Determines how the load balancer handles requests that might pose a security risk to an application due to HTTP desync. Valid values are `monitor`, `defensive` (default), `strictest`.
        :param pulumi.Input[str] dns_name: The DNS name of the ELB
        :param pulumi.Input['LoadBalancerHealthCheckArgs'] health_check: A health_check block. Health Check documented below.
        :param pulumi.Input[int] idle_timeout: The time in seconds that the connection is allowed to be idle. Default: `60`
        :param pulumi.Input[Sequence[pulumi.Input[str]]] instances: A list of instance ids to place in the ELB pool.
        :param pulumi.Input[bool] internal: If true, ELB will be an internal ELB.
        :param pulumi.Input[Sequence[pulumi.Input['LoadBalancerListenerArgs']]] listeners: A list of listener blocks. Listeners documented below.
        :param pulumi.Input[str] name: The name of the ELB. By default generated by this provider.
        :param pulumi.Input[str] name_prefix: Creates a unique name beginning with the specified
               prefix. Conflicts with `name`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_groups: A list of security group IDs to assign to the ELB.
               Only valid if creating an ELB within a VPC
        :param pulumi.Input[str] source_security_group: The name of the security group that you can use as
               part of your inbound rules for your load balancer's back-end application
               instances. Use this for Classic or Default VPC only.
        :param pulumi.Input[str] source_security_group_id: The ID of the security group that you can use as
               part of your inbound rules for your load balancer's back-end application
               instances. Only available on ELBs launched in a VPC.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnets: A list of subnet IDs to attach to the ELB. When an update to subnets will remove all current subnets, this will force a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
               
               Exactly one of `availability_zones` or `subnets` must be specified: this
               determines if the ELB exists in a VPC or in EC2-classic.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[str] zone_id: The canonical hosted zone ID of the ELB (to be used in a Route 53 Alias record)
        """
        if access_logs is not None:
            pulumi.set(__self__, "access_logs", access_logs)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if availability_zones is not None:
            pulumi.set(__self__, "availability_zones", availability_zones)
        if connection_draining is not None:
            pulumi.set(__self__, "connection_draining", connection_draining)
        if connection_draining_timeout is not None:
            pulumi.set(__self__, "connection_draining_timeout", connection_draining_timeout)
        if cross_zone_load_balancing is not None:
            pulumi.set(__self__, "cross_zone_load_balancing", cross_zone_load_balancing)
        if desync_mitigation_mode is not None:
            pulumi.set(__self__, "desync_mitigation_mode", desync_mitigation_mode)
        if dns_name is not None:
            pulumi.set(__self__, "dns_name", dns_name)
        if health_check is not None:
            pulumi.set(__self__, "health_check", health_check)
        if idle_timeout is not None:
            pulumi.set(__self__, "idle_timeout", idle_timeout)
        if instances is not None:
            pulumi.set(__self__, "instances", instances)
        if internal is not None:
            pulumi.set(__self__, "internal", internal)
        if listeners is not None:
            pulumi.set(__self__, "listeners", listeners)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if name_prefix is not None:
            pulumi.set(__self__, "name_prefix", name_prefix)
        if security_groups is not None:
            pulumi.set(__self__, "security_groups", security_groups)
        if source_security_group is not None:
            pulumi.set(__self__, "source_security_group", source_security_group)
        if source_security_group_id is not None:
            pulumi.set(__self__, "source_security_group_id", source_security_group_id)
        if subnets is not None:
            pulumi.set(__self__, "subnets", subnets)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="accessLogs")
    def access_logs(self) -> Optional[pulumi.Input['LoadBalancerAccessLogsArgs']]:
        """
        An Access Logs block. Access Logs documented below.
        """
        return pulumi.get(self, "access_logs")

    @access_logs.setter
    def access_logs(self, value: Optional[pulumi.Input['LoadBalancerAccessLogsArgs']]):
        pulumi.set(self, "access_logs", value)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the ELB
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The AZ's to serve traffic in.
        """
        return pulumi.get(self, "availability_zones")

    @availability_zones.setter
    def availability_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "availability_zones", value)

    @property
    @pulumi.getter(name="connectionDraining")
    def connection_draining(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean to enable connection draining. Default: `false`
        """
        return pulumi.get(self, "connection_draining")

    @connection_draining.setter
    def connection_draining(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "connection_draining", value)

    @property
    @pulumi.getter(name="connectionDrainingTimeout")
    def connection_draining_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        The time in seconds to allow for connections to drain. Default: `300`
        """
        return pulumi.get(self, "connection_draining_timeout")

    @connection_draining_timeout.setter
    def connection_draining_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "connection_draining_timeout", value)

    @property
    @pulumi.getter(name="crossZoneLoadBalancing")
    def cross_zone_load_balancing(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable cross-zone load balancing. Default: `true`
        """
        return pulumi.get(self, "cross_zone_load_balancing")

    @cross_zone_load_balancing.setter
    def cross_zone_load_balancing(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "cross_zone_load_balancing", value)

    @property
    @pulumi.getter(name="desyncMitigationMode")
    def desync_mitigation_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Determines how the load balancer handles requests that might pose a security risk to an application due to HTTP desync. Valid values are `monitor`, `defensive` (default), `strictest`.
        """
        return pulumi.get(self, "desync_mitigation_mode")

    @desync_mitigation_mode.setter
    def desync_mitigation_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "desync_mitigation_mode", value)

    @property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> Optional[pulumi.Input[str]]:
        """
        The DNS name of the ELB
        """
        return pulumi.get(self, "dns_name")

    @dns_name.setter
    def dns_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dns_name", value)

    @property
    @pulumi.getter(name="healthCheck")
    def health_check(self) -> Optional[pulumi.Input['LoadBalancerHealthCheckArgs']]:
        """
        A health_check block. Health Check documented below.
        """
        return pulumi.get(self, "health_check")

    @health_check.setter
    def health_check(self, value: Optional[pulumi.Input['LoadBalancerHealthCheckArgs']]):
        pulumi.set(self, "health_check", value)

    @property
    @pulumi.getter(name="idleTimeout")
    def idle_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        The time in seconds that the connection is allowed to be idle. Default: `60`
        """
        return pulumi.get(self, "idle_timeout")

    @idle_timeout.setter
    def idle_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "idle_timeout", value)

    @property
    @pulumi.getter
    def instances(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of instance ids to place in the ELB pool.
        """
        return pulumi.get(self, "instances")

    @instances.setter
    def instances(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "instances", value)

    @property
    @pulumi.getter
    def internal(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, ELB will be an internal ELB.
        """
        return pulumi.get(self, "internal")

    @internal.setter
    def internal(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "internal", value)

    @property
    @pulumi.getter
    def listeners(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerListenerArgs']]]]:
        """
        A list of listener blocks. Listeners documented below.
        """
        return pulumi.get(self, "listeners")

    @listeners.setter
    def listeners(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerListenerArgs']]]]):
        pulumi.set(self, "listeners", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the ELB. By default generated by this provider.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Creates a unique name beginning with the specified
        prefix. Conflicts with `name`.
        """
        return pulumi.get(self, "name_prefix")

    @name_prefix.setter
    def name_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name_prefix", value)

    @property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of security group IDs to assign to the ELB.
        Only valid if creating an ELB within a VPC
        """
        return pulumi.get(self, "security_groups")

    @security_groups.setter
    def security_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "security_groups", value)

    @property
    @pulumi.getter(name="sourceSecurityGroup")
    def source_security_group(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the security group that you can use as
        part of your inbound rules for your load balancer's back-end application
        instances. Use this for Classic or Default VPC only.
        """
        return pulumi.get(self, "source_security_group")

    @source_security_group.setter
    def source_security_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_security_group", value)

    @property
    @pulumi.getter(name="sourceSecurityGroupId")
    def source_security_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the security group that you can use as
        part of your inbound rules for your load balancer's back-end application
        instances. Only available on ELBs launched in a VPC.
        """
        return pulumi.get(self, "source_security_group_id")

    @source_security_group_id.setter
    def source_security_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_security_group_id", value)

    @property
    @pulumi.getter
    def subnets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of subnet IDs to attach to the ELB. When an update to subnets will remove all current subnets, this will force a new resource.
        """
        return pulumi.get(self, "subnets")

    @subnets.setter
    def subnets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "subnets", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.

        Exactly one of `availability_zones` or `subnets` must be specified: this
        determines if the ELB exists in a VPC or in EC2-classic.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[str]]:
        """
        The canonical hosted zone ID of the ELB (to be used in a Route 53 Alias record)
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone_id", value)


class LoadBalancer(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_logs: Optional[pulumi.Input[pulumi.InputType['LoadBalancerAccessLogsArgs']]] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 connection_draining: Optional[pulumi.Input[bool]] = None,
                 connection_draining_timeout: Optional[pulumi.Input[int]] = None,
                 cross_zone_load_balancing: Optional[pulumi.Input[bool]] = None,
                 desync_mitigation_mode: Optional[pulumi.Input[str]] = None,
                 health_check: Optional[pulumi.Input[pulumi.InputType['LoadBalancerHealthCheckArgs']]] = None,
                 idle_timeout: Optional[pulumi.Input[int]] = None,
                 instances: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 internal: Optional[pulumi.Input[bool]] = None,
                 listeners: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LoadBalancerListenerArgs']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 name_prefix: Optional[pulumi.Input[str]] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 source_security_group: Optional[pulumi.Input[str]] = None,
                 subnets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Provides an Elastic Load Balancer resource, also known as a "Classic
        Load Balancer" after the release of
        Application/Network Load Balancers.

        > **NOTE on ELB Instances and ELB Attachments:** This provider currently
        provides both a standalone ELB Attachment resource
        (describing an instance attached to an ELB), and an ELB resource with
        `instances` defined in-line. At this time you cannot use an ELB with in-line
        instances in conjunction with a ELB Attachment resources. Doing so will cause a
        conflict and will overwrite attachments.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        # Create a new load balancer
        bar = aws.elb.LoadBalancer("bar",
            availability_zones=[
                "us-west-2a",
                "us-west-2b",
                "us-west-2c",
            ],
            access_logs=aws.elb.LoadBalancerAccessLogsArgs(
                bucket="foo",
                bucket_prefix="bar",
                interval=60,
            ),
            listeners=[
                aws.elb.LoadBalancerListenerArgs(
                    instance_port=8000,
                    instance_protocol="http",
                    lb_port=80,
                    lb_protocol="http",
                ),
                aws.elb.LoadBalancerListenerArgs(
                    instance_port=8000,
                    instance_protocol="http",
                    lb_port=443,
                    lb_protocol="https",
                    ssl_certificate_id="arn:aws:iam::123456789012:server-certificate/certName",
                ),
            ],
            health_check=aws.elb.LoadBalancerHealthCheckArgs(
                healthy_threshold=2,
                unhealthy_threshold=2,
                timeout=3,
                target="HTTP:8000/",
                interval=30,
            ),
            instances=[aws_instance["foo"]["id"]],
            cross_zone_load_balancing=True,
            idle_timeout=400,
            connection_draining=True,
            connection_draining_timeout=400,
            tags={
                "Name": "foobar-elb",
            })
        ```
        ## Note on ECDSA Key Algorithm

        If the ARN of the `ssl_certificate_id` that is pointed to references a
        certificate that was signed by an ECDSA key, note that ELB only supports the
        P256 and P384 curves.  Using a certificate signed by a key using a different
        curve could produce the error `ERR_SSL_VERSION_OR_CIPHER_MISMATCH` in your
        browser.

        ## Import

        Using `pulumi import`, import ELBs using the `name`. For example:

        ```sh
         $ pulumi import aws:elb/loadBalancer:LoadBalancer bar elb-production-12345
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['LoadBalancerAccessLogsArgs']] access_logs: An Access Logs block. Access Logs documented below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] availability_zones: The AZ's to serve traffic in.
        :param pulumi.Input[bool] connection_draining: Boolean to enable connection draining. Default: `false`
        :param pulumi.Input[int] connection_draining_timeout: The time in seconds to allow for connections to drain. Default: `300`
        :param pulumi.Input[bool] cross_zone_load_balancing: Enable cross-zone load balancing. Default: `true`
        :param pulumi.Input[str] desync_mitigation_mode: Determines how the load balancer handles requests that might pose a security risk to an application due to HTTP desync. Valid values are `monitor`, `defensive` (default), `strictest`.
        :param pulumi.Input[pulumi.InputType['LoadBalancerHealthCheckArgs']] health_check: A health_check block. Health Check documented below.
        :param pulumi.Input[int] idle_timeout: The time in seconds that the connection is allowed to be idle. Default: `60`
        :param pulumi.Input[Sequence[pulumi.Input[str]]] instances: A list of instance ids to place in the ELB pool.
        :param pulumi.Input[bool] internal: If true, ELB will be an internal ELB.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LoadBalancerListenerArgs']]]] listeners: A list of listener blocks. Listeners documented below.
        :param pulumi.Input[str] name: The name of the ELB. By default generated by this provider.
        :param pulumi.Input[str] name_prefix: Creates a unique name beginning with the specified
               prefix. Conflicts with `name`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_groups: A list of security group IDs to assign to the ELB.
               Only valid if creating an ELB within a VPC
        :param pulumi.Input[str] source_security_group: The name of the security group that you can use as
               part of your inbound rules for your load balancer's back-end application
               instances. Use this for Classic or Default VPC only.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnets: A list of subnet IDs to attach to the ELB. When an update to subnets will remove all current subnets, this will force a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
               
               Exactly one of `availability_zones` or `subnets` must be specified: this
               determines if the ELB exists in a VPC or in EC2-classic.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LoadBalancerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an Elastic Load Balancer resource, also known as a "Classic
        Load Balancer" after the release of
        Application/Network Load Balancers.

        > **NOTE on ELB Instances and ELB Attachments:** This provider currently
        provides both a standalone ELB Attachment resource
        (describing an instance attached to an ELB), and an ELB resource with
        `instances` defined in-line. At this time you cannot use an ELB with in-line
        instances in conjunction with a ELB Attachment resources. Doing so will cause a
        conflict and will overwrite attachments.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        # Create a new load balancer
        bar = aws.elb.LoadBalancer("bar",
            availability_zones=[
                "us-west-2a",
                "us-west-2b",
                "us-west-2c",
            ],
            access_logs=aws.elb.LoadBalancerAccessLogsArgs(
                bucket="foo",
                bucket_prefix="bar",
                interval=60,
            ),
            listeners=[
                aws.elb.LoadBalancerListenerArgs(
                    instance_port=8000,
                    instance_protocol="http",
                    lb_port=80,
                    lb_protocol="http",
                ),
                aws.elb.LoadBalancerListenerArgs(
                    instance_port=8000,
                    instance_protocol="http",
                    lb_port=443,
                    lb_protocol="https",
                    ssl_certificate_id="arn:aws:iam::123456789012:server-certificate/certName",
                ),
            ],
            health_check=aws.elb.LoadBalancerHealthCheckArgs(
                healthy_threshold=2,
                unhealthy_threshold=2,
                timeout=3,
                target="HTTP:8000/",
                interval=30,
            ),
            instances=[aws_instance["foo"]["id"]],
            cross_zone_load_balancing=True,
            idle_timeout=400,
            connection_draining=True,
            connection_draining_timeout=400,
            tags={
                "Name": "foobar-elb",
            })
        ```
        ## Note on ECDSA Key Algorithm

        If the ARN of the `ssl_certificate_id` that is pointed to references a
        certificate that was signed by an ECDSA key, note that ELB only supports the
        P256 and P384 curves.  Using a certificate signed by a key using a different
        curve could produce the error `ERR_SSL_VERSION_OR_CIPHER_MISMATCH` in your
        browser.

        ## Import

        Using `pulumi import`, import ELBs using the `name`. For example:

        ```sh
         $ pulumi import aws:elb/loadBalancer:LoadBalancer bar elb-production-12345
        ```

        :param str resource_name: The name of the resource.
        :param LoadBalancerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LoadBalancerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_logs: Optional[pulumi.Input[pulumi.InputType['LoadBalancerAccessLogsArgs']]] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 connection_draining: Optional[pulumi.Input[bool]] = None,
                 connection_draining_timeout: Optional[pulumi.Input[int]] = None,
                 cross_zone_load_balancing: Optional[pulumi.Input[bool]] = None,
                 desync_mitigation_mode: Optional[pulumi.Input[str]] = None,
                 health_check: Optional[pulumi.Input[pulumi.InputType['LoadBalancerHealthCheckArgs']]] = None,
                 idle_timeout: Optional[pulumi.Input[int]] = None,
                 instances: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 internal: Optional[pulumi.Input[bool]] = None,
                 listeners: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LoadBalancerListenerArgs']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 name_prefix: Optional[pulumi.Input[str]] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 source_security_group: Optional[pulumi.Input[str]] = None,
                 subnets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LoadBalancerArgs.__new__(LoadBalancerArgs)

            __props__.__dict__["access_logs"] = access_logs
            __props__.__dict__["availability_zones"] = availability_zones
            __props__.__dict__["connection_draining"] = connection_draining
            __props__.__dict__["connection_draining_timeout"] = connection_draining_timeout
            __props__.__dict__["cross_zone_load_balancing"] = cross_zone_load_balancing
            __props__.__dict__["desync_mitigation_mode"] = desync_mitigation_mode
            __props__.__dict__["health_check"] = health_check
            __props__.__dict__["idle_timeout"] = idle_timeout
            __props__.__dict__["instances"] = instances
            __props__.__dict__["internal"] = internal
            if listeners is None and not opts.urn:
                raise TypeError("Missing required property 'listeners'")
            __props__.__dict__["listeners"] = listeners
            __props__.__dict__["name"] = name
            __props__.__dict__["name_prefix"] = name_prefix
            __props__.__dict__["security_groups"] = security_groups
            __props__.__dict__["source_security_group"] = source_security_group
            __props__.__dict__["subnets"] = subnets
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["dns_name"] = None
            __props__.__dict__["source_security_group_id"] = None
            __props__.__dict__["tags_all"] = None
            __props__.__dict__["zone_id"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="aws:elasticloadbalancing/loadBalancer:LoadBalancer")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(LoadBalancer, __self__).__init__(
            'aws:elb/loadBalancer:LoadBalancer',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_logs: Optional[pulumi.Input[pulumi.InputType['LoadBalancerAccessLogsArgs']]] = None,
            arn: Optional[pulumi.Input[str]] = None,
            availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            connection_draining: Optional[pulumi.Input[bool]] = None,
            connection_draining_timeout: Optional[pulumi.Input[int]] = None,
            cross_zone_load_balancing: Optional[pulumi.Input[bool]] = None,
            desync_mitigation_mode: Optional[pulumi.Input[str]] = None,
            dns_name: Optional[pulumi.Input[str]] = None,
            health_check: Optional[pulumi.Input[pulumi.InputType['LoadBalancerHealthCheckArgs']]] = None,
            idle_timeout: Optional[pulumi.Input[int]] = None,
            instances: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            internal: Optional[pulumi.Input[bool]] = None,
            listeners: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LoadBalancerListenerArgs']]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            name_prefix: Optional[pulumi.Input[str]] = None,
            security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            source_security_group: Optional[pulumi.Input[str]] = None,
            source_security_group_id: Optional[pulumi.Input[str]] = None,
            subnets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            zone_id: Optional[pulumi.Input[str]] = None) -> 'LoadBalancer':
        """
        Get an existing LoadBalancer resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['LoadBalancerAccessLogsArgs']] access_logs: An Access Logs block. Access Logs documented below.
        :param pulumi.Input[str] arn: The ARN of the ELB
        :param pulumi.Input[Sequence[pulumi.Input[str]]] availability_zones: The AZ's to serve traffic in.
        :param pulumi.Input[bool] connection_draining: Boolean to enable connection draining. Default: `false`
        :param pulumi.Input[int] connection_draining_timeout: The time in seconds to allow for connections to drain. Default: `300`
        :param pulumi.Input[bool] cross_zone_load_balancing: Enable cross-zone load balancing. Default: `true`
        :param pulumi.Input[str] desync_mitigation_mode: Determines how the load balancer handles requests that might pose a security risk to an application due to HTTP desync. Valid values are `monitor`, `defensive` (default), `strictest`.
        :param pulumi.Input[str] dns_name: The DNS name of the ELB
        :param pulumi.Input[pulumi.InputType['LoadBalancerHealthCheckArgs']] health_check: A health_check block. Health Check documented below.
        :param pulumi.Input[int] idle_timeout: The time in seconds that the connection is allowed to be idle. Default: `60`
        :param pulumi.Input[Sequence[pulumi.Input[str]]] instances: A list of instance ids to place in the ELB pool.
        :param pulumi.Input[bool] internal: If true, ELB will be an internal ELB.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LoadBalancerListenerArgs']]]] listeners: A list of listener blocks. Listeners documented below.
        :param pulumi.Input[str] name: The name of the ELB. By default generated by this provider.
        :param pulumi.Input[str] name_prefix: Creates a unique name beginning with the specified
               prefix. Conflicts with `name`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_groups: A list of security group IDs to assign to the ELB.
               Only valid if creating an ELB within a VPC
        :param pulumi.Input[str] source_security_group: The name of the security group that you can use as
               part of your inbound rules for your load balancer's back-end application
               instances. Use this for Classic or Default VPC only.
        :param pulumi.Input[str] source_security_group_id: The ID of the security group that you can use as
               part of your inbound rules for your load balancer's back-end application
               instances. Only available on ELBs launched in a VPC.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnets: A list of subnet IDs to attach to the ELB. When an update to subnets will remove all current subnets, this will force a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
               
               Exactly one of `availability_zones` or `subnets` must be specified: this
               determines if the ELB exists in a VPC or in EC2-classic.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[str] zone_id: The canonical hosted zone ID of the ELB (to be used in a Route 53 Alias record)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LoadBalancerState.__new__(_LoadBalancerState)

        __props__.__dict__["access_logs"] = access_logs
        __props__.__dict__["arn"] = arn
        __props__.__dict__["availability_zones"] = availability_zones
        __props__.__dict__["connection_draining"] = connection_draining
        __props__.__dict__["connection_draining_timeout"] = connection_draining_timeout
        __props__.__dict__["cross_zone_load_balancing"] = cross_zone_load_balancing
        __props__.__dict__["desync_mitigation_mode"] = desync_mitigation_mode
        __props__.__dict__["dns_name"] = dns_name
        __props__.__dict__["health_check"] = health_check
        __props__.__dict__["idle_timeout"] = idle_timeout
        __props__.__dict__["instances"] = instances
        __props__.__dict__["internal"] = internal
        __props__.__dict__["listeners"] = listeners
        __props__.__dict__["name"] = name
        __props__.__dict__["name_prefix"] = name_prefix
        __props__.__dict__["security_groups"] = security_groups
        __props__.__dict__["source_security_group"] = source_security_group
        __props__.__dict__["source_security_group_id"] = source_security_group_id
        __props__.__dict__["subnets"] = subnets
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["zone_id"] = zone_id
        return LoadBalancer(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessLogs")
    def access_logs(self) -> pulumi.Output[Optional['outputs.LoadBalancerAccessLogs']]:
        """
        An Access Logs block. Access Logs documented below.
        """
        return pulumi.get(self, "access_logs")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        The ARN of the ELB
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> pulumi.Output[Sequence[str]]:
        """
        The AZ's to serve traffic in.
        """
        return pulumi.get(self, "availability_zones")

    @property
    @pulumi.getter(name="connectionDraining")
    def connection_draining(self) -> pulumi.Output[Optional[bool]]:
        """
        Boolean to enable connection draining. Default: `false`
        """
        return pulumi.get(self, "connection_draining")

    @property
    @pulumi.getter(name="connectionDrainingTimeout")
    def connection_draining_timeout(self) -> pulumi.Output[Optional[int]]:
        """
        The time in seconds to allow for connections to drain. Default: `300`
        """
        return pulumi.get(self, "connection_draining_timeout")

    @property
    @pulumi.getter(name="crossZoneLoadBalancing")
    def cross_zone_load_balancing(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable cross-zone load balancing. Default: `true`
        """
        return pulumi.get(self, "cross_zone_load_balancing")

    @property
    @pulumi.getter(name="desyncMitigationMode")
    def desync_mitigation_mode(self) -> pulumi.Output[Optional[str]]:
        """
        Determines how the load balancer handles requests that might pose a security risk to an application due to HTTP desync. Valid values are `monitor`, `defensive` (default), `strictest`.
        """
        return pulumi.get(self, "desync_mitigation_mode")

    @property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> pulumi.Output[str]:
        """
        The DNS name of the ELB
        """
        return pulumi.get(self, "dns_name")

    @property
    @pulumi.getter(name="healthCheck")
    def health_check(self) -> pulumi.Output['outputs.LoadBalancerHealthCheck']:
        """
        A health_check block. Health Check documented below.
        """
        return pulumi.get(self, "health_check")

    @property
    @pulumi.getter(name="idleTimeout")
    def idle_timeout(self) -> pulumi.Output[Optional[int]]:
        """
        The time in seconds that the connection is allowed to be idle. Default: `60`
        """
        return pulumi.get(self, "idle_timeout")

    @property
    @pulumi.getter
    def instances(self) -> pulumi.Output[Sequence[str]]:
        """
        A list of instance ids to place in the ELB pool.
        """
        return pulumi.get(self, "instances")

    @property
    @pulumi.getter
    def internal(self) -> pulumi.Output[bool]:
        """
        If true, ELB will be an internal ELB.
        """
        return pulumi.get(self, "internal")

    @property
    @pulumi.getter
    def listeners(self) -> pulumi.Output[Sequence['outputs.LoadBalancerListener']]:
        """
        A list of listener blocks. Listeners documented below.
        """
        return pulumi.get(self, "listeners")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the ELB. By default generated by this provider.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> pulumi.Output[Optional[str]]:
        """
        Creates a unique name beginning with the specified
        prefix. Conflicts with `name`.
        """
        return pulumi.get(self, "name_prefix")

    @property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> pulumi.Output[Sequence[str]]:
        """
        A list of security group IDs to assign to the ELB.
        Only valid if creating an ELB within a VPC
        """
        return pulumi.get(self, "security_groups")

    @property
    @pulumi.getter(name="sourceSecurityGroup")
    def source_security_group(self) -> pulumi.Output[str]:
        """
        The name of the security group that you can use as
        part of your inbound rules for your load balancer's back-end application
        instances. Use this for Classic or Default VPC only.
        """
        return pulumi.get(self, "source_security_group")

    @property
    @pulumi.getter(name="sourceSecurityGroupId")
    def source_security_group_id(self) -> pulumi.Output[str]:
        """
        The ID of the security group that you can use as
        part of your inbound rules for your load balancer's back-end application
        instances. Only available on ELBs launched in a VPC.
        """
        return pulumi.get(self, "source_security_group_id")

    @property
    @pulumi.getter
    def subnets(self) -> pulumi.Output[Sequence[str]]:
        """
        A list of subnet IDs to attach to the ELB. When an update to subnets will remove all current subnets, this will force a new resource.
        """
        return pulumi.get(self, "subnets")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.

        Exactly one of `availability_zones` or `subnets` must be specified: this
        determines if the ELB exists in a VPC or in EC2-classic.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[str]:
        """
        The canonical hosted zone ID of the ELB (to be used in a Route 53 Alias record)
        """
        return pulumi.get(self, "zone_id")

