# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'BlockPublicAccessConfigurationPermittedPublicSecurityGroupRuleRangeArgs',
    'ClusterAutoTerminationPolicyArgs',
    'ClusterBootstrapActionArgs',
    'ClusterCoreInstanceFleetArgs',
    'ClusterCoreInstanceFleetInstanceTypeConfigArgs',
    'ClusterCoreInstanceFleetInstanceTypeConfigConfigurationArgs',
    'ClusterCoreInstanceFleetInstanceTypeConfigEbsConfigArgs',
    'ClusterCoreInstanceFleetLaunchSpecificationsArgs',
    'ClusterCoreInstanceFleetLaunchSpecificationsOnDemandSpecificationArgs',
    'ClusterCoreInstanceFleetLaunchSpecificationsSpotSpecificationArgs',
    'ClusterCoreInstanceGroupArgs',
    'ClusterCoreInstanceGroupEbsConfigArgs',
    'ClusterEc2AttributesArgs',
    'ClusterKerberosAttributesArgs',
    'ClusterMasterInstanceFleetArgs',
    'ClusterMasterInstanceFleetInstanceTypeConfigArgs',
    'ClusterMasterInstanceFleetInstanceTypeConfigConfigurationArgs',
    'ClusterMasterInstanceFleetInstanceTypeConfigEbsConfigArgs',
    'ClusterMasterInstanceFleetLaunchSpecificationsArgs',
    'ClusterMasterInstanceFleetLaunchSpecificationsOnDemandSpecificationArgs',
    'ClusterMasterInstanceFleetLaunchSpecificationsSpotSpecificationArgs',
    'ClusterMasterInstanceGroupArgs',
    'ClusterMasterInstanceGroupEbsConfigArgs',
    'ClusterPlacementGroupConfigArgs',
    'ClusterStepArgs',
    'ClusterStepHadoopJarStepArgs',
    'InstanceFleetInstanceTypeConfigArgs',
    'InstanceFleetInstanceTypeConfigConfigurationArgs',
    'InstanceFleetInstanceTypeConfigEbsConfigArgs',
    'InstanceFleetLaunchSpecificationsArgs',
    'InstanceFleetLaunchSpecificationsOnDemandSpecificationArgs',
    'InstanceFleetLaunchSpecificationsSpotSpecificationArgs',
    'InstanceGroupEbsConfigArgs',
    'ManagedScalingPolicyComputeLimitArgs',
    'GetReleaseLabelsFiltersArgs',
]

@pulumi.input_type
class BlockPublicAccessConfigurationPermittedPublicSecurityGroupRuleRangeArgs:
    def __init__(__self__, *,
                 max_range: pulumi.Input[int],
                 min_range: pulumi.Input[int]):
        """
        :param pulumi.Input[int] max_range: The final port in the range of TCP ports.
        :param pulumi.Input[int] min_range: The first port in the range of TCP ports.
        """
        pulumi.set(__self__, "max_range", max_range)
        pulumi.set(__self__, "min_range", min_range)

    @property
    @pulumi.getter(name="maxRange")
    def max_range(self) -> pulumi.Input[int]:
        """
        The final port in the range of TCP ports.
        """
        return pulumi.get(self, "max_range")

    @max_range.setter
    def max_range(self, value: pulumi.Input[int]):
        pulumi.set(self, "max_range", value)

    @property
    @pulumi.getter(name="minRange")
    def min_range(self) -> pulumi.Input[int]:
        """
        The first port in the range of TCP ports.
        """
        return pulumi.get(self, "min_range")

    @min_range.setter
    def min_range(self, value: pulumi.Input[int]):
        pulumi.set(self, "min_range", value)


@pulumi.input_type
class ClusterAutoTerminationPolicyArgs:
    def __init__(__self__, *,
                 idle_timeout: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] idle_timeout: Specifies the amount of idle time in seconds after which the cluster automatically terminates. You can specify a minimum of `60` seconds and a maximum of `604800` seconds (seven days).
        """
        if idle_timeout is not None:
            pulumi.set(__self__, "idle_timeout", idle_timeout)

    @property
    @pulumi.getter(name="idleTimeout")
    def idle_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the amount of idle time in seconds after which the cluster automatically terminates. You can specify a minimum of `60` seconds and a maximum of `604800` seconds (seven days).
        """
        return pulumi.get(self, "idle_timeout")

    @idle_timeout.setter
    def idle_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "idle_timeout", value)


@pulumi.input_type
class ClusterBootstrapActionArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 path: pulumi.Input[str],
                 args: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] name: Name of the bootstrap action.
        :param pulumi.Input[str] path: Location of the script to run during a bootstrap action. Can be either a location in Amazon S3 or on a local file system.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] args: List of command line arguments to pass to the bootstrap action script.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "path", path)
        if args is not None:
            pulumi.set(__self__, "args", args)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Name of the bootstrap action.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def path(self) -> pulumi.Input[str]:
        """
        Location of the script to run during a bootstrap action. Can be either a location in Amazon S3 or on a local file system.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: pulumi.Input[str]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def args(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of command line arguments to pass to the bootstrap action script.
        """
        return pulumi.get(self, "args")

    @args.setter
    def args(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "args", value)


@pulumi.input_type
class ClusterCoreInstanceFleetArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None,
                 instance_type_configs: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterCoreInstanceFleetInstanceTypeConfigArgs']]]] = None,
                 launch_specifications: Optional[pulumi.Input['ClusterCoreInstanceFleetLaunchSpecificationsArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 provisioned_on_demand_capacity: Optional[pulumi.Input[int]] = None,
                 provisioned_spot_capacity: Optional[pulumi.Input[int]] = None,
                 target_on_demand_capacity: Optional[pulumi.Input[int]] = None,
                 target_spot_capacity: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] id: ID of the cluster.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterCoreInstanceFleetInstanceTypeConfigArgs']]] instance_type_configs: Configuration block for instance fleet.
        :param pulumi.Input['ClusterCoreInstanceFleetLaunchSpecificationsArgs'] launch_specifications: Configuration block for launch specification.
        :param pulumi.Input[str] name: Friendly name given to the instance fleet.
        :param pulumi.Input[int] target_on_demand_capacity: The target capacity of On-Demand units for the instance fleet, which determines how many On-Demand instances to provision.
        :param pulumi.Input[int] target_spot_capacity: Target capacity of Spot units for the instance fleet, which determines how many Spot instances to provision.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if instance_type_configs is not None:
            pulumi.set(__self__, "instance_type_configs", instance_type_configs)
        if launch_specifications is not None:
            pulumi.set(__self__, "launch_specifications", launch_specifications)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if provisioned_on_demand_capacity is not None:
            pulumi.set(__self__, "provisioned_on_demand_capacity", provisioned_on_demand_capacity)
        if provisioned_spot_capacity is not None:
            pulumi.set(__self__, "provisioned_spot_capacity", provisioned_spot_capacity)
        if target_on_demand_capacity is not None:
            pulumi.set(__self__, "target_on_demand_capacity", target_on_demand_capacity)
        if target_spot_capacity is not None:
            pulumi.set(__self__, "target_spot_capacity", target_spot_capacity)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the cluster.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="instanceTypeConfigs")
    def instance_type_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterCoreInstanceFleetInstanceTypeConfigArgs']]]]:
        """
        Configuration block for instance fleet.
        """
        return pulumi.get(self, "instance_type_configs")

    @instance_type_configs.setter
    def instance_type_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterCoreInstanceFleetInstanceTypeConfigArgs']]]]):
        pulumi.set(self, "instance_type_configs", value)

    @property
    @pulumi.getter(name="launchSpecifications")
    def launch_specifications(self) -> Optional[pulumi.Input['ClusterCoreInstanceFleetLaunchSpecificationsArgs']]:
        """
        Configuration block for launch specification.
        """
        return pulumi.get(self, "launch_specifications")

    @launch_specifications.setter
    def launch_specifications(self, value: Optional[pulumi.Input['ClusterCoreInstanceFleetLaunchSpecificationsArgs']]):
        pulumi.set(self, "launch_specifications", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Friendly name given to the instance fleet.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="provisionedOnDemandCapacity")
    def provisioned_on_demand_capacity(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "provisioned_on_demand_capacity")

    @provisioned_on_demand_capacity.setter
    def provisioned_on_demand_capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "provisioned_on_demand_capacity", value)

    @property
    @pulumi.getter(name="provisionedSpotCapacity")
    def provisioned_spot_capacity(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "provisioned_spot_capacity")

    @provisioned_spot_capacity.setter
    def provisioned_spot_capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "provisioned_spot_capacity", value)

    @property
    @pulumi.getter(name="targetOnDemandCapacity")
    def target_on_demand_capacity(self) -> Optional[pulumi.Input[int]]:
        """
        The target capacity of On-Demand units for the instance fleet, which determines how many On-Demand instances to provision.
        """
        return pulumi.get(self, "target_on_demand_capacity")

    @target_on_demand_capacity.setter
    def target_on_demand_capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "target_on_demand_capacity", value)

    @property
    @pulumi.getter(name="targetSpotCapacity")
    def target_spot_capacity(self) -> Optional[pulumi.Input[int]]:
        """
        Target capacity of Spot units for the instance fleet, which determines how many Spot instances to provision.
        """
        return pulumi.get(self, "target_spot_capacity")

    @target_spot_capacity.setter
    def target_spot_capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "target_spot_capacity", value)


@pulumi.input_type
class ClusterCoreInstanceFleetInstanceTypeConfigArgs:
    def __init__(__self__, *,
                 instance_type: pulumi.Input[str],
                 bid_price: Optional[pulumi.Input[str]] = None,
                 bid_price_as_percentage_of_on_demand_price: Optional[pulumi.Input[float]] = None,
                 configurations: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterCoreInstanceFleetInstanceTypeConfigConfigurationArgs']]]] = None,
                 ebs_configs: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterCoreInstanceFleetInstanceTypeConfigEbsConfigArgs']]]] = None,
                 weighted_capacity: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] instance_type: EC2 instance type, such as m4.xlarge.
        :param pulumi.Input[str] bid_price: Bid price for each EC2 Spot instance type as defined by `instance_type`. Expressed in USD. If neither `bid_price` nor `bid_price_as_percentage_of_on_demand_price` is provided, `bid_price_as_percentage_of_on_demand_price` defaults to 100%.
        :param pulumi.Input[float] bid_price_as_percentage_of_on_demand_price: Bid price, as a percentage of On-Demand price, for each EC2 Spot instance as defined by `instance_type`. Expressed as a number (for example, 20 specifies 20%). If neither `bid_price` nor `bid_price_as_percentage_of_on_demand_price` is provided, `bid_price_as_percentage_of_on_demand_price` defaults to 100%.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterCoreInstanceFleetInstanceTypeConfigConfigurationArgs']]] configurations: Configuration classification that applies when provisioning cluster instances, which can include configurations for applications and software that run on the cluster. List of `configuration` blocks.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterCoreInstanceFleetInstanceTypeConfigEbsConfigArgs']]] ebs_configs: Configuration block(s) for EBS volumes attached to each instance in the instance group. Detailed below.
        :param pulumi.Input[int] weighted_capacity: Number of units that a provisioned instance of this type provides toward fulfilling the target capacities defined in `emr.InstanceFleet`.
        """
        pulumi.set(__self__, "instance_type", instance_type)
        if bid_price is not None:
            pulumi.set(__self__, "bid_price", bid_price)
        if bid_price_as_percentage_of_on_demand_price is not None:
            pulumi.set(__self__, "bid_price_as_percentage_of_on_demand_price", bid_price_as_percentage_of_on_demand_price)
        if configurations is not None:
            pulumi.set(__self__, "configurations", configurations)
        if ebs_configs is not None:
            pulumi.set(__self__, "ebs_configs", ebs_configs)
        if weighted_capacity is not None:
            pulumi.set(__self__, "weighted_capacity", weighted_capacity)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Input[str]:
        """
        EC2 instance type, such as m4.xlarge.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter(name="bidPrice")
    def bid_price(self) -> Optional[pulumi.Input[str]]:
        """
        Bid price for each EC2 Spot instance type as defined by `instance_type`. Expressed in USD. If neither `bid_price` nor `bid_price_as_percentage_of_on_demand_price` is provided, `bid_price_as_percentage_of_on_demand_price` defaults to 100%.
        """
        return pulumi.get(self, "bid_price")

    @bid_price.setter
    def bid_price(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bid_price", value)

    @property
    @pulumi.getter(name="bidPriceAsPercentageOfOnDemandPrice")
    def bid_price_as_percentage_of_on_demand_price(self) -> Optional[pulumi.Input[float]]:
        """
        Bid price, as a percentage of On-Demand price, for each EC2 Spot instance as defined by `instance_type`. Expressed as a number (for example, 20 specifies 20%). If neither `bid_price` nor `bid_price_as_percentage_of_on_demand_price` is provided, `bid_price_as_percentage_of_on_demand_price` defaults to 100%.
        """
        return pulumi.get(self, "bid_price_as_percentage_of_on_demand_price")

    @bid_price_as_percentage_of_on_demand_price.setter
    def bid_price_as_percentage_of_on_demand_price(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "bid_price_as_percentage_of_on_demand_price", value)

    @property
    @pulumi.getter
    def configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterCoreInstanceFleetInstanceTypeConfigConfigurationArgs']]]]:
        """
        Configuration classification that applies when provisioning cluster instances, which can include configurations for applications and software that run on the cluster. List of `configuration` blocks.
        """
        return pulumi.get(self, "configurations")

    @configurations.setter
    def configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterCoreInstanceFleetInstanceTypeConfigConfigurationArgs']]]]):
        pulumi.set(self, "configurations", value)

    @property
    @pulumi.getter(name="ebsConfigs")
    def ebs_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterCoreInstanceFleetInstanceTypeConfigEbsConfigArgs']]]]:
        """
        Configuration block(s) for EBS volumes attached to each instance in the instance group. Detailed below.
        """
        return pulumi.get(self, "ebs_configs")

    @ebs_configs.setter
    def ebs_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterCoreInstanceFleetInstanceTypeConfigEbsConfigArgs']]]]):
        pulumi.set(self, "ebs_configs", value)

    @property
    @pulumi.getter(name="weightedCapacity")
    def weighted_capacity(self) -> Optional[pulumi.Input[int]]:
        """
        Number of units that a provisioned instance of this type provides toward fulfilling the target capacities defined in `emr.InstanceFleet`.
        """
        return pulumi.get(self, "weighted_capacity")

    @weighted_capacity.setter
    def weighted_capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "weighted_capacity", value)


@pulumi.input_type
class ClusterCoreInstanceFleetInstanceTypeConfigConfigurationArgs:
    def __init__(__self__, *,
                 classification: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] classification: Classification within a configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: Map of properties specified within a configuration classification.
        """
        if classification is not None:
            pulumi.set(__self__, "classification", classification)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter
    def classification(self) -> Optional[pulumi.Input[str]]:
        """
        Classification within a configuration.
        """
        return pulumi.get(self, "classification")

    @classification.setter
    def classification(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "classification", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Map of properties specified within a configuration classification.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "properties", value)


@pulumi.input_type
class ClusterCoreInstanceFleetInstanceTypeConfigEbsConfigArgs:
    def __init__(__self__, *,
                 size: pulumi.Input[int],
                 type: pulumi.Input[str],
                 iops: Optional[pulumi.Input[int]] = None,
                 volumes_per_instance: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] size: Volume size, in gibibytes (GiB).
        :param pulumi.Input[str] type: Volume type. Valid options are `gp3`, `gp2`, `io1`, `standard`, `st1` and `sc1`. See [EBS Volume Types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html).
        :param pulumi.Input[int] iops: Number of I/O operations per second (IOPS) that the volume supports.
        :param pulumi.Input[int] volumes_per_instance: Number of EBS volumes with this configuration to attach to each EC2 instance in the instance group (default is 1).
        """
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "type", type)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if volumes_per_instance is not None:
            pulumi.set(__self__, "volumes_per_instance", volumes_per_instance)

    @property
    @pulumi.getter
    def size(self) -> pulumi.Input[int]:
        """
        Volume size, in gibibytes (GiB).
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: pulumi.Input[int]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Volume type. Valid options are `gp3`, `gp2`, `io1`, `standard`, `st1` and `sc1`. See [EBS Volume Types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html).
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def iops(self) -> Optional[pulumi.Input[int]]:
        """
        Number of I/O operations per second (IOPS) that the volume supports.
        """
        return pulumi.get(self, "iops")

    @iops.setter
    def iops(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "iops", value)

    @property
    @pulumi.getter(name="volumesPerInstance")
    def volumes_per_instance(self) -> Optional[pulumi.Input[int]]:
        """
        Number of EBS volumes with this configuration to attach to each EC2 instance in the instance group (default is 1).
        """
        return pulumi.get(self, "volumes_per_instance")

    @volumes_per_instance.setter
    def volumes_per_instance(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "volumes_per_instance", value)


@pulumi.input_type
class ClusterCoreInstanceFleetLaunchSpecificationsArgs:
    def __init__(__self__, *,
                 on_demand_specifications: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterCoreInstanceFleetLaunchSpecificationsOnDemandSpecificationArgs']]]] = None,
                 spot_specifications: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterCoreInstanceFleetLaunchSpecificationsSpotSpecificationArgs']]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['ClusterCoreInstanceFleetLaunchSpecificationsOnDemandSpecificationArgs']]] on_demand_specifications: Configuration block for on demand instances launch specifications.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterCoreInstanceFleetLaunchSpecificationsSpotSpecificationArgs']]] spot_specifications: Configuration block for spot instances launch specifications.
        """
        if on_demand_specifications is not None:
            pulumi.set(__self__, "on_demand_specifications", on_demand_specifications)
        if spot_specifications is not None:
            pulumi.set(__self__, "spot_specifications", spot_specifications)

    @property
    @pulumi.getter(name="onDemandSpecifications")
    def on_demand_specifications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterCoreInstanceFleetLaunchSpecificationsOnDemandSpecificationArgs']]]]:
        """
        Configuration block for on demand instances launch specifications.
        """
        return pulumi.get(self, "on_demand_specifications")

    @on_demand_specifications.setter
    def on_demand_specifications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterCoreInstanceFleetLaunchSpecificationsOnDemandSpecificationArgs']]]]):
        pulumi.set(self, "on_demand_specifications", value)

    @property
    @pulumi.getter(name="spotSpecifications")
    def spot_specifications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterCoreInstanceFleetLaunchSpecificationsSpotSpecificationArgs']]]]:
        """
        Configuration block for spot instances launch specifications.
        """
        return pulumi.get(self, "spot_specifications")

    @spot_specifications.setter
    def spot_specifications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterCoreInstanceFleetLaunchSpecificationsSpotSpecificationArgs']]]]):
        pulumi.set(self, "spot_specifications", value)


@pulumi.input_type
class ClusterCoreInstanceFleetLaunchSpecificationsOnDemandSpecificationArgs:
    def __init__(__self__, *,
                 allocation_strategy: pulumi.Input[str]):
        """
        :param pulumi.Input[str] allocation_strategy: Specifies the strategy to use in launching On-Demand instance fleets. Currently, the only option is `lowest-price` (the default), which launches the lowest price first.
        """
        pulumi.set(__self__, "allocation_strategy", allocation_strategy)

    @property
    @pulumi.getter(name="allocationStrategy")
    def allocation_strategy(self) -> pulumi.Input[str]:
        """
        Specifies the strategy to use in launching On-Demand instance fleets. Currently, the only option is `lowest-price` (the default), which launches the lowest price first.
        """
        return pulumi.get(self, "allocation_strategy")

    @allocation_strategy.setter
    def allocation_strategy(self, value: pulumi.Input[str]):
        pulumi.set(self, "allocation_strategy", value)


@pulumi.input_type
class ClusterCoreInstanceFleetLaunchSpecificationsSpotSpecificationArgs:
    def __init__(__self__, *,
                 allocation_strategy: pulumi.Input[str],
                 timeout_action: pulumi.Input[str],
                 timeout_duration_minutes: pulumi.Input[int],
                 block_duration_minutes: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] allocation_strategy: Specifies the strategy to use in launching Spot instance fleets. Valid values include `capacity-optimized`, `diversified`, `lowest-price`, `price-capacity-optimized`. See the [AWS documentation](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-instance-fleet.html#emr-instance-fleet-allocation-strategy) for details on each strategy type.
        :param pulumi.Input[str] timeout_action: Action to take when TargetSpotCapacity has not been fulfilled when the TimeoutDurationMinutes has expired; that is, when all Spot instances could not be provisioned within the Spot provisioning timeout. Valid values are `TERMINATE_CLUSTER` and `SWITCH_TO_ON_DEMAND`. SWITCH_TO_ON_DEMAND specifies that if no Spot instances are available, On-Demand Instances should be provisioned to fulfill any remaining Spot capacity.
        :param pulumi.Input[int] timeout_duration_minutes: Spot provisioning timeout period in minutes. If Spot instances are not provisioned within this time period, the TimeOutAction is taken. Minimum value is 5 and maximum value is 1440. The timeout applies only during initial provisioning, when the cluster is first created.
        :param pulumi.Input[int] block_duration_minutes: Defined duration for Spot instances (also known as Spot blocks) in minutes. When specified, the Spot instance does not terminate before the defined duration expires, and defined duration pricing for Spot instances applies. Valid values are 60, 120, 180, 240, 300, or 360. The duration period starts as soon as a Spot instance receives its instance ID. At the end of the duration, Amazon EC2 marks the Spot instance for termination and provides a Spot instance termination notice, which gives the instance a two-minute warning before it terminates.
        """
        pulumi.set(__self__, "allocation_strategy", allocation_strategy)
        pulumi.set(__self__, "timeout_action", timeout_action)
        pulumi.set(__self__, "timeout_duration_minutes", timeout_duration_minutes)
        if block_duration_minutes is not None:
            pulumi.set(__self__, "block_duration_minutes", block_duration_minutes)

    @property
    @pulumi.getter(name="allocationStrategy")
    def allocation_strategy(self) -> pulumi.Input[str]:
        """
        Specifies the strategy to use in launching Spot instance fleets. Valid values include `capacity-optimized`, `diversified`, `lowest-price`, `price-capacity-optimized`. See the [AWS documentation](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-instance-fleet.html#emr-instance-fleet-allocation-strategy) for details on each strategy type.
        """
        return pulumi.get(self, "allocation_strategy")

    @allocation_strategy.setter
    def allocation_strategy(self, value: pulumi.Input[str]):
        pulumi.set(self, "allocation_strategy", value)

    @property
    @pulumi.getter(name="timeoutAction")
    def timeout_action(self) -> pulumi.Input[str]:
        """
        Action to take when TargetSpotCapacity has not been fulfilled when the TimeoutDurationMinutes has expired; that is, when all Spot instances could not be provisioned within the Spot provisioning timeout. Valid values are `TERMINATE_CLUSTER` and `SWITCH_TO_ON_DEMAND`. SWITCH_TO_ON_DEMAND specifies that if no Spot instances are available, On-Demand Instances should be provisioned to fulfill any remaining Spot capacity.
        """
        return pulumi.get(self, "timeout_action")

    @timeout_action.setter
    def timeout_action(self, value: pulumi.Input[str]):
        pulumi.set(self, "timeout_action", value)

    @property
    @pulumi.getter(name="timeoutDurationMinutes")
    def timeout_duration_minutes(self) -> pulumi.Input[int]:
        """
        Spot provisioning timeout period in minutes. If Spot instances are not provisioned within this time period, the TimeOutAction is taken. Minimum value is 5 and maximum value is 1440. The timeout applies only during initial provisioning, when the cluster is first created.
        """
        return pulumi.get(self, "timeout_duration_minutes")

    @timeout_duration_minutes.setter
    def timeout_duration_minutes(self, value: pulumi.Input[int]):
        pulumi.set(self, "timeout_duration_minutes", value)

    @property
    @pulumi.getter(name="blockDurationMinutes")
    def block_duration_minutes(self) -> Optional[pulumi.Input[int]]:
        """
        Defined duration for Spot instances (also known as Spot blocks) in minutes. When specified, the Spot instance does not terminate before the defined duration expires, and defined duration pricing for Spot instances applies. Valid values are 60, 120, 180, 240, 300, or 360. The duration period starts as soon as a Spot instance receives its instance ID. At the end of the duration, Amazon EC2 marks the Spot instance for termination and provides a Spot instance termination notice, which gives the instance a two-minute warning before it terminates.
        """
        return pulumi.get(self, "block_duration_minutes")

    @block_duration_minutes.setter
    def block_duration_minutes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "block_duration_minutes", value)


@pulumi.input_type
class ClusterCoreInstanceGroupArgs:
    def __init__(__self__, *,
                 instance_type: pulumi.Input[str],
                 autoscaling_policy: Optional[pulumi.Input[str]] = None,
                 bid_price: Optional[pulumi.Input[str]] = None,
                 ebs_configs: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterCoreInstanceGroupEbsConfigArgs']]]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 instance_count: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] instance_type: EC2 instance type for all instances in the instance group.
        :param pulumi.Input[str] autoscaling_policy: String containing the [EMR Auto Scaling Policy](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-automatic-scaling.html) JSON.
        :param pulumi.Input[str] bid_price: Bid price for each EC2 instance in the instance group, expressed in USD. By setting this attribute, the instance group is being declared as a Spot Instance, and will implicitly create a Spot request. Leave this blank to use On-Demand Instances.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterCoreInstanceGroupEbsConfigArgs']]] ebs_configs: Configuration block(s) for EBS volumes attached to each instance in the instance group. Detailed below.
        :param pulumi.Input[str] id: ID of the cluster.
        :param pulumi.Input[int] instance_count: Target number of instances for the instance group. Must be at least 1. Defaults to 1.
        :param pulumi.Input[str] name: Friendly name given to the instance group.
        """
        pulumi.set(__self__, "instance_type", instance_type)
        if autoscaling_policy is not None:
            pulumi.set(__self__, "autoscaling_policy", autoscaling_policy)
        if bid_price is not None:
            pulumi.set(__self__, "bid_price", bid_price)
        if ebs_configs is not None:
            pulumi.set(__self__, "ebs_configs", ebs_configs)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if instance_count is not None:
            pulumi.set(__self__, "instance_count", instance_count)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Input[str]:
        """
        EC2 instance type for all instances in the instance group.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter(name="autoscalingPolicy")
    def autoscaling_policy(self) -> Optional[pulumi.Input[str]]:
        """
        String containing the [EMR Auto Scaling Policy](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-automatic-scaling.html) JSON.
        """
        return pulumi.get(self, "autoscaling_policy")

    @autoscaling_policy.setter
    def autoscaling_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "autoscaling_policy", value)

    @property
    @pulumi.getter(name="bidPrice")
    def bid_price(self) -> Optional[pulumi.Input[str]]:
        """
        Bid price for each EC2 instance in the instance group, expressed in USD. By setting this attribute, the instance group is being declared as a Spot Instance, and will implicitly create a Spot request. Leave this blank to use On-Demand Instances.
        """
        return pulumi.get(self, "bid_price")

    @bid_price.setter
    def bid_price(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bid_price", value)

    @property
    @pulumi.getter(name="ebsConfigs")
    def ebs_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterCoreInstanceGroupEbsConfigArgs']]]]:
        """
        Configuration block(s) for EBS volumes attached to each instance in the instance group. Detailed below.
        """
        return pulumi.get(self, "ebs_configs")

    @ebs_configs.setter
    def ebs_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterCoreInstanceGroupEbsConfigArgs']]]]):
        pulumi.set(self, "ebs_configs", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the cluster.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> Optional[pulumi.Input[int]]:
        """
        Target number of instances for the instance group. Must be at least 1. Defaults to 1.
        """
        return pulumi.get(self, "instance_count")

    @instance_count.setter
    def instance_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "instance_count", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Friendly name given to the instance group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class ClusterCoreInstanceGroupEbsConfigArgs:
    def __init__(__self__, *,
                 size: pulumi.Input[int],
                 type: pulumi.Input[str],
                 iops: Optional[pulumi.Input[int]] = None,
                 throughput: Optional[pulumi.Input[int]] = None,
                 volumes_per_instance: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] size: Volume size, in gibibytes (GiB).
        :param pulumi.Input[str] type: Volume type. Valid options are `gp3`, `gp2`, `io1`, `standard`, `st1` and `sc1`. See [EBS Volume Types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html).
        :param pulumi.Input[int] iops: Number of I/O operations per second (IOPS) that the volume supports.
        :param pulumi.Input[int] throughput: The throughput, in mebibyte per second (MiB/s).
        :param pulumi.Input[int] volumes_per_instance: Number of EBS volumes with this configuration to attach to each EC2 instance in the instance group (default is 1).
        """
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "type", type)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if throughput is not None:
            pulumi.set(__self__, "throughput", throughput)
        if volumes_per_instance is not None:
            pulumi.set(__self__, "volumes_per_instance", volumes_per_instance)

    @property
    @pulumi.getter
    def size(self) -> pulumi.Input[int]:
        """
        Volume size, in gibibytes (GiB).
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: pulumi.Input[int]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Volume type. Valid options are `gp3`, `gp2`, `io1`, `standard`, `st1` and `sc1`. See [EBS Volume Types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html).
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def iops(self) -> Optional[pulumi.Input[int]]:
        """
        Number of I/O operations per second (IOPS) that the volume supports.
        """
        return pulumi.get(self, "iops")

    @iops.setter
    def iops(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "iops", value)

    @property
    @pulumi.getter
    def throughput(self) -> Optional[pulumi.Input[int]]:
        """
        The throughput, in mebibyte per second (MiB/s).
        """
        return pulumi.get(self, "throughput")

    @throughput.setter
    def throughput(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "throughput", value)

    @property
    @pulumi.getter(name="volumesPerInstance")
    def volumes_per_instance(self) -> Optional[pulumi.Input[int]]:
        """
        Number of EBS volumes with this configuration to attach to each EC2 instance in the instance group (default is 1).
        """
        return pulumi.get(self, "volumes_per_instance")

    @volumes_per_instance.setter
    def volumes_per_instance(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "volumes_per_instance", value)


@pulumi.input_type
class ClusterEc2AttributesArgs:
    def __init__(__self__, *,
                 instance_profile: pulumi.Input[str],
                 additional_master_security_groups: Optional[pulumi.Input[str]] = None,
                 additional_slave_security_groups: Optional[pulumi.Input[str]] = None,
                 emr_managed_master_security_group: Optional[pulumi.Input[str]] = None,
                 emr_managed_slave_security_group: Optional[pulumi.Input[str]] = None,
                 key_name: Optional[pulumi.Input[str]] = None,
                 service_access_security_group: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] instance_profile: Instance Profile for EC2 instances of the cluster assume this role.
        :param pulumi.Input[str] additional_master_security_groups: String containing a comma separated list of additional Amazon EC2 security group IDs for the master node.
        :param pulumi.Input[str] additional_slave_security_groups: String containing a comma separated list of additional Amazon EC2 security group IDs for the slave nodes as a comma separated string.
        :param pulumi.Input[str] emr_managed_master_security_group: Identifier of the Amazon EC2 EMR-Managed security group for the master node.
        :param pulumi.Input[str] emr_managed_slave_security_group: Identifier of the Amazon EC2 EMR-Managed security group for the slave nodes.
        :param pulumi.Input[str] key_name: Amazon EC2 key pair that can be used to ssh to the master node as the user called `hadoop`.
        :param pulumi.Input[str] service_access_security_group: Identifier of the Amazon EC2 service-access security group - required when the cluster runs on a private subnet.
        :param pulumi.Input[str] subnet_id: VPC subnet id where you want the job flow to launch. Cannot specify the `cc1.4xlarge` instance type for nodes of a job flow launched in an Amazon VPC.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnet_ids: List of VPC subnet id-s where you want the job flow to launch.  Amazon EMR identifies the best Availability Zone to launch instances according to your fleet specifications.
               
               > **NOTE on EMR-Managed security groups:** These security groups will have any missing inbound or outbound access rules added and maintained by AWS, to ensure proper communication between instances in a cluster. The EMR service will maintain these rules for groups provided in `emr_managed_master_security_group` and `emr_managed_slave_security_group`; attempts to remove the required rules may succeed, only for the EMR service to re-add them in a matter of minutes. This may cause this provider to fail to destroy an environment that contains an EMR cluster, because the EMR service does not revoke rules added on deletion, leaving a cyclic dependency between the security groups that prevents their deletion. To avoid this, use the `revoke_rules_on_delete` optional attribute for any Security Group used in `emr_managed_master_security_group` and `emr_managed_slave_security_group`. See [Amazon EMR-Managed Security Groups](http://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-man-sec-groups.html) for more information about the EMR-managed security group rules.
        """
        pulumi.set(__self__, "instance_profile", instance_profile)
        if additional_master_security_groups is not None:
            pulumi.set(__self__, "additional_master_security_groups", additional_master_security_groups)
        if additional_slave_security_groups is not None:
            pulumi.set(__self__, "additional_slave_security_groups", additional_slave_security_groups)
        if emr_managed_master_security_group is not None:
            pulumi.set(__self__, "emr_managed_master_security_group", emr_managed_master_security_group)
        if emr_managed_slave_security_group is not None:
            pulumi.set(__self__, "emr_managed_slave_security_group", emr_managed_slave_security_group)
        if key_name is not None:
            pulumi.set(__self__, "key_name", key_name)
        if service_access_security_group is not None:
            pulumi.set(__self__, "service_access_security_group", service_access_security_group)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if subnet_ids is not None:
            pulumi.set(__self__, "subnet_ids", subnet_ids)

    @property
    @pulumi.getter(name="instanceProfile")
    def instance_profile(self) -> pulumi.Input[str]:
        """
        Instance Profile for EC2 instances of the cluster assume this role.
        """
        return pulumi.get(self, "instance_profile")

    @instance_profile.setter
    def instance_profile(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_profile", value)

    @property
    @pulumi.getter(name="additionalMasterSecurityGroups")
    def additional_master_security_groups(self) -> Optional[pulumi.Input[str]]:
        """
        String containing a comma separated list of additional Amazon EC2 security group IDs for the master node.
        """
        return pulumi.get(self, "additional_master_security_groups")

    @additional_master_security_groups.setter
    def additional_master_security_groups(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "additional_master_security_groups", value)

    @property
    @pulumi.getter(name="additionalSlaveSecurityGroups")
    def additional_slave_security_groups(self) -> Optional[pulumi.Input[str]]:
        """
        String containing a comma separated list of additional Amazon EC2 security group IDs for the slave nodes as a comma separated string.
        """
        return pulumi.get(self, "additional_slave_security_groups")

    @additional_slave_security_groups.setter
    def additional_slave_security_groups(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "additional_slave_security_groups", value)

    @property
    @pulumi.getter(name="emrManagedMasterSecurityGroup")
    def emr_managed_master_security_group(self) -> Optional[pulumi.Input[str]]:
        """
        Identifier of the Amazon EC2 EMR-Managed security group for the master node.
        """
        return pulumi.get(self, "emr_managed_master_security_group")

    @emr_managed_master_security_group.setter
    def emr_managed_master_security_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "emr_managed_master_security_group", value)

    @property
    @pulumi.getter(name="emrManagedSlaveSecurityGroup")
    def emr_managed_slave_security_group(self) -> Optional[pulumi.Input[str]]:
        """
        Identifier of the Amazon EC2 EMR-Managed security group for the slave nodes.
        """
        return pulumi.get(self, "emr_managed_slave_security_group")

    @emr_managed_slave_security_group.setter
    def emr_managed_slave_security_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "emr_managed_slave_security_group", value)

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> Optional[pulumi.Input[str]]:
        """
        Amazon EC2 key pair that can be used to ssh to the master node as the user called `hadoop`.
        """
        return pulumi.get(self, "key_name")

    @key_name.setter
    def key_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_name", value)

    @property
    @pulumi.getter(name="serviceAccessSecurityGroup")
    def service_access_security_group(self) -> Optional[pulumi.Input[str]]:
        """
        Identifier of the Amazon EC2 service-access security group - required when the cluster runs on a private subnet.
        """
        return pulumi.get(self, "service_access_security_group")

    @service_access_security_group.setter
    def service_access_security_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_access_security_group", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        VPC subnet id where you want the job flow to launch. Cannot specify the `cc1.4xlarge` instance type for nodes of a job flow launched in an Amazon VPC.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of VPC subnet id-s where you want the job flow to launch.  Amazon EMR identifies the best Availability Zone to launch instances according to your fleet specifications.

        > **NOTE on EMR-Managed security groups:** These security groups will have any missing inbound or outbound access rules added and maintained by AWS, to ensure proper communication between instances in a cluster. The EMR service will maintain these rules for groups provided in `emr_managed_master_security_group` and `emr_managed_slave_security_group`; attempts to remove the required rules may succeed, only for the EMR service to re-add them in a matter of minutes. This may cause this provider to fail to destroy an environment that contains an EMR cluster, because the EMR service does not revoke rules added on deletion, leaving a cyclic dependency between the security groups that prevents their deletion. To avoid this, use the `revoke_rules_on_delete` optional attribute for any Security Group used in `emr_managed_master_security_group` and `emr_managed_slave_security_group`. See [Amazon EMR-Managed Security Groups](http://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-man-sec-groups.html) for more information about the EMR-managed security group rules.
        """
        return pulumi.get(self, "subnet_ids")

    @subnet_ids.setter
    def subnet_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "subnet_ids", value)


@pulumi.input_type
class ClusterKerberosAttributesArgs:
    def __init__(__self__, *,
                 kdc_admin_password: pulumi.Input[str],
                 realm: pulumi.Input[str],
                 ad_domain_join_password: Optional[pulumi.Input[str]] = None,
                 ad_domain_join_user: Optional[pulumi.Input[str]] = None,
                 cross_realm_trust_principal_password: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] kdc_admin_password: Password used within the cluster for the kadmin service on the cluster-dedicated KDC, which maintains Kerberos principals, password policies, and keytabs for the cluster. This provider cannot perform drift detection of this configuration.
        :param pulumi.Input[str] realm: Name of the Kerberos realm to which all nodes in a cluster belong. For example, `EC2.INTERNAL`
        :param pulumi.Input[str] ad_domain_join_password: Active Directory password for `ad_domain_join_user`. This provider cannot perform drift detection of this configuration.
        :param pulumi.Input[str] ad_domain_join_user: Required only when establishing a cross-realm trust with an Active Directory domain. A user with sufficient privileges to join resources to the domain. This provider cannot perform drift detection of this configuration.
        :param pulumi.Input[str] cross_realm_trust_principal_password: Required only when establishing a cross-realm trust with a KDC in a different realm. The cross-realm principal password, which must be identical across realms. This provider cannot perform drift detection of this configuration.
        """
        pulumi.set(__self__, "kdc_admin_password", kdc_admin_password)
        pulumi.set(__self__, "realm", realm)
        if ad_domain_join_password is not None:
            pulumi.set(__self__, "ad_domain_join_password", ad_domain_join_password)
        if ad_domain_join_user is not None:
            pulumi.set(__self__, "ad_domain_join_user", ad_domain_join_user)
        if cross_realm_trust_principal_password is not None:
            pulumi.set(__self__, "cross_realm_trust_principal_password", cross_realm_trust_principal_password)

    @property
    @pulumi.getter(name="kdcAdminPassword")
    def kdc_admin_password(self) -> pulumi.Input[str]:
        """
        Password used within the cluster for the kadmin service on the cluster-dedicated KDC, which maintains Kerberos principals, password policies, and keytabs for the cluster. This provider cannot perform drift detection of this configuration.
        """
        return pulumi.get(self, "kdc_admin_password")

    @kdc_admin_password.setter
    def kdc_admin_password(self, value: pulumi.Input[str]):
        pulumi.set(self, "kdc_admin_password", value)

    @property
    @pulumi.getter
    def realm(self) -> pulumi.Input[str]:
        """
        Name of the Kerberos realm to which all nodes in a cluster belong. For example, `EC2.INTERNAL`
        """
        return pulumi.get(self, "realm")

    @realm.setter
    def realm(self, value: pulumi.Input[str]):
        pulumi.set(self, "realm", value)

    @property
    @pulumi.getter(name="adDomainJoinPassword")
    def ad_domain_join_password(self) -> Optional[pulumi.Input[str]]:
        """
        Active Directory password for `ad_domain_join_user`. This provider cannot perform drift detection of this configuration.
        """
        return pulumi.get(self, "ad_domain_join_password")

    @ad_domain_join_password.setter
    def ad_domain_join_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ad_domain_join_password", value)

    @property
    @pulumi.getter(name="adDomainJoinUser")
    def ad_domain_join_user(self) -> Optional[pulumi.Input[str]]:
        """
        Required only when establishing a cross-realm trust with an Active Directory domain. A user with sufficient privileges to join resources to the domain. This provider cannot perform drift detection of this configuration.
        """
        return pulumi.get(self, "ad_domain_join_user")

    @ad_domain_join_user.setter
    def ad_domain_join_user(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ad_domain_join_user", value)

    @property
    @pulumi.getter(name="crossRealmTrustPrincipalPassword")
    def cross_realm_trust_principal_password(self) -> Optional[pulumi.Input[str]]:
        """
        Required only when establishing a cross-realm trust with a KDC in a different realm. The cross-realm principal password, which must be identical across realms. This provider cannot perform drift detection of this configuration.
        """
        return pulumi.get(self, "cross_realm_trust_principal_password")

    @cross_realm_trust_principal_password.setter
    def cross_realm_trust_principal_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cross_realm_trust_principal_password", value)


@pulumi.input_type
class ClusterMasterInstanceFleetArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None,
                 instance_type_configs: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterMasterInstanceFleetInstanceTypeConfigArgs']]]] = None,
                 launch_specifications: Optional[pulumi.Input['ClusterMasterInstanceFleetLaunchSpecificationsArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 provisioned_on_demand_capacity: Optional[pulumi.Input[int]] = None,
                 provisioned_spot_capacity: Optional[pulumi.Input[int]] = None,
                 target_on_demand_capacity: Optional[pulumi.Input[int]] = None,
                 target_spot_capacity: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] id: ID of the cluster.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterMasterInstanceFleetInstanceTypeConfigArgs']]] instance_type_configs: Configuration block for instance fleet.
        :param pulumi.Input['ClusterMasterInstanceFleetLaunchSpecificationsArgs'] launch_specifications: Configuration block for launch specification.
        :param pulumi.Input[str] name: Friendly name given to the instance fleet.
        :param pulumi.Input[int] target_on_demand_capacity: Target capacity of On-Demand units for the instance fleet, which determines how many On-Demand instances to provision.
        :param pulumi.Input[int] target_spot_capacity: Target capacity of Spot units for the instance fleet, which determines how many Spot instances to provision.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if instance_type_configs is not None:
            pulumi.set(__self__, "instance_type_configs", instance_type_configs)
        if launch_specifications is not None:
            pulumi.set(__self__, "launch_specifications", launch_specifications)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if provisioned_on_demand_capacity is not None:
            pulumi.set(__self__, "provisioned_on_demand_capacity", provisioned_on_demand_capacity)
        if provisioned_spot_capacity is not None:
            pulumi.set(__self__, "provisioned_spot_capacity", provisioned_spot_capacity)
        if target_on_demand_capacity is not None:
            pulumi.set(__self__, "target_on_demand_capacity", target_on_demand_capacity)
        if target_spot_capacity is not None:
            pulumi.set(__self__, "target_spot_capacity", target_spot_capacity)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the cluster.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="instanceTypeConfigs")
    def instance_type_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterMasterInstanceFleetInstanceTypeConfigArgs']]]]:
        """
        Configuration block for instance fleet.
        """
        return pulumi.get(self, "instance_type_configs")

    @instance_type_configs.setter
    def instance_type_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterMasterInstanceFleetInstanceTypeConfigArgs']]]]):
        pulumi.set(self, "instance_type_configs", value)

    @property
    @pulumi.getter(name="launchSpecifications")
    def launch_specifications(self) -> Optional[pulumi.Input['ClusterMasterInstanceFleetLaunchSpecificationsArgs']]:
        """
        Configuration block for launch specification.
        """
        return pulumi.get(self, "launch_specifications")

    @launch_specifications.setter
    def launch_specifications(self, value: Optional[pulumi.Input['ClusterMasterInstanceFleetLaunchSpecificationsArgs']]):
        pulumi.set(self, "launch_specifications", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Friendly name given to the instance fleet.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="provisionedOnDemandCapacity")
    def provisioned_on_demand_capacity(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "provisioned_on_demand_capacity")

    @provisioned_on_demand_capacity.setter
    def provisioned_on_demand_capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "provisioned_on_demand_capacity", value)

    @property
    @pulumi.getter(name="provisionedSpotCapacity")
    def provisioned_spot_capacity(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "provisioned_spot_capacity")

    @provisioned_spot_capacity.setter
    def provisioned_spot_capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "provisioned_spot_capacity", value)

    @property
    @pulumi.getter(name="targetOnDemandCapacity")
    def target_on_demand_capacity(self) -> Optional[pulumi.Input[int]]:
        """
        Target capacity of On-Demand units for the instance fleet, which determines how many On-Demand instances to provision.
        """
        return pulumi.get(self, "target_on_demand_capacity")

    @target_on_demand_capacity.setter
    def target_on_demand_capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "target_on_demand_capacity", value)

    @property
    @pulumi.getter(name="targetSpotCapacity")
    def target_spot_capacity(self) -> Optional[pulumi.Input[int]]:
        """
        Target capacity of Spot units for the instance fleet, which determines how many Spot instances to provision.
        """
        return pulumi.get(self, "target_spot_capacity")

    @target_spot_capacity.setter
    def target_spot_capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "target_spot_capacity", value)


@pulumi.input_type
class ClusterMasterInstanceFleetInstanceTypeConfigArgs:
    def __init__(__self__, *,
                 instance_type: pulumi.Input[str],
                 bid_price: Optional[pulumi.Input[str]] = None,
                 bid_price_as_percentage_of_on_demand_price: Optional[pulumi.Input[float]] = None,
                 configurations: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterMasterInstanceFleetInstanceTypeConfigConfigurationArgs']]]] = None,
                 ebs_configs: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterMasterInstanceFleetInstanceTypeConfigEbsConfigArgs']]]] = None,
                 weighted_capacity: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] instance_type: EC2 instance type, such as m4.xlarge.
        :param pulumi.Input[str] bid_price: Bid price for each EC2 Spot instance type as defined by `instance_type`. Expressed in USD. If neither `bid_price` nor `bid_price_as_percentage_of_on_demand_price` is provided, `bid_price_as_percentage_of_on_demand_price` defaults to 100%.
        :param pulumi.Input[float] bid_price_as_percentage_of_on_demand_price: Bid price, as a percentage of On-Demand price, for each EC2 Spot instance as defined by `instance_type`. Expressed as a number (for example, 20 specifies 20%). If neither `bid_price` nor `bid_price_as_percentage_of_on_demand_price` is provided, `bid_price_as_percentage_of_on_demand_price` defaults to 100%.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterMasterInstanceFleetInstanceTypeConfigConfigurationArgs']]] configurations: Configuration classification that applies when provisioning cluster instances, which can include configurations for applications and software that run on the cluster. List of `configuration` blocks.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterMasterInstanceFleetInstanceTypeConfigEbsConfigArgs']]] ebs_configs: Configuration block(s) for EBS volumes attached to each instance in the instance group. Detailed below.
        :param pulumi.Input[int] weighted_capacity: Number of units that a provisioned instance of this type provides toward fulfilling the target capacities defined in `emr.InstanceFleet`.
        """
        pulumi.set(__self__, "instance_type", instance_type)
        if bid_price is not None:
            pulumi.set(__self__, "bid_price", bid_price)
        if bid_price_as_percentage_of_on_demand_price is not None:
            pulumi.set(__self__, "bid_price_as_percentage_of_on_demand_price", bid_price_as_percentage_of_on_demand_price)
        if configurations is not None:
            pulumi.set(__self__, "configurations", configurations)
        if ebs_configs is not None:
            pulumi.set(__self__, "ebs_configs", ebs_configs)
        if weighted_capacity is not None:
            pulumi.set(__self__, "weighted_capacity", weighted_capacity)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Input[str]:
        """
        EC2 instance type, such as m4.xlarge.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter(name="bidPrice")
    def bid_price(self) -> Optional[pulumi.Input[str]]:
        """
        Bid price for each EC2 Spot instance type as defined by `instance_type`. Expressed in USD. If neither `bid_price` nor `bid_price_as_percentage_of_on_demand_price` is provided, `bid_price_as_percentage_of_on_demand_price` defaults to 100%.
        """
        return pulumi.get(self, "bid_price")

    @bid_price.setter
    def bid_price(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bid_price", value)

    @property
    @pulumi.getter(name="bidPriceAsPercentageOfOnDemandPrice")
    def bid_price_as_percentage_of_on_demand_price(self) -> Optional[pulumi.Input[float]]:
        """
        Bid price, as a percentage of On-Demand price, for each EC2 Spot instance as defined by `instance_type`. Expressed as a number (for example, 20 specifies 20%). If neither `bid_price` nor `bid_price_as_percentage_of_on_demand_price` is provided, `bid_price_as_percentage_of_on_demand_price` defaults to 100%.
        """
        return pulumi.get(self, "bid_price_as_percentage_of_on_demand_price")

    @bid_price_as_percentage_of_on_demand_price.setter
    def bid_price_as_percentage_of_on_demand_price(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "bid_price_as_percentage_of_on_demand_price", value)

    @property
    @pulumi.getter
    def configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterMasterInstanceFleetInstanceTypeConfigConfigurationArgs']]]]:
        """
        Configuration classification that applies when provisioning cluster instances, which can include configurations for applications and software that run on the cluster. List of `configuration` blocks.
        """
        return pulumi.get(self, "configurations")

    @configurations.setter
    def configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterMasterInstanceFleetInstanceTypeConfigConfigurationArgs']]]]):
        pulumi.set(self, "configurations", value)

    @property
    @pulumi.getter(name="ebsConfigs")
    def ebs_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterMasterInstanceFleetInstanceTypeConfigEbsConfigArgs']]]]:
        """
        Configuration block(s) for EBS volumes attached to each instance in the instance group. Detailed below.
        """
        return pulumi.get(self, "ebs_configs")

    @ebs_configs.setter
    def ebs_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterMasterInstanceFleetInstanceTypeConfigEbsConfigArgs']]]]):
        pulumi.set(self, "ebs_configs", value)

    @property
    @pulumi.getter(name="weightedCapacity")
    def weighted_capacity(self) -> Optional[pulumi.Input[int]]:
        """
        Number of units that a provisioned instance of this type provides toward fulfilling the target capacities defined in `emr.InstanceFleet`.
        """
        return pulumi.get(self, "weighted_capacity")

    @weighted_capacity.setter
    def weighted_capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "weighted_capacity", value)


@pulumi.input_type
class ClusterMasterInstanceFleetInstanceTypeConfigConfigurationArgs:
    def __init__(__self__, *,
                 classification: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] classification: Classification within a configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: Map of properties specified within a configuration classification.
        """
        if classification is not None:
            pulumi.set(__self__, "classification", classification)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter
    def classification(self) -> Optional[pulumi.Input[str]]:
        """
        Classification within a configuration.
        """
        return pulumi.get(self, "classification")

    @classification.setter
    def classification(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "classification", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Map of properties specified within a configuration classification.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "properties", value)


@pulumi.input_type
class ClusterMasterInstanceFleetInstanceTypeConfigEbsConfigArgs:
    def __init__(__self__, *,
                 size: pulumi.Input[int],
                 type: pulumi.Input[str],
                 iops: Optional[pulumi.Input[int]] = None,
                 volumes_per_instance: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] size: Volume size, in gibibytes (GiB).
        :param pulumi.Input[str] type: Volume type. Valid options are `gp3`, `gp2`, `io1`, `standard`, `st1` and `sc1`. See [EBS Volume Types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html).
        :param pulumi.Input[int] iops: Number of I/O operations per second (IOPS) that the volume supports.
        :param pulumi.Input[int] volumes_per_instance: Number of EBS volumes with this configuration to attach to each EC2 instance in the instance group (default is 1).
        """
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "type", type)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if volumes_per_instance is not None:
            pulumi.set(__self__, "volumes_per_instance", volumes_per_instance)

    @property
    @pulumi.getter
    def size(self) -> pulumi.Input[int]:
        """
        Volume size, in gibibytes (GiB).
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: pulumi.Input[int]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Volume type. Valid options are `gp3`, `gp2`, `io1`, `standard`, `st1` and `sc1`. See [EBS Volume Types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html).
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def iops(self) -> Optional[pulumi.Input[int]]:
        """
        Number of I/O operations per second (IOPS) that the volume supports.
        """
        return pulumi.get(self, "iops")

    @iops.setter
    def iops(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "iops", value)

    @property
    @pulumi.getter(name="volumesPerInstance")
    def volumes_per_instance(self) -> Optional[pulumi.Input[int]]:
        """
        Number of EBS volumes with this configuration to attach to each EC2 instance in the instance group (default is 1).
        """
        return pulumi.get(self, "volumes_per_instance")

    @volumes_per_instance.setter
    def volumes_per_instance(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "volumes_per_instance", value)


@pulumi.input_type
class ClusterMasterInstanceFleetLaunchSpecificationsArgs:
    def __init__(__self__, *,
                 on_demand_specifications: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterMasterInstanceFleetLaunchSpecificationsOnDemandSpecificationArgs']]]] = None,
                 spot_specifications: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterMasterInstanceFleetLaunchSpecificationsSpotSpecificationArgs']]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['ClusterMasterInstanceFleetLaunchSpecificationsOnDemandSpecificationArgs']]] on_demand_specifications: Configuration block for on demand instances launch specifications.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterMasterInstanceFleetLaunchSpecificationsSpotSpecificationArgs']]] spot_specifications: Configuration block for spot instances launch specifications.
        """
        if on_demand_specifications is not None:
            pulumi.set(__self__, "on_demand_specifications", on_demand_specifications)
        if spot_specifications is not None:
            pulumi.set(__self__, "spot_specifications", spot_specifications)

    @property
    @pulumi.getter(name="onDemandSpecifications")
    def on_demand_specifications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterMasterInstanceFleetLaunchSpecificationsOnDemandSpecificationArgs']]]]:
        """
        Configuration block for on demand instances launch specifications.
        """
        return pulumi.get(self, "on_demand_specifications")

    @on_demand_specifications.setter
    def on_demand_specifications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterMasterInstanceFleetLaunchSpecificationsOnDemandSpecificationArgs']]]]):
        pulumi.set(self, "on_demand_specifications", value)

    @property
    @pulumi.getter(name="spotSpecifications")
    def spot_specifications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterMasterInstanceFleetLaunchSpecificationsSpotSpecificationArgs']]]]:
        """
        Configuration block for spot instances launch specifications.
        """
        return pulumi.get(self, "spot_specifications")

    @spot_specifications.setter
    def spot_specifications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterMasterInstanceFleetLaunchSpecificationsSpotSpecificationArgs']]]]):
        pulumi.set(self, "spot_specifications", value)


@pulumi.input_type
class ClusterMasterInstanceFleetLaunchSpecificationsOnDemandSpecificationArgs:
    def __init__(__self__, *,
                 allocation_strategy: pulumi.Input[str]):
        """
        :param pulumi.Input[str] allocation_strategy: Specifies the strategy to use in launching On-Demand instance fleets. Currently, the only option is `lowest-price` (the default), which launches the lowest price first.
        """
        pulumi.set(__self__, "allocation_strategy", allocation_strategy)

    @property
    @pulumi.getter(name="allocationStrategy")
    def allocation_strategy(self) -> pulumi.Input[str]:
        """
        Specifies the strategy to use in launching On-Demand instance fleets. Currently, the only option is `lowest-price` (the default), which launches the lowest price first.
        """
        return pulumi.get(self, "allocation_strategy")

    @allocation_strategy.setter
    def allocation_strategy(self, value: pulumi.Input[str]):
        pulumi.set(self, "allocation_strategy", value)


@pulumi.input_type
class ClusterMasterInstanceFleetLaunchSpecificationsSpotSpecificationArgs:
    def __init__(__self__, *,
                 allocation_strategy: pulumi.Input[str],
                 timeout_action: pulumi.Input[str],
                 timeout_duration_minutes: pulumi.Input[int],
                 block_duration_minutes: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] allocation_strategy: Specifies the strategy to use in launching Spot instance fleets. Valid values include `capacity-optimized`, `diversified`, `lowest-price`, `price-capacity-optimized`. See the [AWS documentation](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-instance-fleet.html#emr-instance-fleet-allocation-strategy) for details on each strategy type.
        :param pulumi.Input[str] timeout_action: Action to take when TargetSpotCapacity has not been fulfilled when the TimeoutDurationMinutes has expired; that is, when all Spot instances could not be provisioned within the Spot provisioning timeout. Valid values are `TERMINATE_CLUSTER` and `SWITCH_TO_ON_DEMAND`. SWITCH_TO_ON_DEMAND specifies that if no Spot instances are available, On-Demand Instances should be provisioned to fulfill any remaining Spot capacity.
        :param pulumi.Input[int] timeout_duration_minutes: Spot provisioning timeout period in minutes. If Spot instances are not provisioned within this time period, the TimeOutAction is taken. Minimum value is 5 and maximum value is 1440. The timeout applies only during initial provisioning, when the cluster is first created.
        :param pulumi.Input[int] block_duration_minutes: Defined duration for Spot instances (also known as Spot blocks) in minutes. When specified, the Spot instance does not terminate before the defined duration expires, and defined duration pricing for Spot instances applies. Valid values are 60, 120, 180, 240, 300, or 360. The duration period starts as soon as a Spot instance receives its instance ID. At the end of the duration, Amazon EC2 marks the Spot instance for termination and provides a Spot instance termination notice, which gives the instance a two-minute warning before it terminates.
        """
        pulumi.set(__self__, "allocation_strategy", allocation_strategy)
        pulumi.set(__self__, "timeout_action", timeout_action)
        pulumi.set(__self__, "timeout_duration_minutes", timeout_duration_minutes)
        if block_duration_minutes is not None:
            pulumi.set(__self__, "block_duration_minutes", block_duration_minutes)

    @property
    @pulumi.getter(name="allocationStrategy")
    def allocation_strategy(self) -> pulumi.Input[str]:
        """
        Specifies the strategy to use in launching Spot instance fleets. Valid values include `capacity-optimized`, `diversified`, `lowest-price`, `price-capacity-optimized`. See the [AWS documentation](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-instance-fleet.html#emr-instance-fleet-allocation-strategy) for details on each strategy type.
        """
        return pulumi.get(self, "allocation_strategy")

    @allocation_strategy.setter
    def allocation_strategy(self, value: pulumi.Input[str]):
        pulumi.set(self, "allocation_strategy", value)

    @property
    @pulumi.getter(name="timeoutAction")
    def timeout_action(self) -> pulumi.Input[str]:
        """
        Action to take when TargetSpotCapacity has not been fulfilled when the TimeoutDurationMinutes has expired; that is, when all Spot instances could not be provisioned within the Spot provisioning timeout. Valid values are `TERMINATE_CLUSTER` and `SWITCH_TO_ON_DEMAND`. SWITCH_TO_ON_DEMAND specifies that if no Spot instances are available, On-Demand Instances should be provisioned to fulfill any remaining Spot capacity.
        """
        return pulumi.get(self, "timeout_action")

    @timeout_action.setter
    def timeout_action(self, value: pulumi.Input[str]):
        pulumi.set(self, "timeout_action", value)

    @property
    @pulumi.getter(name="timeoutDurationMinutes")
    def timeout_duration_minutes(self) -> pulumi.Input[int]:
        """
        Spot provisioning timeout period in minutes. If Spot instances are not provisioned within this time period, the TimeOutAction is taken. Minimum value is 5 and maximum value is 1440. The timeout applies only during initial provisioning, when the cluster is first created.
        """
        return pulumi.get(self, "timeout_duration_minutes")

    @timeout_duration_minutes.setter
    def timeout_duration_minutes(self, value: pulumi.Input[int]):
        pulumi.set(self, "timeout_duration_minutes", value)

    @property
    @pulumi.getter(name="blockDurationMinutes")
    def block_duration_minutes(self) -> Optional[pulumi.Input[int]]:
        """
        Defined duration for Spot instances (also known as Spot blocks) in minutes. When specified, the Spot instance does not terminate before the defined duration expires, and defined duration pricing for Spot instances applies. Valid values are 60, 120, 180, 240, 300, or 360. The duration period starts as soon as a Spot instance receives its instance ID. At the end of the duration, Amazon EC2 marks the Spot instance for termination and provides a Spot instance termination notice, which gives the instance a two-minute warning before it terminates.
        """
        return pulumi.get(self, "block_duration_minutes")

    @block_duration_minutes.setter
    def block_duration_minutes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "block_duration_minutes", value)


@pulumi.input_type
class ClusterMasterInstanceGroupArgs:
    def __init__(__self__, *,
                 instance_type: pulumi.Input[str],
                 bid_price: Optional[pulumi.Input[str]] = None,
                 ebs_configs: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterMasterInstanceGroupEbsConfigArgs']]]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 instance_count: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] instance_type: EC2 instance type for all instances in the instance group.
        :param pulumi.Input[str] bid_price: Bid price for each EC2 instance in the instance group, expressed in USD. By setting this attribute, the instance group is being declared as a Spot Instance, and will implicitly create a Spot request. Leave this blank to use On-Demand Instances.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterMasterInstanceGroupEbsConfigArgs']]] ebs_configs: Configuration block(s) for EBS volumes attached to each instance in the instance group. Detailed below.
        :param pulumi.Input[str] id: ID of the cluster.
        :param pulumi.Input[int] instance_count: Target number of instances for the instance group. Must be 1 or 3. Defaults to 1. Launching with multiple master nodes is only supported in EMR version 5.23.0+, and requires this resource's `core_instance_group` to be configured. Public (Internet accessible) instances must be created in VPC subnets that have map public IP on launch enabled. Termination protection is automatically enabled when launched with multiple master nodes and this provider must have the `termination_protection = false` configuration applied before destroying this resource.
        :param pulumi.Input[str] name: Friendly name given to the instance group.
        """
        pulumi.set(__self__, "instance_type", instance_type)
        if bid_price is not None:
            pulumi.set(__self__, "bid_price", bid_price)
        if ebs_configs is not None:
            pulumi.set(__self__, "ebs_configs", ebs_configs)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if instance_count is not None:
            pulumi.set(__self__, "instance_count", instance_count)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Input[str]:
        """
        EC2 instance type for all instances in the instance group.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter(name="bidPrice")
    def bid_price(self) -> Optional[pulumi.Input[str]]:
        """
        Bid price for each EC2 instance in the instance group, expressed in USD. By setting this attribute, the instance group is being declared as a Spot Instance, and will implicitly create a Spot request. Leave this blank to use On-Demand Instances.
        """
        return pulumi.get(self, "bid_price")

    @bid_price.setter
    def bid_price(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bid_price", value)

    @property
    @pulumi.getter(name="ebsConfigs")
    def ebs_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterMasterInstanceGroupEbsConfigArgs']]]]:
        """
        Configuration block(s) for EBS volumes attached to each instance in the instance group. Detailed below.
        """
        return pulumi.get(self, "ebs_configs")

    @ebs_configs.setter
    def ebs_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterMasterInstanceGroupEbsConfigArgs']]]]):
        pulumi.set(self, "ebs_configs", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the cluster.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> Optional[pulumi.Input[int]]:
        """
        Target number of instances for the instance group. Must be 1 or 3. Defaults to 1. Launching with multiple master nodes is only supported in EMR version 5.23.0+, and requires this resource's `core_instance_group` to be configured. Public (Internet accessible) instances must be created in VPC subnets that have map public IP on launch enabled. Termination protection is automatically enabled when launched with multiple master nodes and this provider must have the `termination_protection = false` configuration applied before destroying this resource.
        """
        return pulumi.get(self, "instance_count")

    @instance_count.setter
    def instance_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "instance_count", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Friendly name given to the instance group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class ClusterMasterInstanceGroupEbsConfigArgs:
    def __init__(__self__, *,
                 size: pulumi.Input[int],
                 type: pulumi.Input[str],
                 iops: Optional[pulumi.Input[int]] = None,
                 throughput: Optional[pulumi.Input[int]] = None,
                 volumes_per_instance: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] size: Volume size, in gibibytes (GiB).
        :param pulumi.Input[str] type: Volume type. Valid options are `gp3`, `gp2`, `io1`, `standard`, `st1` and `sc1`. See [EBS Volume Types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html).
        :param pulumi.Input[int] iops: Number of I/O operations per second (IOPS) that the volume supports.
        :param pulumi.Input[int] throughput: The throughput, in mebibyte per second (MiB/s).
        :param pulumi.Input[int] volumes_per_instance: Number of EBS volumes with this configuration to attach to each EC2 instance in the instance group (default is 1).
        """
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "type", type)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if throughput is not None:
            pulumi.set(__self__, "throughput", throughput)
        if volumes_per_instance is not None:
            pulumi.set(__self__, "volumes_per_instance", volumes_per_instance)

    @property
    @pulumi.getter
    def size(self) -> pulumi.Input[int]:
        """
        Volume size, in gibibytes (GiB).
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: pulumi.Input[int]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Volume type. Valid options are `gp3`, `gp2`, `io1`, `standard`, `st1` and `sc1`. See [EBS Volume Types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html).
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def iops(self) -> Optional[pulumi.Input[int]]:
        """
        Number of I/O operations per second (IOPS) that the volume supports.
        """
        return pulumi.get(self, "iops")

    @iops.setter
    def iops(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "iops", value)

    @property
    @pulumi.getter
    def throughput(self) -> Optional[pulumi.Input[int]]:
        """
        The throughput, in mebibyte per second (MiB/s).
        """
        return pulumi.get(self, "throughput")

    @throughput.setter
    def throughput(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "throughput", value)

    @property
    @pulumi.getter(name="volumesPerInstance")
    def volumes_per_instance(self) -> Optional[pulumi.Input[int]]:
        """
        Number of EBS volumes with this configuration to attach to each EC2 instance in the instance group (default is 1).
        """
        return pulumi.get(self, "volumes_per_instance")

    @volumes_per_instance.setter
    def volumes_per_instance(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "volumes_per_instance", value)


@pulumi.input_type
class ClusterPlacementGroupConfigArgs:
    def __init__(__self__, *,
                 instance_role: pulumi.Input[str],
                 placement_strategy: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] instance_role: Role of the instance in the cluster. Valid Values: `MASTER`, `CORE`, `TASK`.
        :param pulumi.Input[str] placement_strategy: EC2 Placement Group strategy associated with instance role. Valid Values: `SPREAD`, `PARTITION`, `CLUSTER`, `NONE`.
        """
        pulumi.set(__self__, "instance_role", instance_role)
        if placement_strategy is not None:
            pulumi.set(__self__, "placement_strategy", placement_strategy)

    @property
    @pulumi.getter(name="instanceRole")
    def instance_role(self) -> pulumi.Input[str]:
        """
        Role of the instance in the cluster. Valid Values: `MASTER`, `CORE`, `TASK`.
        """
        return pulumi.get(self, "instance_role")

    @instance_role.setter
    def instance_role(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_role", value)

    @property
    @pulumi.getter(name="placementStrategy")
    def placement_strategy(self) -> Optional[pulumi.Input[str]]:
        """
        EC2 Placement Group strategy associated with instance role. Valid Values: `SPREAD`, `PARTITION`, `CLUSTER`, `NONE`.
        """
        return pulumi.get(self, "placement_strategy")

    @placement_strategy.setter
    def placement_strategy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "placement_strategy", value)


@pulumi.input_type
class ClusterStepArgs:
    def __init__(__self__, *,
                 action_on_failure: pulumi.Input[str],
                 hadoop_jar_step: pulumi.Input['ClusterStepHadoopJarStepArgs'],
                 name: pulumi.Input[str]):
        """
        :param pulumi.Input[str] action_on_failure: Action to take if the step fails. Valid values: `TERMINATE_JOB_FLOW`, `TERMINATE_CLUSTER`, `CANCEL_AND_WAIT`, and `CONTINUE`
        :param pulumi.Input['ClusterStepHadoopJarStepArgs'] hadoop_jar_step: JAR file used for the step. See below.
        :param pulumi.Input[str] name: Name of the step.
        """
        pulumi.set(__self__, "action_on_failure", action_on_failure)
        pulumi.set(__self__, "hadoop_jar_step", hadoop_jar_step)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="actionOnFailure")
    def action_on_failure(self) -> pulumi.Input[str]:
        """
        Action to take if the step fails. Valid values: `TERMINATE_JOB_FLOW`, `TERMINATE_CLUSTER`, `CANCEL_AND_WAIT`, and `CONTINUE`
        """
        return pulumi.get(self, "action_on_failure")

    @action_on_failure.setter
    def action_on_failure(self, value: pulumi.Input[str]):
        pulumi.set(self, "action_on_failure", value)

    @property
    @pulumi.getter(name="hadoopJarStep")
    def hadoop_jar_step(self) -> pulumi.Input['ClusterStepHadoopJarStepArgs']:
        """
        JAR file used for the step. See below.
        """
        return pulumi.get(self, "hadoop_jar_step")

    @hadoop_jar_step.setter
    def hadoop_jar_step(self, value: pulumi.Input['ClusterStepHadoopJarStepArgs']):
        pulumi.set(self, "hadoop_jar_step", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Name of the step.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class ClusterStepHadoopJarStepArgs:
    def __init__(__self__, *,
                 jar: pulumi.Input[str],
                 args: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 main_class: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] jar: Path to a JAR file run during the step.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] args: List of command line arguments passed to the JAR file's main function when executed.
        :param pulumi.Input[str] main_class: Name of the main class in the specified Java file. If not specified, the JAR file should specify a Main-Class in its manifest file.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: Key-Value map of Java properties that are set when the step runs. You can use these properties to pass key value pairs to your main function.
        """
        pulumi.set(__self__, "jar", jar)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if main_class is not None:
            pulumi.set(__self__, "main_class", main_class)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter
    def jar(self) -> pulumi.Input[str]:
        """
        Path to a JAR file run during the step.
        """
        return pulumi.get(self, "jar")

    @jar.setter
    def jar(self, value: pulumi.Input[str]):
        pulumi.set(self, "jar", value)

    @property
    @pulumi.getter
    def args(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of command line arguments passed to the JAR file's main function when executed.
        """
        return pulumi.get(self, "args")

    @args.setter
    def args(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "args", value)

    @property
    @pulumi.getter(name="mainClass")
    def main_class(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the main class in the specified Java file. If not specified, the JAR file should specify a Main-Class in its manifest file.
        """
        return pulumi.get(self, "main_class")

    @main_class.setter
    def main_class(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "main_class", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key-Value map of Java properties that are set when the step runs. You can use these properties to pass key value pairs to your main function.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "properties", value)


@pulumi.input_type
class InstanceFleetInstanceTypeConfigArgs:
    def __init__(__self__, *,
                 instance_type: pulumi.Input[str],
                 bid_price: Optional[pulumi.Input[str]] = None,
                 bid_price_as_percentage_of_on_demand_price: Optional[pulumi.Input[float]] = None,
                 configurations: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceFleetInstanceTypeConfigConfigurationArgs']]]] = None,
                 ebs_configs: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceFleetInstanceTypeConfigEbsConfigArgs']]]] = None,
                 weighted_capacity: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] instance_type: An EC2 instance type, such as m4.xlarge.
        :param pulumi.Input[str] bid_price: The bid price for each EC2 Spot instance type as defined by `instance_type`. Expressed in USD. If neither `bid_price` nor `bid_price_as_percentage_of_on_demand_price` is provided, `bid_price_as_percentage_of_on_demand_price` defaults to 100%.
        :param pulumi.Input[float] bid_price_as_percentage_of_on_demand_price: The bid price, as a percentage of On-Demand price, for each EC2 Spot instance as defined by `instance_type`. Expressed as a number (for example, 20 specifies 20%). If neither `bid_price` nor `bid_price_as_percentage_of_on_demand_price` is provided, `bid_price_as_percentage_of_on_demand_price` defaults to 100%.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceFleetInstanceTypeConfigConfigurationArgs']]] configurations: A configuration classification that applies when provisioning cluster instances, which can include configurations for applications and software that run on the cluster. List of `configuration` blocks.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceFleetInstanceTypeConfigEbsConfigArgs']]] ebs_configs: Configuration block(s) for EBS volumes attached to each instance in the instance group. Detailed below.
        :param pulumi.Input[int] weighted_capacity: The number of units that a provisioned instance of this type provides toward fulfilling the target capacities defined in `emr.InstanceFleet`.
        """
        pulumi.set(__self__, "instance_type", instance_type)
        if bid_price is not None:
            pulumi.set(__self__, "bid_price", bid_price)
        if bid_price_as_percentage_of_on_demand_price is not None:
            pulumi.set(__self__, "bid_price_as_percentage_of_on_demand_price", bid_price_as_percentage_of_on_demand_price)
        if configurations is not None:
            pulumi.set(__self__, "configurations", configurations)
        if ebs_configs is not None:
            pulumi.set(__self__, "ebs_configs", ebs_configs)
        if weighted_capacity is not None:
            pulumi.set(__self__, "weighted_capacity", weighted_capacity)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Input[str]:
        """
        An EC2 instance type, such as m4.xlarge.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter(name="bidPrice")
    def bid_price(self) -> Optional[pulumi.Input[str]]:
        """
        The bid price for each EC2 Spot instance type as defined by `instance_type`. Expressed in USD. If neither `bid_price` nor `bid_price_as_percentage_of_on_demand_price` is provided, `bid_price_as_percentage_of_on_demand_price` defaults to 100%.
        """
        return pulumi.get(self, "bid_price")

    @bid_price.setter
    def bid_price(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bid_price", value)

    @property
    @pulumi.getter(name="bidPriceAsPercentageOfOnDemandPrice")
    def bid_price_as_percentage_of_on_demand_price(self) -> Optional[pulumi.Input[float]]:
        """
        The bid price, as a percentage of On-Demand price, for each EC2 Spot instance as defined by `instance_type`. Expressed as a number (for example, 20 specifies 20%). If neither `bid_price` nor `bid_price_as_percentage_of_on_demand_price` is provided, `bid_price_as_percentage_of_on_demand_price` defaults to 100%.
        """
        return pulumi.get(self, "bid_price_as_percentage_of_on_demand_price")

    @bid_price_as_percentage_of_on_demand_price.setter
    def bid_price_as_percentage_of_on_demand_price(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "bid_price_as_percentage_of_on_demand_price", value)

    @property
    @pulumi.getter
    def configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceFleetInstanceTypeConfigConfigurationArgs']]]]:
        """
        A configuration classification that applies when provisioning cluster instances, which can include configurations for applications and software that run on the cluster. List of `configuration` blocks.
        """
        return pulumi.get(self, "configurations")

    @configurations.setter
    def configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceFleetInstanceTypeConfigConfigurationArgs']]]]):
        pulumi.set(self, "configurations", value)

    @property
    @pulumi.getter(name="ebsConfigs")
    def ebs_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceFleetInstanceTypeConfigEbsConfigArgs']]]]:
        """
        Configuration block(s) for EBS volumes attached to each instance in the instance group. Detailed below.
        """
        return pulumi.get(self, "ebs_configs")

    @ebs_configs.setter
    def ebs_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceFleetInstanceTypeConfigEbsConfigArgs']]]]):
        pulumi.set(self, "ebs_configs", value)

    @property
    @pulumi.getter(name="weightedCapacity")
    def weighted_capacity(self) -> Optional[pulumi.Input[int]]:
        """
        The number of units that a provisioned instance of this type provides toward fulfilling the target capacities defined in `emr.InstanceFleet`.
        """
        return pulumi.get(self, "weighted_capacity")

    @weighted_capacity.setter
    def weighted_capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "weighted_capacity", value)


@pulumi.input_type
class InstanceFleetInstanceTypeConfigConfigurationArgs:
    def __init__(__self__, *,
                 classification: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] classification: The classification within a configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: A map of properties specified within a configuration classification
        """
        if classification is not None:
            pulumi.set(__self__, "classification", classification)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter
    def classification(self) -> Optional[pulumi.Input[str]]:
        """
        The classification within a configuration.
        """
        return pulumi.get(self, "classification")

    @classification.setter
    def classification(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "classification", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of properties specified within a configuration classification
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "properties", value)


@pulumi.input_type
class InstanceFleetInstanceTypeConfigEbsConfigArgs:
    def __init__(__self__, *,
                 size: pulumi.Input[int],
                 type: pulumi.Input[str],
                 iops: Optional[pulumi.Input[int]] = None,
                 volumes_per_instance: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] size: The volume size, in gibibytes (GiB).
        :param pulumi.Input[str] type: The volume type. Valid options are `gp2`, `io1`, `standard` and `st1`. See [EBS Volume Types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html).
        :param pulumi.Input[int] iops: The number of I/O operations per second (IOPS) that the volume supports
        :param pulumi.Input[int] volumes_per_instance: The number of EBS volumes with this configuration to attach to each EC2 instance in the instance group (default is 1)
        """
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "type", type)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if volumes_per_instance is not None:
            pulumi.set(__self__, "volumes_per_instance", volumes_per_instance)

    @property
    @pulumi.getter
    def size(self) -> pulumi.Input[int]:
        """
        The volume size, in gibibytes (GiB).
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: pulumi.Input[int]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The volume type. Valid options are `gp2`, `io1`, `standard` and `st1`. See [EBS Volume Types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html).
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def iops(self) -> Optional[pulumi.Input[int]]:
        """
        The number of I/O operations per second (IOPS) that the volume supports
        """
        return pulumi.get(self, "iops")

    @iops.setter
    def iops(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "iops", value)

    @property
    @pulumi.getter(name="volumesPerInstance")
    def volumes_per_instance(self) -> Optional[pulumi.Input[int]]:
        """
        The number of EBS volumes with this configuration to attach to each EC2 instance in the instance group (default is 1)
        """
        return pulumi.get(self, "volumes_per_instance")

    @volumes_per_instance.setter
    def volumes_per_instance(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "volumes_per_instance", value)


@pulumi.input_type
class InstanceFleetLaunchSpecificationsArgs:
    def __init__(__self__, *,
                 on_demand_specifications: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceFleetLaunchSpecificationsOnDemandSpecificationArgs']]]] = None,
                 spot_specifications: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceFleetLaunchSpecificationsSpotSpecificationArgs']]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['InstanceFleetLaunchSpecificationsOnDemandSpecificationArgs']]] on_demand_specifications: Configuration block for on demand instances launch specifications
        :param pulumi.Input[Sequence[pulumi.Input['InstanceFleetLaunchSpecificationsSpotSpecificationArgs']]] spot_specifications: Configuration block for spot instances launch specifications
        """
        if on_demand_specifications is not None:
            pulumi.set(__self__, "on_demand_specifications", on_demand_specifications)
        if spot_specifications is not None:
            pulumi.set(__self__, "spot_specifications", spot_specifications)

    @property
    @pulumi.getter(name="onDemandSpecifications")
    def on_demand_specifications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceFleetLaunchSpecificationsOnDemandSpecificationArgs']]]]:
        """
        Configuration block for on demand instances launch specifications
        """
        return pulumi.get(self, "on_demand_specifications")

    @on_demand_specifications.setter
    def on_demand_specifications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceFleetLaunchSpecificationsOnDemandSpecificationArgs']]]]):
        pulumi.set(self, "on_demand_specifications", value)

    @property
    @pulumi.getter(name="spotSpecifications")
    def spot_specifications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceFleetLaunchSpecificationsSpotSpecificationArgs']]]]:
        """
        Configuration block for spot instances launch specifications
        """
        return pulumi.get(self, "spot_specifications")

    @spot_specifications.setter
    def spot_specifications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceFleetLaunchSpecificationsSpotSpecificationArgs']]]]):
        pulumi.set(self, "spot_specifications", value)


@pulumi.input_type
class InstanceFleetLaunchSpecificationsOnDemandSpecificationArgs:
    def __init__(__self__, *,
                 allocation_strategy: pulumi.Input[str]):
        """
        :param pulumi.Input[str] allocation_strategy: Specifies the strategy to use in launching Spot instance fleets. Currently, the only option is `capacity-optimized` (the default), which launches instances from Spot instance pools with optimal capacity for the number of instances that are launching.
        """
        pulumi.set(__self__, "allocation_strategy", allocation_strategy)

    @property
    @pulumi.getter(name="allocationStrategy")
    def allocation_strategy(self) -> pulumi.Input[str]:
        """
        Specifies the strategy to use in launching Spot instance fleets. Currently, the only option is `capacity-optimized` (the default), which launches instances from Spot instance pools with optimal capacity for the number of instances that are launching.
        """
        return pulumi.get(self, "allocation_strategy")

    @allocation_strategy.setter
    def allocation_strategy(self, value: pulumi.Input[str]):
        pulumi.set(self, "allocation_strategy", value)


@pulumi.input_type
class InstanceFleetLaunchSpecificationsSpotSpecificationArgs:
    def __init__(__self__, *,
                 allocation_strategy: pulumi.Input[str],
                 timeout_action: pulumi.Input[str],
                 timeout_duration_minutes: pulumi.Input[int],
                 block_duration_minutes: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] allocation_strategy: Specifies the strategy to use in launching Spot instance fleets. Currently, the only option is `capacity-optimized` (the default), which launches instances from Spot instance pools with optimal capacity for the number of instances that are launching.
        :param pulumi.Input[str] timeout_action: The action to take when TargetSpotCapacity has not been fulfilled when the TimeoutDurationMinutes has expired; that is, when all Spot instances could not be provisioned within the Spot provisioning timeout. Valid values are `TERMINATE_CLUSTER` and `SWITCH_TO_ON_DEMAND`. SWITCH_TO_ON_DEMAND specifies that if no Spot instances are available, On-Demand Instances should be provisioned to fulfill any remaining Spot capacity.
        :param pulumi.Input[int] timeout_duration_minutes: The spot provisioning timeout period in minutes. If Spot instances are not provisioned within this time period, the TimeOutAction is taken. Minimum value is 5 and maximum value is 1440. The timeout applies only during initial provisioning, when the cluster is first created.
        :param pulumi.Input[int] block_duration_minutes: The defined duration for Spot instances (also known as Spot blocks) in minutes. When specified, the Spot instance does not terminate before the defined duration expires, and defined duration pricing for Spot instances applies. Valid values are 60, 120, 180, 240, 300, or 360. The duration period starts as soon as a Spot instance receives its instance ID. At the end of the duration, Amazon EC2 marks the Spot instance for termination and provides a Spot instance termination notice, which gives the instance a two-minute warning before it terminates.
        """
        pulumi.set(__self__, "allocation_strategy", allocation_strategy)
        pulumi.set(__self__, "timeout_action", timeout_action)
        pulumi.set(__self__, "timeout_duration_minutes", timeout_duration_minutes)
        if block_duration_minutes is not None:
            pulumi.set(__self__, "block_duration_minutes", block_duration_minutes)

    @property
    @pulumi.getter(name="allocationStrategy")
    def allocation_strategy(self) -> pulumi.Input[str]:
        """
        Specifies the strategy to use in launching Spot instance fleets. Currently, the only option is `capacity-optimized` (the default), which launches instances from Spot instance pools with optimal capacity for the number of instances that are launching.
        """
        return pulumi.get(self, "allocation_strategy")

    @allocation_strategy.setter
    def allocation_strategy(self, value: pulumi.Input[str]):
        pulumi.set(self, "allocation_strategy", value)

    @property
    @pulumi.getter(name="timeoutAction")
    def timeout_action(self) -> pulumi.Input[str]:
        """
        The action to take when TargetSpotCapacity has not been fulfilled when the TimeoutDurationMinutes has expired; that is, when all Spot instances could not be provisioned within the Spot provisioning timeout. Valid values are `TERMINATE_CLUSTER` and `SWITCH_TO_ON_DEMAND`. SWITCH_TO_ON_DEMAND specifies that if no Spot instances are available, On-Demand Instances should be provisioned to fulfill any remaining Spot capacity.
        """
        return pulumi.get(self, "timeout_action")

    @timeout_action.setter
    def timeout_action(self, value: pulumi.Input[str]):
        pulumi.set(self, "timeout_action", value)

    @property
    @pulumi.getter(name="timeoutDurationMinutes")
    def timeout_duration_minutes(self) -> pulumi.Input[int]:
        """
        The spot provisioning timeout period in minutes. If Spot instances are not provisioned within this time period, the TimeOutAction is taken. Minimum value is 5 and maximum value is 1440. The timeout applies only during initial provisioning, when the cluster is first created.
        """
        return pulumi.get(self, "timeout_duration_minutes")

    @timeout_duration_minutes.setter
    def timeout_duration_minutes(self, value: pulumi.Input[int]):
        pulumi.set(self, "timeout_duration_minutes", value)

    @property
    @pulumi.getter(name="blockDurationMinutes")
    def block_duration_minutes(self) -> Optional[pulumi.Input[int]]:
        """
        The defined duration for Spot instances (also known as Spot blocks) in minutes. When specified, the Spot instance does not terminate before the defined duration expires, and defined duration pricing for Spot instances applies. Valid values are 60, 120, 180, 240, 300, or 360. The duration period starts as soon as a Spot instance receives its instance ID. At the end of the duration, Amazon EC2 marks the Spot instance for termination and provides a Spot instance termination notice, which gives the instance a two-minute warning before it terminates.
        """
        return pulumi.get(self, "block_duration_minutes")

    @block_duration_minutes.setter
    def block_duration_minutes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "block_duration_minutes", value)


@pulumi.input_type
class InstanceGroupEbsConfigArgs:
    def __init__(__self__, *,
                 size: pulumi.Input[int],
                 type: pulumi.Input[str],
                 iops: Optional[pulumi.Input[int]] = None,
                 volumes_per_instance: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] size: The volume size, in gibibytes (GiB). This can be a number from 1 - 1024. If the volume type is EBS-optimized, the minimum value is 10.
        :param pulumi.Input[str] type: The volume type. Valid options are 'gp2', 'io1' and 'standard'.
        :param pulumi.Input[int] iops: The number of I/O operations per second (IOPS) that the volume supports.
        :param pulumi.Input[int] volumes_per_instance: The number of EBS Volumes to attach per instance.
        """
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "type", type)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if volumes_per_instance is not None:
            pulumi.set(__self__, "volumes_per_instance", volumes_per_instance)

    @property
    @pulumi.getter
    def size(self) -> pulumi.Input[int]:
        """
        The volume size, in gibibytes (GiB). This can be a number from 1 - 1024. If the volume type is EBS-optimized, the minimum value is 10.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: pulumi.Input[int]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The volume type. Valid options are 'gp2', 'io1' and 'standard'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def iops(self) -> Optional[pulumi.Input[int]]:
        """
        The number of I/O operations per second (IOPS) that the volume supports.
        """
        return pulumi.get(self, "iops")

    @iops.setter
    def iops(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "iops", value)

    @property
    @pulumi.getter(name="volumesPerInstance")
    def volumes_per_instance(self) -> Optional[pulumi.Input[int]]:
        """
        The number of EBS Volumes to attach per instance.
        """
        return pulumi.get(self, "volumes_per_instance")

    @volumes_per_instance.setter
    def volumes_per_instance(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "volumes_per_instance", value)


@pulumi.input_type
class ManagedScalingPolicyComputeLimitArgs:
    def __init__(__self__, *,
                 maximum_capacity_units: pulumi.Input[int],
                 minimum_capacity_units: pulumi.Input[int],
                 unit_type: pulumi.Input[str],
                 maximum_core_capacity_units: Optional[pulumi.Input[int]] = None,
                 maximum_ondemand_capacity_units: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] maximum_capacity_units: The upper boundary of EC2 units. It is measured through VCPU cores or instances for instance groups and measured through units for instance fleets. Managed scaling activities are not allowed beyond this boundary. The limit only applies to the core and task nodes. The master node cannot be scaled after initial configuration.
        :param pulumi.Input[int] minimum_capacity_units: The lower boundary of EC2 units. It is measured through VCPU cores or instances for instance groups and measured through units for instance fleets. Managed scaling activities are not allowed beyond this boundary. The limit only applies to the core and task nodes. The master node cannot be scaled after initial configuration.
        :param pulumi.Input[str] unit_type: The unit type used for specifying a managed scaling policy. Valid Values: `InstanceFleetUnits` | `Instances` | `VCPU`
        :param pulumi.Input[int] maximum_core_capacity_units: The upper boundary of EC2 units for core node type in a cluster. It is measured through VCPU cores or instances for instance groups and measured through units for instance fleets. The core units are not allowed to scale beyond this boundary. The parameter is used to split capacity allocation between core and task nodes.
        :param pulumi.Input[int] maximum_ondemand_capacity_units: The upper boundary of On-Demand EC2 units. It is measured through VCPU cores or instances for instance groups and measured through units for instance fleets. The On-Demand units are not allowed to scale beyond this boundary. The parameter is used to split capacity allocation between On-Demand and Spot instances.
        """
        pulumi.set(__self__, "maximum_capacity_units", maximum_capacity_units)
        pulumi.set(__self__, "minimum_capacity_units", minimum_capacity_units)
        pulumi.set(__self__, "unit_type", unit_type)
        if maximum_core_capacity_units is not None:
            pulumi.set(__self__, "maximum_core_capacity_units", maximum_core_capacity_units)
        if maximum_ondemand_capacity_units is not None:
            pulumi.set(__self__, "maximum_ondemand_capacity_units", maximum_ondemand_capacity_units)

    @property
    @pulumi.getter(name="maximumCapacityUnits")
    def maximum_capacity_units(self) -> pulumi.Input[int]:
        """
        The upper boundary of EC2 units. It is measured through VCPU cores or instances for instance groups and measured through units for instance fleets. Managed scaling activities are not allowed beyond this boundary. The limit only applies to the core and task nodes. The master node cannot be scaled after initial configuration.
        """
        return pulumi.get(self, "maximum_capacity_units")

    @maximum_capacity_units.setter
    def maximum_capacity_units(self, value: pulumi.Input[int]):
        pulumi.set(self, "maximum_capacity_units", value)

    @property
    @pulumi.getter(name="minimumCapacityUnits")
    def minimum_capacity_units(self) -> pulumi.Input[int]:
        """
        The lower boundary of EC2 units. It is measured through VCPU cores or instances for instance groups and measured through units for instance fleets. Managed scaling activities are not allowed beyond this boundary. The limit only applies to the core and task nodes. The master node cannot be scaled after initial configuration.
        """
        return pulumi.get(self, "minimum_capacity_units")

    @minimum_capacity_units.setter
    def minimum_capacity_units(self, value: pulumi.Input[int]):
        pulumi.set(self, "minimum_capacity_units", value)

    @property
    @pulumi.getter(name="unitType")
    def unit_type(self) -> pulumi.Input[str]:
        """
        The unit type used for specifying a managed scaling policy. Valid Values: `InstanceFleetUnits` | `Instances` | `VCPU`
        """
        return pulumi.get(self, "unit_type")

    @unit_type.setter
    def unit_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "unit_type", value)

    @property
    @pulumi.getter(name="maximumCoreCapacityUnits")
    def maximum_core_capacity_units(self) -> Optional[pulumi.Input[int]]:
        """
        The upper boundary of EC2 units for core node type in a cluster. It is measured through VCPU cores or instances for instance groups and measured through units for instance fleets. The core units are not allowed to scale beyond this boundary. The parameter is used to split capacity allocation between core and task nodes.
        """
        return pulumi.get(self, "maximum_core_capacity_units")

    @maximum_core_capacity_units.setter
    def maximum_core_capacity_units(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "maximum_core_capacity_units", value)

    @property
    @pulumi.getter(name="maximumOndemandCapacityUnits")
    def maximum_ondemand_capacity_units(self) -> Optional[pulumi.Input[int]]:
        """
        The upper boundary of On-Demand EC2 units. It is measured through VCPU cores or instances for instance groups and measured through units for instance fleets. The On-Demand units are not allowed to scale beyond this boundary. The parameter is used to split capacity allocation between On-Demand and Spot instances.
        """
        return pulumi.get(self, "maximum_ondemand_capacity_units")

    @maximum_ondemand_capacity_units.setter
    def maximum_ondemand_capacity_units(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "maximum_ondemand_capacity_units", value)


@pulumi.input_type
class GetReleaseLabelsFiltersArgs:
    def __init__(__self__, *,
                 application: Optional[str] = None,
                 prefix: Optional[str] = None):
        """
        :param str application: Optional release label application filter. For example, `Spark@2.1.0` or `Spark`.
        :param str prefix: Optional release label version prefix filter. For example, `emr-5`.
        """
        if application is not None:
            pulumi.set(__self__, "application", application)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)

    @property
    @pulumi.getter
    def application(self) -> Optional[str]:
        """
        Optional release label application filter. For example, `Spark@2.1.0` or `Spark`.
        """
        return pulumi.get(self, "application")

    @application.setter
    def application(self, value: Optional[str]):
        pulumi.set(self, "application", value)

    @property
    @pulumi.getter
    def prefix(self) -> Optional[str]:
        """
        Optional release label version prefix filter. For example, `emr-5`.
        """
        return pulumi.get(self, "prefix")

    @prefix.setter
    def prefix(self, value: Optional[str]):
        pulumi.set(self, "prefix", value)


