# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'KxClusterAutoScalingConfigurationArgs',
    'KxClusterCacheStorageConfigurationArgs',
    'KxClusterCapacityConfigurationArgs',
    'KxClusterCodeArgs',
    'KxClusterDatabaseArgs',
    'KxClusterDatabaseCacheConfigurationArgs',
    'KxClusterSavedownStorageConfigurationArgs',
    'KxClusterVpcConfigurationArgs',
    'KxEnvironmentCustomDnsConfigurationArgs',
    'KxEnvironmentTransitGatewayConfigurationArgs',
]

@pulumi.input_type
class KxClusterAutoScalingConfigurationArgs:
    def __init__(__self__, *,
                 auto_scaling_metric: pulumi.Input[str],
                 max_node_count: pulumi.Input[int],
                 metric_target: pulumi.Input[float],
                 min_node_count: pulumi.Input[int],
                 scale_in_cooldown_seconds: pulumi.Input[float],
                 scale_out_cooldown_seconds: pulumi.Input[float]):
        """
        :param pulumi.Input[str] auto_scaling_metric: Metric your cluster will track in order to scale in and out. For example, CPU_UTILIZATION_PERCENTAGE is the average CPU usage across all nodes in a cluster.
        :param pulumi.Input[int] max_node_count: Highest number of nodes to scale. Cannot be greater than 5
        :param pulumi.Input[float] metric_target: Desired value of chosen `auto_scaling_metric`. When metric drops below this value, cluster will scale in. When metric goes above this value, cluster will scale out. Can be set between 0 and 100 percent.
        :param pulumi.Input[int] min_node_count: Lowest number of nodes to scale. Must be at least 1 and less than the `max_node_count`. If nodes in cluster belong to multiple availability zones, then `min_node_count` must be at least 3.
        :param pulumi.Input[float] scale_in_cooldown_seconds: Duration in seconds that FinSpace will wait after a scale in event before initiating another scaling event.
        :param pulumi.Input[float] scale_out_cooldown_seconds: Duration in seconds that FinSpace will wait after a scale out event before initiating another scaling event.
        """
        pulumi.set(__self__, "auto_scaling_metric", auto_scaling_metric)
        pulumi.set(__self__, "max_node_count", max_node_count)
        pulumi.set(__self__, "metric_target", metric_target)
        pulumi.set(__self__, "min_node_count", min_node_count)
        pulumi.set(__self__, "scale_in_cooldown_seconds", scale_in_cooldown_seconds)
        pulumi.set(__self__, "scale_out_cooldown_seconds", scale_out_cooldown_seconds)

    @property
    @pulumi.getter(name="autoScalingMetric")
    def auto_scaling_metric(self) -> pulumi.Input[str]:
        """
        Metric your cluster will track in order to scale in and out. For example, CPU_UTILIZATION_PERCENTAGE is the average CPU usage across all nodes in a cluster.
        """
        return pulumi.get(self, "auto_scaling_metric")

    @auto_scaling_metric.setter
    def auto_scaling_metric(self, value: pulumi.Input[str]):
        pulumi.set(self, "auto_scaling_metric", value)

    @property
    @pulumi.getter(name="maxNodeCount")
    def max_node_count(self) -> pulumi.Input[int]:
        """
        Highest number of nodes to scale. Cannot be greater than 5
        """
        return pulumi.get(self, "max_node_count")

    @max_node_count.setter
    def max_node_count(self, value: pulumi.Input[int]):
        pulumi.set(self, "max_node_count", value)

    @property
    @pulumi.getter(name="metricTarget")
    def metric_target(self) -> pulumi.Input[float]:
        """
        Desired value of chosen `auto_scaling_metric`. When metric drops below this value, cluster will scale in. When metric goes above this value, cluster will scale out. Can be set between 0 and 100 percent.
        """
        return pulumi.get(self, "metric_target")

    @metric_target.setter
    def metric_target(self, value: pulumi.Input[float]):
        pulumi.set(self, "metric_target", value)

    @property
    @pulumi.getter(name="minNodeCount")
    def min_node_count(self) -> pulumi.Input[int]:
        """
        Lowest number of nodes to scale. Must be at least 1 and less than the `max_node_count`. If nodes in cluster belong to multiple availability zones, then `min_node_count` must be at least 3.
        """
        return pulumi.get(self, "min_node_count")

    @min_node_count.setter
    def min_node_count(self, value: pulumi.Input[int]):
        pulumi.set(self, "min_node_count", value)

    @property
    @pulumi.getter(name="scaleInCooldownSeconds")
    def scale_in_cooldown_seconds(self) -> pulumi.Input[float]:
        """
        Duration in seconds that FinSpace will wait after a scale in event before initiating another scaling event.
        """
        return pulumi.get(self, "scale_in_cooldown_seconds")

    @scale_in_cooldown_seconds.setter
    def scale_in_cooldown_seconds(self, value: pulumi.Input[float]):
        pulumi.set(self, "scale_in_cooldown_seconds", value)

    @property
    @pulumi.getter(name="scaleOutCooldownSeconds")
    def scale_out_cooldown_seconds(self) -> pulumi.Input[float]:
        """
        Duration in seconds that FinSpace will wait after a scale out event before initiating another scaling event.
        """
        return pulumi.get(self, "scale_out_cooldown_seconds")

    @scale_out_cooldown_seconds.setter
    def scale_out_cooldown_seconds(self, value: pulumi.Input[float]):
        pulumi.set(self, "scale_out_cooldown_seconds", value)


@pulumi.input_type
class KxClusterCacheStorageConfigurationArgs:
    def __init__(__self__, *,
                 size: pulumi.Input[int],
                 type: pulumi.Input[str]):
        """
        :param pulumi.Input[int] size: Size of cache in Gigabytes.
        :param pulumi.Input[str] type: Type of KDB database. The following types are available:
               * HDB - Historical Database. The data is only accessible with read-only permissions from one of the FinSpace managed KX databases mounted to the cluster.
               * RDB - Realtime Database. This type of database captures all the data from a ticker plant and stores it in memory until the end of day, after which it writes all of its data to a disk and reloads the HDB. This cluster type requires local storage for temporary storage of data during the savedown process. If you specify this field in your request, you must provide the `savedownStorageConfiguration` parameter.
               * GATEWAY - A gateway cluster allows you to access data across processes in kdb systems. It allows you to create your own routing logic using the initialization scripts and custom code. This type of cluster does not require a  writable local storage.
        """
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def size(self) -> pulumi.Input[int]:
        """
        Size of cache in Gigabytes.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: pulumi.Input[int]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of KDB database. The following types are available:
        * HDB - Historical Database. The data is only accessible with read-only permissions from one of the FinSpace managed KX databases mounted to the cluster.
        * RDB - Realtime Database. This type of database captures all the data from a ticker plant and stores it in memory until the end of day, after which it writes all of its data to a disk and reloads the HDB. This cluster type requires local storage for temporary storage of data during the savedown process. If you specify this field in your request, you must provide the `savedownStorageConfiguration` parameter.
        * GATEWAY - A gateway cluster allows you to access data across processes in kdb systems. It allows you to create your own routing logic using the initialization scripts and custom code. This type of cluster does not require a  writable local storage.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class KxClusterCapacityConfigurationArgs:
    def __init__(__self__, *,
                 node_count: pulumi.Input[int],
                 node_type: pulumi.Input[str]):
        """
        :param pulumi.Input[int] node_count: Number of instances running in a cluster. Must be at least 1 and at most 5.
        :param pulumi.Input[str] node_type: Determines the hardware of the host computer used for your cluster instance. Each node type offers different memory and storage capabilities. Choose a node type based on the requirements of the application or software that you plan to run on your instance.
               
               You can only specify one of the following values:
               * kx.s.large – The node type with a configuration of 12 GiB memory and 2 vCPUs.
               * kx.s.xlarge – The node type with a configuration of 27 GiB memory and 4 vCPUs.
               * kx.s.2xlarge – The node type with a configuration of 54 GiB memory and 8 vCPUs.
               * kx.s.4xlarge – The node type with a configuration of 108 GiB memory and 16 vCPUs.
               * kx.s.8xlarge – The node type with a configuration of 216 GiB memory and 32 vCPUs.
               * kx.s.16xlarge – The node type with a configuration of 432 GiB memory and 64 vCPUs.
               * kx.s.32xlarge – The node type with a configuration of 864 GiB memory and 128 vCPUs.
        """
        pulumi.set(__self__, "node_count", node_count)
        pulumi.set(__self__, "node_type", node_type)

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> pulumi.Input[int]:
        """
        Number of instances running in a cluster. Must be at least 1 and at most 5.
        """
        return pulumi.get(self, "node_count")

    @node_count.setter
    def node_count(self, value: pulumi.Input[int]):
        pulumi.set(self, "node_count", value)

    @property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> pulumi.Input[str]:
        """
        Determines the hardware of the host computer used for your cluster instance. Each node type offers different memory and storage capabilities. Choose a node type based on the requirements of the application or software that you plan to run on your instance.

        You can only specify one of the following values:
        * kx.s.large – The node type with a configuration of 12 GiB memory and 2 vCPUs.
        * kx.s.xlarge – The node type with a configuration of 27 GiB memory and 4 vCPUs.
        * kx.s.2xlarge – The node type with a configuration of 54 GiB memory and 8 vCPUs.
        * kx.s.4xlarge – The node type with a configuration of 108 GiB memory and 16 vCPUs.
        * kx.s.8xlarge – The node type with a configuration of 216 GiB memory and 32 vCPUs.
        * kx.s.16xlarge – The node type with a configuration of 432 GiB memory and 64 vCPUs.
        * kx.s.32xlarge – The node type with a configuration of 864 GiB memory and 128 vCPUs.
        """
        return pulumi.get(self, "node_type")

    @node_type.setter
    def node_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "node_type", value)


@pulumi.input_type
class KxClusterCodeArgs:
    def __init__(__self__, *,
                 s3_bucket: pulumi.Input[str],
                 s3_key: pulumi.Input[str],
                 s3_object_version: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] s3_bucket: Unique name for the S3 bucket.
        :param pulumi.Input[str] s3_key: Full S3 path (excluding bucket) to the .zip file that contains the code to be loaded onto the cluster when it’s started.
        :param pulumi.Input[str] s3_object_version: Version of an S3 Object.
        """
        pulumi.set(__self__, "s3_bucket", s3_bucket)
        pulumi.set(__self__, "s3_key", s3_key)
        if s3_object_version is not None:
            pulumi.set(__self__, "s3_object_version", s3_object_version)

    @property
    @pulumi.getter(name="s3Bucket")
    def s3_bucket(self) -> pulumi.Input[str]:
        """
        Unique name for the S3 bucket.
        """
        return pulumi.get(self, "s3_bucket")

    @s3_bucket.setter
    def s3_bucket(self, value: pulumi.Input[str]):
        pulumi.set(self, "s3_bucket", value)

    @property
    @pulumi.getter(name="s3Key")
    def s3_key(self) -> pulumi.Input[str]:
        """
        Full S3 path (excluding bucket) to the .zip file that contains the code to be loaded onto the cluster when it’s started.
        """
        return pulumi.get(self, "s3_key")

    @s3_key.setter
    def s3_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "s3_key", value)

    @property
    @pulumi.getter(name="s3ObjectVersion")
    def s3_object_version(self) -> Optional[pulumi.Input[str]]:
        """
        Version of an S3 Object.
        """
        return pulumi.get(self, "s3_object_version")

    @s3_object_version.setter
    def s3_object_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "s3_object_version", value)


@pulumi.input_type
class KxClusterDatabaseArgs:
    def __init__(__self__, *,
                 database_name: pulumi.Input[str],
                 cache_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['KxClusterDatabaseCacheConfigurationArgs']]]] = None,
                 changeset_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] database_name: Name of the KX database.
        :param pulumi.Input[Sequence[pulumi.Input['KxClusterDatabaseCacheConfigurationArgs']]] cache_configurations: Configuration details for the disk cache to increase performance reading from a KX database mounted to the cluster. See cache_configurations.
        :param pulumi.Input[str] changeset_id: A unique identifier of the changeset that is associated with the cluster.
        """
        pulumi.set(__self__, "database_name", database_name)
        if cache_configurations is not None:
            pulumi.set(__self__, "cache_configurations", cache_configurations)
        if changeset_id is not None:
            pulumi.set(__self__, "changeset_id", changeset_id)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Input[str]:
        """
        Name of the KX database.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "database_name", value)

    @property
    @pulumi.getter(name="cacheConfigurations")
    def cache_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KxClusterDatabaseCacheConfigurationArgs']]]]:
        """
        Configuration details for the disk cache to increase performance reading from a KX database mounted to the cluster. See cache_configurations.
        """
        return pulumi.get(self, "cache_configurations")

    @cache_configurations.setter
    def cache_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KxClusterDatabaseCacheConfigurationArgs']]]]):
        pulumi.set(self, "cache_configurations", value)

    @property
    @pulumi.getter(name="changesetId")
    def changeset_id(self) -> Optional[pulumi.Input[str]]:
        """
        A unique identifier of the changeset that is associated with the cluster.
        """
        return pulumi.get(self, "changeset_id")

    @changeset_id.setter
    def changeset_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "changeset_id", value)


@pulumi.input_type
class KxClusterDatabaseCacheConfigurationArgs:
    def __init__(__self__, *,
                 cache_type: pulumi.Input[str],
                 db_paths: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] cache_type: Type of disk cache.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] db_paths: Paths within the database to cache.
        """
        pulumi.set(__self__, "cache_type", cache_type)
        if db_paths is not None:
            pulumi.set(__self__, "db_paths", db_paths)

    @property
    @pulumi.getter(name="cacheType")
    def cache_type(self) -> pulumi.Input[str]:
        """
        Type of disk cache.
        """
        return pulumi.get(self, "cache_type")

    @cache_type.setter
    def cache_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "cache_type", value)

    @property
    @pulumi.getter(name="dbPaths")
    def db_paths(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Paths within the database to cache.
        """
        return pulumi.get(self, "db_paths")

    @db_paths.setter
    def db_paths(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "db_paths", value)


@pulumi.input_type
class KxClusterSavedownStorageConfigurationArgs:
    def __init__(__self__, *,
                 size: pulumi.Input[int],
                 type: pulumi.Input[str]):
        """
        :param pulumi.Input[int] size: Size of temporary storage in gigabytes. Must be between 10 and 16000.
        :param pulumi.Input[str] type: Type of writeable storage space for temporarily storing your savedown data. The valid values are:
               * SDS01 - This type represents 3000 IOPS and io2 ebs volume type.
        """
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def size(self) -> pulumi.Input[int]:
        """
        Size of temporary storage in gigabytes. Must be between 10 and 16000.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: pulumi.Input[int]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of writeable storage space for temporarily storing your savedown data. The valid values are:
        * SDS01 - This type represents 3000 IOPS and io2 ebs volume type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class KxClusterVpcConfigurationArgs:
    def __init__(__self__, *,
                 ip_address_type: pulumi.Input[str],
                 security_group_ids: pulumi.Input[Sequence[pulumi.Input[str]]],
                 subnet_ids: pulumi.Input[Sequence[pulumi.Input[str]]],
                 vpc_id: pulumi.Input[str]):
        """
        :param pulumi.Input[str] ip_address_type: IP address type for cluster network configuration parameters. The following type is available: IP_V4 - IP address version 4.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: Unique identifier of the VPC security group applied to the VPC endpoint ENI for the cluster.
               * `subnet_ids `- (Required) Identifier of the subnet that the Privatelink VPC endpoint uses to connect to the cluster.
        :param pulumi.Input[str] vpc_id: Identifier of the VPC endpoint
        """
        pulumi.set(__self__, "ip_address_type", ip_address_type)
        pulumi.set(__self__, "security_group_ids", security_group_ids)
        pulumi.set(__self__, "subnet_ids", subnet_ids)
        pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="ipAddressType")
    def ip_address_type(self) -> pulumi.Input[str]:
        """
        IP address type for cluster network configuration parameters. The following type is available: IP_V4 - IP address version 4.
        """
        return pulumi.get(self, "ip_address_type")

    @ip_address_type.setter
    def ip_address_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "ip_address_type", value)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Unique identifier of the VPC security group applied to the VPC endpoint ENI for the cluster.
        * `subnet_ids `- (Required) Identifier of the subnet that the Privatelink VPC endpoint uses to connect to the cluster.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "security_group_ids", value)

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        return pulumi.get(self, "subnet_ids")

    @subnet_ids.setter
    def subnet_ids(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "subnet_ids", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[str]:
        """
        Identifier of the VPC endpoint
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vpc_id", value)


@pulumi.input_type
class KxEnvironmentCustomDnsConfigurationArgs:
    def __init__(__self__, *,
                 custom_dns_server_ip: pulumi.Input[str],
                 custom_dns_server_name: pulumi.Input[str]):
        """
        :param pulumi.Input[str] custom_dns_server_ip: IP address of the DNS server.
        :param pulumi.Input[str] custom_dns_server_name: Name of the DNS server.
        """
        pulumi.set(__self__, "custom_dns_server_ip", custom_dns_server_ip)
        pulumi.set(__self__, "custom_dns_server_name", custom_dns_server_name)

    @property
    @pulumi.getter(name="customDnsServerIp")
    def custom_dns_server_ip(self) -> pulumi.Input[str]:
        """
        IP address of the DNS server.
        """
        return pulumi.get(self, "custom_dns_server_ip")

    @custom_dns_server_ip.setter
    def custom_dns_server_ip(self, value: pulumi.Input[str]):
        pulumi.set(self, "custom_dns_server_ip", value)

    @property
    @pulumi.getter(name="customDnsServerName")
    def custom_dns_server_name(self) -> pulumi.Input[str]:
        """
        Name of the DNS server.
        """
        return pulumi.get(self, "custom_dns_server_name")

    @custom_dns_server_name.setter
    def custom_dns_server_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "custom_dns_server_name", value)


@pulumi.input_type
class KxEnvironmentTransitGatewayConfigurationArgs:
    def __init__(__self__, *,
                 routable_cidr_space: pulumi.Input[str],
                 transit_gateway_id: pulumi.Input[str]):
        """
        :param pulumi.Input[str] routable_cidr_space: Routing CIDR on behalf of KX environment. It could be any “/26 range in the 100.64.0.0 CIDR space. After providing, it will be added to the customer’s transit gateway routing table so that the traffics could be routed to KX network.
        :param pulumi.Input[str] transit_gateway_id: Identifier of the transit gateway created by the customer to connect outbound traffics from KX network to your internal network.
        """
        pulumi.set(__self__, "routable_cidr_space", routable_cidr_space)
        pulumi.set(__self__, "transit_gateway_id", transit_gateway_id)

    @property
    @pulumi.getter(name="routableCidrSpace")
    def routable_cidr_space(self) -> pulumi.Input[str]:
        """
        Routing CIDR on behalf of KX environment. It could be any “/26 range in the 100.64.0.0 CIDR space. After providing, it will be added to the customer’s transit gateway routing table so that the traffics could be routed to KX network.
        """
        return pulumi.get(self, "routable_cidr_space")

    @routable_cidr_space.setter
    def routable_cidr_space(self, value: pulumi.Input[str]):
        pulumi.set(self, "routable_cidr_space", value)

    @property
    @pulumi.getter(name="transitGatewayId")
    def transit_gateway_id(self) -> pulumi.Input[str]:
        """
        Identifier of the transit gateway created by the customer to connect outbound traffics from KX network to your internal network.
        """
        return pulumi.get(self, "transit_gateway_id")

    @transit_gateway_id.setter
    def transit_gateway_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "transit_gateway_id", value)


