# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['KxClusterArgs', 'KxCluster']

@pulumi.input_type
class KxClusterArgs:
    def __init__(__self__, *,
                 az_mode: pulumi.Input[str],
                 capacity_configuration: pulumi.Input['KxClusterCapacityConfigurationArgs'],
                 environment_id: pulumi.Input[str],
                 release_label: pulumi.Input[str],
                 type: pulumi.Input[str],
                 vpc_configuration: pulumi.Input['KxClusterVpcConfigurationArgs'],
                 auto_scaling_configuration: Optional[pulumi.Input['KxClusterAutoScalingConfigurationArgs']] = None,
                 availability_zone_id: Optional[pulumi.Input[str]] = None,
                 cache_storage_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['KxClusterCacheStorageConfigurationArgs']]]] = None,
                 code: Optional[pulumi.Input['KxClusterCodeArgs']] = None,
                 command_line_arguments: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 databases: Optional[pulumi.Input[Sequence[pulumi.Input['KxClusterDatabaseArgs']]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 execution_role: Optional[pulumi.Input[str]] = None,
                 initialization_script: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 savedown_storage_configuration: Optional[pulumi.Input['KxClusterSavedownStorageConfigurationArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a KxCluster resource.
        :param pulumi.Input[str] az_mode: The number of availability zones you want to assign per cluster. This can be one of the following:
               * SINGLE - Assigns one availability zone per cluster.
               * MULTI - Assigns all the availability zones per cluster.
        :param pulumi.Input['KxClusterCapacityConfigurationArgs'] capacity_configuration: Structure for the metadata of a cluster. Includes information like the CPUs needed, memory of instances, and number of instances. See capacity_configuration.
        :param pulumi.Input[str] environment_id: Unique identifier for the KX environment.
        :param pulumi.Input[str] release_label: Version of FinSpace Managed kdb to run.
        :param pulumi.Input[str] type: Type of KDB database. The following types are available:
               * HDB - Historical Database. The data is only accessible with read-only permissions from one of the FinSpace managed KX databases mounted to the cluster.
               * RDB - Realtime Database. This type of database captures all the data from a ticker plant and stores it in memory until the end of day, after which it writes all of its data to a disk and reloads the HDB. This cluster type requires local storage for temporary storage of data during the savedown process. If you specify this field in your request, you must provide the `savedownStorageConfiguration` parameter.
               * GATEWAY - A gateway cluster allows you to access data across processes in kdb systems. It allows you to create your own routing logic using the initialization scripts and custom code. This type of cluster does not require a  writable local storage.
        :param pulumi.Input['KxClusterVpcConfigurationArgs'] vpc_configuration: Configuration details about the network where the Privatelink endpoint of the cluster resides. See vpc_configuration.
               
               The following arguments are optional:
        :param pulumi.Input['KxClusterAutoScalingConfigurationArgs'] auto_scaling_configuration: Configuration based on which FinSpace will scale in or scale out nodes in your cluster. See auto_scaling_configuration.
        :param pulumi.Input[str] availability_zone_id: The availability zone identifiers for the requested regions. Required when `az_mode` is set to SINGLE.
        :param pulumi.Input[Sequence[pulumi.Input['KxClusterCacheStorageConfigurationArgs']]] cache_storage_configurations: Configurations for a read only cache storage associated with a cluster. This cache will be stored as an FSx Lustre that reads from the S3 store. See cache_storage_configuration.
        :param pulumi.Input['KxClusterCodeArgs'] code: Details of the custom code that you want to use inside a cluster when analyzing data. Consists of the S3 source bucket, location, object version, and the relative path from where the custom code is loaded into the cluster. See code.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] command_line_arguments: List of key-value pairs to make available inside the cluster.
        :param pulumi.Input[Sequence[pulumi.Input['KxClusterDatabaseArgs']]] databases: KX database that will be available for querying. Defined below.
        :param pulumi.Input[str] description: Description of the cluster.
        :param pulumi.Input[str] execution_role: An IAM role that defines a set of permissions associated with a cluster. These permissions are assumed when a cluster attempts to access another cluster.
        :param pulumi.Input[str] initialization_script: Path to Q program that will be run at launch of a cluster. This is a relative path within .zip file that contains the custom code, which will be loaded on the cluster. It must include the file name itself. For example, somedir/init.q.
        :param pulumi.Input[str] name: Unique name for the cluster that you want to create.
        :param pulumi.Input['KxClusterSavedownStorageConfigurationArgs'] savedown_storage_configuration: Size and type of the temporary storage that is used to hold data during the savedown process. This parameter is required when you choose `type` as RDB. All the data written to this storage space is lost when the cluster node is restarted. See savedown_storage_configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        pulumi.set(__self__, "az_mode", az_mode)
        pulumi.set(__self__, "capacity_configuration", capacity_configuration)
        pulumi.set(__self__, "environment_id", environment_id)
        pulumi.set(__self__, "release_label", release_label)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "vpc_configuration", vpc_configuration)
        if auto_scaling_configuration is not None:
            pulumi.set(__self__, "auto_scaling_configuration", auto_scaling_configuration)
        if availability_zone_id is not None:
            pulumi.set(__self__, "availability_zone_id", availability_zone_id)
        if cache_storage_configurations is not None:
            pulumi.set(__self__, "cache_storage_configurations", cache_storage_configurations)
        if code is not None:
            pulumi.set(__self__, "code", code)
        if command_line_arguments is not None:
            pulumi.set(__self__, "command_line_arguments", command_line_arguments)
        if databases is not None:
            pulumi.set(__self__, "databases", databases)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if execution_role is not None:
            pulumi.set(__self__, "execution_role", execution_role)
        if initialization_script is not None:
            pulumi.set(__self__, "initialization_script", initialization_script)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if savedown_storage_configuration is not None:
            pulumi.set(__self__, "savedown_storage_configuration", savedown_storage_configuration)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="azMode")
    def az_mode(self) -> pulumi.Input[str]:
        """
        The number of availability zones you want to assign per cluster. This can be one of the following:
        * SINGLE - Assigns one availability zone per cluster.
        * MULTI - Assigns all the availability zones per cluster.
        """
        return pulumi.get(self, "az_mode")

    @az_mode.setter
    def az_mode(self, value: pulumi.Input[str]):
        pulumi.set(self, "az_mode", value)

    @property
    @pulumi.getter(name="capacityConfiguration")
    def capacity_configuration(self) -> pulumi.Input['KxClusterCapacityConfigurationArgs']:
        """
        Structure for the metadata of a cluster. Includes information like the CPUs needed, memory of instances, and number of instances. See capacity_configuration.
        """
        return pulumi.get(self, "capacity_configuration")

    @capacity_configuration.setter
    def capacity_configuration(self, value: pulumi.Input['KxClusterCapacityConfigurationArgs']):
        pulumi.set(self, "capacity_configuration", value)

    @property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> pulumi.Input[str]:
        """
        Unique identifier for the KX environment.
        """
        return pulumi.get(self, "environment_id")

    @environment_id.setter
    def environment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "environment_id", value)

    @property
    @pulumi.getter(name="releaseLabel")
    def release_label(self) -> pulumi.Input[str]:
        """
        Version of FinSpace Managed kdb to run.
        """
        return pulumi.get(self, "release_label")

    @release_label.setter
    def release_label(self, value: pulumi.Input[str]):
        pulumi.set(self, "release_label", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of KDB database. The following types are available:
        * HDB - Historical Database. The data is only accessible with read-only permissions from one of the FinSpace managed KX databases mounted to the cluster.
        * RDB - Realtime Database. This type of database captures all the data from a ticker plant and stores it in memory until the end of day, after which it writes all of its data to a disk and reloads the HDB. This cluster type requires local storage for temporary storage of data during the savedown process. If you specify this field in your request, you must provide the `savedownStorageConfiguration` parameter.
        * GATEWAY - A gateway cluster allows you to access data across processes in kdb systems. It allows you to create your own routing logic using the initialization scripts and custom code. This type of cluster does not require a  writable local storage.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="vpcConfiguration")
    def vpc_configuration(self) -> pulumi.Input['KxClusterVpcConfigurationArgs']:
        """
        Configuration details about the network where the Privatelink endpoint of the cluster resides. See vpc_configuration.

        The following arguments are optional:
        """
        return pulumi.get(self, "vpc_configuration")

    @vpc_configuration.setter
    def vpc_configuration(self, value: pulumi.Input['KxClusterVpcConfigurationArgs']):
        pulumi.set(self, "vpc_configuration", value)

    @property
    @pulumi.getter(name="autoScalingConfiguration")
    def auto_scaling_configuration(self) -> Optional[pulumi.Input['KxClusterAutoScalingConfigurationArgs']]:
        """
        Configuration based on which FinSpace will scale in or scale out nodes in your cluster. See auto_scaling_configuration.
        """
        return pulumi.get(self, "auto_scaling_configuration")

    @auto_scaling_configuration.setter
    def auto_scaling_configuration(self, value: Optional[pulumi.Input['KxClusterAutoScalingConfigurationArgs']]):
        pulumi.set(self, "auto_scaling_configuration", value)

    @property
    @pulumi.getter(name="availabilityZoneId")
    def availability_zone_id(self) -> Optional[pulumi.Input[str]]:
        """
        The availability zone identifiers for the requested regions. Required when `az_mode` is set to SINGLE.
        """
        return pulumi.get(self, "availability_zone_id")

    @availability_zone_id.setter
    def availability_zone_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_zone_id", value)

    @property
    @pulumi.getter(name="cacheStorageConfigurations")
    def cache_storage_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KxClusterCacheStorageConfigurationArgs']]]]:
        """
        Configurations for a read only cache storage associated with a cluster. This cache will be stored as an FSx Lustre that reads from the S3 store. See cache_storage_configuration.
        """
        return pulumi.get(self, "cache_storage_configurations")

    @cache_storage_configurations.setter
    def cache_storage_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KxClusterCacheStorageConfigurationArgs']]]]):
        pulumi.set(self, "cache_storage_configurations", value)

    @property
    @pulumi.getter
    def code(self) -> Optional[pulumi.Input['KxClusterCodeArgs']]:
        """
        Details of the custom code that you want to use inside a cluster when analyzing data. Consists of the S3 source bucket, location, object version, and the relative path from where the custom code is loaded into the cluster. See code.
        """
        return pulumi.get(self, "code")

    @code.setter
    def code(self, value: Optional[pulumi.Input['KxClusterCodeArgs']]):
        pulumi.set(self, "code", value)

    @property
    @pulumi.getter(name="commandLineArguments")
    def command_line_arguments(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        List of key-value pairs to make available inside the cluster.
        """
        return pulumi.get(self, "command_line_arguments")

    @command_line_arguments.setter
    def command_line_arguments(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "command_line_arguments", value)

    @property
    @pulumi.getter
    def databases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KxClusterDatabaseArgs']]]]:
        """
        KX database that will be available for querying. Defined below.
        """
        return pulumi.get(self, "databases")

    @databases.setter
    def databases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KxClusterDatabaseArgs']]]]):
        pulumi.set(self, "databases", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the cluster.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="executionRole")
    def execution_role(self) -> Optional[pulumi.Input[str]]:
        """
        An IAM role that defines a set of permissions associated with a cluster. These permissions are assumed when a cluster attempts to access another cluster.
        """
        return pulumi.get(self, "execution_role")

    @execution_role.setter
    def execution_role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "execution_role", value)

    @property
    @pulumi.getter(name="initializationScript")
    def initialization_script(self) -> Optional[pulumi.Input[str]]:
        """
        Path to Q program that will be run at launch of a cluster. This is a relative path within .zip file that contains the custom code, which will be loaded on the cluster. It must include the file name itself. For example, somedir/init.q.
        """
        return pulumi.get(self, "initialization_script")

    @initialization_script.setter
    def initialization_script(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "initialization_script", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Unique name for the cluster that you want to create.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="savedownStorageConfiguration")
    def savedown_storage_configuration(self) -> Optional[pulumi.Input['KxClusterSavedownStorageConfigurationArgs']]:
        """
        Size and type of the temporary storage that is used to hold data during the savedown process. This parameter is required when you choose `type` as RDB. All the data written to this storage space is lost when the cluster node is restarted. See savedown_storage_configuration.
        """
        return pulumi.get(self, "savedown_storage_configuration")

    @savedown_storage_configuration.setter
    def savedown_storage_configuration(self, value: Optional[pulumi.Input['KxClusterSavedownStorageConfigurationArgs']]):
        pulumi.set(self, "savedown_storage_configuration", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _KxClusterState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[str]] = None,
                 auto_scaling_configuration: Optional[pulumi.Input['KxClusterAutoScalingConfigurationArgs']] = None,
                 availability_zone_id: Optional[pulumi.Input[str]] = None,
                 az_mode: Optional[pulumi.Input[str]] = None,
                 cache_storage_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['KxClusterCacheStorageConfigurationArgs']]]] = None,
                 capacity_configuration: Optional[pulumi.Input['KxClusterCapacityConfigurationArgs']] = None,
                 code: Optional[pulumi.Input['KxClusterCodeArgs']] = None,
                 command_line_arguments: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 created_timestamp: Optional[pulumi.Input[str]] = None,
                 databases: Optional[pulumi.Input[Sequence[pulumi.Input['KxClusterDatabaseArgs']]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 environment_id: Optional[pulumi.Input[str]] = None,
                 execution_role: Optional[pulumi.Input[str]] = None,
                 initialization_script: Optional[pulumi.Input[str]] = None,
                 last_modified_timestamp: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 release_label: Optional[pulumi.Input[str]] = None,
                 savedown_storage_configuration: Optional[pulumi.Input['KxClusterSavedownStorageConfigurationArgs']] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 status_reason: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 vpc_configuration: Optional[pulumi.Input['KxClusterVpcConfigurationArgs']] = None):
        """
        Input properties used for looking up and filtering KxCluster resources.
        :param pulumi.Input[str] arn: Amazon Resource Name (ARN) identifier of the KX cluster.
        :param pulumi.Input['KxClusterAutoScalingConfigurationArgs'] auto_scaling_configuration: Configuration based on which FinSpace will scale in or scale out nodes in your cluster. See auto_scaling_configuration.
        :param pulumi.Input[str] availability_zone_id: The availability zone identifiers for the requested regions. Required when `az_mode` is set to SINGLE.
        :param pulumi.Input[str] az_mode: The number of availability zones you want to assign per cluster. This can be one of the following:
               * SINGLE - Assigns one availability zone per cluster.
               * MULTI - Assigns all the availability zones per cluster.
        :param pulumi.Input[Sequence[pulumi.Input['KxClusterCacheStorageConfigurationArgs']]] cache_storage_configurations: Configurations for a read only cache storage associated with a cluster. This cache will be stored as an FSx Lustre that reads from the S3 store. See cache_storage_configuration.
        :param pulumi.Input['KxClusterCapacityConfigurationArgs'] capacity_configuration: Structure for the metadata of a cluster. Includes information like the CPUs needed, memory of instances, and number of instances. See capacity_configuration.
        :param pulumi.Input['KxClusterCodeArgs'] code: Details of the custom code that you want to use inside a cluster when analyzing data. Consists of the S3 source bucket, location, object version, and the relative path from where the custom code is loaded into the cluster. See code.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] command_line_arguments: List of key-value pairs to make available inside the cluster.
        :param pulumi.Input[str] created_timestamp: Timestamp at which the cluster is created in FinSpace. Value determined as epoch time in seconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000.
        :param pulumi.Input[Sequence[pulumi.Input['KxClusterDatabaseArgs']]] databases: KX database that will be available for querying. Defined below.
        :param pulumi.Input[str] description: Description of the cluster.
        :param pulumi.Input[str] environment_id: Unique identifier for the KX environment.
        :param pulumi.Input[str] execution_role: An IAM role that defines a set of permissions associated with a cluster. These permissions are assumed when a cluster attempts to access another cluster.
        :param pulumi.Input[str] initialization_script: Path to Q program that will be run at launch of a cluster. This is a relative path within .zip file that contains the custom code, which will be loaded on the cluster. It must include the file name itself. For example, somedir/init.q.
        :param pulumi.Input[str] last_modified_timestamp: Last timestamp at which the cluster was updated in FinSpace. Value determined as epoch time in seconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000.
        :param pulumi.Input[str] name: Unique name for the cluster that you want to create.
        :param pulumi.Input[str] release_label: Version of FinSpace Managed kdb to run.
        :param pulumi.Input['KxClusterSavedownStorageConfigurationArgs'] savedown_storage_configuration: Size and type of the temporary storage that is used to hold data during the savedown process. This parameter is required when you choose `type` as RDB. All the data written to this storage space is lost when the cluster node is restarted. See savedown_storage_configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[str] type: Type of KDB database. The following types are available:
               * HDB - Historical Database. The data is only accessible with read-only permissions from one of the FinSpace managed KX databases mounted to the cluster.
               * RDB - Realtime Database. This type of database captures all the data from a ticker plant and stores it in memory until the end of day, after which it writes all of its data to a disk and reloads the HDB. This cluster type requires local storage for temporary storage of data during the savedown process. If you specify this field in your request, you must provide the `savedownStorageConfiguration` parameter.
               * GATEWAY - A gateway cluster allows you to access data across processes in kdb systems. It allows you to create your own routing logic using the initialization scripts and custom code. This type of cluster does not require a  writable local storage.
        :param pulumi.Input['KxClusterVpcConfigurationArgs'] vpc_configuration: Configuration details about the network where the Privatelink endpoint of the cluster resides. See vpc_configuration.
               
               The following arguments are optional:
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if auto_scaling_configuration is not None:
            pulumi.set(__self__, "auto_scaling_configuration", auto_scaling_configuration)
        if availability_zone_id is not None:
            pulumi.set(__self__, "availability_zone_id", availability_zone_id)
        if az_mode is not None:
            pulumi.set(__self__, "az_mode", az_mode)
        if cache_storage_configurations is not None:
            pulumi.set(__self__, "cache_storage_configurations", cache_storage_configurations)
        if capacity_configuration is not None:
            pulumi.set(__self__, "capacity_configuration", capacity_configuration)
        if code is not None:
            pulumi.set(__self__, "code", code)
        if command_line_arguments is not None:
            pulumi.set(__self__, "command_line_arguments", command_line_arguments)
        if created_timestamp is not None:
            pulumi.set(__self__, "created_timestamp", created_timestamp)
        if databases is not None:
            pulumi.set(__self__, "databases", databases)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if environment_id is not None:
            pulumi.set(__self__, "environment_id", environment_id)
        if execution_role is not None:
            pulumi.set(__self__, "execution_role", execution_role)
        if initialization_script is not None:
            pulumi.set(__self__, "initialization_script", initialization_script)
        if last_modified_timestamp is not None:
            pulumi.set(__self__, "last_modified_timestamp", last_modified_timestamp)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if release_label is not None:
            pulumi.set(__self__, "release_label", release_label)
        if savedown_storage_configuration is not None:
            pulumi.set(__self__, "savedown_storage_configuration", savedown_storage_configuration)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if status_reason is not None:
            pulumi.set(__self__, "status_reason", status_reason)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if vpc_configuration is not None:
            pulumi.set(__self__, "vpc_configuration", vpc_configuration)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        Amazon Resource Name (ARN) identifier of the KX cluster.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="autoScalingConfiguration")
    def auto_scaling_configuration(self) -> Optional[pulumi.Input['KxClusterAutoScalingConfigurationArgs']]:
        """
        Configuration based on which FinSpace will scale in or scale out nodes in your cluster. See auto_scaling_configuration.
        """
        return pulumi.get(self, "auto_scaling_configuration")

    @auto_scaling_configuration.setter
    def auto_scaling_configuration(self, value: Optional[pulumi.Input['KxClusterAutoScalingConfigurationArgs']]):
        pulumi.set(self, "auto_scaling_configuration", value)

    @property
    @pulumi.getter(name="availabilityZoneId")
    def availability_zone_id(self) -> Optional[pulumi.Input[str]]:
        """
        The availability zone identifiers for the requested regions. Required when `az_mode` is set to SINGLE.
        """
        return pulumi.get(self, "availability_zone_id")

    @availability_zone_id.setter
    def availability_zone_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_zone_id", value)

    @property
    @pulumi.getter(name="azMode")
    def az_mode(self) -> Optional[pulumi.Input[str]]:
        """
        The number of availability zones you want to assign per cluster. This can be one of the following:
        * SINGLE - Assigns one availability zone per cluster.
        * MULTI - Assigns all the availability zones per cluster.
        """
        return pulumi.get(self, "az_mode")

    @az_mode.setter
    def az_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "az_mode", value)

    @property
    @pulumi.getter(name="cacheStorageConfigurations")
    def cache_storage_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KxClusterCacheStorageConfigurationArgs']]]]:
        """
        Configurations for a read only cache storage associated with a cluster. This cache will be stored as an FSx Lustre that reads from the S3 store. See cache_storage_configuration.
        """
        return pulumi.get(self, "cache_storage_configurations")

    @cache_storage_configurations.setter
    def cache_storage_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KxClusterCacheStorageConfigurationArgs']]]]):
        pulumi.set(self, "cache_storage_configurations", value)

    @property
    @pulumi.getter(name="capacityConfiguration")
    def capacity_configuration(self) -> Optional[pulumi.Input['KxClusterCapacityConfigurationArgs']]:
        """
        Structure for the metadata of a cluster. Includes information like the CPUs needed, memory of instances, and number of instances. See capacity_configuration.
        """
        return pulumi.get(self, "capacity_configuration")

    @capacity_configuration.setter
    def capacity_configuration(self, value: Optional[pulumi.Input['KxClusterCapacityConfigurationArgs']]):
        pulumi.set(self, "capacity_configuration", value)

    @property
    @pulumi.getter
    def code(self) -> Optional[pulumi.Input['KxClusterCodeArgs']]:
        """
        Details of the custom code that you want to use inside a cluster when analyzing data. Consists of the S3 source bucket, location, object version, and the relative path from where the custom code is loaded into the cluster. See code.
        """
        return pulumi.get(self, "code")

    @code.setter
    def code(self, value: Optional[pulumi.Input['KxClusterCodeArgs']]):
        pulumi.set(self, "code", value)

    @property
    @pulumi.getter(name="commandLineArguments")
    def command_line_arguments(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        List of key-value pairs to make available inside the cluster.
        """
        return pulumi.get(self, "command_line_arguments")

    @command_line_arguments.setter
    def command_line_arguments(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "command_line_arguments", value)

    @property
    @pulumi.getter(name="createdTimestamp")
    def created_timestamp(self) -> Optional[pulumi.Input[str]]:
        """
        Timestamp at which the cluster is created in FinSpace. Value determined as epoch time in seconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000.
        """
        return pulumi.get(self, "created_timestamp")

    @created_timestamp.setter
    def created_timestamp(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_timestamp", value)

    @property
    @pulumi.getter
    def databases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KxClusterDatabaseArgs']]]]:
        """
        KX database that will be available for querying. Defined below.
        """
        return pulumi.get(self, "databases")

    @databases.setter
    def databases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KxClusterDatabaseArgs']]]]):
        pulumi.set(self, "databases", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the cluster.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> Optional[pulumi.Input[str]]:
        """
        Unique identifier for the KX environment.
        """
        return pulumi.get(self, "environment_id")

    @environment_id.setter
    def environment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "environment_id", value)

    @property
    @pulumi.getter(name="executionRole")
    def execution_role(self) -> Optional[pulumi.Input[str]]:
        """
        An IAM role that defines a set of permissions associated with a cluster. These permissions are assumed when a cluster attempts to access another cluster.
        """
        return pulumi.get(self, "execution_role")

    @execution_role.setter
    def execution_role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "execution_role", value)

    @property
    @pulumi.getter(name="initializationScript")
    def initialization_script(self) -> Optional[pulumi.Input[str]]:
        """
        Path to Q program that will be run at launch of a cluster. This is a relative path within .zip file that contains the custom code, which will be loaded on the cluster. It must include the file name itself. For example, somedir/init.q.
        """
        return pulumi.get(self, "initialization_script")

    @initialization_script.setter
    def initialization_script(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "initialization_script", value)

    @property
    @pulumi.getter(name="lastModifiedTimestamp")
    def last_modified_timestamp(self) -> Optional[pulumi.Input[str]]:
        """
        Last timestamp at which the cluster was updated in FinSpace. Value determined as epoch time in seconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000.
        """
        return pulumi.get(self, "last_modified_timestamp")

    @last_modified_timestamp.setter
    def last_modified_timestamp(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_modified_timestamp", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Unique name for the cluster that you want to create.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="releaseLabel")
    def release_label(self) -> Optional[pulumi.Input[str]]:
        """
        Version of FinSpace Managed kdb to run.
        """
        return pulumi.get(self, "release_label")

    @release_label.setter
    def release_label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "release_label", value)

    @property
    @pulumi.getter(name="savedownStorageConfiguration")
    def savedown_storage_configuration(self) -> Optional[pulumi.Input['KxClusterSavedownStorageConfigurationArgs']]:
        """
        Size and type of the temporary storage that is used to hold data during the savedown process. This parameter is required when you choose `type` as RDB. All the data written to this storage space is lost when the cluster node is restarted. See savedown_storage_configuration.
        """
        return pulumi.get(self, "savedown_storage_configuration")

    @savedown_storage_configuration.setter
    def savedown_storage_configuration(self, value: Optional[pulumi.Input['KxClusterSavedownStorageConfigurationArgs']]):
        pulumi.set(self, "savedown_storage_configuration", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="statusReason")
    def status_reason(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "status_reason")

    @status_reason.setter
    def status_reason(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status_reason", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of KDB database. The following types are available:
        * HDB - Historical Database. The data is only accessible with read-only permissions from one of the FinSpace managed KX databases mounted to the cluster.
        * RDB - Realtime Database. This type of database captures all the data from a ticker plant and stores it in memory until the end of day, after which it writes all of its data to a disk and reloads the HDB. This cluster type requires local storage for temporary storage of data during the savedown process. If you specify this field in your request, you must provide the `savedownStorageConfiguration` parameter.
        * GATEWAY - A gateway cluster allows you to access data across processes in kdb systems. It allows you to create your own routing logic using the initialization scripts and custom code. This type of cluster does not require a  writable local storage.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="vpcConfiguration")
    def vpc_configuration(self) -> Optional[pulumi.Input['KxClusterVpcConfigurationArgs']]:
        """
        Configuration details about the network where the Privatelink endpoint of the cluster resides. See vpc_configuration.

        The following arguments are optional:
        """
        return pulumi.get(self, "vpc_configuration")

    @vpc_configuration.setter
    def vpc_configuration(self, value: Optional[pulumi.Input['KxClusterVpcConfigurationArgs']]):
        pulumi.set(self, "vpc_configuration", value)


class KxCluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_scaling_configuration: Optional[pulumi.Input[pulumi.InputType['KxClusterAutoScalingConfigurationArgs']]] = None,
                 availability_zone_id: Optional[pulumi.Input[str]] = None,
                 az_mode: Optional[pulumi.Input[str]] = None,
                 cache_storage_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['KxClusterCacheStorageConfigurationArgs']]]]] = None,
                 capacity_configuration: Optional[pulumi.Input[pulumi.InputType['KxClusterCapacityConfigurationArgs']]] = None,
                 code: Optional[pulumi.Input[pulumi.InputType['KxClusterCodeArgs']]] = None,
                 command_line_arguments: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 databases: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['KxClusterDatabaseArgs']]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 environment_id: Optional[pulumi.Input[str]] = None,
                 execution_role: Optional[pulumi.Input[str]] = None,
                 initialization_script: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 release_label: Optional[pulumi.Input[str]] = None,
                 savedown_storage_configuration: Optional[pulumi.Input[pulumi.InputType['KxClusterSavedownStorageConfigurationArgs']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 vpc_configuration: Optional[pulumi.Input[pulumi.InputType['KxClusterVpcConfigurationArgs']]] = None,
                 __props__=None):
        """
        Resource for managing an AWS FinSpace Kx Cluster.

        ## Example Usage

        ## Import

        Using `pulumi import`, import an AWS FinSpace Kx Cluster using the `id` (environment ID and cluster name, comma-delimited). For example:

        ```sh
         $ pulumi import aws:finspace/kxCluster:KxCluster example n3ceo7wqxoxcti5tujqwzs,my-tf-kx-cluster
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['KxClusterAutoScalingConfigurationArgs']] auto_scaling_configuration: Configuration based on which FinSpace will scale in or scale out nodes in your cluster. See auto_scaling_configuration.
        :param pulumi.Input[str] availability_zone_id: The availability zone identifiers for the requested regions. Required when `az_mode` is set to SINGLE.
        :param pulumi.Input[str] az_mode: The number of availability zones you want to assign per cluster. This can be one of the following:
               * SINGLE - Assigns one availability zone per cluster.
               * MULTI - Assigns all the availability zones per cluster.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['KxClusterCacheStorageConfigurationArgs']]]] cache_storage_configurations: Configurations for a read only cache storage associated with a cluster. This cache will be stored as an FSx Lustre that reads from the S3 store. See cache_storage_configuration.
        :param pulumi.Input[pulumi.InputType['KxClusterCapacityConfigurationArgs']] capacity_configuration: Structure for the metadata of a cluster. Includes information like the CPUs needed, memory of instances, and number of instances. See capacity_configuration.
        :param pulumi.Input[pulumi.InputType['KxClusterCodeArgs']] code: Details of the custom code that you want to use inside a cluster when analyzing data. Consists of the S3 source bucket, location, object version, and the relative path from where the custom code is loaded into the cluster. See code.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] command_line_arguments: List of key-value pairs to make available inside the cluster.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['KxClusterDatabaseArgs']]]] databases: KX database that will be available for querying. Defined below.
        :param pulumi.Input[str] description: Description of the cluster.
        :param pulumi.Input[str] environment_id: Unique identifier for the KX environment.
        :param pulumi.Input[str] execution_role: An IAM role that defines a set of permissions associated with a cluster. These permissions are assumed when a cluster attempts to access another cluster.
        :param pulumi.Input[str] initialization_script: Path to Q program that will be run at launch of a cluster. This is a relative path within .zip file that contains the custom code, which will be loaded on the cluster. It must include the file name itself. For example, somedir/init.q.
        :param pulumi.Input[str] name: Unique name for the cluster that you want to create.
        :param pulumi.Input[str] release_label: Version of FinSpace Managed kdb to run.
        :param pulumi.Input[pulumi.InputType['KxClusterSavedownStorageConfigurationArgs']] savedown_storage_configuration: Size and type of the temporary storage that is used to hold data during the savedown process. This parameter is required when you choose `type` as RDB. All the data written to this storage space is lost when the cluster node is restarted. See savedown_storage_configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[str] type: Type of KDB database. The following types are available:
               * HDB - Historical Database. The data is only accessible with read-only permissions from one of the FinSpace managed KX databases mounted to the cluster.
               * RDB - Realtime Database. This type of database captures all the data from a ticker plant and stores it in memory until the end of day, after which it writes all of its data to a disk and reloads the HDB. This cluster type requires local storage for temporary storage of data during the savedown process. If you specify this field in your request, you must provide the `savedownStorageConfiguration` parameter.
               * GATEWAY - A gateway cluster allows you to access data across processes in kdb systems. It allows you to create your own routing logic using the initialization scripts and custom code. This type of cluster does not require a  writable local storage.
        :param pulumi.Input[pulumi.InputType['KxClusterVpcConfigurationArgs']] vpc_configuration: Configuration details about the network where the Privatelink endpoint of the cluster resides. See vpc_configuration.
               
               The following arguments are optional:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: KxClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS FinSpace Kx Cluster.

        ## Example Usage

        ## Import

        Using `pulumi import`, import an AWS FinSpace Kx Cluster using the `id` (environment ID and cluster name, comma-delimited). For example:

        ```sh
         $ pulumi import aws:finspace/kxCluster:KxCluster example n3ceo7wqxoxcti5tujqwzs,my-tf-kx-cluster
        ```

        :param str resource_name: The name of the resource.
        :param KxClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(KxClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_scaling_configuration: Optional[pulumi.Input[pulumi.InputType['KxClusterAutoScalingConfigurationArgs']]] = None,
                 availability_zone_id: Optional[pulumi.Input[str]] = None,
                 az_mode: Optional[pulumi.Input[str]] = None,
                 cache_storage_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['KxClusterCacheStorageConfigurationArgs']]]]] = None,
                 capacity_configuration: Optional[pulumi.Input[pulumi.InputType['KxClusterCapacityConfigurationArgs']]] = None,
                 code: Optional[pulumi.Input[pulumi.InputType['KxClusterCodeArgs']]] = None,
                 command_line_arguments: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 databases: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['KxClusterDatabaseArgs']]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 environment_id: Optional[pulumi.Input[str]] = None,
                 execution_role: Optional[pulumi.Input[str]] = None,
                 initialization_script: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 release_label: Optional[pulumi.Input[str]] = None,
                 savedown_storage_configuration: Optional[pulumi.Input[pulumi.InputType['KxClusterSavedownStorageConfigurationArgs']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 vpc_configuration: Optional[pulumi.Input[pulumi.InputType['KxClusterVpcConfigurationArgs']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = KxClusterArgs.__new__(KxClusterArgs)

            __props__.__dict__["auto_scaling_configuration"] = auto_scaling_configuration
            __props__.__dict__["availability_zone_id"] = availability_zone_id
            if az_mode is None and not opts.urn:
                raise TypeError("Missing required property 'az_mode'")
            __props__.__dict__["az_mode"] = az_mode
            __props__.__dict__["cache_storage_configurations"] = cache_storage_configurations
            if capacity_configuration is None and not opts.urn:
                raise TypeError("Missing required property 'capacity_configuration'")
            __props__.__dict__["capacity_configuration"] = capacity_configuration
            __props__.__dict__["code"] = code
            __props__.__dict__["command_line_arguments"] = command_line_arguments
            __props__.__dict__["databases"] = databases
            __props__.__dict__["description"] = description
            if environment_id is None and not opts.urn:
                raise TypeError("Missing required property 'environment_id'")
            __props__.__dict__["environment_id"] = environment_id
            __props__.__dict__["execution_role"] = execution_role
            __props__.__dict__["initialization_script"] = initialization_script
            __props__.__dict__["name"] = name
            if release_label is None and not opts.urn:
                raise TypeError("Missing required property 'release_label'")
            __props__.__dict__["release_label"] = release_label
            __props__.__dict__["savedown_storage_configuration"] = savedown_storage_configuration
            __props__.__dict__["tags"] = tags
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            if vpc_configuration is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_configuration'")
            __props__.__dict__["vpc_configuration"] = vpc_configuration
            __props__.__dict__["arn"] = None
            __props__.__dict__["created_timestamp"] = None
            __props__.__dict__["last_modified_timestamp"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["status_reason"] = None
            __props__.__dict__["tags_all"] = None
        super(KxCluster, __self__).__init__(
            'aws:finspace/kxCluster:KxCluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[str]] = None,
            auto_scaling_configuration: Optional[pulumi.Input[pulumi.InputType['KxClusterAutoScalingConfigurationArgs']]] = None,
            availability_zone_id: Optional[pulumi.Input[str]] = None,
            az_mode: Optional[pulumi.Input[str]] = None,
            cache_storage_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['KxClusterCacheStorageConfigurationArgs']]]]] = None,
            capacity_configuration: Optional[pulumi.Input[pulumi.InputType['KxClusterCapacityConfigurationArgs']]] = None,
            code: Optional[pulumi.Input[pulumi.InputType['KxClusterCodeArgs']]] = None,
            command_line_arguments: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            created_timestamp: Optional[pulumi.Input[str]] = None,
            databases: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['KxClusterDatabaseArgs']]]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            environment_id: Optional[pulumi.Input[str]] = None,
            execution_role: Optional[pulumi.Input[str]] = None,
            initialization_script: Optional[pulumi.Input[str]] = None,
            last_modified_timestamp: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            release_label: Optional[pulumi.Input[str]] = None,
            savedown_storage_configuration: Optional[pulumi.Input[pulumi.InputType['KxClusterSavedownStorageConfigurationArgs']]] = None,
            status: Optional[pulumi.Input[str]] = None,
            status_reason: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            type: Optional[pulumi.Input[str]] = None,
            vpc_configuration: Optional[pulumi.Input[pulumi.InputType['KxClusterVpcConfigurationArgs']]] = None) -> 'KxCluster':
        """
        Get an existing KxCluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] arn: Amazon Resource Name (ARN) identifier of the KX cluster.
        :param pulumi.Input[pulumi.InputType['KxClusterAutoScalingConfigurationArgs']] auto_scaling_configuration: Configuration based on which FinSpace will scale in or scale out nodes in your cluster. See auto_scaling_configuration.
        :param pulumi.Input[str] availability_zone_id: The availability zone identifiers for the requested regions. Required when `az_mode` is set to SINGLE.
        :param pulumi.Input[str] az_mode: The number of availability zones you want to assign per cluster. This can be one of the following:
               * SINGLE - Assigns one availability zone per cluster.
               * MULTI - Assigns all the availability zones per cluster.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['KxClusterCacheStorageConfigurationArgs']]]] cache_storage_configurations: Configurations for a read only cache storage associated with a cluster. This cache will be stored as an FSx Lustre that reads from the S3 store. See cache_storage_configuration.
        :param pulumi.Input[pulumi.InputType['KxClusterCapacityConfigurationArgs']] capacity_configuration: Structure for the metadata of a cluster. Includes information like the CPUs needed, memory of instances, and number of instances. See capacity_configuration.
        :param pulumi.Input[pulumi.InputType['KxClusterCodeArgs']] code: Details of the custom code that you want to use inside a cluster when analyzing data. Consists of the S3 source bucket, location, object version, and the relative path from where the custom code is loaded into the cluster. See code.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] command_line_arguments: List of key-value pairs to make available inside the cluster.
        :param pulumi.Input[str] created_timestamp: Timestamp at which the cluster is created in FinSpace. Value determined as epoch time in seconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['KxClusterDatabaseArgs']]]] databases: KX database that will be available for querying. Defined below.
        :param pulumi.Input[str] description: Description of the cluster.
        :param pulumi.Input[str] environment_id: Unique identifier for the KX environment.
        :param pulumi.Input[str] execution_role: An IAM role that defines a set of permissions associated with a cluster. These permissions are assumed when a cluster attempts to access another cluster.
        :param pulumi.Input[str] initialization_script: Path to Q program that will be run at launch of a cluster. This is a relative path within .zip file that contains the custom code, which will be loaded on the cluster. It must include the file name itself. For example, somedir/init.q.
        :param pulumi.Input[str] last_modified_timestamp: Last timestamp at which the cluster was updated in FinSpace. Value determined as epoch time in seconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000.
        :param pulumi.Input[str] name: Unique name for the cluster that you want to create.
        :param pulumi.Input[str] release_label: Version of FinSpace Managed kdb to run.
        :param pulumi.Input[pulumi.InputType['KxClusterSavedownStorageConfigurationArgs']] savedown_storage_configuration: Size and type of the temporary storage that is used to hold data during the savedown process. This parameter is required when you choose `type` as RDB. All the data written to this storage space is lost when the cluster node is restarted. See savedown_storage_configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[str] type: Type of KDB database. The following types are available:
               * HDB - Historical Database. The data is only accessible with read-only permissions from one of the FinSpace managed KX databases mounted to the cluster.
               * RDB - Realtime Database. This type of database captures all the data from a ticker plant and stores it in memory until the end of day, after which it writes all of its data to a disk and reloads the HDB. This cluster type requires local storage for temporary storage of data during the savedown process. If you specify this field in your request, you must provide the `savedownStorageConfiguration` parameter.
               * GATEWAY - A gateway cluster allows you to access data across processes in kdb systems. It allows you to create your own routing logic using the initialization scripts and custom code. This type of cluster does not require a  writable local storage.
        :param pulumi.Input[pulumi.InputType['KxClusterVpcConfigurationArgs']] vpc_configuration: Configuration details about the network where the Privatelink endpoint of the cluster resides. See vpc_configuration.
               
               The following arguments are optional:
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _KxClusterState.__new__(_KxClusterState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["auto_scaling_configuration"] = auto_scaling_configuration
        __props__.__dict__["availability_zone_id"] = availability_zone_id
        __props__.__dict__["az_mode"] = az_mode
        __props__.__dict__["cache_storage_configurations"] = cache_storage_configurations
        __props__.__dict__["capacity_configuration"] = capacity_configuration
        __props__.__dict__["code"] = code
        __props__.__dict__["command_line_arguments"] = command_line_arguments
        __props__.__dict__["created_timestamp"] = created_timestamp
        __props__.__dict__["databases"] = databases
        __props__.__dict__["description"] = description
        __props__.__dict__["environment_id"] = environment_id
        __props__.__dict__["execution_role"] = execution_role
        __props__.__dict__["initialization_script"] = initialization_script
        __props__.__dict__["last_modified_timestamp"] = last_modified_timestamp
        __props__.__dict__["name"] = name
        __props__.__dict__["release_label"] = release_label
        __props__.__dict__["savedown_storage_configuration"] = savedown_storage_configuration
        __props__.__dict__["status"] = status
        __props__.__dict__["status_reason"] = status_reason
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["type"] = type
        __props__.__dict__["vpc_configuration"] = vpc_configuration
        return KxCluster(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        Amazon Resource Name (ARN) identifier of the KX cluster.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="autoScalingConfiguration")
    def auto_scaling_configuration(self) -> pulumi.Output[Optional['outputs.KxClusterAutoScalingConfiguration']]:
        """
        Configuration based on which FinSpace will scale in or scale out nodes in your cluster. See auto_scaling_configuration.
        """
        return pulumi.get(self, "auto_scaling_configuration")

    @property
    @pulumi.getter(name="availabilityZoneId")
    def availability_zone_id(self) -> pulumi.Output[Optional[str]]:
        """
        The availability zone identifiers for the requested regions. Required when `az_mode` is set to SINGLE.
        """
        return pulumi.get(self, "availability_zone_id")

    @property
    @pulumi.getter(name="azMode")
    def az_mode(self) -> pulumi.Output[str]:
        """
        The number of availability zones you want to assign per cluster. This can be one of the following:
        * SINGLE - Assigns one availability zone per cluster.
        * MULTI - Assigns all the availability zones per cluster.
        """
        return pulumi.get(self, "az_mode")

    @property
    @pulumi.getter(name="cacheStorageConfigurations")
    def cache_storage_configurations(self) -> pulumi.Output[Optional[Sequence['outputs.KxClusterCacheStorageConfiguration']]]:
        """
        Configurations for a read only cache storage associated with a cluster. This cache will be stored as an FSx Lustre that reads from the S3 store. See cache_storage_configuration.
        """
        return pulumi.get(self, "cache_storage_configurations")

    @property
    @pulumi.getter(name="capacityConfiguration")
    def capacity_configuration(self) -> pulumi.Output['outputs.KxClusterCapacityConfiguration']:
        """
        Structure for the metadata of a cluster. Includes information like the CPUs needed, memory of instances, and number of instances. See capacity_configuration.
        """
        return pulumi.get(self, "capacity_configuration")

    @property
    @pulumi.getter
    def code(self) -> pulumi.Output[Optional['outputs.KxClusterCode']]:
        """
        Details of the custom code that you want to use inside a cluster when analyzing data. Consists of the S3 source bucket, location, object version, and the relative path from where the custom code is loaded into the cluster. See code.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter(name="commandLineArguments")
    def command_line_arguments(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        List of key-value pairs to make available inside the cluster.
        """
        return pulumi.get(self, "command_line_arguments")

    @property
    @pulumi.getter(name="createdTimestamp")
    def created_timestamp(self) -> pulumi.Output[str]:
        """
        Timestamp at which the cluster is created in FinSpace. Value determined as epoch time in seconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000.
        """
        return pulumi.get(self, "created_timestamp")

    @property
    @pulumi.getter
    def databases(self) -> pulumi.Output[Optional[Sequence['outputs.KxClusterDatabase']]]:
        """
        KX database that will be available for querying. Defined below.
        """
        return pulumi.get(self, "databases")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Description of the cluster.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> pulumi.Output[str]:
        """
        Unique identifier for the KX environment.
        """
        return pulumi.get(self, "environment_id")

    @property
    @pulumi.getter(name="executionRole")
    def execution_role(self) -> pulumi.Output[Optional[str]]:
        """
        An IAM role that defines a set of permissions associated with a cluster. These permissions are assumed when a cluster attempts to access another cluster.
        """
        return pulumi.get(self, "execution_role")

    @property
    @pulumi.getter(name="initializationScript")
    def initialization_script(self) -> pulumi.Output[Optional[str]]:
        """
        Path to Q program that will be run at launch of a cluster. This is a relative path within .zip file that contains the custom code, which will be loaded on the cluster. It must include the file name itself. For example, somedir/init.q.
        """
        return pulumi.get(self, "initialization_script")

    @property
    @pulumi.getter(name="lastModifiedTimestamp")
    def last_modified_timestamp(self) -> pulumi.Output[str]:
        """
        Last timestamp at which the cluster was updated in FinSpace. Value determined as epoch time in seconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000.
        """
        return pulumi.get(self, "last_modified_timestamp")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Unique name for the cluster that you want to create.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="releaseLabel")
    def release_label(self) -> pulumi.Output[str]:
        """
        Version of FinSpace Managed kdb to run.
        """
        return pulumi.get(self, "release_label")

    @property
    @pulumi.getter(name="savedownStorageConfiguration")
    def savedown_storage_configuration(self) -> pulumi.Output[Optional['outputs.KxClusterSavedownStorageConfiguration']]:
        """
        Size and type of the temporary storage that is used to hold data during the savedown process. This parameter is required when you choose `type` as RDB. All the data written to this storage space is lost when the cluster node is restarted. See savedown_storage_configuration.
        """
        return pulumi.get(self, "savedown_storage_configuration")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="statusReason")
    def status_reason(self) -> pulumi.Output[str]:
        return pulumi.get(self, "status_reason")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        Type of KDB database. The following types are available:
        * HDB - Historical Database. The data is only accessible with read-only permissions from one of the FinSpace managed KX databases mounted to the cluster.
        * RDB - Realtime Database. This type of database captures all the data from a ticker plant and stores it in memory until the end of day, after which it writes all of its data to a disk and reloads the HDB. This cluster type requires local storage for temporary storage of data during the savedown process. If you specify this field in your request, you must provide the `savedownStorageConfiguration` parameter.
        * GATEWAY - A gateway cluster allows you to access data across processes in kdb systems. It allows you to create your own routing logic using the initialization scripts and custom code. This type of cluster does not require a  writable local storage.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="vpcConfiguration")
    def vpc_configuration(self) -> pulumi.Output['outputs.KxClusterVpcConfiguration']:
        """
        Configuration details about the network where the Privatelink endpoint of the cluster resides. See vpc_configuration.

        The following arguments are optional:
        """
        return pulumi.get(self, "vpc_configuration")

