# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FileCacheArgs', 'FileCache']

@pulumi.input_type
class FileCacheArgs:
    def __init__(__self__, *,
                 file_cache_type: pulumi.Input[str],
                 file_cache_type_version: pulumi.Input[str],
                 storage_capacity: pulumi.Input[int],
                 subnet_ids: pulumi.Input[Sequence[pulumi.Input[str]]],
                 copy_tags_to_data_repository_associations: Optional[pulumi.Input[bool]] = None,
                 data_repository_associations: Optional[pulumi.Input[Sequence[pulumi.Input['FileCacheDataRepositoryAssociationArgs']]]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 lustre_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['FileCacheLustreConfigurationArgs']]]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a FileCache resource.
        :param pulumi.Input[str] file_cache_type: The type of cache that you're creating. The only supported value is `LUSTRE`.
        :param pulumi.Input[str] file_cache_type_version: The version for the type of cache that you're creating. The only supported value is `2.12`.
        :param pulumi.Input[int] storage_capacity: The storage capacity of the cache in gibibytes (GiB). Valid values are `1200` GiB, `2400` GiB, and increments of `2400` GiB.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnet_ids: A list of subnet IDs that the cache will be accessible from. You can specify only one subnet ID.
               
               The following arguments are optional:
        :param pulumi.Input[bool] copy_tags_to_data_repository_associations: A boolean flag indicating whether tags for the cache should be copied to data repository associations. This value defaults to false.
        :param pulumi.Input[Sequence[pulumi.Input['FileCacheDataRepositoryAssociationArgs']]] data_repository_associations: See the `data_repository_association` configuration block. Max of 8.
               A list of up to 8 configurations for data repository associations (DRAs) to be created during the cache creation. The DRAs link the cache to either an Amazon S3 data repository or a Network File System (NFS) data repository that supports the NFSv3 protocol. The DRA configurations must meet the following requirements: 1) All configurations on the list must be of the same data repository type, either all S3 or all NFS. A cache can't link to different data repository types at the same time. 2) An NFS DRA must link to an NFS file system that supports the NFSv3 protocol. DRA automatic import and automatic export is not supported.
        :param pulumi.Input[str] kms_key_id: Specifies the ID of the AWS Key Management Service (AWS KMS) key to use for encrypting data on an Amazon File Cache. If a KmsKeyId isn't specified, the Amazon FSx-managed AWS KMS key for your account is used.
        :param pulumi.Input[Sequence[pulumi.Input['FileCacheLustreConfigurationArgs']]] lustre_configurations: See the `lustre_configuration` block. Required when `file_cache_type` is `LUSTRE`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: A list of IDs specifying the security groups to apply to all network interfaces created for Amazon File Cache access.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the file cache. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        pulumi.set(__self__, "file_cache_type", file_cache_type)
        pulumi.set(__self__, "file_cache_type_version", file_cache_type_version)
        pulumi.set(__self__, "storage_capacity", storage_capacity)
        pulumi.set(__self__, "subnet_ids", subnet_ids)
        if copy_tags_to_data_repository_associations is not None:
            pulumi.set(__self__, "copy_tags_to_data_repository_associations", copy_tags_to_data_repository_associations)
        if data_repository_associations is not None:
            pulumi.set(__self__, "data_repository_associations", data_repository_associations)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if lustre_configurations is not None:
            pulumi.set(__self__, "lustre_configurations", lustre_configurations)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="fileCacheType")
    def file_cache_type(self) -> pulumi.Input[str]:
        """
        The type of cache that you're creating. The only supported value is `LUSTRE`.
        """
        return pulumi.get(self, "file_cache_type")

    @file_cache_type.setter
    def file_cache_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "file_cache_type", value)

    @property
    @pulumi.getter(name="fileCacheTypeVersion")
    def file_cache_type_version(self) -> pulumi.Input[str]:
        """
        The version for the type of cache that you're creating. The only supported value is `2.12`.
        """
        return pulumi.get(self, "file_cache_type_version")

    @file_cache_type_version.setter
    def file_cache_type_version(self, value: pulumi.Input[str]):
        pulumi.set(self, "file_cache_type_version", value)

    @property
    @pulumi.getter(name="storageCapacity")
    def storage_capacity(self) -> pulumi.Input[int]:
        """
        The storage capacity of the cache in gibibytes (GiB). Valid values are `1200` GiB, `2400` GiB, and increments of `2400` GiB.
        """
        return pulumi.get(self, "storage_capacity")

    @storage_capacity.setter
    def storage_capacity(self, value: pulumi.Input[int]):
        pulumi.set(self, "storage_capacity", value)

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        A list of subnet IDs that the cache will be accessible from. You can specify only one subnet ID.

        The following arguments are optional:
        """
        return pulumi.get(self, "subnet_ids")

    @subnet_ids.setter
    def subnet_ids(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "subnet_ids", value)

    @property
    @pulumi.getter(name="copyTagsToDataRepositoryAssociations")
    def copy_tags_to_data_repository_associations(self) -> Optional[pulumi.Input[bool]]:
        """
        A boolean flag indicating whether tags for the cache should be copied to data repository associations. This value defaults to false.
        """
        return pulumi.get(self, "copy_tags_to_data_repository_associations")

    @copy_tags_to_data_repository_associations.setter
    def copy_tags_to_data_repository_associations(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "copy_tags_to_data_repository_associations", value)

    @property
    @pulumi.getter(name="dataRepositoryAssociations")
    def data_repository_associations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FileCacheDataRepositoryAssociationArgs']]]]:
        """
        See the `data_repository_association` configuration block. Max of 8.
        A list of up to 8 configurations for data repository associations (DRAs) to be created during the cache creation. The DRAs link the cache to either an Amazon S3 data repository or a Network File System (NFS) data repository that supports the NFSv3 protocol. The DRA configurations must meet the following requirements: 1) All configurations on the list must be of the same data repository type, either all S3 or all NFS. A cache can't link to different data repository types at the same time. 2) An NFS DRA must link to an NFS file system that supports the NFSv3 protocol. DRA automatic import and automatic export is not supported.
        """
        return pulumi.get(self, "data_repository_associations")

    @data_repository_associations.setter
    def data_repository_associations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FileCacheDataRepositoryAssociationArgs']]]]):
        pulumi.set(self, "data_repository_associations", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the ID of the AWS Key Management Service (AWS KMS) key to use for encrypting data on an Amazon File Cache. If a KmsKeyId isn't specified, the Amazon FSx-managed AWS KMS key for your account is used.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="lustreConfigurations")
    def lustre_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FileCacheLustreConfigurationArgs']]]]:
        """
        See the `lustre_configuration` block. Required when `file_cache_type` is `LUSTRE`.
        """
        return pulumi.get(self, "lustre_configurations")

    @lustre_configurations.setter
    def lustre_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FileCacheLustreConfigurationArgs']]]]):
        pulumi.set(self, "lustre_configurations", value)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of IDs specifying the security groups to apply to all network interfaces created for Amazon File Cache access.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags to assign to the file cache. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _FileCacheState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[str]] = None,
                 copy_tags_to_data_repository_associations: Optional[pulumi.Input[bool]] = None,
                 data_repository_association_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 data_repository_associations: Optional[pulumi.Input[Sequence[pulumi.Input['FileCacheDataRepositoryAssociationArgs']]]] = None,
                 dns_name: Optional[pulumi.Input[str]] = None,
                 file_cache_id: Optional[pulumi.Input[str]] = None,
                 file_cache_type: Optional[pulumi.Input[str]] = None,
                 file_cache_type_version: Optional[pulumi.Input[str]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 lustre_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['FileCacheLustreConfigurationArgs']]]] = None,
                 network_interface_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 owner_id: Optional[pulumi.Input[str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 storage_capacity: Optional[pulumi.Input[int]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering FileCache resources.
        :param pulumi.Input[str] arn: The Amazon Resource Name (ARN) for the resource.
        :param pulumi.Input[bool] copy_tags_to_data_repository_associations: A boolean flag indicating whether tags for the cache should be copied to data repository associations. This value defaults to false.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] data_repository_association_ids: A list of IDs of data repository associations that are associated with this cache.
        :param pulumi.Input[Sequence[pulumi.Input['FileCacheDataRepositoryAssociationArgs']]] data_repository_associations: See the `data_repository_association` configuration block. Max of 8.
               A list of up to 8 configurations for data repository associations (DRAs) to be created during the cache creation. The DRAs link the cache to either an Amazon S3 data repository or a Network File System (NFS) data repository that supports the NFSv3 protocol. The DRA configurations must meet the following requirements: 1) All configurations on the list must be of the same data repository type, either all S3 or all NFS. A cache can't link to different data repository types at the same time. 2) An NFS DRA must link to an NFS file system that supports the NFSv3 protocol. DRA automatic import and automatic export is not supported.
        :param pulumi.Input[str] dns_name: The Domain Name System (DNS) name for the cache.
        :param pulumi.Input[str] file_cache_id: The system-generated, unique ID of the cache.
        :param pulumi.Input[str] file_cache_type: The type of cache that you're creating. The only supported value is `LUSTRE`.
        :param pulumi.Input[str] file_cache_type_version: The version for the type of cache that you're creating. The only supported value is `2.12`.
        :param pulumi.Input[str] kms_key_id: Specifies the ID of the AWS Key Management Service (AWS KMS) key to use for encrypting data on an Amazon File Cache. If a KmsKeyId isn't specified, the Amazon FSx-managed AWS KMS key for your account is used.
        :param pulumi.Input[Sequence[pulumi.Input['FileCacheLustreConfigurationArgs']]] lustre_configurations: See the `lustre_configuration` block. Required when `file_cache_type` is `LUSTRE`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] network_interface_ids: A list of network interface IDs.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: A list of IDs specifying the security groups to apply to all network interfaces created for Amazon File Cache access.
        :param pulumi.Input[int] storage_capacity: The storage capacity of the cache in gibibytes (GiB). Valid values are `1200` GiB, `2400` GiB, and increments of `2400` GiB.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnet_ids: A list of subnet IDs that the cache will be accessible from. You can specify only one subnet ID.
               
               The following arguments are optional:
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the file cache. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[str] vpc_id: The ID of your virtual private cloud (VPC).
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if copy_tags_to_data_repository_associations is not None:
            pulumi.set(__self__, "copy_tags_to_data_repository_associations", copy_tags_to_data_repository_associations)
        if data_repository_association_ids is not None:
            pulumi.set(__self__, "data_repository_association_ids", data_repository_association_ids)
        if data_repository_associations is not None:
            pulumi.set(__self__, "data_repository_associations", data_repository_associations)
        if dns_name is not None:
            pulumi.set(__self__, "dns_name", dns_name)
        if file_cache_id is not None:
            pulumi.set(__self__, "file_cache_id", file_cache_id)
        if file_cache_type is not None:
            pulumi.set(__self__, "file_cache_type", file_cache_type)
        if file_cache_type_version is not None:
            pulumi.set(__self__, "file_cache_type_version", file_cache_type_version)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if lustre_configurations is not None:
            pulumi.set(__self__, "lustre_configurations", lustre_configurations)
        if network_interface_ids is not None:
            pulumi.set(__self__, "network_interface_ids", network_interface_ids)
        if owner_id is not None:
            pulumi.set(__self__, "owner_id", owner_id)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if storage_capacity is not None:
            pulumi.set(__self__, "storage_capacity", storage_capacity)
        if subnet_ids is not None:
            pulumi.set(__self__, "subnet_ids", subnet_ids)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name (ARN) for the resource.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="copyTagsToDataRepositoryAssociations")
    def copy_tags_to_data_repository_associations(self) -> Optional[pulumi.Input[bool]]:
        """
        A boolean flag indicating whether tags for the cache should be copied to data repository associations. This value defaults to false.
        """
        return pulumi.get(self, "copy_tags_to_data_repository_associations")

    @copy_tags_to_data_repository_associations.setter
    def copy_tags_to_data_repository_associations(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "copy_tags_to_data_repository_associations", value)

    @property
    @pulumi.getter(name="dataRepositoryAssociationIds")
    def data_repository_association_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of IDs of data repository associations that are associated with this cache.
        """
        return pulumi.get(self, "data_repository_association_ids")

    @data_repository_association_ids.setter
    def data_repository_association_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "data_repository_association_ids", value)

    @property
    @pulumi.getter(name="dataRepositoryAssociations")
    def data_repository_associations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FileCacheDataRepositoryAssociationArgs']]]]:
        """
        See the `data_repository_association` configuration block. Max of 8.
        A list of up to 8 configurations for data repository associations (DRAs) to be created during the cache creation. The DRAs link the cache to either an Amazon S3 data repository or a Network File System (NFS) data repository that supports the NFSv3 protocol. The DRA configurations must meet the following requirements: 1) All configurations on the list must be of the same data repository type, either all S3 or all NFS. A cache can't link to different data repository types at the same time. 2) An NFS DRA must link to an NFS file system that supports the NFSv3 protocol. DRA automatic import and automatic export is not supported.
        """
        return pulumi.get(self, "data_repository_associations")

    @data_repository_associations.setter
    def data_repository_associations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FileCacheDataRepositoryAssociationArgs']]]]):
        pulumi.set(self, "data_repository_associations", value)

    @property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> Optional[pulumi.Input[str]]:
        """
        The Domain Name System (DNS) name for the cache.
        """
        return pulumi.get(self, "dns_name")

    @dns_name.setter
    def dns_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dns_name", value)

    @property
    @pulumi.getter(name="fileCacheId")
    def file_cache_id(self) -> Optional[pulumi.Input[str]]:
        """
        The system-generated, unique ID of the cache.
        """
        return pulumi.get(self, "file_cache_id")

    @file_cache_id.setter
    def file_cache_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "file_cache_id", value)

    @property
    @pulumi.getter(name="fileCacheType")
    def file_cache_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of cache that you're creating. The only supported value is `LUSTRE`.
        """
        return pulumi.get(self, "file_cache_type")

    @file_cache_type.setter
    def file_cache_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "file_cache_type", value)

    @property
    @pulumi.getter(name="fileCacheTypeVersion")
    def file_cache_type_version(self) -> Optional[pulumi.Input[str]]:
        """
        The version for the type of cache that you're creating. The only supported value is `2.12`.
        """
        return pulumi.get(self, "file_cache_type_version")

    @file_cache_type_version.setter
    def file_cache_type_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "file_cache_type_version", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the ID of the AWS Key Management Service (AWS KMS) key to use for encrypting data on an Amazon File Cache. If a KmsKeyId isn't specified, the Amazon FSx-managed AWS KMS key for your account is used.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="lustreConfigurations")
    def lustre_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FileCacheLustreConfigurationArgs']]]]:
        """
        See the `lustre_configuration` block. Required when `file_cache_type` is `LUSTRE`.
        """
        return pulumi.get(self, "lustre_configurations")

    @lustre_configurations.setter
    def lustre_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FileCacheLustreConfigurationArgs']]]]):
        pulumi.set(self, "lustre_configurations", value)

    @property
    @pulumi.getter(name="networkInterfaceIds")
    def network_interface_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of network interface IDs.
        """
        return pulumi.get(self, "network_interface_ids")

    @network_interface_ids.setter
    def network_interface_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "network_interface_ids", value)

    @property
    @pulumi.getter(name="ownerId")
    def owner_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "owner_id")

    @owner_id.setter
    def owner_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "owner_id", value)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of IDs specifying the security groups to apply to all network interfaces created for Amazon File Cache access.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @property
    @pulumi.getter(name="storageCapacity")
    def storage_capacity(self) -> Optional[pulumi.Input[int]]:
        """
        The storage capacity of the cache in gibibytes (GiB). Valid values are `1200` GiB, `2400` GiB, and increments of `2400` GiB.
        """
        return pulumi.get(self, "storage_capacity")

    @storage_capacity.setter
    def storage_capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "storage_capacity", value)

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of subnet IDs that the cache will be accessible from. You can specify only one subnet ID.

        The following arguments are optional:
        """
        return pulumi.get(self, "subnet_ids")

    @subnet_ids.setter
    def subnet_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "subnet_ids", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags to assign to the file cache. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of your virtual private cloud (VPC).
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)


class FileCache(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 copy_tags_to_data_repository_associations: Optional[pulumi.Input[bool]] = None,
                 data_repository_associations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FileCacheDataRepositoryAssociationArgs']]]]] = None,
                 file_cache_type: Optional[pulumi.Input[str]] = None,
                 file_cache_type_version: Optional[pulumi.Input[str]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 lustre_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FileCacheLustreConfigurationArgs']]]]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 storage_capacity: Optional[pulumi.Input[int]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Resource for managing an Amazon File Cache cache.
        See the [Create File Cache](https://docs.aws.amazon.com/fsx/latest/APIReference/API_CreateFileCache.html) for more information.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.fsx.FileCache("example",
            data_repository_associations=[aws.fsx.FileCacheDataRepositoryAssociationArgs(
                data_repository_path="nfs://filer.domain.com",
                data_repository_subdirectories=[
                    "test",
                    "test2",
                ],
                file_cache_path="/ns1",
                nfs=[aws.fsx.FileCacheDataRepositoryAssociationNfArgs(
                    dns_ips=[
                        "192.168.0.1",
                        "192.168.0.2",
                    ],
                    version="NFS3",
                )],
            )],
            file_cache_type="LUSTRE",
            file_cache_type_version="2.12",
            lustre_configurations=[aws.fsx.FileCacheLustreConfigurationArgs(
                deployment_type="CACHE_1",
                metadata_configurations=[aws.fsx.FileCacheLustreConfigurationMetadataConfigurationArgs(
                    storage_capacity=2400,
                )],
                per_unit_storage_throughput=1000,
                weekly_maintenance_start_time="2:05:00",
            )],
            subnet_ids=[aws_subnet["test1"]["id"]],
            storage_capacity=1200)
        ```

        ## Import

        Using `pulumi import`, import Amazon File Cache cache using the resource `id`. For example:

        ```sh
         $ pulumi import aws:fsx/fileCache:FileCache example fc-8012925589
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] copy_tags_to_data_repository_associations: A boolean flag indicating whether tags for the cache should be copied to data repository associations. This value defaults to false.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FileCacheDataRepositoryAssociationArgs']]]] data_repository_associations: See the `data_repository_association` configuration block. Max of 8.
               A list of up to 8 configurations for data repository associations (DRAs) to be created during the cache creation. The DRAs link the cache to either an Amazon S3 data repository or a Network File System (NFS) data repository that supports the NFSv3 protocol. The DRA configurations must meet the following requirements: 1) All configurations on the list must be of the same data repository type, either all S3 or all NFS. A cache can't link to different data repository types at the same time. 2) An NFS DRA must link to an NFS file system that supports the NFSv3 protocol. DRA automatic import and automatic export is not supported.
        :param pulumi.Input[str] file_cache_type: The type of cache that you're creating. The only supported value is `LUSTRE`.
        :param pulumi.Input[str] file_cache_type_version: The version for the type of cache that you're creating. The only supported value is `2.12`.
        :param pulumi.Input[str] kms_key_id: Specifies the ID of the AWS Key Management Service (AWS KMS) key to use for encrypting data on an Amazon File Cache. If a KmsKeyId isn't specified, the Amazon FSx-managed AWS KMS key for your account is used.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FileCacheLustreConfigurationArgs']]]] lustre_configurations: See the `lustre_configuration` block. Required when `file_cache_type` is `LUSTRE`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: A list of IDs specifying the security groups to apply to all network interfaces created for Amazon File Cache access.
        :param pulumi.Input[int] storage_capacity: The storage capacity of the cache in gibibytes (GiB). Valid values are `1200` GiB, `2400` GiB, and increments of `2400` GiB.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnet_ids: A list of subnet IDs that the cache will be accessible from. You can specify only one subnet ID.
               
               The following arguments are optional:
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the file cache. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FileCacheArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an Amazon File Cache cache.
        See the [Create File Cache](https://docs.aws.amazon.com/fsx/latest/APIReference/API_CreateFileCache.html) for more information.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.fsx.FileCache("example",
            data_repository_associations=[aws.fsx.FileCacheDataRepositoryAssociationArgs(
                data_repository_path="nfs://filer.domain.com",
                data_repository_subdirectories=[
                    "test",
                    "test2",
                ],
                file_cache_path="/ns1",
                nfs=[aws.fsx.FileCacheDataRepositoryAssociationNfArgs(
                    dns_ips=[
                        "192.168.0.1",
                        "192.168.0.2",
                    ],
                    version="NFS3",
                )],
            )],
            file_cache_type="LUSTRE",
            file_cache_type_version="2.12",
            lustre_configurations=[aws.fsx.FileCacheLustreConfigurationArgs(
                deployment_type="CACHE_1",
                metadata_configurations=[aws.fsx.FileCacheLustreConfigurationMetadataConfigurationArgs(
                    storage_capacity=2400,
                )],
                per_unit_storage_throughput=1000,
                weekly_maintenance_start_time="2:05:00",
            )],
            subnet_ids=[aws_subnet["test1"]["id"]],
            storage_capacity=1200)
        ```

        ## Import

        Using `pulumi import`, import Amazon File Cache cache using the resource `id`. For example:

        ```sh
         $ pulumi import aws:fsx/fileCache:FileCache example fc-8012925589
        ```

        :param str resource_name: The name of the resource.
        :param FileCacheArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FileCacheArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 copy_tags_to_data_repository_associations: Optional[pulumi.Input[bool]] = None,
                 data_repository_associations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FileCacheDataRepositoryAssociationArgs']]]]] = None,
                 file_cache_type: Optional[pulumi.Input[str]] = None,
                 file_cache_type_version: Optional[pulumi.Input[str]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 lustre_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FileCacheLustreConfigurationArgs']]]]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 storage_capacity: Optional[pulumi.Input[int]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FileCacheArgs.__new__(FileCacheArgs)

            __props__.__dict__["copy_tags_to_data_repository_associations"] = copy_tags_to_data_repository_associations
            __props__.__dict__["data_repository_associations"] = data_repository_associations
            if file_cache_type is None and not opts.urn:
                raise TypeError("Missing required property 'file_cache_type'")
            __props__.__dict__["file_cache_type"] = file_cache_type
            if file_cache_type_version is None and not opts.urn:
                raise TypeError("Missing required property 'file_cache_type_version'")
            __props__.__dict__["file_cache_type_version"] = file_cache_type_version
            __props__.__dict__["kms_key_id"] = kms_key_id
            __props__.__dict__["lustre_configurations"] = lustre_configurations
            __props__.__dict__["security_group_ids"] = security_group_ids
            if storage_capacity is None and not opts.urn:
                raise TypeError("Missing required property 'storage_capacity'")
            __props__.__dict__["storage_capacity"] = storage_capacity
            if subnet_ids is None and not opts.urn:
                raise TypeError("Missing required property 'subnet_ids'")
            __props__.__dict__["subnet_ids"] = subnet_ids
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["data_repository_association_ids"] = None
            __props__.__dict__["dns_name"] = None
            __props__.__dict__["file_cache_id"] = None
            __props__.__dict__["network_interface_ids"] = None
            __props__.__dict__["owner_id"] = None
            __props__.__dict__["tags_all"] = None
            __props__.__dict__["vpc_id"] = None
        super(FileCache, __self__).__init__(
            'aws:fsx/fileCache:FileCache',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[str]] = None,
            copy_tags_to_data_repository_associations: Optional[pulumi.Input[bool]] = None,
            data_repository_association_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            data_repository_associations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FileCacheDataRepositoryAssociationArgs']]]]] = None,
            dns_name: Optional[pulumi.Input[str]] = None,
            file_cache_id: Optional[pulumi.Input[str]] = None,
            file_cache_type: Optional[pulumi.Input[str]] = None,
            file_cache_type_version: Optional[pulumi.Input[str]] = None,
            kms_key_id: Optional[pulumi.Input[str]] = None,
            lustre_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FileCacheLustreConfigurationArgs']]]]] = None,
            network_interface_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            owner_id: Optional[pulumi.Input[str]] = None,
            security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            storage_capacity: Optional[pulumi.Input[int]] = None,
            subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            vpc_id: Optional[pulumi.Input[str]] = None) -> 'FileCache':
        """
        Get an existing FileCache resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] arn: The Amazon Resource Name (ARN) for the resource.
        :param pulumi.Input[bool] copy_tags_to_data_repository_associations: A boolean flag indicating whether tags for the cache should be copied to data repository associations. This value defaults to false.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] data_repository_association_ids: A list of IDs of data repository associations that are associated with this cache.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FileCacheDataRepositoryAssociationArgs']]]] data_repository_associations: See the `data_repository_association` configuration block. Max of 8.
               A list of up to 8 configurations for data repository associations (DRAs) to be created during the cache creation. The DRAs link the cache to either an Amazon S3 data repository or a Network File System (NFS) data repository that supports the NFSv3 protocol. The DRA configurations must meet the following requirements: 1) All configurations on the list must be of the same data repository type, either all S3 or all NFS. A cache can't link to different data repository types at the same time. 2) An NFS DRA must link to an NFS file system that supports the NFSv3 protocol. DRA automatic import and automatic export is not supported.
        :param pulumi.Input[str] dns_name: The Domain Name System (DNS) name for the cache.
        :param pulumi.Input[str] file_cache_id: The system-generated, unique ID of the cache.
        :param pulumi.Input[str] file_cache_type: The type of cache that you're creating. The only supported value is `LUSTRE`.
        :param pulumi.Input[str] file_cache_type_version: The version for the type of cache that you're creating. The only supported value is `2.12`.
        :param pulumi.Input[str] kms_key_id: Specifies the ID of the AWS Key Management Service (AWS KMS) key to use for encrypting data on an Amazon File Cache. If a KmsKeyId isn't specified, the Amazon FSx-managed AWS KMS key for your account is used.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FileCacheLustreConfigurationArgs']]]] lustre_configurations: See the `lustre_configuration` block. Required when `file_cache_type` is `LUSTRE`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] network_interface_ids: A list of network interface IDs.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: A list of IDs specifying the security groups to apply to all network interfaces created for Amazon File Cache access.
        :param pulumi.Input[int] storage_capacity: The storage capacity of the cache in gibibytes (GiB). Valid values are `1200` GiB, `2400` GiB, and increments of `2400` GiB.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnet_ids: A list of subnet IDs that the cache will be accessible from. You can specify only one subnet ID.
               
               The following arguments are optional:
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the file cache. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[str] vpc_id: The ID of your virtual private cloud (VPC).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FileCacheState.__new__(_FileCacheState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["copy_tags_to_data_repository_associations"] = copy_tags_to_data_repository_associations
        __props__.__dict__["data_repository_association_ids"] = data_repository_association_ids
        __props__.__dict__["data_repository_associations"] = data_repository_associations
        __props__.__dict__["dns_name"] = dns_name
        __props__.__dict__["file_cache_id"] = file_cache_id
        __props__.__dict__["file_cache_type"] = file_cache_type
        __props__.__dict__["file_cache_type_version"] = file_cache_type_version
        __props__.__dict__["kms_key_id"] = kms_key_id
        __props__.__dict__["lustre_configurations"] = lustre_configurations
        __props__.__dict__["network_interface_ids"] = network_interface_ids
        __props__.__dict__["owner_id"] = owner_id
        __props__.__dict__["security_group_ids"] = security_group_ids
        __props__.__dict__["storage_capacity"] = storage_capacity
        __props__.__dict__["subnet_ids"] = subnet_ids
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["vpc_id"] = vpc_id
        return FileCache(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        The Amazon Resource Name (ARN) for the resource.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="copyTagsToDataRepositoryAssociations")
    def copy_tags_to_data_repository_associations(self) -> pulumi.Output[Optional[bool]]:
        """
        A boolean flag indicating whether tags for the cache should be copied to data repository associations. This value defaults to false.
        """
        return pulumi.get(self, "copy_tags_to_data_repository_associations")

    @property
    @pulumi.getter(name="dataRepositoryAssociationIds")
    def data_repository_association_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        A list of IDs of data repository associations that are associated with this cache.
        """
        return pulumi.get(self, "data_repository_association_ids")

    @property
    @pulumi.getter(name="dataRepositoryAssociations")
    def data_repository_associations(self) -> pulumi.Output[Optional[Sequence['outputs.FileCacheDataRepositoryAssociation']]]:
        """
        See the `data_repository_association` configuration block. Max of 8.
        A list of up to 8 configurations for data repository associations (DRAs) to be created during the cache creation. The DRAs link the cache to either an Amazon S3 data repository or a Network File System (NFS) data repository that supports the NFSv3 protocol. The DRA configurations must meet the following requirements: 1) All configurations on the list must be of the same data repository type, either all S3 or all NFS. A cache can't link to different data repository types at the same time. 2) An NFS DRA must link to an NFS file system that supports the NFSv3 protocol. DRA automatic import and automatic export is not supported.
        """
        return pulumi.get(self, "data_repository_associations")

    @property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> pulumi.Output[str]:
        """
        The Domain Name System (DNS) name for the cache.
        """
        return pulumi.get(self, "dns_name")

    @property
    @pulumi.getter(name="fileCacheId")
    def file_cache_id(self) -> pulumi.Output[str]:
        """
        The system-generated, unique ID of the cache.
        """
        return pulumi.get(self, "file_cache_id")

    @property
    @pulumi.getter(name="fileCacheType")
    def file_cache_type(self) -> pulumi.Output[str]:
        """
        The type of cache that you're creating. The only supported value is `LUSTRE`.
        """
        return pulumi.get(self, "file_cache_type")

    @property
    @pulumi.getter(name="fileCacheTypeVersion")
    def file_cache_type_version(self) -> pulumi.Output[str]:
        """
        The version for the type of cache that you're creating. The only supported value is `2.12`.
        """
        return pulumi.get(self, "file_cache_type_version")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> pulumi.Output[str]:
        """
        Specifies the ID of the AWS Key Management Service (AWS KMS) key to use for encrypting data on an Amazon File Cache. If a KmsKeyId isn't specified, the Amazon FSx-managed AWS KMS key for your account is used.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="lustreConfigurations")
    def lustre_configurations(self) -> pulumi.Output[Optional[Sequence['outputs.FileCacheLustreConfiguration']]]:
        """
        See the `lustre_configuration` block. Required when `file_cache_type` is `LUSTRE`.
        """
        return pulumi.get(self, "lustre_configurations")

    @property
    @pulumi.getter(name="networkInterfaceIds")
    def network_interface_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        A list of network interface IDs.
        """
        return pulumi.get(self, "network_interface_ids")

    @property
    @pulumi.getter(name="ownerId")
    def owner_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "owner_id")

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A list of IDs specifying the security groups to apply to all network interfaces created for Amazon File Cache access.
        """
        return pulumi.get(self, "security_group_ids")

    @property
    @pulumi.getter(name="storageCapacity")
    def storage_capacity(self) -> pulumi.Output[int]:
        """
        The storage capacity of the cache in gibibytes (GiB). Valid values are `1200` GiB, `2400` GiB, and increments of `2400` GiB.
        """
        return pulumi.get(self, "storage_capacity")

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        A list of subnet IDs that the cache will be accessible from. You can specify only one subnet ID.

        The following arguments are optional:
        """
        return pulumi.get(self, "subnet_ids")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        A map of tags to assign to the file cache. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, str]]:
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[str]:
        """
        The ID of your virtual private cloud (VPC).
        """
        return pulumi.get(self, "vpc_id")

