# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['OpenZfsVolumeArgs', 'OpenZfsVolume']

@pulumi.input_type
class OpenZfsVolumeArgs:
    def __init__(__self__, *,
                 parent_volume_id: pulumi.Input[str],
                 copy_tags_to_snapshots: Optional[pulumi.Input[bool]] = None,
                 data_compression_type: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 nfs_exports: Optional[pulumi.Input['OpenZfsVolumeNfsExportsArgs']] = None,
                 origin_snapshot: Optional[pulumi.Input['OpenZfsVolumeOriginSnapshotArgs']] = None,
                 read_only: Optional[pulumi.Input[bool]] = None,
                 record_size_kib: Optional[pulumi.Input[int]] = None,
                 storage_capacity_quota_gib: Optional[pulumi.Input[int]] = None,
                 storage_capacity_reservation_gib: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 user_and_group_quotas: Optional[pulumi.Input[Sequence[pulumi.Input['OpenZfsVolumeUserAndGroupQuotaArgs']]]] = None,
                 volume_type: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a OpenZfsVolume resource.
        :param pulumi.Input[str] parent_volume_id: The volume id of volume that will be the parent volume for the volume being created, this could be the root volume created from the `fsx.OpenZfsFileSystem` resource with the `root_volume_id` or the `id` property of another `fsx.OpenZfsVolume`.
        :param pulumi.Input[bool] copy_tags_to_snapshots: A boolean flag indicating whether tags for the file system should be copied to snapshots. The default value is false.
        :param pulumi.Input[str] data_compression_type: Method used to compress the data on the volume. Valid values are `NONE` or `ZSTD`. Child volumes that don't specify compression option will inherit from parent volume. This option on file system applies to the root volume.
        :param pulumi.Input[str] name: The name of the Volume. You can use a maximum of 203 alphanumeric characters, plus the underscore (_) special character.
        :param pulumi.Input['OpenZfsVolumeNfsExportsArgs'] nfs_exports: NFS export configuration for the root volume. Exactly 1 item. See NFS Exports Below.
        :param pulumi.Input['OpenZfsVolumeOriginSnapshotArgs'] origin_snapshot: The ARN of the source snapshot to create the volume from.
        :param pulumi.Input[bool] read_only: specifies whether the volume is read-only. Default is false.
        :param pulumi.Input[int] record_size_kib: The record size of an OpenZFS volume, in kibibytes (KiB). Valid values are `4`, `8`, `16`, `32`, `64`, `128`, `256`, `512`, or `1024` KiB. The default is `128` KiB.
        :param pulumi.Input[int] storage_capacity_quota_gib: The maximum amount of storage in gibibytes (GiB) that the volume can use from its parent.
        :param pulumi.Input[int] storage_capacity_reservation_gib: The amount of storage in gibibytes (GiB) to reserve from the parent volume.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the file system. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Sequence[pulumi.Input['OpenZfsVolumeUserAndGroupQuotaArgs']]] user_and_group_quotas: Specify how much storage users or groups can use on the volume. Maximum of 100 items. See User and Group Quotas Below.
        """
        pulumi.set(__self__, "parent_volume_id", parent_volume_id)
        if copy_tags_to_snapshots is not None:
            pulumi.set(__self__, "copy_tags_to_snapshots", copy_tags_to_snapshots)
        if data_compression_type is not None:
            pulumi.set(__self__, "data_compression_type", data_compression_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nfs_exports is not None:
            pulumi.set(__self__, "nfs_exports", nfs_exports)
        if origin_snapshot is not None:
            pulumi.set(__self__, "origin_snapshot", origin_snapshot)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if record_size_kib is not None:
            pulumi.set(__self__, "record_size_kib", record_size_kib)
        if storage_capacity_quota_gib is not None:
            pulumi.set(__self__, "storage_capacity_quota_gib", storage_capacity_quota_gib)
        if storage_capacity_reservation_gib is not None:
            pulumi.set(__self__, "storage_capacity_reservation_gib", storage_capacity_reservation_gib)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if user_and_group_quotas is not None:
            pulumi.set(__self__, "user_and_group_quotas", user_and_group_quotas)
        if volume_type is not None:
            pulumi.set(__self__, "volume_type", volume_type)

    @property
    @pulumi.getter(name="parentVolumeId")
    def parent_volume_id(self) -> pulumi.Input[str]:
        """
        The volume id of volume that will be the parent volume for the volume being created, this could be the root volume created from the `fsx.OpenZfsFileSystem` resource with the `root_volume_id` or the `id` property of another `fsx.OpenZfsVolume`.
        """
        return pulumi.get(self, "parent_volume_id")

    @parent_volume_id.setter
    def parent_volume_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "parent_volume_id", value)

    @property
    @pulumi.getter(name="copyTagsToSnapshots")
    def copy_tags_to_snapshots(self) -> Optional[pulumi.Input[bool]]:
        """
        A boolean flag indicating whether tags for the file system should be copied to snapshots. The default value is false.
        """
        return pulumi.get(self, "copy_tags_to_snapshots")

    @copy_tags_to_snapshots.setter
    def copy_tags_to_snapshots(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "copy_tags_to_snapshots", value)

    @property
    @pulumi.getter(name="dataCompressionType")
    def data_compression_type(self) -> Optional[pulumi.Input[str]]:
        """
        Method used to compress the data on the volume. Valid values are `NONE` or `ZSTD`. Child volumes that don't specify compression option will inherit from parent volume. This option on file system applies to the root volume.
        """
        return pulumi.get(self, "data_compression_type")

    @data_compression_type.setter
    def data_compression_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_compression_type", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Volume. You can use a maximum of 203 alphanumeric characters, plus the underscore (_) special character.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nfsExports")
    def nfs_exports(self) -> Optional[pulumi.Input['OpenZfsVolumeNfsExportsArgs']]:
        """
        NFS export configuration for the root volume. Exactly 1 item. See NFS Exports Below.
        """
        return pulumi.get(self, "nfs_exports")

    @nfs_exports.setter
    def nfs_exports(self, value: Optional[pulumi.Input['OpenZfsVolumeNfsExportsArgs']]):
        pulumi.set(self, "nfs_exports", value)

    @property
    @pulumi.getter(name="originSnapshot")
    def origin_snapshot(self) -> Optional[pulumi.Input['OpenZfsVolumeOriginSnapshotArgs']]:
        """
        The ARN of the source snapshot to create the volume from.
        """
        return pulumi.get(self, "origin_snapshot")

    @origin_snapshot.setter
    def origin_snapshot(self, value: Optional[pulumi.Input['OpenZfsVolumeOriginSnapshotArgs']]):
        pulumi.set(self, "origin_snapshot", value)

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[pulumi.Input[bool]]:
        """
        specifies whether the volume is read-only. Default is false.
        """
        return pulumi.get(self, "read_only")

    @read_only.setter
    def read_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "read_only", value)

    @property
    @pulumi.getter(name="recordSizeKib")
    def record_size_kib(self) -> Optional[pulumi.Input[int]]:
        """
        The record size of an OpenZFS volume, in kibibytes (KiB). Valid values are `4`, `8`, `16`, `32`, `64`, `128`, `256`, `512`, or `1024` KiB. The default is `128` KiB.
        """
        return pulumi.get(self, "record_size_kib")

    @record_size_kib.setter
    def record_size_kib(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "record_size_kib", value)

    @property
    @pulumi.getter(name="storageCapacityQuotaGib")
    def storage_capacity_quota_gib(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum amount of storage in gibibytes (GiB) that the volume can use from its parent.
        """
        return pulumi.get(self, "storage_capacity_quota_gib")

    @storage_capacity_quota_gib.setter
    def storage_capacity_quota_gib(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "storage_capacity_quota_gib", value)

    @property
    @pulumi.getter(name="storageCapacityReservationGib")
    def storage_capacity_reservation_gib(self) -> Optional[pulumi.Input[int]]:
        """
        The amount of storage in gibibytes (GiB) to reserve from the parent volume.
        """
        return pulumi.get(self, "storage_capacity_reservation_gib")

    @storage_capacity_reservation_gib.setter
    def storage_capacity_reservation_gib(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "storage_capacity_reservation_gib", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags to assign to the file system. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="userAndGroupQuotas")
    def user_and_group_quotas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OpenZfsVolumeUserAndGroupQuotaArgs']]]]:
        """
        Specify how much storage users or groups can use on the volume. Maximum of 100 items. See User and Group Quotas Below.
        """
        return pulumi.get(self, "user_and_group_quotas")

    @user_and_group_quotas.setter
    def user_and_group_quotas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OpenZfsVolumeUserAndGroupQuotaArgs']]]]):
        pulumi.set(self, "user_and_group_quotas", value)

    @property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "volume_type")

    @volume_type.setter
    def volume_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "volume_type", value)


@pulumi.input_type
class _OpenZfsVolumeState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[str]] = None,
                 copy_tags_to_snapshots: Optional[pulumi.Input[bool]] = None,
                 data_compression_type: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 nfs_exports: Optional[pulumi.Input['OpenZfsVolumeNfsExportsArgs']] = None,
                 origin_snapshot: Optional[pulumi.Input['OpenZfsVolumeOriginSnapshotArgs']] = None,
                 parent_volume_id: Optional[pulumi.Input[str]] = None,
                 read_only: Optional[pulumi.Input[bool]] = None,
                 record_size_kib: Optional[pulumi.Input[int]] = None,
                 storage_capacity_quota_gib: Optional[pulumi.Input[int]] = None,
                 storage_capacity_reservation_gib: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 user_and_group_quotas: Optional[pulumi.Input[Sequence[pulumi.Input['OpenZfsVolumeUserAndGroupQuotaArgs']]]] = None,
                 volume_type: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering OpenZfsVolume resources.
        :param pulumi.Input[str] arn: Amazon Resource Name of the file system.
        :param pulumi.Input[bool] copy_tags_to_snapshots: A boolean flag indicating whether tags for the file system should be copied to snapshots. The default value is false.
        :param pulumi.Input[str] data_compression_type: Method used to compress the data on the volume. Valid values are `NONE` or `ZSTD`. Child volumes that don't specify compression option will inherit from parent volume. This option on file system applies to the root volume.
        :param pulumi.Input[str] name: The name of the Volume. You can use a maximum of 203 alphanumeric characters, plus the underscore (_) special character.
        :param pulumi.Input['OpenZfsVolumeNfsExportsArgs'] nfs_exports: NFS export configuration for the root volume. Exactly 1 item. See NFS Exports Below.
        :param pulumi.Input['OpenZfsVolumeOriginSnapshotArgs'] origin_snapshot: The ARN of the source snapshot to create the volume from.
        :param pulumi.Input[str] parent_volume_id: The volume id of volume that will be the parent volume for the volume being created, this could be the root volume created from the `fsx.OpenZfsFileSystem` resource with the `root_volume_id` or the `id` property of another `fsx.OpenZfsVolume`.
        :param pulumi.Input[bool] read_only: specifies whether the volume is read-only. Default is false.
        :param pulumi.Input[int] record_size_kib: The record size of an OpenZFS volume, in kibibytes (KiB). Valid values are `4`, `8`, `16`, `32`, `64`, `128`, `256`, `512`, or `1024` KiB. The default is `128` KiB.
        :param pulumi.Input[int] storage_capacity_quota_gib: The maximum amount of storage in gibibytes (GiB) that the volume can use from its parent.
        :param pulumi.Input[int] storage_capacity_reservation_gib: The amount of storage in gibibytes (GiB) to reserve from the parent volume.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the file system. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[Sequence[pulumi.Input['OpenZfsVolumeUserAndGroupQuotaArgs']]] user_and_group_quotas: Specify how much storage users or groups can use on the volume. Maximum of 100 items. See User and Group Quotas Below.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if copy_tags_to_snapshots is not None:
            pulumi.set(__self__, "copy_tags_to_snapshots", copy_tags_to_snapshots)
        if data_compression_type is not None:
            pulumi.set(__self__, "data_compression_type", data_compression_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nfs_exports is not None:
            pulumi.set(__self__, "nfs_exports", nfs_exports)
        if origin_snapshot is not None:
            pulumi.set(__self__, "origin_snapshot", origin_snapshot)
        if parent_volume_id is not None:
            pulumi.set(__self__, "parent_volume_id", parent_volume_id)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if record_size_kib is not None:
            pulumi.set(__self__, "record_size_kib", record_size_kib)
        if storage_capacity_quota_gib is not None:
            pulumi.set(__self__, "storage_capacity_quota_gib", storage_capacity_quota_gib)
        if storage_capacity_reservation_gib is not None:
            pulumi.set(__self__, "storage_capacity_reservation_gib", storage_capacity_reservation_gib)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if user_and_group_quotas is not None:
            pulumi.set(__self__, "user_and_group_quotas", user_and_group_quotas)
        if volume_type is not None:
            pulumi.set(__self__, "volume_type", volume_type)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        Amazon Resource Name of the file system.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="copyTagsToSnapshots")
    def copy_tags_to_snapshots(self) -> Optional[pulumi.Input[bool]]:
        """
        A boolean flag indicating whether tags for the file system should be copied to snapshots. The default value is false.
        """
        return pulumi.get(self, "copy_tags_to_snapshots")

    @copy_tags_to_snapshots.setter
    def copy_tags_to_snapshots(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "copy_tags_to_snapshots", value)

    @property
    @pulumi.getter(name="dataCompressionType")
    def data_compression_type(self) -> Optional[pulumi.Input[str]]:
        """
        Method used to compress the data on the volume. Valid values are `NONE` or `ZSTD`. Child volumes that don't specify compression option will inherit from parent volume. This option on file system applies to the root volume.
        """
        return pulumi.get(self, "data_compression_type")

    @data_compression_type.setter
    def data_compression_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_compression_type", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Volume. You can use a maximum of 203 alphanumeric characters, plus the underscore (_) special character.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nfsExports")
    def nfs_exports(self) -> Optional[pulumi.Input['OpenZfsVolumeNfsExportsArgs']]:
        """
        NFS export configuration for the root volume. Exactly 1 item. See NFS Exports Below.
        """
        return pulumi.get(self, "nfs_exports")

    @nfs_exports.setter
    def nfs_exports(self, value: Optional[pulumi.Input['OpenZfsVolumeNfsExportsArgs']]):
        pulumi.set(self, "nfs_exports", value)

    @property
    @pulumi.getter(name="originSnapshot")
    def origin_snapshot(self) -> Optional[pulumi.Input['OpenZfsVolumeOriginSnapshotArgs']]:
        """
        The ARN of the source snapshot to create the volume from.
        """
        return pulumi.get(self, "origin_snapshot")

    @origin_snapshot.setter
    def origin_snapshot(self, value: Optional[pulumi.Input['OpenZfsVolumeOriginSnapshotArgs']]):
        pulumi.set(self, "origin_snapshot", value)

    @property
    @pulumi.getter(name="parentVolumeId")
    def parent_volume_id(self) -> Optional[pulumi.Input[str]]:
        """
        The volume id of volume that will be the parent volume for the volume being created, this could be the root volume created from the `fsx.OpenZfsFileSystem` resource with the `root_volume_id` or the `id` property of another `fsx.OpenZfsVolume`.
        """
        return pulumi.get(self, "parent_volume_id")

    @parent_volume_id.setter
    def parent_volume_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parent_volume_id", value)

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[pulumi.Input[bool]]:
        """
        specifies whether the volume is read-only. Default is false.
        """
        return pulumi.get(self, "read_only")

    @read_only.setter
    def read_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "read_only", value)

    @property
    @pulumi.getter(name="recordSizeKib")
    def record_size_kib(self) -> Optional[pulumi.Input[int]]:
        """
        The record size of an OpenZFS volume, in kibibytes (KiB). Valid values are `4`, `8`, `16`, `32`, `64`, `128`, `256`, `512`, or `1024` KiB. The default is `128` KiB.
        """
        return pulumi.get(self, "record_size_kib")

    @record_size_kib.setter
    def record_size_kib(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "record_size_kib", value)

    @property
    @pulumi.getter(name="storageCapacityQuotaGib")
    def storage_capacity_quota_gib(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum amount of storage in gibibytes (GiB) that the volume can use from its parent.
        """
        return pulumi.get(self, "storage_capacity_quota_gib")

    @storage_capacity_quota_gib.setter
    def storage_capacity_quota_gib(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "storage_capacity_quota_gib", value)

    @property
    @pulumi.getter(name="storageCapacityReservationGib")
    def storage_capacity_reservation_gib(self) -> Optional[pulumi.Input[int]]:
        """
        The amount of storage in gibibytes (GiB) to reserve from the parent volume.
        """
        return pulumi.get(self, "storage_capacity_reservation_gib")

    @storage_capacity_reservation_gib.setter
    def storage_capacity_reservation_gib(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "storage_capacity_reservation_gib", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags to assign to the file system. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter(name="userAndGroupQuotas")
    def user_and_group_quotas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OpenZfsVolumeUserAndGroupQuotaArgs']]]]:
        """
        Specify how much storage users or groups can use on the volume. Maximum of 100 items. See User and Group Quotas Below.
        """
        return pulumi.get(self, "user_and_group_quotas")

    @user_and_group_quotas.setter
    def user_and_group_quotas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OpenZfsVolumeUserAndGroupQuotaArgs']]]]):
        pulumi.set(self, "user_and_group_quotas", value)

    @property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "volume_type")

    @volume_type.setter
    def volume_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "volume_type", value)


class OpenZfsVolume(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 copy_tags_to_snapshots: Optional[pulumi.Input[bool]] = None,
                 data_compression_type: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 nfs_exports: Optional[pulumi.Input[pulumi.InputType['OpenZfsVolumeNfsExportsArgs']]] = None,
                 origin_snapshot: Optional[pulumi.Input[pulumi.InputType['OpenZfsVolumeOriginSnapshotArgs']]] = None,
                 parent_volume_id: Optional[pulumi.Input[str]] = None,
                 read_only: Optional[pulumi.Input[bool]] = None,
                 record_size_kib: Optional[pulumi.Input[int]] = None,
                 storage_capacity_quota_gib: Optional[pulumi.Input[int]] = None,
                 storage_capacity_reservation_gib: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 user_and_group_quotas: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['OpenZfsVolumeUserAndGroupQuotaArgs']]]]] = None,
                 volume_type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages an Amazon FSx for OpenZFS volume.
        See the [FSx OpenZFS User Guide](https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/what-is-fsx.html) for more information.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.fsx.OpenZfsVolume("test", parent_volume_id=aws_fsx_openzfs_file_system["test"]["root_volume_id"])
        ```

        ## Import

        Using `pulumi import`, import FSx Volumes using the `id`. For example:

        ```sh
         $ pulumi import aws:fsx/openZfsVolume:OpenZfsVolume example fsvol-543ab12b1ca672f33
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] copy_tags_to_snapshots: A boolean flag indicating whether tags for the file system should be copied to snapshots. The default value is false.
        :param pulumi.Input[str] data_compression_type: Method used to compress the data on the volume. Valid values are `NONE` or `ZSTD`. Child volumes that don't specify compression option will inherit from parent volume. This option on file system applies to the root volume.
        :param pulumi.Input[str] name: The name of the Volume. You can use a maximum of 203 alphanumeric characters, plus the underscore (_) special character.
        :param pulumi.Input[pulumi.InputType['OpenZfsVolumeNfsExportsArgs']] nfs_exports: NFS export configuration for the root volume. Exactly 1 item. See NFS Exports Below.
        :param pulumi.Input[pulumi.InputType['OpenZfsVolumeOriginSnapshotArgs']] origin_snapshot: The ARN of the source snapshot to create the volume from.
        :param pulumi.Input[str] parent_volume_id: The volume id of volume that will be the parent volume for the volume being created, this could be the root volume created from the `fsx.OpenZfsFileSystem` resource with the `root_volume_id` or the `id` property of another `fsx.OpenZfsVolume`.
        :param pulumi.Input[bool] read_only: specifies whether the volume is read-only. Default is false.
        :param pulumi.Input[int] record_size_kib: The record size of an OpenZFS volume, in kibibytes (KiB). Valid values are `4`, `8`, `16`, `32`, `64`, `128`, `256`, `512`, or `1024` KiB. The default is `128` KiB.
        :param pulumi.Input[int] storage_capacity_quota_gib: The maximum amount of storage in gibibytes (GiB) that the volume can use from its parent.
        :param pulumi.Input[int] storage_capacity_reservation_gib: The amount of storage in gibibytes (GiB) to reserve from the parent volume.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the file system. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['OpenZfsVolumeUserAndGroupQuotaArgs']]]] user_and_group_quotas: Specify how much storage users or groups can use on the volume. Maximum of 100 items. See User and Group Quotas Below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OpenZfsVolumeArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Amazon FSx for OpenZFS volume.
        See the [FSx OpenZFS User Guide](https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/what-is-fsx.html) for more information.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.fsx.OpenZfsVolume("test", parent_volume_id=aws_fsx_openzfs_file_system["test"]["root_volume_id"])
        ```

        ## Import

        Using `pulumi import`, import FSx Volumes using the `id`. For example:

        ```sh
         $ pulumi import aws:fsx/openZfsVolume:OpenZfsVolume example fsvol-543ab12b1ca672f33
        ```

        :param str resource_name: The name of the resource.
        :param OpenZfsVolumeArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OpenZfsVolumeArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 copy_tags_to_snapshots: Optional[pulumi.Input[bool]] = None,
                 data_compression_type: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 nfs_exports: Optional[pulumi.Input[pulumi.InputType['OpenZfsVolumeNfsExportsArgs']]] = None,
                 origin_snapshot: Optional[pulumi.Input[pulumi.InputType['OpenZfsVolumeOriginSnapshotArgs']]] = None,
                 parent_volume_id: Optional[pulumi.Input[str]] = None,
                 read_only: Optional[pulumi.Input[bool]] = None,
                 record_size_kib: Optional[pulumi.Input[int]] = None,
                 storage_capacity_quota_gib: Optional[pulumi.Input[int]] = None,
                 storage_capacity_reservation_gib: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 user_and_group_quotas: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['OpenZfsVolumeUserAndGroupQuotaArgs']]]]] = None,
                 volume_type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OpenZfsVolumeArgs.__new__(OpenZfsVolumeArgs)

            __props__.__dict__["copy_tags_to_snapshots"] = copy_tags_to_snapshots
            __props__.__dict__["data_compression_type"] = data_compression_type
            __props__.__dict__["name"] = name
            __props__.__dict__["nfs_exports"] = nfs_exports
            __props__.__dict__["origin_snapshot"] = origin_snapshot
            if parent_volume_id is None and not opts.urn:
                raise TypeError("Missing required property 'parent_volume_id'")
            __props__.__dict__["parent_volume_id"] = parent_volume_id
            __props__.__dict__["read_only"] = read_only
            __props__.__dict__["record_size_kib"] = record_size_kib
            __props__.__dict__["storage_capacity_quota_gib"] = storage_capacity_quota_gib
            __props__.__dict__["storage_capacity_reservation_gib"] = storage_capacity_reservation_gib
            __props__.__dict__["tags"] = tags
            __props__.__dict__["user_and_group_quotas"] = user_and_group_quotas
            __props__.__dict__["volume_type"] = volume_type
            __props__.__dict__["arn"] = None
            __props__.__dict__["tags_all"] = None
        super(OpenZfsVolume, __self__).__init__(
            'aws:fsx/openZfsVolume:OpenZfsVolume',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[str]] = None,
            copy_tags_to_snapshots: Optional[pulumi.Input[bool]] = None,
            data_compression_type: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            nfs_exports: Optional[pulumi.Input[pulumi.InputType['OpenZfsVolumeNfsExportsArgs']]] = None,
            origin_snapshot: Optional[pulumi.Input[pulumi.InputType['OpenZfsVolumeOriginSnapshotArgs']]] = None,
            parent_volume_id: Optional[pulumi.Input[str]] = None,
            read_only: Optional[pulumi.Input[bool]] = None,
            record_size_kib: Optional[pulumi.Input[int]] = None,
            storage_capacity_quota_gib: Optional[pulumi.Input[int]] = None,
            storage_capacity_reservation_gib: Optional[pulumi.Input[int]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            user_and_group_quotas: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['OpenZfsVolumeUserAndGroupQuotaArgs']]]]] = None,
            volume_type: Optional[pulumi.Input[str]] = None) -> 'OpenZfsVolume':
        """
        Get an existing OpenZfsVolume resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] arn: Amazon Resource Name of the file system.
        :param pulumi.Input[bool] copy_tags_to_snapshots: A boolean flag indicating whether tags for the file system should be copied to snapshots. The default value is false.
        :param pulumi.Input[str] data_compression_type: Method used to compress the data on the volume. Valid values are `NONE` or `ZSTD`. Child volumes that don't specify compression option will inherit from parent volume. This option on file system applies to the root volume.
        :param pulumi.Input[str] name: The name of the Volume. You can use a maximum of 203 alphanumeric characters, plus the underscore (_) special character.
        :param pulumi.Input[pulumi.InputType['OpenZfsVolumeNfsExportsArgs']] nfs_exports: NFS export configuration for the root volume. Exactly 1 item. See NFS Exports Below.
        :param pulumi.Input[pulumi.InputType['OpenZfsVolumeOriginSnapshotArgs']] origin_snapshot: The ARN of the source snapshot to create the volume from.
        :param pulumi.Input[str] parent_volume_id: The volume id of volume that will be the parent volume for the volume being created, this could be the root volume created from the `fsx.OpenZfsFileSystem` resource with the `root_volume_id` or the `id` property of another `fsx.OpenZfsVolume`.
        :param pulumi.Input[bool] read_only: specifies whether the volume is read-only. Default is false.
        :param pulumi.Input[int] record_size_kib: The record size of an OpenZFS volume, in kibibytes (KiB). Valid values are `4`, `8`, `16`, `32`, `64`, `128`, `256`, `512`, or `1024` KiB. The default is `128` KiB.
        :param pulumi.Input[int] storage_capacity_quota_gib: The maximum amount of storage in gibibytes (GiB) that the volume can use from its parent.
        :param pulumi.Input[int] storage_capacity_reservation_gib: The amount of storage in gibibytes (GiB) to reserve from the parent volume.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the file system. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['OpenZfsVolumeUserAndGroupQuotaArgs']]]] user_and_group_quotas: Specify how much storage users or groups can use on the volume. Maximum of 100 items. See User and Group Quotas Below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OpenZfsVolumeState.__new__(_OpenZfsVolumeState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["copy_tags_to_snapshots"] = copy_tags_to_snapshots
        __props__.__dict__["data_compression_type"] = data_compression_type
        __props__.__dict__["name"] = name
        __props__.__dict__["nfs_exports"] = nfs_exports
        __props__.__dict__["origin_snapshot"] = origin_snapshot
        __props__.__dict__["parent_volume_id"] = parent_volume_id
        __props__.__dict__["read_only"] = read_only
        __props__.__dict__["record_size_kib"] = record_size_kib
        __props__.__dict__["storage_capacity_quota_gib"] = storage_capacity_quota_gib
        __props__.__dict__["storage_capacity_reservation_gib"] = storage_capacity_reservation_gib
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["user_and_group_quotas"] = user_and_group_quotas
        __props__.__dict__["volume_type"] = volume_type
        return OpenZfsVolume(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        Amazon Resource Name of the file system.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="copyTagsToSnapshots")
    def copy_tags_to_snapshots(self) -> pulumi.Output[Optional[bool]]:
        """
        A boolean flag indicating whether tags for the file system should be copied to snapshots. The default value is false.
        """
        return pulumi.get(self, "copy_tags_to_snapshots")

    @property
    @pulumi.getter(name="dataCompressionType")
    def data_compression_type(self) -> pulumi.Output[Optional[str]]:
        """
        Method used to compress the data on the volume. Valid values are `NONE` or `ZSTD`. Child volumes that don't specify compression option will inherit from parent volume. This option on file system applies to the root volume.
        """
        return pulumi.get(self, "data_compression_type")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the Volume. You can use a maximum of 203 alphanumeric characters, plus the underscore (_) special character.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nfsExports")
    def nfs_exports(self) -> pulumi.Output[Optional['outputs.OpenZfsVolumeNfsExports']]:
        """
        NFS export configuration for the root volume. Exactly 1 item. See NFS Exports Below.
        """
        return pulumi.get(self, "nfs_exports")

    @property
    @pulumi.getter(name="originSnapshot")
    def origin_snapshot(self) -> pulumi.Output[Optional['outputs.OpenZfsVolumeOriginSnapshot']]:
        """
        The ARN of the source snapshot to create the volume from.
        """
        return pulumi.get(self, "origin_snapshot")

    @property
    @pulumi.getter(name="parentVolumeId")
    def parent_volume_id(self) -> pulumi.Output[str]:
        """
        The volume id of volume that will be the parent volume for the volume being created, this could be the root volume created from the `fsx.OpenZfsFileSystem` resource with the `root_volume_id` or the `id` property of another `fsx.OpenZfsVolume`.
        """
        return pulumi.get(self, "parent_volume_id")

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> pulumi.Output[bool]:
        """
        specifies whether the volume is read-only. Default is false.
        """
        return pulumi.get(self, "read_only")

    @property
    @pulumi.getter(name="recordSizeKib")
    def record_size_kib(self) -> pulumi.Output[Optional[int]]:
        """
        The record size of an OpenZFS volume, in kibibytes (KiB). Valid values are `4`, `8`, `16`, `32`, `64`, `128`, `256`, `512`, or `1024` KiB. The default is `128` KiB.
        """
        return pulumi.get(self, "record_size_kib")

    @property
    @pulumi.getter(name="storageCapacityQuotaGib")
    def storage_capacity_quota_gib(self) -> pulumi.Output[int]:
        """
        The maximum amount of storage in gibibytes (GiB) that the volume can use from its parent.
        """
        return pulumi.get(self, "storage_capacity_quota_gib")

    @property
    @pulumi.getter(name="storageCapacityReservationGib")
    def storage_capacity_reservation_gib(self) -> pulumi.Output[int]:
        """
        The amount of storage in gibibytes (GiB) to reserve from the parent volume.
        """
        return pulumi.get(self, "storage_capacity_reservation_gib")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        A map of tags to assign to the file system. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter(name="userAndGroupQuotas")
    def user_and_group_quotas(self) -> pulumi.Output[Sequence['outputs.OpenZfsVolumeUserAndGroupQuota']]:
        """
        Specify how much storage users or groups can use on the volume. Maximum of 100 items. See User and Group Quotas Below.
        """
        return pulumi.get(self, "user_and_group_quotas")

    @property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "volume_type")

